function selectNav(obj) {
    $('#parent_id').val($(obj).val());
    $('#topid').val($(obj).find("option:selected").attr('data-topid'));
}

// 选择链接
function menusHeaderLink(obj) {
    // 打开选择链接
    selectMenusHeaderLink(obj, function(result) {
        $('#host_id').val(result.host_id);
        $('#link_id').val(result.link_id);
        $('#link_names').text(result.link_names);
    });
}

// 选择链接
function selectMenusHeaderLink(obj, func_callback) {
    var ad_host_id = $(obj).data('ad_host_id') || 1;
    var ad_link_id = $(obj).data('ad_link_id') || 0;
    var url = eyou_basefile + "?m=admin&c=Decoration&a=link&link_type=3";
    if (parseInt(ad_host_id) > 0) url += "&ad_host_id=" + parseInt(ad_host_id);
    if (parseInt(ad_link_id) > 0) url += "&ad_link_id=" + parseInt(ad_link_id);
    layer.open({
        id: 'manual_select_course',
        type: 2,
        title: '选择链接',
        fixed: true,
        shadeClose: false,
        shade: layer_shade,
        maxmin: false,
        btn: ['确定', '关闭'],
        area: ['1200px', '80%'],
        closeBtn: 3,
        content: url,
        yes: function(index, layero) {
            // 选择的链接信息
            var body = layer.getChildFrame('body', index);
            var link_id = body.find('#link_id').val();
            var link_names = body.find('#link_names').val();
            var link_jsondata = body.find('#link_jsondata').val();
            link_jsondata = $.parseJSON(link_jsondata);
            if (parseInt(link_id) > 0) {
                link_jsondata.link_id = link_id;
                link_jsondata.link_names = link_names;
                func_callback(link_jsondata);
                layer.closeAll();
            }
        }
    });
}

// 判断输入框是否为空
function submitForm(submitFormID) {
    if ($('#nav_name').val() == '') {
        showErrorMsg('请填写菜单名称');
        $('#nav_name').focus();
        return false;
    } 
    else if (!$('#host_id').val() || !$('#link_id').val()) {
        showErrorMsg('请设置跳转链接', 500, function() {
            $('#menusHeaderLink').click();
        });
        return false;
    }
    layer_loading('正在处理');
    $.ajax({
        type: 'post',
        url : submitFormUrl,
        data: $(submitFormID).serialize(),
        dataType: 'json',
        success: function(res) {
            layer.closeAll();
            if (1 === parseInt(res.code)) {
                var _parent = parent;
                _parent.layer.closeAll();
                _parent.showSuccessMsg(res.msg, 1000, function() {
                    _parent.window.location.reload();
                });
            } else {
                showErrorAlert(res.msg);
            }
        },
        error: function(e) {
            layer.closeAll();
            showErrorAlert(e.responseText);
        }
    });
}