$(function() {
    // 新增时，广告类型默认选中图片类型
    $('#type' + selectedType).prop('checked', 'checked');
    // 新增时，默认显示图片上传
    $('#1615775137_' + selectedType).show();
    // 多媒体类型 && 广告内容不为空 则执行显示 否则 执行隐藏
    videoLitpicValue('#video_litpic');
});

// 切换广告类型
function typeSwitch(typeValue) {
    // 隐藏全部类型内容
    $('.1615775137_dl').hide();
    // 显示指定类型内容
    $('#1615775137_'+typeValue).show();
    // 切换类型后设置为当前切换的类型
    selectedType = typeValue;
    // 多媒体类型 && 广告内容不为空 则执行显示 否则 执行隐藏
    videoLitpicValue('#video_litpic');
}

// 多媒体类型
function videoLitpicValue(obj) {
    // 获取广告内容(多媒体为播放链接)
    // var video_litpic = $(obj).val();
    // 判断隐藏/显示预览按钮if (2 == selectedType && video_litpic)
    if (2 === parseInt(selectedType)) {
        $('#previewVideo').show();
    } else {
        $('#previewVideo').hide();
    }
}

// 上传媒体文件
function videoUploadLitpic(e) {
    var data_type = $(e).attr('data-type');
    if ('qiniu' == data_type) {
        // 七牛云上传
        showErrorAlert('暂不支持七牛云上传视频');
    } else if ('oss' == data_type) {
        // OSS上传
        showErrorAlert('暂不支持OSS上传视频');
    } else if ('cos' == data_type) {
        // COS上传
        showErrorAlert('暂不支持COS上传视频');
    } else {
        // 本地上传
        videoUploadLitpicLocal(e);
    }
}

// 本地上传
function videoUploadLitpicLocal(e) {
    // 获取文件路径名
    var file = $(e)[0].files[0];

    // 验证上传格式
    var fileName = file.name;
    var fileExt = fileName.substr(fileName.lastIndexOf('.')).toLowerCase();
    var ext = judgeExt(fileExt);
    if (ext == -1) {
        showErrorMsg('不支持的视频格式，可在附件设置中修改');
        return false;
    }

    // 验证上传大小
    if (file.size > uploadMaxFilesize) {
        showErrorMsg('视频大小超过限制，可在附件设置中修改');
        return false;
    }

    // 定义上传数据
    var formData = new FormData();
    formData.append('file', file);

    // 执行上传
    layer_loading('上传本地');
    $.ajax({
        type: 'post',
        url : upVideo,
        data: formData,
        contentType: false,
        processData: false,
        dataType: 'json',
        xhr: function () {
            myXhr = $.ajaxSettings.xhr();
            if (myXhr.upload) {
                myXhr.upload.addEventListener('progress', function(e){
                    var curr = e.loaded;
                    var total = e.total;
                    process = parseInt(curr / total * 100);
                    $("#videoUploadLitpicLocal").html('上传中...'+process+"%");
                });
            }
            return myXhr;
        },
        success: function (res) {
            layer.closeAll();
            $("#videoUploadLitpicLocal").html('上传成功');
            setTimeout(function() {
                $('#videoUploadLitpicLocal').html('本地上传');
            }, 2000);
            if ("SUCCESS" == res.state) {
                $("#video_litpic").val(res.url);
            } else {
                showErrorMsg(res.msg);
            }
        }
    });
}

// 打开预览视频
function openPreviewVideo() {
    // 获取视频链接
    var video_litpic = $('#video_litpic').val();
    if (video_litpic == '') {
        $('#video_litpic').focus();
        showErrorMsg('请先上传视频');
        return false;
    }

    // 视频链接后缀验证处理 
    var fileExt = video_litpic.substr(video_litpic.lastIndexOf('.')).toLowerCase();
    var fileExt = judgeExt(fileExt);
    if (fileExt == -1) {
        $('#video_litpic').focus();
        showErrorMsg('不支持的视频格式，可在附件设置中修改');
        return false;
    }

    // 视频链接是否存在斜杠处理 
    var fileInfo = video_litpic.lastIndexOf('/');
    if (fileInfo == -1) {
        $('#video_litpic').focus();
        showErrorMsg('视频链接不完整，无法正常预览');
        return false;
    }

    // 打开视频播放
    $.ajax({
        type : 'post',
        url  : open_preview_video,
        data : {video_litpic: video_litpic},
        dataType : 'json',
        success : function(res) {
            if (1 === parseInt(res.code) && res.url) {
                layer.open({
                    type: 1,
                    title: false,
                    fixed: true, //不固定
                    shadeClose: false,
                    shade: layer_shade,
                    area: ['80%', '80%'],
                    content: "<video style='width:100%; height:100%;' src='"+res.url+"' controls preload='auto' oncontextmenu='return fase' autoplay></video>"
                });
            } else {
                showErrorMsg(res.msg);
            }
        },
        error: function(e) {
            showErrorAlert(e.responseText);
        }
    });
}

// 验证格式
function judgeExt(ext) {
    var extArr = [];
    extArr = mediaType.split("|");
    var ext = ext.replace(".","");
    return extArr.indexOf(ext);
}

// 勾选新窗口打开链接
function checkedTarget(obj) {
    if ($(obj).is(':checked')) {
        $(obj).parent().find('input[name="img_target[]"]').val(1);
    } else {
        $(obj).parent().find('input[name="img_target[]"]').val(0);
    }
}

// 鼠标事件，加载查看大图和更新图片
function upimgMouseover(obj) {
    $(obj).find('div.icaction').show();
    $(obj).find('div.cover-bg').show();
}

function upimgMouseout(obj) {
    $(obj).find('div.icaction').hide();
    $(obj).find('div.cover-bg').hide();
}

// 检测广告名称是否存在重复
function detectionTitleRepeat(obj) {
    // 执行检测
    $.ajax({
        type: 'post',
        url : detection_title_repeat,
        data: {id: $(obj).data('id'), title: $(obj).val()},
        dataType: 'json',
        success: function(res) {
            if (0 === parseInt(res.code)) {
                $('#title_tips').show().html(res.msg);
            } else {
                $('#title_tips').hide().html('');
            }
        },
        error: function(e) {
            layer.closeAll();
            showErrorAlert(e.responseText);
        }
    });
}

// 上传图集相册回调函数
function imgupload_call_back(paths) {
    var last_div = $(".images_upload_tpl").html();
    var inputs   = $('.span_input input');
    var timestamp = 0;

    // 图片数据处理
    for (var i=0; i<paths.length; i++) {
        // 生成新的时间戳
        timestamp = (new Date()).getTime();
        // 插入一个 新图片
        $(".images_upload:eq(0)").before(last_div);
        // 处理他的链接地址
        $(".images_upload:eq(0)").find('span:eq(0)').attr('onclick', "Images('"+paths[i]+"', 900, 600);");
        // 处理信息显示隐藏按钮
        $(".images_upload:eq(0)").find('span:eq(1)').attr('onclick', "showInput('"+timestamp+"');");
        // 处理他的图片路径
        $(".images_upload:eq(0)").find('img').attr('src', paths[i]);
        // 处理删除按钮
        $(".images_upload:eq(0)").find('a:eq(1)').attr('onclick', "clearPicArr(this, '"+paths[i]+"', 0);");
        // 处理图片信息框ID
        $(".images_upload:eq(0)").find('.load_input:eq(0)').attr('id', timestamp+'_ShowInput');
        
        // 处理图片路径及隐藏域
        if (inputs.length > 0) {
            // 修改隐藏域
            $(".images_upload:eq(0)").find('input:eq(0)').attr('name', 'img_id[]').attr('value', '');
            $(".span_input:eq(0)").find('input:eq(0)').attr('name', 'img_litpic[]').attr('value', paths[i]);
            // 处理标题
            $(".images_upload:eq(0)").find('textarea:eq(0)').attr('name', 'img_title[]');
            // 处理跳转链接
            $(".images_upload:eq(0)").find('textarea:eq(1)').attr('name', 'img_links[]');
            // 处理内容描述
            $(".images_upload:eq(0)").find('textarea:eq(2)').attr('name', 'img_intro[]');
            // 处理新窗口选项
            $(".images_upload:eq(0)").find('div.operation a:eq(0)').html("<label><input type='checkbox' title='在新窗口打开' onclick='checkedTarget(this);'/>新窗口<input type='hidden' name='img_target[]' value='0'></label>");
            // 处理收回按钮
            $(".images_upload:eq(0)").find('div.operation a:eq(2)').attr('onclick', "showInput('"+timestamp+"');").attr('title', "收回").html('<i style="font-size:16px;" class="fa fa-angle-double-up"></i>');
        }
    }
}

// 显示信息输入框
function showInput(id) {
    var obj = $("#"+id+"_ShowInput");
    var showOrHide = obj.attr('data-showOrHide');
    if ('hide' == showOrHide) {
        obj.show().attr('data-showOrHide', 'show');
    } else {
        obj.hide().attr('data-showOrHide', 'hide');
    }
}

// 上传之后删除组图input
function clearPicArr(obj, path, id) {
    if (0 < parseInt(id)) {
        // 删除数据库记录
        $.ajax({
            type: 'POST',
            url : del_imgupload,
            data: {del_id: id, _ajax: 1},
            success: function() {
                $(obj).parent().parent().parent().remove();
            }
        });
    } else {
        $(obj).parent().parent().parent().remove();
    }
}

// 图集相册的拖动排序相关 js
$(".sort-list").sortable({
    start: function( event, ui) {},
    stop: function( event, ui ) {}
});

// 获取点击更新图片的ID并加载隐藏域
function loadImagesId(id) {
    // 加载ID到隐藏域
    $('#ImagesId').val(id);
    // 调用图片上传JS
    GetUploadify(1, '', 'allimg', 'UpdataImages');
}

// 更新图片
function UpdataImages(path){
    // 获取点击的ID
    var id = $('#ImagesId').val();
    // 加载图片到显示层
    $("#"+id+"_Id").attr('src', path);
    // 加载图片到提交的隐藏域
    $("#"+id+"_Litpic").val(path);
}

// 判断输入框是否为空
function submitForm(submitFormID) {
    if ($('#title').val() == '') {
        showErrorMsg('请输入广告位名称');
        return false;
    }
    layer_loading('正在处理');
    $.ajax({
        url : submitFormUrl,
        type: 'post',
        data: $(submitFormID).serialize(),
        dataType: 'json',
        success: function(res) {
            layer.closeAll();
            if (1 === parseInt(res.code)) {
                var _parent = parent;
                _parent.layer.closeAll();
                _parent.showSuccessMsg(res.msg, 1000, function() {
                    _parent.window.location.reload();
                });
            } else {
                showErrorAlert(res.msg);
            }
        },
        error: function(e) {
            layer.closeAll();
            showErrorAlert(e.responseText);
        }
    });
}