-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Host           : 127.0.0.1:3306
-- Database       : dd36
-- 
-- Part : #1
-- Version : #v1.3.0
-- Date : 2024-10-09 11:13:55
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COMMENT='广告表';

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240723/1-240H310595A23.jpg', '0', '0', '', '', '', '', '0', '', '1', '3', '1', '1', '0', '1719994048', '1721703630');
INSERT INTO `ey_ad` VALUES ('20', '1', '1', '', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240723/1-240H31100161J.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', '1721703630', '1721703630');
INSERT INTO `ey_ad` VALUES ('10', '4', '1', '', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240724/1-240H40Z53Lc.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '1', '1', '0', '1719998618', '1721790231');
INSERT INTO `ey_ad` VALUES ('9', '4', '1', '', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240724/1-240H40Z529D5.png', '0', '0', '', '', '', '', '0', '', '1', '1', '1', '1', '0', '1719998618', '1721790231');
INSERT INTO `ey_ad` VALUES ('11', '4', '1', '', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240724/1-240H40Z54CE.png', '0', '0', '', '', '', '', '0', '', '1', '3', '1', '1', '0', '1719998618', '1721790231');
INSERT INTO `ey_ad` VALUES ('19', '9', '1', '横栏广告一', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240718/1-240GQ0311aJ.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '1', '1', '0', '1720148734', '1721269883');
INSERT INTO `ey_ad` VALUES ('21', '1', '1', '', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240723/1-240H311001B35.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', '1721703630', '1721703630');

-- -----------------------------
-- Table structure for `ey_ad_link`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_link`;
CREATE TABLE `ey_ad_link` (
  `link_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `host_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告链接主体ID',
  `host_title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告链接主体标题',
  `link_names` varchar(60) NOT NULL DEFAULT '' COMMENT '广告链接名称',
  `link_pahts` varchar(60) NOT NULL DEFAULT '' COMMENT '广告链接路径 (小程序)',
  `link_url` varchar(150) NOT NULL DEFAULT '' COMMENT '广告链接URL (H5)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态 (1:启用; 2:禁用;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COMMENT='广告链接表';

-- -----------------------------
-- Records of `ey_ad_link`
-- -----------------------------
INSERT INTO `ey_ad_link` VALUES ('1', '1', '基础链接', '主页', '/pages/index/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('2', '1', '基础链接', '购物车', '/pages/flow/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('3', '1', '基础链接', '商品分类', '/pages/classify/classify', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('4', '2', '会员中心', '会员中心', '/pages/user/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('5', '2', '会员中心', '全部订单', '/pages/order/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('6', '2', '会员中心', '待付款订单', '/pages/order/index?type=payment', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('7', '2', '会员中心', '待发货订单', '/pages/order/index?type=delivery', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('8', '2', '会员中心', '待收货订单', '/pages/order/index?type=received', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('9', '2', '会员中心', '待评价订单', '/pages/order/index?type=complete', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('10', '2', '会员中心', '售后订单', '/pages/service/order/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('11', '2', '会员中心', '我的余额', '/pages/user/wallet/wallet', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('12', '2', '会员中心', '我的积分', '/pages/user/point/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('16', '2', '会员中心', '我的收藏', '/pages/user/collect/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('17', '2', '会员中心', '个人资料', '/pages/user/edit/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('18', '2', '会员中心', '收货地址', '/pages/address/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('19', '2', '会员中心', '优惠券', '/pages/user/coupon/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('20', '3', '商品列表', '商品列表', '', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('21', '4', '分类管理', '分类管理', '', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('22', '1', '基础链接', '优惠券列表', '/pages/coupon/index', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('23', '1', '基础链接', '积分商城', '/pages/user/integral/pointMall', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('24', '1', '基础链接', '今日爆款', '/pages/product/list?orderway=desc&orderby=total_sales_num', '', '100', '1', '0', '0');
INSERT INTO `ey_ad_link` VALUES ('25', '1', '基础链接', '帮助中心', '/pages/help/list', '', '100', '1', '0', '0');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告展示类型，1图片类型，2媒体类型，3HTML代码',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `intro` text NOT NULL COMMENT '广告描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0关闭1开启',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', '图片广告', '1', '0', '0', '', '1', '1', '0', '1719994048', '1721703630');
INSERT INTO `ey_ad_position` VALUES ('4', '推荐', '1', '0', '0', '', '1', '1', '0', '1719998618', '1721790231');
INSERT INTO `ey_ad_position` VALUES ('9', '首页横栏广告', '1', '0', '0', '', '1', '1', '0', '1720148734', '1721269883');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `pwd_lenth` smallint(5) DEFAULT '0',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) DEFAULT '0' COMMENT '同步注册到会员表',
  `desc` varchar(500) DEFAULT '' COMMENT '工作内容',
  `wechat_appid` varchar(50) DEFAULT '' COMMENT '公众号appid',
  `wechat_followed` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '记录是否关注了微信公众号，默认0；0=未关注、1=已关注',
  `wechat_open_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'open_id，关注微信公众号后存入',
  `union_id` varchar(50) DEFAULT '' COMMENT '微信用户的unionId',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='管理员表';

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '$2y$11$f9f3871eb36b3e26f259fu6Qqsftd7C.RTntDQ0m1sYPCzmeq8ozi', '0', '', '1728437218', '127.0.0.1', '2', 'um7g350me4oopklba609b5amsv', '0', '-1', '1', '0', '', '', '0', '', '', '1728437199', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='管理员操作日志表';

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('1', '1', '后台登录', '127.0.0.1', '/login.php', '1727333138');
INSERT INTO `ey_admin_log` VALUES ('2', '1', '后台登录', '127.0.0.1', '/login.php', '1727333233');
INSERT INTO `ey_admin_log` VALUES ('3', '1', '后台登录', '127.0.0.1', '/login.php', '1727396875');
INSERT INTO `ey_admin_log` VALUES ('4', '1', '后台登录', '127.0.0.1', '/login.php', '1727419326');
INSERT INTO `ey_admin_log` VALUES ('5', '1', '后台登录', '127.0.0.1', '/login.php', '1727419369');
INSERT INTO `ey_admin_log` VALUES ('6', '1', '后台登录', '127.0.0.1', '/login.php', '1728437218');
INSERT INTO `ey_admin_log` VALUES ('7', '1', '备份数据库', '127.0.0.1', '/login.php', '1728441706');
INSERT INTO `ey_admin_log` VALUES ('8', '1', '删除数据库备份文件', '127.0.0.1', '/login.php', '1728443631');

-- -----------------------------
-- Table structure for `ey_admin_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_menu`;
CREATE TABLE `ey_admin_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT '0',
  `title` varchar(100) DEFAULT '' COMMENT '导航名称',
  `controller_name` varchar(50) DEFAULT '' COMMENT '控制器',
  `action_name` varchar(50) DEFAULT '' COMMENT '方法名',
  `param` varchar(255) DEFAULT '' COMMENT '参数',
  `icon` varchar(50) DEFAULT 'iconfont e-lanmuguanli' COMMENT '图标',
  `is_menu` tinyint(1) DEFAULT '0' COMMENT '是否显示为左侧菜单',
  `is_switch` tinyint(1) DEFAULT '0' COMMENT '是否显示在switch_map页面中',
  `target` varchar(50) DEFAULT 'workspace' COMMENT '链接打开方式',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `menu_id` (`menu_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COMMENT='外挂功能地图菜单表';

-- -----------------------------
-- Records of `ey_admin_menu`
-- -----------------------------
INSERT INTO `ey_admin_menu` VALUES ('1', '1005', '首页', 'Index', 'welcome', '', 'iconfont e-zhuye', '1', '1', 'workspace', '0', '1', '1650263716', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('6', '2001', '设置', 'System', 'web', '', 'iconfont e-shezhi', '1', '1', 'workspace', '7', '1', '1650263716', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('9', '2004', '功能', 'Index', 'switch_map', '', 'iconfont e-caidangongneng', '1', '0', 'workspace', '10000', '0', '1650263716', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('10', '2005', '应用', 'Weapp', 'index', '', 'iconfont e-chajian', '1', '1', 'workspace', '7', '1', '1650263716', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('11', '2006', '会员', 'Member', 'users_index', '', 'iconfont e-gerenzhongxin', '1', '1', 'workspace', '4', '1', '1650263716', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('15', '2004021', '订单', 'Order', 'index', '', 'iconfont e-dingdanguanli', '1', '1', 'workspace', '2', '1', '1711089186', '1711089186');
INSERT INTO `ey_admin_menu` VALUES ('16', '2004023', '渠道', 'Canal', 'index', '', 'iconfont e-qudaofenxi', '1', '1', 'workspace', '6', '1', '1711090501', '1714006106');
INSERT INTO `ey_admin_menu` VALUES ('18', '2008', '商品', 'ShopProduct', 'index', '', 'iconfont e-shangpinguanli ', '1', '1', 'workspace', '1', '1', '1712995229', '1712995229');

-- -----------------------------
-- Table structure for `ey_admin_theme`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_theme`;
CREATE TABLE `ey_admin_theme` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `theme_type` tinyint(1) DEFAULT '0' COMMENT '主题类型：1=登录页，2=欢迎页',
  `theme_title` varchar(50) DEFAULT '' COMMENT '主题标题',
  `theme_pic` varchar(255) DEFAULT '' COMMENT '主题效果图',
  `theme_color_model` varchar(10) DEFAULT '' COMMENT '主题颜色模式',
  `theme_main_color` varchar(20) DEFAULT '' COMMENT '主题主色',
  `theme_assist_color` varchar(20) DEFAULT '' COMMENT '主题辅色',
  `theme_css_tplname` varchar(100) DEFAULT '' COMMENT '主题风格样式自定义文件',
  `login_logo` varchar(255) DEFAULT '' COMMENT '登录图标',
  `login_bgimg_model` varchar(10) DEFAULT '' COMMENT '登录背景图模式',
  `login_bgimg` varchar(255) DEFAULT '' COMMENT '登录背景图',
  `login_tplname` varchar(100) DEFAULT '' COMMENT '登录页自定义模板',
  `admin_logo` varchar(255) DEFAULT '' COMMENT '后台Logo',
  `welcome_tplname` varchar(100) DEFAULT '' COMMENT '欢迎页自定义模板',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '内置主题',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`theme_id`)
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8 COMMENT='后台主题风格表';

-- -----------------------------
-- Records of `ey_admin_theme`
-- -----------------------------
INSERT INTO `ey_admin_theme` VALUES ('1', '1', '经典蓝主题', '/public/static/admin/images/theme/theme_pic_1.png', '1', '#3398cc', '#2189be', 'css_1.css', '/public/static/admin/login/login-logo_ey.png', '1', '/public/static/admin/loginbg/login-bg-1.png', '', '/public/static/admin/logo/logo_ey.png', '', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('2', '1', '易优橙主题', '/public/static/admin/images/theme/theme_pic_2.png', 'custom', '#197971', '#fa921b', 'css_2.css', '/public/static/admin/login/login-logo.png', '2', '/public/static/admin/loginbg/login-bg-1.png', '', '/public/static/admin/logo/logo.png', '', '1', '100', '1681866512', '1681866512');
INSERT INTO `ey_admin_theme` VALUES ('4', '2', '商城欢迎页', '/public/static/admin/images/theme/theme_pic_4.png', '', '', '', '', '', '', '', '', '', 'welcome_shop.htm', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('5', '2', '任务流欢迎页', '/public/static/admin/images/theme/theme_pic_5.png', '', '', '', '', '', '', '', '', '', 'welcome_taskflow.htm', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('3', '2', '默认欢迎页', '/public/static/admin/images/theme/theme_pic_default.png', '', '', '', '', '', '', '', '', '', '', '1', '100', '1681200988', '1681200988');

-- -----------------------------
-- Table structure for `ey_admin_wxlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_wxlogin`;
CREATE TABLE `ey_admin_wxlogin` (
  `wx_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=官方公众号，2=微信应用，3=自有公众号',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(50) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `unionid` varchar(200) NOT NULL DEFAULT '' COMMENT 'unionid',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wx_id`),
  KEY `openid` (`openid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='后台微信登录记录表';


-- -----------------------------
-- Table structure for `ey_applets_ad_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_applets_ad_content`;
CREATE TABLE `ey_applets_ad_content` (
  `content_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告内容ID',
  `position_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位ID',
  `host_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告链接分组ID',
  `link_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '内置商城链接ID or 系统商品分类ID or 系统商品ID',
  `content_type` tinyint(1) DEFAULT '1' COMMENT '广告内容类型(1:图片类型)',
  `content_title` varchar(100) DEFAULT '' COMMENT '广告内容名称',
  `content_images` varchar(255) DEFAULT '' COMMENT '广告内容图片地址',
  `content_intro` text COMMENT '广告内容描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`content_id`),
  KEY `position_id` (`position_id`) USING BTREE,
  KEY `link_id` (`link_id`) USING BTREE,
  KEY `host_id` (`host_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COMMENT='小程序插件-广告内容';

-- -----------------------------
-- Records of `ey_applets_ad_content`
-- -----------------------------
INSERT INTO `ey_applets_ad_content` VALUES ('47', '2', '4', '1', '1', '今日推荐', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K04F.png', '', '2', '1719367858', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('43', '3', '1', '1', '1', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240808/1-240PQ0093NB.jpg', '', '1', '1715562822', '1723082988');
INSERT INTO `ey_applets_ad_content` VALUES ('45', '2', '4', '2', '1', '镇店爆款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K0208.png', '', '1', '1719365563', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('46', '2', '4', '3', '1', '满减专区', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K1125.png', '', '3', '1719367840', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('57', '2', '1', '1', '1', '休闲零食', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K1H1.png', '', '6', '1722929952', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('48', '2', '4', '4', '1', '新品尝鲜', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K15T.png', '', '4', '1719367858', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('61', '2', '1', '1', '1', '签到中心', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K0160.png', '', '10', '1722929952', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('55', '2', '1', '1', '1', '领券中心', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K1Z6.png', '', '5', '1721783802', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('60', '2', '1', '1', '1', '烘培蛋糕', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K1444.png', '', '9', '1722929952', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('62', '3', '1', '1', '1', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240808/1-240PQ0094W18.jpg', '', '2', '1723082988', '1723082988');
INSERT INTO `ey_applets_ad_content` VALUES ('58', '2', '1', '1', '1', '酒水饮品', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K1C1.png', '', '7', '1722929952', '1722930058');
INSERT INTO `ey_applets_ad_content` VALUES ('59', '2', '1', '1', '1', '坚果炒货', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6153K1X5.png', '', '8', '1722929952', '1722930058');

-- -----------------------------
-- Table structure for `ey_applets_ad_link`
-- -----------------------------
DROP TABLE IF EXISTS `ey_applets_ad_link`;
CREATE TABLE `ey_applets_ad_link` (
  `link_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `host_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告链接主体ID',
  `host_title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告链接主体标题',
  `link_names` varchar(60) NOT NULL DEFAULT '' COMMENT '广告链接名称',
  `link_paths` varchar(60) NOT NULL DEFAULT '' COMMENT '广告链接路径',
  `link_url` varchar(150) DEFAULT '' COMMENT 'h5端URL',
  `link_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '链接类型(1:公用; 2:仅小程序、H5; 3:仅PC;)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用; 2:禁用)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='小程序插件-广告链接';

-- -----------------------------
-- Records of `ey_applets_ad_link`
-- -----------------------------
INSERT INTO `ey_applets_ad_link` VALUES ('1', '1', '基础链接', '主页', '/pages/index/index', '/', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('2', '1', '基础链接', '购物车', '/pages/cart/cart', '/cart', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('3', '1', '基础链接', '商品分类', '/pages/category/category', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('4', '1', '基础链接', '领券中心', '/otherpages/mall/coupon/index', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('5', '1', '基础链接', '积分商城', '/otherpages/points_shop/index', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('6', '2', '会员中心', '会员中心', '/pages/user/user', '/user/index', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('7', '2', '会员中心', '全部订单', '/otherpages/mall/order/index', '/user/Shop/shop_centre.html', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('8', '2', '会员中心', '待付款订单', '/otherpages/mall/order/index?type=payment', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('9', '2', '会员中心', '待发货订单', '/otherpages/mall/order/index?type=delivery', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('10', '2', '会员中心', '待收货订单', '/otherpages/mall/order/index?type=received', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('11', '2', '会员中心', '已完成订单', '/otherpages/mall/order/index?type=complete', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('12', '2', '会员中心', '退款订单', '/otherpages/mall/order/service/index', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('13', '2', '会员中心', '个人资料', '/otherpages/user/edit/index', '/user/Users/info.html', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('14', '2', '会员中心', '我的余额', '/otherpages/user/wallet/withdrawal/index', '/user/Pay/pay_consumer_details.html', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('15', '2', '会员中心', '我的积分', '/otherpages/user/pointsDetail', '/user/Users/score_index.html', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('16', '2', '会员中心', '我的优惠券', '/otherpages/user/coupon/index', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('17', '2', '会员中心', '收货地址', '/otherpages/mall/address/index', '/user/Shop/shop_address_list.html', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('18', '3', '商品列表', '商品列表', '', '', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('19', '4', '分类管理', '分类管理', '', '', '1', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('20', '2', '会员等级', '会员等级', '/otherpages/user/upgradeMember/upgradeMember', '', '2', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('21', '1', '基础链接', '我的收藏', '', '/user/Users/collection_index.html', '3', '100', '1', '0', '0');
INSERT INTO `ey_applets_ad_link` VALUES ('22', '1', '基础链接', '全部商品', 'pages/category/list', '/goods_all', '1', '100', '1', '0', '0');

-- -----------------------------
-- Table structure for `ey_applets_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_applets_ad_position`;
CREATE TABLE `ey_applets_ad_position` (
  `position_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告位ID',
  `position_title` varchar(100) NOT NULL DEFAULT '' COMMENT '广告位名称',
  `position_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告位类型(1:图片类型)',
  `position_intro` text NOT NULL COMMENT '广告位描述',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否系统广告位(0:否; 1:是)',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告位状态(0:关闭; 1:开启)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`position_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='小程序插件-广告位';

-- -----------------------------
-- Records of `ey_applets_ad_position`
-- -----------------------------
INSERT INTO `ey_applets_ad_position` VALUES ('1', '幻灯片', '1', '', '1', '1', '1700789503', '1707039720');
INSERT INTO `ey_applets_ad_position` VALUES ('2', '金刚位', '1', '', '1', '1', '1700789503', '1700789503');
INSERT INTO `ey_applets_ad_position` VALUES ('3', 'banner', '1', '', '1', '1', '1700789503', '1700789503');

-- -----------------------------
-- Table structure for `ey_applets_bottom_nav`
-- -----------------------------
DROP TABLE IF EXISTS `ey_applets_bottom_nav`;
CREATE TABLE `ey_applets_bottom_nav` (
  `nav_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `host_id` int(11) unsigned DEFAULT '0' COMMENT '广告链接分组ID',
  `link_id` int(11) unsigned DEFAULT '0' COMMENT '内置商城链接ID or 系统商品分类ID or 系统商品ID',
  `nav_title` varchar(100) DEFAULT '' COMMENT '导航标题',
  `default_pic` varchar(100) DEFAULT '' COMMENT '默认图标',
  `selected_pic` varchar(100) DEFAULT '' COMMENT '选中图标',
  `sort_order` int(10) unsigned DEFAULT '100' COMMENT '排序',
  `system` tinyint(1) unsigned DEFAULT '0' COMMENT '是否系统默认导航(0:否; 1:是)',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1:启用; 2:禁用)',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nav_id`),
  KEY `host_id` (`host_id`) USING BTREE,
  KEY `link_id` (`link_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='小程序插件-底部导航';

-- -----------------------------
-- Records of `ey_applets_bottom_nav`
-- -----------------------------
INSERT INTO `ey_applets_bottom_nav` VALUES ('1', '1', '3', '分类', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406240UI1T0.png', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406240UHA94.png', '2', '0', '1', '1714291785', '1723083002');
INSERT INTO `ey_applets_bottom_nav` VALUES ('2', '1', '1', '首页', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406240U639253.png', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240808/1-240PQ01001128.png', '1', '0', '1', '1714291785', '1723083002');
INSERT INTO `ey_applets_bottom_nav` VALUES ('25', '1', '2', '购物车', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406240U644135.png', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615311N93.png', '3', '0', '1', '1719190654', '1723083002');
INSERT INTO `ey_applets_bottom_nav` VALUES ('26', '2', '6', '我的', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406240UG0449.png', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406240U5555P.png', '4', '0', '1', '1719190654', '1723083002');

-- -----------------------------
-- Table structure for `ey_applets_page_paths`
-- -----------------------------
DROP TABLE IF EXISTS `ey_applets_page_paths`;
CREATE TABLE `ey_applets_page_paths` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '页面路径标题',
  `paths` varchar(100) NOT NULL DEFAULT '' COMMENT '页面路径标题',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1:启用; 2:禁用)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COMMENT='小程序插件-页面路径';

-- -----------------------------
-- Records of `ey_applets_page_paths`
-- -----------------------------
INSERT INTO `ey_applets_page_paths` VALUES ('1', '主页', '/pages/index/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('2', '商品分类', '/pages/category/category', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('3', '商品列表', '/pages/category/list', '100', '0', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('4', '购物车', '/pages/cart/cart', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('5', '会员中心', '/pages/user/user', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('6', '全部订单', '/otherpages/mall/order/index?type=all', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('7', '待付款订单', '/otherpages/mall/order/index?type=payment', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('8', '待发货订单', '/otherpages/mall/order/index?type=delivery', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('9', '待收货订单', '/otherpages/mall/order/index?type=received', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('10', '已完成订单', '/otherpages/mall/order/index?type=complete', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('11', '退款订单', '/otherpages/mall/order/service/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('12', '个人资料', '/otherpages/user/edit/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('13', '收货地址', '/otherpages/mall/address/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('14', '我的余额', '/otherpages/user/wallet/withdrawal/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('15', '消费明细', '/otherpages/user/wallet/withdrawal/record', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('16', '会员等级', '/otherpages/user/upgradeMember/upgradeMember', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('17', '领券中心', '/otherpages/mall/coupon/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('18', '我的优惠券', '/otherpages/user/coupon/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('19', '秒杀列表', '/otherpages/seckill/index', '100', '0', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('20', '签到', '/pages/user/index', '100', '0', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('21', '分销商申请', '/otherpages/dealer/apply', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('22', '分销中心', '/otherpages/dealer/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('23', '分销提现', '/otherpages/dealer/withdraw/apply', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('24', '提现明细', '/otherpages/dealer/withdraw/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('25', '分销订单', '/otherpages/dealer/order', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('26', '分销商客户', '/otherpages/dealer/subcustomer', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('27', '分销我的下级', '/otherpages/dealer/subordinate', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('28', '推广海报', '/otherpages/dealer/qrcode', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('29', '分销佣金明细', '/otherpages/dealer/money', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('30', '积分商城', '/otherpages/points_shop/index', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('31', '积分明细', '/otherpages/points_shop/pointsDetails', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('32', '积分规则', '/otherpages/points_shop/rule', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('33', '核销台', '/otherpages/mall/order/verification', '100', '1', '0', '0');
INSERT INTO `ey_applets_page_paths` VALUES ('34', '我的关注', '/otherpages/user/collect/index', '100', '1', '0', '0');

-- -----------------------------
-- Table structure for `ey_applets_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_applets_template`;
CREATE TABLE `ey_applets_template` (
  `tpl_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_title` varchar(128) NOT NULL DEFAULT '' COMMENT '模板标题',
  `template_title` varchar(100) DEFAULT '' COMMENT '官方模板标题',
  `template_code` varchar(30) DEFAULT '' COMMENT '模板编号',
  `template_id` varchar(100) NOT NULL DEFAULT '' COMMENT '模板ID',
  `tpl_data` text NOT NULL COMMENT '模板内容序列化',
  `send_scene` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送场景',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `info` varchar(200) DEFAULT '' COMMENT '发送说明',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='微信小程序消息发送模板';

-- -----------------------------
-- Records of `ey_applets_template`
-- -----------------------------
INSERT INTO `ey_applets_template` VALUES ('1', '订单发货', '订单发货通知', '0', '', '{\"keywordsList\":{\"1\":{\"kid\":1,\"name\":\"\\u8ba2\\u5355\\u53f7\",\"example\":\"986753421\",\"rule\":\"character_string\",\"enumValueList\":[]},\"2\":{\"kid\":2,\"name\":\"\\u5546\\u54c1\\u540d\\u79f0\",\"example\":\"xx\\u5546\\u54c1\",\"rule\":\"thing\",\"enumValueList\":[]},\"7\":{\"kid\":7,\"name\":\"\\u5feb\\u9012\\u516c\\u53f8\",\"example\":\"TIT\\u9020\\u8230\\u5feb\\u9012\",\"rule\":\"thing\",\"enumValueList\":[]},\"4\":{\"kid\":4,\"name\":\"\\u5feb\\u9012\\u5355\\u53f7\",\"example\":\"986753421\",\"rule\":\"character_string\",\"enumValueList\":[]},\"5\":{\"kid\":5,\"name\":\"\\u53d1\\u8d27\\u65f6\\u95f4\",\"example\":\"2019-10-22 16:00:00\",\"rule\":\"date\",\"enumValueList\":[]}}}', '7', '0', '商家发货后立即发送', '1611054772', '1680229577');

-- -----------------------------
-- Table structure for `ey_arc_click`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arc_click`;
CREATE TABLE `ey_arc_click` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '浏览量统计表',
  `aid` int(11) DEFAULT '0' COMMENT '文档id',
  `month` int(11) DEFAULT '0' COMMENT '当月浏览量',
  `last_month` int(11) DEFAULT '0' COMMENT '上月浏览量',
  `cur_time` int(11) DEFAULT '0' COMMENT '当前月份时间',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_arc_click`
-- -----------------------------
INSERT INTO `ey_arc_click` VALUES ('1', '8', '1', '5', '1719158400', '1715589174', '1719192106');
INSERT INTO `ey_arc_click` VALUES ('2', '9', '18', '6', '1719158400', '1715592010', '1719221042');
INSERT INTO `ey_arc_click` VALUES ('3', '10', '36', '0', '1719158400', '1719193017', '1719215402');
INSERT INTO `ey_arc_click` VALUES ('4', '6', '2', '0', '1719158400', '1719193332', '1719194492');
INSERT INTO `ey_arc_click` VALUES ('5', '15', '1', '1', '1721750400', '1719276465', '1721787426');
INSERT INTO `ey_arc_click` VALUES ('6', '17', '1', '2', '1722787200', '1719276577', '1722840271');
INSERT INTO `ey_arc_click` VALUES ('7', '21', '2', '1', '1722960000', '1719276837', '1722993032');
INSERT INTO `ey_arc_click` VALUES ('8', '20', '1', '2', '1722960000', '1719279356', '1723001318');
INSERT INTO `ey_arc_click` VALUES ('9', '19', '1', '1', '1723046400', '1719279359', '1723087932');
INSERT INTO `ey_arc_click` VALUES ('10', '18', '2', '1', '1720972800', '1719279361', '1721026607');
INSERT INTO `ey_arc_click` VALUES ('11', '11', '2', '14', '1721664000', '1719279364', '1721722181');
INSERT INTO `ey_arc_click` VALUES ('12', '27', '1', '2', '1723046400', '1719280208', '1723080625');
INSERT INTO `ey_arc_click` VALUES ('13', '28', '1', '2', '1722441600', '1719280211', '1722514379');
INSERT INTO `ey_arc_click` VALUES ('14', '31', '1', '2', '1722355200', '1719281663', '1722410864');
INSERT INTO `ey_arc_click` VALUES ('15', '35', '3', '2', '1722960000', '1719282395', '1722991703');
INSERT INTO `ey_arc_click` VALUES ('16', '37', '21', '12', '1722960000', '1719282937', '1723024048');
INSERT INTO `ey_arc_click` VALUES ('17', '25', '1', '2', '1722268800', '1719283839', '1722337700');
INSERT INTO `ey_arc_click` VALUES ('18', '36', '20', '100', '1723046400', '1719302691', '1723088403');
INSERT INTO `ey_arc_click` VALUES ('19', '32', '1', '2', '1722960000', '1719394995', '1723016927');
INSERT INTO `ey_arc_click` VALUES ('20', '33', '1', '1', '1723046400', '1719394997', '1723088232');
INSERT INTO `ey_arc_click` VALUES ('21', '14', '1', '1', '1722182400', '1719395009', '1722247954');
INSERT INTO `ey_arc_click` VALUES ('22', '29', '2', '1', '1722355200', '1719470823', '1722418197');
INSERT INTO `ey_arc_click` VALUES ('23', '34', '2', '1', '1722960000', '1719474293', '1722993598');
INSERT INTO `ey_arc_click` VALUES ('24', '30', '1', '0', '1719417600', '1719474297', '1719474297');
INSERT INTO `ey_arc_click` VALUES ('25', '12', '1', '2', '1722182400', '1719881166', '1722247707');
INSERT INTO `ey_arc_click` VALUES ('26', '13', '2', '2', '1721923200', '1719881296', '1721977165');
INSERT INTO `ey_arc_click` VALUES ('27', '16', '2', '1', '1722355200', '1721785204', '1722413305');
INSERT INTO `ey_arc_click` VALUES ('28', '40', '6', '11', '1722441600', '1722245400', '1722495095');
INSERT INTO `ey_arc_click` VALUES ('29', '43', '6', '1', '1722441600', '1722419615', '1722478399');
INSERT INTO `ey_arc_click` VALUES ('30', '42', '5', '1', '1722441600', '1722419622', '1722478403');
INSERT INTO `ey_arc_click` VALUES ('31', '44', '11', '0', '1722441600', '1722472528', '1722482244');
INSERT INTO `ey_arc_click` VALUES ('32', '45', '9', '0', '1722441600', '1722472533', '1722484263');
INSERT INTO `ey_arc_click` VALUES ('33', '46', '19', '0', '1722441600', '1722494863', '1722499331');
INSERT INTO `ey_arc_click` VALUES ('34', '47', '11', '0', '1722441600', '1722494864', '1722495193');
INSERT INTO `ey_arc_click` VALUES ('35', '26', '1', '0', '1722873600', '1722914200', '1722914200');
INSERT INTO `ey_arc_click` VALUES ('36', '52', '1', '5', '1722960000', '1722926807', '1723013848');
INSERT INTO `ey_arc_click` VALUES ('37', '53', '6', '0', '1722873600', '1722927108', '1722927317');
INSERT INTO `ey_arc_click` VALUES ('38', '57', '24', '2', '1722960000', '1722930401', '1723023416');
INSERT INTO `ey_arc_click` VALUES ('39', '56', '4', '3', '1723046400', '1722931232', '1723087724');
INSERT INTO `ey_arc_click` VALUES ('40', '55', '2', '2', '1723046400', '1722934289', '1723085835');
INSERT INTO `ey_arc_click` VALUES ('41', '54', '2', '10', '1723046400', '1722935556', '1723083349');
INSERT INTO `ey_arc_click` VALUES ('42', '50', '5', '0', '1722960000', '1722992398', '1722998171');
INSERT INTO `ey_arc_click` VALUES ('43', '51', '2', '2', '1723046400', '1722993159', '1723088056');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `stypeid` varchar(90) DEFAULT '' COMMENT '副栏目ID集合',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `dealer_goods` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否参与分销(0:未参与; 1:已参与;)',
  `title` varchar(200) DEFAULT '' COMMENT '文档标题',
  `subtitle` varchar(200) DEFAULT '' COMMENT '副标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图片',
  `video_paths` varchar(250) DEFAULT '' COMMENT '商品视频介绍',
  `video_times` int(11) unsigned DEFAULT '0' COMMENT '视频时长',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `is_litpic` tinyint(1) DEFAULT '0' COMMENT '图片（0=否，1=是）',
  `is_roll` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '滚动（0=否，1=是）',
  `is_slide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '幻灯（0=否，1=是）',
  `is_diyattr` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '自定义（0=否，1=是）',
  `origin` varchar(200) DEFAULT '' COMMENT '来源',
  `author` varchar(200) DEFAULT '' COMMENT '作者',
  `click` int(10) DEFAULT '0' COMMENT '点击数',
  `arcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(255) DEFAULT '' COMMENT '跳转网址',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `attrlist_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '参数列表ID',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `free_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否包邮(1包邮(免运费)  0跟随系统)',
  `users_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员价',
  `crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品划线价',
  `users_discount_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)',
  `users_free` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否会员免费，默认0不免费，1为免费',
  `old_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品旧价',
  `sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '总销售量',
  `virtual_sales` int(10) DEFAULT '0' COMMENT '商品虚拟销售量',
  `sales_all` int(10) DEFAULT '0' COMMENT '虚拟总销量',
  `stock_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `stock_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品库存在产品详情页是否显示，1为显示，0为不显示',
  `stock_warning` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '库存预警阈值',
  `goods_unit` varchar(20) NOT NULL DEFAULT '' COMMENT '商品单位',
  `freight_fee_set` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品运费设置(1:包邮; 2:使用模板)',
  `freight_fee_tpl` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '运费模板ID，freight_fee_set=2时存入',
  `marketing_label` varchar(20) DEFAULT '' COMMENT '商品营销标签',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本) 4-核销',
  `logistics_type` varchar(100) DEFAULT '' COMMENT '商品物流支持类型(1: 物流配送; 2: 到店核销)',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员ID',
  `arc_level_id` int(10) DEFAULT '0' COMMENT '文档会员权限ID',
  `restric_type` tinyint(1) DEFAULT '0' COMMENT '限制模式，0=免费，1=付费，2=会员专享，3=会员付费',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `joinaid` int(10) DEFAULT '0' COMMENT '关联文档ID',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `appraise` int(10) DEFAULT '0' COMMENT '评价数',
  `collection` int(10) DEFAULT '0' COMMENT '收藏数',
  `htmlfilename` varchar(500) DEFAULT '' COMMENT '自定义文件名',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `goods_synch_images` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否同步商品主图到商品轮播图(0:否; 1:是;)',
  `no_vip_pay` tinyint(3) DEFAULT '0' COMMENT 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启',
  `editor_remote_img_local` tinyint(1) DEFAULT '1' COMMENT '远程图片本地化',
  `editor_img_clear_link` tinyint(1) DEFAULT '1' COMMENT '清除非本站链接',
  `reason` text COMMENT '退回原因',
  PRIMARY KEY (`aid`),
  KEY `add_time` (`add_time`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COMMENT='文档主表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('11', '0', ',5,', '2', '0', '棉麻中底吸湿透气 高颜值 脚感更出众 温莎舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241I529149.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '21', '0', '', '0', '', '', '', '0', '0', '0', '39.90', '0.00', '0', '0', '0.00', '1', '0', '1', '2996', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719221921', '1719221921', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('12', '0', ',5,', '2', '0', '纺织帮面 透气舒适 冰丝触感透气不闷脚 夏洛特舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241JT4F4.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '4', '0', '', '0', '', '', '', '0', '0', '0', '59.00', '0.00', '0', '0', '0.00', '5', '0', '6', '100993', '1', '0', '', '1', '0', '新品', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '2', '', '1719222644', '1719222644', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('13', '0', ',5,', '2', '0', '挺阔帮面柔韧回弹不易变形 全天候的舒适脚感 迈阿密舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K141Q4.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '6', '0', '', '0', '', '', '', '0', '0', '0', '79.00', '0.00', '0', '0', '0.00', '0', '0', '1', '999', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '2', '', '1719222822', '1719881339', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('14', '0', ',6,', '2', '0', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K526131.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '2', '0', '', '0', '', '', '', '0', '0', '0', '69.00', '0.00', '0', '0', '0.00', '0', '0', '0', '100998', '1', '0', '', '1', '0', '新品', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719223020', '1719223020', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('15', '0', ',6,', '2', '0', '时髦时尚 个性风绒亲毛毛拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KJ6418.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '3', '0', '', '0', '', '', '', '0', '0', '0', '89.00', '0.00', '0', '0', '0.00', '0', '0', '0', '2997', '1', '0', '', '1', '0', '新品', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719223196', '1719223196', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('16', '0', ',6,', '2', '0', '俏佳人毛巾拖', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P0452A.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '3', '0', '', '0', '', '', '', '0', '0', '0', '35.40', '0.00', '0', '0', '0.00', '1', '0', '1', '7991', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719223363', '1719223363', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('17', '0', ',6,', '2', '0', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P51N47.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '8', '0', '', '0', '', '', '', '0', '0', '0', '79.00', '0.00', '0', '0', '0.00', '0', '0', '0', '20979', '1', '0', '', '1', '0', '新品', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1719223671', '1719223671', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('18', '0', ',7,', '2', '0', '一体成型EVA环保材质 厚道踏云拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250RJ4937.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '9', '0', '', '0', '', '', '', '0', '0', '0', '39.00', '0.00', '0', '0', '0.00', '0', '0', '7', '23976', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719275500', '1719275500', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('19', '0', ',7,', '2', '0', '艾琪舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S4144L.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '13', '0', '', '0', '', '', '', '0', '0', '0', '39.00', '0.00', '0', '0', '0.00', '0', '0', '8', '239976', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719275851', '1719275851', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('20', '0', ',7,', '2', '0', '4CM厚底减震舒压 艾登舒防滑拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SS63b.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '13', '0', '', '0', '', '', '', '0', '0', '0', '39.00', '0.00', '0', '0', '0.00', '0', '0', '5', '27972', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1719276245', '1719276245', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('21', '0', ',7,', '2', '0', '一体成型EVA柔软Q弹 可爱萌宠情侣蜜蜜羊/甜甜犬舒适拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T530100.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '17', '0', '', '0', '', '', '', '0', '0', '0', '49.00', '59.00', '0', '0', '0.00', '0', '0', '0', '7992', '1', '0', '', '1', '0', '热卖', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719276556', '1722993110', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('22', '0', ',8,', '2', '0', 'PIMA棉 雅-床品四件套-米白/蓝/200*230cm/220*240cm', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U0242K.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '1999.00', '0.00', '0', '0', '0.00', '0', '0', '0', '3996', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719276941', '1719276941', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('23', '0', ',8,', '2', '0', '严选60S高密天丝 繁花-锦天丝床品四件套', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U6262K.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '2299.00', '0.00', '0', '0', '0.00', '1', '0', '1', '3995', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719277140', '1719277140', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('24', '0', ',8,', '2', '0', '高支高密奢享真丝般的舒适 寻梦/雅300T床品四件套', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z31E23.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '1999.00', '0.00', '0', '0', '0.00', '0', '0', '0', '3996', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719277677', '1719277677', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('25', '0', ',8,', '2', '0', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZU5J0.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '6', '0', '', '0', '', '', '', '0', '0', '0', '2199.00', '0.00', '0', '0', '0.00', '0', '0', '0', '5994', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719277998', '1719277998', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('26', '0', ',9,', '2', '0', '天使尊享枕', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091U2H8.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '399.00', '0.00', '0', '0', '0.00', '0', '0', '0', '999', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719278567', '1719278567', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('27', '0', ',9,', '2', '0', '饱满填充 高弹支撑 安睡舒眠枕 (2入装）枕头 枕芯', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092H4259.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '10', '0', '', '0', '', '', '', '0', '0', '0', '45.00', '0.00', '0', '0', '0.00', '5', '0', '5', '101992', '1', '0', '', '1', '0', '热卖', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719278990', '1719278990', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('28', '0', ',10,', '2', '0', '柔软瞬吸 温暖情侣 优选新疆棉莫兰迪抑菌无捻浴袍', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250930594G.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '8', '0', '', '0', '', '', '', '0', '0', '0', '399.00', '0.00', '0', '0', '0.00', '0', '0', '2', '102996', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719279222', '1719279222', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('29', '0', ',10,', '2', '0', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095116317.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '5', '0', '', '0', '', '', '', '0', '0', '0', '479.00', '0.00', '0', '0', '0.00', '0', '0', '4', '11988', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719280595', '1719280595', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('30', '0', ',11,', '2', '0', '压纹手挽遥控器盒/咖啡/收纳盒', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095T0616.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '249.00', '0.00', '0', '0', '0.00', '160', '0', '160', '99839', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719280775', '1719280775', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('31', '0', '', '2', '0', '古典仿皮压纹收纳筐 压纹收纳框/咖啡/桌面收纳多规格', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251000501H.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '10', '0', '', '0', '', '', '', '0', '0', '0', '159.00', '0.00', '0', '0', '0.00', '12', '0', '15', '2985', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719281004', '1722221778', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('32', '0', ',11,', '2', '0', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100511Q0.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '16', '0', '', '0', '', '', '', '0', '0', '0', '189.00', '0.00', '0', '0', '0.00', '12', '0', '11', '4984', '1', '0', '', '1', '0', '', '0', '1,2', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719281537', '1722591489', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('33', '0', ',11,', '2', '0', '好收纳多用包/钱包/化妆包/手拿包/洗漱包/小', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510134H09.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '6', '0', '', '0', '', '', '', '0', '0', '0', '85.00', '0.00', '0', '0', '0.00', '0', '0', '2', '2997', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719281738', '1719281738', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('34', '0', ',12,', '2', '0', '奢华系列品质优选 持久散香 香薰蜡烛&amp;室内扩香礼盒(香薰/香氛)', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101A4625.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '10', '0', '', '0', '', '', '', '0', '0', '0', '129.00', '0.00', '0', '0', '0.00', '1', '0', '1', '2996', '0', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1719282064', '1721955184', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('35', '0', ',12,', '2', '0', '轻奢雅致系列 品质优选 持久散香室内扩香100ml(香薰/香氛)', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102200926.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '31', '0', '', '0', '', '', '', '0', '0', '0', '99.00', '119.00', '0', '0', '0.00', '4', '0', '188', '3992', '1', '0', '', '1', '0', '热卖', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1719282324', '1723087051', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('36', '0', ',13,', '2', '0', '格格纹纱布面巾 毛巾', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102U1209.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '363', '0', '', '0', '', '', '', '0', '0', '0', '0.01', '35.00', '0', '0', '0.00', '82', '0', '14', '99917', '1', '0', '', '1', '0', '', '0', '1,2', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '4', '', '1719282597', '1723024958', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('37', '0', ',13,', '2', '0', '雪绒超细纤维毛巾', '加厚毛巾洗脸家用比纯棉吸水不掉毛珊瑚绒干发巾男女士洗澡擦头发', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103030500.jpg', 'https://update.eyoucms.com/app/shop/uploads/media/20240724/1-240H41HA2156.mp4', '37', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '591', '0', '', '0', '', '', '', '0', '0', '0', '38.00', '45.00', '0', '0', '0.00', '24', '0', '22', '13968', '1', '0', '', '1', '0', '热卖', '0', '1,2', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '1', '4', '', '1719282898', '1723024350', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('50', '0', ',5,', '2', '0', '夏洛特开口拖春秋透气舒适男女居家防滑情侣家用木地板拖鞋', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6114254Q3.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '5', '0', '', '0', '', '', '', '0', '0', '0', '48.00', '0.00', '0', '0', '0.00', '0', '0', '0', '5994', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722924605', '1722925397', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('51', '0', ',5,', '2', '0', '厚道朵朵云舒适拖鞋女居家防滑吸汗小众四季厚底空调软拖', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61412455N.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '4', '0', '', '0', '', '', '', '0', '0', '0', '58.00', '0.00', '0', '0', '0.00', '0', '0', '0', '8991', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722925223', '1722925625', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('52', '0', ',8,', '2', '0', '明媚色彩与柔软面料，亲肤透气玫香怡人全棉床品四件套/200*230cm', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143034348.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '6', '0', '', '0', '', '', '', '0', '0', '0', '1399.00', '0.00', '0', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722926111', '1722926111', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('53', '0', ',11,', '2', '0', '魅-遥控器盒', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144521637.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '6', '0', '', '0', '', '', '', '0', '0', '0', '112.80', '0.00', '0', '0', '0.00', '0', '0', '0', '19998', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722926642', '1722926728', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('54', '0', ',11,', '2', '0', '荔枝纹手挽遥控器盒', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144I0415.jpg', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '', '17', '0', '', '0', '', '', '', '0', '0', '0', '135.00', '0.00', '0', '0', '0.00', '2', '0', '2', '19996', '0', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722927005', '1722991532', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('55', '0', ',13,', '2', '0', '全棉质地蓬松柔软长绒触感吸水性好严选新疆材质Tide(潮色)毛巾方巾', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614531D39.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '4', '0', '', '0', '', '', '', '0', '0', '0', '29.00', '0.00', '0', '0', '0.00', '0', '0', '0', '89991', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722927578', '1722927578', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('56', '0', ',13,', '2', '0', '优雅条纹经典简约毛巾系列-清馨条纹浴巾', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615022Jb.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '8', '0', '', '0', '', '', '', '0', '0', '0', '99.00', '0.00', '0', '0', '0.00', '1', '0', '1', '2996', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '1722928078', '1722928078', '1', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('57', '0', ',13,', '2', '0', '棉花糖般的柔软触感森林物语提花-趣生活毛巾系列', '', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150911331.jpg', '', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '', '26', '0', '', '0', '', '', '', '0', '0', '0', '159.00', '0.00', '0', '0', '0.00', '0', '0', '2', '19998', '1', '0', '', '1', '0', '', '0', '1', 'view_product.htm', '1', '100', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1722928392', '1722928392', '1', '0', '1', '1', '');

-- -----------------------------
-- Table structure for `ey_archives_flag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives_flag`;
CREATE TABLE `ey_archives_flag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `flag_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文档属性名称',
  `flag_attr` varchar(10) NOT NULL DEFAULT '' COMMENT '属性值',
  `flag_fieldname` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态， 1---显示， 0---隐藏',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flag_attr` (`flag_attr`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='文档属性配置表';

-- -----------------------------
-- Records of `ey_archives_flag`
-- -----------------------------
INSERT INTO `ey_archives_flag` VALUES ('1', '头条', 'h', 'is_head', '1', '1', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('2', '推荐', 'c', 'is_recom', '1', '2', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('3', '加推', 'a', 'is_special', '0', '3', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('4', '标粗', 'b', 'is_b', '0', '4', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('5', '有图', 'p', 'is_litpic', '1', '5', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('6', '外链', 'j', 'is_jump', '1', '6', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('7', '轮播', 's', 'is_slide', '0', '7', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('8', '滚动', 'r', 'is_roll', '0', '8', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('9', '热文', 'd', 'is_diyattr', '0', '9', '1606272350', '1606272350');

-- -----------------------------
-- Table structure for `ey_arcmulti`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcmulti`;
CREATE TABLE `ey_arcmulti` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tagid` varchar(60) NOT NULL DEFAULT '' COMMENT '标签ID',
  `tagname` varchar(60) NOT NULL DEFAULT '' COMMENT '标签名',
  `innertext` text NOT NULL COMMENT '标签模板代码',
  `pagesize` int(10) NOT NULL DEFAULT '0' COMMENT '分页列表',
  `querysql` text NOT NULL COMMENT '完整SQL',
  `ordersql` varchar(200) DEFAULT '' COMMENT '排序SQL',
  `addfieldsSql` varchar(255) DEFAULT '' COMMENT '附加字段SQL',
  `addtableName` varchar(50) DEFAULT '' COMMENT '附加字段的数据表，不包含表前缀',
  `attstr` text COMMENT '属性字符串',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多页标记存储数据表';


-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', '0', '1552376880');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '栏目ID',
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `topid` int(10) DEFAULT '0' COMMENT '顶级栏目ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `ad_image` varchar(250) DEFAULT '' COMMENT '广告图片',
  `ad_host_id` int(11) unsigned DEFAULT '0' COMMENT '广告链接分组ID',
  `ad_link_id` int(11) unsigned DEFAULT '0' COMMENT '广告链接ID/商品分类ID/商品ID',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `diy_dirpath` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `rulelist` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `ruleview` varchar(200) DEFAULT '' COMMENT '文档静态文件存放规则',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '栏目是否应用于会员投稿发布，1是，0否',
  `weapp_code` varchar(50) DEFAULT '' COMMENT '插件栏目唯一标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `target` tinyint(1) DEFAULT '0' COMMENT '新窗口打开',
  `nofollow` tinyint(1) DEFAULT '0' COMMENT '防抓取',
  `typearcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `empty_logic` tinyint(1) DEFAULT '0' COMMENT '空内容逻辑',
  `page_limit` varchar(10) DEFAULT '0' COMMENT '限制页面 1-栏目页面 0-文档页面',
  `total_arc` int(10) DEFAULT '0' COMMENT '栏目下文档数量',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='文档栏目表';

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '2', '2', '0', '0', '舒适拖鞋', '0', '', '', '0', '0', 'shushituoxie', '/shushituoxie', '/shushituoxie', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719192043', '1721980560', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('2', '2', '2', '0', '0', '舒适睡眠', '0', '', '', '0', '0', 'shushishuimian', '/shushishuimian', '/shushishuimian', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221369', '1719221369', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('3', '2', '2', '0', '0', '居家好物', '0', '', '', '0', '0', 'jijiahaowu', '/jijiahaowu', '/jijiahaowu', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221380', '1719221380', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('4', '2', '2', '0', '0', '美浴时光', '0', '', '', '0', '0', 'meiyushiguang', '/meiyushiguang', '/meiyushiguang', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221406', '1719221406', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('5', '2', '2', '1', '1', '四季拖鞋', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240527/1-24052G623191Z.jpg', '', '0', '0', 'sijituoxie', '/ceshifenlei1/sijituoxie', '/ceshifenlei1/sijituoxie', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221425', '1721010920', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('6', '2', '2', '1', '1', '秋冬棉拖', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240705/1-240F5142Z44K.jpg', '', '0', '0', 'qiudongmiantuo', '/ceshifenlei1/qiudongmiantuo', '/ceshifenlei1/qiudongmiantuo', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221435', '1721011860', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('7', '2', '2', '1', '1', '夏季凉拖', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240705/1-240F5142911634.jpg', '', '0', '0', 'xiajiliangtuo', '/ceshifenlei1/xiajiliangtuo', '/ceshifenlei1/xiajiliangtuo', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221449', '1721011836', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('8', '2', '2', '2', '2', '床品', '1', '', '', '0', '0', 'chuangpin', '/shushishuimian/chuangpin', '/shushishuimian/chuangpin', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221464', '1719221464', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('9', '2', '2', '2', '2', '枕头', '1', '', '', '0', '0', 'zhentou', '/shushishuimian/zhentou', '/shushishuimian/zhentou', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221473', '1719221473', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('10', '2', '2', '2', '2', '家居服', '1', '', '', '0', '0', 'jiajifu', '/shushishuimian/jiajifu', '/shushishuimian/jiajifu', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221484', '1719221484', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('11', '2', '2', '3', '3', '收纳', '1', '', '', '0', '0', 'shouna', '/jijiahaowu/shouna', '/jijiahaowu/shouna', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221515', '1719221515', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('12', '2', '2', '3', '3', '香薰', '1', '', '', '0', '0', 'xiangxun', '/jijiahaowu/xiangxun', '/jijiahaowu/xiangxun', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221532', '1719221532', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('13', '2', '2', '4', '4', '毛巾', '1', '', '', '0', '0', 'maojin', '/meiyushiguang/maojin', '/meiyushiguang/maojin', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '0', '', '1719221549', '1719221549', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('14', '2', '2', '4', '4', '个护清洁', '1', '', '', '0', '0', 'gehuqingjie', '/meiyushiguang/gehuqingjie', '/meiyushiguang/gehuqingjie', '', '', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '1', '0', '0', '0', '0', '1', '0', '', '1719221576', '1721809933', '0', '0', '0', '0', '0', '0');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章附加表';


-- -----------------------------
-- Table structure for `ey_article_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_order`;
CREATE TABLE `ey_article_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章订单表';


-- -----------------------------
-- Table structure for `ey_article_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_pay`;
CREATE TABLE `ey_article_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT '0',
  `part_free` tinyint(1) DEFAULT '0' COMMENT '是否试看 0-否 1-是',
  `size` float(10,2) DEFAULT '1.00' COMMENT 'KB',
  `free_content` longtext COMMENT '试看内容',
  `add_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章付费预览表';


-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `switch_map` tinyint(1) DEFAULT '0' COMMENT '功能地图',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `check_oneself` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '发布文档自动通过审核，1--是，0--否',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` longtext COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:41:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:8;i:6;i:9;i:7;i:10;i:8;i:11;i:9;i:12;i:10;i:20;i:11;i:21;i:12;i:22;i:13;i:24;i:14;i:25;i:15;i:26;i:16;i:27;i:17;i:28;i:18;i:29;i:19;i:30;i:20;i:64;i:21;i:66;i:22;s:2:\"71\";i:23;s:2:\"72\";i:24;s:2:\"73\";i:25;s:2:\"74\";i:26;s:2:\"75\";i:27;s:1:\"1\";i:28;s:1:\"2\";i:29;s:1:\"3\";i:30;s:1:\"4\";i:31;s:1:\"5\";i:32;s:1:\"6\";i:33;s:1:\"7\";i:34;s:1:\"8\";i:35;s:1:\"9\";i:36;s:2:\"10\";i:37;s:2:\"11\";i:38;s:2:\"12\";i:39;s:2:\"13\";i:40;s:2:\"14\";}}', '1', '100', '1', '0', '1541207843', '1712996316');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:41:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:8;i:6;i:9;i:7;i:10;i:8;i:11;i:9;i:12;i:10;i:20;i:11;i:21;i:12;i:22;i:13;i:24;i:14;i:25;i:15;i:26;i:16;i:27;i:17;i:28;i:18;i:29;i:19;i:30;i:20;i:64;i:21;i:66;i:22;s:2:\"71\";i:23;s:2:\"72\";i:24;s:2:\"73\";i:25;s:2:\"74\";i:26;s:2:\"75\";i:27;s:1:\"1\";i:28;s:1:\"2\";i:29;s:1:\"3\";i:30;s:1:\"4\";i:31;s:1:\"5\";i:32;s:1:\"6\";i:33;s:1:\"7\";i:34;s:1:\"8\";i:35;s:1:\"9\";i:36;s:2:\"10\";i:37;s:2:\"11\";i:38;s:2:\"12\";i:39;s:2:\"13\";i:40;s:2:\"14\";}}', '1', '100', '1', '0', '1541207846', '1712996316');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` text NOT NULL COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_screening` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `is_release` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于会员投稿发布',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `ifcontrol` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态，控制该条数据是否允许被控制，1为不允许控制，0为允许控制',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `set_type` tinyint(3) DEFAULT '0' COMMENT '区域选择时使用是否为三级联动,1-是',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=553 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091575', '1533091575', '0');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091601', '1533091601', '0');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091624', '1533091624', '0');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092214', '1533092214', '0');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092246', '1533092246', '0');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092381', '1533092381', '0');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092398', '1533092398', '0');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092439', '1533092439', '0');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092454', '1533092454', '0');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092468', '1533092468', '0');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092484', '1533092484', '0');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '编辑者', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092498', '1533092498', '0');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092512', '1533092512', '0');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092534', '1533092534', '0');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092553', '1533092553', '0');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092698', '1533092698', '0');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092713', '1533092713', '0');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092725', '1533092725', '0');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092739', '1533092739', '0');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092753', '1533092753', '0');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092766', '1533092766', '0');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359739', '1533359739', '0');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1533464713', '0');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('52', 'del_method', '-99', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('53', 'is_del', '0', '是否伪删除', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('54', 'del_method', '0', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('55', 'prom_type', '0', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('56', 'users_price', '0', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('57', 'prom_type', '2', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('58', 'users_price', '2', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1713337196', '0');
INSERT INTO `ey_channelfield` VALUES ('59', 'update_time', '2', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('60', 'add_time', '2', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('61', 'del_method', '2', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('62', 'is_del', '2', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('63', 'admin_id', '2', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('64', 'lang', '2', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('65', 'sort_order', '2', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('66', 'status', '2', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('67', 'tempview', '2', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('68', 'seo_description', '2', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('69', 'seo_keywords', '2', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('70', 'seo_title', '2', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('71', 'ismake', '2', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('72', 'jumplinks', '2', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('73', 'arcrank', '2', '阅读权限：0=开放浏览，-1=待审核稿件', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('74', 'click', '2', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('75', 'author', '2', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('76', 'is_litpic', '2', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('77', 'is_jump', '2', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('78', 'is_recom', '2', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('79', 'is_top', '2', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('80', 'is_special', '2', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('81', 'is_head', '2', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('82', 'litpic', '2', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('83', 'title', '2', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('84', 'is_b', '2', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('85', 'channel', '2', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('86', 'typeid', '2', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('87', 'aid', '2', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563518642', '1563518642', '0');
INSERT INTO `ey_channelfield` VALUES ('552', 'total_arc', '-99', '栏目下文档数量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1711942240', '1711942240', '0');
INSERT INTO `ey_channelfield` VALUES ('89', 'update_time', '9', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('90', 'add_time', '9', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('91', 'del_method', '9', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('92', 'is_del', '9', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('93', 'admin_id', '9', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('94', 'lang', '9', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('95', 'sort_order', '9', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('96', 'status', '9', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('97', 'tempview', '9', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('98', 'prom_type', '9', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('99', 'users_price', '9', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('100', 'seo_description', '9', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('101', 'seo_keywords', '9', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('102', 'seo_title', '9', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('103', 'ismake', '9', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('104', 'jumplinks', '9', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('105', 'arcrank', '9', '阅读权限：0=开放浏览，-1=待审核稿件', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('106', 'click', '9', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('107', 'author', '9', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('108', 'is_litpic', '9', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('109', 'is_jump', '9', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('110', 'is_recom', '9', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('111', 'is_top', '9', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('112', 'is_special', '9', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('113', 'is_head', '9', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('114', 'litpic', '9', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '0', '0', '1', '1', '0', '100', '1', '1563526560', '1563526567', '0');
INSERT INTO `ey_channelfield` VALUES ('115', 'title', '9', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('116', 'is_b', '9', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('117', 'channel', '9', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('118', 'typeid', '9', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('119', 'aid', '9', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1563526560', '1563526560', '0');
INSERT INTO `ey_channelfield` VALUES ('120', 'gzdd', '9', '工作地点', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '0', '0', '0', '1', '1', '1563526665', '1563528016', '0');
INSERT INTO `ey_channelfield` VALUES ('121', 'xlyq', '9', '学历要求', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '0', '0', '0', '2', '1', '1563526681', '1563528016', '0');
INSERT INTO `ey_channelfield` VALUES ('122', 'xzdy', '9', '薪资待遇', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '0', '0', '0', '3', '1', '1563526694', '1563528018', '0');
INSERT INTO `ey_channelfield` VALUES ('123', 'gzxz', '9', '工作性质', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '0', '0', '0', '4', '1', '1563526705', '1563528018', '0');
INSERT INTO `ey_channelfield` VALUES ('124', 'gznx', '9', '工作年限', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '0', '0', '0', '5', '1', '1563526716', '1563528019', '0');
INSERT INTO `ey_channelfield` VALUES ('125', 'zprs', '9', '招聘人数', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '0', '0', '0', '6', '1', '1563526727', '1563528021', '0');
INSERT INTO `ey_channelfield` VALUES ('126', 'nnxq', '9', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '0', '1', '0', '0', '0', '0', '7', '1', '1563526769', '1563528023', '0');
INSERT INTO `ey_channelfield` VALUES ('127', 'users_id', '0', '会员ID', 'int', 'int(11)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('128', 'arc_level_id', '0', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('129', 'arc_level_id', '4', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('130', 'arc_level_id', '2', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1565662106', '1565662106', '0');
INSERT INTO `ey_channelfield` VALUES ('131', 'users_id', '2', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1565662106', '1565662106', '0');
INSERT INTO `ey_channelfield` VALUES ('136', 'weapp_code', '-99', '插件栏目唯一标识', 'text', 'varchar(200)', '200', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('137', 'is_release', '-99', '栏目是否应用于会员投稿发布，1是，0否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('138', 'old_price', '0', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('139', 'stock_count', '0', '商品库存量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('140', 'stock_show', '0', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('141', 'joinaid', '0', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('142', 'downcount', '0', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('143', 'downcount', '4', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('144', 'update_time', '1', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('145', 'add_time', '1', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('146', 'downcount', '1', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('147', 'joinaid', '1', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('148', 'del_method', '1', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('149', 'is_del', '1', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('150', 'arc_level_id', '1', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('151', 'users_id', '1', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('152', 'admin_id', '1', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('153', 'lang', '1', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('154', 'sort_order', '1', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('155', 'status', '1', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('156', 'tempview', '1', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('157', 'prom_type', '1', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('158', 'stock_show', '1', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('159', 'stock_count', '1', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('160', 'old_price', '1', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('161', 'users_price', '1', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('162', 'seo_description', '1', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('163', 'seo_keywords', '1', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('164', 'seo_title', '1', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('165', 'ismake', '1', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('166', 'jumplinks', '1', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('167', 'arcrank', '1', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('168', 'click', '1', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('169', 'author', '1', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('170', 'is_litpic', '1', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('171', 'is_jump', '1', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('172', 'is_recom', '1', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('173', 'is_top', '1', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('174', 'is_special', '1', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('175', 'is_head', '1', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('176', 'litpic', '1', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('177', 'title', '1', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('178', 'is_b', '1', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('179', 'channel', '1', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('180', 'typeid', '1', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('181', 'aid', '1', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233787', '1574233787', '0');
INSERT INTO `ey_channelfield` VALUES ('182', 'downcount', '2', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233793', '1574233793', '0');
INSERT INTO `ey_channelfield` VALUES ('183', 'joinaid', '2', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233793', '1574233793', '0');
INSERT INTO `ey_channelfield` VALUES ('184', 'stock_show', '2', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233793', '1574233793', '0');
INSERT INTO `ey_channelfield` VALUES ('185', 'stock_count', '2', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233793', '1574233793', '0');
INSERT INTO `ey_channelfield` VALUES ('186', 'old_price', '2', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233793', '1574233793', '0');
INSERT INTO `ey_channelfield` VALUES ('187', 'update_time', '3', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('188', 'add_time', '3', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('189', 'downcount', '3', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('190', 'joinaid', '3', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('191', 'del_method', '3', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('192', 'is_del', '3', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('193', 'arc_level_id', '3', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('194', 'users_id', '3', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('195', 'admin_id', '3', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('196', 'lang', '3', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('197', 'sort_order', '3', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('198', 'status', '3', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('199', 'tempview', '3', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('200', 'prom_type', '3', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('201', 'stock_show', '3', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('202', 'stock_count', '3', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('203', 'old_price', '3', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('204', 'users_price', '3', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('205', 'seo_description', '3', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('206', 'seo_keywords', '3', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('207', 'seo_title', '3', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('208', 'ismake', '3', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('209', 'jumplinks', '3', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('210', 'arcrank', '3', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('211', 'click', '3', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('212', 'author', '3', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('213', 'is_litpic', '3', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('214', 'is_jump', '3', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('215', 'is_recom', '3', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('216', 'is_top', '3', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('217', 'is_special', '3', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('218', 'is_head', '3', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('219', 'litpic', '3', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('220', 'title', '3', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('221', 'is_b', '3', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('222', 'channel', '3', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('223', 'typeid', '3', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('224', 'aid', '3', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233796', '1574233796', '0');
INSERT INTO `ey_channelfield` VALUES ('225', 'update_time', '4', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('226', 'add_time', '4', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('227', 'joinaid', '4', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('228', 'del_method', '4', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('229', 'is_del', '4', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('230', 'users_id', '4', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('231', 'admin_id', '4', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('232', 'lang', '4', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('233', 'sort_order', '4', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('234', 'status', '4', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('235', 'tempview', '4', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('236', 'prom_type', '4', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('237', 'stock_show', '4', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('238', 'stock_count', '4', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('239', 'old_price', '4', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('240', 'users_price', '4', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('241', 'seo_description', '4', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('242', 'seo_keywords', '4', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('243', 'seo_title', '4', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('244', 'ismake', '4', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('245', 'jumplinks', '4', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('246', 'arcrank', '4', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('247', 'click', '4', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('248', 'author', '4', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('249', 'is_litpic', '4', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('250', 'is_jump', '4', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('251', 'is_recom', '4', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('252', 'is_top', '4', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('253', 'is_special', '4', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('254', 'is_head', '4', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('255', 'litpic', '4', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('256', 'title', '4', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('257', 'is_b', '4', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('258', 'channel', '4', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('259', 'typeid', '4', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('260', 'aid', '4', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233799', '1574233799', '0');
INSERT INTO `ey_channelfield` VALUES ('261', 'update_time', '6', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('262', 'add_time', '6', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('263', 'downcount', '6', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('264', 'joinaid', '6', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('265', 'del_method', '6', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('266', 'is_del', '6', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('267', 'arc_level_id', '6', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('268', 'users_id', '6', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('269', 'admin_id', '6', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('270', 'lang', '6', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('271', 'sort_order', '6', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('272', 'status', '6', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('273', 'tempview', '6', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('274', 'prom_type', '6', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('275', 'stock_show', '6', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('276', 'stock_count', '6', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('277', 'old_price', '6', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('278', 'users_price', '6', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('279', 'seo_description', '6', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('280', 'seo_keywords', '6', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('281', 'seo_title', '6', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('282', 'ismake', '6', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('283', 'jumplinks', '6', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('284', 'arcrank', '6', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('285', 'click', '6', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('286', 'author', '6', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('287', 'is_litpic', '6', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('288', 'is_jump', '6', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('289', 'is_recom', '6', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('290', 'is_top', '6', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('291', 'is_special', '6', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('292', 'is_head', '6', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('293', 'litpic', '6', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('294', 'title', '6', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('295', 'is_b', '6', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('296', 'channel', '6', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('297', 'typeid', '6', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('298', 'aid', '6', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233802', '1574233802', '0');
INSERT INTO `ey_channelfield` VALUES ('299', 'downcount', '9', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('300', 'joinaid', '9', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('301', 'arc_level_id', '9', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('302', 'users_id', '9', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('303', 'stock_show', '9', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('304', 'stock_count', '9', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('305', 'old_price', '9', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1574233808', '1574233808', '0');
INSERT INTO `ey_channelfield` VALUES ('306', 'htmlfilename', '0', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('307', 'htmlfilename', '1', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('308', 'htmlfilename', '2', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('309', 'htmlfilename', '3', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('310', 'htmlfilename', '4', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('311', 'htmlfilename', '6', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('312', 'attrlist_id', '0', '参数列表ID', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('313', 'sales_num', '0', '销售量', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('314', 'update_time', '5', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('315', 'add_time', '5', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('316', 'htmlfilename', '5', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('317', 'downcount', '5', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('318', 'joinaid', '5', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('319', 'del_method', '5', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('320', 'is_del', '5', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('321', 'arc_level_id', '5', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('322', 'users_id', '5', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('323', 'admin_id', '5', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('324', 'lang', '5', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('325', 'sort_order', '5', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('326', 'status', '5', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('327', 'tempview', '5', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('328', 'prom_type', '5', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('329', 'stock_show', '5', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('330', 'stock_count', '5', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('331', 'sales_num', '5', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('332', 'old_price', '5', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('333', 'users_price', '5', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('334', 'attrlist_id', '5', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('335', 'seo_description', '5', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('336', 'seo_keywords', '5', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('337', 'seo_title', '5', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('338', 'ismake', '5', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('339', 'jumplinks', '5', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('340', 'arcrank', '5', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('341', 'click', '5', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('342', 'author', '5', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('343', 'is_litpic', '5', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('344', 'is_jump', '5', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('345', 'is_recom', '5', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('346', 'is_top', '5', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('347', 'is_special', '5', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('348', 'is_head', '5', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('349', 'litpic', '5', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('350', 'title', '5', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('351', 'is_b', '5', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('352', 'channel', '5', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('353', 'typeid', '5', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('354', 'aid', '5', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('355', 'content', '5', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('356', 'courseware', '5', '课件地址', 'text', 'varchar(200)', '200', '', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('357', 'courseware_free', '5', '课件收费', 'select', 'enum(\'免费\',\'收费\')', '0', '免费,收费', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('358', 'total_duration', '5', '视频总时长', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('359', 'total_video', '5', '视频数', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('404', 'topid', '-99', '顶级栏目ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('361', 'update_time', '7', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('362', 'add_time', '7', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('363', 'htmlfilename', '7', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('364', 'downcount', '7', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('365', 'joinaid', '7', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('366', 'del_method', '7', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('367', 'is_del', '7', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('368', 'arc_level_id', '7', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('369', 'users_id', '7', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('370', 'admin_id', '7', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('371', 'lang', '7', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('372', 'sort_order', '7', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('373', 'status', '7', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('374', 'tempview', '7', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('375', 'prom_type', '7', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('376', 'stock_show', '7', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('377', 'stock_count', '7', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('378', 'sales_num', '7', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('379', 'old_price', '7', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('380', 'users_free', '7', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('381', 'users_price', '7', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('382', 'attrlist_id', '7', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('383', 'seo_description', '7', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('384', 'seo_keywords', '7', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('385', 'seo_title', '7', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('386', 'ismake', '7', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('387', 'jumplinks', '7', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('388', 'arcrank', '7', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('389', 'click', '7', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('390', 'author', '7', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('391', 'is_litpic', '7', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('392', 'is_jump', '7', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('393', 'is_recom', '7', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('394', 'is_top', '7', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('395', 'is_special', '7', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('396', 'is_head', '7', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('397', 'litpic', '7', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('398', 'title', '7', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('399', 'is_b', '7', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('400', 'channel', '7', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('401', 'typeid', '7', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('402', 'aid', '7', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('403', 'content', '7', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('405', 'is_slide', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('406', 'is_roll', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('407', 'is_diyattr', '0', '是否自定义', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('408', 'restric_type', '0', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('409', 'diy_dirpath', '-99', '自定义HTML保存路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('410', 'rulelist', '-99', '列表静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('411', 'ruleview', '-99', '文档静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('412', 'subtitle', '0', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('413', 'origin', '0', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('414', 'stypeid', '0', '副栏目', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('415', 'area_id', '1', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('416', 'city_id', '1', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('417', 'province_id', '1', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('418', 'collection', '1', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('419', 'appraise', '1', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('420', 'restric_type', '1', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('421', 'sales_num', '1', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('422', 'users_free', '1', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('423', 'attrlist_id', '1', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('424', 'origin', '1', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('425', 'is_diyattr', '1', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('426', 'is_slide', '1', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('427', 'is_roll', '1', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('428', 'subtitle', '1', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('429', 'stypeid', '1', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949813', '1641949813', '0');
INSERT INTO `ey_channelfield` VALUES ('430', 'area_id', '2', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('431', 'city_id', '2', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('432', 'province_id', '2', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('433', 'collection', '2', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('434', 'appraise', '2', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('435', 'restric_type', '2', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('436', 'sales_num', '2', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('437', 'users_free', '2', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('438', 'attrlist_id', '2', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('439', 'origin', '2', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('440', 'is_diyattr', '2', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('441', 'is_slide', '2', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('442', 'is_roll', '2', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('443', 'subtitle', '2', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('444', 'stypeid', '2', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949815', '1641949815', '0');
INSERT INTO `ey_channelfield` VALUES ('445', 'area_id', '3', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('446', 'city_id', '3', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('447', 'province_id', '3', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('448', 'collection', '3', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('449', 'appraise', '3', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('450', 'restric_type', '3', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('451', 'sales_num', '3', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('452', 'users_free', '3', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('453', 'attrlist_id', '3', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('454', 'origin', '3', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('455', 'is_diyattr', '3', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('456', 'is_slide', '3', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('457', 'is_roll', '3', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('458', 'subtitle', '3', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('459', 'stypeid', '3', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949817', '1641949817', '0');
INSERT INTO `ey_channelfield` VALUES ('460', 'area_id', '4', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('461', 'city_id', '4', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('462', 'province_id', '4', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('463', 'collection', '4', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('464', 'appraise', '4', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('465', 'restric_type', '4', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('466', 'sales_num', '4', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('467', 'users_free', '4', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('468', 'attrlist_id', '4', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('469', 'origin', '4', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('470', 'is_diyattr', '4', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('471', 'is_slide', '4', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('472', 'is_roll', '4', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('473', 'subtitle', '4', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('474', 'stypeid', '4', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949819', '1641949819', '0');
INSERT INTO `ey_channelfield` VALUES ('475', 'area_id', '6', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('476', 'city_id', '6', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('477', 'province_id', '6', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('478', 'collection', '6', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('479', 'appraise', '6', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('480', 'restric_type', '6', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('481', 'sales_num', '6', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('482', 'users_free', '6', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('483', 'attrlist_id', '6', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('484', 'origin', '6', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('485', 'is_diyattr', '6', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('486', 'is_slide', '6', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('487', 'is_roll', '6', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('488', 'subtitle', '6', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('489', 'stypeid', '6', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949820', '1641949820', '0');
INSERT INTO `ey_channelfield` VALUES ('490', 'area_id', '7', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('491', 'city_id', '7', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('492', 'province_id', '7', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('493', 'collection', '7', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('494', 'appraise', '7', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('495', 'restric_type', '7', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('496', 'origin', '7', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('497', 'is_diyattr', '7', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('498', 'is_slide', '7', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('499', 'is_roll', '7', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('500', 'subtitle', '7', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('501', 'stypeid', '7', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949822', '1641949822', '0');
INSERT INTO `ey_channelfield` VALUES ('502', 'area_id', '9', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('503', 'city_id', '9', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('504', 'province_id', '9', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('505', 'htmlfilename', '9', '自定义文件名', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('506', 'collection', '9', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('507', 'appraise', '9', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('508', 'restric_type', '9', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('509', 'sales_num', '9', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('510', 'users_free', '9', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('511', 'attrlist_id', '9', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('512', 'origin', '9', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('513', 'is_diyattr', '9', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('514', 'is_slide', '9', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('515', 'is_roll', '9', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('516', 'subtitle', '9', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('517', 'stypeid', '9', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641949825', '1641949825', '0');
INSERT INTO `ey_channelfield` VALUES ('518', 'target', '-99', '新窗口打开', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('519', 'nofollow', '-99', '防抓取', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('520', 'content_ey_m', '1', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1623047123', '0');
INSERT INTO `ey_channelfield` VALUES ('521', 'content_ey_m', '2', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1645086030', '1645086039', '0');
INSERT INTO `ey_channelfield` VALUES ('522', 'content_ey_m', '3', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('523', 'content_ey_m', '4', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('524', 'content_ey_m', '5', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('525', 'content_ey_m', '6', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('526', 'content_ey_m', '7', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('527', 'typearcrank', '-99', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('528', 'empty_logic', '-99', '空内容逻辑', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('529', 'users_discount_type', '0', '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1683873488', '1683873488', '0');
INSERT INTO `ey_channelfield` VALUES ('530', 'logistics_type', '0', '商品物流支持类型(1: 物流配送; 2: 到店核销)', 'text', 'varchar(100)', '100', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1690364521', '1690364521', '0');
INSERT INTO `ey_channelfield` VALUES ('531', 'editor_img_clear_link', '3', '清除非本站链接', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('532', 'editor_remote_img_local', '3', '远程图片本地化', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('533', 'no_vip_pay', '3', 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启', 'switch', 'tinyint(3)', '3', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('534', 'logistics_type', '3', '商品物流支持类型(1: 物流配送; 2: 到店核销)', 'text', 'varchar(100)', '100', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('535', 'sales_all', '3', '虚拟总销量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('536', 'virtual_sales', '3', '商品虚拟销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('537', 'users_discount_type', '3', '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('538', 'crossed_price', '3', '商品划线价', 'decimal', 'decimal(10,2) unsigned', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('539', 'free_shipping', '3', '商品是否包邮(1包邮(免运费)  0跟随系统)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('540', 'merchant_id', '3', '多商家ID', 'datetime', 'int(11) unsigned', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1701047939', '1701047939', '0');
INSERT INTO `ey_channelfield` VALUES ('541', 'reason', '2', '退回原因', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('542', 'editor_img_clear_link', '2', '清除非本站链接', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('543', 'editor_remote_img_local', '2', '远程图片本地化', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('544', 'no_vip_pay', '2', 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启', 'switch', 'tinyint(3)', '3', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('545', 'logistics_type', '2', '商品物流支持类型(1: 物流配送; 2: 到店核销)', 'text', 'varchar(100)', '100', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('546', 'sales_all', '2', '虚拟总销量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('547', 'virtual_sales', '2', '商品虚拟销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('548', 'users_discount_type', '2', '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('549', 'crossed_price', '2', '商品划线价', 'decimal', 'decimal(10,2) unsigned', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('550', 'free_shipping', '2', '商品是否包邮(1包邮(免运费)  0跟随系统)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');
INSERT INTO `ey_channelfield` VALUES ('551', 'merchant_id', '2', '多商家ID', 'datetime', 'int(11) unsigned', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1713168925', '1713168925', '0');

-- -----------------------------
-- Table structure for `ey_channelfield_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_bind`;
CREATE TABLE `ey_channelfield_bind` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `field_id` int(10) DEFAULT '0' COMMENT '自定义字段ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='栏目与自定义字段绑定表';


-- -----------------------------
-- Table structure for `ey_channelfield_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_log`;
CREATE TABLE `ey_channelfield_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) DEFAULT '0' COMMENT '模型ID',
  `dtype` varchar(32) DEFAULT '' COMMENT '字段类型',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='自定义字段日志表';


-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `ifsystem` tinyint(1) DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `is_repeat_title` tinyint(1) DEFAULT '1' COMMENT '文档标题重复，1=允许，0=不允许',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '模型是否允许应用于会员投稿发布，1是，0否',
  `is_litpic_users_release` tinyint(1) DEFAULT '1' COMMENT '缩略图是否应用于会员投稿，1=允许，0=不允许',
  `data` text COMMENT '额外序列化存储数据',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8 COMMENT='系统模型表';

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '1', '1', '1', '', '0', '1', '0', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '1', '1', '1', '1', '1', '', '0', '4', '0', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '1', '1', '1', '1', '1', '', '0', '2', '0', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '1', '1', '1', '1', '', '0', '8', '1509197711', '1690181604');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '1', '1', '1', '1', '', '0', '6', '1523091961', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '1', '1', '1', '1', '1', '', '0', '3', '1523929121', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('9', 'recruit', '招聘模型', '人才招聘', 'recruit', 'Recruit', '1', '0', '1', '1', '1', '', '0', '50', '1563526560', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('5', 'media', '视频模型', '视频', 'media', 'Media', '0', '1', '1', '1', '1', '', '0', '5', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('7', 'special', '专题模型', '专题', 'special', 'Special', '0', '1', '1', '1', '1', '', '0', '7', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('51', 'ask', '问答模型', '问答', 'ask', 'Ask', '0', '1', '1', '1', '1', '', '1', '9', '1509197711', '1692668301');

-- -----------------------------
-- Table structure for `ey_common_pic`
-- -----------------------------
DROP TABLE IF EXISTS `ey_common_pic`;
CREATE TABLE `ey_common_pic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '常用图片ID',
  `pic_path` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='常用图片';


-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=420 DEFAULT CHARSET=utf8 COMMENT='系统配置表';

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', 'https://update.eyoucms.com/demo/uploads/allimg/20190114/f0d5e5830502125f5077212a90ef3a33.png', 'water', '', '0', '1547463466');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '50', 'basic', '', '0', '1719975246');
INSERT INTO `ey_config` VALUES ('12', 'image_type', 'jpg|gif|png|bmp|jpeg|ico|webp', 'basic', '', '0', '1675389691');
INSERT INTO `ey_config` VALUES ('13', 'file_type', 'zip|gz|rar|iso|doc|xls|ppt|wps|docx|xlsx|pptx|pem', 'basic', '', '0', '1718964306');
INSERT INTO `ey_config` VALUES ('14', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'basic', '', '0', '0');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '商城系统,商城CMS', 'web', '', '0', '1722933467');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '45°SHOP', 'web', '', '0', '1722305938');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/public/static/admin/logo/logo_ey.png', 'web', '', '0', '1721271666');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://www.meiz36.hk', 'web', '', '0', '1727419810');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', '0', '1721271666');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', '', 'web', '', '0', '1719997608');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2012-2022 45°C SHOP 版权所有', 'web', '', '0', '1722933467');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '3', 'seo', '', '0', '1721100404');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '&gt;', 'basic', '', '0', '0');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '45°C SHOP', 'web', '', '0', '1722933467');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '', 'web', '', '0', '1728437840');
INSERT INTO `ey_config` VALUES ('60', 'web_attr_1', '400-12345-67890', 'web', '', '0', '1667183895');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', '0', '1727341722');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', '0', '1721271586');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata_jvpkgfQ21qv9Mstrxu3p', 'web', '', '0', '1727333139');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'cbQ1AmriPQ7LHyth9xeHH6Lj', 'php', '', '0', '1571040555');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', '0', '1719973751');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '-1', 'web', '', '0', '1728441391');
INSERT INTO `ey_config` VALUES ('81', 'web_adminbasefile', '/login.php', 'web', '', '0', '1721271586');
INSERT INTO `ey_config` VALUES ('82', 'seo_rewrite_format', '1', 'seo', '', '0', '0');
INSERT INTO `ey_config` VALUES ('83', 'web_cmsmode', '2', 'web', '', '0', '1701048841');
INSERT INTO `ey_config` VALUES ('84', 'web_htmlcache_expires_in', '0', 'web', '', '0', '1546477337');
INSERT INTO `ey_config` VALUES ('85', 'web_show_popup_upgrade', '1', 'web', '', '0', '1653359674');
INSERT INTO `ey_config` VALUES ('86', 'web_weapp_switch', '1', 'web', '', '0', '1563498417');
INSERT INTO `ey_config` VALUES ('88', 'seo_dynamic_format', '1', 'seo', '', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_sql_mode', 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', '0', '1727333130');
INSERT INTO `ey_config` VALUES ('90', 'system_home_default_lang', 'cn', 'system', '', '0', '0');
INSERT INTO `ey_config` VALUES ('91', 'system_langnum', '1', 'system', '', '0', '1610357910');
INSERT INTO `ey_config` VALUES ('170', 'web_exception', '0', 'web', '', '0', '1546477337');
INSERT INTO `ey_config` VALUES ('171', 'web_language_switch', '0', 'web', '', '0', '1703142357');
INSERT INTO `ey_config` VALUES ('174', 'web_is_https', '0', 'web', '', '0', '1552968816');
INSERT INTO `ey_config` VALUES ('176', 'smtp_syn_weapp', '1', 'smtp', '', '0', '1553566547');
INSERT INTO `ey_config` VALUES ('178', 'php_eyou_blacklist', '', 'php', '', '0', '1553654429');
INSERT INTO `ey_config` VALUES ('190', 'system_auth_code', '$2y$11$f9f3871eb36b3e26f259f28', 'system', '', '0', '1557733856');
INSERT INTO `ey_config` VALUES ('192', 'system_upgrade_filelist', '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', 'system', '', '0', '1712994989');
INSERT INTO `ey_config` VALUES ('366', 'web_recycle_switch', '1', 'web', '', '0', '1701045570');
INSERT INTO `ey_config` VALUES ('354', 'php_websensitive', '5aix5LmQfOWNmuW9qXzkuJbnlYzmna985aSc5bqXfOi1jOWNmnzmnqrmlK986aOO5pq0fGJvYnzmirzms6h8OyYjfGHniYd85aSn54mHfOasp+e+jnwo5Lit5Zu9KXzvvIjkuK3lm73vvIl85Y2K5bKbwrfkvZPogrI=', 'php', '', '0', '1721292333');
INSERT INTO `ey_config` VALUES ('331', 'other_pcwapjs', '0', 'other', '', '0', '1636442096');
INSERT INTO `ey_config` VALUES ('247', 'syn_admin_logic_video_addfields', '5', 'syn', '', '0', '1614152870');
INSERT INTO `ey_config` VALUES ('248', 'syn_admin_logic_add_tag', '1', 'syn', '', '0', '1591957363');
INSERT INTO `ey_config` VALUES ('249', 'syn_admin_logic_users_parameter', '1', 'syn', '', '0', '1591957363');
INSERT INTO `ey_config` VALUES ('227', 'seo_html_arcdir', '/html', 'seo', '', '0', '1721100370');
INSERT INTO `ey_config` VALUES ('228', 'seo_html_listname', '2', 'seo', '', '0', '1567578996');
INSERT INTO `ey_config` VALUES ('229', 'seo_html_pagename', '2', 'seo', '', '0', '1567578996');
INSERT INTO `ey_config` VALUES ('230', 'seo_force_inlet', '0', 'seo', '', '0', '1721102570');
INSERT INTO `ey_config` VALUES ('193', 'system_version', 'v1.3.0', 'system', '', '0', '1701045567');
INSERT INTO `ey_config` VALUES ('195', 'web_users_switch', '1', 'web', '', '0', '1713262161');
INSERT INTO `ey_config` VALUES ('199', 'system_correctarctypedirpath', '1', 'system', '', '0', '1563503940');
INSERT INTO `ey_config` VALUES ('203', 'web_attr_13', 'https://update.eyoucms.com/demo/uploads/allimg/20210115/1-210115153Z9511.png', 'web', '', '0', '1610696352');
INSERT INTO `ey_config` VALUES ('225', 'system_synleveldata', '1', 'system', '', '0', '1564532901');
INSERT INTO `ey_config` VALUES ('235', 'system_robots_edit', '1', 'system', '', '0', '1571038279');
INSERT INTO `ey_config` VALUES ('237', 'syn_gb_attribute_showlist', '1', 'syn', '', '0', '1576764161');
INSERT INTO `ey_config` VALUES ('238', 'system_smtp_tpl_5', '1', 'system', '', '0', '1587364685');
INSERT INTO `ey_config` VALUES ('240', 'syn_admin_logic_sms_template', '1', 'syn', '', '0', '1591262356');
INSERT INTO `ey_config` VALUES ('241', 'php_weapp_plugin_open', '1', 'php', '', '0', '1703142166');
INSERT INTO `ey_config` VALUES ('243', 'syn_admin_logic_unlink', '1', 'syn', '', '0', '1591262356');
INSERT INTO `ey_config` VALUES ('244', 'syn_admin_logic_update_basic', '1', 'syn', '', '0', '1591262356');
INSERT INTO `ey_config` VALUES ('245', 'syn_admin_logic_update_tag', '1', 'syn', '', '0', '1591262356');
INSERT INTO `ey_config` VALUES ('246', 'syn_admin_logic_update_arctype', '1', 'syn', '', '0', '1591262356');
INSERT INTO `ey_config` VALUES ('250', 'syn_admin_logic_users_download', '1', 'syn', '', '0', '1602320126');
INSERT INTO `ey_config` VALUES ('251', 'syn_admin_logic_special_addfields', '5', 'syn', '', '0', '1614152870');
INSERT INTO `ey_config` VALUES ('252', 'syn_admin_logic_session_conf', '1', 'syn', '', '0', '1602320145');
INSERT INTO `ey_config` VALUES ('253', 'syn_admin_logic_arctype_topid', '2', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('254', 'syn_admin_logic_arctype_topid2', '1', 'syn', '', '0', '1609929250');
INSERT INTO `ey_config` VALUES ('255', 'web_attr_15', 'demo@admin.com', 'web', '', '0', '1667183901');
INSERT INTO `ey_config` VALUES ('256', 'web_attr_16', '广东省广州市天河区某某科技园', 'web', '', '0', '1609930161');
INSERT INTO `ey_config` VALUES ('257', 'web_attr_17', 'https://update.eyoucms.com/demo/uploads/allimg/20210106/1-2101061T919343.jpg', 'web', '', '0', '1610696352');
INSERT INTO `ey_config` VALUES ('261', 'web_recordnum_mode', '0', 'web', '', '0', '1609930161');
INSERT INTO `ey_config` VALUES ('262', 'thumb_open', '0', 'thumb', '', '0', '1609985492');
INSERT INTO `ey_config` VALUES ('263', 'thumb_mode', '2', 'thumb', '', '0', '1609985492');
INSERT INTO `ey_config` VALUES ('264', 'thumb_color', '#FFFFFF', 'thumb', '', '0', '1609985492');
INSERT INTO `ey_config` VALUES ('265', 'thumb_width', '300', 'thumb', '', '0', '1609985492');
INSERT INTO `ey_config` VALUES ('266', 'thumb_height', '300', 'thumb', '', '0', '1609985492');
INSERT INTO `ey_config` VALUES ('297', 'system_usecodelist', 'ac1cVghSAQVVBlJRBAcAU1dXDVwCWw1aDgcGVAFoEwkGAgYnaS91dFRvJjRDA3UjVwF0J0ABdW1eOCU8MnFmcFR6did+AX90CV06MGEmdDEKW24zT2hsYGxULDAlZVdkM2FqIn4vc20NcDUnU1RjIyBWcDZyTmdvUhUzJzJ1ZmAdRHcgVDd+Yg5VNDNiKlQ0ERp8PAZ8eG9VMwAhMkdjdBJtUj5PCXJ3CWwmJkwDdTMeCWkidlthSUkTMk9VGHBeTllnAWgYaR4VRyhQblNkCwkyWx1tWHJMDzU8Vgx/UlkpAFYLYQdzQCtuNRhFU2VaLwt4ClRyflR1OTINVnxhQhNzYgFIVHdfPGY6C0UTZSYnN2ggYnx2bXhQJjMxeXR0N355LlAadGcncwYjXyJoMAEoYzV1Y2ZvbxICIiVEYGAgQ3IxaSx2ZiB3KCRlHGE6IAZuMwVOdW4IKzM0C35lZSN5djNuN2BxMHwRI1gUYCEgEnsgWFteUU0yVA0tRWtACkZvSU0FCHozZ1IkfDJ4BDQOVkZq', 'system', '', '0', '1713753932');
INSERT INTO `ey_config` VALUES ('375', 'web_shopcomment_switch', '1', 'web', '', '0', '1712996719');
INSERT INTO `ey_config` VALUES ('376', 'web_theme_login_tplname', '', 'web', '', '0', '1712998279');
INSERT INTO `ey_config` VALUES ('377', 'web_theme_style_uptime', '1715589817', 'web', '', '0', '1715589817');
INSERT INTO `ey_config` VALUES ('378', 'web_login_lockopen', '1', 'web', '', '0', '1713075196');
INSERT INTO `ey_config` VALUES ('379', 'web_login_errtotal', '5', 'web', '', '0', '1713075196');
INSERT INTO `ey_config` VALUES ('380', 'web_login_errexpire', '600', 'web', '', '0', '1713075196');
INSERT INTO `ey_config` VALUES ('381', 'web_xss_filter', '0', 'web', '', '0', '1713075196');
INSERT INTO `ey_config` VALUES ('298', 'web_theme_color_model', '1', 'web', '', '0', '1610357887');
INSERT INTO `ey_config` VALUES ('299', 'web_adminlogo', '/public/static/admin/logo/logo_ey.png', 'web', '', '0', '1712998352');
INSERT INTO `ey_config` VALUES ('300', 'web_loginlogo', '/public/static/admin/images/login-logo_ey.png', 'web', '', '0', '1610357887');
INSERT INTO `ey_config` VALUES ('301', 'web_loginbgimg_model', 'custom', 'web', '', '0', '1715325773');
INSERT INTO `ey_config` VALUES ('303', 'web_loginbgimg', '/public/static/admin/loginbg/login-bg-4.png', 'web', '', '0', '1715325773');
INSERT INTO `ey_config` VALUES ('304', 'syn_admin_logic_1608884981', '1', 'syn', '', '0', '1610352406');
INSERT INTO `ey_config` VALUES ('305', 'web_users_tpl_theme', '', 'web', '', '0', '1610352449');
INSERT INTO `ey_config` VALUES ('272', 'php_serviceinfo', 'f104U1MJBAdTVlMIBAUDUFNRWlNXUVVUVl1YBlFLGhEGU0UGDUpdQwoQBhoOFQJTWBsNKVs3BCs0K1RAYAlJPhlaQykBV1huGQsNWQ0PAlNiAA0HRz4EKwpUU3pgflUIGVxYEhFUWHxaXlVZe3gCQkBTXiJ8EDsKGQhQR01dS1ALCXkaOlNScCsICmFQDwJTYg0NUVsuBCsCFkkeUhtSCBReAy8KTQFtFl8oYE5BQXtbCE0uBQoPU1ATT3xbCA0/UXoDAShbQ0UFDRViZFhQQHheGkkUBxcQCwpLU15cXQsQVhRZQWVBDwEAVGRBAgUBAT9NUFRfWjgWUl8ABmxNUgYBVD8WAVIABzoWDQEDAW5EV11UVzoXUlBdAWlCBg9SUG1DVVYBA2sWUgZeAmtCVFdTCUcaRAMRFw1WR1pDX1dBCxQ/FgFWUlY6Fg0GDlFuRFsIA1I6F1AGBgxpQgkOU1NtQ1VQAQxrFlBUDAdrQgcGB145Q1NWVAc5TFNRAAlETxNXFhdRW0UOFQQKFg0VbkRbWgADOhdRUVxfaUIICAAHbUNXBloBaxZfVQ0Ea0ILUAcAOUNRBwVUOUwCBQQAOhYHBVtbZUEBVFJQZEECAFZXP01QAlYGOBYDXwUGEhREAkVHFgZLTUUGFxZdR0MVCBM0CxZfPDoMFARhf1toCzQTU2E2CnZeZlcrGV8EenNwCC9wFl88OgwUBGF/W2gLNBNTYTYKdl5uGSsnW016c3AIL3AWXzw6DBQEYX9baAs0E1NhNgp2Xm5QKxlTTXpzcAg7aVgLRE5GAApdUBUKGkRPE0EGAklEaBMKFl9dWWhdQQZWRwxXTkYTDUlqQkBfFAJVUy8KSkAVWURBFBZHX0JuAlQJWRE9FwYXT1xUVWcJEBMMQUFE', 'php', '', '0', '1728441391');
INSERT INTO `ey_config` VALUES ('352', 'web_status_mode', '0', 'web', '', '0', '1667183867');
INSERT INTO `ey_config` VALUES ('353', 'web_status_text', '商城暂时关闭，维护中……', 'web', '', '0', '1667183867');
INSERT INTO `ey_config` VALUES ('273', 'php_servicemeal', '0', 'php', '', '0', '1728441391');
INSERT INTO `ey_config` VALUES ('274', 'php_servicecode', '', 'php', '', '0', '1728437205');
INSERT INTO `ey_config` VALUES ('278', 'syn_admin_logic_check_oneself', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('279', 'syn_admin_logic_links_group', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('280', 'sms_type', '1', 'sms', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('282', 'syn_admin_logic_1608189503', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('306', 'download_select_servername', 'a:6:{i:0;s:12:\"立即下载\";i:1;s:15:\"本地服务器\";i:2;s:15:\"远程服务器\";i:3;s:12:\"百度网盘\";i:4;s:15:\"七牛云存储\";i:5;s:12:\"腾讯网盘\";}', 'download', '', '0', '1610439420');
INSERT INTO `ey_config` VALUES ('285', 'syn_admin_logic_1608191377', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('286', 'system_paginate_pagesize', '50', 'system', '', '0', '1715308488');
INSERT INTO `ey_config` VALUES ('287', 'web_theme_color', '#3398cc', 'web', '', '0', '1610357887');
INSERT INTO `ey_config` VALUES ('288', 'web_assist_color', '#2189be', 'web', '', '0', '1610357887');
INSERT INTO `ey_config` VALUES ('294', 'syn_admin_logic_1609039608', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('295', 'syn_admin_logic_1609291091', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('296', 'admin_logic_1610086647', '1', 'syn', '', '0', '1610334638');
INSERT INTO `ey_config` VALUES ('307', 'web_mobile_domain_open', '0', 'web', '', '0', '1610585089');
INSERT INTO `ey_config` VALUES ('308', 'web_login_expiretime', '36000', 'web', '', '0', '1713075196');
INSERT INTO `ey_config` VALUES ('309', 'web_tpl_theme', '', 'web', '', '0', '1610585089');
INSERT INTO `ey_config` VALUES ('310', 'syn_admin_logic_video_addfields_2', '1', 'syn', '', '0', '1614152870');
INSERT INTO `ey_config` VALUES ('311', 'syn_admin_logic_1608884981_2', '1', 'syn', '', '0', '1614152870');
INSERT INTO `ey_config` VALUES ('312', 'basic_indexname', '首页', 'basic', '', '0', '1614152874');
INSERT INTO `ey_config` VALUES ('313', 'basic_img_style_wh', '0', 'basic', '', '0', '1614152874');
INSERT INTO `ey_config` VALUES ('314', 'max_filesize', '50', 'basic', '', '0', '1718964306');
INSERT INTO `ey_config` VALUES ('315', 'max_sizeunit', 'MB', 'basic', '', '0', '1614152874');
INSERT INTO `ey_config` VALUES ('316', 'other_arcclick', '500|1000', 'other', '', '0', '1614152874');
INSERT INTO `ey_config` VALUES ('317', 'other_arcdownload', '100|500', 'other', '', '0', '1614152874');
INSERT INTO `ey_config` VALUES ('318', 'syn_admin_logic_balance_pay', '1', 'syn', '', '0', '1616460912');
INSERT INTO `ey_config` VALUES ('319', 'syn_admin_logic_1610086648', '1', 'syn', '', '0', '1616460912');
INSERT INTO `ey_config` VALUES ('320', 'syn_admin_logic_1614829120', '1', 'syn', '', '0', '1616460912');
INSERT INTO `ey_config` VALUES ('321', 'syn_admin_logic_1616123192', '1', 'syn', '', '0', '1616460912');
INSERT INTO `ey_config` VALUES ('322', 'syn_admin_logic_1614829121', '1', 'syn', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('323', 'syn_admin_logic_ask_answer_like', '1', 'syn', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('324', 'syn_admin_logic_archives_1618279798', '1', 'syn', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('325', 'syn_admin_logic_1623036205', '1', 'syn', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('326', 'admin_logic_1623055490', '1', 'syn', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('327', 'system_use_language', '0', 'system', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('328', 'admin_logic_1623133485', '1', 'syn', '', '0', '1623322108');
INSERT INTO `ey_config` VALUES ('329', 'recycle_switch', '1', 'web', '', '0', '1623809302');
INSERT INTO `ey_config` VALUES ('330', 'seo_rewrite_view_format', '1', 'seo', '', '0', '1623809665');
INSERT INTO `ey_config` VALUES ('332', 'seo_uphtml_after_home', '0', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('333', 'seo_uphtml_after_channel', '1', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('334', 'seo_uphtml_after_pernext', '1', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('335', 'seo_html_templet', 'index.htm', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('336', 'seo_html_position', '../index.html', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('337', 'seo_showmod', '1', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('338', 'seo_maxpagesize', '50', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('339', 'seo_upnext', '1', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('340', 'seo_pagesize', '20', 'seo', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('341', 'basic_img_auto_wh', '0', 'basic', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('342', 'basic_img_alt', '0', 'basic', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('343', 'basic_img_title', '0', 'basic', '', '0', '1641949807');
INSERT INTO `ey_config` VALUES ('344', 'system_crypt_auth_code', '$2y$11$f9f3871eb36b3e26f259f28', 'system', '', '0', '1650263716');
INSERT INTO `ey_config` VALUES ('345', 'web_citysite_open', '0', 'web', '', '0', '1703142363');
INSERT INTO `ey_config` VALUES ('346', 'admin_logic_1_1648775669', '1', 'syn', '', '0', '1650263716');
INSERT INTO `ey_config` VALUES ('347', 'web_stypeid_open', '0', 'web', '', '0', '1653359674');
INSERT INTO `ey_config` VALUES ('348', 'web_status_url', '', 'web', '', '0', '1653359786');
INSERT INTO `ey_config` VALUES ('349', 'web_status_tpl', '', 'web', '', '0', '1713153676');
INSERT INTO `ey_config` VALUES ('350', 'web_garecordnum', '', 'web', '', '0', '1719997608');
INSERT INTO `ey_config` VALUES ('351', 'web_garecordnum_mode', '0', 'web', '', '0', '1653359786');
INSERT INTO `ey_config` VALUES ('355', 'editor_select', '1', 'basic', '', '0', '1675389691');
INSERT INTO `ey_config` VALUES ('356', 'editor_remote_img_local', '1', 'basic', '', '0', '1675389691');
INSERT INTO `ey_config` VALUES ('357', 'editor_img_clear_link', '1', 'basic', '', '0', '1675389691');
INSERT INTO `ey_config` VALUES ('358', 'php_allow_service_os', '', 'php', '', '0', '1728437205');
INSERT INTO `ey_config` VALUES ('419', 'system_explanation_welcome_2', '1', 'system', '', '0', '1728441355');
INSERT INTO `ey_config` VALUES ('367', 'absolute_path_open', '0', 'web', '', '0', '1701048818');
INSERT INTO `ey_config` VALUES ('364', 'php_upgradelist', '', 'php', '', '0', '1690161726');
INSERT INTO `ey_config` VALUES ('359', 'php_atqueryrequest', 'W3siZXhwaXJlX3RpbWUiOjQ4Mzg0MDB9LHsiZXhwaXJlX3RpbWUiOjYzMDcyMDB9LHsiZXhwaXJlX3RpbWUiOjY3MzkyMDB9XQ==', 'php', '', '0', '1728441391');
INSERT INTO `ey_config` VALUES ('360', 'php_atqueryrequest_time', '0', 'php', '', '0', '1728441554');
INSERT INTO `ey_config` VALUES ('361', 'search_tabu_words', '<\r\n>\r\n\"\r\n;\r\n,\r\n@\r\n&\r\n#\r\n\\\r\n*', 'search', '', '0', '1686877656');
INSERT INTO `ey_config` VALUES ('362', 'web_anti_brushing', '0', 'web', '', '0', '1686877656');
INSERT INTO `ey_config` VALUES ('363', 'php_atqueryrequest_time2', '0', 'php', '', '0', '1713747132');
INSERT INTO `ey_config` VALUES ('365', 'web_theme_styleid', '1', 'web', '', '0', '1715326369');
INSERT INTO `ey_config` VALUES ('368', 'seo_uphtml_after_home13', '0', 'seo', '', '0', '1721100370');
INSERT INTO `ey_config` VALUES ('369', 'seo_uphtml_after_channel13', '0', 'seo', '', '0', '1721100370');
INSERT INTO `ey_config` VALUES ('370', 'seo_uphtml_after_pernext13', '0', 'seo', '', '0', '1721100370');
INSERT INTO `ey_config` VALUES ('371', 'seo_uphtml_editafter_home', '0', 'seo', '', '0', '1706510953');
INSERT INTO `ey_config` VALUES ('372', 'seo_uphtml_editafter_channel', '0', 'seo', '', '0', '1706510953');
INSERT INTO `ey_config` VALUES ('373', 'seo_uphtml_editafter_pernext', '1', 'seo', '', '0', '1706510953');
INSERT INTO `ey_config` VALUES ('374', 'web_theme_welcome_tplname', 'welcome_shop.htm', 'web', '', '0', '1713314657');
INSERT INTO `ey_config` VALUES ('382', 'basic_update_seo_description', '0', 'basic', '', '0', '1713495920');
INSERT INTO `ey_config` VALUES ('383', 'web_intro', '', 'web', '', '0', '1714095052');
INSERT INTO `ey_config` VALUES ('384', 'web_status_pc', '0', 'web', '', '0', '1728443621');
INSERT INTO `ey_config` VALUES ('385', 'web_status_pc_mode', '1', 'web', '', '0', '1667183867');
INSERT INTO `ey_config` VALUES ('386', 'web_status_pc_text', 'PC端商城暂时关闭，维护中……', 'web', '', '0', '1667183867');
INSERT INTO `ey_config` VALUES ('387', 'web_status_pc_url', '/', 'web', '', '0', '1653359786');
INSERT INTO `ey_config` VALUES ('388', 'web_status_pc_tpl', '/public/close.html', 'web', '', '0', '1713153676');
INSERT INTO `ey_config` VALUES ('389', 'web_status_h5', '0', 'web', '', '0', '1719819272');
INSERT INTO `ey_config` VALUES ('390', 'web_status_h5_text', '商城已打烊……', 'web', '', '0', '1667183867');
INSERT INTO `ey_config` VALUES ('391', 'web_status_gzh', '0', 'web', '', '0', '1715128991');
INSERT INTO `ey_config` VALUES ('392', 'sms_appkey', '', 'sms', '', '0', '1714122960');
INSERT INTO `ey_config` VALUES ('393', 'sms_secretkey', '', 'sms', '', '0', '1714122960');
INSERT INTO `ey_config` VALUES ('394', 'sms_test_mobile', '', 'sms', '', '0', '1719302095');
INSERT INTO `ey_config` VALUES ('397', 'smtp_server', '', 'smtp', '', '0', '1721275609');
INSERT INTO `ey_config` VALUES ('398', 'smtp_port', '', 'smtp', '', '0', '1721275609');
INSERT INTO `ey_config` VALUES ('399', 'smtp_user', '', 'smtp', '', '0', '1721275609');
INSERT INTO `ey_config` VALUES ('400', 'smtp_pwd', '', 'smtp', '', '0', '1721275609');
INSERT INTO `ey_config` VALUES ('401', 'smtp_from_eamil', '', 'smtp', '', '0', '1721275609');
INSERT INTO `ey_config` VALUES ('402', 'web_theme_css_tplname', 'css_1.css', 'web', '', '0', '1715326369');
INSERT INTO `ey_config` VALUES ('406', 'web_phone', '400-1234567', 'web', '', '0', '1719997608');
INSERT INTO `ey_config` VALUES ('403', 'editor_bdmap_ak', '', 'basic', '', '0', '1718964306');
INSERT INTO `ey_config` VALUES ('404', 'basic_body_allowurls', '', 'basic', '', '0', '1718964306');
INSERT INTO `ey_config` VALUES ('405', 'basic_img_alt_force', '0', 'basic', '', '0', '1718964306');
INSERT INTO `ey_config` VALUES ('409', 'pc_web_attr_3', '', 'pc', '', '0', '0');
INSERT INTO `ey_config` VALUES ('410', 'pc_web_attr_4', '', 'pc', '', '0', '0');
INSERT INTO `ey_config` VALUES ('411', 'pc_web_attr_5', '', 'pc', '', '0', '0');
INSERT INTO `ey_config` VALUES ('412', 'pc_web_attr_6', '', 'pc', '', '0', '0');
INSERT INTO `ey_config` VALUES ('413', 'pc_web_attr_7', '', 'pc', '', '0', '0');
INSERT INTO `ey_config` VALUES ('416', 'web_navigation_switch', '1', 'web', '', '0', '1720164332');
INSERT INTO `ey_config` VALUES ('414', 'web_pc_name', '45°C SHOP', 'web', '', '0', '1722933467');
INSERT INTO `ey_config` VALUES ('415', 'web_pc_logo', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240723/1-240H3093141J8.png', 'web', '', '0', '1722933174');
INSERT INTO `ey_config` VALUES ('417', 'seo_title_symbol', '-', 'seo', '', '0', '1721100370');
INSERT INTO `ey_config` VALUES ('418', 'web_adminico', '/favicon.ico', 'web', '', '0', '1721877270');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) NOT NULL DEFAULT '' COMMENT '变量分组',
  `type_id` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '自定义变量分组表ID',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `system_field` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否系统字段，1=系统字段，0=自定义字段',
  `release_field` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否发布使用字段，1=发布使用，0=未发布使用',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='自定义变量表';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('1', 'web', '1', '网站简称', 'web_pc_name', '0', '1', '1', '1', '1719567669', '1719567669');
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '1', '网站LOGO', 'web_pc_logo', '3', '1', '1', '2', '1719567669', '1719567669');
INSERT INTO `ey_config_attribute` VALUES ('3', 'web', '1', '地址栏图标', 'web_ico', '3', '1', '1', '3', '1719567669', '1719567669');
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '1', '网站网址', 'web_basehost', '0', '1', '1', '4', '1719567669', '1719567669');
INSERT INTO `ey_config_attribute` VALUES ('5', 'web', '1', '版权信息', 'web_copyright', '0', '1', '1', '5', '1719567669', '1719567669');
INSERT INTO `ey_config_attribute` VALUES ('6', 'web', '1', '备案号', 'web_recordnum', '0', '1', '1', '6', '1719567669', '1719567669');
INSERT INTO `ey_config_attribute` VALUES ('7', 'web', '1', '公安备案号', 'web_garecordnum', '0', '1', '1', '7', '1719567669', '1719567669');

-- -----------------------------
-- Table structure for `ey_config_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_type`;
CREATE TABLE `ey_config_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) DEFAULT '' COMMENT '分组名称',
  `status` tinyint(1) DEFAULT '1',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义变量分组表';

-- -----------------------------
-- Records of `ey_config_type`
-- -----------------------------
INSERT INTO `ey_config_type` VALUES ('1', '默认分组', '1', '1650271499', '1650271499', '100');

-- -----------------------------
-- Table structure for `ey_ddos_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ddos_log`;
CREATE TABLE `ey_ddos_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5key` varchar(50) DEFAULT '' COMMENT 'md5值',
  `file_name` varchar(500) DEFAULT '' COMMENT '文件名',
  `file_num` int(10) DEFAULT '0' COMMENT '已扫描数',
  `file_total` int(10) DEFAULT '0' COMMENT '总文件数',
  `file_num_ky` int(10) DEFAULT '0' COMMENT '可疑恶意文件数',
  `is_suspicious` tinyint(1) DEFAULT '0' COMMENT '是否可疑',
  `html` text,
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ddos查杀进度记录表';


-- -----------------------------
-- Table structure for `ey_discount_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active`;
CREATE TABLE `ey_discount_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_name` varchar(255) DEFAULT '' COMMENT '活动名称',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '活动开始时间',
  `end_date` int(11) DEFAULT '0' COMMENT '活动结束时间',
  `limit_type` tinyint(3) unsigned DEFAULT '1' COMMENT '限购类型 1-不限购,2-活动期内每人最多购买n件,3-活动期内每人每天最多购买n件',
  `limit` int(11) unsigned DEFAULT '0' COMMENT '限购数量',
  `preheat` tinyint(3) DEFAULT '0' COMMENT '是否开启预热 0-关闭 1-开启',
  `preheat_time` int(11) DEFAULT '0' COMMENT '预热时间,不能大于开启时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场表';


-- -----------------------------
-- Table structure for `ey_discount_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active_goods`;
CREATE TABLE `ey_discount_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `discount_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_discount_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_goods`;
CREATE TABLE `ey_discount_goods` (
  `discount_gid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '限时折扣商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `discount_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限时折扣商品库存总量',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`discount_gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-商品表';


-- -----------------------------
-- Table structure for `ey_download_attr_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_attr_field`;
CREATE TABLE `ey_download_attr_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `field_name` varchar(32) DEFAULT '' COMMENT '字段名称',
  `field_title` varchar(32) DEFAULT '' COMMENT '字段标题',
  `field_use` tinyint(1) DEFAULT '0' COMMENT '字段是否使用，0未使用，1为使用',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='上传文件属性表';

-- -----------------------------
-- Records of `ey_download_attr_field`
-- -----------------------------
INSERT INTO `ey_download_attr_field` VALUES ('1', 'extract_code', '提取码', '1', '1', '1561001807', '1561024954');
INSERT INTO `ey_download_attr_field` VALUES ('2', 'server_name', '服务器名称', '1', '2', '1561001807', '1561078673');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载附加表';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `extract_code` varchar(20) DEFAULT '' COMMENT '文件提取码',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `server_name` varchar(200) DEFAULT '' COMMENT '服务器名称',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `is_remote` tinyint(1) DEFAULT '0' COMMENT '是否远程',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载附件表';


-- -----------------------------
-- Table structure for `ey_download_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_log`;
CREATE TABLE `ey_download_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '附件ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载记录表';


-- -----------------------------
-- Table structure for `ey_download_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_order`;
CREATE TABLE `ey_download_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('region', '区域类型', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('file', '附件类型', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('media', '多媒体类型', '0', '11', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_foreign_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_foreign_pack`;
CREATE TABLE `ey_foreign_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type` int(4) DEFAULT '0' COMMENT '分类：1=列表，2=留言',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COMMENT='外贸助手语言包变量';

-- -----------------------------
-- Records of `ey_foreign_pack`
-- -----------------------------
INSERT INTO `ey_foreign_pack` VALUES ('1', '1', 'page1', '首页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('2', '1', 'page2', '上一页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('3', '1', 'page3', '下一页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('4', '1', 'page4', '末页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('5', '1', 'page5', '共<strong>%s</strong>页 <strong>%s</strong>条', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('6', '1', 'page1', 'Home', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('7', '1', 'page2', 'Pre', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('8', '1', 'page3', 'Next', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('9', '1', 'page4', 'Last', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('10', '1', 'page5', 'Road <strong>%s</strong> page <strong>%s</strong> strip', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('11', '2', 'gbook1', '操作成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('12', '2', 'gbook1', 'success', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('14', '2', 'gbook2', 'The same IP cannot be submitted repeatedly within %s seconds!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('13', '2', 'gbook2', '同一个IP在%s秒之内不能重复提交！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('15', '2', 'gbook3', '%s不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('16', '2', 'gbook3', '%s Cannot be empty!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('17', '2', 'gbook4', '%s格式不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('18', '2', 'gbook4', '%s Incorrect format!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('19', '2', 'gbook5', '图片验证码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('20', '2', 'gbook5', 'Picture verification code cannot be empty!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('21', '2', 'gbook6', '图片验证码不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('22', '2', 'gbook6', 'The picture verification code is incorrect!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('23', '2', 'gbook7', '请输入手机号码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('24', '2', 'gbook7', 'Please enter your mobile number!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('25', '2', 'gbook8', '手机号码和手机验证码不一致，请重新输入！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('26', '2', 'gbook8', 'Mobile phone number and mobile phone verification code are inconsistent, please re-enter!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('27', '2', 'gbook9', '手机验证码已被使用或超时，请重新发送！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('28', '2', 'gbook9', 'The mobile phone verification code has been used or timed out. Please resend it!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('29', '2', 'gbook10', '请输入手机验证码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('30', '2', 'gbook10', 'Please enter the mobile phone verification code!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('31', '2', 'gbook11', '表单缺少标签属性{$field.hidden}', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('32', '2', 'gbook11', 'The form is missing label attribute {$field.hidden}', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('33', '2', 'gbook12', '页面自动 %s跳转%s 等待时间：', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('34', '2', 'gbook12', 'Page automatic %sjump%s waiting time：', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('35', '2', 'gbook13', '%s至少选择一项！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('36', '2', 'gbook13', 'Select at least one item to %s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('37', '2', 'gbook14', '请选择%s', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('38', '2', 'gbook14', 'Please select %s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('39', '2', 'gbook15', '请输入正确的手机号码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('40', '2', 'gbook15', 'Please enter the correct mobile number！', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('41', '2', 'gbook16', '图片验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('42', '2', 'gbook16', 'Picture verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('43', '2', 'gbook17', '手机验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('44', '2', 'gbook17', 'Mobile verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('45', '2', 'gbook18', '获取验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('46', '2', 'gbook18', 'Get verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('47', '2', 'gbook19', '看不清？点击更换验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('48', '2', 'gbook19', 'Can\'t see clearly? Click to change the verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('49', '2', 'gbook20', '看不清？%s点击更换%s', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('50', '2', 'gbook20', 'Can\'t see clearly? %sClick to replace%s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('51', '1', 'page6', '第%s页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('52', '1', 'page6', '%s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('53', '3', 'system1', '图', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('54', '3', 'system1', 'pic', 'en', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_form`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form`;
CREATE TABLE `ey_form` (
  `form_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增表单ID',
  `form_name` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `intro` text NOT NULL COMMENT '表单描述，预留',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '表单状态，0关闭，1开启',
  `attr_auto` tinyint(1) DEFAULT '0' COMMENT '自动标签：0=否，1=是',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `open_reply` tinyint(1) DEFAULT '0' COMMENT '是否开启回复 0-未开启,1-开启',
  `open_examine` tinyint(1) DEFAULT '0' COMMENT '是否开启审核 0-不审核,1-审核',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单管理表';


-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID/表单ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `is_read` tinyint(1) DEFAULT '0' COMMENT '0=未读，1=已读',
  `is_star` tinyint(1) DEFAULT '0' COMMENT '标记星号',
  `source` tinyint(1) DEFAULT '0' COMMENT '提交来源：1=电脑端，2=手机端',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `reply` varchar(1000) DEFAULT '' COMMENT '留言回复内容',
  `admin_id` int(11) DEFAULT '0' COMMENT '回复管理员ID',
  `reply_time` int(11) DEFAULT '0' COMMENT '回复时间',
  `examine` tinyint(1) DEFAULT '1' COMMENT '0-未审核 1-审核通过 2-审核不通过',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言主表';


-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';


-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID/表单ID',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `is_showlist` tinyint(1) DEFAULT '0' COMMENT '在列表显示 0=隐藏，1=显示',
  `required` tinyint(1) DEFAULT '0' COMMENT '必填 0=否，1=是',
  `validate_type` smallint(5) DEFAULT '0' COMMENT '验证格式，0=不验证，1=手机，2=Email',
  `real_validate` tinyint(1) unsigned DEFAULT '0' COMMENT '是否进行真实验证，0=不验证，1=真实验证',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表单属性';


-- -----------------------------
-- Table structure for `ey_gzh_keyword`
-- -----------------------------
DROP TABLE IF EXISTS `ey_gzh_keyword`;
CREATE TABLE `ey_gzh_keyword` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `material_id` varchar(1000) DEFAULT '' COMMENT '素材ID',
  `rule` varchar(255) DEFAULT '' COMMENT '规则名称',
  `text_count` int(11) DEFAULT '0' COMMENT '文字素材数量,与图片素材数量相加=material_id数量',
  `pic_count` int(11) DEFAULT '0' COMMENT '图片素材数量,与文字素材数量相加=material_id数量',
  `keywords` varchar(1000) DEFAULT '' COMMENT '关键词规则名称',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信公众号-关键字回复-表';


-- -----------------------------
-- Table structure for `ey_gzh_material`
-- -----------------------------
DROP TABLE IF EXISTS `ey_gzh_material`;
CREATE TABLE `ey_gzh_material` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `parent_id` int(11) DEFAULT '0' COMMENT 'type=2时使用',
  `type` tinyint(2) DEFAULT '1' COMMENT '1-文字,2-图文',
  `title` varchar(100) DEFAULT '' COMMENT '标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '封面图片',
  `show_cover_pic` tinyint(1) DEFAULT '0' COMMENT '封面显示在正文,0-否 1-显示',
  `intro` text COMMENT '简介',
  `author` varchar(55) DEFAULT '' COMMENT '作者',
  `original_url` varchar(500) DEFAULT '' COMMENT '原文链接',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `thumb_media_id` varchar(255) DEFAULT '' COMMENT '缩略图的media_id',
  `wx_img_url` varchar(255) DEFAULT NULL COMMENT '缩略图的图片URL(素材接口返回)',
  `media_id` varchar(255) DEFAULT '' COMMENT '素材ID',
  `publish_id` varchar(100) DEFAULT '' COMMENT '发布任务id',
  `publish_status` tinyint(3) DEFAULT '1' COMMENT '发布状态，0:成功, 1:发布中，2:原创失败, 3: 常规失败, 4:平台审核不通过, 5:成功后用户删除所有文章, 6: 成功后系统封禁所有文章',
  `article_id` varchar(100) DEFAULT '' COMMENT '当发布状态为0时（即成功）时，返回图文的 article_id，可用于“客服消息”场景',
  `article_url` varchar(255) DEFAULT '' COMMENT '当发布状态为0时（即成功）时，返回图文的永久链接',
  `errmsg` varchar(500) DEFAULT '' COMMENT '发布失败返回错误信息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信公众号-消息素材-表';


-- -----------------------------
-- Table structure for `ey_gzh_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_gzh_menu`;
CREATE TABLE `ey_gzh_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `level` tinyint(1) DEFAULT '1' COMMENT '菜单级别,1-一级菜单,2-二级菜单',
  `pid` int(11) DEFAULT '0' COMMENT '父级ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `title` varchar(20) DEFAULT '' COMMENT '关键词',
  `type` varchar(30) DEFAULT '0' COMMENT '类型',
  `material_id` int(11) DEFAULT '0' COMMENT '素材ID,type=sendmsg时用',
  `jump_url` varchar(255) DEFAULT '' COMMENT '跳转链接,type=view时用',
  `key` varchar(128) DEFAULT '' COMMENT '关键词,type=click时用',
  `url` varchar(255) DEFAULT '' COMMENT '网页链接,type=miniprogram时用',
  `appid` varchar(55) DEFAULT '' COMMENT '小程序appid,type=miniprogram时用',
  `path` varchar(55) DEFAULT '' COMMENT '小程序跳转页面链接,type=miniprogram时用',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信公众号-关键字回复-表';


-- -----------------------------
-- Table structure for `ey_gzh_subscribe`
-- -----------------------------
DROP TABLE IF EXISTS `ey_gzh_subscribe`;
CREATE TABLE `ey_gzh_subscribe` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `text` text COMMENT '回复内容',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `type` varchar(20) DEFAULT '' COMMENT '回复类型 LINK-链接,TEXT-文本,PIC-图文,ARC-站内文档',
  `aid` int(11) DEFAULT '0' COMMENT '站内文档ID',
  `material_id` int(11) DEFAULT '0' COMMENT '素材ID',
  `appid` varchar(50) DEFAULT '' COMMENT '公众号标识',
  `keyword` varchar(255) DEFAULT '' COMMENT '关键词',
  `link` varchar(100) DEFAULT '' COMMENT '链接',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信公众号-回复-表';


-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图集附加表';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图集图片表';


-- -----------------------------
-- Table structure for `ey_label_types`
-- -----------------------------
DROP TABLE IF EXISTS `ey_label_types`;
CREATE TABLE `ey_label_types` (
  `types_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `types_value` tinyint(1) NOT NULL DEFAULT '0' COMMENT '标签类型值(1=营销标签 2=服务标签)',
  `types_names` varchar(200) NOT NULL DEFAULT '' COMMENT '标签类型名称',
  `types_intro` varchar(1000) NOT NULL DEFAULT '' COMMENT '标签类型描述',
  `sort_order` int(11) NOT NULL DEFAULT '100' COMMENT '排序号',
  `selected` tinyint(1) DEFAULT '0' COMMENT '默认勾选：0=否，1=是',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1启用 2禁用)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`types_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1011 DEFAULT CHARSET=utf8mb4 COMMENT='标签类型表';

-- -----------------------------
-- Records of `ey_label_types`
-- -----------------------------
INSERT INTO `ey_label_types` VALUES ('1001', '2', '货到付款', '支持送货上门后在收款，支持现金、POS机刷卡等方式', '100', '1', '1', '1662715057', '1665973566');
INSERT INTO `ey_label_types` VALUES ('1002', '2', '闪电退款', '闪电退款为会员提供快速退款服务', '100', '0', '1', '1662715057', '1662715057');
INSERT INTO `ey_label_types` VALUES ('1003', '2', '7天无理由退货', '支持7天无理由退货(拆封后不支持)', '100', '1', '1', '1662715057', '1665973553');
INSERT INTO `ey_label_types` VALUES ('5', '1', '新品', '', '100', '0', '1', '1662715057', '1662715057');
INSERT INTO `ey_label_types` VALUES ('4', '1', '热卖', '', '100', '0', '1', '1662715057', '1662715057');
INSERT INTO `ey_label_types` VALUES ('3', '1', '抢购', '', '100', '0', '1', '1662715057', '1666834221');
INSERT INTO `ey_label_types` VALUES ('1', '1', '推荐', '', '100', '0', '1', '1663297618', '1666834220');
INSERT INTO `ey_label_types` VALUES ('1004', '2', '运费险', '卖家为您购买的商品投保退货运费险（保单生效以确认订单页展示的运费险为准）', '100', '1', '1', '1663297643', '1666161574');
INSERT INTO `ey_label_types` VALUES ('2', '1', '爆款', '', '100', '0', '1', '1663297603', '1664525399');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `groupid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '分组id， 默认分组值为1',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `nofollow` tinyint(1) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('6', '2', '1', '阿里云', 'https://www.aliyun.com/', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240726/1-240H6143Q1531.png', '100', '1', '1', '', '', '1', '0', '1722302722', '1722302722');
INSERT INTO `ey_links` VALUES ('5', '2', '1', '淘宝', 'https://www.taobao.com/', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240726/1-240H6143FRL.png', '100', '1', '1', '', '', '1', '0', '1721975831', '1721975831');
INSERT INTO `ey_links` VALUES ('7', '2', '1', '天猫', 'https://www.tmall.com/', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240726/1-240H614512GC.png', '100', '1', '1', '', '', '1', '0', '1722302727', '1722302727');
INSERT INTO `ey_links` VALUES ('8', '2', '1', '支付宝', 'https://www.alipay.com/', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240726/1-240H6145309217.png', '100', '1', '1', '', '', '1', '0', '1722302735', '1722302735');
INSERT INTO `ey_links` VALUES ('9', '2', '1', '京东', 'https://www.jd.com/', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240730/1-240I0092511293.png', '100', '1', '1', '', '', '1', '0', '1722302717', '1722302717');
INSERT INTO `ey_links` VALUES ('10', '2', '1', '腾讯', 'https://www.tencent.com/', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240730/1-240I009291J43.png', '100', '1', '1', '', '', '1', '0', '1722302962', '1722302962');

-- -----------------------------
-- Table structure for `ey_links_group`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links_group`;
CREATE TABLE `ey_links_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '' COMMENT '分组名称',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='友情链接分组';

-- -----------------------------
-- Records of `ey_links_group`
-- -----------------------------
INSERT INTO `ey_links_group` VALUES ('1', '默认分组', '1', '100', '1610334638', '1610334638');

-- -----------------------------
-- Table structure for `ey_media_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_content`;
CREATE TABLE `ey_media_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `courseware` varchar(200) NOT NULL DEFAULT '' COMMENT '课件地址',
  `courseware_free` enum('免费','收费') NOT NULL DEFAULT '免费' COMMENT '课件收费',
  `total_duration` int(10) NOT NULL DEFAULT '0' COMMENT '视频总时长',
  `total_video` int(10) NOT NULL DEFAULT '0' COMMENT '视频数',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附加表';


-- -----------------------------
-- Table structure for `ey_media_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_file`;
CREATE TABLE `ey_media_file` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '视频模型文件表',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文档标题',
  `file_name` varchar(200) NOT NULL DEFAULT '' COMMENT '文件名称',
  `file_title` varchar(200) NOT NULL DEFAULT '' COMMENT '选集标题',
  `file_url` text NOT NULL COMMENT '存储路径',
  `file_time` int(8) NOT NULL DEFAULT '0' COMMENT '文件时长',
  `file_ext` varchar(50) NOT NULL DEFAULT '' COMMENT '文件后缀名',
  `file_size` varchar(255) NOT NULL DEFAULT '' COMMENT '文件大小',
  `file_mime` varchar(200) NOT NULL DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) NOT NULL DEFAULT '' COMMENT '自定义的一种加密方式，用于视频播放的权限验证',
  `md5file` varchar(200) NOT NULL DEFAULT '' COMMENT 'md5_file加密，可以检测上传/播放的视频文件是否损坏',
  `is_remote` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否远程 1-远程',
  `playcount` int(10) NOT NULL DEFAULT '0' COMMENT '播放次数',
  `gratis` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否试看，0不试看，1试看',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附件表';


-- -----------------------------
-- Table structure for `ey_media_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_log`;
CREATE TABLE `ey_media_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '视频ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频日志表';


-- -----------------------------
-- Table structure for `ey_media_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_order`;
CREATE TABLE `ey_media_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '媒体订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频订单表';


-- -----------------------------
-- Table structure for `ey_media_play_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_play_record`;
CREATE TABLE `ey_media_play_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `aid` int(10) DEFAULT '0' COMMENT '课程id',
  `file_id` int(10) DEFAULT '0' COMMENT '文件id',
  `play_time` int(10) DEFAULT '0' COMMENT '播放时间',
  `add_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频播放时长表';


-- -----------------------------
-- Table structure for `ey_memgift`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgift`;
CREATE TABLE `ey_memgift` (
  `gift_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '礼品列表',
  `type` tinyint(3) NOT NULL DEFAULT '1' COMMENT '-1-实物,2-会员产品',
  `type_id` int(10) DEFAULT '0' COMMENT '类型为会员产品时的会员产品类型(users_type_manage)type_id',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所需积分',
  `litpic` varchar(250) NOT NULL DEFAULT '',
  `giftname` varchar(60) NOT NULL DEFAULT '',
  `num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '兑换次数',
  `content` longtext COMMENT '礼品详情',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存总数',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0-正常,1-删除',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '礼品状态：1=显示，0=隐藏',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='礼品兑换表';


-- -----------------------------
-- Table structure for `ey_memgiftget`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgiftget`;
CREATE TABLE `ey_memgiftget` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `giftname` char(60) NOT NULL DEFAULT '',
  `gift_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '礼品ID',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `users_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态,0-待发货,1-已发货,2-退回,3-重发',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(55) NOT NULL DEFAULT '' COMMENT '手机',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `type_id` int(11) DEFAULT '0' COMMENT '兑换会员产品时,会员产品套餐(表::users_type_manage)type_id',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='礼品兑换记录表';


-- -----------------------------
-- Table structure for `ey_nav_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_list`;
CREATE TABLE `ey_nav_list` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '导航ID',
  `host_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告链接分组ID',
  `link_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '内置商城链接ID or 系统商品分类ID or 系统商品ID',
  `nav_name` varchar(200) NOT NULL DEFAULT '' COMMENT '导航名称',
  `parent_id` int(10) NOT NULL DEFAULT '0' COMMENT '上级菜单id',
  `topid` int(10) NOT NULL DEFAULT '0' COMMENT '顶级菜单id',
  `en_name` varchar(200) NOT NULL DEFAULT '' COMMENT '英文名称',
  `nav_url` varchar(200) NOT NULL DEFAULT '' COMMENT '导航链接',
  `position_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航位置',
  `arctype_sync` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否与栏目同步',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '同步栏目的ID',
  `nav_pic` varchar(255) NOT NULL DEFAULT '' COMMENT '导航图片',
  `is_remote` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否远程图片',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否打开新窗口，1=是，0=否',
  `nofollow` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用nofollow，1=是，0=否',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '启用 (1=正常，0=停用)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nav_id`),
  KEY `position_id` (`position_id`) USING BTREE,
  KEY `type_id` (`type_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='导航列表';

-- -----------------------------
-- Records of `ey_nav_list`
-- -----------------------------
INSERT INTO `ey_nav_list` VALUES ('1', '1', '1', '首页', '0', '0', '', 'web_cmsurl', '2', '0', '0', '', '0', '0', '0', '1', '0', '100', '1720166615', '1721705537');
INSERT INTO `ey_nav_list` VALUES ('13', '2', '6', '会员中心', '0', '0', '', '', '2', '0', '0', '', '0', '0', '0', '1', '0', '100', '1721705622', '1721705622');
INSERT INTO `ey_nav_list` VALUES ('12', '1', '2', '购物车', '0', '0', '', '', '2', '0', '0', '', '0', '0', '0', '1', '0', '100', '1721705603', '1721705603');
INSERT INTO `ey_nav_list` VALUES ('11', '1', '22', '全部商品', '0', '0', '', '', '2', '0', '0', '', '0', '0', '0', '1', '0', '100', '1721705527', '1721725131');

-- -----------------------------
-- Table structure for `ey_nav_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_position`;
CREATE TABLE `ey_nav_position` (
  `position_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '导航列表ID',
  `position_name` varchar(200) DEFAULT '' COMMENT '导航列表名称',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`position_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='导航位置表';

-- -----------------------------
-- Records of `ey_nav_position`
-- -----------------------------
INSERT INTO `ey_nav_position` VALUES ('1', 'PC端主导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('2', 'PC端顶部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('3', 'PC端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('4', 'PC端底部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('5', '移动端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('6', '移动端底部导航', '100', '0', '0', '1624861478');

-- -----------------------------
-- Table structure for `ey_notice_send`
-- -----------------------------
DROP TABLE IF EXISTS `ey_notice_send`;
CREATE TABLE `ey_notice_send` (
  `send_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `service_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '售后ID',
  `send_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '发送类型 (1:微信公众号; 2:手机号码; 3:电子邮箱;)',
  `send_scene` varchar(10) NOT NULL DEFAULT '' COMMENT '发送场景',
  `send_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送状态 (0:未发送; 1:已发送;)',
  `send_result` varchar(255) NOT NULL DEFAULT '' COMMENT '发送结果',
  `send_content` text COMMENT '发送内容',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`send_id`),
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `service_id` (`service_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='通知发送记录表';


-- -----------------------------
-- Table structure for `ey_pay_api_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_pay_api_config`;
CREATE TABLE `ey_pay_api_config` (
  `pay_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付接口配置ID，自增',
  `pay_name` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置名称，微信支付，支付宝支付...',
  `pay_mark` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置标识，wechat，alipay...',
  `pay_info` text NOT NULL COMMENT '支付接口配置信息，数组以序列化存储',
  `pay_terminal` varchar(100) NOT NULL DEFAULT '' COMMENT '支付时的终端，暂时预留',
  `system_built` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否属于系统内置，0否，1是',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=关闭，1=开启)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='支付接口配置表';

-- -----------------------------
-- Records of `ey_pay_api_config`
-- -----------------------------
INSERT INTO `ey_pay_api_config` VALUES ('1', '微信支付', 'wechat', '', 'a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}', '1', '1', '1590111253', '1721273961');
INSERT INTO `ey_pay_api_config` VALUES ('2', '支付宝支付', 'alipay', '', 'a:4:{s:8:\"computer\";i:0;s:6:\"c_mark\";i:0;s:6:\"mobile\";i:0;s:6:\"m_mark\";i:0;}', '1', '0', '1590111253', '1636441870');
INSERT INTO `ey_pay_api_config` VALUES ('3', '虎皮椒支付', 'Hupijiaopay', '', '', '0', '1', '1590111253', '1636441870');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性值';


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性表';


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COMMENT='产品附加表';

-- -----------------------------
-- Records of `ey_product_content`
-- -----------------------------
INSERT INTO `ey_product_content` VALUES ('11', '11', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS35M.jpg&quot; alt=&quot;微信图片_20240624173807.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS3X6.jpg&quot; alt=&quot;微信图片_20240624173809.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS3300.jpg&quot; alt=&quot;微信图片_20240624173811.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS3U3.jpg&quot; alt=&quot;微信图片_20240624173813.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS3G2.jpg&quot; alt=&quot;微信图片_20240624173815.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS3231.jpg&quot; alt=&quot;微信图片_20240624173817.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS4250.jpg&quot; alt=&quot;微信图片_20240624173819.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS43c.jpg&quot; alt=&quot;微信图片_20240624173821.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241IS4432.jpg&quot; alt=&quot;微信图片_20240624173823.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719221921', '1719221921');
INSERT INTO `ey_product_content` VALUES ('12', '12', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K030336.jpg&quot; alt=&quot;微信图片_20240624174956.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K030332.jpg&quot; alt=&quot;微信图片_20240624175000.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K030103.jpg&quot; alt=&quot;微信图片_20240624175003.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K0311C.jpg&quot; alt=&quot;微信图片_20240624175009.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K031K0.jpg&quot; alt=&quot;微信图片_20240624175011.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K031364.jpg&quot; alt=&quot;微信图片_20240624175013.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K031118.jpg&quot; alt=&quot;微信图片_20240624175015.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K031123.jpg&quot; alt=&quot;微信图片_20240624175018.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719222644', '1719222644');
INSERT INTO `ey_product_content` VALUES ('13', '13', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32D26.jpg&quot; alt=&quot;微信图片_20240624175244.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32AJ.jpg&quot; alt=&quot;微信图片_20240624175253.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32C17.jpg&quot; alt=&quot;微信图片_20240624175256.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32L05.jpg&quot; alt=&quot;微信图片_20240624175258.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32O56.jpg&quot; alt=&quot;微信图片_20240624175301.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32L92.jpg&quot; alt=&quot;微信图片_20240624175303.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32K45.jpg&quot; alt=&quot;微信图片_20240624175306.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32H30.jpg&quot; alt=&quot;微信图片_20240624175308.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32X37.jpg&quot; alt=&quot;微信图片_20240624175310.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32X12.jpg&quot; alt=&quot;微信图片_20240624175313.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32VJ.jpg&quot; alt=&quot;微信图片_20240624175316.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K32V96.jpg&quot; alt=&quot;微信图片_20240624175318.jpg&quot;/&gt;&lt;/p&gt;', '1719881339', '1719881339');
INSERT INTO `ey_product_content` VALUES ('14', '14', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA3132.jpg&quot; alt=&quot;微信图片_20240624175624.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA4L1.jpg&quot; alt=&quot;微信图片_20240624175626.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA4220.jpg&quot; alt=&quot;微信图片_20240624175627.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA45Y.jpg&quot; alt=&quot;微信图片_20240624175629.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA4U4.jpg&quot; alt=&quot;微信图片_20240624175633.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA4943.jpg&quot; alt=&quot;微信图片_20240624175635.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA5M7.jpg&quot; alt=&quot;微信图片_20240624175637.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA5I4.jpg&quot; alt=&quot;微信图片_20240624175640.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA5392.jpg&quot; alt=&quot;微信图片_20240624175641.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA55L.jpg&quot; alt=&quot;微信图片_20240624175643.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KA5644.jpg&quot; alt=&quot;微信图片_20240624175645.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719223020', '1719223020');
INSERT INTO `ey_product_content` VALUES ('15', '15', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K951W7.jpg&quot; alt=&quot;微信图片_20240624175914.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K9512K.jpg&quot; alt=&quot;微信图片_20240624175916.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K951359.jpg&quot; alt=&quot;微信图片_20240624175918.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K951527.jpg&quot; alt=&quot;微信图片_20240624175919.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K951Z8.jpg&quot; alt=&quot;微信图片_20240624175924.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K9524W.jpg&quot; alt=&quot;微信图片_20240624175925.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K952T4.jpg&quot; alt=&quot;微信图片_20240624175927.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K952H9.jpg&quot; alt=&quot;微信图片_20240624175928.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K952332.jpg&quot; alt=&quot;微信图片_20240624175930.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719223196', '1719223196');
INSERT INTO `ey_product_content` VALUES ('16', '16', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23G64.jpg&quot; alt=&quot;微信图片_20240624180211.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23HV.jpg&quot; alt=&quot;微信图片_20240624180215.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23I48.jpg&quot; alt=&quot;微信图片_20240624180217.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23IH.jpg&quot; alt=&quot;微信图片_20240624180218.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23M07.jpg&quot; alt=&quot;微信图片_20240624180220.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23H61.jpg&quot; alt=&quot;微信图片_20240624180221.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23Qb.jpg&quot; alt=&quot;微信图片_20240624180223.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23Y59.jpg&quot; alt=&quot;微信图片_20240624180224.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23X06.jpg&quot; alt=&quot;微信图片_20240624180226.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23Q08.jpg&quot; alt=&quot;微信图片_20240624180227.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P23SR.jpg&quot; alt=&quot;微信图片_20240624180229.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719223363', '1719223363');
INSERT INTO `ey_product_content` VALUES ('17', '17', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIC29.jpg&quot; alt=&quot;微信图片_20240624180700.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIE07.jpg&quot; alt=&quot;微信图片_20240624180702.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIOY.jpg&quot; alt=&quot;微信图片_20240624180703.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIKV.jpg&quot; alt=&quot;微信图片_20240624180704.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIMa.jpg&quot; alt=&quot;微信图片_20240624180706.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIV39.jpg&quot; alt=&quot;微信图片_20240624180707.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PIX50.jpg&quot; alt=&quot;微信图片_20240624180708.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PI92J.jpg&quot; alt=&quot;微信图片_20240624180710.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PI95E.jpg&quot; alt=&quot;微信图片_20240624180711.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ0V5.jpg&quot; alt=&quot;微信图片_20240624180714.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ1234.jpg&quot; alt=&quot;微信图片_20240624180715.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ1259.jpg&quot; alt=&quot;微信图片_20240624180717.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ2324.jpg&quot; alt=&quot;微信图片_20240624180718.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ25T.jpg&quot; alt=&quot;微信图片_20240624180720.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ3c3.jpg&quot; alt=&quot;微信图片_20240624180721.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241PJ3I1.jpg&quot; alt=&quot;微信图片_20240624180723.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719223671', '1719223671');
INSERT INTO `ey_product_content` VALUES ('18', '18', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S135W5.jpg&quot; alt=&quot;微信图片_20240625083104.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S135I8.jpg&quot; alt=&quot;微信图片_20240625083106.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S135563.jpg&quot; alt=&quot;微信图片_20240625083107.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S135Q8.jpg&quot; alt=&quot;微信图片_20240625083109.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S135945.jpg&quot; alt=&quot;微信图片_20240625083110.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S13E93.jpg&quot; alt=&quot;微信图片_20240625083111.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S136255.jpg&quot; alt=&quot;微信图片_20240625083113.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S13CW.jpg&quot; alt=&quot;微信图片_20240625083114.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S13BQ.jpg&quot; alt=&quot;微信图片_20240625083116.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S1361Y.jpg&quot; alt=&quot;微信图片_20240625083121.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S13A12.jpg&quot; alt=&quot;微信图片_20240625083123.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S13D28.jpg&quot; alt=&quot;微信图片_20240625083125.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719275500', '1719275500');
INSERT INTO `ey_product_content` VALUES ('19', '19', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SH6244.jpg&quot; alt=&quot;微信图片_20240625083700.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SH6152.jpg&quot; alt=&quot;微信图片_20240625083702.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SH6249.jpg&quot; alt=&quot;微信图片_20240625083703.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SH6222.jpg&quot; alt=&quot;微信图片_20240625083705.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SHM20.jpg&quot; alt=&quot;微信图片_20240625083706.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SHK47.jpg&quot; alt=&quot;微信图片_20240625083708.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SHK60.jpg&quot; alt=&quot;微信图片_20240625083709.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SHK40.jpg&quot; alt=&quot;微信图片_20240625083710.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SHM60.jpg&quot; alt=&quot;微信图片_20240625083712.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SHJI.jpg&quot; alt=&quot;微信图片_20240625083714.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719275851', '1719275851');
INSERT INTO `ey_product_content` VALUES ('20', '20', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T359547.jpg&quot; alt=&quot;微信图片_20240625084327.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T35a64.jpg&quot; alt=&quot;微信图片_20240625084328.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T35b19.jpg&quot; alt=&quot;微信图片_20240625084330.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T3591W.jpg&quot; alt=&quot;微信图片_20240625084332.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T35c37.jpg&quot; alt=&quot;微信图片_20240625084333.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T400959.jpg&quot; alt=&quot;微信图片_20240625084335.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T400Z2.jpg&quot; alt=&quot;微信图片_20240625084336.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T400H2.jpg&quot; alt=&quot;微信图片_20240625084338.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T400534.jpg&quot; alt=&quot;微信图片_20240625084340.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T400950.jpg&quot; alt=&quot;微信图片_20240625084341.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T400a9.jpg&quot; alt=&quot;微信图片_20240625084343.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T401125.jpg&quot; alt=&quot;微信图片_20240625084345.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T401643.jpg&quot; alt=&quot;微信图片_20240625084347.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T4012B.jpg&quot; alt=&quot;微信图片_20240625084348.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719276245', '1719276245');
INSERT INTO `ey_product_content` VALUES ('21', '21', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T910611.jpg&quot; alt=&quot;微信图片_20240625084845.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T910463.jpg&quot; alt=&quot;微信图片_20240625084847.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T910308.jpg&quot; alt=&quot;微信图片_20240625084848.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911561.jpg&quot; alt=&quot;微信图片_20240625084850.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911102.jpg&quot; alt=&quot;微信图片_20240625084852.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911G9.jpg&quot; alt=&quot;微信图片_20240625084853.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911E9.jpg&quot; alt=&quot;微信图片_20240625084855.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911936.jpg&quot; alt=&quot;微信图片_20240625084856.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911640.jpg&quot; alt=&quot;微信图片_20240625084858.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T911N3.jpg&quot; alt=&quot;微信图片_20240625084859.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T9115b.jpg&quot; alt=&quot;微信图片_20240625084902.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722993110', '1722993110');
INSERT INTO `ey_product_content` VALUES ('22', '22', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U532D4.jpg&quot; alt=&quot;微信图片_20240625085504.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U532P6.jpg&quot; alt=&quot;微信图片_20240625085506.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U532463.jpg&quot; alt=&quot;微信图片_20240625085507.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U532145.jpg&quot; alt=&quot;微信图片_20240625085509.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U532147.jpg&quot; alt=&quot;微信图片_20240625085510.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U532291.jpg&quot; alt=&quot;微信图片_20240625085512.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U5331B.jpg&quot; alt=&quot;微信图片_20240625085513.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U533124.jpg&quot; alt=&quot;微信图片_20240625085514.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U533102.jpg&quot; alt=&quot;微信图片_20240625085516.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719276941', '1719276941');
INSERT INTO `ey_product_content` VALUES ('23', '23', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU35B.jpg&quot; alt=&quot;微信图片_20240625085830.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU3405.jpg&quot; alt=&quot;微信图片_20240625085831.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU4Z0.jpg&quot; alt=&quot;微信图片_20240625085833.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU4933.jpg&quot; alt=&quot;微信图片_20240625085835.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU4147.jpg&quot; alt=&quot;微信图片_20240625085836.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU4953.jpg&quot; alt=&quot;微信图片_20240625085838.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU4K6.jpg&quot; alt=&quot;微信图片_20240625085839.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU5b4.jpg&quot; alt=&quot;微信图片_20240625085841.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU5644.jpg&quot; alt=&quot;微信图片_20240625085842.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU55R.jpg&quot; alt=&quot;微信图片_20240625085844.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250UU55I.jpg&quot; alt=&quot;微信图片_20240625085845.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719277140', '1719277140');
INSERT INTO `ey_product_content` VALUES ('24', '24', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z64a40.jpg&quot; alt=&quot;微信图片_20240625090610.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z64b94.jpg&quot; alt=&quot;微信图片_20240625090613.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA01M.jpg&quot; alt=&quot;微信图片_20240625090616.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA0W7.jpg&quot; alt=&quot;微信图片_20240625090618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA0A9.jpg&quot; alt=&quot;微信图片_20240625090619.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA0D4.jpg&quot; alt=&quot;微信图片_20240625090621.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA02a.jpg&quot; alt=&quot;微信图片_20240625090623.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA0418.jpg&quot; alt=&quot;微信图片_20240625090625.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA1552.jpg&quot; alt=&quot;微信图片_20240625090626.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA1404.jpg&quot; alt=&quot;微信图片_20240625090628.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA1R7.jpg&quot; alt=&quot;微信图片_20240625090629.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA1H1.jpg&quot; alt=&quot;微信图片_20240625090632.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA1b5.jpg&quot; alt=&quot;微信图片_20240625090636.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA14W.jpg&quot; alt=&quot;微信图片_20240625090638.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZA2U8.jpg&quot; alt=&quot;微信图片_20240625090640.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719277677', '1719277677');
INSERT INTO `ey_product_content` VALUES ('25', '25', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091311R1.jpg&quot; alt=&quot;微信图片_20240625091225.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091312B7.jpg&quot; alt=&quot;微信图片_20240625091227.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091312915.jpg&quot; alt=&quot;微信图片_20240625091228.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091312W2.jpg&quot; alt=&quot;微信图片_20240625091230.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250913122c.jpg&quot; alt=&quot;微信图片_20240625091232.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250913122c.jpg&quot; alt=&quot;微信图片_20240625091233.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091313940.jpg&quot; alt=&quot;微信图片_20240625091235.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091313O9.jpg&quot; alt=&quot;微信图片_20240625091237.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091313306.jpg&quot; alt=&quot;微信图片_20240625091239.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091313E2.jpg&quot; alt=&quot;微信图片_20240625091240.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250913132T.jpg&quot; alt=&quot;微信图片_20240625091242.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091314Y5.jpg&quot; alt=&quot;微信图片_20240625091302.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719277998', '1719277998');
INSERT INTO `ey_product_content` VALUES ('26', '26', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092039313.jpg&quot; alt=&quot;微信图片_20240625092015.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092039256.jpg&quot; alt=&quot;微信图片_20240625092017.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092040944.jpg&quot; alt=&quot;微信图片_20240625092019.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092040240.jpg&quot; alt=&quot;微信图片_20240625092020.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092040617.jpg&quot; alt=&quot;微信图片_20240625092021.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092040T9.jpg&quot; alt=&quot;微信图片_20240625092023.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250920403T.jpg&quot; alt=&quot;微信图片_20240625092025.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092040T1.jpg&quot; alt=&quot;微信图片_20240625092026.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092041100.jpg&quot; alt=&quot;微信图片_20240625092029.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092041354.jpg&quot; alt=&quot;微信图片_20240625092031.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719278567', '1719278567');
INSERT INTO `ey_product_content` VALUES ('27', '27', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092945M9.jpg&quot; alt=&quot;微信图片_20240625092922.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509294C20.jpg&quot; alt=&quot;微信图片_20240625092924.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509294C22.jpg&quot; alt=&quot;微信图片_20240625092926.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092946307.jpg&quot; alt=&quot;微信图片_20240625092927.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509294E56.jpg&quot; alt=&quot;微信图片_20240625092929.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509294A54.jpg&quot; alt=&quot;微信图片_20240625092931.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509294B92.jpg&quot; alt=&quot;微信图片_20240625092932.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092946121.jpg&quot; alt=&quot;微信图片_20240625092935.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719278990', '1719278990');
INSERT INTO `ey_product_content` VALUES ('28', '28', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625093335544.jpg&quot; alt=&quot;微信图片_20240625093255.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625093335148.jpg&quot; alt=&quot;微信图片_20240625093256.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333A61.jpg&quot; alt=&quot;微信图片_20240625093258.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625093336113.jpg&quot; alt=&quot;微信图片_20240625093300.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333B60.jpg&quot; alt=&quot;微信图片_20240625093301.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333E23.jpg&quot; alt=&quot;微信图片_20240625093303.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333Ja.jpg&quot; alt=&quot;微信图片_20240625093305.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333IM.jpg&quot; alt=&quot;微信图片_20240625093307.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333NJ.jpg&quot; alt=&quot;微信图片_20240625093308.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333H32.jpg&quot; alt=&quot;微信图片_20240625093310.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333UV.jpg&quot; alt=&quot;微信图片_20240625093312.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333R18.jpg&quot; alt=&quot;微信图片_20240625093314.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333VP.jpg&quot; alt=&quot;微信图片_20240625093316.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333U52.jpg&quot; alt=&quot;微信图片_20240625093317.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333WY.jpg&quot; alt=&quot;微信图片_20240625093320.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333c30.jpg&quot; alt=&quot;微信图片_20240625093323.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509333aH.jpg&quot; alt=&quot;微信图片_20240625093326.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719279222', '1719279222');
INSERT INTO `ey_product_content` VALUES ('29', '29', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095629B2.jpg&quot; alt=&quot;微信图片_20240625095556.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095630322.jpg&quot; alt=&quot;微信图片_20240625095607.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095630304.jpg&quot; alt=&quot;微信图片_20240625095608.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095630535.jpg&quot; alt=&quot;微信图片_20240625095610.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250956304B.jpg&quot; alt=&quot;微信图片_20240625095611.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095630448.jpg&quot; alt=&quot;微信图片_20240625095613.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095630313.jpg&quot; alt=&quot;微信图片_20240625095614.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095631593.jpg&quot; alt=&quot;微信图片_20240625095616.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095631317.jpg&quot; alt=&quot;微信图片_20240625095618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095631T2.jpg&quot; alt=&quot;微信图片_20240625095619.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095631V2.jpg&quot; alt=&quot;微信图片_20240625095621.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719280595', '1719280595');
INSERT INTO `ey_product_content` VALUES ('30', '30', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095930a3.jpg&quot; alt=&quot;微信图片_20240625095916.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095930557.jpg&quot; alt=&quot;微信图片_20240625095918.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095930520.jpg&quot; alt=&quot;微信图片_20240625095919.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719280775', '1719280775');
INSERT INTO `ey_product_content` VALUES ('31', '31', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510031c62.jpg&quot; alt=&quot;微信图片_20240625100257.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251003192P.jpg&quot; alt=&quot;微信图片_20240625100259.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251003193c.jpg&quot; alt=&quot;微信图片_20240625100300.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100320L2.jpg&quot; alt=&quot;微信图片_20240625100302.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100320121.jpg&quot; alt=&quot;微信图片_20240625100303.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100320530.jpg&quot; alt=&quot;微信图片_20240625100305.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251003204C.jpg&quot; alt=&quot;微信图片_20240625100307.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100320914.jpg&quot; alt=&quot;微信图片_20240625100308.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100320294.jpg&quot; alt=&quot;微信图片_20240625100310.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719281004', '1719281004');
INSERT INTO `ey_product_content` VALUES ('32', '32', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251012125Q.jpg&quot; alt=&quot;微信图片_20240625101134.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101212b5.jpg&quot; alt=&quot;微信图片_20240625101135.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101212351.jpg&quot; alt=&quot;微信图片_20240625101137.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251012132Z.jpg&quot; alt=&quot;微信图片_20240625101138.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101213549.jpg&quot; alt=&quot;微信图片_20240625101140.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101213O3.jpg&quot; alt=&quot;微信图片_20240625101142.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251012131U.jpg&quot; alt=&quot;微信图片_20240625101143.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251012135D.jpg&quot; alt=&quot;微信图片_20240625101145.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101213524.jpg&quot; alt=&quot;微信图片_20240625101147.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101213433.jpg&quot; alt=&quot;微信图片_20240625101148.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101213437.jpg&quot; alt=&quot;微信图片_20240625101150.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101214516.jpg&quot; alt=&quot;微信图片_20240625101151.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101214Z8.jpg&quot; alt=&quot;微信图片_20240625101153.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251012144B.jpg&quot; alt=&quot;微信图片_20240625101154.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101214b8.jpg&quot; alt=&quot;微信图片_20240625101156.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251012143N.jpg&quot; alt=&quot;微信图片_20240625101158.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101214200.jpg&quot; alt=&quot;微信图片_20240625101200.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722506522', '1722506522');
INSERT INTO `ey_product_content` VALUES ('33', '33', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101532S6.jpg&quot; alt=&quot;微信图片_20240625101415.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251015324b.jpg&quot; alt=&quot;微信图片_20240625101458.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251015333C.jpg&quot; alt=&quot;微信图片_20240625101501.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101533342.jpg&quot; alt=&quot;微信图片_20240625101502.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101533351.jpg&quot; alt=&quot;微信图片_20240625101504.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101533Q1.jpg&quot; alt=&quot;微信图片_20240625101506.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251015334J.jpg&quot; alt=&quot;微信图片_20240625101507.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101533421.jpg&quot; alt=&quot;微信图片_20240625101509.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101533D2.jpg&quot; alt=&quot;微信图片_20240625101511.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101534546.jpg&quot; alt=&quot;微信图片_20240625101513.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101534112.jpg&quot; alt=&quot;微信图片_20240625101514.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101534U7.jpg&quot; alt=&quot;微信图片_20240625101520.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101534Q1.jpg&quot; alt=&quot;微信图片_20240625101521.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101534C9.jpg&quot; alt=&quot;微信图片_20240625101523.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719281738', '1719281738');
INSERT INTO `ey_product_content` VALUES ('34', '34', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102031591.jpg&quot; alt=&quot;微信图片_20240625101951.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102031649.jpg&quot; alt=&quot;微信图片_20240625101953.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251020311I.jpg&quot; alt=&quot;微信图片_20240625101954.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102031606.jpg&quot; alt=&quot;微信图片_20240625101956.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102031Y7.jpg&quot; alt=&quot;微信图片_20240625101958.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102031Q8.jpg&quot; alt=&quot;微信图片_20240625101959.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251020312I.jpg&quot; alt=&quot;微信图片_20240625102001.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102032319.jpg&quot; alt=&quot;微信图片_20240625102003.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102032V6.jpg&quot; alt=&quot;微信图片_20240625102005.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102032H1.jpg&quot; alt=&quot;微信图片_20240625102006.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102032A8.jpg&quot; alt=&quot;微信图片_20240625102008.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102032I1.jpg&quot; alt=&quot;微信图片_20240625102009.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102032311.jpg&quot; alt=&quot;微信图片_20240625102011.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1719282064', '1719282064');
INSERT INTO `ey_product_content` VALUES ('35', '35', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510251XJ.jpg&quot; alt=&quot;微信图片_20240625102440.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102519145.jpg&quot; alt=&quot;微信图片_20240625102442.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251025193C.jpg&quot; alt=&quot;微信图片_20240625102443.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510251a37.jpg&quot; alt=&quot;微信图片_20240625102445.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102519509.jpg&quot; alt=&quot;微信图片_20240625102447.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510251cF.jpg&quot; alt=&quot;微信图片_20240625102449.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510251b47.jpg&quot; alt=&quot;微信图片_20240625102451.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102519120.jpg&quot; alt=&quot;微信图片_20240625102453.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102519202.jpg&quot; alt=&quot;微信图片_20240625102454.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520154.jpg&quot; alt=&quot;微信图片_20240625102456.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520525.jpg&quot; alt=&quot;微信图片_20240625102457.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520356.jpg&quot; alt=&quot;微信图片_20240625102459.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520553.jpg&quot; alt=&quot;微信图片_20240625102501.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520b8.jpg&quot; alt=&quot;微信图片_20240625102502.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520357.jpg&quot; alt=&quot;微信图片_20240625102504.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102520a1.jpg&quot; alt=&quot;微信图片_20240625102506.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102521C3.jpg&quot; alt=&quot;微信图片_20240625102508.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722418659', '1722418659');
INSERT INTO `ey_product_content` VALUES ('36', '36', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102951591.jpg&quot; alt=&quot;微信图片_20240625102928.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102952c8.jpg&quot; alt=&quot;微信图片_20240625102929.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102952C1.jpg&quot; alt=&quot;微信图片_20240625102931.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102952192.jpg&quot; alt=&quot;微信图片_20240625102932.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102952428.jpg&quot; alt=&quot;微信图片_20240625102934.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251029523B.jpg&quot; alt=&quot;微信图片_20240625102936.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102952115.jpg&quot; alt=&quot;微信图片_20240625102937.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102953426.jpg&quot; alt=&quot;微信图片_20240625102939.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102953944.jpg&quot; alt=&quot;微信图片_20240625102941.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251029531b.jpg&quot; alt=&quot;微信图片_20240625102942.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1723024958', '1723024958');
INSERT INTO `ey_product_content` VALUES ('37', '37', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103415126.jpg&quot; alt=&quot;微信图片_20240625103344.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103416191.jpg&quot; alt=&quot;微信图片_20240625103346.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251034163M.jpg&quot; alt=&quot;微信图片_20240625103347.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103416435.jpg&quot; alt=&quot;微信图片_20240625103349.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510341M20.jpg&quot; alt=&quot;微信图片_20240625103350.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510341Y02.jpg&quot; alt=&quot;微信图片_20240625103352.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510341UQ.jpg&quot; alt=&quot;微信图片_20240625103354.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510341T57.jpg&quot; alt=&quot;微信图片_20240625103355.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510341aA.jpg&quot; alt=&quot;微信图片_20240625103357.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103419606.jpg&quot; alt=&quot;微信图片_20240625103358.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103420A7.jpg&quot; alt=&quot;微信图片_20240625103400.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251034202L.jpg&quot; alt=&quot;微信图片_20240625103402.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103421H3.jpg&quot; alt=&quot;微信图片_20240625103403.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103421K5.jpg&quot; alt=&quot;微信图片_20240625103405.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1723024350', '1723024350');
INSERT INTO `ey_product_content` VALUES ('50', '50', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142204501.jpg&quot; alt=&quot;O1CN01emxiNv1VvyRm74dCj_!!2206762402716.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142204138.jpg&quot; alt=&quot;O1CN01u4tWAh1VvyRm766h2_!!2206762402716.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142203W1.jpg&quot; alt=&quot;O1CN01QRsyD61VvyRzen2Pv_!!2206762402716.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142203a7.jpg&quot; alt=&quot;O1CN01c8S5Qr1VvyRygNk87_!!2206762402716.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142204300.jpg&quot; alt=&quot;O1CN01mVre7u1VvyRvJ9ok1_!!2206762402716.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142202551.jpg&quot; alt=&quot;O1CN018Qzx341VvyRx2jy07_!!2206762402716.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142202U9.jpg&quot; alt=&quot;O1CN01Z4yY8i1VvyRvJAxPE_!!2206762402716.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt;&lt;/p&gt;', '1722925397', '1722925397');
INSERT INTO `ey_product_content` VALUES ('55', '55', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592B59.jpg&quot; alt=&quot;微信图片_20240806145846.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6145926259.jpg&quot; alt=&quot;微信图片_20240806145847.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592DR.jpg&quot; alt=&quot;微信图片_20240806145848.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592O43.jpg&quot; alt=&quot;微信图片_20240806145851.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592L48.jpg&quot; alt=&quot;微信图片_20240806145852.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592G42.jpg&quot; alt=&quot;微信图片_20240806145854.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592N45.jpg&quot; alt=&quot;微信图片_20240806145855.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592N63.jpg&quot; alt=&quot;微信图片_20240806145856.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592VH.jpg&quot; alt=&quot;微信图片_20240806145857.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592YO.jpg&quot; alt=&quot;微信图片_20240806145859.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592X29.jpg&quot; alt=&quot;微信图片_20240806145900.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592V55.jpg&quot; alt=&quot;微信图片_20240806145902.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592Y33.jpg&quot; alt=&quot;微信图片_20240806145904.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592V07.jpg&quot; alt=&quot;微信图片_20240806145906.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61459294R.jpg&quot; alt=&quot;微信图片_20240806145908.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614592aY.jpg&quot; alt=&quot;微信图片_20240806145909.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61459295B.jpg&quot; alt=&quot;微信图片_20240806145912.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722927578', '1722927578');
INSERT INTO `ey_product_content` VALUES ('53', '53', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144339457.jpg&quot; alt=&quot;微信图片_20240806144316.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144339342.jpg&quot; alt=&quot;微信图片_20240806144319.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144339236.jpg&quot; alt=&quot;微信图片_20240806144321.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614433c21.jpg&quot; alt=&quot;微信图片_20240806144325.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722926728', '1722926728');
INSERT INTO `ey_product_content` VALUES ('54', '54', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144956113.jpg&quot; alt=&quot;微信图片_20240806144853.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61449564X.jpg&quot; alt=&quot;微信图片_20240806144855.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61449561E.jpg&quot; alt=&quot;微信图片_20240806144858.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614495H13.jpg&quot; alt=&quot;微信图片_20240806144859.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614495I44.jpg&quot; alt=&quot;微信图片_20240806144901.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614495K47.jpg&quot; alt=&quot;微信图片_20240806144902.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614495G46.jpg&quot; alt=&quot;微信图片_20240806144904.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614495J95.jpg&quot; alt=&quot;微信图片_20240806144905.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614495H48.jpg&quot; alt=&quot;微信图片_20240806144907.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722991519', '1722991519');
INSERT INTO `ey_product_content` VALUES ('51', '51', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614242K23.jpg&quot; alt=&quot;O1CN01n5U7ZY2NSeM4wCPhT_!!59029962.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614242J58.jpg&quot; alt=&quot;O1CN01p9Jo3Z2NSeM4CVoBC_!!59029962.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614242L23.jpg&quot; alt=&quot;O1CN01Qhx36D2NSeM4CSqzK_!!59029962.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614242BP.jpg&quot; alt=&quot;O1CN01UfWZ4s2NSeM1XI62z_!!59029962.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61424264I.jpg&quot; alt=&quot;O1CN01rtBRSk2NSeM6vDQ6D_!!59029962.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614242IM.jpg&quot; alt=&quot;O1CN01HIT1yn2NSeLzsv8bp_!!59029962.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142425356.jpg&quot; alt=&quot;O1CN01T3VgyV2NSeM85T2D9_!!59029962.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142424462.jpg&quot; alt=&quot;O1CN01mAKYwr2NSeLqPAmdf_!!59029962.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142425C5.jpg&quot; alt=&quot;O1CN01QfraLw2NSeM1yh8Tk_!!59029962.jpg&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142425249.jpg&quot; alt=&quot;O1CN01mWFXUA2NSeLwluh7c_!!59029962.jpg&quot; style=&quot;text-wrap: wrap;&quot;/&gt; &amp;nbsp; &amp;nbsp;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6142425Q3.jpg&quot; alt=&quot;O1CN01MFOBwq2NSeM4w9aoQ_!!59029962.jpg&quot;/&gt;&lt;/p&gt;', '1722925625', '1722925625');
INSERT INTO `ey_product_content` VALUES ('52', '52', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143311955.jpg&quot; alt=&quot;微信图片_20240806143207.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143311563.jpg&quot; alt=&quot;微信图片_20240806143220.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143311E5.jpg&quot; alt=&quot;微信图片_20240806143223.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143311122.jpg&quot; alt=&quot;微信图片_20240806143226.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61433114E.jpg&quot; alt=&quot;微信图片_20240806143228.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143312U0.jpg&quot; alt=&quot;微信图片_20240806143230.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143312433.jpg&quot; alt=&quot;微信图片_20240806143232.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143312102.jpg&quot; alt=&quot;微信图片_20240806143235.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61433125F.jpg&quot; alt=&quot;微信图片_20240806143237.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61433121K.jpg&quot; alt=&quot;微信图片_20240806143239.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143312256.jpg&quot; alt=&quot;微信图片_20240806143246.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143313E4.jpg&quot; alt=&quot;微信图片_20240806143249.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61433133R.jpg&quot; alt=&quot;微信图片_20240806143253.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722926111', '1722926111');
INSERT INTO `ey_product_content` VALUES ('56', '56', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K1123.jpg&quot; alt=&quot;微信图片_20240806150557.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K1115.jpg&quot; alt=&quot;微信图片_20240806150559.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K1509.jpg&quot; alt=&quot;微信图片_20240806150601.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K1547.jpg&quot; alt=&quot;微信图片_20240806150602.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K24G.jpg&quot; alt=&quot;微信图片_20240806150604.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K2536.jpg&quot; alt=&quot;微信图片_20240806150605.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K2a2.jpg&quot; alt=&quot;微信图片_20240806150606.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K2V5.jpg&quot; alt=&quot;微信图片_20240806150608.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150K23I.jpg&quot; alt=&quot;微信图片_20240806150609.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722928078', '1722928078');
INSERT INTO `ey_product_content` VALUES ('57', '57', '', '&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615103R38.jpg&quot; alt=&quot;微信图片_20240806151009.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615103Q22.jpg&quot; alt=&quot;微信图片_20240806151011.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615103SV.jpg&quot; alt=&quot;微信图片_20240806151012.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615103X50.jpg&quot; alt=&quot;微信图片_20240806151013.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615103aB.jpg&quot; alt=&quot;微信图片_20240806151015.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61510395K.jpg&quot; alt=&quot;微信图片_20240806151016.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6151039249.jpg&quot; alt=&quot;微信图片_20240806151017.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61510395G.jpg&quot; alt=&quot;微信图片_20240806151019.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61510405Z.jpg&quot; alt=&quot;微信图片_20240806151020.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6151040246.jpg&quot; alt=&quot;微信图片_20240806151022.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6151040550.jpg&quot; alt=&quot;微信图片_20240806151024.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61510405E.jpg&quot; alt=&quot;微信图片_20240806151025.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6151040I6.jpg&quot; alt=&quot;微信图片_20240806151027.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6151040c1.jpg&quot; alt=&quot;微信图片_20240806151028.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1722928392', '1722928392');

-- -----------------------------
-- Table structure for `ey_product_custom_param`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_custom_param`;
CREATE TABLE `ey_product_custom_param` (
  `param_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '参数ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数ID',
  `param_name` varchar(60) NOT NULL DEFAULT '' COMMENT '参数名称',
  `param_value` varchar(200) NOT NULL DEFAULT '' COMMENT '参数值',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`param_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品自定义参数表';


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=464 DEFAULT CHARSET=utf8 COMMENT='产品图片表';

-- -----------------------------
-- Records of `ey_product_img`
-- -----------------------------
INSERT INTO `ey_product_img` VALUES ('52', '11', '棉麻中底吸湿透气 高颜值 脚感更出众 温莎舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241I529149.jpg', '', '800', '800', '73897', 'image/jpeg', '1', '1719221921', '0');
INSERT INTO `ey_product_img` VALUES ('53', '11', '棉麻中底吸湿透气 高颜值 脚感更出众 温莎舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241I53K43.jpg', '', '800', '800', '116461', 'image/jpeg', '2', '1719221921', '0');
INSERT INTO `ey_product_img` VALUES ('54', '11', '棉麻中底吸湿透气 高颜值 脚感更出众 温莎舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241I53Rb.jpg', '', '800', '800', '115250', 'image/jpeg', '3', '1719221921', '0');
INSERT INTO `ey_product_img` VALUES ('55', '11', '棉麻中底吸湿透气 高颜值 脚感更出众 温莎舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241I53W21.jpg', '', '800', '800', '82031', 'image/jpeg', '4', '1719221921', '0');
INSERT INTO `ey_product_img` VALUES ('56', '12', '纺织帮面 透气舒适 冰丝触感透气不闷脚 夏洛特舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241JT4F4.jpg', '', '800', '800', '93614', 'image/jpeg', '1', '1719222644', '0');
INSERT INTO `ey_product_img` VALUES ('57', '12', '纺织帮面 透气舒适 冰丝触感透气不闷脚 夏洛特舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241JU42A.jpg', '', '800', '800', '108465', 'image/jpeg', '2', '1719222644', '0');
INSERT INTO `ey_product_img` VALUES ('58', '12', '纺织帮面 透气舒适 冰丝触感透气不闷脚 夏洛特舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241JU45H.jpg', '', '800', '800', '109511', 'image/jpeg', '3', '1719222644', '0');
INSERT INTO `ey_product_img` VALUES ('59', '12', '纺织帮面 透气舒适 冰丝触感透气不闷脚 夏洛特舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241JU5430.jpg', '', '800', '800', '105388', 'image/jpeg', '4', '1719222644', '0');
INSERT INTO `ey_product_img` VALUES ('60', '12', '纺织帮面 透气舒适 冰丝触感透气不闷脚 夏洛特舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241JU5246.jpg', '', '800', '800', '77464', 'image/jpeg', '5', '1719222644', '0');
INSERT INTO `ey_product_img` VALUES ('203', '13', '挺阔帮面柔韧回弹不易变形 全天候的舒适脚感 迈阿密舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K14a18.jpg', '', '800', '800', '117693', 'image/jpeg', '4', '1719881339', '0');
INSERT INTO `ey_product_img` VALUES ('202', '13', '挺阔帮面柔韧回弹不易变形 全天候的舒适脚感 迈阿密舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K149215.jpg', '', '800', '800', '85189', 'image/jpeg', '3', '1719881339', '0');
INSERT INTO `ey_product_img` VALUES ('201', '13', '挺阔帮面柔韧回弹不易变形 全天候的舒适脚感 迈阿密舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K149114.jpg', '', '800', '800', '89438', 'image/jpeg', '2', '1719881339', '0');
INSERT INTO `ey_product_img` VALUES ('200', '13', '挺阔帮面柔韧回弹不易变形 全天候的舒适脚感 迈阿密舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K141Q4.jpg', '', '800', '800', '101704', 'image/jpeg', '1', '1719881339', '0');
INSERT INTO `ey_product_img` VALUES ('65', '14', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K526131.jpg', '', '800', '800', '51296', 'image/jpeg', '1', '1719223020', '0');
INSERT INTO `ey_product_img` VALUES ('66', '14', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K534294.jpg', '', '800', '800', '95530', 'image/jpeg', '2', '1719223020', '0');
INSERT INTO `ey_product_img` VALUES ('67', '14', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K534F7.jpg', '', '800', '800', '85615', 'image/jpeg', '3', '1719223020', '0');
INSERT INTO `ey_product_img` VALUES ('68', '14', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K535960.jpg', '', '800', '800', '64769', 'image/jpeg', '4', '1719223020', '0');
INSERT INTO `ey_product_img` VALUES ('69', '14', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K535O9.jpg', '', '800', '800', '52742', 'image/jpeg', '5', '1719223020', '0');
INSERT INTO `ey_product_img` VALUES ('70', '14', '加厚麦穗绒防风更保暖 可爱情侣居家防滑拖鞋 立体波纹鞋底&quot;磨&quot;力无限 悦琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241K535264.jpg', '', '800', '800', '104797', 'image/jpeg', '6', '1719223020', '0');
INSERT INTO `ey_product_img` VALUES ('71', '15', '时髦时尚 个性风绒亲毛毛拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KJ6418.jpg', '', '800', '800', '49520', 'image/jpeg', '1', '1719223196', '0');
INSERT INTO `ey_product_img` VALUES ('72', '15', '时髦时尚 个性风绒亲毛毛拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241KK2503.jpg', '', '800', '800', '55641', 'image/jpeg', '2', '1719223196', '0');
INSERT INTO `ey_product_img` VALUES ('73', '16', '俏佳人毛巾拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P0452A.jpg', '', '800', '800', '70242', 'image/jpeg', '1', '1719223363', '0');
INSERT INTO `ey_product_img` VALUES ('74', '16', '俏佳人毛巾拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P0521Q.jpg', '', '800', '800', '58770', 'image/jpeg', '2', '1719223363', '0');
INSERT INTO `ey_product_img` VALUES ('75', '16', '俏佳人毛巾拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P052946.jpg', '', '800', '800', '59002', 'image/jpeg', '3', '1719223363', '0');
INSERT INTO `ey_product_img` VALUES ('76', '16', '俏佳人毛巾拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P052357.jpg', '', '800', '800', '47455', 'image/jpeg', '4', '1719223363', '0');
INSERT INTO `ey_product_img` VALUES ('77', '16', '俏佳人毛巾拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P052V3.jpg', '', '800', '800', '82168', 'image/jpeg', '5', '1719223363', '0');
INSERT INTO `ey_product_img` VALUES ('78', '17', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P51N47.jpg', '', '800', '800', '39696', 'image/jpeg', '1', '1719223671', '0');
INSERT INTO `ey_product_img` VALUES ('79', '17', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P524607.jpg', '', '800', '800', '68560', 'image/jpeg', '2', '1719223671', '0');
INSERT INTO `ey_product_img` VALUES ('80', '17', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P524500.jpg', '', '800', '800', '73021', 'image/jpeg', '3', '1719223671', '0');
INSERT INTO `ey_product_img` VALUES ('81', '17', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P524Q2.jpg', '', '800', '800', '64344', 'image/jpeg', '4', '1719223671', '0');
INSERT INTO `ey_product_img` VALUES ('82', '17', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P524K2.jpg', '', '800', '800', '112865', 'image/jpeg', '5', '1719223671', '0');
INSERT INTO `ey_product_img` VALUES ('83', '17', '仿兔毛软糯糯的橹猫感 超级舒服!猫绒绒舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240624/1-2406241P524391.jpg', '', '800', '800', '98525', 'image/jpeg', '6', '1719223671', '0');
INSERT INTO `ey_product_img` VALUES ('84', '18', '一体成型EVA环保材质 厚道踏云拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250RJ4937.jpg', '', '800', '800', '48232', 'image/jpeg', '1', '1719275500', '0');
INSERT INTO `ey_product_img` VALUES ('85', '18', '一体成型EVA环保材质 厚道踏云拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250RK21I.jpg', '', '800', '800', '37871', 'image/jpeg', '2', '1719275500', '0');
INSERT INTO `ey_product_img` VALUES ('86', '18', '一体成型EVA环保材质 厚道踏云拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250RK24H.jpg', '', '800', '800', '39100', 'image/jpeg', '3', '1719275500', '0');
INSERT INTO `ey_product_img` VALUES ('87', '18', '一体成型EVA环保材质 厚道踏云拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250RK2130.jpg', '', '800', '800', '34726', 'image/jpeg', '4', '1719275500', '0');
INSERT INTO `ey_product_img` VALUES ('88', '18', '一体成型EVA环保材质 厚道踏云拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250RK2P0.jpg', '', '800', '800', '29282', 'image/jpeg', '5', '1719275500', '0');
INSERT INTO `ey_product_img` VALUES ('89', '19', '艾琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S4144L.jpg', '', '1000', '1000', '49464', 'image/jpeg', '1', '1719275851', '0');
INSERT INTO `ey_product_img` VALUES ('90', '19', '艾琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S456402.jpg', '', '1000', '1000', '54574', 'image/jpeg', '2', '1719275851', '0');
INSERT INTO `ey_product_img` VALUES ('91', '19', '艾琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S45E18.jpg', '', '1000', '1000', '26895', 'image/jpeg', '3', '1719275851', '0');
INSERT INTO `ey_product_img` VALUES ('92', '19', '艾琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S45E36.jpg', '', '1000', '1000', '44198', 'image/jpeg', '4', '1719275851', '0');
INSERT INTO `ey_product_img` VALUES ('93', '19', '艾琪舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250S45C23.jpg', '', '1000', '1000', '34620', 'image/jpeg', '5', '1719275851', '0');
INSERT INTO `ey_product_img` VALUES ('94', '20', '4CM厚底减震舒压 艾登舒防滑拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250SS63b.jpg', '', '800', '800', '44555', 'image/jpeg', '1', '1719276245', '0');
INSERT INTO `ey_product_img` VALUES ('95', '20', '4CM厚底减震舒压 艾登舒防滑拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ST5549.jpg', '', '800', '800', '42149', 'image/jpeg', '2', '1719276245', '0');
INSERT INTO `ey_product_img` VALUES ('96', '20', '4CM厚底减震舒压 艾登舒防滑拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ST5A2.jpg', '', '800', '800', '40410', 'image/jpeg', '3', '1719276245', '0');
INSERT INTO `ey_product_img` VALUES ('97', '20', '4CM厚底减震舒压 艾登舒防滑拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ST55B.jpg', '', '800', '800', '33906', 'image/jpeg', '4', '1719276245', '0');
INSERT INTO `ey_product_img` VALUES ('98', '20', '4CM厚底减震舒压 艾登舒防滑拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ST5548.jpg', '', '800', '800', '41014', 'image/jpeg', '5', '1719276245', '0');
INSERT INTO `ey_product_img` VALUES ('447', '21', '一体成型EVA柔软Q弹 可爱萌宠情侣蜜蜜羊/甜甜犬舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T53Y40.jpg', '', '800', '800', '47207', 'image/jpeg', '5', '1722993110', '0');
INSERT INTO `ey_product_img` VALUES ('446', '21', '一体成型EVA柔软Q弹 可爱萌宠情侣蜜蜜羊/甜甜犬舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T53V50.jpg', '', '800', '800', '35239', 'image/jpeg', '4', '1722993110', '0');
INSERT INTO `ey_product_img` VALUES ('445', '21', '一体成型EVA柔软Q弹 可爱萌宠情侣蜜蜜羊/甜甜犬舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T53V12.jpg', '', '800', '800', '31581', 'image/jpeg', '3', '1722993110', '0');
INSERT INTO `ey_product_img` VALUES ('444', '21', '一体成型EVA柔软Q弹 可爱萌宠情侣蜜蜜羊/甜甜犬舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T53W53.jpg', '', '800', '800', '39032', 'image/jpeg', '2', '1722993110', '0');
INSERT INTO `ey_product_img` VALUES ('443', '21', '一体成型EVA柔软Q弹 可爱萌宠情侣蜜蜜羊/甜甜犬舒适拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T530100.jpg', '', '800', '800', '46274', 'image/jpeg', '1', '1722993110', '0');
INSERT INTO `ey_product_img` VALUES ('104', '22', 'PIMA棉 雅-床品四件套-米白/蓝/200*230cm/220*240cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U0242K.jpg', '', '640', '640', '24478', 'image/jpeg', '1', '1719276941', '0');
INSERT INTO `ey_product_img` VALUES ('105', '22', 'PIMA棉 雅-床品四件套-米白/蓝/200*230cm/220*240cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U031N5.jpg', '', '640', '640', '59115', 'image/jpeg', '2', '1719276941', '0');
INSERT INTO `ey_product_img` VALUES ('106', '22', 'PIMA棉 雅-床品四件套-米白/蓝/200*230cm/220*240cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U032153.jpg', '', '640', '640', '67144', 'image/jpeg', '3', '1719276941', '0');
INSERT INTO `ey_product_img` VALUES ('107', '22', 'PIMA棉 雅-床品四件套-米白/蓝/200*230cm/220*240cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U032156.jpg', '', '640', '640', '72470', 'image/jpeg', '4', '1719276941', '0');
INSERT INTO `ey_product_img` VALUES ('108', '23', '严选60S高密天丝 繁花-锦天丝床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U6262K.jpg', '', '800', '800', '85597', 'image/jpeg', '1', '1719277140', '0');
INSERT INTO `ey_product_img` VALUES ('109', '23', '严选60S高密天丝 繁花-锦天丝床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U634195.jpg', '', '800', '800', '133816', 'image/jpeg', '2', '1719277140', '0');
INSERT INTO `ey_product_img` VALUES ('110', '23', '严选60S高密天丝 繁花-锦天丝床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U6344I.jpg', '', '800', '800', '134819', 'image/jpeg', '3', '1719277140', '0');
INSERT INTO `ey_product_img` VALUES ('111', '23', '严选60S高密天丝 繁花-锦天丝床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U6344K.jpg', '', '800', '800', '115888', 'image/jpeg', '4', '1719277140', '0');
INSERT INTO `ey_product_img` VALUES ('112', '23', '严选60S高密天丝 繁花-锦天丝床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250U635M4.jpg', '', '800', '800', '84303', 'image/jpeg', '5', '1719277140', '0');
INSERT INTO `ey_product_img` VALUES ('113', '24', '高支高密奢享真丝般的舒适 寻梦/雅300T床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z31E23.jpg', '', '800', '800', '39707', 'image/jpeg', '1', '1719277677', '0');
INSERT INTO `ey_product_img` VALUES ('114', '24', '高支高密奢享真丝般的舒适 寻梦/雅300T床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z3233Q.jpg', '', '800', '800', '72548', 'image/jpeg', '2', '1719277677', '0');
INSERT INTO `ey_product_img` VALUES ('115', '24', '高支高密奢享真丝般的舒适 寻梦/雅300T床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z324530.jpg', '', '800', '800', '82885', 'image/jpeg', '3', '1719277677', '0');
INSERT INTO `ey_product_img` VALUES ('116', '24', '高支高密奢享真丝般的舒适 寻梦/雅300T床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250Z324W7.jpg', '', '800', '800', '53228', 'image/jpeg', '4', '1719277677', '0');
INSERT INTO `ey_product_img` VALUES ('117', '25', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZU5J0.jpg', '', '800', '800', '49479', 'image/jpeg', '1', '1719277998', '0');
INSERT INTO `ey_product_img` VALUES ('118', '25', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZZ3413.jpg', '', '800', '800', '66471', 'image/jpeg', '2', '1719277998', '0');
INSERT INTO `ey_product_img` VALUES ('119', '25', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZZ3529.jpg', '', '800', '800', '91752', 'image/jpeg', '3', '1719277998', '0');
INSERT INTO `ey_product_img` VALUES ('120', '25', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZZ3223.jpg', '', '800', '800', '84893', 'image/jpeg', '4', '1719277998', '0');
INSERT INTO `ey_product_img` VALUES ('121', '25', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZZ4249.jpg', '', '800', '800', '76384', 'image/jpeg', '5', '1719277998', '0');
INSERT INTO `ey_product_img` VALUES ('122', '25', '贡缎提花丝滑裸睡的舒适睡感 芸馨-贡缎提花床品四件套', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250ZZ4T3.jpg', '', '800', '800', '62883', 'image/jpeg', '6', '1719277998', '0');
INSERT INTO `ey_product_img` VALUES ('123', '26', '天使尊享枕', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091U2H8.jpg', '', '800', '800', '34074', 'image/jpeg', '1', '1719278567', '0');
INSERT INTO `ey_product_img` VALUES ('124', '26', '天使尊享枕', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091924454.jpg', '', '800', '800', '78786', 'image/jpeg', '2', '1719278567', '0');
INSERT INTO `ey_product_img` VALUES ('125', '26', '天使尊享枕', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091924508.jpg', '', '800', '800', '39809', 'image/jpeg', '3', '1719278567', '0');
INSERT INTO `ey_product_img` VALUES ('126', '26', '天使尊享枕', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091924a5.jpg', '', '800', '800', '30712', 'image/jpeg', '4', '1719278567', '0');
INSERT INTO `ey_product_img` VALUES ('127', '26', '天使尊享枕', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625091925630.jpg', '', '800', '800', '35680', 'image/jpeg', '5', '1719278567', '0');
INSERT INTO `ey_product_img` VALUES ('128', '27', '饱满填充 高弹支撑 安睡舒眠枕 (2入装）枕头 枕芯', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092H4259.jpg', '', '640', '640', '14538', 'image/jpeg', '1', '1719278990', '0');
INSERT INTO `ey_product_img` VALUES ('129', '27', '饱满填充 高弹支撑 安睡舒眠枕 (2入装）枕头 枕芯', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092IR32.jpg', '', '640', '640', '33109', 'image/jpeg', '2', '1719278990', '0');
INSERT INTO `ey_product_img` VALUES ('130', '27', '饱满填充 高弹支撑 安睡舒眠枕 (2入装）枕头 枕芯', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092IQ30.jpg', '', '640', '640', '41477', 'image/jpeg', '3', '1719278990', '0');
INSERT INTO `ey_product_img` VALUES ('131', '27', '饱满填充 高弹支撑 安睡舒眠枕 (2入装）枕头 枕芯', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625092I9260.jpg', '', '640', '640', '45227', 'image/jpeg', '4', '1719278990', '0');
INSERT INTO `ey_product_img` VALUES ('132', '28', '柔软瞬吸 温暖情侣 优选新疆棉莫兰迪抑菌无捻浴袍', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250930594G.jpg', '', '800', '800', '33345', 'image/jpeg', '1', '1719279222', '0');
INSERT INTO `ey_product_img` VALUES ('133', '28', '柔软瞬吸 温暖情侣 优选新疆棉莫兰迪抑菌无捻浴袍', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509310AC.jpg', '', '800', '800', '46686', 'image/jpeg', '2', '1719279222', '0');
INSERT INTO `ey_product_img` VALUES ('134', '28', '柔软瞬吸 温暖情侣 优选新疆棉莫兰迪抑菌无捻浴袍', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625093106393.jpg', '', '800', '800', '49386', 'image/jpeg', '3', '1719279222', '0');
INSERT INTO `ey_product_img` VALUES ('135', '28', '柔软瞬吸 温暖情侣 优选新疆棉莫兰迪抑菌无捻浴袍', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062509310C01.jpg', '', '800', '800', '61607', 'image/jpeg', '4', '1719279222', '0');
INSERT INTO `ey_product_img` VALUES ('136', '29', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095116317.jpg', '', '800', '800', '36707', 'image/jpeg', '1', '1719280595', '0');
INSERT INTO `ey_product_img` VALUES ('137', '29', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095123161.jpg', '', '800', '800', '55442', 'image/jpeg', '2', '1719280595', '0');
INSERT INTO `ey_product_img` VALUES ('138', '29', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095123642.jpg', '', '800', '800', '181588', 'image/jpeg', '3', '1719280595', '0');
INSERT INTO `ey_product_img` VALUES ('139', '29', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250951239A.jpg', '', '800', '800', '43093', 'image/jpeg', '4', '1719280595', '0');
INSERT INTO `ey_product_img` VALUES ('140', '29', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095124642.jpg', '', '800', '800', '138425', 'image/jpeg', '5', '1719280595', '0');
INSERT INTO `ey_product_img` VALUES ('141', '29', '丝柔纺裸睡感极简主义舒适宽松 柔+家居服套装春秋款/短袖长裤款', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095124544.jpg', '', '800', '800', '38751', 'image/jpeg', '6', '1719280595', '0');
INSERT INTO `ey_product_img` VALUES ('142', '30', '压纹手挽遥控器盒/咖啡/收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095T0616.jpg', '', '800', '800', '38845', 'image/jpeg', '1', '1719280775', '0');
INSERT INTO `ey_product_img` VALUES ('143', '30', '压纹手挽遥控器盒/咖啡/收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095T0215.jpg', '', '800', '800', '67956', 'image/jpeg', '2', '1719280775', '0');
INSERT INTO `ey_product_img` VALUES ('144', '30', '压纹手挽遥控器盒/咖啡/收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095T0401.jpg', '', '800', '800', '79178', 'image/jpeg', '3', '1719280775', '0');
INSERT INTO `ey_product_img` VALUES ('145', '30', '压纹手挽遥控器盒/咖啡/收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625095T0352.jpg', '', '800', '800', '43551', 'image/jpeg', '4', '1719280775', '0');
INSERT INTO `ey_product_img` VALUES ('146', '31', '古典仿皮压纹收纳筐 压纹收纳框/咖啡/桌面收纳多规格', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251000501H.jpg', '', '800', '800', '43019', 'image/jpeg', '1', '1719281004', '0');
INSERT INTO `ey_product_img` VALUES ('147', '31', '古典仿皮压纹收纳筐 压纹收纳框/咖啡/桌面收纳多规格', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100056415.jpg', '', '800', '800', '80373', 'image/jpeg', '2', '1719281004', '0');
INSERT INTO `ey_product_img` VALUES ('148', '31', '古典仿皮压纹收纳筐 压纹收纳框/咖啡/桌面收纳多规格', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510005L33.jpg', '', '800', '800', '83836', 'image/jpeg', '3', '1719281004', '0');
INSERT INTO `ey_product_img` VALUES ('149', '31', '古典仿皮压纹收纳筐 压纹收纳框/咖啡/桌面收纳多规格', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510005Nb.jpg', '', '800', '800', '115980', 'image/jpeg', '4', '1719281004', '0');
INSERT INTO `ey_product_img` VALUES ('150', '31', '古典仿皮压纹收纳筐 压纹收纳框/咖啡/桌面收纳多规格', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510005Mb.jpg', '', '800', '800', '75734', 'image/jpeg', '5', '1719281004', '0');
INSERT INTO `ey_product_img` VALUES ('367', '32', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510051U08.jpg', '', '800', '800', '39840', 'image/jpeg', '6', '1722506522', '0');
INSERT INTO `ey_product_img` VALUES ('366', '32', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510051VY.jpg', '', '800', '800', '49743', 'image/jpeg', '5', '1722506522', '0');
INSERT INTO `ey_product_img` VALUES ('365', '32', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510051X62.jpg', '', '800', '800', '33382', 'image/jpeg', '4', '1722506522', '0');
INSERT INTO `ey_product_img` VALUES ('364', '32', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510051UX.jpg', '', '800', '800', '49624', 'image/jpeg', '3', '1722506522', '0');
INSERT INTO `ey_product_img` VALUES ('363', '32', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510051XT.jpg', '', '800', '800', '56693', 'image/jpeg', '2', '1722506522', '0');
INSERT INTO `ey_product_img` VALUES ('362', '32', '品质PU高质感纹理多规格收纳 蜜桃可可单层/二层收纳首饰盒 纸巾收纳盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625100511Q0.jpg', '', '800', '800', '43790', 'image/jpeg', '1', '1722506522', '0');
INSERT INTO `ey_product_img` VALUES ('157', '33', '好收纳多用包/钱包/化妆包/手拿包/洗漱包/小', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510134H09.jpg', '', '800', '800', '34593', 'image/jpeg', '1', '1719281738', '0');
INSERT INTO `ey_product_img` VALUES ('158', '33', '好收纳多用包/钱包/化妆包/手拿包/洗漱包/小', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101353200.jpg', '', '800', '800', '42956', 'image/jpeg', '2', '1719281738', '0');
INSERT INTO `ey_product_img` VALUES ('159', '34', '奢华系列品质优选 持久散香 香薰蜡烛&amp;室内扩香礼盒(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101A4625.jpg', '', '800', '800', '20903', 'image/jpeg', '1', '1719282064', '0');
INSERT INTO `ey_product_img` VALUES ('160', '34', '奢华系列品质优选 持久散香 香薰蜡烛&amp;室内扩香礼盒(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101F1Y8.jpg', '', '800', '800', '48090', 'image/jpeg', '2', '1719282064', '0');
INSERT INTO `ey_product_img` VALUES ('161', '34', '奢华系列品质优选 持久散香 香薰蜡烛&amp;室内扩香礼盒(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101F1451.jpg', '', '800', '800', '24076', 'image/jpeg', '3', '1719282064', '0');
INSERT INTO `ey_product_img` VALUES ('162', '34', '奢华系列品质优选 持久散香 香薰蜡烛&amp;室内扩香礼盒(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101F12K.jpg', '', '800', '800', '20114', 'image/jpeg', '4', '1719282064', '0');
INSERT INTO `ey_product_img` VALUES ('163', '34', '奢华系列品质优选 持久散香 香薰蜡烛&amp;室内扩香礼盒(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625101F1302.jpg', '', '800', '800', '26052', 'image/jpeg', '5', '1719282064', '0');
INSERT INTO `ey_product_img` VALUES ('337', '35', '轻奢雅致系列 品质优选 持久散香室内扩香100ml(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510220KT.jpg', '', '800', '800', '47363', 'image/jpeg', '4', '1722418659', '0');
INSERT INTO `ey_product_img` VALUES ('336', '35', '轻奢雅致系列 品质优选 持久散香室内扩香100ml(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510220J12.jpg', '', '800', '800', '41737', 'image/jpeg', '3', '1722418659', '0');
INSERT INTO `ey_product_img` VALUES ('335', '35', '轻奢雅致系列 品质优选 持久散香室内扩香100ml(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062510220KK.jpg', '', '800', '800', '62344', 'image/jpeg', '2', '1722418659', '0');
INSERT INTO `ey_product_img` VALUES ('334', '35', '轻奢雅致系列 品质优选 持久散香室内扩香100ml(香薰/香氛)', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102200926.jpg', '', '800', '800', '23650', 'image/jpeg', '1', '1722418659', '0');
INSERT INTO `ey_product_img` VALUES ('460', '36', '格格纹纱布面巾 毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102U1209.jpg', '', '640', '640', '19527', 'image/jpeg', '1', '1723024958', '0');
INSERT INTO `ey_product_img` VALUES ('463', '36', '格格纹纱布面巾 毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102UXP.jpg', '', '800', '800', '108479', 'image/jpeg', '4', '1723024958', '0');
INSERT INTO `ey_product_img` VALUES ('462', '36', '格格纹纱布面巾 毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102UY21.jpg', '', '800', '800', '55499', 'image/jpeg', '3', '1723024958', '0');
INSERT INTO `ey_product_img` VALUES ('461', '36', '格格纹纱布面巾 毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625102UX46.jpg', '', '800', '800', '34660', 'image/jpeg', '2', '1723024958', '0');
INSERT INTO `ey_product_img` VALUES ('452', '37', '雪绒超细纤维毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103030500.jpg', '', '800', '800', '54878', 'image/jpeg', '1', '1723024350', '0');
INSERT INTO `ey_product_img` VALUES ('453', '37', '雪绒超细纤维毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103041335.jpg', '', '800', '800', '50478', 'image/jpeg', '2', '1723024350', '0');
INSERT INTO `ey_product_img` VALUES ('454', '37', '雪绒超细纤维毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251030411A.jpg', '', '800', '800', '53371', 'image/jpeg', '3', '1723024350', '0');
INSERT INTO `ey_product_img` VALUES ('455', '37', '雪绒超细纤维毛巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625103041460.jpg', '', '800', '800', '44071', 'image/jpeg', '4', '1723024350', '0');
INSERT INTO `ey_product_img` VALUES ('407', '50', '夏洛特开口拖春秋透气舒适男女居家防滑情侣家用木地板拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6114310U8.webp', '', '800', '800', '51056', 'image/webp', '3', '1722925397', '0');
INSERT INTO `ey_product_img` VALUES ('408', '50', '夏洛特开口拖春秋透气舒适男女居家防滑情侣家用木地板拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6114310X9.jpg', '', '800', '800', '73904', 'image/jpeg', '4', '1722925397', '0');
INSERT INTO `ey_product_img` VALUES ('406', '50', '夏洛特开口拖春秋透气舒适男女居家防滑情侣家用木地板拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6114310A6.jpg', '', '800', '800', '118143', 'image/jpeg', '2', '1722925397', '0');
INSERT INTO `ey_product_img` VALUES ('405', '50', '夏洛特开口拖春秋透气舒适男女居家防滑情侣家用木地板拖鞋', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6114254Q3.jpg', '', '800', '800', '108124', 'image/jpeg', '1', '1722925397', '0');
INSERT INTO `ey_product_img` VALUES ('413', '51', '厚道朵朵云舒适拖鞋女居家防滑吸汗小众四季厚底空调软拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614125J30.jpg', '', '800', '800', '56632', 'image/jpeg', '5', '1722925625', '0');
INSERT INTO `ey_product_img` VALUES ('412', '51', '厚道朵朵云舒适拖鞋女居家防滑吸汗小众四季厚底空调软拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614125GL.jpg', '', '800', '800', '94080', 'image/jpeg', '4', '1722925625', '0');
INSERT INTO `ey_product_img` VALUES ('411', '51', '厚道朵朵云舒适拖鞋女居家防滑吸汗小众四季厚底空调软拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614125G59.jpg', '', '800', '800', '73671', 'image/jpeg', '3', '1722925625', '0');
INSERT INTO `ey_product_img` VALUES ('410', '51', '厚道朵朵云舒适拖鞋女居家防滑吸汗小众四季厚底空调软拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614125JL.jpg', '', '800', '800', '50241', 'image/jpeg', '2', '1722925625', '0');
INSERT INTO `ey_product_img` VALUES ('409', '51', '厚道朵朵云舒适拖鞋女居家防滑吸汗小众四季厚底空调软拖', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61412455N.jpg', '', '800', '800', '37276', 'image/jpeg', '1', '1722925625', '0');
INSERT INTO `ey_product_img` VALUES ('414', '52', '明媚色彩与柔软面料，亲肤透气玫香怡人全棉床品四件套/200*230cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143034348.jpg', '', '800', '800', '46055', 'image/jpeg', '1', '1722926111', '0');
INSERT INTO `ey_product_img` VALUES ('415', '52', '明媚色彩与柔软面料，亲肤透气玫香怡人全棉床品四件套/200*230cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143044X0.jpg', '', '800', '800', '51334', 'image/jpeg', '2', '1722926111', '0');
INSERT INTO `ey_product_img` VALUES ('416', '52', '明媚色彩与柔软面料，亲肤透气玫香怡人全棉床品四件套/200*230cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143044450.jpg', '', '800', '800', '54165', 'image/jpeg', '3', '1722926111', '0');
INSERT INTO `ey_product_img` VALUES ('417', '52', '明媚色彩与柔软面料，亲肤透气玫香怡人全棉床品四件套/200*230cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143044318.jpg', '', '800', '800', '67019', 'image/jpeg', '4', '1722926111', '0');
INSERT INTO `ey_product_img` VALUES ('418', '52', '明媚色彩与柔软面料，亲肤透气玫香怡人全棉床品四件套/200*230cm', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6143044940.jpg', '', '800', '800', '61807', 'image/jpeg', '5', '1722926111', '0');
INSERT INTO `ey_product_img` VALUES ('422', '53', '魅-遥控器盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144215G2.jpg', '', '800', '800', '46910', 'image/jpeg', '2', '1722926728', '0');
INSERT INTO `ey_product_img` VALUES ('421', '53', '魅-遥控器盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144521637.jpg', '', '800', '800', '80236', 'image/jpeg', '1', '1722926728', '0');
INSERT INTO `ey_product_img` VALUES ('442', '54', '荔枝纹手挽遥控器盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144IQ46.jpg', '', '800', '800', '37057', 'image/jpeg', '4', '1722991519', '0');
INSERT INTO `ey_product_img` VALUES ('441', '54', '荔枝纹手挽遥控器盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144IUA.jpg', '', '800', '800', '46191', 'image/jpeg', '3', '1722991519', '0');
INSERT INTO `ey_product_img` VALUES ('440', '54', '荔枝纹手挽遥控器盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144ISW.jpg', '', '800', '800', '42501', 'image/jpeg', '2', '1722991519', '0');
INSERT INTO `ey_product_img` VALUES ('439', '54', '荔枝纹手挽遥控器盒', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6144I0415.jpg', '', '800', '800', '28022', 'image/jpeg', '1', '1722991519', '0');
INSERT INTO `ey_product_img` VALUES ('427', '55', '全棉质地蓬松柔软长绒触感吸水性好严选新疆材质Tide(潮色)毛巾方巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P614531D39.jpg', '', '640', '640', '18348', 'image/jpeg', '1', '1722927578', '0');
INSERT INTO `ey_product_img` VALUES ('428', '55', '全棉质地蓬松柔软长绒触感吸水性好严选新疆材质Tide(潮色)毛巾方巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6145325a3.jpg', '', '800', '800', '57904', 'image/jpeg', '2', '1722927578', '0');
INSERT INTO `ey_product_img` VALUES ('429', '55', '全棉质地蓬松柔软长绒触感吸水性好严选新疆材质Tide(潮色)毛巾方巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6145325J5.jpg', '', '800', '800', '53152', 'image/jpeg', '3', '1722927578', '0');
INSERT INTO `ey_product_img` VALUES ('430', '56', '优雅条纹经典简约毛巾系列-清馨条纹浴巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P615022Jb.jpg', '', '640', '640', '14351', 'image/jpeg', '1', '1722928078', '0');
INSERT INTO `ey_product_img` VALUES ('431', '56', '优雅条纹经典简约毛巾系列-清馨条纹浴巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150240226.jpg', '', '800', '800', '45515', 'image/jpeg', '2', '1722928078', '0');
INSERT INTO `ey_product_img` VALUES ('432', '56', '优雅条纹经典简约毛巾系列-清馨条纹浴巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150240438.jpg', '', '800', '800', '37377', 'image/jpeg', '3', '1722928078', '0');
INSERT INTO `ey_product_img` VALUES ('433', '56', '优雅条纹经典简约毛巾系列-清馨条纹浴巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150241L4.jpg', '', '800', '800', '38072', 'image/jpeg', '4', '1722928078', '0');
INSERT INTO `ey_product_img` VALUES ('434', '56', '优雅条纹经典简约毛巾系列-清馨条纹浴巾', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P61502413I.jpg', '', '800', '800', '59802', 'image/jpeg', '5', '1722928078', '0');
INSERT INTO `ey_product_img` VALUES ('435', '57', '棉花糖般的柔软触感森林物语提花-趣生活毛巾系列', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150911331.jpg', '', '800', '800', '42505', 'image/jpeg', '1', '1722928392', '0');
INSERT INTO `ey_product_img` VALUES ('436', '57', '棉花糖般的柔软触感森林物语提花-趣生活毛巾系列', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150920420.jpg', '', '800', '800', '95256', 'image/jpeg', '2', '1722928392', '0');
INSERT INTO `ey_product_img` VALUES ('437', '57', '棉花糖般的柔软触感森林物语提花-趣生活毛巾系列', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150920463.jpg', '', '800', '800', '135665', 'image/jpeg', '3', '1722928392', '0');
INSERT INTO `ey_product_img` VALUES ('438', '57', '棉花糖般的柔软触感森林物语提花-趣生活毛巾系列', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240806/1-240P6150920413.jpg', '', '800', '800', '88121', 'image/jpeg', '4', '1722928392', '0');

-- -----------------------------
-- Table structure for `ey_product_netdisk`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_netdisk`;
CREATE TABLE `ey_product_netdisk` (
  `nd_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '网盘商品id',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `netdisk_url` varchar(255) NOT NULL DEFAULT '' COMMENT '网盘地址',
  `netdisk_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '提取码',
  `unzip_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '解压密码',
  `text_content` text NOT NULL COMMENT '文本内容',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nd_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品虚拟表';


-- -----------------------------
-- Table structure for `ey_product_spec_data`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data`;
CREATE TABLE `ey_product_spec_data` (
  `spec_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '规格标记ID',
  `spec_name` varchar(255) DEFAULT '' COMMENT '规格名称',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '规格值ID',
  `spec_value` varchar(255) DEFAULT '' COMMENT '规格值',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '是否选中（0=否，1=是）',
  `open_image` tinyint(1) unsigned DEFAULT '0' COMMENT '规格是否开启图片',
  `spec_image` varchar(255) DEFAULT '' COMMENT '规格图片',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM AUTO_INCREMENT=539 DEFAULT CHARSET=utf8 COMMENT='产品规格数据表';

-- -----------------------------
-- Records of `ey_product_spec_data`
-- -----------------------------
INSERT INTO `ey_product_spec_data` VALUES ('21', '11', '411', '颜色', '21', '蜜桃色38码', '1', '0', '', '1719221921', '1719221921');
INSERT INTO `ey_product_spec_data` VALUES ('22', '11', '411', '颜色', '22', '浅咖43码', '1', '0', '', '1719221921', '1719221921');
INSERT INTO `ey_product_spec_data` VALUES ('23', '11', '411', '颜色', '23', '浅咖45码', '1', '0', '', '1719221921', '1719221921');
INSERT INTO `ey_product_spec_data` VALUES ('24', '12', '324', '颜色', '21', '蓝36-37码', '1', '0', '', '1719222644', '1719222644');
INSERT INTO `ey_product_spec_data` VALUES ('151', '13', '493', '颜色', '24', '黄39-40正码', '1', '0', '', '1719881339', '1719881339');
INSERT INTO `ey_product_spec_data` VALUES ('26', '14', '469', '颜色', '24', '黄36-37码', '1', '0', '', '1719223020', '1719223020');
INSERT INTO `ey_product_spec_data` VALUES ('27', '15', '23', '颜色', '24', '宝蓝&amp;姜黄', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data` VALUES ('28', '15', '345', '尺码', '25', '36码', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data` VALUES ('29', '15', '345', '尺码', '26', '37码', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data` VALUES ('30', '15', '345', '尺码', '27', '38码', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data` VALUES ('31', '16', '266', '尺码', '27', '37码', '1', '0', '', '1719223363', '1719223363');
INSERT INTO `ey_product_spec_data` VALUES ('32', '16', '266', '尺码', '26', '36码', '1', '0', '', '1719223363', '1719223363');
INSERT INTO `ey_product_spec_data` VALUES ('33', '16', '583', '颜色', '25', '粉色', '1', '0', '', '1719223363', '1719223363');
INSERT INTO `ey_product_spec_data` VALUES ('34', '16', '583', '颜色', '24', '蓝色', '1', '0', '', '1719223363', '1719223363');
INSERT INTO `ey_product_spec_data` VALUES ('35', '16', '266', '尺码', '28', '38码', '1', '0', '', '1719223363', '1719223363');
INSERT INTO `ey_product_spec_data` VALUES ('36', '16', '266', '尺码', '29', '39码', '1', '0', '', '1719223363', '1719223363');
INSERT INTO `ey_product_spec_data` VALUES ('37', '17', '28', '尺码', '29', '38码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('38', '17', '28', '尺码', '28', '37码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('39', '17', '289', '颜色', '26', '咖色', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('40', '17', '28', '尺码', '27', '36码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('41', '17', '289', '颜色', '25', '粉色', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('42', '17', '289', '颜色', '24', '灰色', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('43', '17', '28', '尺码', '30', '39码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('44', '17', '28', '尺码', '31', '40码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('45', '17', '28', '尺码', '32', '41码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('46', '17', '28', '尺码', '33', '42码', '1', '0', '', '1719223671', '1719223671');
INSERT INTO `ey_product_spec_data` VALUES ('47', '18', '482', '尺码', '33', '40码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('48', '18', '482', '尺码', '32', '39码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('49', '18', '482', '尺码', '30', '37码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('50', '18', '482', '尺码', '31', '38码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('51', '18', '344', '颜色', '29', '中国红', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('52', '18', '344', '颜色', '28', '柠檬黄', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('53', '18', '344', '颜色', '27', '咖啡色', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('54', '18', '344', '颜色', '26', '赤茶橘', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('55', '18', '344', '颜色', '25', '果绿', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('56', '18', '344', '颜色', '24', '樱花粉', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data` VALUES ('57', '19', '401', '尺码', '34', '43码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('58', '19', '548', '颜色', '25', '浅莲灰', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('59', '19', '548', '颜色', '26', '樱花粉', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('60', '19', '401', '尺码', '27', '36码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('61', '19', '401', '尺码', '28', '37码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('62', '19', '401', '尺码', '29', '38码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('63', '19', '401', '尺码', '30', '39码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('64', '19', '401', '尺码', '31', '40码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('65', '19', '401', '尺码', '32', '41码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('66', '19', '401', '尺码', '33', '42码', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('67', '19', '548', '颜色', '24', '柠檬黄', '1', '0', '', '1719275851', '1719275851');
INSERT INTO `ey_product_spec_data` VALUES ('68', '20', '423', '尺码', '34', '42码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('69', '20', '423', '尺码', '33', '41码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('70', '20', '423', '尺码', '32', '40码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('71', '20', '423', '尺码', '31', '39码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('72', '20', '423', '尺码', '30', '38码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('73', '20', '423', '尺码', '29', '37码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('74', '20', '423', '尺码', '28', '36码', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('75', '20', '354', '颜色', '27', '石墨灰', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('76', '20', '354', '颜色', '26', '芥末黄', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('77', '20', '354', '颜色', '25', '浅米白', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('78', '20', '354', '颜色', '24', '樱花粉', '1', '0', '', '1719276245', '1719276245');
INSERT INTO `ey_product_spec_data` VALUES ('529', '21', '331', '尺码', '30', '41码', '1', '0', '', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('527', '21', '331', '尺码', '28', '38码', '1', '0', '', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('528', '21', '331', '尺码', '29', '40码', '1', '0', '', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('524', '21', '97', '颜色', '24', '粉色', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406250T530100.jpg', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('87', '22', '569', '规格', '27', '220*240cm', '1', '0', '', '1719276941', '1719276941');
INSERT INTO `ey_product_spec_data` VALUES ('88', '22', '201', '颜色', '26', '静谧蓝', '1', '0', '', '1719276941', '1719276941');
INSERT INTO `ey_product_spec_data` VALUES ('89', '22', '569', '规格', '25', '200*230cm', '1', '0', '', '1719276941', '1719276941');
INSERT INTO `ey_product_spec_data` VALUES ('90', '22', '201', '颜色', '24', '米白', '1', '0', '', '1719276941', '1719276941');
INSERT INTO `ey_product_spec_data` VALUES ('91', '23', '179', '规格', '27', '220*240cm', '1', '0', '', '1719277140', '1719277140');
INSERT INTO `ey_product_spec_data` VALUES ('92', '23', '179', '规格', '26', '200*230cm', '1', '0', '', '1719277140', '1719277140');
INSERT INTO `ey_product_spec_data` VALUES ('93', '23', '443', '颜色', '25', '绿色', '1', '0', '', '1719277140', '1719277140');
INSERT INTO `ey_product_spec_data` VALUES ('94', '23', '443', '颜色', '24', '粉色', '1', '0', '', '1719277140', '1719277140');
INSERT INTO `ey_product_spec_data` VALUES ('95', '24', '597', '规格', '27', '220*240cm', '1', '0', '', '1719277677', '1719277677');
INSERT INTO `ey_product_spec_data` VALUES ('96', '24', '149', '颜色', '26', '雅-拿铁', '1', '0', '', '1719277677', '1719277677');
INSERT INTO `ey_product_spec_data` VALUES ('97', '24', '597', '规格', '25', '200*230cm', '1', '0', '', '1719277677', '1719277677');
INSERT INTO `ey_product_spec_data` VALUES ('98', '24', '149', '颜色', '24', '寻梦-拿铁', '1', '0', '', '1719277677', '1719277677');
INSERT INTO `ey_product_spec_data` VALUES ('99', '25', '350', '规格', '28', '220*240cm', '1', '0', '', '1719277998', '1719277998');
INSERT INTO `ey_product_spec_data` VALUES ('100', '25', '350', '规格', '27', '200*230cm', '1', '0', '', '1719277998', '1719277998');
INSERT INTO `ey_product_spec_data` VALUES ('101', '25', '1', '颜色', '26', '蓝色', '1', '0', '', '1719277998', '1719277998');
INSERT INTO `ey_product_spec_data` VALUES ('102', '25', '1', '颜色', '25', '灰色', '1', '0', '', '1719277998', '1719277998');
INSERT INTO `ey_product_spec_data` VALUES ('103', '25', '1', '颜色', '24', '粉色', '1', '0', '', '1719277998', '1719277998');
INSERT INTO `ey_product_spec_data` VALUES ('104', '27', '451', '规格', '25', '单枕芯', '1', '0', '', '1719278990', '1719278990');
INSERT INTO `ey_product_spec_data` VALUES ('105', '27', '451', '规格', '24', '两个装', '1', '0', '', '1719278990', '1719278990');
INSERT INTO `ey_product_spec_data` VALUES ('106', '28', '22', '规格', '26', '水蓝/XL', '1', '0', '', '1719279222', '1719279222');
INSERT INTO `ey_product_spec_data` VALUES ('107', '28', '22', '规格', '25', '水蓝/L', '1', '0', '', '1719279222', '1719279222');
INSERT INTO `ey_product_spec_data` VALUES ('108', '28', '22', '规格', '24', '桃粉/M', '1', '0', '', '1719279222', '1719279222');
INSERT INTO `ey_product_spec_data` VALUES ('109', '29', '235', '规格', '24', '长袖款', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('110', '29', '274', '尺码', '30', 'XL码', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('111', '29', '274', '尺码', '29', 'L码', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('112', '29', '178', '颜色', '28', '绅士灰', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('113', '29', '235', '规格', '27', '短袖款', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('114', '29', '274', '尺码', '26', 'M码', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('115', '29', '178', '颜色', '25', '藕粉', '1', '0', '', '1719280595', '1719280595');
INSERT INTO `ey_product_spec_data` VALUES ('116', '31', '196', '规格', '33', '大号', '1', '0', '', '1719281004', '1719281004');
INSERT INTO `ey_product_spec_data` VALUES ('117', '31', '196', '规格', '32', '中号', '1', '0', '', '1719281004', '1719281004');
INSERT INTO `ey_product_spec_data` VALUES ('118', '31', '196', '规格', '31', '小号', '1', '0', '', '1719281004', '1719281004');
INSERT INTO `ey_product_spec_data` VALUES ('440', '32', '213', '颜色', '31', '粉白', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data` VALUES ('439', '32', '254', '规格', '33', '单层首饰盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data` VALUES ('438', '32', '254', '规格', '35', '纸巾收纳盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data` VALUES ('437', '32', '254', '规格', '34', '长方形首饰盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data` VALUES ('436', '32', '254', '规格', '36', '纸巾收纳盒/大', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data` VALUES ('125', '33', '218', '颜色', '33', '军黄', '1', '0', '', '1719281738', '1719281738');
INSERT INTO `ey_product_spec_data` VALUES ('126', '33', '218', '颜色', '32', '藏青', '1', '0', '', '1719281738', '1719281738');
INSERT INTO `ey_product_spec_data` VALUES ('127', '33', '218', '颜色', '31', '桔色', '1', '0', '', '1719281738', '1719281738');
INSERT INTO `ey_product_spec_data` VALUES ('128', '34', '192', '规格', '33', '苹果花甜香', '1', '0', '', '1719282064', '1719282064');
INSERT INTO `ey_product_spec_data` VALUES ('129', '34', '192', '规格', '32', '白桃香', '1', '0', '', '1719282064', '1719282064');
INSERT INTO `ey_product_spec_data` VALUES ('130', '34', '192', '规格', '31', '深色麂皮香', '1', '0', '', '1719282064', '1719282064');
INSERT INTO `ey_product_spec_data` VALUES ('371', '35', '230', '规格', '34', '烟草雪松', '1', '0', '', '1722418659', '1722418659');
INSERT INTO `ey_product_spec_data` VALUES ('370', '35', '230', '规格', '33', '淡淡海风', '1', '0', '', '1722418659', '1722418659');
INSERT INTO `ey_product_spec_data` VALUES ('369', '35', '230', '规格', '32', '琥珀橘汁', '1', '0', '', '1722418659', '1722418659');
INSERT INTO `ey_product_spec_data` VALUES ('368', '35', '230', '规格', '31', '茶味渐浓', '1', '0', '', '1722418659', '1722418659');
INSERT INTO `ey_product_spec_data` VALUES ('526', '21', '331', '尺码', '27', '36码', '1', '0', '', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('538', '37', '403', '颜色', '32', '浅蓝', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-24062511591R57.jpg', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('537', '37', '403', '颜色', '35', '象牙白', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625115T4T9.jpg', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('525', '21', '97', '颜色', '26', '灰色', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240705/1-240F5142911634.jpg', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('523', '21', '97', '颜色', '25', '黄色', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240705/1-240F5142Z44K.jpg', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('535', '37', '403', '颜色', '37', '高级灰', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-2406251159464N.jpg', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('536', '37', '403', '颜色', '36', '珊瑚粉', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625115SR53.jpg', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('533', '37', '569', '规格', '39', '方巾', '1', '0', '', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('534', '37', '403', '颜色', '38', '香槟咖', '1', '1', 'https://update.eyoucms.com/app/shop/uploads/allimg/20240625/1-240625115952626.jpg', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('530', '21', '331', '尺码', '31', '43码', '1', '0', '', '1722993110', '1722993110');
INSERT INTO `ey_product_spec_data` VALUES ('441', '32', '254', '规格', '32', '二层收纳首饰盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data` VALUES ('531', '37', '569', '规格', '41', '浴巾', '1', '0', '', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('532', '37', '569', '规格', '40', '面巾', '1', '0', '', '1723024350', '1723024350');
INSERT INTO `ey_product_spec_data` VALUES ('497', '51', '311', '颜色', '58', '茉莉紫', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data` VALUES ('498', '51', '311', '颜色', '57', '薄荷绿', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data` VALUES ('499', '51', '107', '尺码', '55', '36', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data` VALUES ('494', '50', '102', '尺码', '55', '37', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data` VALUES ('493', '50', '102', '尺码', '57', '42', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data` VALUES ('492', '50', '102', '尺码', '56', '39', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data` VALUES ('490', '50', '241', '颜色', '58', '蓝色', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data` VALUES ('491', '50', '241', '颜色', '59', '米黄色', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data` VALUES ('496', '51', '107', '尺码', '59', '37', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data` VALUES ('495', '51', '107', '尺码', '60', '38', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data` VALUES ('500', '51', '311', '颜色', '56', '樱花粉', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data` VALUES ('504', '53', '206', '颜色', '71', '玫红', '1', '0', '', '1722926728', '1722926728');
INSERT INTO `ey_product_spec_data` VALUES ('503', '53', '206', '颜色', '68', '黄', '1', '0', '', '1722926728', '1722926728');
INSERT INTO `ey_product_spec_data` VALUES ('522', '54', '546', '颜色', '73', '咖色', '1', '0', '', '1722991519', '1722991519');
INSERT INTO `ey_product_spec_data` VALUES ('521', '54', '546', '颜色', '75', '红色', '1', '0', '', '1722991519', '1722991519');
INSERT INTO `ey_product_spec_data` VALUES ('507', '55', '453', '颜色', '80', '天蓝', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('508', '55', '453', '颜色', '77', '水蓝', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('509', '55', '453', '颜色', '81', '海蓝', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('510', '55', '453', '颜色', '82', '黄色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('511', '55', '453', '颜色', '83', '橙色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('512', '55', '453', '颜色', '84', '桔色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('513', '55', '453', '颜色', '85', '粉色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('514', '55', '453', '颜色', '86', '桃色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('515', '55', '453', '颜色', '87', '酒红', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data` VALUES ('516', '56', '108', '颜色', '85', '粉色', '1', '0', '', '1722928078', '1722928078');
INSERT INTO `ey_product_spec_data` VALUES ('517', '56', '108', '颜色', '86', '绿色', '1', '0', '', '1722928078', '1722928078');
INSERT INTO `ey_product_spec_data` VALUES ('518', '56', '108', '颜色', '84', '蓝色', '1', '0', '', '1722928078', '1722928078');
INSERT INTO `ey_product_spec_data` VALUES ('519', '57', '441', '颜色', '85', '粉色', '1', '0', '', '1722928392', '1722928392');
INSERT INTO `ey_product_spec_data` VALUES ('520', '57', '441', '颜色', '84', '绿色', '1', '0', '', '1722928392', '1722928392');

-- -----------------------------
-- Table structure for `ey_product_spec_data_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data_handle`;
CREATE TABLE `ey_product_spec_data_handle` (
  `handle_id` int(10) NOT NULL AUTO_INCREMENT,
  `spec_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `aid` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_name` varchar(255) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_value` varchar(255) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `open_image` tinyint(1) unsigned DEFAULT '0' COMMENT '规格是否开启图片',
  `spec_image` varchar(255) DEFAULT '' COMMENT '规格图片',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  PRIMARY KEY (`handle_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1660 DEFAULT CHARSET=utf8 COMMENT='商品规格表(product_spec_data)预处理规格数据表';

-- -----------------------------
-- Records of `ey_product_spec_data_handle`
-- -----------------------------
INSERT INTO `ey_product_spec_data_handle` VALUES ('1049', '924556', '92455', '553', '', '42', '', '1', '0', '', '1721957095', '1721957095');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1465', '125', '33', '218', '颜色', '33', '军黄', '1', '0', '', '1719281738', '1719281738');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1610', '514', '55', '453', '颜色', '86', '桃色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1613', '504', '53', '206', '颜色', '71', '玫红', '1', '0', '', '1722926728', '1722926728');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1448', '490', '50', '241', '颜色', '58', '蓝色', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1449', '491', '50', '241', '颜色', '59', '米黄色', '1', '0', '', '1722925397', '1722925397');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1611', '515', '55', '453', '颜色', '87', '酒红', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1525', '1502478', '150247', '477', '', '82', '', '1', '0', '', '1722927767', '1722927767');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1058', '1506492', '150649', '499', '', '43', '', '1', '0', '', '1721977609', '1721977609');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1061', '1645242', '164524', '250', '', '44', '', '1', '0', '', '1722242724', '1722242724');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1062', '1724572', '172457', '571', '', '45', '', '1', '0', '', '1722331497', '1722331497');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1464', '126', '33', '218', '颜色', '32', '藏青', '1', '0', '', '1719281738', '1719281738');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1288', '30', '15', '345', '尺码', '27', '38码', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1612', '503', '53', '206', '颜色', '68', '黄', '1', '0', '', '1722926728', '1722926728');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1287', '29', '15', '345', '尺码', '26', '37码', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1285', '27', '15', '23', '颜色', '24', '宝蓝&amp;姜黄', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1286', '28', '15', '345', '尺码', '25', '36码', '1', '0', '', '1719223196', '1719223196');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1283', '48', '18', '482', '尺码', '32', '39码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1284', '47', '18', '482', '尺码', '33', '40码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1282', '50', '18', '482', '尺码', '31', '38码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1281', '49', '18', '482', '尺码', '30', '37码', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1277', '54', '18', '344', '颜色', '26', '赤茶橘', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1273', '24', '12', '324', '颜色', '21', '蓝36-37码', '1', '0', '', '1719222644', '1719222644');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1274', '151', '13', '493', '颜色', '24', '黄39-40正码', '1', '0', '', '1719881339', '1719881339');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1275', '56', '18', '344', '颜色', '24', '樱花粉', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1618', '498', '51', '311', '颜色', '57', '薄荷绿', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1589', '21', '11', '411', '颜色', '21', '蜜桃色38码', '1', '0', '', '1719221921', '1719221921');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1590', '22', '11', '411', '颜色', '22', '浅咖43码', '1', '0', '', '1719221921', '1719221921');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1591', '23', '11', '411', '颜色', '23', '浅咖45码', '1', '0', '', '1719221921', '1719221921');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1616', '499', '51', '107', '尺码', '55', '36', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1617', '500', '51', '311', '颜色', '56', '樱花粉', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1079', '1723026', '172302', '26', '', '46', '', '1', '0', '', '1722417782', '1722417782');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1280', '51', '18', '344', '颜色', '29', '中国红', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1279', '52', '18', '344', '颜色', '28', '柠檬黄', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1278', '53', '18', '344', '颜色', '27', '咖啡色', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1276', '55', '18', '344', '颜色', '25', '果绿', '1', '0', '', '1719275500', '1719275500');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1632', '438', '32', '254', '规格', '35', '纸巾收纳盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1633', '436', '32', '254', '规格', '36', '纸巾收纳盒/大', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1629', '441', '32', '254', '规格', '32', '二层收纳首饰盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1630', '439', '32', '254', '规格', '33', '单层首饰盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1631', '437', '32', '254', '规格', '34', '长方形首饰盒', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1621', '495', '51', '107', '尺码', '60', '38', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1628', '440', '32', '213', '颜色', '31', '粉白', '1', '0', '', '1722506522', '1722506522');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1619', '497', '51', '311', '颜色', '58', '茉莉紫', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1620', '496', '51', '107', '尺码', '59', '37', '1', '0', '', '1722925625', '1722925625');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1463', '127', '33', '218', '颜色', '31', '桔色', '1', '0', '', '1719281738', '1719281738');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1362', '1017087', '101708', '86', '', '54', '', '1', '0', '', '1722824228', '1722824228');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1659', '1114581', '111458', '587', '', '88', '', '1', '0', '', '1723086898', '1723086898');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1109', '1753157', '175315', '151', '', '47', '', '1', '0', '', '1722419595', '1722419595');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1173', '1443398', '144339', '400', '', '52', '', '1', '0', '', '1722494619', '1722494619');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1113', '1151401', '115140', '405', '', '49', '', '1', '0', '', '1722484300', '1722484300');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1255', '1553358', '155335', '358', '', '53', '', '1', '0', '', '1722498815', '1722498815');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1609', '513', '55', '453', '颜色', '85', '粉色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1658', '517', '56', '108', '颜色', '86', '绿色', '1', '0', '', '1722928078', '1722928078');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1656', '518', '56', '108', '颜色', '84', '蓝色', '1', '0', '', '1722928078', '1722928078');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1599', '519', '57', '441', '颜色', '85', '粉色', '1', '0', '', '1722928392', '1722928392');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1657', '516', '56', '108', '颜色', '85', '粉色', '1', '0', '', '1722928078', '1722928078');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1539', '1510281', '151028', '281', '', '86', '', '1', '0', '', '1722928228', '1722928228');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1598', '520', '57', '441', '颜色', '84', '绿色', '1', '0', '', '1722928392', '1722928392');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1608', '512', '55', '453', '颜色', '84', '桔色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1607', '511', '55', '453', '颜色', '83', '橙色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1606', '510', '55', '453', '颜色', '82', '黄色', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1605', '509', '55', '453', '颜色', '81', '海蓝', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1604', '507', '55', '453', '颜色', '80', '天蓝', '1', '0', '', '1722927578', '1722927578');
INSERT INTO `ey_product_spec_data_handle` VALUES ('1603', '508', '55', '453', '颜色', '77', '水蓝', '1', '0', '', '1722927578', '1722927578');

-- -----------------------------
-- Table structure for `ey_product_spec_preset`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_preset`;
CREATE TABLE `ey_product_spec_preset` (
  `preset_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `preset_mark_id` int(10) DEFAULT '0' COMMENT '预设参数标记ID',
  `preset_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `preset_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_sync` tinyint(1) unsigned DEFAULT '0' COMMENT '是否同步到已发布的商品规格：0否，1是。',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `product_add` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在商品添加或编辑页添加的规格信息，0否，1是，默认0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`preset_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='产品规格预设表';

-- -----------------------------
-- Records of `ey_product_spec_preset`
-- -----------------------------
INSERT INTO `ey_product_spec_preset` VALUES ('1', '1', '产品颜色', '红', '0', '100', '0', '0', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('2', '1', '产品颜色', '蓝', '0', '100', '0', '0', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('3', '1', '产品颜色', '黄', '0', '100', '0', '0', '1565752372', '1565752623');

-- -----------------------------
-- Table structure for `ey_product_spec_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value`;
CREATE TABLE `ey_product_spec_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值ID',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '规格价格',
  `spec_crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品规格划线价',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '规格库存',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '销售量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀库存(独立库存，与spec_stock/限时折扣库存不同步)',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀销售量',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-秒杀',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣库存(独立库存，与spec_stock/秒杀库存不同步)',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣销售量',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-限时折扣',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM AUTO_INCREMENT=933 DEFAULT CHARSET=utf8 COMMENT='产品多规格组装表';

-- -----------------------------
-- Records of `ey_product_spec_value`
-- -----------------------------
INSERT INTO `ey_product_spec_value` VALUES ('27', '11', '21', '39.90', '0.00', '998', '1', '0.00', '0', '0', '0', '1719221921', '1719221921', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('28', '11', '22', '39.90', '0.00', '999', '0', '0.00', '0', '0', '0', '1719221921', '1719221921', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('29', '11', '23', '39.90', '0.00', '999', '0', '0.00', '0', '0', '0', '1719221921', '1719221921', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('30', '12', '21', '59.00', '0.00', '994', '5', '0.00', '0', '0', '0', '1719222644', '1719222644', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('239', '13', '24', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719881339', '1719881339', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('32', '14', '24', '69.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223020', '1719223020', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('33', '15', '24_25', '89.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223196', '1719223196', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('34', '15', '24_26', '89.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223196', '1719223196', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('35', '15', '24_27', '89.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223196', '1719223196', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('36', '16', '24_26', '35.40', '0.00', '998', '1', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('37', '16', '24_27', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('38', '16', '24_28', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('39', '16', '24_29', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('40', '16', '25_26', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('41', '16', '25_27', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('42', '16', '25_28', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('43', '16', '25_29', '35.40', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223363', '1719223363', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('44', '17', '24_27', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('45', '17', '24_28', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('46', '17', '24_29', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('47', '17', '24_30', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('48', '17', '24_31', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('49', '17', '24_32', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('50', '17', '24_33', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('51', '17', '25_27', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('52', '17', '25_28', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('53', '17', '25_29', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('54', '17', '25_30', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('55', '17', '25_31', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('56', '17', '25_32', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('57', '17', '25_33', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('58', '17', '26_27', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('59', '17', '26_28', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('60', '17', '26_29', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('61', '17', '26_30', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('62', '17', '26_31', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('63', '17', '26_32', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('64', '17', '26_33', '79.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719223671', '1719223671', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('65', '18', '24_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('66', '18', '25_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('67', '18', '26_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('68', '18', '27_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('69', '18', '28_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('70', '18', '29_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('71', '18', '24_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('72', '18', '25_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('73', '18', '26_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('74', '18', '27_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('75', '18', '28_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('76', '18', '29_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('77', '18', '24_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('78', '18', '25_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('79', '18', '26_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('80', '18', '27_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('81', '18', '28_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('82', '18', '29_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('83', '18', '24_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('84', '18', '25_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('85', '18', '26_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('86', '18', '27_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('87', '18', '28_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('88', '18', '29_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719275500', '1719275500', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('89', '19', '24_27', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('90', '19', '24_28', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('91', '19', '24_29', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('92', '19', '24_30', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('93', '19', '24_31', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('94', '19', '24_32', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('95', '19', '24_33', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('96', '19', '24_34', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('97', '19', '25_27', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('98', '19', '25_28', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('99', '19', '25_29', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('100', '19', '25_30', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('101', '19', '25_31', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('102', '19', '25_32', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('103', '19', '25_33', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('104', '19', '25_34', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('105', '19', '26_27', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('106', '19', '26_28', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('107', '19', '26_29', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('108', '19', '26_30', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('109', '19', '26_31', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('110', '19', '26_32', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('111', '19', '26_33', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('112', '19', '26_34', '39.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1719275851', '1719275851', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('113', '20', '24_28', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('114', '20', '24_29', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('115', '20', '24_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('116', '20', '24_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('117', '20', '24_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('118', '20', '24_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('119', '20', '24_34', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('120', '20', '25_28', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('121', '20', '25_29', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('122', '20', '25_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('123', '20', '25_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('124', '20', '25_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('125', '20', '25_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('126', '20', '25_34', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('127', '20', '26_28', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('128', '20', '26_29', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('129', '20', '26_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('130', '20', '26_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('131', '20', '26_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('132', '20', '26_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('133', '20', '26_34', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('134', '20', '27_28', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('135', '20', '27_29', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('136', '20', '27_30', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('137', '20', '27_31', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('138', '20', '27_32', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('139', '20', '27_33', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('140', '20', '27_34', '39.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276245', '1719276245', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('916', '21', '26_30', '51.00', '61.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('915', '21', '26_29', '51.00', '61.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('914', '21', '26_28', '51.00', '61.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('913', '21', '26_27', '51.00', '61.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('911', '21', '25_30', '50.00', '60.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('912', '21', '25_31', '50.00', '60.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('909', '21', '25_28', '50.00', '60.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('910', '21', '25_29', '50.00', '60.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('908', '21', '25_27', '50.00', '60.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('156', '22', '24_25', '1999.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276941', '1719276941', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('157', '22', '24_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276941', '1719276941', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('158', '22', '25_26', '1999.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276941', '1719276941', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('159', '22', '26_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719276941', '1719276941', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('160', '23', '24_26', '2299.00', '0.00', '998', '1', '0.00', '0', '0', '0', '1719277140', '1719277140', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('161', '23', '24_27', '2499.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277140', '1719277140', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('162', '23', '25_26', '2299.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277140', '1719277140', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('163', '23', '25_27', '2499.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277140', '1719277140', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('164', '24', '24_25', '1999.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277677', '1719277677', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('165', '24', '24_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277677', '1719277677', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('166', '24', '25_26', '1999.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277677', '1719277677', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('167', '24', '26_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277677', '1719277677', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('168', '25', '24_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277998', '1719277998', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('169', '25', '25_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277998', '1719277998', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('170', '25', '26_27', '2199.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277998', '1719277998', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('171', '25', '24_28', '2399.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277998', '1719277998', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('172', '25', '25_28', '2399.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277998', '1719277998', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('173', '25', '26_28', '2399.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719277998', '1719277998', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('174', '27', '24', '238.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719278990', '1719278990', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('175', '27', '25', '45.00', '0.00', '0', '0', '0.00', '0', '0', '0', '1719278990', '1719278990', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('176', '28', '24', '399.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719279222', '1719279222', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('177', '28', '25', '399.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719279222', '1719279222', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('178', '28', '26', '399.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719279222', '1719279222', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('179', '29', '24_25_26', '559.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('180', '29', '24_25_29', '559.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('181', '29', '24_25_30', '559.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('182', '29', '24_26_28', '559.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('183', '29', '24_28_29', '559.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('184', '29', '24_28_30', '559.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('185', '29', '25_26_27', '479.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('186', '29', '25_27_29', '479.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('187', '29', '25_27_30', '479.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('188', '29', '26_27_28', '479.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('189', '29', '27_28_29', '479.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('190', '29', '27_28_30', '479.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719280595', '1719280595', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('191', '31', '31', '159.00', '0.00', '988', '11', '0.00', '0', '0', '0', '1719281004', '1722221778', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('192', '31', '32', '189.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719281004', '1719281004', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('193', '31', '33', '219.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719281004', '1719281004', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('780', '32', '31_34', '469.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722506522', '1722506522', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('779', '32', '31_33', '279.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722506522', '1722506522', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('778', '32', '31_32', '239.00', '0.00', '988', '11', '0.00', '0', '0', '0', '1722506522', '1722591489', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('199', '33', '31', '85.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719281738', '1719281738', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('200', '33', '32', '85.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719281738', '1719281738', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('201', '33', '33', '85.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1719281738', '1719281738', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('637', '34', '32', '129.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1721955184', '1721955184', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('638', '34', '33', '129.00', '0.00', '998', '1', '0.00', '0', '0', '0', '1721955184', '1721955184', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('657', '35', '34', '99.00', '119.00', '998', '38', '0.00', '0', '0', '0', '1722418659', '1722937933', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('656', '35', '33', '99.00', '119.00', '998', '69', '0.00', '0', '0', '0', '1722418659', '1722418659', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('655', '35', '32', '99.00', '119.00', '999', '35', '0.00', '0', '0', '0', '1722418659', '1722418659', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('654', '35', '31', '99.00', '119.00', '997', '47', '0.00', '0', '0', '0', '1722418659', '1723087051', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('906', '21', '24_30', '49.00', '59.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('907', '21', '24_31', '49.00', '59.00', '0', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('932', '37', '38_41', '238.00', '248.00', '997', '2', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('931', '37', '37_41', '238.00', '248.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('930', '37', '36_41', '238.00', '248.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('929', '37', '35_41', '238.00', '248.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('928', '37', '32_41', '238.00', '248.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('927', '37', '38_40', '68.00', '75.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('926', '37', '37_40', '68.00', '75.00', '998', '1', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('925', '37', '36_40', '68.00', '75.00', '998', '1', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('924', '37', '35_40', '68.00', '75.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('905', '21', '24_29', '49.00', '59.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('904', '21', '24_28', '49.00', '59.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('923', '37', '32_40', '68.00', '75.00', '999', '0', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('921', '37', '37_39', '38.00', '45.00', '998', '1', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('922', '37', '38_39', '38.00', '45.00', '988', '11', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('903', '21', '24_27', '49.00', '59.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('781', '32', '31_35', '189.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722506522', '1722506522', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('636', '34', '31', '129.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1721955184', '1721955184', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('919', '37', '35_39', '38.00', '45.00', '998', '1', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('920', '37', '36_39', '38.00', '45.00', '998', '1', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('917', '21', '26_31', '51.00', '61.00', '999', '0', '0.00', '0', '0', '0', '1722993110', '1722993110', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('782', '32', '31_36', '229.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722506522', '1722506522', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('918', '37', '32_39', '38.00', '45.00', '0', '4', '0.00', '0', '0', '0', '1723024350', '1723024350', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('878', '51', '58_60', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('877', '51', '57_60', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('876', '51', '56_60', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('875', '51', '58_59', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('874', '51', '57_59', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('873', '51', '56_59', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('872', '51', '55_58', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('871', '51', '55_57', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('869', '50', '57_59', '48.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925397', '1722925397', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('868', '50', '56_59', '48.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925397', '1722925397', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('867', '50', '55_59', '48.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925397', '1722925397', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('866', '50', '57_58', '48.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925397', '1722925397', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('865', '50', '56_58', '48.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925397', '1722925397', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('864', '50', '55_58', '48.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925397', '1722925397', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('870', '51', '55_56', '58.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722925625', '1722925625', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('882', '53', '71', '112.80', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722926728', '1722926728', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('881', '53', '68', '112.80', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722926728', '1722926728', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('901', '54', '73', '135.00', '0.00', '9997', '2', '0.00', '0', '0', '0', '1722991532', '1722991532', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('902', '54', '75', '135.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722991532', '1722991532', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('885', '55', '77', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('886', '55', '80', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('887', '55', '81', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('888', '55', '82', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('889', '55', '83', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('890', '55', '84', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('891', '55', '85', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('892', '55', '86', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('893', '55', '87', '29.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722927578', '1722927578', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('894', '56', '84', '99.00', '0.00', '998', '1', '0.00', '0', '0', '0', '1722928078', '1722928078', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('895', '56', '85', '99.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722928078', '1722928078', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('896', '56', '86', '99.00', '0.00', '999', '0', '0.00', '0', '0', '0', '1722928078', '1722928078', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('897', '57', '84', '159.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722928392', '1722928392', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value` VALUES ('898', '57', '85', '159.00', '0.00', '9999', '0', '0.00', '0', '0', '0', '1722928392', '1722928392', '0.00', '0', '0', '0');

-- -----------------------------
-- Table structure for `ey_product_spec_value_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value_handle`;
CREATE TABLE `ey_product_spec_value_handle` (
  `value_id` int(20) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '对应 product_spec_value 数据表',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `spec_crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品规格价格表(product_spec_value)预处理规格价格表';

-- -----------------------------
-- Records of `ey_product_spec_value_handle`
-- -----------------------------
INSERT INTO `ey_product_spec_value_handle` VALUES ('894', '56', '84', '99.00', '0.00', '999', '0', '1722928078', '1722928078', '0.00', '0', '0', '0', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value_handle` VALUES ('895', '56', '85', '99.00', '0.00', '999', '0', '1722928078', '1722928078', '0.00', '0', '0', '0', '0.00', '0', '0', '0');
INSERT INTO `ey_product_spec_value_handle` VALUES ('896', '56', '86', '99.00', '0.00', '999', '0', '1722928078', '1722928078', '0.00', '0', '0', '0', '0.00', '0', '0', '0');

-- -----------------------------
-- Table structure for `ey_product_users_discount`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_users_discount`;
CREATE TABLE `ey_product_users_discount` (
  `users_discount_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员等级ID',
  `users_discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员等级价格',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`users_discount_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `level_id` (`level_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品指定会员等级折扣列表';


-- -----------------------------
-- Table structure for `ey_quickentry`
-- -----------------------------
DROP TABLE IF EXISTS `ey_quickentry`;
CREATE TABLE `ey_quickentry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '' COMMENT '名称',
  `laytext` varchar(50) DEFAULT '' COMMENT '完整标题',
  `type` smallint(5) DEFAULT '0' COMMENT '归类，1=快捷入口，2=内容统计',
  `controller` varchar(50) DEFAULT '' COMMENT '控制器名',
  `action` varchar(20) DEFAULT '' COMMENT '操作名',
  `vars` varchar(100) DEFAULT '' COMMENT 'URL参数字符串',
  `groups` smallint(5) DEFAULT '0' COMMENT '分组，1=模型',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是',
  `litpic` varchar(100) DEFAULT '',
  `statistics_type` int(5) DEFAULT '0' COMMENT 'statistics_data表对应的type值',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=有效，0=无效',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COMMENT='快捷入口表';

-- -----------------------------
-- Records of `ey_quickentry`
-- -----------------------------
INSERT INTO `ey_quickentry` VALUES ('1', '产品', '产品列表', '1', 'Product', 'index', 'channel=2', '1', '0', '', '0', '1', '3', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('2', '下载', '下载列表', '1', 'Download', 'index', 'channel=4', '1', '0', '', '0', '1', '4', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('3', '文章', '文章列表', '1', 'Article', 'index', 'channel=1', '1', '0', '', '0', '1', '6', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('4', '图集', '图集列表', '1', 'Images', 'index', 'channel=3', '1', '0', '', '0', '1', '7', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('5', '内容管理', '内容列表', '1', 'Archives', 'index', '', '0', '0', '', '0', '1', '13', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('7', '回收站', '回收站', '1', 'RecycleBin', 'archives_index', '', '0', '1', '', '0', '1', '4', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('8', '栏目管理', '栏目管理', '1', 'Arctype', 'index', '', '0', '0', '', '0', '1', '5', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('9', '留言', '留言管理', '1', 'Form', 'index', '', '1', '0', '', '0', '1', '6', '1569232484', '1680508811');
INSERT INTO `ey_quickentry` VALUES ('10', '网站信息', '网站信息', '1', 'System', 'web', '', '0', '0', '', '0', '1', '7', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('11', '水印配置', '水印配置', '1', 'System', 'water', '', '0', '1', '', '0', '1', '8', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('12', '缩略图配置', '缩略图配置', '1', 'System', 'thumb', '', '0', '1', '', '0', '1', '9', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('13', '数据备份', '数据备份', '1', 'Tools', 'index', '', '0', '0', '', '0', '1', '11', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('14', 'URL配置', 'URL配置', '1', 'Seo', 'seo', '', '0', '1', '', '0', '1', '1', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('15', '模板管理', '模板管理', '1', 'Filemanager', 'index', '', '0', '1', '', '0', '1', '6', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('16', 'SiteMap', 'SiteMap', '1', 'Sitemap', 'index', '', '0', '1', '', '0', '1', '12', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('17', '频道模型', '频道模型', '1', 'Channeltype', 'index', '', '0', '1', '', '0', '1', '2', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('18', '广告管理', '广告管理', '1', 'AdPosition', 'index', '', '0', '0', '', '0', '1', '3', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('19', '友情链接', '友情链接', '1', 'Links', 'index', '', '0', '0', '', '0', '1', '10', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('20', 'Tags管理', 'Tags管理', '1', 'Tags', 'index', '', '0', '1', '', '0', '1', '14', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('21', '管理员管理', '管理员管理', '1', 'Admin', 'index', '', '0', '0', '', '0', '1', '15', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('22', '接口配置', '接口配置', '1', 'System', 'api_conf', '', '0', '1', '', '0', '1', '16', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('23', '文章', '文章列表', '2', 'Article', 'index', 'channel=1', '1', '1', '', '0', '1', '1', '1569310798', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('24', '产品', '产品列表', '2', 'Product', 'index', 'channel=2', '1', '0', '', '0', '1', '2', '1569310798', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('25', '下载', '下载列表', '2', 'Download', 'index', 'channel=4', '1', '0', '', '0', '1', '4', '1569310798', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('26', '图集', '图集列表', '2', 'Images', 'index', 'channel=3', '1', '0', '', '0', '1', '3', '1569310798', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('27', '留言', '留言管理', '2', 'Form', 'index', '', '1', '0', '', '0', '1', '5', '1569310798', '1680508811');
INSERT INTO `ey_quickentry` VALUES ('28', '广告', '广告管理', '2', 'AdPosition', 'index', '', '0', '1', '', '0', '1', '8', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('29', '友情链接', '友情链接', '2', 'Links', 'index', '', '0', '1', '', '0', '1', '9', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('30', 'Tags标签', 'Tags管理', '2', 'Tags', 'index', '', '0', '1', '', '0', '1', '10', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('31', '会员', '会员管理', '2', 'Member', 'users_index', '', '0', '0', '', '0', '1', '7', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('32', '插件应用', '插件应用', '1', 'Weapp', 'index', '', '0', '0', '', '0', '1', '17', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('33', '会员中心', '会员中心', '1', 'Member', 'users_index', '', '0', '0', '', '0', '1', '18', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('34', '商城中心', '商城中心', '1', 'Shop', 'index', '', '0', '0', '', '0', '0', '19', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('35', '订单', '订单管理', '2', 'Shop', 'index', '', '0', '0', '', '0', '0', '6', '1569232484', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('36', '人才招聘', '人才招聘列表', '1', 'Custom', 'index', 'channel=9', '1', '0', '', '0', '1', '100', '1574233851', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('37', '人才招聘', '人才招聘列表', '2', 'Custom', 'index', 'channel=9', '1', '0', '', '0', '1', '100', '1574233853', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('39', '专题', '专题列表', '2', 'Special', 'index', 'channel=7', '1', '0', '', '0', '0', '7', '1600078966', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('41', '视频', '视频列表', '2', 'Media', 'index', 'channel=5', '1', '0', '', '0', '0', '4', '1569310798', '1713314656');
INSERT INTO `ey_quickentry` VALUES ('42', '商品数', '商品总数', '21', 'ShopProduct', 'index', '', '1', '1', '', '6', '1', '1', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('43', '充值金额', '充值总额', '21', 'Member', 'money_index', 'status=2', '1', '0', '', '5', '1', '5', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('44', '会员数', '会员总数', '21', 'Member', 'users_index', '', '1', '0', '', '4', '1', '6', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('45', '销售额', '销售总额', '21', 'Statistics', 'index', 'conceal=1', '1', '1', '', '3', '1', '3', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('46', '订单数', '订单总数', '21', 'Order', 'index', '', '1', '1', '', '2', '1', '2', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('47', '浏览量', '总浏览量', '21', '', '', '', '1', '1', '', '1', '1', '4', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('48', '浏览量', '总浏览量', '31', '', '', '', '1', '1', '', '1', '1', '5', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('49', '订单数', '订单总数', '31', 'Order', 'index', '', '1', '1', '', '2', '1', '3', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('50', '销售额', '销售总额', '31', 'Statistics', 'index', 'conceal=1', '1', '1', '', '3', '1', '4', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('51', '会员数', '会员总数', '31', 'Member', 'users_index', '', '1', '1', '', '4', '1', '1', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('52', '充值金额', '充值总额', '31', 'Member', 'money_index', 'status=2', '1', '1', '', '5', '1', '6', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('53', '商品数', '商品总数', '31', 'ShopProduct', 'index', '', '1', '1', '', '6', '1', '2', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('54', '文章数', '文章总数', '31', 'Article', 'index', '', '1', '1', '', '7', '1', '7', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('55', 'TAG标签数', 'TAG标签总数', '31', 'Tags', 'index', '', '1', '1', '', '8', '1', '8', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('56', '待审文档', '待审总数', '31', 'Archives', 'index_draft', 'menu=1', '1', '1', '', '9', '1', '9', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('57', '充值订单', '充值订单', '11', 'Member', 'money_index', 'status=2', '0', '1', '/public/static/admin/images/theme/survey_chongzhi.png', '0', '1', '7', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('58', '订单查询', '订单查询', '11', 'Order', 'index', '', '0', '1', '/public/static/admin/images/theme/survey_dingdan.png', '0', '1', '2', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('59', '发布商品', '发布商品', '11', 'ShopProduct', 'add', 'firstrun=1', '0', '1', '/public/static/admin/images/theme/survey_fabu.png', '0', '1', '1', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('60', '前往发货', '前往发货', '11', 'Shop', 'index', 'order_status=1', '0', '1', '/public/static/admin/images/theme/survey_fahuo.png', '0', '1', '2', '1569232484', '1669604332');
INSERT INTO `ey_quickentry` VALUES ('61', '会员管理', '会员管理', '11', 'Member', 'users_index', '', '0', '1', '/public/static/admin/images/theme/survey_huiyuan.png', '0', '1', '5', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('63', '评价管理', '评价管理', '11', 'ShopComment', 'comment_index', '', '0', '1', '/public/static/admin/images/theme/survey_pingjia.png', '0', '1', '4', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('64', '售后维权', '售后维权', '11', 'ShopService', 'after_service', '', '0', '1', '/public/static/admin/images/theme/survey_weiquan.png', '0', '1', '3', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('65', '优惠券', '优惠券', '11', 'Weapp', 'execute', 'sm=Coupons&sc=Coupons&sa=index', '0', '0', '/public/static/admin/images/theme/survey_youhuiquan.png', '0', '1', '9', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('66', '运费模板', '运费模板', '11', 'Shop', 'shipping_template', '', '0', '0', '/public/static/admin/images/theme/survey_yunfei.png', '0', '1', '8', '1569232484', '1713515698');
INSERT INTO `ey_quickentry` VALUES ('67', '支付设置', '支付设置', '11', 'System', 'api_conf', '', '0', '1', '/public/static/admin/images/theme/survey_zhifu.png', '0', '1', '6', '1569232484', '1713515698');

-- -----------------------------
-- Table structure for `ey_region`
-- -----------------------------
DROP TABLE IF EXISTS `ey_region`;
CREATE TABLE `ey_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `level` (`level`) USING BTREE,
  KEY `initial` (`initial`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=47991 DEFAULT CHARSET=utf8 COMMENT='区域表';

-- -----------------------------
-- Records of `ey_region`
-- -----------------------------
INSERT INTO `ey_region` VALUES ('1', '北京市', '1', '0', 'B');
INSERT INTO `ey_region` VALUES ('2', '北京市', '2', '1', 'B');
INSERT INTO `ey_region` VALUES ('3', '东城区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('14', '西城区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('22', '崇文区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('30', '宣武区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('39', '朝阳区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('83', '丰台区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('105', '石景山区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('115', '海淀区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('145', '门头沟区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('159', '房山区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('188', '通州区', '3', '2', 'T');
INSERT INTO `ey_region` VALUES ('204', '顺义区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('227', '昌平区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('245', '大兴区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('264', '怀柔区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('281', '平谷区', '3', '2', 'P');
INSERT INTO `ey_region` VALUES ('301', '密云区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('322', '延庆区', '3', '2', 'Y');
INSERT INTO `ey_region` VALUES ('338', '天津市', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('339', '天津市', '2', '338', 'T');
INSERT INTO `ey_region` VALUES ('340', '和平区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('347', '河东区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('361', '河西区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('375', '南开区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('388', '河北区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('399', '红桥区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('410', '塘沽区', '3', '339', 'T');
INSERT INTO `ey_region` VALUES ('425', '汉沽区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('435', '大港区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('445', '东丽区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('460', '西青区', '3', '339', 'X');
INSERT INTO `ey_region` VALUES ('473', '津南区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('488', '北辰区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('504', '武清区', '3', '339', 'W');
INSERT INTO `ey_region` VALUES ('538', '宝坻区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('570', '宁河区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('586', '静海区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('608', '蓟州区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('636', '河北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('637', '石家庄市', '2', '636', 'S');
INSERT INTO `ey_region` VALUES ('638', '市辖区', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('639', '长安区', '3', '637', 'C');
INSERT INTO `ey_region` VALUES ('651', '桥东区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('662', '桥西区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('675', '新华区', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('691', '井陉矿区', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('697', '裕华区', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('708', '井陉县', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('726', '正定县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('736', '栾城县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('745', '行唐县', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('761', '灵寿县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('777', '高邑县', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('783', '深泽县', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('790', '赞皇县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('802', '无极县', '3', '637', 'W');
INSERT INTO `ey_region` VALUES ('814', '平山县', '3', '637', 'P');
INSERT INTO `ey_region` VALUES ('838', '元氏县', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('854', '赵县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('866', '辛集市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('882', '藁城市', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('898', '晋州市', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('909', '新乐市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('922', '鹿泉市', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('936', '唐山市', '2', '636', 'T');
INSERT INTO `ey_region` VALUES ('937', '市辖区', '3', '936', 'S');
INSERT INTO `ey_region` VALUES ('938', '路南区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('952', '路北区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('965', '古冶区', '3', '936', 'G');
INSERT INTO `ey_region` VALUES ('977', '开平区', '3', '936', 'K');
INSERT INTO `ey_region` VALUES ('989', '丰南区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1007', '丰润区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1034', '滦县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1048', '滦南县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1067', '乐亭县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1085', '迁西县', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1104', '玉田县', '3', '936', 'Y');
INSERT INTO `ey_region` VALUES ('1125', '唐海县', '3', '936', 'T');
INSERT INTO `ey_region` VALUES ('1140', '遵化市', '3', '936', 'Z');
INSERT INTO `ey_region` VALUES ('1168', '迁安市', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1188', '秦皇岛市', '2', '636', 'Q');
INSERT INTO `ey_region` VALUES ('1189', '市辖区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1190', '海港区', '3', '1188', 'H');
INSERT INTO `ey_region` VALUES ('1208', '山海关区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1218', '北戴河区', '3', '1188', 'B');
INSERT INTO `ey_region` VALUES ('1223', '青龙县', '3', '1188', 'Q');
INSERT INTO `ey_region` VALUES ('1249', '昌黎县', '3', '1188', 'C');
INSERT INTO `ey_region` VALUES ('1266', '抚宁县', '3', '1188', 'F');
INSERT INTO `ey_region` VALUES ('1278', '卢龙县', '3', '1188', 'L');
INSERT INTO `ey_region` VALUES ('1291', '邯郸市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('1292', '市辖区', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1293', '邯山区', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1307', '丛台区', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1319', '复兴区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1329', '峰峰矿区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1339', '邯郸县', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1350', '临漳县', '3', '1291', 'L');
INSERT INTO `ey_region` VALUES ('1365', '成安县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1375', '大名县', '3', '1291', 'D');
INSERT INTO `ey_region` VALUES ('1396', '涉县', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1414', '磁县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1434', '肥乡县', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1444', '永年县', '3', '1291', 'Y');
INSERT INTO `ey_region` VALUES ('1465', '邱县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1473', '鸡泽县', '3', '1291', 'J');
INSERT INTO `ey_region` VALUES ('1481', '广平县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1489', '馆陶县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1498', '魏县', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1520', '曲周县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1531', '武安市', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1554', '邢台市', '2', '636', 'X');
INSERT INTO `ey_region` VALUES ('1555', '市辖区', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1556', '桥东区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1564', '桥西区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1572', '邢台县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1593', '临城县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1602', '内邱县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1612', '柏乡县', '3', '1554', 'B');
INSERT INTO `ey_region` VALUES ('1619', '隆尧县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1633', '任县', '3', '1554', 'R');
INSERT INTO `ey_region` VALUES ('1642', '南和县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1651', '宁晋县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1669', '巨鹿县', '3', '1554', 'J');
INSERT INTO `ey_region` VALUES ('1680', '新河县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1687', '广宗县', '3', '1554', 'G');
INSERT INTO `ey_region` VALUES ('1696', '平乡县', '3', '1554', 'P');
INSERT INTO `ey_region` VALUES ('1704', '威县', '3', '1554', 'W');
INSERT INTO `ey_region` VALUES ('1721', '清河县', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1728', '临西县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1738', '南宫市', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1754', '沙河市', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1772', '保定市', '2', '636', 'B');
INSERT INTO `ey_region` VALUES ('1773', '市辖区', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('1774', '新市区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1787', '北市区', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('1796', '南市区', '3', '1772', 'N');
INSERT INTO `ey_region` VALUES ('1806', '满城区', '3', '1772', 'M');
INSERT INTO `ey_region` VALUES ('1820', '清苑区', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('1839', '涞水县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1856', '阜平县', '3', '1772', 'F');
INSERT INTO `ey_region` VALUES ('1870', '徐水区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1885', '定兴县', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('1902', '唐县', '3', '1772', 'T');
INSERT INTO `ey_region` VALUES ('1923', '高阳县', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('1933', '容城县', '3', '1772', 'R');
INSERT INTO `ey_region` VALUES ('1942', '涞源县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1960', '望都县', '3', '1772', 'W');
INSERT INTO `ey_region` VALUES ('1969', '安新县', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('1982', '易县', '3', '1772', 'Y');
INSERT INTO `ey_region` VALUES ('2010', '曲阳县', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('2029', '蠡县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('2043', '顺平县', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('2054', '博野县', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('2062', '雄县', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('2072', '涿州市', '3', '1772', 'Z');
INSERT INTO `ey_region` VALUES ('2088', '定州市', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('2114', '安国市', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('2126', '高碑店市', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('2142', '张家口市', '2', '636', 'Z');
INSERT INTO `ey_region` VALUES ('2143', '市辖区', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2144', '桥东区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2154', '桥西区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2164', '宣化区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2176', '下花园区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2183', '宣化县', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2198', '张北县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2220', '康保县', '3', '2142', 'K');
INSERT INTO `ey_region` VALUES ('2237', '沽源县', '3', '2142', 'G');
INSERT INTO `ey_region` VALUES ('2256', '尚义县', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2271', '蔚县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2294', '阳原县', '3', '2142', 'Y');
INSERT INTO `ey_region` VALUES ('2309', '怀安县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2321', '万全县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2333', '怀来县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2351', '涿鹿县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2369', '赤城县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2388', '崇礼县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2400', '承德市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2401', '市辖区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2402', '双桥区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2415', '双滦区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2422', '鹰手营子矿区', '3', '2400', 'Y');
INSERT INTO `ey_region` VALUES ('2427', '承德县', '3', '2400', 'C');
INSERT INTO `ey_region` VALUES ('2453', '兴隆县', '3', '2400', 'X');
INSERT INTO `ey_region` VALUES ('2474', '平泉县', '3', '2400', 'P');
INSERT INTO `ey_region` VALUES ('2494', '滦平县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2517', '隆化县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2543', '丰宁县', '3', '2400', 'F');
INSERT INTO `ey_region` VALUES ('2570', '宽城县', '3', '2400', 'K');
INSERT INTO `ey_region` VALUES ('2589', '围场县', '3', '2400', 'W');
INSERT INTO `ey_region` VALUES ('2629', '沧州市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2630', '市辖区', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2631', '新华区', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2639', '运河区', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2648', '沧县', '3', '2629', 'C');
INSERT INTO `ey_region` VALUES ('2668', '青县', '3', '2629', 'Q');
INSERT INTO `ey_region` VALUES ('2680', '东光县', '3', '2629', 'D');
INSERT INTO `ey_region` VALUES ('2690', '海兴县', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2701', '盐山县', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2714', '肃宁县', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2724', '南皮县', '3', '2629', 'N');
INSERT INTO `ey_region` VALUES ('2734', '吴桥县', '3', '2629', 'W');
INSERT INTO `ey_region` VALUES ('2745', '献县', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2765', '孟村县', '3', '2629', 'M');
INSERT INTO `ey_region` VALUES ('2772', '泊头市', '3', '2629', 'B');
INSERT INTO `ey_region` VALUES ('2788', '任邱市', '3', '2629', 'R');
INSERT INTO `ey_region` VALUES ('2809', '黄骅市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2828', '河间市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2849', '廊坊市', '2', '636', 'L');
INSERT INTO `ey_region` VALUES ('2850', '市辖区', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2851', '安次区', '3', '2849', 'A');
INSERT INTO `ey_region` VALUES ('2862', '广阳区', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2873', '固安县', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2883', '永清县', '3', '2849', 'Y');
INSERT INTO `ey_region` VALUES ('2895', '香河县', '3', '2849', 'X');
INSERT INTO `ey_region` VALUES ('2906', '大城县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2918', '文安县', '3', '2849', 'W');
INSERT INTO `ey_region` VALUES ('2932', '大厂县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2939', '霸州市', '3', '2849', 'B');
INSERT INTO `ey_region` VALUES ('2953', '三河市', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2968', '衡水市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('2969', '市辖区', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('2970', '桃城区', '3', '2968', 'T');
INSERT INTO `ey_region` VALUES ('2983', '枣强县', '3', '2968', 'Z');
INSERT INTO `ey_region` VALUES ('2995', '武邑县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3005', '武强县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3012', '饶阳县', '3', '2968', 'R');
INSERT INTO `ey_region` VALUES ('3020', '安平县', '3', '2968', 'A');
INSERT INTO `ey_region` VALUES ('3029', '故城县', '3', '2968', 'G');
INSERT INTO `ey_region` VALUES ('3043', '景县', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3060', '阜城县', '3', '2968', 'F');
INSERT INTO `ey_region` VALUES ('3071', '冀州市', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3083', '深州市', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('3102', '山西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('3103', '太原市', '2', '3102', 'T');
INSERT INTO `ey_region` VALUES ('3104', '市辖区', '3', '3103', 'S');
INSERT INTO `ey_region` VALUES ('3105', '小店区(人口含高新经济区)', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3117', '迎泽区', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3126', '杏花岭区', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3140', '尖草坪区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3155', '万柏林区', '3', '3103', 'W');
INSERT INTO `ey_region` VALUES ('3171', '晋源区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3178', '清徐县', '3', '3103', 'Q');
INSERT INTO `ey_region` VALUES ('3188', '阳曲县', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3200', '娄烦县', '3', '3103', 'L');
INSERT INTO `ey_region` VALUES ('3209', '古交市', '3', '3103', 'G');
INSERT INTO `ey_region` VALUES ('3224', '大同市', '2', '3102', 'D');
INSERT INTO `ey_region` VALUES ('3225', '市辖区', '3', '3224', 'S');
INSERT INTO `ey_region` VALUES ('3226', '大同市城区', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3241', '矿区', '3', '3224', 'K');
INSERT INTO `ey_region` VALUES ('3266', '南郊区', '3', '3224', 'N');
INSERT INTO `ey_region` VALUES ('3277', '新荣区', '3', '3224', 'X');
INSERT INTO `ey_region` VALUES ('3286', '阳高县', '3', '3224', 'Y');
INSERT INTO `ey_region` VALUES ('3300', '天镇县', '3', '3224', 'T');
INSERT INTO `ey_region` VALUES ('3312', '广灵县', '3', '3224', 'G');
INSERT INTO `ey_region` VALUES ('3322', '灵丘县', '3', '3224', 'L');
INSERT INTO `ey_region` VALUES ('3335', '浑源县', '3', '3224', 'H');
INSERT INTO `ey_region` VALUES ('3354', '左云县', '3', '3224', 'Z');
INSERT INTO `ey_region` VALUES ('3364', '大同县', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3379', '阳泉市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3380', '市辖区', '3', '3379', 'S');
INSERT INTO `ey_region` VALUES ('3381', '城区', '3', '3379', 'C');
INSERT INTO `ey_region` VALUES ('3388', '矿区', '3', '3379', 'K');
INSERT INTO `ey_region` VALUES ('3395', '郊区', '3', '3379', 'J');
INSERT INTO `ey_region` VALUES ('3405', '平定县', '3', '3379', 'P');
INSERT INTO `ey_region` VALUES ('3416', '盂县', '3', '3379', 'Y');
INSERT INTO `ey_region` VALUES ('3431', '长治市', '2', '3102', 'C');
INSERT INTO `ey_region` VALUES ('3432', '市辖区', '3', '3431', 'S');
INSERT INTO `ey_region` VALUES ('3433', '长治市城区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3445', '长治市郊区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3454', '长治县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3466', '襄垣县', '3', '3431', 'X');
INSERT INTO `ey_region` VALUES ('3478', '屯留县', '3', '3431', 'T');
INSERT INTO `ey_region` VALUES ('3493', '平顺县', '3', '3431', 'P');
INSERT INTO `ey_region` VALUES ('3506', '黎城县', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3516', '壶关县', '3', '3431', 'H');
INSERT INTO `ey_region` VALUES ('3530', '长子县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3543', '武乡县', '3', '3431', 'W');
INSERT INTO `ey_region` VALUES ('3558', '沁县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3572', '沁源县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3587', '潞城市', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3597', '晋城市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3598', '市辖区', '3', '3597', 'S');
INSERT INTO `ey_region` VALUES ('3599', '晋城市城区', '3', '3597', 'J');
INSERT INTO `ey_region` VALUES ('3608', '沁水县', '3', '3597', 'Q');
INSERT INTO `ey_region` VALUES ('3623', '阳城县', '3', '3597', 'Y');
INSERT INTO `ey_region` VALUES ('3642', '陵川县', '3', '3597', 'L');
INSERT INTO `ey_region` VALUES ('3655', '泽州县', '3', '3597', 'Z');
INSERT INTO `ey_region` VALUES ('3673', '高平市', '3', '3597', 'G');
INSERT INTO `ey_region` VALUES ('3690', '朔州市', '2', '3102', 'S');
INSERT INTO `ey_region` VALUES ('3691', '市辖区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3692', '朔城区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3709', '平鲁区', '3', '3690', 'P');
INSERT INTO `ey_region` VALUES ('3723', '山阴县', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3739', '应县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3752', '右玉县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3763', '怀仁县', '3', '3690', 'H');
INSERT INTO `ey_region` VALUES ('3776', '晋中市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3777', '市辖区', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3778', '榆次区', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3799', '榆社县', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3810', '左权县', '3', '3776', 'Z');
INSERT INTO `ey_region` VALUES ('3822', '和顺县', '3', '3776', 'H');
INSERT INTO `ey_region` VALUES ('3833', '昔阳县', '3', '3776', 'X');
INSERT INTO `ey_region` VALUES ('3846', '寿阳县', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3861', '太谷县', '3', '3776', 'T');
INSERT INTO `ey_region` VALUES ('3871', '祁县', '3', '3776', 'Q');
INSERT INTO `ey_region` VALUES ('3880', '平遥县', '3', '3776', 'P');
INSERT INTO `ey_region` VALUES ('3895', '灵石县', '3', '3776', 'L');
INSERT INTO `ey_region` VALUES ('3908', '介休市', '3', '3776', 'J');
INSERT INTO `ey_region` VALUES ('3925', '运城市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3926', '市辖区', '3', '3925', 'S');
INSERT INTO `ey_region` VALUES ('3927', '盐湖区', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('3950', '临猗县', '3', '3925', 'L');
INSERT INTO `ey_region` VALUES ('3967', '万荣县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3982', '闻喜县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3996', '稷山县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4004', '新绛县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4013', '绛县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4024', '垣曲县', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4036', '夏县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4048', '平陆县', '3', '3925', 'P');
INSERT INTO `ey_region` VALUES ('4059', '芮城县', '3', '3925', 'R');
INSERT INTO `ey_region` VALUES ('4070', '永济市', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4082', '河津市', '3', '3925', 'H');
INSERT INTO `ey_region` VALUES ('4093', '忻州市', '2', '3102', 'X');
INSERT INTO `ey_region` VALUES ('4094', '市辖区', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4095', '忻府区', '3', '4093', 'X');
INSERT INTO `ey_region` VALUES ('4116', '定襄县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4126', '五台县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4146', '代县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4158', '繁峙县', '3', '4093', 'F');
INSERT INTO `ey_region` VALUES ('4172', '宁武县', '3', '4093', 'N');
INSERT INTO `ey_region` VALUES ('4189', '静乐县', '3', '4093', 'J');
INSERT INTO `ey_region` VALUES ('4204', '神池县', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4215', '五寨县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4228', '岢岚县', '3', '4093', 'K');
INSERT INTO `ey_region` VALUES ('4241', '河曲县', '3', '4093', 'H');
INSERT INTO `ey_region` VALUES ('4255', '保德县', '3', '4093', 'B');
INSERT INTO `ey_region` VALUES ('4269', '偏关县', '3', '4093', 'P');
INSERT INTO `ey_region` VALUES ('4280', '原平市', '3', '4093', 'Y');
INSERT INTO `ey_region` VALUES ('4304', '临汾市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4305', '市辖区', '3', '4304', 'S');
INSERT INTO `ey_region` VALUES ('4306', '尧都区', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4333', '曲沃县', '3', '4304', 'Q');
INSERT INTO `ey_region` VALUES ('4341', '翼城县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4352', '襄汾县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4366', '洪洞县', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4383', '古县', '3', '4304', 'G');
INSERT INTO `ey_region` VALUES ('4391', '安泽县', '3', '4304', 'A');
INSERT INTO `ey_region` VALUES ('4399', '浮山县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4409', '吉县', '3', '4304', 'J');
INSERT INTO `ey_region` VALUES ('4418', '乡宁县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4429', '大宁县', '3', '4304', 'D');
INSERT INTO `ey_region` VALUES ('4436', '隰县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4445', '永和县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4453', '蒲县', '3', '4304', 'P');
INSERT INTO `ey_region` VALUES ('4463', '汾西县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4472', '侯马市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4481', '霍州市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4494', '吕梁市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4495', '市辖区', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4496', '离石区', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4509', '文水县', '3', '4494', 'W');
INSERT INTO `ey_region` VALUES ('4522', '交城县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4533', '兴县', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4551', '临县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4575', '柳林县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4591', '石楼县', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4601', '岚县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4614', '方山县', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4622', '中阳县', '3', '4494', 'Z');
INSERT INTO `ey_region` VALUES ('4630', '交口县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4638', '孝义市', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4655', '汾阳市', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4670', '内蒙古自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('4671', '呼和浩特市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('4672', '市辖区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4673', '新城区', '3', '4671', 'X');
INSERT INTO `ey_region` VALUES ('4684', '回民区', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4693', '玉泉区', '3', '4671', 'Y');
INSERT INTO `ey_region` VALUES ('4702', '赛罕区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4715', '土左旗', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4727', '托克托县', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4733', '和林格尔县', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4742', '清水河县', '3', '4671', 'Q');
INSERT INTO `ey_region` VALUES ('4749', '武川县', '3', '4671', 'W');
INSERT INTO `ey_region` VALUES ('4759', '包头市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('4760', '市辖区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4761', '东河区', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4775', '昆都仑区', '3', '4759', 'K');
INSERT INTO `ey_region` VALUES ('4791', '青山区', '3', '4759', 'Q');
INSERT INTO `ey_region` VALUES ('4803', '石拐区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4810', '白云鄂博矿区', '3', '4759', 'B');
INSERT INTO `ey_region` VALUES ('4813', '九原区', '3', '4759', 'J');
INSERT INTO `ey_region` VALUES ('4823', '土默特右旗', '3', '4759', 'T');
INSERT INTO `ey_region` VALUES ('4833', '固阳县', '3', '4759', 'G');
INSERT INTO `ey_region` VALUES ('4840', '达茂联合旗', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4849', '乌海市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('4850', '乌海市辖区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4851', '海勃湾区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4859', '海南区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4865', '乌达区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4874', '赤峰市', '2', '4670', 'C');
INSERT INTO `ey_region` VALUES ('4875', '市辖区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4876', '红山区', '3', '4874', 'H');
INSERT INTO `ey_region` VALUES ('4888', '元宝山区', '3', '4874', 'Y');
INSERT INTO `ey_region` VALUES ('4896', '松山区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4919', '阿鲁科尔沁旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('4932', '巴林左旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4944', '巴林右旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4953', '林西县', '3', '4874', 'L');
INSERT INTO `ey_region` VALUES ('4963', '克什克腾旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4975', '翁牛特旗', '3', '4874', 'W');
INSERT INTO `ey_region` VALUES ('4988', '喀喇沁旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4999', '宁城县', '3', '4874', 'N');
INSERT INTO `ey_region` VALUES ('5013', '敖汉旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('5029', '通辽市', '2', '4670', 'T');
INSERT INTO `ey_region` VALUES ('5030', '市辖区', '3', '5029', 'S');
INSERT INTO `ey_region` VALUES ('5031', '科尔沁区', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5062', '科尔沁左翼中旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5079', '科左后旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5104', '开鲁县', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5118', '库伦旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5125', '奈曼旗', '3', '5029', 'N');
INSERT INTO `ey_region` VALUES ('5139', '扎鲁特旗', '3', '5029', 'Z');
INSERT INTO `ey_region` VALUES ('5155', '霍林郭勒市', '3', '5029', 'H');
INSERT INTO `ey_region` VALUES ('5162', '鄂尔多斯市', '2', '4670', 'E');
INSERT INTO `ey_region` VALUES ('5163', '东胜区', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5176', '达拉特旗', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5185', '准格尔旗', '3', '5162', 'Z');
INSERT INTO `ey_region` VALUES ('5195', '鄂托克前旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5201', '鄂托克旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5210', '杭锦旗', '3', '5162', 'H');
INSERT INTO `ey_region` VALUES ('5219', '乌审旗', '3', '5162', 'W');
INSERT INTO `ey_region` VALUES ('5228', '伊金霍洛旗', '3', '5162', 'Y');
INSERT INTO `ey_region` VALUES ('5236', '呼伦贝尔市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('5237', '市辖区', '3', '5236', 'S');
INSERT INTO `ey_region` VALUES ('5238', '海拉尔区', '3', '5236', 'H');
INSERT INTO `ey_region` VALUES ('5249', '阿荣旗', '3', '5236', 'A');
INSERT INTO `ey_region` VALUES ('5262', '莫力达瓦旗', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5277', '鄂伦春旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5303', '鄂温旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5314', '陈巴尔虎旗镇', '3', '5236', 'C');
INSERT INTO `ey_region` VALUES ('5323', '新巴尔虎左旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5330', '新巴尔虎右旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5337', '满洲里市', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5354', '牙克石市', '3', '5236', 'Y');
INSERT INTO `ey_region` VALUES ('5371', '扎兰屯市', '3', '5236', 'Z');
INSERT INTO `ey_region` VALUES ('5397', '额尔古纳市', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5410', '根河市', '3', '5236', 'G');
INSERT INTO `ey_region` VALUES ('5418', '巴彦淖尔市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('5419', '市辖区', '3', '5418', 'S');
INSERT INTO `ey_region` VALUES ('5420', '临河区', '3', '5418', 'L');
INSERT INTO `ey_region` VALUES ('5440', '五原县', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5450', '磴口县', '3', '5418', 'D');
INSERT INTO `ey_region` VALUES ('5461', '乌拉特前旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5477', '乌拉特中旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5489', '乌拉特后旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5495', '杭锦后旗', '3', '5418', 'H');
INSERT INTO `ey_region` VALUES ('5505', '乌兰察布市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('5506', '市辖区', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5507', '集宁区', '3', '5505', 'J');
INSERT INTO `ey_region` VALUES ('5518', '卓资县', '3', '5505', 'Z');
INSERT INTO `ey_region` VALUES ('5526', '化德县', '3', '5505', 'H');
INSERT INTO `ey_region` VALUES ('5532', '商都县', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5542', '兴和县', '3', '5505', 'X');
INSERT INTO `ey_region` VALUES ('5551', '凉城县', '3', '5505', 'L');
INSERT INTO `ey_region` VALUES ('5562', '察哈尔右翼前旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5571', '察右中旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5582', '察哈尔右翼后旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5590', '四子王旗', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5603', '丰镇市', '3', '5505', 'F');
INSERT INTO `ey_region` VALUES ('5616', '兴安盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5617', '乌兰浩特市', '3', '5616', 'W');
INSERT INTO `ey_region` VALUES ('5629', '阿尔山市', '3', '5616', 'A');
INSERT INTO `ey_region` VALUES ('5636', '科右前旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5655', '科右中旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5677', '扎赉特旗', '3', '5616', 'Z');
INSERT INTO `ey_region` VALUES ('5692', '突泉县', '3', '5616', 'T');
INSERT INTO `ey_region` VALUES ('5702', '锡林郭勒盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5703', '二连浩特市', '3', '5702', 'E');
INSERT INTO `ey_region` VALUES ('5709', '锡林浩特市', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5723', '阿巴嘎旗', '3', '5702', 'A');
INSERT INTO `ey_region` VALUES ('5731', '苏尼特左旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5738', '苏尼特右旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5745', '东乌珠穆沁旗', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5758', '西乌珠穆沁旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5766', '太仆寺旗', '3', '5702', 'T');
INSERT INTO `ey_region` VALUES ('5774', '镶黄旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5778', '正镶白旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5785', '正蓝旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5794', '多伦县', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5799', '阿拉善盟', '2', '4670', 'A');
INSERT INTO `ey_region` VALUES ('5800', '阿拉善左旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5814', '阿拉善右旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5820', '额济纳旗', '3', '5799', 'E');
INSERT INTO `ey_region` VALUES ('5827', '辽宁省', '1', '0', 'L');
INSERT INTO `ey_region` VALUES ('5828', '沈阳市', '2', '5827', 'S');
INSERT INTO `ey_region` VALUES ('5829', '市辖区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5830', '和平区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5848', '沈河区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5859', '大东区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5873', '皇姑区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5894', '铁西区', '3', '5828', 'T');
INSERT INTO `ey_region` VALUES ('5909', '苏家屯区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5934', '东陵区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5954', '新城子区', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('5975', '于洪区', '3', '5828', 'Y');
INSERT INTO `ey_region` VALUES ('5998', '辽中县', '3', '5828', 'L');
INSERT INTO `ey_region` VALUES ('6020', '康平县', '3', '5828', 'K');
INSERT INTO `ey_region` VALUES ('6038', '法库县', '3', '5828', 'F');
INSERT INTO `ey_region` VALUES ('6058', '新民市', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('6088', '大连市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6089', '市辖区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6090', '中山区', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6099', '西岗区', '3', '6088', 'X');
INSERT INTO `ey_region` VALUES ('6107', '沙河口区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6117', '甘井子区', '3', '6088', 'G');
INSERT INTO `ey_region` VALUES ('6137', '旅顺口区', '3', '6088', 'L');
INSERT INTO `ey_region` VALUES ('6153', '金州区', '3', '6088', 'J');
INSERT INTO `ey_region` VALUES ('6178', '长海县', '3', '6088', 'C');
INSERT INTO `ey_region` VALUES ('6184', '瓦房店市', '3', '6088', 'W');
INSERT INTO `ey_region` VALUES ('6217', '普兰店市', '3', '6088', 'P');
INSERT INTO `ey_region` VALUES ('6239', '庄河市', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6266', '鞍山市', '2', '5827', 'A');
INSERT INTO `ey_region` VALUES ('6267', '市辖区', '3', '6266', 'S');
INSERT INTO `ey_region` VALUES ('6268', '铁东区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6282', '铁西区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6293', '立山区', '3', '6266', 'L');
INSERT INTO `ey_region` VALUES ('6303', '千山区', '3', '6266', 'Q');
INSERT INTO `ey_region` VALUES ('6316', '台安县', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6331', '岫岩县', '3', '6266', 'X');
INSERT INTO `ey_region` VALUES ('6354', '海城市', '3', '6266', 'H');
INSERT INTO `ey_region` VALUES ('6384', '抚顺市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6385', '市辖区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6386', '新抚区', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6395', '东洲区', '3', '6384', 'D');
INSERT INTO `ey_region` VALUES ('6409', '望花区', '3', '6384', 'W');
INSERT INTO `ey_region` VALUES ('6422', '顺城区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6432', '抚顺县', '3', '6384', 'F');
INSERT INTO `ey_region` VALUES ('6445', '新宾县', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6461', '清原县', '3', '6384', 'Q');
INSERT INTO `ey_region` VALUES ('6476', '本溪市', '2', '5827', 'B');
INSERT INTO `ey_region` VALUES ('6477', '市辖区', '3', '6476', 'S');
INSERT INTO `ey_region` VALUES ('6478', '平山区', '3', '6476', 'P');
INSERT INTO `ey_region` VALUES ('6488', '溪湖区', '3', '6476', 'X');
INSERT INTO `ey_region` VALUES ('6499', '明山区', '3', '6476', 'M');
INSERT INTO `ey_region` VALUES ('6509', '南芬区', '3', '6476', 'N');
INSERT INTO `ey_region` VALUES ('6515', '本溪县', '3', '6476', 'B');
INSERT INTO `ey_region` VALUES ('6528', '桓仁县', '3', '6476', 'H');
INSERT INTO `ey_region` VALUES ('6542', '丹东市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6543', '市辖区', '3', '6542', 'S');
INSERT INTO `ey_region` VALUES ('6544', '元宝区', '3', '6542', 'Y');
INSERT INTO `ey_region` VALUES ('6552', '振兴区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6563', '振安区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6573', '宽甸县', '3', '6542', 'K');
INSERT INTO `ey_region` VALUES ('6596', '东港市', '3', '6542', 'D');
INSERT INTO `ey_region` VALUES ('6621', '凤城市', '3', '6542', 'F');
INSERT INTO `ey_region` VALUES ('6643', '锦州市', '2', '5827', 'J');
INSERT INTO `ey_region` VALUES ('6644', '市辖区', '3', '6643', 'S');
INSERT INTO `ey_region` VALUES ('6645', '古塔区', '3', '6643', 'G');
INSERT INTO `ey_region` VALUES ('6655', '凌河区', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6668', '太和区', '3', '6643', 'T');
INSERT INTO `ey_region` VALUES ('6683', '黑山县', '3', '6643', 'H');
INSERT INTO `ey_region` VALUES ('6706', '义县', '3', '6643', 'Y');
INSERT INTO `ey_region` VALUES ('6725', '凌海市', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6750', '北镇市', '3', '6643', 'B');
INSERT INTO `ey_region` VALUES ('6771', '营口市', '2', '5827', 'Y');
INSERT INTO `ey_region` VALUES ('6772', '市辖区', '3', '6771', 'S');
INSERT INTO `ey_region` VALUES ('6773', '站前区', '3', '6771', 'Z');
INSERT INTO `ey_region` VALUES ('6781', '西市区', '3', '6771', 'X');
INSERT INTO `ey_region` VALUES ('6789', '鲅鱼圈区', '3', '6771', 'B');
INSERT INTO `ey_region` VALUES ('6797', '老边区', '3', '6771', 'L');
INSERT INTO `ey_region` VALUES ('6804', '盖州市', '3', '6771', 'G');
INSERT INTO `ey_region` VALUES ('6832', '大石桥市', '3', '6771', 'D');
INSERT INTO `ey_region` VALUES ('6851', '阜新市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6852', '市辖区', '3', '6851', 'S');
INSERT INTO `ey_region` VALUES ('6853', '海州区', '3', '6851', 'H');
INSERT INTO `ey_region` VALUES ('6865', '新邱区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6871', '太平区', '3', '6851', 'T');
INSERT INTO `ey_region` VALUES ('6878', '清河门区', '3', '6851', 'Q');
INSERT INTO `ey_region` VALUES ('6885', '细河区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6893', '阜新县', '3', '6851', 'F');
INSERT INTO `ey_region` VALUES ('6930', '彰武县', '3', '6851', 'Z');
INSERT INTO `ey_region` VALUES ('6955', '辽阳市', '2', '5827', 'L');
INSERT INTO `ey_region` VALUES ('6956', '市辖区', '3', '6955', 'S');
INSERT INTO `ey_region` VALUES ('6957', '白塔区', '3', '6955', 'B');
INSERT INTO `ey_region` VALUES ('6964', '文圣区', '3', '6955', 'W');
INSERT INTO `ey_region` VALUES ('6971', '宏伟区', '3', '6955', 'H');
INSERT INTO `ey_region` VALUES ('6977', '弓长岭区', '3', '6955', 'G');
INSERT INTO `ey_region` VALUES ('6983', '太子河区', '3', '6955', 'T');
INSERT INTO `ey_region` VALUES ('6989', '辽阳县', '3', '6955', 'L');
INSERT INTO `ey_region` VALUES ('7007', '灯塔市', '3', '6955', 'D');
INSERT INTO `ey_region` VALUES ('7024', '盘锦市', '2', '5827', 'P');
INSERT INTO `ey_region` VALUES ('7025', '市辖区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7026', '双台子区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7036', '兴隆台区', '3', '7024', 'X');
INSERT INTO `ey_region` VALUES ('7055', '大洼县', '3', '7024', 'D');
INSERT INTO `ey_region` VALUES ('7072', '盘山县', '3', '7024', 'P');
INSERT INTO `ey_region` VALUES ('7088', '铁岭市', '2', '5827', 'T');
INSERT INTO `ey_region` VALUES ('7089', '市辖区', '3', '7088', 'S');
INSERT INTO `ey_region` VALUES ('7090', '银州区', '3', '7088', 'Y');
INSERT INTO `ey_region` VALUES ('7099', '清河区', '3', '7088', 'Q');
INSERT INTO `ey_region` VALUES ('7105', '铁岭县', '3', '7088', 'T');
INSERT INTO `ey_region` VALUES ('7121', '西丰县', '3', '7088', 'X');
INSERT INTO `ey_region` VALUES ('7140', '昌图县', '3', '7088', 'C');
INSERT INTO `ey_region` VALUES ('7180', '调兵山市', '3', '7088', 'D');
INSERT INTO `ey_region` VALUES ('7186', '开原市', '3', '7088', 'K');
INSERT INTO `ey_region` VALUES ('7208', '朝阳市', '2', '5827', 'C');
INSERT INTO `ey_region` VALUES ('7209', '市辖区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7210', '双塔区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7225', '龙城区', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7238', '朝阳县', '3', '7208', 'C');
INSERT INTO `ey_region` VALUES ('7267', '建平县', '3', '7208', 'J');
INSERT INTO `ey_region` VALUES ('7299', '喀喇沁左翼县', '3', '7208', 'K');
INSERT INTO `ey_region` VALUES ('7322', '北票市', '3', '7208', 'B');
INSERT INTO `ey_region` VALUES ('7360', '凌源市', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7391', '葫芦岛市', '2', '5827', 'H');
INSERT INTO `ey_region` VALUES ('7392', '市辖区', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7393', '连山区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7419', '龙港区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7433', '南票区', '3', '7391', 'N');
INSERT INTO `ey_region` VALUES ('7446', '绥中县', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7474', '建昌县', '3', '7391', 'J');
INSERT INTO `ey_region` VALUES ('7503', '兴城市', '3', '7391', 'X');
INSERT INTO `ey_region` VALUES ('7531', '吉林省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('7532', '长春市', '2', '7531', 'C');
INSERT INTO `ey_region` VALUES ('7533', '长春市辖区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7534', '南关区', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7552', '宽城区', '3', '7532', 'K');
INSERT INTO `ey_region` VALUES ('7569', '朝阳区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7582', '二道区', '3', '7532', 'E');
INSERT INTO `ey_region` VALUES ('7597', '绿园区', '3', '7532', 'L');
INSERT INTO `ey_region` VALUES ('7610', '双阳区', '3', '7532', 'S');
INSERT INTO `ey_region` VALUES ('7619', '农安县', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7642', '九台市', '3', '7532', 'J');
INSERT INTO `ey_region` VALUES ('7658', '榆树市', '3', '7532', 'Y');
INSERT INTO `ey_region` VALUES ('7687', '德惠市', '3', '7532', 'D');
INSERT INTO `ey_region` VALUES ('7706', '吉林市', '2', '7531', 'J');
INSERT INTO `ey_region` VALUES ('7707', '吉林市辖区', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7708', '昌邑区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7731', '龙潭区', '3', '7706', 'L');
INSERT INTO `ey_region` VALUES ('7752', '船营区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7768', '丰满区', '3', '7706', 'F');
INSERT INTO `ey_region` VALUES ('7781', '永吉县', '3', '7706', 'Y');
INSERT INTO `ey_region` VALUES ('7792', '蛟河市', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7810', '桦甸市', '3', '7706', 'H');
INSERT INTO `ey_region` VALUES ('7828', '舒兰市', '3', '7706', 'S');
INSERT INTO `ey_region` VALUES ('7849', '磐石市', '3', '7706', 'P');
INSERT INTO `ey_region` VALUES ('7868', '四平市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('7869', '四平市辖区', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7870', '铁西区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7878', '铁东区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7892', '梨树县', '3', '7868', 'L');
INSERT INTO `ey_region` VALUES ('7916', '伊通县', '3', '7868', 'Y');
INSERT INTO `ey_region` VALUES ('7933', '公主岭市', '3', '7868', 'G');
INSERT INTO `ey_region` VALUES ('7964', '双辽市', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7986', '辽源市', '2', '7531', 'L');
INSERT INTO `ey_region` VALUES ('7987', '辽源市辖区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('7988', '龙山区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('8000', '西安区', '3', '7986', 'X');
INSERT INTO `ey_region` VALUES ('8008', '东丰县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8023', '东辽县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8037', '通化市', '2', '7531', 'T');
INSERT INTO `ey_region` VALUES ('8038', '通化市辖区', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8039', '东昌区', '3', '8037', 'D');
INSERT INTO `ey_region` VALUES ('8051', '二道江区', '3', '8037', 'E');
INSERT INTO `ey_region` VALUES ('8058', '通化县', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8076', '辉南县', '3', '8037', 'H');
INSERT INTO `ey_region` VALUES ('8088', '柳河县', '3', '8037', 'L');
INSERT INTO `ey_region` VALUES ('8104', '梅河口市', '3', '8037', 'M');
INSERT INTO `ey_region` VALUES ('8129', '集安市', '3', '8037', 'J');
INSERT INTO `ey_region` VALUES ('8144', '白山市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8145', '白山市辖区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8146', '八道江区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8159', '江源区', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8168', '抚松县', '3', '8144', 'F');
INSERT INTO `ey_region` VALUES ('8183', '靖宇县', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8192', '长白县', '3', '8144', 'C');
INSERT INTO `ey_region` VALUES ('8202', '临江市', '3', '8144', 'L');
INSERT INTO `ey_region` VALUES ('8216', '松原市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('8217', '松原市辖区', '3', '8216', 'S');
INSERT INTO `ey_region` VALUES ('8218', '宁江区', '3', '8216', 'N');
INSERT INTO `ey_region` VALUES ('8239', '前郭县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8266', '长岭县', '3', '8216', 'C');
INSERT INTO `ey_region` VALUES ('8300', '乾安县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8311', '扶余县', '3', '8216', 'F');
INSERT INTO `ey_region` VALUES ('8333', '白城市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8334', '白城市辖区', '3', '8333', 'B');
INSERT INTO `ey_region` VALUES ('8335', '洮北区', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8362', '镇赉县', '3', '8333', 'Z');
INSERT INTO `ey_region` VALUES ('8375', '通榆县', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8393', '洮南市', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8420', '大安市', '3', '8333', 'D');
INSERT INTO `ey_region` VALUES ('8445', '延边州', '2', '7531', 'Y');
INSERT INTO `ey_region` VALUES ('8446', '延吉市', '3', '8445', 'Y');
INSERT INTO `ey_region` VALUES ('8456', '图们市', '3', '8445', 'T');
INSERT INTO `ey_region` VALUES ('8464', '敦化市', '3', '8445', 'D');
INSERT INTO `ey_region` VALUES ('8489', '珲春市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8504', '龙井市', '3', '8445', 'L');
INSERT INTO `ey_region` VALUES ('8515', '和龙市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8530', '汪清县', '3', '8445', 'W');
INSERT INTO `ey_region` VALUES ('8545', '安图县', '3', '8445', 'A');
INSERT INTO `ey_region` VALUES ('8558', '黑龙江省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('8559', '哈尔滨市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('8560', '市辖区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8561', '道里区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8585', '南岗区', '3', '8559', 'N');
INSERT INTO `ey_region` VALUES ('8606', '道外区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8633', '平房区', '3', '8559', 'P');
INSERT INTO `ey_region` VALUES ('8642', '松北区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8650', '香坊区', '3', '8559', 'X');
INSERT INTO `ey_region` VALUES ('8676', '呼兰区', '3', '8559', 'H');
INSERT INTO `ey_region` VALUES ('8694', '阿城区', '3', '8559', 'A');
INSERT INTO `ey_region` VALUES ('8714', '依兰县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8729', '方正县', '3', '8559', 'F');
INSERT INTO `ey_region` VALUES ('8740', '宾县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8758', '巴彦县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8778', '木兰县', '3', '8559', 'M');
INSERT INTO `ey_region` VALUES ('8788', '通河县', '3', '8559', 'T');
INSERT INTO `ey_region` VALUES ('8800', '延寿县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8812', '双城市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8838', '尚志市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8858', '五常市', '3', '8559', 'W');
INSERT INTO `ey_region` VALUES ('8884', '齐齐哈尔市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('8885', '市辖区', '3', '8884', 'S');
INSERT INTO `ey_region` VALUES ('8886', '龙沙区', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8894', '建华区', '3', '8884', 'J');
INSERT INTO `ey_region` VALUES ('8901', '铁锋区', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8911', '昂昂溪区', '3', '8884', 'A');
INSERT INTO `ey_region` VALUES ('8918', '富拉尔基区', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('8928', '碾子山区', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('8934', '梅里斯达斡尔族区', '3', '8884', 'M');
INSERT INTO `ey_region` VALUES ('8943', '龙江县', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8958', '依安县', '3', '8884', 'Y');
INSERT INTO `ey_region` VALUES ('8976', '泰来县', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8998', '甘南县', '3', '8884', 'G');
INSERT INTO `ey_region` VALUES ('9011', '富裕县', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('9024', '克山县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9048', '克东县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9067', '拜泉县', '3', '8884', 'B');
INSERT INTO `ey_region` VALUES ('9084', '讷河市', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('9117', '鸡西市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9118', '市辖区', '3', '9117', 'S');
INSERT INTO `ey_region` VALUES ('9119', '鸡冠区', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9129', '恒山区', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9139', '滴道区', '3', '9117', 'D');
INSERT INTO `ey_region` VALUES ('9146', '梨树区', '3', '9117', 'L');
INSERT INTO `ey_region` VALUES ('9153', '城子河区', '3', '9117', 'C');
INSERT INTO `ey_region` VALUES ('9161', '麻山区', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9164', '鸡东县', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9178', '虎林市', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9199', '密山市', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9222', '鹤岗市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('9223', '市辖区', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9224', '向阳区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9230', '工农区', '3', '9222', 'G');
INSERT INTO `ey_region` VALUES ('9237', '南山区', '3', '9222', 'N');
INSERT INTO `ey_region` VALUES ('9244', '兴安区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9250', '东山区', '3', '9222', 'D');
INSERT INTO `ey_region` VALUES ('9261', '兴山区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9266', '萝北县', '3', '9222', 'L');
INSERT INTO `ey_region` VALUES ('9283', '绥滨县', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9296', '双鸭山市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('9297', '市辖区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9298', '尖山区', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9307', '岭东区', '3', '9296', 'L');
INSERT INTO `ey_region` VALUES ('9317', '四方台区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9323', '宝山区', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9335', '集贤县', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9356', '友谊县', '3', '9296', 'Y');
INSERT INTO `ey_region` VALUES ('9370', '宝清县', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9393', '饶河县', '3', '9296', 'R');
INSERT INTO `ey_region` VALUES ('9419', '大庆市', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('9420', '市辖区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9421', '萨尔图区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9431', '龙凤区', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9440', '让胡路区', '3', '9419', 'R');
INSERT INTO `ey_region` VALUES ('9451', '红岗区', '3', '9419', 'H');
INSERT INTO `ey_region` VALUES ('9458', '大同区', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9474', '肇州县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9489', '肇源县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9514', '林甸县', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9527', '杜尔伯特县', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9553', '伊春市', '2', '8558', 'Y');
INSERT INTO `ey_region` VALUES ('9554', '市辖区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9555', '伊春区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9561', '南岔区', '3', '9553', 'N');
INSERT INTO `ey_region` VALUES ('9581', '友好区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9599', '西林区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9603', '翠峦区', '3', '9553', 'C');
INSERT INTO `ey_region` VALUES ('9614', '新青区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9631', '美溪区', '3', '9553', 'M');
INSERT INTO `ey_region` VALUES ('9647', '金山屯区', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9660', '五营区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9671', '乌马河区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9685', '汤旺河区', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9702', '带岭区', '3', '9553', 'D');
INSERT INTO `ey_region` VALUES ('9715', '乌伊岭区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9729', '红星区', '3', '9553', 'H');
INSERT INTO `ey_region` VALUES ('9742', '上甘岭区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9756', '嘉荫县', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9772', '铁力市', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9785', '佳木斯市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9786', '市辖区', '3', '9785', 'S');
INSERT INTO `ey_region` VALUES ('9787', '向阳区', '3', '9785', 'X');
INSERT INTO `ey_region` VALUES ('9795', '前进区', '3', '9785', 'Q');
INSERT INTO `ey_region` VALUES ('9802', '东风区', '3', '9785', 'D');
INSERT INTO `ey_region` VALUES ('9810', '郊区', '3', '9785', 'J');
INSERT INTO `ey_region` VALUES ('9825', '桦南县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9839', '桦川县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9851', '汤原县', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9866', '抚远县', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9879', '同江市', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9907', '富锦市', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9930', '七台河市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('9931', '市辖区', '3', '9930', 'S');
INSERT INTO `ey_region` VALUES ('9932', '新兴区', '3', '9930', 'X');
INSERT INTO `ey_region` VALUES ('9944', '桃山区', '3', '9930', 'T');
INSERT INTO `ey_region` VALUES ('9952', '茄子河区', '3', '9930', 'Q');
INSERT INTO `ey_region` VALUES ('9962', '勃利县', '3', '9930', 'B');
INSERT INTO `ey_region` VALUES ('9981', '牡丹江市', '2', '8558', 'M');
INSERT INTO `ey_region` VALUES ('9982', '市辖区', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('9983', '东安区', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('9989', '阳明区', '3', '9981', 'Y');
INSERT INTO `ey_region` VALUES ('9996', '爱民区', '3', '9981', 'A');
INSERT INTO `ey_region` VALUES ('10005', '西安区', '3', '9981', 'X');
INSERT INTO `ey_region` VALUES ('10014', '东宁县', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('10022', '林口县', '3', '9981', 'L');
INSERT INTO `ey_region` VALUES ('10036', '绥芬河市', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('10039', '海林市', '3', '9981', 'H');
INSERT INTO `ey_region` VALUES ('10056', '宁安市', '3', '9981', 'N');
INSERT INTO `ey_region` VALUES ('10072', '穆棱市', '3', '9981', 'M');
INSERT INTO `ey_region` VALUES ('10084', '黑河市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('10085', '市辖区', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10086', '爱辉区', '3', '10084', 'A');
INSERT INTO `ey_region` VALUES ('10122', '嫩江县', '3', '10084', 'N');
INSERT INTO `ey_region` VALUES ('10150', '逊克县', '3', '10084', 'X');
INSERT INTO `ey_region` VALUES ('10168', '孙吴县', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10192', '北安市', '3', '10084', 'B');
INSERT INTO `ey_region` VALUES ('10214', '五大连池市', '3', '10084', 'W');
INSERT INTO `ey_region` VALUES ('10252', '绥化市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('10253', '市辖区', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10254', '北林区', '3', '10252', 'B');
INSERT INTO `ey_region` VALUES ('10281', '望奎县', '3', '10252', 'W');
INSERT INTO `ey_region` VALUES ('10301', '兰西县', '3', '10252', 'L');
INSERT INTO `ey_region` VALUES ('10320', '青冈县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10342', '庆安县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10360', '明水县', '3', '10252', 'M');
INSERT INTO `ey_region` VALUES ('10380', '绥棱县', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10401', '安达市', '3', '10252', 'A');
INSERT INTO `ey_region` VALUES ('10425', '肇东市', '3', '10252', 'Z');
INSERT INTO `ey_region` VALUES ('10452', '海伦市', '3', '10252', 'H');
INSERT INTO `ey_region` VALUES ('10483', '大兴安岭地区', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('10484', '加格达奇区', '3', '10483', 'J');
INSERT INTO `ey_region` VALUES ('10495', '松岭区', '3', '10483', 'S');
INSERT INTO `ey_region` VALUES ('10500', '新林区', '3', '10483', 'X');
INSERT INTO `ey_region` VALUES ('10509', '呼中区', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10515', '呼玛县', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10525', '塔河县', '3', '10483', 'T');
INSERT INTO `ey_region` VALUES ('10534', '漠河县', '3', '10483', 'M');
INSERT INTO `ey_region` VALUES ('10543', '上海市', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('10544', '上海市', '2', '10543', 'S');
INSERT INTO `ey_region` VALUES ('10545', '黄浦区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10555', '卢湾区', '3', '10544', 'L');
INSERT INTO `ey_region` VALUES ('10560', '徐汇区', '3', '10544', 'X');
INSERT INTO `ey_region` VALUES ('10575', '长宁区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10586', '静安区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10592', '普陀区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10602', '闸北区', '3', '10544', 'Z');
INSERT INTO `ey_region` VALUES ('10612', '虹口区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10623', '杨浦区', '3', '10544', 'Y');
INSERT INTO `ey_region` VALUES ('10636', '闵行区', '3', '10544', 'M');
INSERT INTO `ey_region` VALUES ('10650', '宝山区', '3', '10544', 'B');
INSERT INTO `ey_region` VALUES ('10664', '嘉定区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10678', '浦东新区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10704', '金山区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10715', '松江区', '3', '10544', 'S');
INSERT INTO `ey_region` VALUES ('10735', '青浦区', '3', '10544', 'Q');
INSERT INTO `ey_region` VALUES ('10747', '南汇区', '3', '10544', 'N');
INSERT INTO `ey_region` VALUES ('10765', '奉贤区', '3', '10544', 'F');
INSERT INTO `ey_region` VALUES ('10780', '崇明区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10808', '江苏省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('10809', '南京市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('10810', '市辖区', '3', '10809', 'S');
INSERT INTO `ey_region` VALUES ('10811', '玄武区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10820', '白下区', '3', '10809', 'B');
INSERT INTO `ey_region` VALUES ('10831', '秦淮区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10837', '建邺区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10845', '鼓楼区', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10853', '下关区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10860', '浦口区', '3', '10809', 'P');
INSERT INTO `ey_region` VALUES ('10876', '栖霞区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10894', '雨花台区', '3', '10809', 'Y');
INSERT INTO `ey_region` VALUES ('10903', '江宁区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10916', '六合区', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10937', '溧水县', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10947', '高淳县', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10960', '无锡市', '2', '10808', 'W');
INSERT INTO `ey_region` VALUES ('10961', '新吴区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10962', '梁溪区', '3', '10960', 'L');
INSERT INTO `ey_region` VALUES ('10981', '锡山区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10990', '惠山区', '3', '10960', 'H');
INSERT INTO `ey_region` VALUES ('10999', '滨湖区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('11018', '江阴市', '3', '10960', 'J');
INSERT INTO `ey_region` VALUES ('11039', '宜兴市', '3', '10960', 'Y');
INSERT INTO `ey_region` VALUES ('11067', '徐州市', '2', '10808', 'X');
INSERT INTO `ey_region` VALUES ('11068', '市辖区', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11069', '鼓楼区', '3', '11067', 'G');
INSERT INTO `ey_region` VALUES ('11081', '云龙区', '3', '11067', 'Y');
INSERT INTO `ey_region` VALUES ('11089', '九里区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11103', '贾汪区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11115', '泉山区', '3', '11067', 'Q');
INSERT INTO `ey_region` VALUES ('11126', '丰县', '3', '11067', 'F');
INSERT INTO `ey_region` VALUES ('11142', '沛县', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11160', '铜山县', '3', '11067', 'T');
INSERT INTO `ey_region` VALUES ('11182', '睢宁县', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11200', '新沂市', '3', '11067', 'X');
INSERT INTO `ey_region` VALUES ('11218', '邳州市', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11245', '常州市', '2', '10808', 'C');
INSERT INTO `ey_region` VALUES ('11246', '常州市区', '3', '11245', 'C');
INSERT INTO `ey_region` VALUES ('11247', '天宁区', '3', '11245', 'T');
INSERT INTO `ey_region` VALUES ('11254', '钟楼区', '3', '11245', 'Z');
INSERT INTO `ey_region` VALUES ('11262', '戚墅堰区', '3', '11245', 'Q');
INSERT INTO `ey_region` VALUES ('11266', '新北区', '3', '11245', 'X');
INSERT INTO `ey_region` VALUES ('11276', '武进区', '3', '11245', 'W');
INSERT INTO `ey_region` VALUES ('11311', '溧阳市', '3', '11245', 'L');
INSERT INTO `ey_region` VALUES ('11331', '金坛市', '3', '11245', 'J');
INSERT INTO `ey_region` VALUES ('11348', '苏州市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('11349', '市辖区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11350', '沧浪区', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11357', '平江区', '3', '11348', 'P');
INSERT INTO `ey_region` VALUES ('11368', '金阊区', '3', '11348', 'J');
INSERT INTO `ey_region` VALUES ('11374', '苏州高新区虎丘区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11387', '吴中区', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11409', '相城区', '3', '11348', 'X');
INSERT INTO `ey_region` VALUES ('11419', '常熟市', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11433', '张家港市', '3', '11348', 'Z');
INSERT INTO `ey_region` VALUES ('11448', '昆山市', '3', '11348', 'K');
INSERT INTO `ey_region` VALUES ('11460', '吴江市', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11472', '太仓市', '3', '11348', 'T');
INSERT INTO `ey_region` VALUES ('11482', '南通市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('11483', '市辖区', '3', '11482', 'S');
INSERT INTO `ey_region` VALUES ('11484', '崇川区', '3', '11482', 'C');
INSERT INTO `ey_region` VALUES ('11502', '港闸区', '3', '11482', 'G');
INSERT INTO `ey_region` VALUES ('11510', '海安县', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11526', '如东', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11542', '启东市', '3', '11482', 'Q');
INSERT INTO `ey_region` VALUES ('11568', '如皋市', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11600', '通州市', '3', '11482', 'T');
INSERT INTO `ey_region` VALUES ('11627', '海门市', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11663', '连云港市', '2', '10808', 'L');
INSERT INTO `ey_region` VALUES ('11664', '市辖区', '3', '11663', 'S');
INSERT INTO `ey_region` VALUES ('11665', '连云区', '3', '11663', 'L');
INSERT INTO `ey_region` VALUES ('11678', '新浦区', '3', '11663', 'X');
INSERT INTO `ey_region` VALUES ('11692', '海州区', '3', '11663', 'H');
INSERT INTO `ey_region` VALUES ('11699', '赣榆县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11722', '东海县', '3', '11663', 'D');
INSERT INTO `ey_region` VALUES ('11747', '灌云县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11771', '灌南县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11786', '淮安市', '2', '10808', 'H');
INSERT INTO `ey_region` VALUES ('11787', '市辖区', '3', '11786', 'S');
INSERT INTO `ey_region` VALUES ('11788', '清河区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11801', '楚州区', '3', '11786', 'C');
INSERT INTO `ey_region` VALUES ('11830', '淮阴区', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11853', '清浦区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11863', '涟水县', '3', '11786', 'L');
INSERT INTO `ey_region` VALUES ('11896', '洪泽县', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11909', '盱眙县', '3', '11786', 'X');
INSERT INTO `ey_region` VALUES ('11931', '金湖县', '3', '11786', 'J');
INSERT INTO `ey_region` VALUES ('11947', '盐城市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('11948', '市辖区', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('11949', '亭湖区', '3', '11947', 'T');
INSERT INTO `ey_region` VALUES ('11967', '盐都区', '3', '11947', 'Y');
INSERT INTO `ey_region` VALUES ('11982', '响水县', '3', '11947', 'X');
INSERT INTO `ey_region` VALUES ('11998', '滨海县', '3', '11947', 'B');
INSERT INTO `ey_region` VALUES ('12017', '阜宁县', '3', '11947', 'F');
INSERT INTO `ey_region` VALUES ('12040', '射阳县', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('12066', '建湖县', '3', '11947', 'J');
INSERT INTO `ey_region` VALUES ('12083', '东台市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12117', '大丰市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12135', '扬州市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('12136', '市辖区', '3', '12135', 'S');
INSERT INTO `ey_region` VALUES ('12137', '广陵区', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12144', '邗江区', '3', '12135', 'H');
INSERT INTO `ey_region` VALUES ('12160', '维扬区', '3', '12135', 'W');
INSERT INTO `ey_region` VALUES ('12175', '宝应县', '3', '12135', 'B');
INSERT INTO `ey_region` VALUES ('12191', '仪征市', '3', '12135', 'Y');
INSERT INTO `ey_region` VALUES ('12212', '高邮市', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12235', '江都市', '3', '12135', 'J');
INSERT INTO `ey_region` VALUES ('12249', '镇江市', '2', '10808', 'Z');
INSERT INTO `ey_region` VALUES ('12250', '市区', '3', '12249', 'S');
INSERT INTO `ey_region` VALUES ('12251', '京口区', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12265', '润州区', '3', '12249', 'R');
INSERT INTO `ey_region` VALUES ('12273', '丹徒区', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12282', '丹阳市', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12300', '扬中市', '3', '12249', 'Y');
INSERT INTO `ey_region` VALUES ('12312', '句容市', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12343', '泰州市', '2', '10808', 'T');
INSERT INTO `ey_region` VALUES ('12344', '市辖区', '3', '12343', 'S');
INSERT INTO `ey_region` VALUES ('12345', '海陵区', '3', '12343', 'H');
INSERT INTO `ey_region` VALUES ('12362', '高港区', '3', '12343', 'G');
INSERT INTO `ey_region` VALUES ('12370', '兴化市', '3', '12343', 'X');
INSERT INTO `ey_region` VALUES ('12407', '靖江市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12423', '泰兴市', '3', '12343', 'T');
INSERT INTO `ey_region` VALUES ('12450', '姜堰市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12475', '宿迁市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('12476', '市辖区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12477', '宿城区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12496', '宿豫区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12515', '沭阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12551', '泗阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12570', '泗洪县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12596', '浙江省', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('12597', '杭州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('12598', '市辖区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12599', '上城区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12606', '下城区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12615', '江干区', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12626', '拱墅区', '3', '12597', 'G');
INSERT INTO `ey_region` VALUES ('12637', '西湖区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12652', '滨江区', '3', '12597', 'B');
INSERT INTO `ey_region` VALUES ('12656', '萧山区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12685', '余杭区', '3', '12597', 'Y');
INSERT INTO `ey_region` VALUES ('12705', '桐庐县', '3', '12597', 'T');
INSERT INTO `ey_region` VALUES ('12719', '淳安县', '3', '12597', 'C');
INSERT INTO `ey_region` VALUES ('12743', '建德市', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12760', '富阳市', '3', '12597', 'F');
INSERT INTO `ey_region` VALUES ('12786', '临安市', '3', '12597', 'L');
INSERT INTO `ey_region` VALUES ('12813', '宁波市', '2', '12596', 'N');
INSERT INTO `ey_region` VALUES ('12814', '市辖区', '3', '12813', 'S');
INSERT INTO `ey_region` VALUES ('12815', '海曙区', '3', '12813', 'H');
INSERT INTO `ey_region` VALUES ('12824', '江东区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12832', '江北区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12841', '北仑区', '3', '12813', 'B');
INSERT INTO `ey_region` VALUES ('12851', '镇海区', '3', '12813', 'Z');
INSERT INTO `ey_region` VALUES ('12858', '鄞州区', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12881', '象山县', '3', '12813', 'X');
INSERT INTO `ey_region` VALUES ('12900', '宁海县', '3', '12813', 'N');
INSERT INTO `ey_region` VALUES ('12919', '余姚市', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12941', '慈溪市', '3', '12813', 'C');
INSERT INTO `ey_region` VALUES ('12962', '奉化市', '3', '12813', 'F');
INSERT INTO `ey_region` VALUES ('12974', '温州市', '2', '12596', 'W');
INSERT INTO `ey_region` VALUES ('12975', '市辖区', '3', '12974', 'S');
INSERT INTO `ey_region` VALUES ('12976', '鹿城区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('12998', '龙湾区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13009', '瓯海区', '3', '12974', 'O');
INSERT INTO `ey_region` VALUES ('13023', '洞头县', '3', '12974', 'D');
INSERT INTO `ey_region` VALUES ('13030', '永嘉县', '3', '12974', 'Y');
INSERT INTO `ey_region` VALUES ('13069', '平阳县', '3', '12974', 'P');
INSERT INTO `ey_region` VALUES ('13101', '苍南县', '3', '12974', 'C');
INSERT INTO `ey_region` VALUES ('13138', '文成县', '3', '12974', 'W');
INSERT INTO `ey_region` VALUES ('13172', '泰顺县', '3', '12974', 'T');
INSERT INTO `ey_region` VALUES ('13209', '瑞安市', '3', '12974', 'R');
INSERT INTO `ey_region` VALUES ('13248', '乐清市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13280', '嘉兴市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13281', '市辖区', '3', '13280', 'S');
INSERT INTO `ey_region` VALUES ('13282', '南湖区', '3', '13280', 'N');
INSERT INTO `ey_region` VALUES ('13295', '秀洲区', '3', '13280', 'X');
INSERT INTO `ey_region` VALUES ('13304', '嘉善县', '3', '13280', 'J');
INSERT INTO `ey_region` VALUES ('13316', '海盐县', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13325', '海宁市', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13339', '平湖市', '3', '13280', 'P');
INSERT INTO `ey_region` VALUES ('13350', '桐乡市', '3', '13280', 'T');
INSERT INTO `ey_region` VALUES ('13364', '湖州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('13365', '市辖区', '3', '13364', 'S');
INSERT INTO `ey_region` VALUES ('13366', '吴兴区', '3', '13364', 'W');
INSERT INTO `ey_region` VALUES ('13382', '南浔区', '3', '13364', 'N');
INSERT INTO `ey_region` VALUES ('13392', '德清县', '3', '13364', 'D');
INSERT INTO `ey_region` VALUES ('13404', '长兴县', '3', '13364', 'C');
INSERT INTO `ey_region` VALUES ('13421', '安吉县', '3', '13364', 'A');
INSERT INTO `ey_region` VALUES ('13437', '绍兴市', '2', '12596', 'S');
INSERT INTO `ey_region` VALUES ('13438', '市辖区', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13439', '越城区', '3', '13437', 'Y');
INSERT INTO `ey_region` VALUES ('13453', '绍兴县', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13473', '新昌县', '3', '13437', 'X');
INSERT INTO `ey_region` VALUES ('13490', '诸暨市', '3', '13437', 'Z');
INSERT INTO `ey_region` VALUES ('13518', '上虞市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13542', '嵊州市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13564', '金华市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13565', '市辖区', '3', '13564', 'S');
INSERT INTO `ey_region` VALUES ('13566', '婺城区', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13594', '金东区', '3', '13564', 'J');
INSERT INTO `ey_region` VALUES ('13606', '武义县', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13625', '浦江县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13641', '磐安县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13662', '兰溪市', '3', '13564', 'L');
INSERT INTO `ey_region` VALUES ('13678', '义乌市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13692', '东阳市', '3', '13564', 'D');
INSERT INTO `ey_region` VALUES ('13711', '永康市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13726', '衢州市', '2', '12596', 'Q');
INSERT INTO `ey_region` VALUES ('13727', '市辖区', '3', '13726', 'S');
INSERT INTO `ey_region` VALUES ('13728', '柯城区', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13746', '衢江区', '3', '13726', 'Q');
INSERT INTO `ey_region` VALUES ('13768', '常山县', '3', '13726', 'C');
INSERT INTO `ey_region` VALUES ('13783', '开化县', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13802', '龙游县', '3', '13726', 'L');
INSERT INTO `ey_region` VALUES ('13818', '江山市', '3', '13726', 'J');
INSERT INTO `ey_region` VALUES ('13840', '舟山市', '2', '12596', 'Z');
INSERT INTO `ey_region` VALUES ('13841', '市辖区', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13842', '定海区', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13859', '普陀区', '3', '13840', 'P');
INSERT INTO `ey_region` VALUES ('13874', '岱山县', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13882', '嵊泗县', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13890', '台州市', '2', '12596', 'T');
INSERT INTO `ey_region` VALUES ('13891', '市辖区', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13892', '椒江区', '3', '13890', 'J');
INSERT INTO `ey_region` VALUES ('13903', '黄岩区', '3', '13890', 'H');
INSERT INTO `ey_region` VALUES ('13923', '路桥区', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('13934', '玉环县', '3', '13890', 'Y');
INSERT INTO `ey_region` VALUES ('13944', '三门县', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13959', '天台县', '3', '13890', 'T');
INSERT INTO `ey_region` VALUES ('13975', '仙居县', '3', '13890', 'X');
INSERT INTO `ey_region` VALUES ('13996', '温岭市', '3', '13890', 'W');
INSERT INTO `ey_region` VALUES ('14013', '临海市', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('14033', '丽水市', '2', '12596', 'L');
INSERT INTO `ey_region` VALUES ('14034', '市辖区', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14035', '莲都区', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14054', '青田县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14086', '缙云县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14111', '遂昌县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14132', '松阳县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14153', '云和县', '3', '14033', 'Y');
INSERT INTO `ey_region` VALUES ('14168', '庆元县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14189', '景宁县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14214', '龙泉市', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14234', '安徽省', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('14235', '合肥市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14236', '市辖区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14237', '瑶海区', '3', '14235', 'Y');
INSERT INTO `ey_region` VALUES ('14254', '庐阳区', '3', '14235', 'L');
INSERT INTO `ey_region` VALUES ('14269', '蜀山区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14286', '包河区', '3', '14235', 'B');
INSERT INTO `ey_region` VALUES ('14297', '长丰县', '3', '14235', 'C');
INSERT INTO `ey_region` VALUES ('14314', '肥东县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14334', '肥西县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14351', '芜湖市', '2', '14234', 'W');
INSERT INTO `ey_region` VALUES ('14352', '市辖区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14353', '镜湖区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14366', '弋江区', '3', '14351', 'Y');
INSERT INTO `ey_region` VALUES ('14374', '鸠江区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14382', '三山区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14387', '芜湖县', '3', '14351', 'W');
INSERT INTO `ey_region` VALUES ('14394', '繁昌县', '3', '14351', 'F');
INSERT INTO `ey_region` VALUES ('14401', '南陵县', '3', '14351', 'N');
INSERT INTO `ey_region` VALUES ('14410', '蚌埠市', '2', '14234', 'B');
INSERT INTO `ey_region` VALUES ('14411', '市辖区', '3', '14410', 'S');
INSERT INTO `ey_region` VALUES ('14412', '龙子湖区', '3', '14410', 'L');
INSERT INTO `ey_region` VALUES ('14422', '蚌山区', '3', '14410', 'B');
INSERT INTO `ey_region` VALUES ('14434', '禹会区', '3', '14410', 'Y');
INSERT INTO `ey_region` VALUES ('14443', '淮上区', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14449', '怀远县', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14471', '五河县', '3', '14410', 'W');
INSERT INTO `ey_region` VALUES ('14487', '固镇县', '3', '14410', 'G');
INSERT INTO `ey_region` VALUES ('14500', '淮南市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14501', '市辖区', '3', '14500', 'S');
INSERT INTO `ey_region` VALUES ('14502', '大通区', '3', '14500', 'D');
INSERT INTO `ey_region` VALUES ('14508', '田家庵区', '3', '14500', 'T');
INSERT INTO `ey_region` VALUES ('14523', '谢家集区', '3', '14500', 'X');
INSERT INTO `ey_region` VALUES ('14535', '八公山区', '3', '14500', 'B');
INSERT INTO `ey_region` VALUES ('14542', '潘集区', '3', '14500', 'P');
INSERT INTO `ey_region` VALUES ('14554', '凤台县', '3', '14500', 'F');
INSERT INTO `ey_region` VALUES ('14575', '马鞍山市', '2', '14234', 'M');
INSERT INTO `ey_region` VALUES ('14576', '市辖区', '3', '14575', 'S');
INSERT INTO `ey_region` VALUES ('14577', '金家庄区', '3', '14575', 'J');
INSERT INTO `ey_region` VALUES ('14583', '花山区', '3', '14575', 'H');
INSERT INTO `ey_region` VALUES ('14589', '雨山区', '3', '14575', 'Y');
INSERT INTO `ey_region` VALUES ('14597', '当涂县', '3', '14575', 'D');
INSERT INTO `ey_region` VALUES ('14612', '淮北市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14613', '市辖区', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14614', '杜集区', '3', '14612', 'D');
INSERT INTO `ey_region` VALUES ('14620', '相山区', '3', '14612', 'X');
INSERT INTO `ey_region` VALUES ('14632', '烈山区', '3', '14612', 'L');
INSERT INTO `ey_region` VALUES ('14641', '濉溪县', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14653', '铜陵市', '2', '14234', 'T');
INSERT INTO `ey_region` VALUES ('14654', '市辖区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14655', '铜官山区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14663', '狮子山区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14671', '铜陵市郊区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14678', '铜陵县', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14687', '安庆市', '2', '14234', 'A');
INSERT INTO `ey_region` VALUES ('14688', '市辖区', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14689', '迎江区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14700', '大观区', '3', '14687', 'D');
INSERT INTO `ey_region` VALUES ('14712', '宜秀区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14720', '怀宁县', '3', '14687', 'H');
INSERT INTO `ey_region` VALUES ('14741', '枞阳县', '3', '14687', 'C');
INSERT INTO `ey_region` VALUES ('14764', '潜山县', '3', '14687', 'Q');
INSERT INTO `ey_region` VALUES ('14782', '太湖县', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14798', '宿松县', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14823', '望江县', '3', '14687', 'W');
INSERT INTO `ey_region` VALUES ('14834', '岳西县', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14859', '桐城市', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14887', '黄山市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14888', '市辖区', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14889', '屯溪区', '3', '14887', 'T');
INSERT INTO `ey_region` VALUES ('14900', '黄山区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14917', '徽州区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14926', '歙县', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14955', '休宁县', '3', '14887', 'X');
INSERT INTO `ey_region` VALUES ('14977', '黟县', '3', '14887', 'Y');
INSERT INTO `ey_region` VALUES ('14986', '祁门县', '3', '14887', 'Q');
INSERT INTO `ey_region` VALUES ('15005', '滁州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15006', '市辖区', '3', '15005', 'S');
INSERT INTO `ey_region` VALUES ('15007', '琅琊区', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15016', '南谯区', '3', '15005', 'N');
INSERT INTO `ey_region` VALUES ('15034', '来安县', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15053', '全椒县', '3', '15005', 'Q');
INSERT INTO `ey_region` VALUES ('15071', '定远县', '3', '15005', 'D');
INSERT INTO `ey_region` VALUES ('15109', '凤阳县', '3', '15005', 'F');
INSERT INTO `ey_region` VALUES ('15136', '天长市', '3', '15005', 'T');
INSERT INTO `ey_region` VALUES ('15166', '明光市', '3', '15005', 'M');
INSERT INTO `ey_region` VALUES ('15194', '阜阳市', '2', '14234', 'F');
INSERT INTO `ey_region` VALUES ('15195', '市辖区', '3', '15194', 'S');
INSERT INTO `ey_region` VALUES ('15196', '颍州区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15211', '颍东区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15224', '颍泉区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15231', '临泉县', '3', '15194', 'L');
INSERT INTO `ey_region` VALUES ('15264', '太和县', '3', '15194', 'T');
INSERT INTO `ey_region` VALUES ('15296', '阜南县', '3', '15194', 'F');
INSERT INTO `ey_region` VALUES ('15328', '颍上县', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15359', '界首市', '3', '15194', 'J');
INSERT INTO `ey_region` VALUES ('15378', '宿州市', '2', '14234', 'S');
INSERT INTO `ey_region` VALUES ('15379', '市辖区', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15380', '墉桥区', '3', '15378', 'Y');
INSERT INTO `ey_region` VALUES ('15417', '砀山县', '3', '15378', 'D');
INSERT INTO `ey_region` VALUES ('15437', '萧县', '3', '15378', 'X');
INSERT INTO `ey_region` VALUES ('15461', '灵璧县', '3', '15378', 'L');
INSERT INTO `ey_region` VALUES ('15482', '泗县', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15499', '巢湖市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15500', '市辖区', '3', '15499', 'S');
INSERT INTO `ey_region` VALUES ('15501', '居巢区', '3', '15499', 'J');
INSERT INTO `ey_region` VALUES ('15520', '庐江县', '3', '15499', 'L');
INSERT INTO `ey_region` VALUES ('15542', '无为县', '3', '15499', 'W');
INSERT INTO `ey_region` VALUES ('15566', '含山县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15575', '和县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15586', '六安市', '2', '14234', 'L');
INSERT INTO `ey_region` VALUES ('15587', '市辖区', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15588', '金安区', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15612', '裕安区', '3', '15586', 'Y');
INSERT INTO `ey_region` VALUES ('15635', '寿县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15662', '霍邱县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15698', '舒城县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15720', '金寨县', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15747', '霍山县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15764', '亳州市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('15765', '市辖区', '3', '15764', 'S');
INSERT INTO `ey_region` VALUES ('15766', '谯城区', '3', '15764', 'Q');
INSERT INTO `ey_region` VALUES ('15795', '涡阳县', '3', '15764', 'W');
INSERT INTO `ey_region` VALUES ('15823', '蒙城县', '3', '15764', 'M');
INSERT INTO `ey_region` VALUES ('15843', '利辛县', '3', '15764', 'L');
INSERT INTO `ey_region` VALUES ('15871', '池州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15872', '市辖区', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15873', '贵池区', '3', '15871', 'G');
INSERT INTO `ey_region` VALUES ('15900', '东至县', '3', '15871', 'D');
INSERT INTO `ey_region` VALUES ('15930', '石台县', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15944', '青阳县', '3', '15871', 'Q');
INSERT INTO `ey_region` VALUES ('15958', '宣城市', '2', '14234', 'X');
INSERT INTO `ey_region` VALUES ('15959', '市辖区', '3', '15958', 'S');
INSERT INTO `ey_region` VALUES ('15960', '宣州区', '3', '15958', 'X');
INSERT INTO `ey_region` VALUES ('15987', '郎溪县', '3', '15958', 'L');
INSERT INTO `ey_region` VALUES ('16001', '广德县', '3', '15958', 'G');
INSERT INTO `ey_region` VALUES ('16013', '泾县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16025', '绩溪县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16037', '旌德县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16048', '宁国市', '3', '15958', 'N');
INSERT INTO `ey_region` VALUES ('16068', '福建省', '1', '0', 'F');
INSERT INTO `ey_region` VALUES ('16069', '福州市', '2', '16068', 'F');
INSERT INTO `ey_region` VALUES ('16070', '市辖区', '3', '16069', 'S');
INSERT INTO `ey_region` VALUES ('16071', '鼓楼区', '3', '16069', 'G');
INSERT INTO `ey_region` VALUES ('16082', '台江区', '3', '16069', 'T');
INSERT INTO `ey_region` VALUES ('16093', '仓山区', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16108', '马尾区', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16113', '晋安区', '3', '16069', 'J');
INSERT INTO `ey_region` VALUES ('16123', '闽侯县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16140', '连江县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16164', '罗源县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16177', '闽清县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16194', '永泰县', '3', '16069', 'Y');
INSERT INTO `ey_region` VALUES ('16216', '平潭县', '3', '16069', 'P');
INSERT INTO `ey_region` VALUES ('16232', '福清市', '3', '16069', 'F');
INSERT INTO `ey_region` VALUES ('16259', '长乐市', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16278', '厦门市', '2', '16068', 'X');
INSERT INTO `ey_region` VALUES ('16279', '市辖区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16280', '思明区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16294', '海沧区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16303', '湖里区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16315', '集美区', '3', '16278', 'J');
INSERT INTO `ey_region` VALUES ('16326', '同安区', '3', '16278', 'T');
INSERT INTO `ey_region` VALUES ('16341', '翔安区', '3', '16278', 'X');
INSERT INTO `ey_region` VALUES ('16348', '莆田市', '2', '16068', 'P');
INSERT INTO `ey_region` VALUES ('16349', '市辖区', '3', '16348', 'S');
INSERT INTO `ey_region` VALUES ('16350', '城厢区', '3', '16348', 'C');
INSERT INTO `ey_region` VALUES ('16358', '涵江区', '3', '16348', 'H');
INSERT INTO `ey_region` VALUES ('16372', '荔城区', '3', '16348', 'L');
INSERT INTO `ey_region` VALUES ('16379', '秀屿区', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16393', '仙游县', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16412', '三明市', '2', '16068', 'S');
INSERT INTO `ey_region` VALUES ('16413', '市辖区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16414', '梅列区', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16421', '三元区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16430', '明溪县', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16440', '清流县', '3', '16412', 'Q');
INSERT INTO `ey_region` VALUES ('16455', '宁化县', '3', '16412', 'N');
INSERT INTO `ey_region` VALUES ('16472', '大田县', '3', '16412', 'D');
INSERT INTO `ey_region` VALUES ('16492', '尤溪县', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16508', '沙县', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16521', '将乐县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16535', '泰宁县', '3', '16412', 'T');
INSERT INTO `ey_region` VALUES ('16545', '建宁县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16556', '永安市', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16572', '泉州市', '2', '16068', 'Q');
INSERT INTO `ey_region` VALUES ('16573', '市辖区', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16574', '鲤城区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16584', '丰泽区', '3', '16572', 'F');
INSERT INTO `ey_region` VALUES ('16593', '洛江区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16600', '泉港区', '3', '16572', 'Q');
INSERT INTO `ey_region` VALUES ('16608', '惠安县', '3', '16572', 'H');
INSERT INTO `ey_region` VALUES ('16625', '安溪县', '3', '16572', 'A');
INSERT INTO `ey_region` VALUES ('16650', '永春县', '3', '16572', 'Y');
INSERT INTO `ey_region` VALUES ('16673', '德化县', '3', '16572', 'D');
INSERT INTO `ey_region` VALUES ('16692', '金门县', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16693', '石狮市', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16703', '晋江市', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16726', '南安市', '3', '16572', 'N');
INSERT INTO `ey_region` VALUES ('16754', '漳州市', '2', '16068', 'Z');
INSERT INTO `ey_region` VALUES ('16755', '市辖区', '3', '16754', 'S');
INSERT INTO `ey_region` VALUES ('16756', '芗城区', '3', '16754', 'X');
INSERT INTO `ey_region` VALUES ('16772', '龙文区', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16778', '云霄县', '3', '16754', 'Y');
INSERT INTO `ey_region` VALUES ('16790', '漳浦县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16821', '诏安县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16842', '长泰县', '3', '16754', 'C');
INSERT INTO `ey_region` VALUES ('16852', '东山县', '3', '16754', 'D');
INSERT INTO `ey_region` VALUES ('16860', '南靖县', '3', '16754', 'N');
INSERT INTO `ey_region` VALUES ('16872', '平和县', '3', '16754', 'P');
INSERT INTO `ey_region` VALUES ('16889', '华安县', '3', '16754', 'H');
INSERT INTO `ey_region` VALUES ('16899', '龙海市', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16924', '南平市', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('16925', '市辖区', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16926', '延平区', '3', '16924', 'Y');
INSERT INTO `ey_region` VALUES ('16948', '顺昌县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16961', '浦城县', '3', '16924', 'P');
INSERT INTO `ey_region` VALUES ('16982', '光泽县', '3', '16924', 'G');
INSERT INTO `ey_region` VALUES ('16991', '松溪县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17001', '政和县', '3', '16924', 'Z');
INSERT INTO `ey_region` VALUES ('17012', '邵武市', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17033', '武夷山市', '3', '16924', 'W');
INSERT INTO `ey_region` VALUES ('17044', '建瓯市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17063', '建阳市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17077', '龙岩市', '2', '16068', 'L');
INSERT INTO `ey_region` VALUES ('17078', '市辖区', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17079', '新罗区', '3', '17077', 'X');
INSERT INTO `ey_region` VALUES ('17099', '长汀县', '3', '17077', 'C');
INSERT INTO `ey_region` VALUES ('17118', '永定县', '3', '17077', 'Y');
INSERT INTO `ey_region` VALUES ('17143', '上杭县', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17166', '武平县', '3', '17077', 'W');
INSERT INTO `ey_region` VALUES ('17184', '连城县', '3', '17077', 'L');
INSERT INTO `ey_region` VALUES ('17202', '漳平市', '3', '17077', 'Z');
INSERT INTO `ey_region` VALUES ('17219', '宁德市　', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('17220', '市辖区', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17221', '蕉城区', '3', '17219', 'J');
INSERT INTO `ey_region` VALUES ('17239', '霞浦县', '3', '17219', 'X');
INSERT INTO `ey_region` VALUES ('17254', '古田县', '3', '17219', 'G');
INSERT INTO `ey_region` VALUES ('17269', '屏南县', '3', '17219', 'P');
INSERT INTO `ey_region` VALUES ('17281', '寿宁县', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17296', '周宁县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17306', '柘荣县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17316', '福安市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17341', '福鼎市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17359', '江西省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('17360', '南昌市', '2', '17359', 'N');
INSERT INTO `ey_region` VALUES ('17361', '市辖区', '3', '17360', 'S');
INSERT INTO `ey_region` VALUES ('17362', '东湖区', '3', '17360', 'D');
INSERT INTO `ey_region` VALUES ('17374', '西湖区', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17387', '青云谱区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17395', '湾里区', '3', '17360', 'W');
INSERT INTO `ey_region` VALUES ('17402', '青山湖区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17420', '南昌县', '3', '17360', 'N');
INSERT INTO `ey_region` VALUES ('17443', '新建县', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17471', '安义县', '3', '17360', 'A');
INSERT INTO `ey_region` VALUES ('17485', '进贤县', '3', '17360', 'J');
INSERT INTO `ey_region` VALUES ('17508', '景德镇市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17509', '市辖区', '3', '17508', 'S');
INSERT INTO `ey_region` VALUES ('17510', '昌江区', '3', '17508', 'C');
INSERT INTO `ey_region` VALUES ('17534', '珠山区', '3', '17508', 'Z');
INSERT INTO `ey_region` VALUES ('17545', '浮梁县', '3', '17508', 'F');
INSERT INTO `ey_region` VALUES ('17568', '乐平市', '3', '17508', 'L');
INSERT INTO `ey_region` VALUES ('17589', '萍乡市', '2', '17359', 'P');
INSERT INTO `ey_region` VALUES ('17590', '市辖区', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17591', '安源区', '3', '17589', 'A');
INSERT INTO `ey_region` VALUES ('17604', '湘东区', '3', '17589', 'X');
INSERT INTO `ey_region` VALUES ('17616', '莲花县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17630', '上栗县', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17640', '芦溪县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17651', '九江市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17652', '市辖区', '3', '17651', 'S');
INSERT INTO `ey_region` VALUES ('17653', '庐山区', '3', '17651', 'L');
INSERT INTO `ey_region` VALUES ('17667', '浔阳区', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17676', '九江县', '3', '17651', 'J');
INSERT INTO `ey_region` VALUES ('17693', '武宁县', '3', '17651', 'W');
INSERT INTO `ey_region` VALUES ('17714', '修水县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17751', '永修县', '3', '17651', 'Y');
INSERT INTO `ey_region` VALUES ('17773', '德安县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17792', '星子县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17807', '都昌县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17834', '湖口县', '3', '17651', 'H');
INSERT INTO `ey_region` VALUES ('17849', '彭泽县', '3', '17651', 'P');
INSERT INTO `ey_region` VALUES ('17872', '瑞昌市', '3', '17651', 'R');
INSERT INTO `ey_region` VALUES ('17894', '新余市', '2', '17359', 'X');
INSERT INTO `ey_region` VALUES ('17895', '市辖区', '3', '17894', 'S');
INSERT INTO `ey_region` VALUES ('17896', '渝水区', '3', '17894', 'Y');
INSERT INTO `ey_region` VALUES ('17917', '分宜县', '3', '17894', 'F');
INSERT INTO `ey_region` VALUES ('17934', '鹰潭市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('17935', '市辖区', '3', '17934', 'S');
INSERT INTO `ey_region` VALUES ('17936', '月湖区', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17945', '余江县', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17966', '贵溪市', '3', '17934', 'G');
INSERT INTO `ey_region` VALUES ('17999', '赣州市', '2', '17359', 'G');
INSERT INTO `ey_region` VALUES ('18000', '市辖区', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18001', '章贡区', '3', '17999', 'Z');
INSERT INTO `ey_region` VALUES ('18016', '赣县', '3', '17999', 'G');
INSERT INTO `ey_region` VALUES ('18037', '信丰县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18055', '大余县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18068', '上犹县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18084', '崇义县', '3', '17999', 'C');
INSERT INTO `ey_region` VALUES ('18102', '安远县', '3', '17999', 'A');
INSERT INTO `ey_region` VALUES ('18122', '龙南县', '3', '17999', 'L');
INSERT INTO `ey_region` VALUES ('18139', '定南县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18148', '全南县', '3', '17999', 'Q');
INSERT INTO `ey_region` VALUES ('18161', '宁都县', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18187', '于都县', '3', '17999', 'Y');
INSERT INTO `ey_region` VALUES ('18212', '兴国县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18239', '会昌县', '3', '17999', 'H');
INSERT INTO `ey_region` VALUES ('18260', '寻乌县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18276', '石城县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18287', '瑞金市', '3', '17999', 'R');
INSERT INTO `ey_region` VALUES ('18306', '南康市', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18330', '吉安市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('18331', '市辖区', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18332', '吉州区', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18345', '青原区', '3', '18330', 'Q');
INSERT INTO `ey_region` VALUES ('18356', '吉安县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18378', '吉水县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18398', '峡江县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18411', '新干县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18429', '永丰县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18454', '泰和县', '3', '18330', 'T');
INSERT INTO `ey_region` VALUES ('18483', '遂川县', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18510', '万安县', '3', '18330', 'W');
INSERT INTO `ey_region` VALUES ('18529', '安福县', '3', '18330', 'A');
INSERT INTO `ey_region` VALUES ('18550', '永新县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18575', '井冈山市', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18598', '宜春市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('18599', '市辖区', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18600', '袁州区', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18639', '奉新县', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18659', '万载县', '3', '18598', 'W');
INSERT INTO `ey_region` VALUES ('18678', '上高县', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18696', '宜丰县', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18714', '靖安县', '3', '18598', 'J');
INSERT INTO `ey_region` VALUES ('18727', '铜鼓县', '3', '18598', 'T');
INSERT INTO `ey_region` VALUES ('18741', '丰城市', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18777', '樟树市', '3', '18598', 'Z');
INSERT INTO `ey_region` VALUES ('18799', '高安市', '3', '18598', 'G');
INSERT INTO `ey_region` VALUES ('18829', '抚州市', '2', '17359', 'F');
INSERT INTO `ey_region` VALUES ('18830', '市辖区', '3', '18829', 'S');
INSERT INTO `ey_region` VALUES ('18831', '临川区', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18869', '南城县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18882', '黎川县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18900', '南丰县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18915', '崇仁县', '3', '18829', 'C');
INSERT INTO `ey_region` VALUES ('18931', '乐安县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18949', '宜黄县', '3', '18829', 'Y');
INSERT INTO `ey_region` VALUES ('18965', '金溪县', '3', '18829', 'J');
INSERT INTO `ey_region` VALUES ('18980', '资溪县', '3', '18829', 'Z');
INSERT INTO `ey_region` VALUES ('18988', '东乡县', '3', '18829', 'D');
INSERT INTO `ey_region` VALUES ('19010', '广昌县', '3', '18829', 'G');
INSERT INTO `ey_region` VALUES ('19024', '上饶市', '2', '17359', 'S');
INSERT INTO `ey_region` VALUES ('19025', '市辖区', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19026', '信州区', '3', '19024', 'X');
INSERT INTO `ey_region` VALUES ('19038', '上饶县', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19062', '广丰县', '3', '19024', 'G');
INSERT INTO `ey_region` VALUES ('19088', '玉山县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19108', '铅山县', '3', '19024', 'Q');
INSERT INTO `ey_region` VALUES ('19136', '横峰县', '3', '19024', 'H');
INSERT INTO `ey_region` VALUES ('19151', '弋阳县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19171', '余干县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19202', '鄱阳县', '3', '19024', 'P');
INSERT INTO `ey_region` VALUES ('19234', '万年县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19248', '婺源县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19265', '德兴市', '3', '19024', 'D');
INSERT INTO `ey_region` VALUES ('19280', '山东省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('19281', '济南市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('19282', '市辖区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19283', '历下区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19295', '市中区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19311', '槐荫区', '3', '19281', 'H');
INSERT INTO `ey_region` VALUES ('19326', '天桥区', '3', '19281', 'T');
INSERT INTO `ey_region` VALUES ('19342', '历城区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19359', '长清区', '3', '19281', 'C');
INSERT INTO `ey_region` VALUES ('19370', '平阴县', '3', '19281', 'P');
INSERT INTO `ey_region` VALUES ('19378', '济阳县', '3', '19281', 'J');
INSERT INTO `ey_region` VALUES ('19387', '商河县', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19400', '章丘市', '3', '19281', 'Z');
INSERT INTO `ey_region` VALUES ('19421', '青岛市', '2', '19280', 'Q');
INSERT INTO `ey_region` VALUES ('19422', '市辖区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19423', '市南区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19438', '市北区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19456', '四方区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19464', '黄岛区', '3', '19421', 'H');
INSERT INTO `ey_region` VALUES ('19471', '崂山区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19476', '李沧区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19488', '城阳区', '3', '19421', 'C');
INSERT INTO `ey_region` VALUES ('19497', '胶州市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19516', '即墨市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19540', '平度市', '3', '19421', 'P');
INSERT INTO `ey_region` VALUES ('19572', '胶南市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19590', '莱西市', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19608', '淄博市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19609', '市辖区', '3', '19608', 'S');
INSERT INTO `ey_region` VALUES ('19610', '淄川区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19632', '张店区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19649', '博山区', '3', '19608', 'B');
INSERT INTO `ey_region` VALUES ('19663', '临淄区', '3', '19608', 'L');
INSERT INTO `ey_region` VALUES ('19678', '周村区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19688', '桓台县', '3', '19608', 'H');
INSERT INTO `ey_region` VALUES ('19700', '高青县', '3', '19608', 'G');
INSERT INTO `ey_region` VALUES ('19710', '沂源县', '3', '19608', 'Y');
INSERT INTO `ey_region` VALUES ('19724', '枣庄市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19725', '市辖区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19726', '市中区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19738', '薛城区', '3', '19724', 'X');
INSERT INTO `ey_region` VALUES ('19748', '峄城区', '3', '19724', 'Y');
INSERT INTO `ey_region` VALUES ('19756', '台儿庄区', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19763', '山亭区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19774', '滕州市', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19796', '东营市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('19797', '市辖区', '3', '19796', 'S');
INSERT INTO `ey_region` VALUES ('19798', '东营区', '3', '19796', 'D');
INSERT INTO `ey_region` VALUES ('19809', '河口区', '3', '19796', 'H');
INSERT INTO `ey_region` VALUES ('19817', '垦利县', '3', '19796', 'K');
INSERT INTO `ey_region` VALUES ('19825', '利津县', '3', '19796', 'L');
INSERT INTO `ey_region` VALUES ('19835', '广饶县', '3', '19796', 'G');
INSERT INTO `ey_region` VALUES ('19846', '烟台市', '2', '19280', 'Y');
INSERT INTO `ey_region` VALUES ('19847', '市辖区', '3', '19846', 'S');
INSERT INTO `ey_region` VALUES ('19848', '芝罘区', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19861', '福山区', '3', '19846', 'F');
INSERT INTO `ey_region` VALUES ('19873', '牟平区', '3', '19846', 'M');
INSERT INTO `ey_region` VALUES ('19887', '莱山区', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19893', '长岛县', '3', '19846', 'C');
INSERT INTO `ey_region` VALUES ('19902', '龙口市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19916', '莱阳市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19935', '莱州市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19952', '蓬莱市', '3', '19846', 'P');
INSERT INTO `ey_region` VALUES ('19965', '招远市', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19980', '栖霞市', '3', '19846', 'Q');
INSERT INTO `ey_region` VALUES ('19996', '海阳市', '3', '19846', 'H');
INSERT INTO `ey_region` VALUES ('20012', '潍坊市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20013', '市辖区', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20014', '潍城区', '3', '20012', 'W');
INSERT INTO `ey_region` VALUES ('20023', '寒亭区', '3', '20012', 'H');
INSERT INTO `ey_region` VALUES ('20034', '坊子区', '3', '20012', 'F');
INSERT INTO `ey_region` VALUES ('20043', '奎文区', '3', '20012', 'K');
INSERT INTO `ey_region` VALUES ('20055', '临朐县', '3', '20012', 'L');
INSERT INTO `ey_region` VALUES ('20074', '昌乐县', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20091', '青州市', '3', '20012', 'Q');
INSERT INTO `ey_region` VALUES ('20113', '诸城市', '3', '20012', 'Z');
INSERT INTO `ey_region` VALUES ('20137', '寿光市', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20155', '安丘市', '3', '20012', 'A');
INSERT INTO `ey_region` VALUES ('20179', '高密市', '3', '20012', 'G');
INSERT INTO `ey_region` VALUES ('20200', '昌邑市', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20216', '济宁市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('20217', '市辖区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20218', '市中区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20227', '任城区', '3', '20216', 'R');
INSERT INTO `ey_region` VALUES ('20257', '鱼台县', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20268', '金乡县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20282', '嘉祥县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20298', '汶上县', '3', '20216', 'W');
INSERT INTO `ey_region` VALUES ('20313', '泗水县', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20327', '梁山县', '3', '20216', 'L');
INSERT INTO `ey_region` VALUES ('20342', '曲阜市', '3', '20216', 'Q');
INSERT INTO `ey_region` VALUES ('20355', '兖州市', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20368', '邹城市', '3', '20216', 'Z');
INSERT INTO `ey_region` VALUES ('20386', '泰安市', '2', '19280', 'T');
INSERT INTO `ey_region` VALUES ('20387', '市辖区', '3', '20386', 'S');
INSERT INTO `ey_region` VALUES ('20388', '泰山区', '3', '20386', 'T');
INSERT INTO `ey_region` VALUES ('20397', '岱岳区', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20416', '宁阳县', '3', '20386', 'N');
INSERT INTO `ey_region` VALUES ('20429', '东平县', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20444', '新泰市', '3', '20386', 'X');
INSERT INTO `ey_region` VALUES ('20465', '肥城市', '3', '20386', 'F');
INSERT INTO `ey_region` VALUES ('20480', '威海市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20481', '市辖区', '3', '20480', 'S');
INSERT INTO `ey_region` VALUES ('20482', '环翠区', '3', '20480', 'H');
INSERT INTO `ey_region` VALUES ('20500', '文登市', '3', '20480', 'W');
INSERT INTO `ey_region` VALUES ('20519', '荣成市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20542', '乳山市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20558', '日照市', '2', '19280', 'R');
INSERT INTO `ey_region` VALUES ('20559', '市辖区', '3', '20558', 'S');
INSERT INTO `ey_region` VALUES ('20560', '东港区', '3', '20558', 'D');
INSERT INTO `ey_region` VALUES ('20573', '岚山区', '3', '20558', 'L');
INSERT INTO `ey_region` VALUES ('20583', '五莲县', '3', '20558', 'W');
INSERT INTO `ey_region` VALUES ('20596', '莒县', '3', '20558', 'J');
INSERT INTO `ey_region` VALUES ('20618', '莱芜市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20619', '市辖区', '3', '20618', 'S');
INSERT INTO `ey_region` VALUES ('20620', '莱城区', '3', '20618', 'L');
INSERT INTO `ey_region` VALUES ('20636', '钢城区', '3', '20618', 'G');
INSERT INTO `ey_region` VALUES ('20642', '临沂市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20643', '临沂市辖区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20644', '兰山区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20656', '罗庄区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20665', '河东区', '3', '20642', 'H');
INSERT INTO `ey_region` VALUES ('20678', '沂南县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20696', '郯城县', '3', '20642', 'T');
INSERT INTO `ey_region` VALUES ('20714', '沂水县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20734', '苍山县', '3', '20642', 'C');
INSERT INTO `ey_region` VALUES ('20756', '费县', '3', '20642', 'F');
INSERT INTO `ey_region` VALUES ('20775', '平邑县', '3', '20642', 'P');
INSERT INTO `ey_region` VALUES ('20792', '莒南县', '3', '20642', 'J');
INSERT INTO `ey_region` VALUES ('20811', '蒙阴县', '3', '20642', 'M');
INSERT INTO `ey_region` VALUES ('20823', '临沭县', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20836', '德州市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('20837', '市辖区', '3', '20836', 'S');
INSERT INTO `ey_region` VALUES ('20838', '德城区', '3', '20836', 'D');
INSERT INTO `ey_region` VALUES ('20850', '陵县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20864', '宁津县', '3', '20836', 'N');
INSERT INTO `ey_region` VALUES ('20876', '庆云县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20886', '临邑县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20899', '齐河县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20914', '平原县', '3', '20836', 'P');
INSERT INTO `ey_region` VALUES ('20927', '夏津县', '3', '20836', 'X');
INSERT INTO `ey_region` VALUES ('20942', '武城县', '3', '20836', 'W');
INSERT INTO `ey_region` VALUES ('20952', '乐陵市', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20969', '禹城市', '3', '20836', 'Y');
INSERT INTO `ey_region` VALUES ('20981', '聊城市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20982', '市辖区', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('20983', '东昌府区', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21004', '阳谷县', '3', '20981', 'Y');
INSERT INTO `ey_region` VALUES ('21023', '莘县', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('21046', '茌平县', '3', '20981', 'C');
INSERT INTO `ey_region` VALUES ('21063', '东阿县', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21075', '冠县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21093', '高唐县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21106', '临清市', '3', '20981', 'L');
INSERT INTO `ey_region` VALUES ('21123', '滨州市', '2', '19280', 'B');
INSERT INTO `ey_region` VALUES ('21124', '市辖区', '3', '21123', 'S');
INSERT INTO `ey_region` VALUES ('21125', '滨城区', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21141', '惠民县', '3', '21123', 'H');
INSERT INTO `ey_region` VALUES ('21156', '阳信县', '3', '21123', 'Y');
INSERT INTO `ey_region` VALUES ('21166', '无棣县', '3', '21123', 'W');
INSERT INTO `ey_region` VALUES ('21178', '沾化县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21190', '博兴县', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21201', '邹平县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21218', '菏泽市', '2', '19280', 'H');
INSERT INTO `ey_region` VALUES ('21219', '市辖区', '3', '21218', 'S');
INSERT INTO `ey_region` VALUES ('21220', '牡丹区', '3', '21218', 'M');
INSERT INTO `ey_region` VALUES ('21245', '曹县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21271', '单县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21292', '成武县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21305', '巨野县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21322', '郓城县', '3', '21218', 'Y');
INSERT INTO `ey_region` VALUES ('21344', '鄄城县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21361', '定陶县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21373', '东明县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21387', '河南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('21388', '郑州市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('21389', '市辖区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21390', '中原区', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21404', '二七区', '3', '21388', 'E');
INSERT INTO `ey_region` VALUES ('21420', '管城回族区', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21435', '金水区', '3', '21388', 'J');
INSERT INTO `ey_region` VALUES ('21453', '上街区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21460', '惠济区', '3', '21388', 'H');
INSERT INTO `ey_region` VALUES ('21469', '中牟县', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21487', '巩义市', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21508', '荥阳市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21523', '新密市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21542', '新郑市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21558', '登封市', '3', '21388', 'D');
INSERT INTO `ey_region` VALUES ('21575', '开封市', '2', '21387', 'K');
INSERT INTO `ey_region` VALUES ('21576', '市辖区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21577', '龙亭区', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21584', '顺河区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21593', '鼓楼区', '3', '21575', 'G');
INSERT INTO `ey_region` VALUES ('21602', '禹王台区', '3', '21575', 'Y');
INSERT INTO `ey_region` VALUES ('21610', '金明区', '3', '21575', 'J');
INSERT INTO `ey_region` VALUES ('21618', '杞县', '3', '21575', 'Q');
INSERT INTO `ey_region` VALUES ('21640', '通许县', '3', '21575', 'T');
INSERT INTO `ey_region` VALUES ('21653', '尉氏县', '3', '21575', 'W');
INSERT INTO `ey_region` VALUES ('21671', '开封县', '3', '21575', 'K');
INSERT INTO `ey_region` VALUES ('21687', '兰考县', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21711', '洛阳市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('21712', '市辖区', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21713', '老城区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21722', '西工区', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21733', '廛河回族区', '3', '21711', 'C');
INSERT INTO `ey_region` VALUES ('21742', '涧西区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21758', '吉利区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21761', '洛龙区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21770', '孟津县', '3', '21711', 'M');
INSERT INTO `ey_region` VALUES ('21781', '新安县', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21794', '栾川县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21809', '嵩县', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21829', '汝阳县', '3', '21711', 'R');
INSERT INTO `ey_region` VALUES ('21844', '宜阳县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21862', '洛宁县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21881', '伊川县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21896', '偃师市', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21913', '平顶山市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('21914', '市辖区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21915', '新华区', '3', '21913', 'X');
INSERT INTO `ey_region` VALUES ('21928', '卫东区', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('21940', '石龙区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21945', '湛河区', '3', '21913', 'Z');
INSERT INTO `ey_region` VALUES ('21954', '宝丰县', '3', '21913', 'B');
INSERT INTO `ey_region` VALUES ('21968', '叶  县', '3', '21913', 'Y');
INSERT INTO `ey_region` VALUES ('21987', '鲁山县', '3', '21913', 'L');
INSERT INTO `ey_region` VALUES ('22009', '郏  县', '3', '21913', 'J');
INSERT INTO `ey_region` VALUES ('22024', '舞钢市', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('22037', '汝州市', '3', '21913', 'R');
INSERT INTO `ey_region` VALUES ('22058', '安阳市', '2', '21387', 'A');
INSERT INTO `ey_region` VALUES ('22059', '市辖区', '3', '22058', 'S');
INSERT INTO `ey_region` VALUES ('22060', '文峰区', '3', '22058', 'W');
INSERT INTO `ey_region` VALUES ('22080', '北关区', '3', '22058', 'B');
INSERT INTO `ey_region` VALUES ('22090', '殷都区', '3', '22058', 'Y');
INSERT INTO `ey_region` VALUES ('22101', '龙安区', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22111', '安阳县', '3', '22058', 'A');
INSERT INTO `ey_region` VALUES ('22133', '汤阴县', '3', '22058', 'T');
INSERT INTO `ey_region` VALUES ('22144', '滑县', '3', '22058', 'H');
INSERT INTO `ey_region` VALUES ('22167', '内黄县', '3', '22058', 'N');
INSERT INTO `ey_region` VALUES ('22185', '林州市', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22206', '鹤壁市', '2', '21387', 'H');
INSERT INTO `ey_region` VALUES ('22207', '市辖区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22208', '鹤山区', '3', '22206', 'H');
INSERT INTO `ey_region` VALUES ('22216', '山城区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22224', '淇滨区', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22232', '浚县', '3', '22206', 'J');
INSERT INTO `ey_region` VALUES ('22243', '淇县', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22251', '新乡市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22252', '市辖区', '3', '22251', 'S');
INSERT INTO `ey_region` VALUES ('22253', '红旗区', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22264', '卫滨区', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22273', '凤泉区', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22279', '牧野区', '3', '22251', 'M');
INSERT INTO `ey_region` VALUES ('22290', '新乡县', '3', '22251', 'X');
INSERT INTO `ey_region` VALUES ('22299', '获嘉县', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22312', '原阳县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22330', '延津县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22347', '封丘县', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22367', '长垣县', '3', '22251', 'C');
INSERT INTO `ey_region` VALUES ('22386', '卫辉市', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22400', '辉县市', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22423', '焦作市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('22424', '市辖区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22425', '解放区', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22435', '中站区', '3', '22423', 'Z');
INSERT INTO `ey_region` VALUES ('22446', '马村区', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22454', '山阳区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22465', '修武县', '3', '22423', 'X');
INSERT INTO `ey_region` VALUES ('22475', '博爱县', '3', '22423', 'B');
INSERT INTO `ey_region` VALUES ('22487', '武陟县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22503', '温县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22515', '济源市', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22532', '沁阳市', '3', '22423', 'Q');
INSERT INTO `ey_region` VALUES ('22546', '孟州市', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22558', '濮阳市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('22559', '市辖区', '3', '22558', 'S');
INSERT INTO `ey_region` VALUES ('22560', '华龙区', '3', '22558', 'H');
INSERT INTO `ey_region` VALUES ('22578', '清丰县', '3', '22558', 'Q');
INSERT INTO `ey_region` VALUES ('22596', '南乐县', '3', '22558', 'N');
INSERT INTO `ey_region` VALUES ('22609', '范县', '3', '22558', 'F');
INSERT INTO `ey_region` VALUES ('22622', '台前县', '3', '22558', 'T');
INSERT INTO `ey_region` VALUES ('22632', '濮阳县', '3', '22558', 'P');
INSERT INTO `ey_region` VALUES ('22655', '许昌市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22656', '市辖区', '3', '22655', 'S');
INSERT INTO `ey_region` VALUES ('22657', '魏都区', '3', '22655', 'W');
INSERT INTO `ey_region` VALUES ('22671', '许昌县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22688', '鄢陵县', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22701', '襄城县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22718', '禹州市', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22745', '长葛市', '3', '22655', 'C');
INSERT INTO `ey_region` VALUES ('22762', '漯河市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('22763', '市辖区', '3', '22762', 'S');
INSERT INTO `ey_region` VALUES ('22764', '源汇区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22773', '郾城区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22783', '召陵区', '3', '22762', 'Z');
INSERT INTO `ey_region` VALUES ('22793', '舞阳县', '3', '22762', 'W');
INSERT INTO `ey_region` VALUES ('22808', '临颖县', '3', '22762', 'L');
INSERT INTO `ey_region` VALUES ('22824', '三门峡市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('22825', '市辖区', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22826', '湖滨区', '3', '22824', 'H');
INSERT INTO `ey_region` VALUES ('22838', '渑池县', '3', '22824', 'M');
INSERT INTO `ey_region` VALUES ('22851', '陕县', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22865', '卢氏县', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22885', '义马市', '3', '22824', 'Y');
INSERT INTO `ey_region` VALUES ('22893', '灵宝市', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22910', '南阳市', '2', '21387', 'N');
INSERT INTO `ey_region` VALUES ('22911', '市辖区', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('22912', '宛城区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22930', '卧龙区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22951', '南召县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('22973', '方城县', '3', '22910', 'F');
INSERT INTO `ey_region` VALUES ('22992', '西峡县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23013', '镇平县', '3', '22910', 'Z');
INSERT INTO `ey_region` VALUES ('23036', '内乡县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('23053', '淅川县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23071', '社旗县', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('23087', '唐河县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23108', '新野县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23123', '桐柏县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23140', '邓州市', '3', '22910', 'D');
INSERT INTO `ey_region` VALUES ('23170', '商丘市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('23171', '市辖区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23172', '梁园区', '3', '23170', 'L');
INSERT INTO `ey_region` VALUES ('23192', '睢阳区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23211', '民权县', '3', '23170', 'M');
INSERT INTO `ey_region` VALUES ('23232', '睢县', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23253', '宁陵县', '3', '23170', 'N');
INSERT INTO `ey_region` VALUES ('23268', '柘城县', '3', '23170', 'Z');
INSERT INTO `ey_region` VALUES ('23290', '虞城县', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23317', '夏邑县', '3', '23170', 'X');
INSERT INTO `ey_region` VALUES ('23342', '永城市', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23372', '信阳市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('23373', '市辖区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23374', '浉河区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23393', '平桥区', '3', '23372', 'P');
INSERT INTO `ey_region` VALUES ('23414', '罗山县', '3', '23372', 'L');
INSERT INTO `ey_region` VALUES ('23435', '光山县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23455', '新县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23471', '商城县', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23492', '固始县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23525', '潢川县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23549', '淮滨县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23567', '息县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23589', '周口市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23590', '市辖区', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23591', '川汇区', '3', '23589', 'C');
INSERT INTO `ey_region` VALUES ('23604', '扶沟县', '3', '23589', 'F');
INSERT INTO `ey_region` VALUES ('23621', '西华县', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23647', '商水县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23672', '沈丘县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23695', '郸城县', '3', '23589', 'D');
INSERT INTO `ey_region` VALUES ('23716', '淮阳县', '3', '23589', 'H');
INSERT INTO `ey_region` VALUES ('23736', '太康县', '3', '23589', 'T');
INSERT INTO `ey_region` VALUES ('23766', '鹿邑县', '3', '23589', 'L');
INSERT INTO `ey_region` VALUES ('23796', '项城市', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23818', '驻马店市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23819', '市辖区', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23820', '驿城区', '3', '23818', 'Y');
INSERT INTO `ey_region` VALUES ('23840', '西平县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('23861', '上蔡县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23886', '平舆县', '3', '23818', 'P');
INSERT INTO `ey_region` VALUES ('23905', '正阳县', '3', '23818', 'Z');
INSERT INTO `ey_region` VALUES ('23926', '确山县', '3', '23818', 'Q');
INSERT INTO `ey_region` VALUES ('23940', '泌阳县', '3', '23818', 'M');
INSERT INTO `ey_region` VALUES ('23965', '汝南县', '3', '23818', 'R');
INSERT INTO `ey_region` VALUES ('23983', '遂平县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23999', '新蔡县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('24022', '湖北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('24023', '武汉市', '2', '24022', 'W');
INSERT INTO `ey_region` VALUES ('24024', '市辖区', '3', '24023', 'S');
INSERT INTO `ey_region` VALUES ('24025', '江岸区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24043', '江汉区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24057', '硚口区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24069', '汉阳区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24082', '武昌区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24098', '青山区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24111', '洪山区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24129', '东西湖区', '3', '24023', 'D');
INSERT INTO `ey_region` VALUES ('24142', '汉南区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24150', '蔡甸区', '3', '24023', 'C');
INSERT INTO `ey_region` VALUES ('24165', '江夏区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24185', '黄陂区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24205', '武汉市新洲区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24224', '黄石市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('24225', '市辖区', '3', '24224', 'S');
INSERT INTO `ey_region` VALUES ('24226', '黄石港区', '3', '24224', 'H');
INSERT INTO `ey_region` VALUES ('24233', '西塞山区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24242', '下陆区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24247', '铁山区', '3', '24224', 'T');
INSERT INTO `ey_region` VALUES ('24250', '阳新县', '3', '24224', 'Y');
INSERT INTO `ey_region` VALUES ('24273', '大冶市', '3', '24224', 'D');
INSERT INTO `ey_region` VALUES ('24291', '十堰市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('24292', '市辖区', '3', '24291', 'S');
INSERT INTO `ey_region` VALUES ('24293', '茅箭区', '3', '24291', 'M');
INSERT INTO `ey_region` VALUES ('24302', '张湾区', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24314', '郧县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24335', '郧西县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24354', '竹山县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24374', '竹溪县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24405', '房县', '3', '24291', 'F');
INSERT INTO `ey_region` VALUES ('24435', '丹江口市', '3', '24291', 'D');
INSERT INTO `ey_region` VALUES ('24453', '宜昌市', '2', '24022', 'Y');
INSERT INTO `ey_region` VALUES ('24454', '市辖区', '3', '24453', 'S');
INSERT INTO `ey_region` VALUES ('24455', '西陵区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24465', '伍家岗区', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24471', '点军区', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24477', '猇亭区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24481', '夷陵区', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24495', '远安县', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24503', '兴山县', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24512', '秭归县', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24525', '长阳县', '3', '24453', 'C');
INSERT INTO `ey_region` VALUES ('24537', '五峰县', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24546', '宜都市', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24559', '当阳市', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24570', '枝江市', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24580', '襄樊市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24581', '市辖区', '3', '24580', 'S');
INSERT INTO `ey_region` VALUES ('24582', '襄城区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24591', '樊城区', '3', '24580', 'F');
INSERT INTO `ey_region` VALUES ('24608', '襄阳区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24623', '南漳县', '3', '24580', 'N');
INSERT INTO `ey_region` VALUES ('24635', '谷城县', '3', '24580', 'G');
INSERT INTO `ey_region` VALUES ('24647', '保康县', '3', '24580', 'B');
INSERT INTO `ey_region` VALUES ('24659', '老河口市', '3', '24580', 'L');
INSERT INTO `ey_region` VALUES ('24674', '枣阳市', '3', '24580', 'Z');
INSERT INTO `ey_region` VALUES ('24692', '宜城市', '3', '24580', 'Y');
INSERT INTO `ey_region` VALUES ('24706', '鄂州市', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('24707', '市辖区', '3', '24706', 'S');
INSERT INTO `ey_region` VALUES ('24708', '粱子湖区', '3', '24706', 'L');
INSERT INTO `ey_region` VALUES ('24714', '华容区', '3', '24706', 'H');
INSERT INTO `ey_region` VALUES ('24722', '鄂城区', '3', '24706', 'E');
INSERT INTO `ey_region` VALUES ('24737', '荆门市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24738', '市辖区', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24739', '东宝区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24749', '掇刀区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24755', '京山县', '3', '24737', 'J');
INSERT INTO `ey_region` VALUES ('24778', '沙洋县', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24794', '钟祥市', '3', '24737', 'Z');
INSERT INTO `ey_region` VALUES ('24816', '孝感市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24817', '市辖区', '3', '24816', 'S');
INSERT INTO `ey_region` VALUES ('24818', '孝南区', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24838', '孝昌县', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24853', '大悟县', '3', '24816', 'D');
INSERT INTO `ey_region` VALUES ('24871', '云梦县', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24885', '应城市', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24903', '安陆市', '3', '24816', 'A');
INSERT INTO `ey_region` VALUES ('24920', '汉川市', '3', '24816', 'H');
INSERT INTO `ey_region` VALUES ('24949', '荆州市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24950', '市辖区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24951', '沙市区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24965', '荆州区', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('24978', '公安县', '3', '24949', 'G');
INSERT INTO `ey_region` VALUES ('24995', '监利县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25019', '江陵县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25032', '石首市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25048', '洪湖市', '3', '24949', 'H');
INSERT INTO `ey_region` VALUES ('25069', '松滋市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25086', '黄冈市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('25087', '市辖区', '3', '25086', 'S');
INSERT INTO `ey_region` VALUES ('25088', '黄州区', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25099', '团风县', '3', '25086', 'T');
INSERT INTO `ey_region` VALUES ('25112', '红安县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25126', '罗田县', '3', '25086', 'L');
INSERT INTO `ey_region` VALUES ('25143', '英山县', '3', '25086', 'Y');
INSERT INTO `ey_region` VALUES ('25158', '浠水县', '3', '25086', 'X');
INSERT INTO `ey_region` VALUES ('25175', '蕲春县', '3', '25086', 'Q');
INSERT INTO `ey_region` VALUES ('25192', '黄梅县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25211', '麻城市', '3', '25086', 'M');
INSERT INTO `ey_region` VALUES ('25235', '武穴市', '3', '25086', 'W');
INSERT INTO `ey_region` VALUES ('25249', '咸宁市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('25250', '市辖区', '3', '25249', 'S');
INSERT INTO `ey_region` VALUES ('25251', '咸安区', '3', '25249', 'X');
INSERT INTO `ey_region` VALUES ('25266', '嘉鱼县', '3', '25249', 'J');
INSERT INTO `ey_region` VALUES ('25276', '通城县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25290', '崇阳县', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25303', '通山县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25317', '赤壁市', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25335', '随州市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25336', '市辖区', '3', '25335', 'S');
INSERT INTO `ey_region` VALUES ('25337', '曾都区', '3', '25335', 'Z');
INSERT INTO `ey_region` VALUES ('25367', '广水市', '3', '25335', 'G');
INSERT INTO `ey_region` VALUES ('25388', '恩施州', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('25389', '恩施市', '3', '25388', 'E');
INSERT INTO `ey_region` VALUES ('25406', '利川市', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25422', '建始县', '3', '25388', 'J');
INSERT INTO `ey_region` VALUES ('25433', '巴东县', '3', '25388', 'B');
INSERT INTO `ey_region` VALUES ('25446', '宣恩县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25456', '咸丰县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25467', '来凤县', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25476', '鹤峰县', '3', '25388', 'H');
INSERT INTO `ey_region` VALUES ('25487', '省直辖行政单位', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25488', '仙桃市', '3', '25487', 'X');
INSERT INTO `ey_region` VALUES ('25516', '潜江市', '3', '25487', 'Q');
INSERT INTO `ey_region` VALUES ('25541', '天门市', '3', '25487', 'T');
INSERT INTO `ey_region` VALUES ('25570', '神农架林区', '3', '25487', 'S');
INSERT INTO `ey_region` VALUES ('25579', '湖南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('25580', '长沙市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('25581', '市辖区', '3', '25580', 'S');
INSERT INTO `ey_region` VALUES ('25582', '芙蓉区', '3', '25580', 'F');
INSERT INTO `ey_region` VALUES ('25596', '天心区', '3', '25580', 'T');
INSERT INTO `ey_region` VALUES ('25607', '岳麓区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25620', '开福区', '3', '25580', 'K');
INSERT INTO `ey_region` VALUES ('25634', '雨花区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25645', '长沙县', '3', '25580', 'C');
INSERT INTO `ey_region` VALUES ('25666', '望城县', '3', '25580', 'W');
INSERT INTO `ey_region` VALUES ('25686', '宁乡县', '3', '25580', 'N');
INSERT INTO `ey_region` VALUES ('25720', '浏阳市', '3', '25580', 'L');
INSERT INTO `ey_region` VALUES ('25758', '株洲市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('25759', '市辖区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25760', '荷塘区', '3', '25758', 'H');
INSERT INTO `ey_region` VALUES ('25768', '芦淞区', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25777', '石峰区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25785', '天元区', '3', '25758', 'T');
INSERT INTO `ey_region` VALUES ('25791', '株洲县', '3', '25758', 'Z');
INSERT INTO `ey_region` VALUES ('25810', '攸县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25836', '茶陵县', '3', '25758', 'C');
INSERT INTO `ey_region` VALUES ('25863', '炎陵县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25881', '醴陵市', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25912', '湘潭市', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('25913', '市辖区', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('25914', '雨湖区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25929', '岳塘区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25947', '湘潭县', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25970', '湘乡市', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25993', '韶山市', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('26001', '衡阳市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('26002', '市辖区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26003', '珠晖区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26019', '雁峰区', '3', '26001', 'Y');
INSERT INTO `ey_region` VALUES ('26028', '石鼓区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26037', '蒸湘区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26045', '南岳区', '3', '26001', 'N');
INSERT INTO `ey_region` VALUES ('26051', '衡阳县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26080', '衡南县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26112', '衡山县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26130', '衡东县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26155', '祁东县', '3', '26001', 'Q');
INSERT INTO `ey_region` VALUES ('26179', '耒阳市', '3', '26001', 'L');
INSERT INTO `ey_region` VALUES ('26215', '常宁市', '3', '26001', 'C');
INSERT INTO `ey_region` VALUES ('26242', '邵阳市', '2', '25579', 'S');
INSERT INTO `ey_region` VALUES ('26243', '市辖区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26244', '双清区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26257', '大祥区', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26272', '北塔区', '3', '26242', 'B');
INSERT INTO `ey_region` VALUES ('26279', '邵东县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26306', '新邵县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26322', '邵阳县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26348', '隆回县', '3', '26242', 'L');
INSERT INTO `ey_region` VALUES ('26375', '洞口县', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26399', '绥宁县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26425', '新宁县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26444', '城步县', '3', '26242', 'C');
INSERT INTO `ey_region` VALUES ('26465', '武冈市', '3', '26242', 'W');
INSERT INTO `ey_region` VALUES ('26485', '岳阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('26486', '市辖区', '3', '26485', 'S');
INSERT INTO `ey_region` VALUES ('26487', '岳阳楼区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26511', '云溪区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26521', '君山区', '3', '26485', 'J');
INSERT INTO `ey_region` VALUES ('26529', '岳阳县', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26551', '华容县', '3', '26485', 'H');
INSERT INTO `ey_region` VALUES ('26572', '湘阴县', '3', '26485', 'X');
INSERT INTO `ey_region` VALUES ('26592', '平江县', '3', '26485', 'P');
INSERT INTO `ey_region` VALUES ('26620', '汩罗市', '3', '26485', 'G');
INSERT INTO `ey_region` VALUES ('26657', '临湘市', '3', '26485', 'L');
INSERT INTO `ey_region` VALUES ('26683', '常德市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('26684', '市辖区', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26685', '武陵区', '3', '26683', 'W');
INSERT INTO `ey_region` VALUES ('26702', '鼎城区', '3', '26683', 'D');
INSERT INTO `ey_region` VALUES ('26741', '安乡县', '3', '26683', 'A');
INSERT INTO `ey_region` VALUES ('26762', '汉寿县', '3', '26683', 'H');
INSERT INTO `ey_region` VALUES ('26793', '澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26826', '临澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26844', '桃源县', '3', '26683', 'T');
INSERT INTO `ey_region` VALUES ('26885', '石门县', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26912', '津市市', '3', '26683', 'J');
INSERT INTO `ey_region` VALUES ('26925', '张家界市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('26926', '市辖区', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('26927', '永定区', '3', '26925', 'Y');
INSERT INTO `ey_region` VALUES ('26959', '武陵源区', '3', '26925', 'W');
INSERT INTO `ey_region` VALUES ('26966', '慈利县', '3', '26925', 'C');
INSERT INTO `ey_region` VALUES ('26998', '桑植县', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('27038', '益阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27039', '市辖区', '3', '27038', 'S');
INSERT INTO `ey_region` VALUES ('27040', '资阳区', '3', '27038', 'Z');
INSERT INTO `ey_region` VALUES ('27049', '赫山区', '3', '27038', 'H');
INSERT INTO `ey_region` VALUES ('27069', '南县', '3', '27038', 'N');
INSERT INTO `ey_region` VALUES ('27087', '桃江县', '3', '27038', 'T');
INSERT INTO `ey_region` VALUES ('27106', '安化县', '3', '27038', 'A');
INSERT INTO `ey_region` VALUES ('27130', '沅江市', '3', '27038', 'Y');
INSERT INTO `ey_region` VALUES ('27147', '郴州市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('27148', '市辖区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27149', '北湖区', '3', '27147', 'B');
INSERT INTO `ey_region` VALUES ('27168', '苏仙区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27188', '桂阳县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27228', '宜章县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27256', '永兴县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27282', '嘉禾县', '3', '27147', 'J');
INSERT INTO `ey_region` VALUES ('27300', '临武县', '3', '27147', 'L');
INSERT INTO `ey_region` VALUES ('27323', '汝城县', '3', '27147', 'R');
INSERT INTO `ey_region` VALUES ('27347', '桂东县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27367', '安仁县', '3', '27147', 'A');
INSERT INTO `ey_region` VALUES ('27389', '资兴市', '3', '27147', 'Z');
INSERT INTO `ey_region` VALUES ('27418', '永州市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27419', '市辖区', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27420', '零陵区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27437', '冷水滩区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27459', '祁阳县', '3', '27418', 'Q');
INSERT INTO `ey_region` VALUES ('27492', '东安县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27511', '双牌县', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27527', '道县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27554', '江永县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27567', '宁远县', '3', '27418', 'N');
INSERT INTO `ey_region` VALUES ('27585', '蓝山县', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27606', '新田县', '3', '27418', 'X');
INSERT INTO `ey_region` VALUES ('27626', '江华县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27650', '怀化市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('27651', '市辖区', '3', '27650', 'S');
INSERT INTO `ey_region` VALUES ('27652', '鹤城区', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27667', '中方县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27690', '沅陵县', '3', '27650', 'Y');
INSERT INTO `ey_region` VALUES ('27714', '辰溪县', '3', '27650', 'C');
INSERT INTO `ey_region` VALUES ('27745', '溆浦县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27789', '会同县', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27815', '麻阳县', '3', '27650', 'M');
INSERT INTO `ey_region` VALUES ('27839', '新晃县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27863', '芷江县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27892', '靖州苗族侗族县', '3', '27650', 'J');
INSERT INTO `ey_region` VALUES ('27906', '通道县', '3', '27650', 'T');
INSERT INTO `ey_region` VALUES ('27930', '洪江市', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27963', '娄底市', '2', '25579', 'L');
INSERT INTO `ey_region` VALUES ('27964', '市辖区', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27965', '娄星区', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('27980', '双峰县', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27997', '新化县', '3', '27963', 'X');
INSERT INTO `ey_region` VALUES ('28027', '冷水江市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28044', '涟源市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28065', '湘西州', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('28066', '吉首市', '3', '28065', 'J');
INSERT INTO `ey_region` VALUES ('28082', '泸溪县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28099', '凤凰县', '3', '28065', 'F');
INSERT INTO `ey_region` VALUES ('28124', '花垣县', '3', '28065', 'H');
INSERT INTO `ey_region` VALUES ('28143', '保靖县', '3', '28065', 'B');
INSERT INTO `ey_region` VALUES ('28161', '古丈县', '3', '28065', 'G');
INSERT INTO `ey_region` VALUES ('28174', '永顺县', '3', '28065', 'Y');
INSERT INTO `ey_region` VALUES ('28205', '龙山县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28240', '广东省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('28241', '广州市', '2', '28240', 'G');
INSERT INTO `ey_region` VALUES ('28242', '市辖区', '3', '28241', 'S');
INSERT INTO `ey_region` VALUES ('28243', '荔湾区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28266', '越秀区', '3', '28241', 'Y');
INSERT INTO `ey_region` VALUES ('28289', '海珠区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28308', '天河区', '3', '28241', 'T');
INSERT INTO `ey_region` VALUES ('28330', '白云区', '3', '28241', 'B');
INSERT INTO `ey_region` VALUES ('28349', '黄埔区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28359', '番禺区', '3', '28241', 'F');
INSERT INTO `ey_region` VALUES ('28377', '花都区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28386', '南沙区', '3', '28241', 'N');
INSERT INTO `ey_region` VALUES ('28392', '萝岗区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28399', '增城市', '3', '28241', 'Z');
INSERT INTO `ey_region` VALUES ('28409', '从化市', '3', '28241', 'C');
INSERT INTO `ey_region` VALUES ('28421', '韶关市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28422', '市辖区', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28423', '武江区', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28431', '浈江区', '3', '28421', 'Z');
INSERT INTO `ey_region` VALUES ('28448', '曲江区', '3', '28421', 'Q');
INSERT INTO `ey_region` VALUES ('28463', '始兴县', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28475', '仁化县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28488', '翁源县', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28497', '乳源县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28509', '新丰县', '3', '28421', 'X');
INSERT INTO `ey_region` VALUES ('28517', '乐昌市', '3', '28421', 'L');
INSERT INTO `ey_region` VALUES ('28539', '南雄市', '3', '28421', 'N');
INSERT INTO `ey_region` VALUES ('28558', '深圳市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28559', '市辖区', '3', '28558', 'S');
INSERT INTO `ey_region` VALUES ('28560', '罗湖区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28571', '福田区', '3', '28558', 'F');
INSERT INTO `ey_region` VALUES ('28581', '南山区', '3', '28558', 'N');
INSERT INTO `ey_region` VALUES ('28590', '宝安区', '3', '28558', 'B');
INSERT INTO `ey_region` VALUES ('28604', '龙岗区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28619', '盐田区', '3', '28558', 'Y');
INSERT INTO `ey_region` VALUES ('28626', '珠海市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28627', '市辖区', '3', '28626', 'S');
INSERT INTO `ey_region` VALUES ('28628', '香洲区', '3', '28626', 'X');
INSERT INTO `ey_region` VALUES ('28646', '斗门区', '3', '28626', 'D');
INSERT INTO `ey_region` VALUES ('28654', '金湾区', '3', '28626', 'J');
INSERT INTO `ey_region` VALUES ('28659', '汕头市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28660', '市辖区', '3', '28659', 'S');
INSERT INTO `ey_region` VALUES ('28661', '龙湖区', '3', '28659', 'L');
INSERT INTO `ey_region` VALUES ('28669', '金平区', '3', '28659', 'J');
INSERT INTO `ey_region` VALUES ('28687', '濠江区', '3', '28659', 'H');
INSERT INTO `ey_region` VALUES ('28695', '潮阳区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28709', '潮南区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28721', '澄海区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28733', '南澳县', '3', '28659', 'N');
INSERT INTO `ey_region` VALUES ('28737', '佛山市', '2', '28240', 'F');
INSERT INTO `ey_region` VALUES ('28738', '市辖区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28739', '禅城区', '3', '28737', 'C');
INSERT INTO `ey_region` VALUES ('28744', '南海区', '3', '28737', 'N');
INSERT INTO `ey_region` VALUES ('28753', '顺德区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28764', '三水区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28776', '高明区', '3', '28737', 'G');
INSERT INTO `ey_region` VALUES ('28785', '江门市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('28786', '市辖区', '3', '28785', 'S');
INSERT INTO `ey_region` VALUES ('28787', '蓬江区', '3', '28785', 'P');
INSERT INTO `ey_region` VALUES ('28797', '江海区', '3', '28785', 'J');
INSERT INTO `ey_region` VALUES ('28803', '新会区', '3', '28785', 'X');
INSERT INTO `ey_region` VALUES ('28818', '台山市', '3', '28785', 'T');
INSERT INTO `ey_region` VALUES ('28837', '开平市', '3', '28785', 'K');
INSERT INTO `ey_region` VALUES ('28853', '鹤山市', '3', '28785', 'H');
INSERT INTO `ey_region` VALUES ('28867', '恩平市', '3', '28785', 'E');
INSERT INTO `ey_region` VALUES ('28880', '湛江市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28881', '市辖区', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28882', '湛江市赤坎区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28891', '湛江市霞山区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28904', '湛江市坡头区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28914', '湛江市麻章区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28923', '遂溪县', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28941', '徐闻县', '3', '28880', 'X');
INSERT INTO `ey_region` VALUES ('28962', '廉江市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('28984', '雷州市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('29010', '吴川市', '3', '28880', 'W');
INSERT INTO `ey_region` VALUES ('29026', '茂名市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29027', '市辖区', '3', '29026', 'S');
INSERT INTO `ey_region` VALUES ('29028', '茂南区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29045', '茂港区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29053', '电白县', '3', '29026', 'D');
INSERT INTO `ey_region` VALUES ('29075', '高州市', '3', '29026', 'G');
INSERT INTO `ey_region` VALUES ('29107', '化州市', '3', '29026', 'H');
INSERT INTO `ey_region` VALUES ('29138', '信宜市', '3', '29026', 'X');
INSERT INTO `ey_region` VALUES ('29159', '肇庆市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29160', '市辖区', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29161', '端州区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29169', '鼎湖区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29178', '广宁县', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29196', '怀集县', '3', '29159', 'H');
INSERT INTO `ey_region` VALUES ('29217', '封开县', '3', '29159', 'F');
INSERT INTO `ey_region` VALUES ('29234', '德庆县', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29248', '高要市', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29266', '四会市', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29282', '惠州市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29283', '市辖区', '3', '29282', 'S');
INSERT INTO `ey_region` VALUES ('29284', '惠城区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29304', '惠阳区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29317', '博罗县', '3', '29282', 'B');
INSERT INTO `ey_region` VALUES ('29335', '惠东县', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29355', '龙门县', '3', '29282', 'L');
INSERT INTO `ey_region` VALUES ('29371', '梅州市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29372', '市辖区', '3', '29371', 'S');
INSERT INTO `ey_region` VALUES ('29373', '梅江区', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29380', '梅县', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29400', '大埔县', '3', '29371', 'D');
INSERT INTO `ey_region` VALUES ('29418', '丰顺县', '3', '29371', 'F');
INSERT INTO `ey_region` VALUES ('29436', '五华县', '3', '29371', 'W');
INSERT INTO `ey_region` VALUES ('29453', '平远县', '3', '29371', 'P');
INSERT INTO `ey_region` VALUES ('29466', '蕉岭县', '3', '29371', 'J');
INSERT INTO `ey_region` VALUES ('29477', '兴宁市', '3', '29371', 'X');
INSERT INTO `ey_region` VALUES ('29498', '汕尾市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('29499', '市辖区', '3', '29498', 'S');
INSERT INTO `ey_region` VALUES ('29500', '城区', '3', '29498', 'C');
INSERT INTO `ey_region` VALUES ('29511', '海丰县', '3', '29498', 'H');
INSERT INTO `ey_region` VALUES ('29529', '陆河县', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29538', '陆丰市', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29568', '河源市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29569', '市辖区', '3', '29568', 'S');
INSERT INTO `ey_region` VALUES ('29570', '源城区', '3', '29568', 'Y');
INSERT INTO `ey_region` VALUES ('29578', '紫金县', '3', '29568', 'Z');
INSERT INTO `ey_region` VALUES ('29599', '龙川县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29625', '连平县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29639', '和平县', '3', '29568', 'H');
INSERT INTO `ey_region` VALUES ('29657', '东源县', '3', '29568', 'D');
INSERT INTO `ey_region` VALUES ('29679', '阳江市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('29680', '市辖区', '3', '29679', 'S');
INSERT INTO `ey_region` VALUES ('29681', '江城区', '3', '29679', 'J');
INSERT INTO `ey_region` VALUES ('29698', '阳西县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29709', '阳东县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29729', '阳春市', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29755', '清远市', '2', '28240', 'Q');
INSERT INTO `ey_region` VALUES ('29756', '市辖区', '3', '29755', 'S');
INSERT INTO `ey_region` VALUES ('29757', '清城区', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29766', '佛冈县', '3', '29755', 'F');
INSERT INTO `ey_region` VALUES ('29773', '阳山县', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29787', '连山县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29797', '连南县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29805', '清新县', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29816', '英德市', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29842', '连州市', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29855', '东莞市', '2', '28240', 'D');
INSERT INTO `ey_region` VALUES ('29890', '中山市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29915', '潮州市', '2', '28240', 'C');
INSERT INTO `ey_region` VALUES ('29916', '市辖区', '3', '29915', 'S');
INSERT INTO `ey_region` VALUES ('29917', '潮州市湘桥区', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29930', '潮州市潮安县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29954', '潮州市饶平县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29977', '揭阳市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('29978', '市辖区', '3', '29977', 'S');
INSERT INTO `ey_region` VALUES ('29979', '榕城区', '3', '29977', 'R');
INSERT INTO `ey_region` VALUES ('29990', '揭东县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30008', '揭西县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30032', '惠来县', '3', '29977', 'H');
INSERT INTO `ey_region` VALUES ('30054', '普宁市', '3', '29977', 'P');
INSERT INTO `ey_region` VALUES ('30086', '云浮市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('30087', '市辖区', '3', '30086', 'S');
INSERT INTO `ey_region` VALUES ('30088', '云城区', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30096', '新兴县', '3', '30086', 'X');
INSERT INTO `ey_region` VALUES ('30112', '郁南县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30132', '云安县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30141', '罗定市', '3', '30086', 'L');
INSERT INTO `ey_region` VALUES ('30164', '广西壮族自治区', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('30165', '南宁市', '2', '30164', 'N');
INSERT INTO `ey_region` VALUES ('30166', '市辖区', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30167', '兴宁区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30174', '青秀区', '3', '30165', 'Q');
INSERT INTO `ey_region` VALUES ('30186', '江南区', '3', '30165', 'J');
INSERT INTO `ey_region` VALUES ('30196', '西乡塘区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30214', '良庆区', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30222', '邕宁区', '3', '30165', 'Y');
INSERT INTO `ey_region` VALUES ('30228', '武鸣县', '3', '30165', 'W');
INSERT INTO `ey_region` VALUES ('30245', '隆安县', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30257', '马山县', '3', '30165', 'M');
INSERT INTO `ey_region` VALUES ('30270', '上林县', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30282', '宾阳县', '3', '30165', 'B');
INSERT INTO `ey_region` VALUES ('30300', '横县', '3', '30165', 'H');
INSERT INTO `ey_region` VALUES ('30319', '柳州市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('30320', '市辖区', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30321', '城中区', '3', '30319', 'C');
INSERT INTO `ey_region` VALUES ('30329', '鱼峰区', '3', '30319', 'Y');
INSERT INTO `ey_region` VALUES ('30338', '柳南区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30348', '柳北区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30361', '柳江县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30374', '柳城县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30387', '鹿寨县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30398', '融安县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30411', '融水县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30432', '三江县', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30448', '桂林市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30449', '市辖区', '3', '30448', 'S');
INSERT INTO `ey_region` VALUES ('30450', '秀峰区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30454', '叠彩区', '3', '30448', 'D');
INSERT INTO `ey_region` VALUES ('30458', '象山区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30463', '七星区', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30469', '雁山区', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30475', '阳朔县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30485', '临桂县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30497', '灵川县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30509', '全州县', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30528', '兴安县', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30539', '永福县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30549', '灌阳县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30559', '龙胜县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30570', '资源县', '3', '30448', 'Z');
INSERT INTO `ey_region` VALUES ('30578', '平乐县', '3', '30448', 'P');
INSERT INTO `ey_region` VALUES ('30589', '荔浦县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30603', '恭城县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30613', '梧州市', '2', '30164', 'W');
INSERT INTO `ey_region` VALUES ('30614', '市辖区', '3', '30613', 'S');
INSERT INTO `ey_region` VALUES ('30615', '万秀区', '3', '30613', 'W');
INSERT INTO `ey_region` VALUES ('30622', '蝶山区', '3', '30613', 'D');
INSERT INTO `ey_region` VALUES ('30628', '长洲区', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30633', '苍梧县', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30646', '藤县', '3', '30613', 'T');
INSERT INTO `ey_region` VALUES ('30663', '蒙山县', '3', '30613', 'M');
INSERT INTO `ey_region` VALUES ('30673', '岑溪市', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30688', '北海市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('30689', '市辖区', '3', '30688', 'S');
INSERT INTO `ey_region` VALUES ('30690', '海城区', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30699', '银海区', '3', '30688', 'Y');
INSERT INTO `ey_region` VALUES ('30704', '铁山港区', '3', '30688', 'T');
INSERT INTO `ey_region` VALUES ('30708', '合浦县', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30724', '防城港市', '2', '30164', 'F');
INSERT INTO `ey_region` VALUES ('30725', '市辖区', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30726', '港口区', '3', '30724', 'G');
INSERT INTO `ey_region` VALUES ('30732', '防城区', '3', '30724', 'F');
INSERT INTO `ey_region` VALUES ('30748', '上思县', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30758', '东兴市', '3', '30724', 'D');
INSERT INTO `ey_region` VALUES ('30762', '钦州市', '2', '30164', 'Q');
INSERT INTO `ey_region` VALUES ('30763', '市辖区', '3', '30762', 'S');
INSERT INTO `ey_region` VALUES ('30764', '钦南区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30783', '钦北区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30796', '灵山县', '3', '30762', 'L');
INSERT INTO `ey_region` VALUES ('30817', '浦北县', '3', '30762', 'P');
INSERT INTO `ey_region` VALUES ('30834', '贵港市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30835', '市辖区', '3', '30834', 'S');
INSERT INTO `ey_region` VALUES ('30836', '港北区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30845', '港南区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30855', '覃塘区', '3', '30834', 'Q');
INSERT INTO `ey_region` VALUES ('30866', '平南县', '3', '30834', 'P');
INSERT INTO `ey_region` VALUES ('30888', '桂平市', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30915', '玉林市', '2', '30164', 'Y');
INSERT INTO `ey_region` VALUES ('30916', '市辖区', '3', '30915', 'S');
INSERT INTO `ey_region` VALUES ('30917', '玉州区', '3', '30915', 'Y');
INSERT INTO `ey_region` VALUES ('30933', '容县', '3', '30915', 'R');
INSERT INTO `ey_region` VALUES ('30949', '陆川县', '3', '30915', 'L');
INSERT INTO `ey_region` VALUES ('30964', '博白县', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('30993', '兴业县', '3', '30915', 'X');
INSERT INTO `ey_region` VALUES ('31007', '北流市', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('31033', '百色市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('31034', '市辖区', '3', '31033', 'S');
INSERT INTO `ey_region` VALUES ('31035', '右江区', '3', '31033', 'Y');
INSERT INTO `ey_region` VALUES ('31045', '田阳县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31056', '田东县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31067', '平果县', '3', '31033', 'P');
INSERT INTO `ey_region` VALUES ('31081', '德保县', '3', '31033', 'D');
INSERT INTO `ey_region` VALUES ('31095', '靖西县', '3', '31033', 'J');
INSERT INTO `ey_region` VALUES ('31115', '那坡县', '3', '31033', 'N');
INSERT INTO `ey_region` VALUES ('31125', '凌云县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31134', '乐业县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31143', '田林县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31158', '西林县', '3', '31033', 'X');
INSERT INTO `ey_region` VALUES ('31167', '隆林县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31184', '贺州市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31185', '市辖区', '3', '31184', 'S');
INSERT INTO `ey_region` VALUES ('31186', '八步区', '3', '31184', 'B');
INSERT INTO `ey_region` VALUES ('31208', '昭平县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31221', '钟山县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31236', '富川县', '3', '31184', 'F');
INSERT INTO `ey_region` VALUES ('31249', '河池市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31250', '市辖区', '3', '31249', 'S');
INSERT INTO `ey_region` VALUES ('31251', '金城江区', '3', '31249', 'J');
INSERT INTO `ey_region` VALUES ('31264', '南丹县', '3', '31249', 'N');
INSERT INTO `ey_region` VALUES ('31276', '天峨县', '3', '31249', 'T');
INSERT INTO `ey_region` VALUES ('31286', '凤山县', '3', '31249', 'F');
INSERT INTO `ey_region` VALUES ('31296', '东兰县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31311', '罗城县', '3', '31249', 'L');
INSERT INTO `ey_region` VALUES ('31323', '环江县', '3', '31249', 'H');
INSERT INTO `ey_region` VALUES ('31336', '巴马县', '3', '31249', 'B');
INSERT INTO `ey_region` VALUES ('31347', '都安县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31367', '大化县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31384', '宜州市', '3', '31249', 'Y');
INSERT INTO `ey_region` VALUES ('31401', '来宾市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('31402', '市辖区', '3', '31401', 'S');
INSERT INTO `ey_region` VALUES ('31403', '兴宾区', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31427', '忻城县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31440', '象州县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31452', '武宣县', '3', '31401', 'W');
INSERT INTO `ey_region` VALUES ('31463', '金秀县', '3', '31401', 'J');
INSERT INTO `ey_region` VALUES ('31474', '合山市', '3', '31401', 'H');
INSERT INTO `ey_region` VALUES ('31478', '崇左市', '2', '30164', 'C');
INSERT INTO `ey_region` VALUES ('31479', '市辖区', '3', '31478', 'S');
INSERT INTO `ey_region` VALUES ('31480', '江州区', '3', '31478', 'J');
INSERT INTO `ey_region` VALUES ('31490', '扶绥县', '3', '31478', 'F');
INSERT INTO `ey_region` VALUES ('31502', '宁明县', '3', '31478', 'N');
INSERT INTO `ey_region` VALUES ('31516', '龙州县', '3', '31478', 'L');
INSERT INTO `ey_region` VALUES ('31529', '大新县', '3', '31478', 'D');
INSERT INTO `ey_region` VALUES ('31544', '天等县', '3', '31478', 'T');
INSERT INTO `ey_region` VALUES ('31558', '凭祥市', '3', '31478', 'P');
INSERT INTO `ey_region` VALUES ('31563', '海南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('31564', '海口市', '2', '31563', 'H');
INSERT INTO `ey_region` VALUES ('31565', '市辖区', '3', '31564', 'S');
INSERT INTO `ey_region` VALUES ('31566', '秀英区', '3', '31564', 'X');
INSERT INTO `ey_region` VALUES ('31575', '龙华区', '3', '31564', 'L');
INSERT INTO `ey_region` VALUES ('31587', '琼山区', '3', '31564', 'Q');
INSERT INTO `ey_region` VALUES ('31601', '美兰区', '3', '31564', 'M');
INSERT INTO `ey_region` VALUES ('31618', '三亚市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('47967', '海棠区', '3', '31618', 'H');
INSERT INTO `ey_region` VALUES ('31634', '五指山市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31635', '冲山镇', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31636', '南圣镇', '3', '31634', 'N');
INSERT INTO `ey_region` VALUES ('31637', '毛阳镇', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31638', '番阳镇', '3', '31634', 'F');
INSERT INTO `ey_region` VALUES ('31639', '畅好乡', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31640', '毛道乡', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31641', '水满乡', '3', '31634', 'S');
INSERT INTO `ey_region` VALUES ('31642', '国营畅好农场', '3', '31634', 'G');
INSERT INTO `ey_region` VALUES ('31643', '琼海市', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31644', '嘉积镇', '3', '31643', 'J');
INSERT INTO `ey_region` VALUES ('31645', '万泉镇', '3', '31643', 'W');
INSERT INTO `ey_region` VALUES ('31646', '石壁镇', '3', '31643', 'S');
INSERT INTO `ey_region` VALUES ('31647', '中原镇', '3', '31643', 'Z');
INSERT INTO `ey_region` VALUES ('31648', '博敖镇', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31649', '阳江镇', '3', '31643', 'Y');
INSERT INTO `ey_region` VALUES ('31650', '龙江镇', '3', '31643', 'L');
INSERT INTO `ey_region` VALUES ('31651', '潭门镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31652', '塔洋镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31653', '长坡镇', '3', '31643', 'C');
INSERT INTO `ey_region` VALUES ('31654', '大路镇', '3', '31643', 'D');
INSERT INTO `ey_region` VALUES ('31655', '会山镇', '3', '31643', 'H');
INSERT INTO `ey_region` VALUES ('31656', '国营东太农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31657', '国营东平农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31658', '国营东红农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31659', '国营东升农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31660', '国营南俸农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31661', '彬村山华侨农场', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31662', '儋州市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31663', '那大镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31664', '和庆镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31665', '南丰镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31666', '大成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31667', '雅星镇', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31668', '兰洋镇', '3', '31662', 'L');
INSERT INTO `ey_region` VALUES ('31669', '光村镇', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31670', '木棠镇', '3', '31662', 'M');
INSERT INTO `ey_region` VALUES ('31671', '海头镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31672', '峨蔓镇', '3', '31662', 'E');
INSERT INTO `ey_region` VALUES ('31673', '三都镇', '3', '31662', 'S');
INSERT INTO `ey_region` VALUES ('31674', '王五镇', '3', '31662', 'W');
INSERT INTO `ey_region` VALUES ('31675', '白马井镇', '3', '31662', 'B');
INSERT INTO `ey_region` VALUES ('31676', '中和镇', '3', '31662', 'Z');
INSERT INTO `ey_region` VALUES ('31677', '排浦镇', '3', '31662', 'P');
INSERT INTO `ey_region` VALUES ('31678', '东成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31679', '新州镇', '3', '31662', 'X');
INSERT INTO `ey_region` VALUES ('31680', '国营西培农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31681', '国营西华农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31682', '国营西庆农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31683', '国营西流农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31684', '国营西联农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31685', '国营蓝洋农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31686', '国营新盈农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31687', '国营八一农场东山分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31688', '国营八一农场金川分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31689', '国营八一农场长岭分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31690', '国营八一农场英岛分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31691', '国营八一农场春江分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31692', '国营八一农场强打管区', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31693', '国营龙山农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31694', '国营红岭农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31695', '洋浦经济开发区', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31696', '华南热作学院', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31697', '文昌市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31698', '文城镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31699', '重兴镇', '3', '31697', 'Z');
INSERT INTO `ey_region` VALUES ('31700', '蓬莱镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31701', '会文镇', '3', '31697', 'H');
INSERT INTO `ey_region` VALUES ('31702', '东路镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31703', '潭牛镇', '3', '31697', 'T');
INSERT INTO `ey_region` VALUES ('31704', '东阁镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31705', '文教镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31706', '东郊镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31707', '龙楼镇', '3', '31697', 'L');
INSERT INTO `ey_region` VALUES ('31708', '昌洒镇', '3', '31697', 'C');
INSERT INTO `ey_region` VALUES ('31709', '翁田镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31710', '抱罗镇', '3', '31697', 'B');
INSERT INTO `ey_region` VALUES ('31711', '冯坡镇', '3', '31697', 'F');
INSERT INTO `ey_region` VALUES ('31712', '锦山镇', '3', '31697', 'J');
INSERT INTO `ey_region` VALUES ('31713', '铺前镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31714', '国营东路农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31715', '国营南阳农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31716', '国营罗豆农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31717', '国营文昌橡胶研究所', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31718', '万宁市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31719', '万城镇', '3', '31718', 'W');
INSERT INTO `ey_region` VALUES ('31720', '龙滚镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31721', '和乐镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31722', '后安镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31723', '大茂镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31724', '东澳镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31725', '礼纪镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31726', '长丰镇', '3', '31718', 'C');
INSERT INTO `ey_region` VALUES ('31727', '山根镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31728', '北大镇', '3', '31718', 'B');
INSERT INTO `ey_region` VALUES ('31729', '南桥镇', '3', '31718', 'N');
INSERT INTO `ey_region` VALUES ('31730', '三更罗镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31731', '国营东兴农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31732', '国营东和农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31733', '国营东岭农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31734', '国营南林农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31735', '国营新中农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31736', '兴隆华侨农场', '3', '31718', 'X');
INSERT INTO `ey_region` VALUES ('31737', '地方国营六连林场', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31738', '东方市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31739', '八所镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31740', '东河镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31741', '大田镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31742', '感城镇', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31743', '板桥镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31744', '三家镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31745', '四更镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31746', '新龙镇', '3', '31738', 'X');
INSERT INTO `ey_region` VALUES ('31747', '天安乡', '3', '31738', 'T');
INSERT INTO `ey_region` VALUES ('31748', '江边乡', '3', '31738', 'J');
INSERT INTO `ey_region` VALUES ('31749', '国营广坝农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31750', '国营公爱农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31751', '国营红泉农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31752', '省国营东方华侨农场', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31753', '定安县', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31754', '定城镇', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31755', '新竹镇', '3', '31753', 'X');
INSERT INTO `ey_region` VALUES ('31756', '龙湖镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31757', '黄竹镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31758', '雷鸣镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31759', '龙门镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31760', '龙河镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31761', '岭口镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31762', '翰林镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31763', '富文镇', '3', '31753', 'F');
INSERT INTO `ey_region` VALUES ('31764', '国营中瑞农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31765', '国营南海农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31766', '国营金鸡岭农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31767', '定安热作研究所', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31768', '屯昌县', '2', '31563', 'T');
INSERT INTO `ey_region` VALUES ('31769', '屯城镇', '3', '31768', 'T');
INSERT INTO `ey_region` VALUES ('31770', '新兴镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31771', '枫木镇', '3', '31768', 'F');
INSERT INTO `ey_region` VALUES ('31772', '乌坡镇', '3', '31768', 'W');
INSERT INTO `ey_region` VALUES ('31773', '南吕镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31774', '南坤镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31775', '坡心镇', '3', '31768', 'P');
INSERT INTO `ey_region` VALUES ('31776', '西昌镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31777', '国营中建农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31778', '国营中坤农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31779', '国营黄岭农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31780', '国营南吕农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31781', '国营广青农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31782', '国营晨星农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31783', '澄迈县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31784', '金江镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31785', '老城镇', '3', '31783', 'L');
INSERT INTO `ey_region` VALUES ('31786', '瑞溪镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31787', '永发镇', '3', '31783', 'Y');
INSERT INTO `ey_region` VALUES ('31788', '加乐镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31789', '文儒镇', '3', '31783', 'W');
INSERT INTO `ey_region` VALUES ('31790', '中兴镇', '3', '31783', 'Z');
INSERT INTO `ey_region` VALUES ('31791', '仁兴镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31792', '福山镇', '3', '31783', 'F');
INSERT INTO `ey_region` VALUES ('31793', '桥头镇', '3', '31783', 'Q');
INSERT INTO `ey_region` VALUES ('31794', '国营红光农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31795', '国营红岗农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31796', '国营西达农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31797', '国营昆仑农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31798', '国营和岭农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31799', '国营金安农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31800', '澄迈县华侨农场', '3', '31783', 'C');
INSERT INTO `ey_region` VALUES ('31801', '临高县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31802', '临城镇', '3', '31801', 'L');
INSERT INTO `ey_region` VALUES ('31803', '波莲镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31804', '东英镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31805', '博厚镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31806', '皇桐镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31807', '多文镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31808', '和舍镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31809', '南宝镇', '3', '31801', 'N');
INSERT INTO `ey_region` VALUES ('31810', '新盈镇', '3', '31801', 'X');
INSERT INTO `ey_region` VALUES ('31811', '调楼镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31812', '国营红华农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31813', '国营加来农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31814', '白沙县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31815', '牙叉镇', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31816', '七坊镇', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31817', '邦溪镇', '3', '31814', 'B');
INSERT INTO `ey_region` VALUES ('31818', '打安镇', '3', '31814', 'D');
INSERT INTO `ey_region` VALUES ('31819', '细水乡', '3', '31814', 'X');
INSERT INTO `ey_region` VALUES ('31820', '元门乡', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31821', '南开乡', '3', '31814', 'N');
INSERT INTO `ey_region` VALUES ('31822', '阜龙乡', '3', '31814', 'F');
INSERT INTO `ey_region` VALUES ('31823', '青松乡', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31824', '金波乡', '3', '31814', 'J');
INSERT INTO `ey_region` VALUES ('31825', '荣邦乡', '3', '31814', 'R');
INSERT INTO `ey_region` VALUES ('31826', '国营金波农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31827', '国营白沙农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31828', '国营牙叉农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31829', '国营卫星农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31830', '国营龙江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31831', '国营珠碧江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31832', '国营芙蓉田农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31833', '国营大岭农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31834', '国营邦溪农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31835', '昌江县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31836', '石碌镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31837', '叉河镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31838', '十月田镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31839', '乌烈镇', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31840', '昌化镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31841', '海尾镇', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31842', '七叉镇', '3', '31835', 'Q');
INSERT INTO `ey_region` VALUES ('31843', '王下乡', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31844', '国营红田农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31845', '国营红林农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31846', '国营坝王岭林场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31847', '海南钢铁公司', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31848', '乐东县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31849', '抱由镇', '3', '31848', 'B');
INSERT INTO `ey_region` VALUES ('31850', '万冲镇', '3', '31848', 'W');
INSERT INTO `ey_region` VALUES ('31851', '大安镇', '3', '31848', 'D');
INSERT INTO `ey_region` VALUES ('31852', '志仲镇', '3', '31848', 'Z');
INSERT INTO `ey_region` VALUES ('31853', '千家镇', '3', '31848', 'Q');
INSERT INTO `ey_region` VALUES ('31854', '九所镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31855', '利国镇', '3', '31848', 'L');
INSERT INTO `ey_region` VALUES ('31856', '黄流镇', '3', '31848', 'H');
INSERT INTO `ey_region` VALUES ('31857', '佛罗镇', '3', '31848', 'F');
INSERT INTO `ey_region` VALUES ('31858', '尖峰镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31859', '莺歌海镇', '3', '31848', 'Y');
INSERT INTO `ey_region` VALUES ('31860', '国营乐中农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31861', '国营山荣农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31862', '国营乐光农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31863', '国营报伦农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31864', '国营福报农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31865', '国营保国农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31866', '国营保显农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31867', '国营尖峰岭林业公司', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31868', '国营莺歌海盐场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31869', '陵水县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31870', '椰林镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31871', '光坡镇', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31872', '三才镇', '3', '31869', 'S');
INSERT INTO `ey_region` VALUES ('31873', '英州镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31874', '隆广镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31875', '文罗镇', '3', '31869', 'W');
INSERT INTO `ey_region` VALUES ('31876', '本号镇', '3', '31869', 'B');
INSERT INTO `ey_region` VALUES ('31877', '新村镇', '3', '31869', 'X');
INSERT INTO `ey_region` VALUES ('31878', '黎安镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31879', '提蒙乡', '3', '31869', 'T');
INSERT INTO `ey_region` VALUES ('31880', '群英乡', '3', '31869', 'Q');
INSERT INTO `ey_region` VALUES ('31881', '国营岭门农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31882', '国营南平农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31883', '国营吊罗山林业公司', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31884', '保亭县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31885', '保城镇', '3', '31884', 'B');
INSERT INTO `ey_region` VALUES ('31886', '什玲镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31887', '加茂镇', '3', '31884', 'J');
INSERT INTO `ey_region` VALUES ('31888', '响水镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31889', '新政镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31890', '三道镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31891', '六弓乡', '3', '31884', 'L');
INSERT INTO `ey_region` VALUES ('31892', '南林乡', '3', '31884', 'N');
INSERT INTO `ey_region` VALUES ('31893', '毛感乡', '3', '31884', 'M');
INSERT INTO `ey_region` VALUES ('31894', '国营五指山茶场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31895', '国营新星农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31896', '国营保亭热作所', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31897', '国营金江农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31898', '国营南茂农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31899', '国营三道农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31900', '琼中县', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31901', '营根镇', '3', '31900', 'Y');
INSERT INTO `ey_region` VALUES ('31902', '湾岭镇', '3', '31900', 'W');
INSERT INTO `ey_region` VALUES ('31903', '黎母山镇', '3', '31900', 'L');
INSERT INTO `ey_region` VALUES ('31904', '和平镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31905', '长征镇', '3', '31900', 'C');
INSERT INTO `ey_region` VALUES ('31906', '红毛镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31907', '中平镇', '3', '31900', 'Z');
INSERT INTO `ey_region` VALUES ('31908', '吊罗山乡', '3', '31900', 'D');
INSERT INTO `ey_region` VALUES ('31909', '上安乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31910', '什运乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31911', '国营新进农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31912', '国营大丰农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31913', '国营阳江农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31914', '国营乌石农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31915', '国营南方农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31916', '国营岭头农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31917', '国营加钗农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31918', '国营长征农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31919', '国营乘坡农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31920', '国营太平农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31921', '国营新伟农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31922', '国营黎母山林业公司', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31923', '西沙群岛', '3', '31924', 'X');
INSERT INTO `ey_region` VALUES ('31924', '三沙市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31925', '南沙群岛', '3', '31924', 'N');
INSERT INTO `ey_region` VALUES ('47499', '香港岛', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('31927', '中沙群岛的岛礁及其海域', '3', '31924', 'Z');
INSERT INTO `ey_region` VALUES ('47498', '九龙', '2', '47494', 'J');
INSERT INTO `ey_region` VALUES ('31929', '重庆市', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('31930', '重庆市', '2', '31929', 'C');
INSERT INTO `ey_region` VALUES ('31931', '万州区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('31984', '涪陵区', '3', '31930', 'F');
INSERT INTO `ey_region` VALUES ('32031', '渝中区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32044', '大渡口区', '3', '31930', 'D');
INSERT INTO `ey_region` VALUES ('32053', '江北区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32066', '沙坪坝区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32093', '九龙坡区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32112', '南岸区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32127', '北碚区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32145', '万盛区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('32156', '双桥区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32160', '渝北区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32191', '巴南区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32213', '黔江区', '3', '31930', 'Q');
INSERT INTO `ey_region` VALUES ('32244', '长寿区', '3', '31930', 'C');
INSERT INTO `ey_region` VALUES ('32263', '江津区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32291', '合川区', '3', '31930', 'H');
INSERT INTO `ey_region` VALUES ('32322', '永川区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32345', '南川区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32380', '县', '2', '31929', 'X');
INSERT INTO `ey_region` VALUES ('32381', '綦江县', '3', '32380', 'Q');
INSERT INTO `ey_region` VALUES ('32401', '潼南县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32424', '铜梁县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32453', '大足县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32478', '荣昌县', '3', '32380', 'R');
INSERT INTO `ey_region` VALUES ('32499', '璧山县', '3', '32380', 'B');
INSERT INTO `ey_region` VALUES ('32513', '梁平县', '3', '32380', 'L');
INSERT INTO `ey_region` VALUES ('32549', '城口县', '3', '32380', 'C');
INSERT INTO `ey_region` VALUES ('32574', '丰都县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32606', '垫江县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32632', '武隆县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32659', '忠县', '3', '32380', 'Z');
INSERT INTO `ey_region` VALUES ('32688', '开县', '3', '32380', 'K');
INSERT INTO `ey_region` VALUES ('32727', '云阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32771', '奉节县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32802', '巫山县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32829', '巫溪县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32861', '石柱县', '3', '32380', 'S');
INSERT INTO `ey_region` VALUES ('32894', '秀山县', '3', '32380', 'X');
INSERT INTO `ey_region` VALUES ('32927', '酉阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32967', '彭水县', '3', '32380', 'P');
INSERT INTO `ey_region` VALUES ('33007', '四川省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('33008', '成都市', '2', '33007', 'C');
INSERT INTO `ey_region` VALUES ('33009', '市辖区', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33010', '锦江区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33027', '青羊区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33042', '金牛区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33058', '武侯区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33076', '成华区', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33091', '龙泉驿区', '3', '33008', 'L');
INSERT INTO `ey_region` VALUES ('33104', '青白江区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33116', '新都区', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33130', '温江区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33141', '金堂县', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33163', '双流县', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33189', '郫县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33205', '大邑县', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33226', '蒲江县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33239', '新津县', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33252', '都江堰市', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33272', '彭州市', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33293', '邛崃市', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33318', '崇州市', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33344', '自贡市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('33345', '市辖区', '3', '33344', 'S');
INSERT INTO `ey_region` VALUES ('33346', '自流井区', '3', '33344', 'Z');
INSERT INTO `ey_region` VALUES ('33360', '贡井区', '3', '33344', 'G');
INSERT INTO `ey_region` VALUES ('33374', '大安区', '3', '33344', 'D');
INSERT INTO `ey_region` VALUES ('33391', '沿滩区', '3', '33344', 'Y');
INSERT INTO `ey_region` VALUES ('33405', '荣县', '3', '33344', 'R');
INSERT INTO `ey_region` VALUES ('33433', '富顺县', '3', '33344', 'F');
INSERT INTO `ey_region` VALUES ('33460', '攀枝花市', '2', '33007', 'P');
INSERT INTO `ey_region` VALUES ('33461', '市辖区', '3', '33460', 'S');
INSERT INTO `ey_region` VALUES ('33462', '攀枝花东区', '3', '33460', 'P');
INSERT INTO `ey_region` VALUES ('33473', '西区', '3', '33460', 'X');
INSERT INTO `ey_region` VALUES ('33481', '仁和区', '3', '33460', 'R');
INSERT INTO `ey_region` VALUES ('33497', '米易县', '3', '33460', 'M');
INSERT INTO `ey_region` VALUES ('33511', '盐边县', '3', '33460', 'Y');
INSERT INTO `ey_region` VALUES ('33528', '泸州市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('33529', '市辖区', '3', '33528', 'S');
INSERT INTO `ey_region` VALUES ('33530', '江阳区', '3', '33528', 'J');
INSERT INTO `ey_region` VALUES ('33548', '纳溪区', '3', '33528', 'N');
INSERT INTO `ey_region` VALUES ('33563', '龙马潭区', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33577', '泸县', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33597', '合江县', '3', '33528', 'H');
INSERT INTO `ey_region` VALUES ('33625', '叙永县', '3', '33528', 'X');
INSERT INTO `ey_region` VALUES ('33654', '古蔺县', '3', '33528', 'G');
INSERT INTO `ey_region` VALUES ('33681', '德阳市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('33682', '市辖区', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33683', '旌阳区', '3', '33681', 'J');
INSERT INTO `ey_region` VALUES ('33701', '中江县', '3', '33681', 'Z');
INSERT INTO `ey_region` VALUES ('33747', '罗江县', '3', '33681', 'L');
INSERT INTO `ey_region` VALUES ('33758', '广汉市', '3', '33681', 'G');
INSERT INTO `ey_region` VALUES ('33778', '什邡市', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33795', '绵竹市', '3', '33681', 'M');
INSERT INTO `ey_region` VALUES ('33817', '绵阳市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('33818', '市辖区', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33819', '涪城区', '3', '33817', 'F');
INSERT INTO `ey_region` VALUES ('33844', '游仙区', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33873', '三台县', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33937', '盐亭县', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33974', '安县', '3', '33817', 'A');
INSERT INTO `ey_region` VALUES ('33995', '梓潼县', '3', '33817', 'Z');
INSERT INTO `ey_region` VALUES ('34028', '北川县', '3', '33817', 'B');
INSERT INTO `ey_region` VALUES ('34049', '平武县', '3', '33817', 'P');
INSERT INTO `ey_region` VALUES ('34075', '江油市', '3', '33817', 'J');
INSERT INTO `ey_region` VALUES ('34120', '广元市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('34121', '市辖区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34122', '市中区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34143', '元坝区', '3', '34120', 'Y');
INSERT INTO `ey_region` VALUES ('34173', '朝天区', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34199', '旺苍县', '3', '34120', 'W');
INSERT INTO `ey_region` VALUES ('34238', '青川县', '3', '34120', 'Q');
INSERT INTO `ey_region` VALUES ('34276', '剑阁县', '3', '34120', 'J');
INSERT INTO `ey_region` VALUES ('34334', '苍溪县', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34376', '遂宁市', '2', '33007', 'S');
INSERT INTO `ey_region` VALUES ('34377', '市辖区', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34378', '船山区', '3', '34376', 'C');
INSERT INTO `ey_region` VALUES ('34404', '安居区', '3', '34376', 'A');
INSERT INTO `ey_region` VALUES ('34426', '蓬溪县', '3', '34376', 'P');
INSERT INTO `ey_region` VALUES ('34458', '射洪县', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34489', '大英县', '3', '34376', 'D');
INSERT INTO `ey_region` VALUES ('34501', '内江市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34502', '市辖区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34503', '市中区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34524', '东兴区', '3', '34501', 'D');
INSERT INTO `ey_region` VALUES ('34554', '威远县', '3', '34501', 'W');
INSERT INTO `ey_region` VALUES ('34575', '资中县', '3', '34501', 'Z');
INSERT INTO `ey_region` VALUES ('34609', '隆昌县', '3', '34501', 'L');
INSERT INTO `ey_region` VALUES ('34628', '乐山市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('34629', '市辖区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34630', '市中区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34661', '沙湾区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34676', '五通桥区', '3', '34628', 'W');
INSERT INTO `ey_region` VALUES ('34689', '金口河区', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34696', '犍为县', '3', '34628', 'Q');
INSERT INTO `ey_region` VALUES ('34727', '井研县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34755', '夹江县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34778', '沐川县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34799', '峨边县', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34819', '马边县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34840', '峨眉山市', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34859', '南充市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34860', '市辖区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34861', '顺庆区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34890', '高坪区', '3', '34859', 'G');
INSERT INTO `ey_region` VALUES ('34923', '嘉陵区', '3', '34859', 'J');
INSERT INTO `ey_region` VALUES ('34967', '南部县', '3', '34859', 'N');
INSERT INTO `ey_region` VALUES ('35040', '营山县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35094', '蓬安县', '3', '34859', 'P');
INSERT INTO `ey_region` VALUES ('35134', '仪陇县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35193', '西充县', '3', '34859', 'X');
INSERT INTO `ey_region` VALUES ('35238', '阆中市', '3', '34859', 'L');
INSERT INTO `ey_region` VALUES ('35288', '眉山市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('35289', '市辖区', '3', '35288', 'S');
INSERT INTO `ey_region` VALUES ('35290', '东坡区', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35317', '仁寿县', '3', '35288', 'R');
INSERT INTO `ey_region` VALUES ('35378', '彭山县', '3', '35288', 'P');
INSERT INTO `ey_region` VALUES ('35392', '洪雅县', '3', '35288', 'H');
INSERT INTO `ey_region` VALUES ('35408', '丹棱县', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35416', '青神县', '3', '35288', 'Q');
INSERT INTO `ey_region` VALUES ('35427', '宜宾市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('35428', '市辖区', '3', '35427', 'S');
INSERT INTO `ey_region` VALUES ('35429', '翠屏区', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35454', '宜宾县', '3', '35427', 'Y');
INSERT INTO `ey_region` VALUES ('35481', '南溪县', '3', '35427', 'N');
INSERT INTO `ey_region` VALUES ('35497', '江安县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35516', '长宁县', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35535', '高县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35555', '珙县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35573', '筠连县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35592', '兴文县', '3', '35427', 'X');
INSERT INTO `ey_region` VALUES ('35608', '屏山县', '3', '35427', 'P');
INSERT INTO `ey_region` VALUES ('35625', '广安市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('35626', '市辖区', '3', '35625', 'S');
INSERT INTO `ey_region` VALUES ('35627', '广安区', '3', '35625', 'G');
INSERT INTO `ey_region` VALUES ('35677', '岳池县', '3', '35625', 'Y');
INSERT INTO `ey_region` VALUES ('35721', '武胜县', '3', '35625', 'W');
INSERT INTO `ey_region` VALUES ('35753', '邻水县', '3', '35625', 'L');
INSERT INTO `ey_region` VALUES ('35799', '华蓥市', '3', '35625', 'H');
INSERT INTO `ey_region` VALUES ('35813', '达州市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('35814', '市辖区', '3', '35813', 'S');
INSERT INTO `ey_region` VALUES ('35815', '通川区', '3', '35813', 'T');
INSERT INTO `ey_region` VALUES ('35829', '达县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('35894', '宣汉县', '3', '35813', 'X');
INSERT INTO `ey_region` VALUES ('35949', '开江县', '3', '35813', 'K');
INSERT INTO `ey_region` VALUES ('35970', '大竹县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('36021', '渠县', '3', '35813', 'Q');
INSERT INTO `ey_region` VALUES ('36082', '万源市', '3', '35813', 'W');
INSERT INTO `ey_region` VALUES ('36136', '雅安市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('36137', '市辖区', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36138', '雨城区', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36161', '名山县', '3', '36136', 'M');
INSERT INTO `ey_region` VALUES ('36182', '荥经县', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36204', '汉源县', '3', '36136', 'H');
INSERT INTO `ey_region` VALUES ('36245', '石棉县', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36263', '天全县', '3', '36136', 'T');
INSERT INTO `ey_region` VALUES ('36279', '芦山县', '3', '36136', 'L');
INSERT INTO `ey_region` VALUES ('36289', '宝兴县', '3', '36136', 'B');
INSERT INTO `ey_region` VALUES ('36299', '巴中市', '2', '33007', 'B');
INSERT INTO `ey_region` VALUES ('36300', '市辖区', '3', '36299', 'S');
INSERT INTO `ey_region` VALUES ('36301', '巴州区', '3', '36299', 'B');
INSERT INTO `ey_region` VALUES ('36354', '通江县', '3', '36299', 'T');
INSERT INTO `ey_region` VALUES ('36404', '南江县', '3', '36299', 'N');
INSERT INTO `ey_region` VALUES ('36453', '平昌县', '3', '36299', 'P');
INSERT INTO `ey_region` VALUES ('36497', '资阳市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('36498', '市辖区', '3', '36497', 'S');
INSERT INTO `ey_region` VALUES ('36499', '雁江区', '3', '36497', 'Y');
INSERT INTO `ey_region` VALUES ('36527', '安岳县', '3', '36497', 'A');
INSERT INTO `ey_region` VALUES ('36597', '乐至县', '3', '36497', 'L');
INSERT INTO `ey_region` VALUES ('36623', '简阳市', '3', '36497', 'J');
INSERT INTO `ey_region` VALUES ('36679', '阿坝州', '2', '33007', 'A');
INSERT INTO `ey_region` VALUES ('36680', '汶川县', '3', '36679', 'W');
INSERT INTO `ey_region` VALUES ('36694', '理县', '3', '36679', 'L');
INSERT INTO `ey_region` VALUES ('36708', '茂县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36731', '松潘县', '3', '36679', 'S');
INSERT INTO `ey_region` VALUES ('36759', '九寨沟县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36778', '金川县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36802', '小金县', '3', '36679', 'X');
INSERT INTO `ey_region` VALUES ('36824', '黑水县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36842', '马尔康县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36858', '壤塘县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36871', '阿坝县', '3', '36679', 'A');
INSERT INTO `ey_region` VALUES ('36893', '若尔盖县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36914', '红原县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36926', '甘孜州', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('36927', '康定县', '3', '36926', 'K');
INSERT INTO `ey_region` VALUES ('36949', '泸定县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('36962', '丹巴县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('36978', '九龙县', '3', '36926', 'J');
INSERT INTO `ey_region` VALUES ('36997', '雅江县', '3', '36926', 'Y');
INSERT INTO `ey_region` VALUES ('37015', '道孚县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37038', '炉霍县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37055', '甘孜县', '3', '36926', 'G');
INSERT INTO `ey_region` VALUES ('37078', '新龙县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37098', '德格县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37125', '白玉县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37143', '石渠县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37166', '色达县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37184', '理塘县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37209', '巴塘县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37229', '乡城县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37242', '稻城县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37257', '得荣县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37270', '凉山州', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('37271', '西昌市', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37315', '木里县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37345', '盐源县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37380', '德昌', '3', '37270', 'D');
INSERT INTO `ey_region` VALUES ('37404', '会理县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37455', '会东县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37509', '宁南县', '3', '37270', 'N');
INSERT INTO `ey_region` VALUES ('37535', '普格县', '3', '37270', 'P');
INSERT INTO `ey_region` VALUES ('37570', '布拖县', '3', '37270', 'B');
INSERT INTO `ey_region` VALUES ('37601', '金阳县', '3', '37270', 'J');
INSERT INTO `ey_region` VALUES ('37636', '昭觉县', '3', '37270', 'Z');
INSERT INTO `ey_region` VALUES ('37684', '喜德县', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37709', '冕宁县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37748', '越西县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37790', '甘洛县', '3', '37270', 'G');
INSERT INTO `ey_region` VALUES ('37819', '美姑县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37856', '雷波县', '3', '37270', 'L');
INSERT INTO `ey_region` VALUES ('37906', '贵州省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('37907', '贵阳市', '2', '37906', 'G');
INSERT INTO `ey_region` VALUES ('37908', '市辖区', '3', '37907', 'S');
INSERT INTO `ey_region` VALUES ('37909', '南明区', '3', '37907', 'N');
INSERT INTO `ey_region` VALUES ('37927', '云岩区', '3', '37907', 'Y');
INSERT INTO `ey_region` VALUES ('37944', '花溪区', '3', '37907', 'H');
INSERT INTO `ey_region` VALUES ('37961', '乌当区', '3', '37907', 'W');
INSERT INTO `ey_region` VALUES ('37977', '白云区', '3', '37907', 'B');
INSERT INTO `ey_region` VALUES ('37987', '小河区', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('37991', '开阳县', '3', '37907', 'K');
INSERT INTO `ey_region` VALUES ('38008', '息烽县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38019', '修文县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38030', '清镇市', '3', '37907', 'Q');
INSERT INTO `ey_region` VALUES ('38042', '六盘水市', '2', '37906', 'L');
INSERT INTO `ey_region` VALUES ('38043', '钟山区', '3', '38042', 'Z');
INSERT INTO `ey_region` VALUES ('38053', '六枝特区', '3', '38042', 'L');
INSERT INTO `ey_region` VALUES ('38073', '水城县', '3', '38042', 'S');
INSERT INTO `ey_region` VALUES ('38107', '盘县', '3', '38042', 'P');
INSERT INTO `ey_region` VALUES ('38145', '遵义市', '2', '37906', 'Z');
INSERT INTO `ey_region` VALUES ('38146', '市辖区', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38147', '红花岗区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38164', '汇川区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38174', '遵义县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38206', '桐梓县', '3', '38145', 'T');
INSERT INTO `ey_region` VALUES ('38231', '绥阳县', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38247', '正安县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38267', '道真县', '3', '38145', 'D');
INSERT INTO `ey_region` VALUES ('38282', '务川县', '3', '38145', 'W');
INSERT INTO `ey_region` VALUES ('38298', '凤冈县', '3', '38145', 'F');
INSERT INTO `ey_region` VALUES ('38313', '湄潭县', '3', '38145', 'M');
INSERT INTO `ey_region` VALUES ('38329', '余庆县', '3', '38145', 'Y');
INSERT INTO `ey_region` VALUES ('38340', '习水县', '3', '38145', 'X');
INSERT INTO `ey_region` VALUES ('38364', '赤水市', '3', '38145', 'C');
INSERT INTO `ey_region` VALUES ('38382', '仁怀市', '3', '38145', 'R');
INSERT INTO `ey_region` VALUES ('38402', '安顺市', '2', '37906', 'A');
INSERT INTO `ey_region` VALUES ('38403', '市辖区', '3', '38402', 'S');
INSERT INTO `ey_region` VALUES ('38404', '西秀区', '3', '38402', 'X');
INSERT INTO `ey_region` VALUES ('38429', '平坝县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38440', '普定县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38452', '镇宁县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38469', '关岭县', '3', '38402', 'G');
INSERT INTO `ey_region` VALUES ('38484', '紫云县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38497', '铜仁地区', '2', '37906', 'T');
INSERT INTO `ey_region` VALUES ('38498', '铜仁市', '3', '38497', 'T');
INSERT INTO `ey_region` VALUES ('38516', '江口县', '3', '38497', 'J');
INSERT INTO `ey_region` VALUES ('38526', '玉屏县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38533', '石阡县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38552', '思南县　', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38580', '印江县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38598', '德江县', '3', '38497', 'D');
INSERT INTO `ey_region` VALUES ('38619', '沿河县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38642', '松桃县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38671', '万山特区', '3', '38497', 'W');
INSERT INTO `ey_region` VALUES ('38677', '黔西南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('38678', '兴义市', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38705', '兴仁县', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38722', '普安县', '3', '38677', 'P');
INSERT INTO `ey_region` VALUES ('38737', '晴隆县', '3', '38677', 'Q');
INSERT INTO `ey_region` VALUES ('38752', '贞丰县', '3', '38677', 'Z');
INSERT INTO `ey_region` VALUES ('38766', '望谟县', '3', '38677', 'W');
INSERT INTO `ey_region` VALUES ('38784', '册亨县', '3', '38677', 'C');
INSERT INTO `ey_region` VALUES ('38799', '安龙县', '3', '38677', 'A');
INSERT INTO `ey_region` VALUES ('38816', '毕节地区', '2', '37906', 'B');
INSERT INTO `ey_region` VALUES ('38817', '毕节市', '3', '38816', 'B');
INSERT INTO `ey_region` VALUES ('38859', '大方县', '3', '38816', 'D');
INSERT INTO `ey_region` VALUES ('38896', '黔西县', '3', '38816', 'Q');
INSERT INTO `ey_region` VALUES ('38925', '金沙县', '3', '38816', 'J');
INSERT INTO `ey_region` VALUES ('38952', '织金县', '3', '38816', 'Z');
INSERT INTO `ey_region` VALUES ('38985', '纳雍县', '3', '38816', 'N');
INSERT INTO `ey_region` VALUES ('39011', '威宁县', '3', '38816', 'W');
INSERT INTO `ey_region` VALUES ('39047', '赫章县', '3', '38816', 'H');
INSERT INTO `ey_region` VALUES ('39075', '黔东南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39076', '凯里市', '3', '39075', 'K');
INSERT INTO `ey_region` VALUES ('39092', '黄平县', '3', '39075', 'H');
INSERT INTO `ey_region` VALUES ('39107', '施秉县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39116', '三穗县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39126', '镇远县', '3', '39075', 'Z');
INSERT INTO `ey_region` VALUES ('39139', '岑巩县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39151', '天柱县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39168', '锦屏县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39184', '剑河县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39197', '台江县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39206', '黎平县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39232', '榕江县', '3', '39075', 'R');
INSERT INTO `ey_region` VALUES ('39252', '从江县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39274', '雷山县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39284', '麻江县', '3', '39075', 'M');
INSERT INTO `ey_region` VALUES ('39294', '丹寨县', '3', '39075', 'D');
INSERT INTO `ey_region` VALUES ('39302', '黔南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39303', '都匀市', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39327', '福泉市', '3', '39302', 'F');
INSERT INTO `ey_region` VALUES ('39345', '荔波县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39363', '贵定县', '3', '39302', 'G');
INSERT INTO `ey_region` VALUES ('39384', '瓮安县', '3', '39302', 'W');
INSERT INTO `ey_region` VALUES ('39408', '独山县', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39427', '平塘县', '3', '39302', 'P');
INSERT INTO `ey_region` VALUES ('39447', '罗甸县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39474', '长顺县', '3', '39302', 'C');
INSERT INTO `ey_region` VALUES ('39493', '龙里县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39508', '惠水县', '3', '39302', 'H');
INSERT INTO `ey_region` VALUES ('39534', '三都县', '3', '39302', 'S');
INSERT INTO `ey_region` VALUES ('39556', '云南省', '1', '0', 'Y');
INSERT INTO `ey_region` VALUES ('39557', '昆明市', '2', '39556', 'K');
INSERT INTO `ey_region` VALUES ('39558', '市辖区', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39559', '五华区', '3', '39557', 'W');
INSERT INTO `ey_region` VALUES ('39571', '盘龙区', '3', '39557', 'P');
INSERT INTO `ey_region` VALUES ('39582', '官渡区', '3', '39557', 'G');
INSERT INTO `ey_region` VALUES ('39594', '西山区', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39605', '东川区', '3', '39557', 'D');
INSERT INTO `ey_region` VALUES ('39614', '呈贡县', '3', '39557', 'C');
INSERT INTO `ey_region` VALUES ('39622', '晋宁县', '3', '39557', 'J');
INSERT INTO `ey_region` VALUES ('39632', '富民县', '3', '39557', 'F');
INSERT INTO `ey_region` VALUES ('39640', '宜良县', '3', '39557', 'Y');
INSERT INTO `ey_region` VALUES ('39650', '石林县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39659', '嵩明县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39667', '禄劝县', '3', '39557', 'L');
INSERT INTO `ey_region` VALUES ('39684', '寻甸县', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39701', '安宁市', '3', '39557', 'A');
INSERT INTO `ey_region` VALUES ('39710', '曲靖市', '2', '39556', 'Q');
INSERT INTO `ey_region` VALUES ('39711', '市辖区', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39712', '麒麟区', '3', '39710', 'Q');
INSERT INTO `ey_region` VALUES ('39724', '马龙县', '3', '39710', 'M');
INSERT INTO `ey_region` VALUES ('39733', '陆良县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39744', '师宗县', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39753', '罗平县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39766', '富源县', '3', '39710', 'F');
INSERT INTO `ey_region` VALUES ('39778', '会泽县', '3', '39710', 'H');
INSERT INTO `ey_region` VALUES ('39800', '沾益县', '3', '39710', 'Z');
INSERT INTO `ey_region` VALUES ('39809', '宣威市', '3', '39710', 'X');
INSERT INTO `ey_region` VALUES ('39836', '玉溪市', '2', '39556', 'Y');
INSERT INTO `ey_region` VALUES ('39837', '市辖区', '3', '39836', 'S');
INSERT INTO `ey_region` VALUES ('39838', '红塔区', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39850', '江川县', '3', '39836', 'J');
INSERT INTO `ey_region` VALUES ('39858', '澄江县', '3', '39836', 'C');
INSERT INTO `ey_region` VALUES ('39865', '通海县', '3', '39836', 'T');
INSERT INTO `ey_region` VALUES ('39875', '华宁县', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39881', '易门县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39889', '峨山县', '3', '39836', 'E');
INSERT INTO `ey_region` VALUES ('39899', '新平县', '3', '39836', 'X');
INSERT INTO `ey_region` VALUES ('39912', '元江县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39923', '保山市', '2', '39556', 'B');
INSERT INTO `ey_region` VALUES ('39924', '市辖区', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39925', '隆阳区', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39946', '施甸县', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39960', '腾冲县', '3', '39923', 'T');
INSERT INTO `ey_region` VALUES ('39979', '龙陵县', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39990', '昌宁县', '3', '39923', 'C');
INSERT INTO `ey_region` VALUES ('40004', '昭通市', '2', '39556', 'Z');
INSERT INTO `ey_region` VALUES ('40005', '市辖区', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40006', '昭阳区', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40027', '鲁甸县', '3', '40004', 'L');
INSERT INTO `ey_region` VALUES ('40040', '巧家县', '3', '40004', 'Q');
INSERT INTO `ey_region` VALUES ('40057', '盐津县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40068', '大关县', '3', '40004', 'D');
INSERT INTO `ey_region` VALUES ('40078', '永善县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40094', '绥江县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40100', '镇雄县', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40129', '彝良县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40145', '威信县', '3', '40004', 'W');
INSERT INTO `ey_region` VALUES ('40156', '水富县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40160', '丽江市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40161', '市辖区', '3', '40160', 'S');
INSERT INTO `ey_region` VALUES ('40162', '古城区', '3', '40160', 'G');
INSERT INTO `ey_region` VALUES ('40172', '玉龙县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40189', '永胜县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40205', '华坪县', '3', '40160', 'H');
INSERT INTO `ey_region` VALUES ('40214', '宁蒗县', '3', '40160', 'N');
INSERT INTO `ey_region` VALUES ('40230', '思茅市', '2', '39556', 'S');
INSERT INTO `ey_region` VALUES ('40231', '市辖区', '3', '40230', 'S');
INSERT INTO `ey_region` VALUES ('40232', '翠云区', '3', '40230', 'C');
INSERT INTO `ey_region` VALUES ('40240', '普洱县', '3', '40230', 'P');
INSERT INTO `ey_region` VALUES ('40250', '墨江县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40266', '景东县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40280', '景谷县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40291', '镇沅县', '3', '40230', 'Z');
INSERT INTO `ey_region` VALUES ('40301', '江城县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40310', '孟连县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40318', '澜沧县', '3', '40230', 'L');
INSERT INTO `ey_region` VALUES ('40340', '西盟县', '3', '40230', 'X');
INSERT INTO `ey_region` VALUES ('40348', '临沧市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40349', '市辖区', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40350', '临翔区', '3', '40348', 'L');
INSERT INTO `ey_region` VALUES ('40361', '凤庆县', '3', '40348', 'F');
INSERT INTO `ey_region` VALUES ('40375', '云县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40388', '永德县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40400', '镇康县', '3', '40348', 'Z');
INSERT INTO `ey_region` VALUES ('40408', '双江县', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40417', '耿马县', '3', '40348', 'G');
INSERT INTO `ey_region` VALUES ('40429', '沧源县', '3', '40348', 'C');
INSERT INTO `ey_region` VALUES ('40441', '楚雄州', '2', '39556', 'C');
INSERT INTO `ey_region` VALUES ('40442', '楚雄市', '3', '40441', 'C');
INSERT INTO `ey_region` VALUES ('40458', '双柏县', '3', '40441', 'S');
INSERT INTO `ey_region` VALUES ('40467', '牟定县', '3', '40441', 'M');
INSERT INTO `ey_region` VALUES ('40475', '南华县', '3', '40441', 'N');
INSERT INTO `ey_region` VALUES ('40486', '姚安县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40496', '大姚县', '3', '40441', 'D');
INSERT INTO `ey_region` VALUES ('40509', '永仁县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40517', '元谋县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40528', '武定县', '3', '40441', 'W');
INSERT INTO `ey_region` VALUES ('40540', '禄丰县', '3', '40441', 'L');
INSERT INTO `ey_region` VALUES ('40555', '红河州', '2', '39556', 'H');
INSERT INTO `ey_region` VALUES ('40556', '个旧市', '3', '40555', 'G');
INSERT INTO `ey_region` VALUES ('40567', '开远市', '3', '40555', 'K');
INSERT INTO `ey_region` VALUES ('40576', '蒙自县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40588', '屏边县', '3', '40555', 'P');
INSERT INTO `ey_region` VALUES ('40596', '建水县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40611', '石屏县', '3', '40555', 'S');
INSERT INTO `ey_region` VALUES ('40621', '弥勒县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40635', '泸西县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40644', '元阳县', '3', '40555', 'Y');
INSERT INTO `ey_region` VALUES ('40659', '红河县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40673', '金平县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40688', '绿春县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40698', '河口县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40705', '文山州', '2', '39556', 'W');
INSERT INTO `ey_region` VALUES ('40706', '文山县', '3', '40705', 'W');
INSERT INTO `ey_region` VALUES ('40722', '砚山县', '3', '40705', 'Y');
INSERT INTO `ey_region` VALUES ('40734', '西畴县', '3', '40705', 'X');
INSERT INTO `ey_region` VALUES ('40744', '麻栗坡县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40756', '马关县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40770', '丘北县', '3', '40705', 'Q');
INSERT INTO `ey_region` VALUES ('40783', '广南县', '3', '40705', 'G');
INSERT INTO `ey_region` VALUES ('40802', '富宁县', '3', '40705', 'F');
INSERT INTO `ey_region` VALUES ('40816', '西双版纳州', '2', '39556', 'X');
INSERT INTO `ey_region` VALUES ('40817', '景洪市', '3', '40816', 'J');
INSERT INTO `ey_region` VALUES ('40829', '勐海县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40841', '勐腊县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40852', '大理州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40853', '大理市', '3', '40852', 'D');
INSERT INTO `ey_region` VALUES ('40866', '漾濞县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40876', '祥云县', '3', '40852', 'X');
INSERT INTO `ey_region` VALUES ('40887', '宾川县', '3', '40852', 'B');
INSERT INTO `ey_region` VALUES ('40901', '弥渡县', '3', '40852', 'M');
INSERT INTO `ey_region` VALUES ('40910', '南涧县', '3', '40852', 'N');
INSERT INTO `ey_region` VALUES ('40919', '巍山县', '3', '40852', 'W');
INSERT INTO `ey_region` VALUES ('40930', '永平县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40938', '云龙县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40950', '洱源县', '3', '40852', 'E');
INSERT INTO `ey_region` VALUES ('40960', '剑川县', '3', '40852', 'J');
INSERT INTO `ey_region` VALUES ('40969', '鹤庆县', '3', '40852', 'H');
INSERT INTO `ey_region` VALUES ('40979', '德宏州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40980', '瑞丽市', '3', '40979', 'R');
INSERT INTO `ey_region` VALUES ('40988', '潞西市', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41000', '梁河县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41010', '盈江县', '3', '40979', 'Y');
INSERT INTO `ey_region` VALUES ('41026', '陇川县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41036', '怒江州', '2', '39556', 'N');
INSERT INTO `ey_region` VALUES ('41037', '泸水县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41047', '福贡县', '3', '41036', 'F');
INSERT INTO `ey_region` VALUES ('41055', '贡山县', '3', '41036', 'G');
INSERT INTO `ey_region` VALUES ('41061', '兰坪县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41070', '迪庆州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('41071', '香格里拉县', '3', '41070', 'X');
INSERT INTO `ey_region` VALUES ('41083', '德钦县', '3', '41070', 'D');
INSERT INTO `ey_region` VALUES ('41092', '维西县', '3', '41070', 'W');
INSERT INTO `ey_region` VALUES ('41103', '西藏自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('41104', '拉萨市', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41105', '市辖区', '3', '41104', 'S');
INSERT INTO `ey_region` VALUES ('41106', '城关区', '3', '41104', 'C');
INSERT INTO `ey_region` VALUES ('41118', '林周县', '3', '41104', 'L');
INSERT INTO `ey_region` VALUES ('41129', '当雄县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41138', '尼木县', '3', '41104', 'N');
INSERT INTO `ey_region` VALUES ('41147', '曲水县', '3', '41104', 'Q');
INSERT INTO `ey_region` VALUES ('41154', '堆龙德庆', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41162', '达孜县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41169', '墨竹工卡县', '3', '41104', 'M');
INSERT INTO `ey_region` VALUES ('41178', '昌都地区', '2', '41103', 'C');
INSERT INTO `ey_region` VALUES ('41179', '昌都县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41195', '江达县', '3', '41178', 'J');
INSERT INTO `ey_region` VALUES ('41209', '贡觉县', '3', '41178', 'G');
INSERT INTO `ey_region` VALUES ('41222', '类乌齐县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41233', '丁青县', '3', '41178', 'D');
INSERT INTO `ey_region` VALUES ('41247', '察亚县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41261', '八宿县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41276', '左贡县', '3', '41178', 'Z');
INSERT INTO `ey_region` VALUES ('41287', '芒康县', '3', '41178', 'M');
INSERT INTO `ey_region` VALUES ('41304', '洛隆县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41316', '边坝县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41328', '山南地区', '2', '41103', 'S');
INSERT INTO `ey_region` VALUES ('41329', '乃东县', '3', '41328', 'N');
INSERT INTO `ey_region` VALUES ('41337', '扎囊县', '3', '41328', 'Z');
INSERT INTO `ey_region` VALUES ('41343', '贡嘎县', '3', '41328', 'G');
INSERT INTO `ey_region` VALUES ('41352', '桑日县', '3', '41328', 'S');
INSERT INTO `ey_region` VALUES ('41357', '琼结县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41362', '曲松县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41368', '措美县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41373', '洛扎县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41381', '加查县', '3', '41328', 'J');
INSERT INTO `ey_region` VALUES ('41389', '隆子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41401', '错那县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41412', '浪卡子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41423', '日喀则地区', '2', '41103', 'R');
INSERT INTO `ey_region` VALUES ('41424', '日喀则市', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41437', '南木林县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41455', '江孜县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41475', '定日县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41489', '萨迦县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41501', '拉孜县', '3', '41423', 'L');
INSERT INTO `ey_region` VALUES ('41513', '昂仁县', '3', '41423', 'A');
INSERT INTO `ey_region` VALUES ('41531', '谢通门县', '3', '41423', 'X');
INSERT INTO `ey_region` VALUES ('41551', '白朗县', '3', '41423', 'B');
INSERT INTO `ey_region` VALUES ('41563', '仁布县', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41573', '康马县', '3', '41423', 'K');
INSERT INTO `ey_region` VALUES ('41583', '定结县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41594', '仲巴县', '3', '41423', 'Z');
INSERT INTO `ey_region` VALUES ('41608', '亚东县', '3', '41423', 'Y');
INSERT INTO `ey_region` VALUES ('41616', '吉隆县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41622', '聂拉木县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41630', '萨嘎县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41639', '岗巴县', '3', '41423', 'G');
INSERT INTO `ey_region` VALUES ('41645', '那曲地区', '2', '41103', 'N');
INSERT INTO `ey_region` VALUES ('41646', '那曲县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41659', '嘉黎县', '3', '41645', 'J');
INSERT INTO `ey_region` VALUES ('41670', '比如县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41681', '聂荣县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41692', '安多县', '3', '41645', 'A');
INSERT INTO `ey_region` VALUES ('41706', '申扎县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41715', '索县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41726', '班戈县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41737', '巴青县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41748', '尼玛县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41770', '阿里地区', '2', '41103', 'A');
INSERT INTO `ey_region` VALUES ('41771', '普兰县', '3', '41770', 'P');
INSERT INTO `ey_region` VALUES ('41775', '札达县', '3', '41770', 'Z');
INSERT INTO `ey_region` VALUES ('41782', '噶尔县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41788', '日土县', '3', '41770', 'R');
INSERT INTO `ey_region` VALUES ('41794', '革吉县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41800', '改则县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41808', '措勤县', '3', '41770', 'C');
INSERT INTO `ey_region` VALUES ('41814', '林芝地区', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41815', '林芝县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41823', '工布江达县', '3', '41814', 'G');
INSERT INTO `ey_region` VALUES ('41833', '米林县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41842', '墨脱县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41851', '波密县', '3', '41814', 'B');
INSERT INTO `ey_region` VALUES ('41863', '察隅县', '3', '41814', 'C');
INSERT INTO `ey_region` VALUES ('41870', '朗县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41877', '陕西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('41878', '西安市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('41879', '市辖区', '3', '41878', 'S');
INSERT INTO `ey_region` VALUES ('41880', '新城区', '3', '41878', 'X');
INSERT INTO `ey_region` VALUES ('41890', '碑林区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41899', '莲湖区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41909', '灞桥区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41919', '未央区', '3', '41878', 'W');
INSERT INTO `ey_region` VALUES ('41930', '雁塔区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41939', '阎良区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41947', '临潼区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41971', '长安区', '3', '41878', 'C');
INSERT INTO `ey_region` VALUES ('41997', '蓝田县', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('42020', '周至县', '3', '41878', 'Z');
INSERT INTO `ey_region` VALUES ('42043', '户县', '3', '41878', 'H');
INSERT INTO `ey_region` VALUES ('42060', '高陵县', '3', '41878', 'G');
INSERT INTO `ey_region` VALUES ('42069', '铜川市', '2', '41877', 'T');
INSERT INTO `ey_region` VALUES ('42070', '市辖区', '3', '42069', 'S');
INSERT INTO `ey_region` VALUES ('42071', '王益区', '3', '42069', 'W');
INSERT INTO `ey_region` VALUES ('42079', '印台区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42091', '耀州区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42108', '宜君县', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42119', '宝鸡市', '2', '41877', 'B');
INSERT INTO `ey_region` VALUES ('42120', '市辖区', '3', '42119', 'S');
INSERT INTO `ey_region` VALUES ('42121', '渭滨区', '3', '42119', 'W');
INSERT INTO `ey_region` VALUES ('42133', '金台区', '3', '42119', 'J');
INSERT INTO `ey_region` VALUES ('42146', '陈仓区', '3', '42119', 'C');
INSERT INTO `ey_region` VALUES ('42165', '凤翔县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42183', '岐山县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42198', '扶风县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42211', '眉县', '3', '42119', 'M');
INSERT INTO `ey_region` VALUES ('42224', '陇县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42240', '千阳县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42252', '麟游县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42263', '凤县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42278', '太白县', '3', '42119', 'T');
INSERT INTO `ey_region` VALUES ('42287', '咸阳市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('42288', '市辖区', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42289', '秦都区', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42302', '杨凌区', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42308', '渭城区', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42319', '三原县', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42334', '泾阳县', '3', '42287', 'J');
INSERT INTO `ey_region` VALUES ('42351', '乾县', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42372', '礼泉县', '3', '42287', 'L');
INSERT INTO `ey_region` VALUES ('42388', '永寿县', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42402', '彬县', '3', '42287', 'B');
INSERT INTO `ey_region` VALUES ('42419', '长武县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42431', '旬邑县', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42446', '淳化县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42462', '武功县', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42475', '兴平市', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42490', '渭南市', '2', '41877', 'W');
INSERT INTO `ey_region` VALUES ('42491', '市辖区', '3', '42490', 'S');
INSERT INTO `ey_region` VALUES ('42492', '临渭区', '3', '42490', 'L');
INSERT INTO `ey_region` VALUES ('42523', '华县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42538', '潼关县', '3', '42490', 'T');
INSERT INTO `ey_region` VALUES ('42547', '大荔县', '3', '42490', 'D');
INSERT INTO `ey_region` VALUES ('42577', '合阳县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42594', '澄城县', '3', '42490', 'C');
INSERT INTO `ey_region` VALUES ('42609', '蒲城县', '3', '42490', 'P');
INSERT INTO `ey_region` VALUES ('42634', '白水县', '3', '42490', 'B');
INSERT INTO `ey_region` VALUES ('42649', '富平县', '3', '42490', 'F');
INSERT INTO `ey_region` VALUES ('42674', '韩城市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42691', '华阴市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42703', '延安市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('42704', '市辖区', '3', '42703', 'S');
INSERT INTO `ey_region` VALUES ('42705', '宝塔区', '3', '42703', 'B');
INSERT INTO `ey_region` VALUES ('42729', '延长县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42742', '延川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42757', '子长县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42771', '安塞县', '3', '42703', 'A');
INSERT INTO `ey_region` VALUES ('42784', '志丹县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42796', '吴起县', '3', '42703', 'W');
INSERT INTO `ey_region` VALUES ('42809', '甘泉县', '3', '42703', 'G');
INSERT INTO `ey_region` VALUES ('42818', '富县', '3', '42703', 'F');
INSERT INTO `ey_region` VALUES ('42833', '洛川县', '3', '42703', 'L');
INSERT INTO `ey_region` VALUES ('42850', '宜川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42863', '黄龙县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42874', '黄陵县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42888', '汉中市', '2', '41877', 'H');
INSERT INTO `ey_region` VALUES ('42889', '市辖区', '3', '42888', 'S');
INSERT INTO `ey_region` VALUES ('42890', '汉台区', '3', '42888', 'H');
INSERT INTO `ey_region` VALUES ('42908', '南郑县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('42939', '城固县', '3', '42888', 'C');
INSERT INTO `ey_region` VALUES ('42965', '洋县', '3', '42888', 'Y');
INSERT INTO `ey_region` VALUES ('42992', '西乡县', '3', '42888', 'X');
INSERT INTO `ey_region` VALUES ('43016', '勉县', '3', '42888', 'M');
INSERT INTO `ey_region` VALUES ('43042', '宁强县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('43069', '略阳县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43091', '镇巴县', '3', '42888', 'Z');
INSERT INTO `ey_region` VALUES ('43116', '留坝县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43126', '佛坪县', '3', '42888', 'F');
INSERT INTO `ey_region` VALUES ('43136', '榆林市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('43137', '市辖区', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43138', '榆阳区', '3', '43136', 'Y');
INSERT INTO `ey_region` VALUES ('43170', '神木县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43190', '府谷县', '3', '43136', 'F');
INSERT INTO `ey_region` VALUES ('43211', '横山县', '3', '43136', 'H');
INSERT INTO `ey_region` VALUES ('43230', '靖边县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43253', '定边县', '3', '43136', 'D');
INSERT INTO `ey_region` VALUES ('43279', '绥德县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43300', '米脂县', '3', '43136', 'M');
INSERT INTO `ey_region` VALUES ('43314', '佳县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43335', '吴堡县', '3', '43136', 'W');
INSERT INTO `ey_region` VALUES ('43344', '清涧县', '3', '43136', 'Q');
INSERT INTO `ey_region` VALUES ('43360', '子洲县', '3', '43136', 'Z');
INSERT INTO `ey_region` VALUES ('43379', '安康市', '2', '41877', 'A');
INSERT INTO `ey_region` VALUES ('43380', '市辖区', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43381', '汉滨区', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43428', '汉阴县', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43447', '石泉县', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43463', '宁陕县', '3', '43379', 'N');
INSERT INTO `ey_region` VALUES ('43478', '紫阳县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43504', '岚皋县', '3', '43379', 'L');
INSERT INTO `ey_region` VALUES ('43522', '平利县', '3', '43379', 'P');
INSERT INTO `ey_region` VALUES ('43535', '镇坪县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43546', '旬阳县', '3', '43379', 'X');
INSERT INTO `ey_region` VALUES ('43575', '白河县', '3', '43379', 'B');
INSERT INTO `ey_region` VALUES ('43592', '商洛市', '2', '41877', 'S');
INSERT INTO `ey_region` VALUES ('43593', '市辖区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43594', '商州区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43628', '洛南县', '3', '43592', 'L');
INSERT INTO `ey_region` VALUES ('43654', '丹凤县', '3', '43592', 'D');
INSERT INTO `ey_region` VALUES ('43676', '商南县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43699', '山阳县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43730', '镇安县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43759', '柞水县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43776', '甘肃省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('43777', '兰州市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('43778', '市辖区', '3', '43777', 'S');
INSERT INTO `ey_region` VALUES ('43779', '城关区', '3', '43777', 'C');
INSERT INTO `ey_region` VALUES ('43804', '七里河区', '3', '43777', 'Q');
INSERT INTO `ey_region` VALUES ('43820', '兰州市西固区', '3', '43777', 'L');
INSERT INTO `ey_region` VALUES ('43836', '安宁区', '3', '43777', 'A');
INSERT INTO `ey_region` VALUES ('43845', '红古区', '3', '43777', 'H');
INSERT INTO `ey_region` VALUES ('43853', '永登县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43872', '皋兰县', '3', '43777', 'G');
INSERT INTO `ey_region` VALUES ('43880', '榆中县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43904', '嘉峪关市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43905', '市辖', '3', '43904', 'S');
INSERT INTO `ey_region` VALUES ('43914', '金昌市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43915', '市辖区', '3', '43914', 'S');
INSERT INTO `ey_region` VALUES ('43916', '金川区', '3', '43914', 'J');
INSERT INTO `ey_region` VALUES ('43925', '永昌县', '3', '43914', 'Y');
INSERT INTO `ey_region` VALUES ('43936', '白银市', '2', '43776', 'B');
INSERT INTO `ey_region` VALUES ('43937', '市辖区', '3', '43936', 'S');
INSERT INTO `ey_region` VALUES ('43938', '白银区', '3', '43936', 'B');
INSERT INTO `ey_region` VALUES ('43949', '平川区', '3', '43936', 'P');
INSERT INTO `ey_region` VALUES ('43961', '靖远县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('43980', '会宁县', '3', '43936', 'H');
INSERT INTO `ey_region` VALUES ('44009', '景泰县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('44022', '天水市', '2', '43776', 'T');
INSERT INTO `ey_region` VALUES ('44023', '市辖区', '3', '44022', 'S');
INSERT INTO `ey_region` VALUES ('44024', '秦州区', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44048', '麦积区', '3', '44022', 'M');
INSERT INTO `ey_region` VALUES ('44069', '清水县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44088', '秦安县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44106', '甘谷县', '3', '44022', 'G');
INSERT INTO `ey_region` VALUES ('44122', '武山县', '3', '44022', 'W');
INSERT INTO `ey_region` VALUES ('44138', '张家川县', '3', '44022', 'Z');
INSERT INTO `ey_region` VALUES ('44154', '武威市', '2', '43776', 'W');
INSERT INTO `ey_region` VALUES ('44155', '市辖区', '3', '44154', 'S');
INSERT INTO `ey_region` VALUES ('44156', '凉州区', '3', '44154', 'L');
INSERT INTO `ey_region` VALUES ('44202', '民勤县', '3', '44154', 'M');
INSERT INTO `ey_region` VALUES ('44221', '古浪县', '3', '44154', 'G');
INSERT INTO `ey_region` VALUES ('44242', '天祝县', '3', '44154', 'T');
INSERT INTO `ey_region` VALUES ('44265', '张掖市', '2', '43776', 'Z');
INSERT INTO `ey_region` VALUES ('44266', '市辖区', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44267', '甘州区', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44294', '肃南县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44305', '民乐县', '3', '44265', 'M');
INSERT INTO `ey_region` VALUES ('44317', '临泽县', '3', '44265', 'L');
INSERT INTO `ey_region` VALUES ('44331', '高台县', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44341', '山丹县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44352', '平凉市', '2', '43776', 'P');
INSERT INTO `ey_region` VALUES ('44353', '市辖区', '3', '44352', 'S');
INSERT INTO `ey_region` VALUES ('44354', '崆峒区', '3', '44352', 'K');
INSERT INTO `ey_region` VALUES ('44375', '泾川县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44392', '灵台县', '3', '44352', 'L');
INSERT INTO `ey_region` VALUES ('44408', '崇信县', '3', '44352', 'C');
INSERT INTO `ey_region` VALUES ('44418', '华亭县', '3', '44352', 'H');
INSERT INTO `ey_region` VALUES ('44431', '庄浪县', '3', '44352', 'Z');
INSERT INTO `ey_region` VALUES ('44451', '静宁县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44477', '酒泉市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('44478', '市辖区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44479', '肃州区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44504', '金塔县', '3', '44477', 'J');
INSERT INTO `ey_region` VALUES ('44516', '瓜州县', '3', '44477', 'G');
INSERT INTO `ey_region` VALUES ('44531', '肃北县', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44535', '阿克塞县', '3', '44477', 'A');
INSERT INTO `ey_region` VALUES ('44539', '玉门市', '3', '44477', 'Y');
INSERT INTO `ey_region` VALUES ('44557', '敦煌市', '3', '44477', 'D');
INSERT INTO `ey_region` VALUES ('44569', '庆阳市', '2', '43776', 'Q');
INSERT INTO `ey_region` VALUES ('44570', '市辖区', '3', '44569', 'S');
INSERT INTO `ey_region` VALUES ('44571', '西峰区', '3', '44569', 'X');
INSERT INTO `ey_region` VALUES ('44582', '庆城县', '3', '44569', 'Q');
INSERT INTO `ey_region` VALUES ('44598', '环县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44620', '华池县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44636', '合水县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44649', '正宁县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44660', '宁县', '3', '44569', 'N');
INSERT INTO `ey_region` VALUES ('44679', '镇原县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44699', '定西市', '2', '43776', 'D');
INSERT INTO `ey_region` VALUES ('44700', '市辖区', '3', '44699', 'S');
INSERT INTO `ey_region` VALUES ('44701', '安定区', '3', '44699', 'A');
INSERT INTO `ey_region` VALUES ('44723', '通渭县', '3', '44699', 'T');
INSERT INTO `ey_region` VALUES ('44742', '陇西县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44760', '渭源县', '3', '44699', 'W');
INSERT INTO `ey_region` VALUES ('44777', '临洮县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44796', '漳县', '3', '44699', 'Z');
INSERT INTO `ey_region` VALUES ('44810', '岷县', '3', '44699', 'M');
INSERT INTO `ey_region` VALUES ('44829', '陇南市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('44830', '市辖区', '3', '44829', 'S');
INSERT INTO `ey_region` VALUES ('44831', '武都区', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44868', '成县', '3', '44829', 'C');
INSERT INTO `ey_region` VALUES ('44886', '文县', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44907', '宕昌县', '3', '44829', 'D');
INSERT INTO `ey_region` VALUES ('44933', '康县', '3', '44829', 'K');
INSERT INTO `ey_region` VALUES ('44955', '西和县', '3', '44829', 'X');
INSERT INTO `ey_region` VALUES ('44976', '礼县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45006', '徽县', '3', '44829', 'H');
INSERT INTO `ey_region` VALUES ('45022', '两当县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45035', '临夏州', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('45036', '临夏市', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45047', '临夏县', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45073', '康乐县', '3', '45035', 'K');
INSERT INTO `ey_region` VALUES ('45089', '永靖县', '3', '45035', 'Y');
INSERT INTO `ey_region` VALUES ('45107', '广河县', '3', '45035', 'G');
INSERT INTO `ey_region` VALUES ('45117', '和政县', '3', '45035', 'H');
INSERT INTO `ey_region` VALUES ('45131', '东乡县', '3', '45035', 'D');
INSERT INTO `ey_region` VALUES ('45156', '积石山县', '3', '45035', 'J');
INSERT INTO `ey_region` VALUES ('45174', '甘南州', '2', '43776', 'G');
INSERT INTO `ey_region` VALUES ('45175', '合作市', '3', '45174', 'H');
INSERT INTO `ey_region` VALUES ('45186', '临潭县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45203', '卓尼县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45219', '舟曲县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45239', '迭部县', '3', '45174', 'D');
INSERT INTO `ey_region` VALUES ('45251', '玛曲县', '3', '45174', 'M');
INSERT INTO `ey_region` VALUES ('45263', '碌曲县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45272', '夏河县', '3', '45174', 'X');
INSERT INTO `ey_region` VALUES ('45286', '青海省', '1', '0', 'Q');
INSERT INTO `ey_region` VALUES ('45287', '西宁市', '2', '45286', 'X');
INSERT INTO `ey_region` VALUES ('45288', '市辖区', '3', '45287', 'S');
INSERT INTO `ey_region` VALUES ('45289', '城东区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45299', '城中区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45306', '城西区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45314', '城北区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45320', '大通县', '3', '45287', 'D');
INSERT INTO `ey_region` VALUES ('45341', '湟中县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45358', '湟源县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45368', '海东地区', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45369', '平安县', '3', '45368', 'P');
INSERT INTO `ey_region` VALUES ('45378', '民和县', '3', '45368', 'M');
INSERT INTO `ey_region` VALUES ('45401', '乐都县', '3', '45368', 'L');
INSERT INTO `ey_region` VALUES ('45421', '互助县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45441', '化隆县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45461', '循化县', '3', '45368', 'X');
INSERT INTO `ey_region` VALUES ('45471', '海北州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45472', '门源县', '3', '45471', 'M');
INSERT INTO `ey_region` VALUES ('45487', '祁连县', '3', '45471', 'Q');
INSERT INTO `ey_region` VALUES ('45495', '海晏县', '3', '45471', 'H');
INSERT INTO `ey_region` VALUES ('45502', '刚察县', '3', '45471', 'G');
INSERT INTO `ey_region` VALUES ('45510', '黄南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45511', '同仁县', '3', '45510', 'T');
INSERT INTO `ey_region` VALUES ('45523', '尖扎县', '3', '45510', 'J');
INSERT INTO `ey_region` VALUES ('45533', '泽库县', '3', '45510', 'Z');
INSERT INTO `ey_region` VALUES ('45542', '河南县', '3', '45510', 'H');
INSERT INTO `ey_region` VALUES ('45548', '海南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45549', '共和县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45566', '同德县', '3', '45548', 'T');
INSERT INTO `ey_region` VALUES ('45573', '贵德县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45581', '兴海县', '3', '45548', 'X');
INSERT INTO `ey_region` VALUES ('45589', '贵南县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45597', '果洛州', '2', '45286', 'G');
INSERT INTO `ey_region` VALUES ('45598', '玛沁县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45607', '班玛县', '3', '45597', 'B');
INSERT INTO `ey_region` VALUES ('45617', '甘德县', '3', '45597', 'G');
INSERT INTO `ey_region` VALUES ('45625', '达日县', '3', '45597', 'D');
INSERT INTO `ey_region` VALUES ('45636', '久治县', '3', '45597', 'J');
INSERT INTO `ey_region` VALUES ('45643', '玛多县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45648', '玉树州', '2', '45286', 'Y');
INSERT INTO `ey_region` VALUES ('45649', '玉树县', '3', '45648', 'Y');
INSERT INTO `ey_region` VALUES ('45659', '杂多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45668', '称多县', '3', '45648', 'C');
INSERT INTO `ey_region` VALUES ('45676', '治多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45683', '囊谦县', '3', '45648', 'N');
INSERT INTO `ey_region` VALUES ('45694', '曲麻莱县', '3', '45648', 'Q');
INSERT INTO `ey_region` VALUES ('45701', '海西州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45702', '格尔木市', '3', '45701', 'G');
INSERT INTO `ey_region` VALUES ('45714', '德令哈市', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45727', '乌兰县', '3', '45701', 'W');
INSERT INTO `ey_region` VALUES ('45733', '都兰县', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45742', '天峻县', '3', '45701', 'T');
INSERT INTO `ey_region` VALUES ('45753', '宁夏回族自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('45754', '银川市', '2', '45753', 'Y');
INSERT INTO `ey_region` VALUES ('45755', '市辖区', '3', '45754', 'S');
INSERT INTO `ey_region` VALUES ('45756', '兴庆区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45772', '西夏区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45784', '金凤区', '3', '45754', 'J');
INSERT INTO `ey_region` VALUES ('45794', '永宁县', '3', '45754', 'Y');
INSERT INTO `ey_region` VALUES ('45803', '贺兰县', '3', '45754', 'H');
INSERT INTO `ey_region` VALUES ('45813', '灵武市', '3', '45754', 'L');
INSERT INTO `ey_region` VALUES ('45825', '石嘴山市', '2', '45753', 'S');
INSERT INTO `ey_region` VALUES ('45826', '市辖区', '3', '45825', 'S');
INSERT INTO `ey_region` VALUES ('45827', '大武口区', '3', '45825', 'D');
INSERT INTO `ey_region` VALUES ('45839', '惠农区', '3', '45825', 'H');
INSERT INTO `ey_region` VALUES ('45856', '平罗县', '3', '45825', 'P');
INSERT INTO `ey_region` VALUES ('45871', '吴忠市', '2', '45753', 'W');
INSERT INTO `ey_region` VALUES ('45872', '市辖区', '3', '45871', 'S');
INSERT INTO `ey_region` VALUES ('45877', '利通区', '3', '45871', 'L');
INSERT INTO `ey_region` VALUES ('45892', '盐池县', '3', '45871', 'Y');
INSERT INTO `ey_region` VALUES ('45903', '同心县', '3', '45871', 'T');
INSERT INTO `ey_region` VALUES ('45914', '青铜峡市', '3', '45871', 'Q');
INSERT INTO `ey_region` VALUES ('45926', '固原市', '2', '45753', 'G');
INSERT INTO `ey_region` VALUES ('45927', '市辖区', '3', '45926', 'S');
INSERT INTO `ey_region` VALUES ('45928', '原州区', '3', '45926', 'Y');
INSERT INTO `ey_region` VALUES ('45944', '西吉县', '3', '45926', 'X');
INSERT INTO `ey_region` VALUES ('45964', '隆德县', '3', '45926', 'L');
INSERT INTO `ey_region` VALUES ('45978', '泾源县', '3', '45926', 'J');
INSERT INTO `ey_region` VALUES ('45986', '彭阳县', '3', '45926', 'P');
INSERT INTO `ey_region` VALUES ('45999', '中卫市', '2', '45753', 'Z');
INSERT INTO `ey_region` VALUES ('46000', '市辖区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46012', '沙坡头区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46013', '中宁县', '3', '45999', 'Z');
INSERT INTO `ey_region` VALUES ('46026', '海原县', '3', '45999', 'H');
INSERT INTO `ey_region` VALUES ('46047', '新疆维吾尔自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('46048', '乌鲁木齐市', '2', '46047', 'W');
INSERT INTO `ey_region` VALUES ('46049', '市辖区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46050', '天山区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46065', '沙依巴克区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46079', '新市区', '3', '46048', 'X');
INSERT INTO `ey_region` VALUES ('46095', '水磨沟区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46104', '头屯河区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46114', '达坂城区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46123', '东山区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46128', '乌鲁木齐县', '3', '46048', 'W');
INSERT INTO `ey_region` VALUES ('46138', '克拉玛依市', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46139', '市辖区', '3', '46138', 'S');
INSERT INTO `ey_region` VALUES ('46140', '独山子区', '3', '46138', 'D');
INSERT INTO `ey_region` VALUES ('46144', '克拉玛依区', '3', '46138', 'K');
INSERT INTO `ey_region` VALUES ('46155', '白碱滩区', '3', '46138', 'B');
INSERT INTO `ey_region` VALUES ('46158', '乌尔禾区', '3', '46138', 'W');
INSERT INTO `ey_region` VALUES ('46162', '吐鲁番地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('46163', '吐鲁番市', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46178', '鄯善县', '3', '46162', 'S');
INSERT INTO `ey_region` VALUES ('46189', '托克逊县', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46197', '哈密地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46198', '哈密市', '3', '46197', 'H');
INSERT INTO `ey_region` VALUES ('46230', '巴里坤县', '3', '46197', 'B');
INSERT INTO `ey_region` VALUES ('46246', '伊吾县', '3', '46197', 'Y');
INSERT INTO `ey_region` VALUES ('46255', '昌吉州', '2', '46047', 'C');
INSERT INTO `ey_region` VALUES ('46256', '昌吉市', '3', '46255', 'C');
INSERT INTO `ey_region` VALUES ('46275', '阜康市', '3', '46255', 'F');
INSERT INTO `ey_region` VALUES ('46289', '米泉市', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46299', '呼图壁县', '3', '46255', 'H');
INSERT INTO `ey_region` VALUES ('46316', '玛纳斯', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46337', '奇台县', '3', '46255', 'Q');
INSERT INTO `ey_region` VALUES ('46355', '吉木萨尔县', '3', '46255', 'J');
INSERT INTO `ey_region` VALUES ('46366', '木垒县', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46380', '博州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46381', '博乐市', '3', '46380', 'B');
INSERT INTO `ey_region` VALUES ('46399', '精河县', '3', '46380', 'J');
INSERT INTO `ey_region` VALUES ('46410', '温泉县', '3', '46380', 'W');
INSERT INTO `ey_region` VALUES ('46422', '巴州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46423', '库尔勒市', '3', '46422', 'K');
INSERT INTO `ey_region` VALUES ('46451', '轮台县', '3', '46422', 'L');
INSERT INTO `ey_region` VALUES ('46463', '尉犁县', '3', '46422', 'W');
INSERT INTO `ey_region` VALUES ('46476', '若羌县', '3', '46422', 'R');
INSERT INTO `ey_region` VALUES ('46486', '且末县', '3', '46422', 'Q');
INSERT INTO `ey_region` VALUES ('46500', '焉耆县', '3', '46422', 'Y');
INSERT INTO `ey_region` VALUES ('46512', '和静县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46531', '和硕县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46542', '博湖县', '3', '46422', 'B');
INSERT INTO `ey_region` VALUES ('46551', '阿克苏地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('46552', '阿克苏市', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46571', '温宿县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46592', '库车县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46617', '沙雅县', '3', '46551', 'S');
INSERT INTO `ey_region` VALUES ('46630', '新和县', '3', '46551', 'X');
INSERT INTO `ey_region` VALUES ('46640', '拜城县', '3', '46551', 'B');
INSERT INTO `ey_region` VALUES ('46657', '乌什县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46668', '阿瓦提县', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46682', '柯坪县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46688', '克州', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46689', '阿图什市', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46704', '阿克陶县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46723', '阿合奇县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46733', '乌恰县', '3', '46688', 'W');
INSERT INTO `ey_region` VALUES ('46747', '喀什地区', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46748', '喀什市', '3', '46747', 'K');
INSERT INTO `ey_region` VALUES ('46761', '疏附县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46780', '疏勒县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46797', '英吉沙县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46813', '泽普县', '3', '46747', 'Z');
INSERT INTO `ey_region` VALUES ('46830', '莎车县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46863', '叶城县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46885', '麦盖提县', '3', '46747', 'M');
INSERT INTO `ey_region` VALUES ('46902', '岳普湖县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46913', '伽师县', '3', '46747', 'Q');
INSERT INTO `ey_region` VALUES ('46928', '巴楚县', '3', '46747', 'B');
INSERT INTO `ey_region` VALUES ('46942', '塔什库尔干县', '3', '46747', 'T');
INSERT INTO `ey_region` VALUES ('46957', '和田地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46958', '和田市', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46971', '和田县', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46983', '墨玉县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47002', '皮山县', '3', '46957', 'P');
INSERT INTO `ey_region` VALUES ('47020', '洛浦县', '3', '46957', 'L');
INSERT INTO `ey_region` VALUES ('47032', '策勒县', '3', '46957', 'C');
INSERT INTO `ey_region` VALUES ('47042', '于田县', '3', '46957', 'Y');
INSERT INTO `ey_region` VALUES ('47061', '民丰县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47069', '伊犁州', '2', '46047', 'Y');
INSERT INTO `ey_region` VALUES ('47070', '伊宁市', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47091', '奎屯市', '3', '47069', 'K');
INSERT INTO `ey_region` VALUES ('47099', '伊宁县', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47121', '察布查尔县', '3', '47069', 'C');
INSERT INTO `ey_region` VALUES ('47143', '霍城县', '3', '47069', 'H');
INSERT INTO `ey_region` VALUES ('47164', '巩留县', '3', '47069', 'G');
INSERT INTO `ey_region` VALUES ('47180', '新源县', '3', '47069', 'X');
INSERT INTO `ey_region` VALUES ('47196', '昭苏县', '3', '47069', 'Z');
INSERT INTO `ey_region` VALUES ('47214', '特克斯县', '3', '47069', 'T');
INSERT INTO `ey_region` VALUES ('47226', '尼勒克县', '3', '47069', 'N');
INSERT INTO `ey_region` VALUES ('47241', '塔城地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('47242', '塔城市', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47258', '乌苏市', '3', '47241', 'W');
INSERT INTO `ey_region` VALUES ('47291', '额敏县', '3', '47241', 'E');
INSERT INTO `ey_region` VALUES ('47315', '沙湾县', '3', '47241', 'S');
INSERT INTO `ey_region` VALUES ('47338', '托里县', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47351', '裕民县', '3', '47241', 'Y');
INSERT INTO `ey_region` VALUES ('47360', '和布县', '3', '47241', 'H');
INSERT INTO `ey_region` VALUES ('47374', '阿勒泰地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('47375', '阿勒泰市', '3', '47374', 'A');
INSERT INTO `ey_region` VALUES ('47393', '布尔津县', '3', '47374', 'B');
INSERT INTO `ey_region` VALUES ('47401', '富蕴县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47411', '福海县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47424', '哈巴河县', '3', '47374', 'H');
INSERT INTO `ey_region` VALUES ('47433', '青河县', '3', '47374', 'Q');
INSERT INTO `ey_region` VALUES ('47441', '吉木乃县', '3', '47374', 'J');
INSERT INTO `ey_region` VALUES ('47450', '省直辖行政单位', '2', '46047', 'S');
INSERT INTO `ey_region` VALUES ('47451', '石河子市', '3', '47450', 'S');
INSERT INTO `ey_region` VALUES ('47460', '阿拉尔市', '3', '47450', 'A');
INSERT INTO `ey_region` VALUES ('47477', '图木舒克市', '3', '47450', 'T');
INSERT INTO `ey_region` VALUES ('47486', '五家渠市', '3', '47450', 'W');
INSERT INTO `ey_region` VALUES ('47493', '台湾省', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('47494', '香港特别行政区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('47495', '澳门特别行政区', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('47496', '龙华新区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('47497', '光明新区', '3', '28558', 'G');
INSERT INTO `ey_region` VALUES ('47500', '新界', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('47501', '观塘区', '3', '47498', 'G');
INSERT INTO `ey_region` VALUES ('47502', '黄大仙区', '3', '47498', 'H');
INSERT INTO `ey_region` VALUES ('47503', '九龙城区', '3', '47498', 'J');
INSERT INTO `ey_region` VALUES ('47504', '深水埗区', '3', '47498', 'S');
INSERT INTO `ey_region` VALUES ('47505', '油尖旺区', '3', '47498', 'Y');
INSERT INTO `ey_region` VALUES ('47506', '东区', '3', '47499', 'D');
INSERT INTO `ey_region` VALUES ('47507', '南区', '3', '47499', 'N');
INSERT INTO `ey_region` VALUES ('47508', '湾仔', '3', '47499', 'W');
INSERT INTO `ey_region` VALUES ('47509', '中西区', '3', '47499', 'Z');
INSERT INTO `ey_region` VALUES ('47510', '北区', '3', '47500', 'B');
INSERT INTO `ey_region` VALUES ('47511', '大埔区', '3', '47500', 'D');
INSERT INTO `ey_region` VALUES ('47512', '葵青区', '3', '47500', 'K');
INSERT INTO `ey_region` VALUES ('47513', '离岛区', '3', '47500', 'L');
INSERT INTO `ey_region` VALUES ('47514', '荃湾区', '3', '47500', 'Q');
INSERT INTO `ey_region` VALUES ('47515', '沙田区', '3', '47500', 'S');
INSERT INTO `ey_region` VALUES ('47516', '屯门区', '3', '47500', 'T');
INSERT INTO `ey_region` VALUES ('47517', '西贡区', '3', '47500', 'X');
INSERT INTO `ey_region` VALUES ('47518', '元朗区', '3', '47500', 'Y');
INSERT INTO `ey_region` VALUES ('47519', '澳门半岛', '2', '47495', 'A');
INSERT INTO `ey_region` VALUES ('47520', '离岛', '2', '47495', 'L');
INSERT INTO `ey_region` VALUES ('47521', '大堂区', '3', '47519', 'D');
INSERT INTO `ey_region` VALUES ('47522', '风顺堂区', '3', '47519', 'F');
INSERT INTO `ey_region` VALUES ('47523', '花地玛堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47524', '花王堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47525', '望德堂区', '3', '47519', 'W');
INSERT INTO `ey_region` VALUES ('47526', '嘉模堂区', '3', '47520', 'J');
INSERT INTO `ey_region` VALUES ('47527', '路氹填海区', '3', '47520', 'L');
INSERT INTO `ey_region` VALUES ('47528', '圣方济各堂区', '3', '47520', 'S');
INSERT INTO `ey_region` VALUES ('47529', '高雄市', '2', '47493', 'G');
INSERT INTO `ey_region` VALUES ('47530', '花莲县', '2', '47493', 'H');
INSERT INTO `ey_region` VALUES ('47531', '基隆市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47532', '嘉义市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47533', '嘉义县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47534', '金门县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47535', '连江县', '2', '47493', 'L');
INSERT INTO `ey_region` VALUES ('47536', '苗栗县', '2', '47493', 'M');
INSERT INTO `ey_region` VALUES ('47537', '南投县', '2', '47493', 'N');
INSERT INTO `ey_region` VALUES ('47538', '澎湖县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47539', '屏东县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47540', '台北市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47541', '台东县', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47542', '台南市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47543', '台中市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47544', '桃园市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47545', '新北市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47546', '新竹市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47547', '新竹县', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47548', '宜兰县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47549', '云林县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47550', '彰化县', '2', '47493', 'Z');
INSERT INTO `ey_region` VALUES ('47551', '阿莲区', '3', '47529', 'A');
INSERT INTO `ey_region` VALUES ('47552', '大寮区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47553', '大社区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47554', '大树区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47555', '凤山区', '3', '47529', 'F');
INSERT INTO `ey_region` VALUES ('47556', '冈山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47557', '鼓山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47558', '湖内区', '3', '47529', 'H');
INSERT INTO `ey_region` VALUES ('47559', '甲仙区', '3', '47529', 'J');
INSERT INTO `ey_region` VALUES ('47560', '林园区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47561', '苓雅区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47562', '六龟区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47563', '路竹区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47564', '茂林区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47565', '美浓区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47566', '弥陀区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47567', '楠梓区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47568', '那玛夏区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47569', '内门区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47570', '鸟松区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47571', '旗津区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47572', '旗门区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47573', '其它区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47574', '前金区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47575', '前镇区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47576', '桥头区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47577', '茄萣区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47578', '芩雅区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47579', '仁武区', '3', '47529', 'R');
INSERT INTO `ey_region` VALUES ('47580', '三民区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47581', '杉林区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47582', '桃源区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47583', '田寮区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47584', '小港区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47585', '新兴区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47586', '燕巢区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47587', '盐埕区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47588', '永安区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47589', '梓官区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47590', '左营区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47591', '丰滨乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47592', '凤林镇', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47593', '富里乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47594', '光复乡', '3', '47530', 'G');
INSERT INTO `ey_region` VALUES ('47595', '花莲市', '3', '47530', 'H');
INSERT INTO `ey_region` VALUES ('47596', '吉安乡', '3', '47530', 'J');
INSERT INTO `ey_region` VALUES ('47597', '瑞穗乡', '3', '47530', 'R');
INSERT INTO `ey_region` VALUES ('47598', '寿丰乡', '3', '47530', 'S');
INSERT INTO `ey_region` VALUES ('47599', '太鲁阁', '3', '47530', 'T');
INSERT INTO `ey_region` VALUES ('47600', '万荣乡', '3', '47530', 'W');
INSERT INTO `ey_region` VALUES ('47601', '新城乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47602', '秀林乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47603', '玉里镇', '3', '47530', 'Y');
INSERT INTO `ey_region` VALUES ('47604', '卓溪乡', '3', '47530', 'Z');
INSERT INTO `ey_region` VALUES ('47605', '安乐区', '3', '47531', 'A');
INSERT INTO `ey_region` VALUES ('47606', '暖暖区', '3', '47531', 'N');
INSERT INTO `ey_region` VALUES ('47607', '七堵区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47608', '其它区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47609', '仁爱区', '3', '47531', 'R');
INSERT INTO `ey_region` VALUES ('47610', '信义区', '3', '47531', 'X');
INSERT INTO `ey_region` VALUES ('47611', '中山区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47612', '中正区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47613', '东区', '3', '47532', 'D');
INSERT INTO `ey_region` VALUES ('47614', '西区', '3', '47532', 'X');
INSERT INTO `ey_region` VALUES ('47615', '其它区', '3', '47532', 'Q');
INSERT INTO `ey_region` VALUES ('47616', '阿里山乡', '3', '47533', 'A');
INSERT INTO `ey_region` VALUES ('47617', '布袋镇', '3', '47533', 'B');
INSERT INTO `ey_region` VALUES ('47618', '大林镇', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47619', '大埔乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47620', '东石乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47621', '番路乡', '3', '47533', 'F');
INSERT INTO `ey_region` VALUES ('47622', '六脚乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47623', '鹿草乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47624', '梅山乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47625', '民雄乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47626', '朴子市', '3', '47533', 'P');
INSERT INTO `ey_region` VALUES ('47627', '水上乡', '3', '47533', 'S');
INSERT INTO `ey_region` VALUES ('47628', '太保市', '3', '47533', 'T');
INSERT INTO `ey_region` VALUES ('47629', '溪口乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47630', '新港乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47631', '义竹乡', '3', '47533', 'Y');
INSERT INTO `ey_region` VALUES ('47632', '中埔乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47633', '竹崎乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47634', '金城镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47635', '金湖镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47636', '金宁乡', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47637', '金沙镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47638', '烈屿乡', '3', '47534', 'L');
INSERT INTO `ey_region` VALUES ('47639', '乌邱乡', '3', '47534', 'W');
INSERT INTO `ey_region` VALUES ('47640', '北竿乡', '3', '47535', 'B');
INSERT INTO `ey_region` VALUES ('47641', '东引乡', '3', '47535', 'D');
INSERT INTO `ey_region` VALUES ('47642', '莒光乡', '3', '47535', 'J');
INSERT INTO `ey_region` VALUES ('47643', '南竿乡', '3', '47535', 'N');
INSERT INTO `ey_region` VALUES ('47644', '大湖乡', '3', '47536', 'D');
INSERT INTO `ey_region` VALUES ('47645', '公馆乡', '3', '47536', 'G');
INSERT INTO `ey_region` VALUES ('47646', '后龙镇', '3', '47536', 'H');
INSERT INTO `ey_region` VALUES ('47647', '苗栗市', '3', '47536', 'M');
INSERT INTO `ey_region` VALUES ('47648', '南庄乡', '3', '47536', 'N');
INSERT INTO `ey_region` VALUES ('47649', '三湾乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47650', '三义乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47651', '狮潭乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47652', '泰安乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47653', '铜锣乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47654', '通宵镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47655', '头份镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47656', '头屋乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47657', '西湖乡', '3', '47536', 'X');
INSERT INTO `ey_region` VALUES ('47658', '苑里镇', '3', '47536', 'Y');
INSERT INTO `ey_region` VALUES ('47659', '造桥乡', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47660', '竹南镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47661', '卓兰镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47662', '草屯镇', '3', '47537', 'C');
INSERT INTO `ey_region` VALUES ('47663', '国姓乡', '3', '47537', 'G');
INSERT INTO `ey_region` VALUES ('47664', '集集镇', '3', '47537', 'J');
INSERT INTO `ey_region` VALUES ('47665', '鹿谷乡', '3', '47537', 'L');
INSERT INTO `ey_region` VALUES ('47666', '名间乡', '3', '47537', 'M');
INSERT INTO `ey_region` VALUES ('47667', '南投市', '3', '47537', 'N');
INSERT INTO `ey_region` VALUES ('47668', '埔里镇', '3', '47537', 'P');
INSERT INTO `ey_region` VALUES ('47669', '仁爱乡', '3', '47537', 'R');
INSERT INTO `ey_region` VALUES ('47670', '水里乡', '3', '47537', 'S');
INSERT INTO `ey_region` VALUES ('47671', '信义乡', '3', '47537', 'X');
INSERT INTO `ey_region` VALUES ('47672', '鱼池乡', '3', '47537', 'Y');
INSERT INTO `ey_region` VALUES ('47673', '中寮乡', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47674', '竹山镇', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47675', '白沙乡', '3', '47538', 'B');
INSERT INTO `ey_region` VALUES ('47676', '湖西乡', '3', '47538', 'H');
INSERT INTO `ey_region` VALUES ('47677', '马公市', '3', '47538', 'M');
INSERT INTO `ey_region` VALUES ('47678', '七美乡', '3', '47538', 'Q');
INSERT INTO `ey_region` VALUES ('47679', '望安乡', '3', '47538', 'W');
INSERT INTO `ey_region` VALUES ('47680', '西屿乡', '3', '47538', 'X');
INSERT INTO `ey_region` VALUES ('47681', '长治乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47682', '潮州镇', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47683', '车城乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47684', '春日乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47685', '东港镇', '3', '47539', 'D');
INSERT INTO `ey_region` VALUES ('47686', '枋寮乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47687', '枋山乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47688', '高树乡', '3', '47539', 'G');
INSERT INTO `ey_region` VALUES ('47689', '恒春镇', '3', '47539', 'H');
INSERT INTO `ey_region` VALUES ('47690', '佳冬乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47691', '九如乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47692', '崁顶乡', '3', '47539', 'K');
INSERT INTO `ey_region` VALUES ('47693', '来义乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47694', '里港乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47695', '林边乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47696', '麟洛乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47697', '琉球乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47698', '玛家乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47699', '满州乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47700', '牡丹乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47701', '南州乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47702', '内埔乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47703', '屏东市', '3', '47539', 'P');
INSERT INTO `ey_region` VALUES ('47704', '三地门乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47705', '狮子乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47706', '泰武乡', '3', '47539', 'T');
INSERT INTO `ey_region` VALUES ('47707', '万丹乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47708', '万峦乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47709', '雾台乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47710', '新埤乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47711', '新园乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47712', '盐埔乡', '3', '47539', 'Y');
INSERT INTO `ey_region` VALUES ('47713', '竹田乡', '3', '47539', 'Z');
INSERT INTO `ey_region` VALUES ('47714', '北投区', '3', '47540', 'B');
INSERT INTO `ey_region` VALUES ('47715', '大安区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47716', '大同区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47717', '南港区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47718', '内湖区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47719', '士林区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47720', '松山区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47721', '万华区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47722', '文山区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47723', '信义区', '3', '47540', 'X');
INSERT INTO `ey_region` VALUES ('47724', '中山区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47725', '中正区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47726', '其它区', '3', '47540', 'Q');
INSERT INTO `ey_region` VALUES ('47727', '卑南乡', '3', '47541', 'B');
INSERT INTO `ey_region` VALUES ('47728', '长滨乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47729', '成功镇', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47730', '池上乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47731', '达仁乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47732', '大武乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47733', '东河乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47734', '关山镇', '3', '47541', 'G');
INSERT INTO `ey_region` VALUES ('47735', '海端乡', '3', '47541', 'H');
INSERT INTO `ey_region` VALUES ('47736', '金峰乡', '3', '47541', 'J');
INSERT INTO `ey_region` VALUES ('47737', '兰屿乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47738', '鹿野乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47739', '绿岛乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47740', '台东市', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47741', '太麻里乡', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47742', '延平乡', '3', '47541', 'Y');
INSERT INTO `ey_region` VALUES ('47743', '中西区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47744', '东区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47745', '南区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47746', '北区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47747', '安平区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47748', '安南区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47749', '其它区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47750', '永康区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47751', '归仁区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47752', '新化区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47753', '左镇区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47754', '玉井区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47755', '楠西区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47756', '南化区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47757', '仁德区', '3', '47542', 'R');
INSERT INTO `ey_region` VALUES ('47758', '关庙区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47759', '龙崎区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47760', '官田区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47761', '麻豆区', '3', '47542', 'M');
INSERT INTO `ey_region` VALUES ('47762', '佳里区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47763', '西港区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47764', '七股区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47765', '将军区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47766', '学甲区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47767', '北门区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47768', '新营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47769', '后壁区', '3', '47542', 'H');
INSERT INTO `ey_region` VALUES ('47770', '白河区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47771', '东山区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47772', '六甲区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47773', '下营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47774', '柳营区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47775', '盐水区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47776', '善化区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47777', '大内区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47778', '山上区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47779', '新市区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47780', '安定区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47781', '中区', '3', '47543', 'Z');
INSERT INTO `ey_region` VALUES ('47782', '东区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47783', '南区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47784', '西区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47785', '北区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47786', '北屯区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47787', '西屯区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47788', '南屯区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47789', '其它区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47790', '太平区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47791', '大里区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47792', '雾峰区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47793', '乌日区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47794', '丰原区', '3', '47543', 'F');
INSERT INTO `ey_region` VALUES ('47795', '后里区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47796', '石冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47797', '东势区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47798', '和平区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47799', '新社区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47800', '潭子区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47801', '大雅区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47802', '神冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47803', '大肚区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47804', '沙鹿区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47805', '龙井区', '3', '47543', 'L');
INSERT INTO `ey_region` VALUES ('47806', '梧栖区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47807', '清水区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47808', '大甲区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47809', '外埔区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47810', '大安区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47811', '中坜区', '3', '47544', 'Z');
INSERT INTO `ey_region` VALUES ('47812', '平镇区', '3', '47544', 'P');
INSERT INTO `ey_region` VALUES ('47813', '龙潭区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47814', '杨梅区', '3', '47544', 'Y');
INSERT INTO `ey_region` VALUES ('47815', '新屋区', '3', '47544', 'X');
INSERT INTO `ey_region` VALUES ('47816', '观音区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47817', '桃园区', '3', '47544', 'T');
INSERT INTO `ey_region` VALUES ('47818', '龟山区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47819', '八德区', '3', '47544', 'B');
INSERT INTO `ey_region` VALUES ('47820', '大溪区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47821', '复兴区', '3', '47544', 'F');
INSERT INTO `ey_region` VALUES ('47822', '大园区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47823', '芦竹区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47824', '万里区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47825', '金山区', '3', '47545', 'J');
INSERT INTO `ey_region` VALUES ('47826', '板桥区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47827', '汐止区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47828', '深坑区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47829', '石碇区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47830', '瑞芳区', '3', '47545', 'R');
INSERT INTO `ey_region` VALUES ('47831', '平溪区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47832', '双溪区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47833', '贡寮区', '3', '47545', 'G');
INSERT INTO `ey_region` VALUES ('47834', '新店区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47835', '坪林区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47836', '乌来区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47837', '永和区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47838', '中和区', '3', '47545', 'Z');
INSERT INTO `ey_region` VALUES ('47839', '土城区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47840', '三峡区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47841', '树林区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47842', '莺歌区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47843', '三重区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47844', '新庄区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47845', '泰山区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47846', '林口区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47847', '芦洲区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47848', '五股区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47849', '八里区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47850', '淡水区', '3', '47545', 'D');
INSERT INTO `ey_region` VALUES ('47851', '三芝区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47852', '石门区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47853', '东区', '3', '47546', 'D');
INSERT INTO `ey_region` VALUES ('47854', '北区', '3', '47546', 'B');
INSERT INTO `ey_region` VALUES ('47855', '香山区', '3', '47546', 'X');
INSERT INTO `ey_region` VALUES ('47856', '其它区', '3', '47546', 'Q');
INSERT INTO `ey_region` VALUES ('47857', '竹北市', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47858', '湖口乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47859', '新丰乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47860', '新埔镇', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47861', '关西镇', '3', '47547', 'G');
INSERT INTO `ey_region` VALUES ('47862', '芎林乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47863', '宝山乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47864', '竹东镇', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47865', '五峰乡', '3', '47547', 'W');
INSERT INTO `ey_region` VALUES ('47866', '横山乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47867', '尖石乡', '3', '47547', 'J');
INSERT INTO `ey_region` VALUES ('47868', '北埔乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47869', '峨眉乡', '3', '47547', 'E');
INSERT INTO `ey_region` VALUES ('47870', '宜兰市', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47871', '头城镇', '3', '47548', 'T');
INSERT INTO `ey_region` VALUES ('47872', '礁溪乡', '3', '47548', 'J');
INSERT INTO `ey_region` VALUES ('47873', '壮围乡', '3', '47548', 'Z');
INSERT INTO `ey_region` VALUES ('47874', '员山乡', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47875', '罗东镇', '3', '47548', 'L');
INSERT INTO `ey_region` VALUES ('47876', '三星乡', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47877', '大同乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47878', '五结乡', '3', '47548', 'W');
INSERT INTO `ey_region` VALUES ('47879', '冬山乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47880', '苏澳镇', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47881', '南澳乡', '3', '47548', 'N');
INSERT INTO `ey_region` VALUES ('47882', '钓鱼台', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47883', '斗南镇', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47884', '大埤乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47885', '虎尾镇', '3', '47549', 'H');
INSERT INTO `ey_region` VALUES ('47886', '土库镇', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47887', '褒忠乡', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47888', '东势乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47889', '台西乡', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47890', '仑背乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47891', '麦寮乡', '3', '47549', 'M');
INSERT INTO `ey_region` VALUES ('47892', '斗六市', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47893', '林内乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47894', '古坑乡', '3', '47549', 'G');
INSERT INTO `ey_region` VALUES ('47895', '莿桐乡', '3', '47549', 'C');
INSERT INTO `ey_region` VALUES ('47896', '西螺镇', '3', '47549', 'X');
INSERT INTO `ey_region` VALUES ('47897', '二仑乡', '3', '47549', 'E');
INSERT INTO `ey_region` VALUES ('47898', '北港镇', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47899', '水林乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47900', '口湖乡', '3', '47549', 'K');
INSERT INTO `ey_region` VALUES ('47901', '四湖乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47902', '元长乡', '3', '47549', 'Y');
INSERT INTO `ey_region` VALUES ('47903', '彰化市', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47904', '芬园乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47905', '花坛乡', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47906', '秀水乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47907', '鹿港镇', '3', '47550', 'L');
INSERT INTO `ey_region` VALUES ('47908', '福兴乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47909', '线西乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47910', '和美镇', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47911', '伸港乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47912', '员林镇', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47913', '社头乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47914', '永靖乡', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47915', '埔心乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47916', '溪湖镇', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47917', '大村乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47918', '埔盐乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47919', '田中镇', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47920', '北斗镇', '3', '47550', 'B');
INSERT INTO `ey_region` VALUES ('47921', '田尾乡', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47922', '埤头乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47923', '溪州乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47924', '竹塘乡', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47925', '二林镇', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47926', '大城乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47927', '芳苑乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47928', '二水乡', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47929', '莲池区', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('47930', '竞秀区', '3', '1772', 'J');
INSERT INTO `ey_region` VALUES ('47931', '常平镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47932', '茶山镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47933', '大朗镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47934', '大岭山镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47935', '道滘镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47936', '东城街道', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47937', '东坑镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47938', '凤岗镇', '3', '29855', 'F');
INSERT INTO `ey_region` VALUES ('47939', '高埗镇', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47940', '莞城街道', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47941', '横沥镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47942', '洪梅镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47943', '厚街镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47944', '黄江镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47945', '虎门镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47946', '寮步镇', '3', '29855', 'L');
INSERT INTO `ey_region` VALUES ('47947', '麻涌镇', '3', '29855', 'M');
INSERT INTO `ey_region` VALUES ('47948', '南城街道', '3', '29855', 'N');
INSERT INTO `ey_region` VALUES ('47949', '桥头镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47950', '清溪镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47951', '企石镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47952', '沙田镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47953', '石碣镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47954', '石龙镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47955', '石排镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47956', '松山湖管委会', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47957', '塘厦镇', '3', '29855', 'T');
INSERT INTO `ey_region` VALUES ('47958', '望牛墩镇', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47959', '万江街道', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47960', '谢岗镇', '3', '29855', 'X');
INSERT INTO `ey_region` VALUES ('47961', '长安镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47962', '樟木头镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47963', '中堂镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47964', '海外', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('47965', '海外', '2', '47964', 'H');
INSERT INTO `ey_region` VALUES ('47966', '海外', '3', '47965', 'H');
INSERT INTO `ey_region` VALUES ('47968', '吉阳区', '3', '31618', 'J');
INSERT INTO `ey_region` VALUES ('47969', '天涯区', '3', '31618', 'T');
INSERT INTO `ey_region` VALUES ('47970', '崖州区', '3', '31618', 'Y');
INSERT INTO `ey_region` VALUES ('47971', '济源市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('47972', '沁园街道', '3', '47971', 'Q');
INSERT INTO `ey_region` VALUES ('47973', '济水街道', '3', '47971', 'J');
INSERT INTO `ey_region` VALUES ('47974', '北海街道', '3', '47971', 'B');
INSERT INTO `ey_region` VALUES ('47975', '天坛街道', '3', '47971', 'T');
INSERT INTO `ey_region` VALUES ('47976', '玉泉街道', '3', '47971', 'Y');
INSERT INTO `ey_region` VALUES ('47977', '克井镇', '3', '47971', 'K');
INSERT INTO `ey_region` VALUES ('47978', '五龙口镇', '3', '47971', 'W');
INSERT INTO `ey_region` VALUES ('47979', '轵城镇', '3', '47971', 'Z');
INSERT INTO `ey_region` VALUES ('47980', '承留镇', '3', '47971', 'C');
INSERT INTO `ey_region` VALUES ('47981', '邵原镇', '3', '47971', 'S');
INSERT INTO `ey_region` VALUES ('47982', '坡头镇', '3', '47971', 'P');
INSERT INTO `ey_region` VALUES ('47983', '梨林镇', '3', '47971', 'L');
INSERT INTO `ey_region` VALUES ('47984', '大峪镇', '3', '47971', 'D');
INSERT INTO `ey_region` VALUES ('47985', '思礼镇', '3', '47971', 'S');
INSERT INTO `ey_region` VALUES ('47986', '王屋镇', '3', '47971', 'W');
INSERT INTO `ey_region` VALUES ('47987', '下冶镇', '3', '47971', 'X');
INSERT INTO `ey_region` VALUES ('47988', '龙港市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('47989', '市辖区', '2', '1', 'S');
INSERT INTO `ey_region` VALUES ('47990', '海淀区', '3', '47989', 'H');

-- -----------------------------
-- Table structure for `ey_search_hot`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_hot`;
CREATE TABLE `ey_search_hot` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT '' COMMENT '关键词',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `word` (`word`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='搜索词统计表';

-- -----------------------------
-- Records of `ey_search_hot`
-- -----------------------------
INSERT INTO `ey_search_hot` VALUES ('5', '枕头', '100', '1713953150', '1719283859');
INSERT INTO `ey_search_hot` VALUES ('6', '毛巾', '100', '1713953152', '1719283879');
INSERT INTO `ey_search_hot` VALUES ('7', '床品', '100', '1713953159', '1719283882');
INSERT INTO `ey_search_hot` VALUES ('8', '香薰', '100', '1713953180', '1719283889');

-- -----------------------------
-- Table structure for `ey_search_locking`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_locking`;
CREATE TABLE `ey_search_locking` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `locking_time` int(11) DEFAULT '0' COMMENT '锁定时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索记录锁定表';


-- -----------------------------
-- Table structure for `ey_search_word`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_word`;
CREATE TABLE `ey_search_word` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT '' COMMENT '关键词',
  `searchNum` int(10) DEFAULT '1' COMMENT '搜索次数',
  `resultNum` int(10) DEFAULT '0' COMMENT '搜索结果数量',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否热搜',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `word` (`word`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='搜索词统计表';

-- -----------------------------
-- Records of `ey_search_word`
-- -----------------------------
INSERT INTO `ey_search_word` VALUES ('1', '毛巾', '44', '6', '100', '0', '127.0.0.1', '0', '1719970970', '1727336587');
INSERT INTO `ey_search_word` VALUES ('5', '电脑', '1', '0', '100', '0', '36.101.199.83', '0', '1721641014', '1721641014');
INSERT INTO `ey_search_word` VALUES ('7', '充电宝', '3', '0', '100', '19', '36.101.197.83', '0', '1721716315', '1721716336');
INSERT INTO `ey_search_word` VALUES ('8', '床品', '4', '4', '100', '2', '36.101.197.83', '0', '1721725569', '1721805197');
INSERT INTO `ey_search_word` VALUES ('9', '枕头', '34', '1', '100', '0', '36.101.194.32', '0', '1721725571', '1722825046');
INSERT INTO `ey_search_word` VALUES ('10', '香薰', '31', '2', '100', '0', '36.101.203.105', '0', '1721725707', '1722219442');

-- -----------------------------
-- Table structure for `ey_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_setting`;
CREATE TABLE `ey_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `inc_type` (`inc_type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=284 DEFAULT CHARSET=utf8 COMMENT='系统非全局配置表';

-- -----------------------------
-- Records of `ey_setting`
-- -----------------------------
INSERT INTO `ey_setting` VALUES ('1', 'ask_ques_steps', '1、写问题标题，描述具体现象。杜绝 “求救，大佬，小白…” 等和问题无关的词汇。\r\n2、选择问题的分类，选择正确的内容分类，能更快的得到其他人的回复。\r\n3、遇到的问题比较急需解决，可以给问题悬赏一定的金额报酬，能让更多同行参与进来出谋策划，从中选择自己心仪的答案。\r\n4、写问题内容详细描述你碰到的困难，写清楚你尝试了什么方法，错误代码，软件的版本等，更容易得到答案。\r\n5、点击发布。', 'ask', '1623322108');
INSERT INTO `ey_setting` VALUES ('2', 'recycle_switch', '1', 'recycle', '1623809302');
INSERT INTO `ey_setting` VALUES ('3', 'system_old_product_attr', '0', 'system', '1623813369');
INSERT INTO `ey_setting` VALUES ('4', 'syn_admin_logic_1623377269', '1', 'syn', '1623813369');
INSERT INTO `ey_setting` VALUES ('5', 'syn_admin_logic_1625725290', '1', 'syn', '1636441870');
INSERT INTO `ey_setting` VALUES ('6', 'syn_admin_logic_1629252424', '1', 'syn', '1636441870');
INSERT INTO `ey_setting` VALUES ('7', 'admin_logic_1634204189', '1', 'syn', '1636442096');
INSERT INTO `ey_setting` VALUES ('8', 'admin_logic_1634280892', '1', 'syn', '1636442096');
INSERT INTO `ey_setting` VALUES ('9', 'admin_logic_1635326854', '1', 'syn', '1636442096');
INSERT INTO `ey_setting` VALUES ('10', 'admin_logic_1635389623', '1', 'syn', '1636442096');
INSERT INTO `ey_setting` VALUES ('11', 'admin_logic_1636875693', '1', 'syn', '1641949807');
INSERT INTO `ey_setting` VALUES ('12', 'admin_logic_1637033990', '1', 'syn', '1641949807');
INSERT INTO `ey_setting` VALUES ('13', 'admin_logic_1640918327', '1', 'syn', '1641949807');
INSERT INTO `ey_setting` VALUES ('14', 'admin_logic_1638857408', '1', 'syn', '1641949807');
INSERT INTO `ey_setting` VALUES ('15', 'admin_logic_1643352860', '2', 'syn', '1650263640');
INSERT INTO `ey_setting` VALUES ('16', 'admin_logic_1643352862', '1', 'syn', '1650263640');
INSERT INTO `ey_setting` VALUES ('17', 'admin_logic_1649299958', '1', 'syn', '1650263716');
INSERT INTO `ey_setting` VALUES ('18', 'admin_logic_1643352863', '1', 'syn', '1650263717');
INSERT INTO `ey_setting` VALUES ('19', 'security_askanswer_list', '[\"\\u60a8\\u5e38\\u7528\\u7684\\u624b\\u673a\\u53f7\\u7801\\u662f\\uff1f\",\"\\u60a8\\u5e38\\u7528\\u7684\\u7535\\u5b50\\u90ae\\u7bb1\\u662f\\uff1f\",\"\\u60a8\\u771f\\u5b9e\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u5b66\\u6821\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u51fa\\u751f\\u5730\\u540d\\u662f\\uff1f\",\"\\u60a8\\u914d\\u5076\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u8eab\\u4efd\\u8bc1\\u53f7\\u540e\\u516b\\u4f4d\\u662f\\uff1f\",\"\\u60a8\\u9ad8\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u6700\\u559c\\u6b22\\u7684\\u660e\\u661f\\u540d\\u5b57\\u662f\\uff1f\",\"\\u5bf9\\u60a8\\u5f71\\u54cd\\u6700\\u5927\\u7684\\u4eba\\u540d\\u5b57\\u662f\\uff1f\"]', 'security', '1650263717');
INSERT INTO `ey_setting` VALUES ('20', 'admin_logic_1643352864', '1', 'syn', '1650263717');
INSERT INTO `ey_setting` VALUES ('21', 'admin_logic_1647918733', '1', 'syn', '1650263717');
INSERT INTO `ey_setting` VALUES ('22', 'system_originlist', '[\"\\u7f51\\u7edc\"]', 'system', '1650263717');
INSERT INTO `ey_setting` VALUES ('23', 'admin_logic_1648435161', '1', 'syn', '1650263717');
INSERT INTO `ey_setting` VALUES ('24', 'admin_logic_1648882158', '1', 'syn', '1650263717');
INSERT INTO `ey_setting` VALUES ('25', 'admin_logic_1649399344', '1', 'syn', '1650263717');
INSERT INTO `ey_setting` VALUES ('29', 'syn_admin_logic_1616123194', '1', 'syn', '1653359669');
INSERT INTO `ey_setting` VALUES ('30', 'admin_logic_1655453263', '1', 'syn', '1658916485');
INSERT INTO `ey_setting` VALUES ('31', 'admin_logic_1652254594', '1', 'syn', '1658916485');
INSERT INTO `ey_setting` VALUES ('32', 'designated_column_1657069673', '1', 'syn', '1658916485');
INSERT INTO `ey_setting` VALUES ('33', 'admin_logic_1652771782', '1', 'syn', '1658916485');
INSERT INTO `ey_setting` VALUES ('34', 'syn_admin_logic_1616123195', '1', 'syn', '1658916485');
INSERT INTO `ey_setting` VALUES ('35', 'admin_logic_1651114275', '1', 'syn', '1658916485');
INSERT INTO `ey_setting` VALUES ('36', 'syn_admin_logic_1658220528', '1', 'syn', '1667183769');
INSERT INTO `ey_setting` VALUES ('37', 'syn_admin_logic_1658799138', '1', 'syn', '1667183769');
INSERT INTO `ey_setting` VALUES ('38', 'syn_admin_logic_1661323010', '1', 'syn', '1667183769');
INSERT INTO `ey_setting` VALUES ('39', 'syn_admin_logic_1661483783', '1', 'syn', '1667183769');
INSERT INTO `ey_setting` VALUES ('40', 'admin_logic_1662518904', '1', 'syn', '1667183769');
INSERT INTO `ey_setting` VALUES ('41', 'syn_admin_logic_1660557712', '1', 'syn', '1667183769');
INSERT INTO `ey_setting` VALUES ('42', 'admin_logic_1663290997', '1', 'syn', '1667184483');
INSERT INTO `ey_setting` VALUES ('43', 'admin_logic_1667210674', '1', 'syn', '1667356308');
INSERT INTO `ey_setting` VALUES ('44', 'admin_logic_1667357946', '1', 'syn', '1673945387');
INSERT INTO `ey_setting` VALUES ('45', 'editor_select', '1', 'editor', '1675389691');
INSERT INTO `ey_setting` VALUES ('46', 'editor_remote_img_local', '1', 'editor', '1675389691');
INSERT INTO `ey_setting` VALUES ('47', 'editor_img_clear_link', '1', 'editor', '1675389691');
INSERT INTO `ey_setting` VALUES ('48', 'admin_logic_1673941712', '1', 'syn', '1680508400');
INSERT INTO `ey_setting` VALUES ('49', 'admin_logic_1676854942', '1', 'syn', '1680508882');
INSERT INTO `ey_setting` VALUES ('50', 'admin_logic_1675243579', '1', 'syn', '1680508882');
INSERT INTO `ey_setting` VALUES ('51', 'admin_logic_1677555001', '1', 'syn', '1680508882');
INSERT INTO `ey_setting` VALUES ('52', 'admin_logic_1678762367', '1', 'syn', '1680508882');
INSERT INTO `ey_setting` VALUES ('53', 'admin_logic_1685584104', '1', 'syn', '1686877656');
INSERT INTO `ey_setting` VALUES ('54', 'admin_logic_1682580429', '1', 'syn', '1686877656');
INSERT INTO `ey_setting` VALUES ('55', 'admin_logic_1680749290', '1', 'syn', '1686877656');
INSERT INTO `ey_setting` VALUES ('58', 'adminlogin_bb7e531fe20f8dcc4485ceada88140d5', '0', 'adminlogin', '1692667932');
INSERT INTO `ey_setting` VALUES ('59', 'admin_logic_1687767523', '1', 'syn', '1692667932');
INSERT INTO `ey_setting` VALUES ('60', 'admin_logic_1689071584', '1', 'syn', '1692667932');
INSERT INTO `ey_setting` VALUES ('61', 'admin_logic_1681199467', '1', 'syn', '1692667955');
INSERT INTO `ey_setting` VALUES ('62', 'admin_logic_1687676445', '1', 'syn', '1692667955');
INSERT INTO `ey_setting` VALUES ('63', 'admin_logic_1685094852', '1', 'syn', '1692667955');
INSERT INTO `ey_setting` VALUES ('64', 'admin_logic_1687687709', '1', 'syn', '1692667955');
INSERT INTO `ey_setting` VALUES ('65', 'admin_logic_1692067658', '1', 'syn', '1692667957');
INSERT INTO `ey_setting` VALUES ('66', 'admin_logic_1697156935', 'v1.3.0', 'syn', '1727333138');
INSERT INTO `ey_setting` VALUES ('67', 'admin_logic_1698388181', '1', 'syn', '1699840479');
INSERT INTO `ey_setting` VALUES ('68', 'admin_logic_1698716726', '1', 'syn', '1699840479');
INSERT INTO `ey_setting` VALUES ('69', 'admin_logic_1700638990', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('70', 'admin_logic_1700789211', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('71', 'admin_logic_1700645198', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('72', 'admin_logic_1698733259', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('73', 'admin_logic_1698799687', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('74', 'syn_admin_logic_1700016487', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('75', 'syn_admin_logic_1700016488', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('76', 'syn_admin_logic_1700016489', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('77', 'syn_admin_logic_1700106425', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('78', 'admin_logic_1700621159', '1', 'syn', '1701045570');
INSERT INTO `ey_setting` VALUES ('79', 'admin_logic_1701050542', '1', 'syn', '1703142160');
INSERT INTO `ey_setting` VALUES ('80', 'admin_logic_1693909371', '1', 'syn', '1703142193');
INSERT INTO `ey_setting` VALUES ('81', 'admin_logic_1701855768', '1', 'syn', '1706510953');
INSERT INTO `ey_setting` VALUES ('82', 'system_codelogic_1638857408', 'ac1cVghSAQVVBlJRBAcAU1dXDVwCWw1aDgcGVAFoEwkGAgYnaS91dFRvJjRDA3UjVwF0J0ABdW1eOCU8MnFmcFR6did+AX90CV06MGEmdDEKW24zT2hsYGxULDAlZVdkM2FqIn4vc20NcDUnU1RjIyBWcDZyTmdvUhUzJzJ1ZmAdRHcgVDd+Yg5VNDNiKlQ0ERp8PAZ8eG9VMwAhMkdjdBJtUj5PCXJ3CWwmJkwDdTMeCWkidlthSUkTMk9VGHBeTllnAWgYaR4VRyhQblNkCwkyWx1tWHJMDzU8Vgx/UlkpAFYLYQdzQCtuNRhFU2VaLwt4ClRyflR1OTINVnxhQhNzYgFIVHdfPGY6C0UTZSYnN2ggYnx2bXhQJjMxeXR0N355LlAadGcncwYjXyJoMAEoYzV1Y2ZvbxICIiVEYGAgQ3IxaSx2ZiB3KCRlHGE6IAZuMwVOdW4IKzM0C35lZSN5djNuN2BxMHwRI1gUYCEgEnsgWFteUU0yVA0tRWtACkZvSU0FCHozZ1IkfDJ4BDQOVkZq', 'system', '1713753932');
INSERT INTO `ey_setting` VALUES ('83', 'system_uploads_type_id_selected', '0', 'system', '1713085803');
INSERT INTO `ey_setting` VALUES ('84', 'security_wechat_open', '0', 'security', '1713400999');
INSERT INTO `ey_setting` VALUES ('196', 'conf_weixin', '{\"mchid\":\"\",\"appid\":\"\",\"apikey\":\"\",\"appsecret\":\"\",\"apiclient_key\":\"\",\"apiclient_cert\":\"\"}', 'OpenMinicode', '1721274010');
INSERT INTO `ey_setting` VALUES ('211', 'editor_bdmap_ak', '', 'editor', '1718964306');
INSERT INTO `ey_setting` VALUES ('221', 'conf_toutiao', '{\"salt\":\"\",\"appid\":\"\",\"secret\":\"\",\"access_token\":\"\",\"expires_time\":}', 'OpenMinicode', '1719557121');
INSERT INTO `ey_setting` VALUES ('240', 'system_optimizetabledata_time', '1721100370', 'system', '1721100370');

-- -----------------------------
-- Table structure for `ey_sharp_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active`;
CREATE TABLE `ey_sharp_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动日期',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场表';


-- -----------------------------
-- Table structure for `ey_sharp_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_goods`;
CREATE TABLE `ey_sharp_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动场次ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `sharp_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_sharp_active_time`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_time`;
CREATE TABLE `ey_sharp_active_time` (
  `active_time_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '场次ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '场次时间(0点-23点)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_time_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场场次表';


-- -----------------------------
-- Table structure for `ey_sharp_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_goods`;
CREATE TABLE `ey_sharp_goods` (
  `sharp_goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '秒杀商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `limit` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限购数量',
  `seckill_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品库存总量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`sharp_goods_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-商品表';


-- -----------------------------
-- Table structure for `ey_sharp_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_setting`;
CREATE TABLE `ey_sharp_setting` (
  `key` varchar(30) NOT NULL DEFAULT '' COMMENT '设置项标示',
  `describe` varchar(255) NOT NULL DEFAULT '' COMMENT '设置项描述',
  `values` mediumtext NOT NULL COMMENT '设置内容(json格式)',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  UNIQUE KEY `unique_key` (`key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀设置表';


-- -----------------------------
-- Table structure for `ey_shop_address`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_address`;
CREATE TABLE `ey_shop_address` (
  `addr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '地址id',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '详细地址',
  `zipcode` varchar(10) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `is_default` tinyint(1) DEFAULT '0' COMMENT '是否默认，0否，1是。',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`addr_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='收货地址表';


-- -----------------------------
-- Table structure for `ey_shop_cart`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_cart`;
CREATE TABLE `ey_shop_cart` (
  `cart_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `users_id` int(10) unsigned DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned DEFAULT '0' COMMENT '产品id',
  `product_num` int(10) unsigned DEFAULT '0' COMMENT '购买数量',
  `spec_value_id` varchar(100) DEFAULT '' COMMENT '规格值ID',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态：0未选中，1选中',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_active_id` int(11) DEFAULT '0' COMMENT '限时折扣ID,用来区分购物车的商品哪些是限时折扣活动的',
  PRIMARY KEY (`cart_id`),
  KEY `users_id` (`users_id`,`product_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车表';


-- -----------------------------
-- Table structure for `ey_shop_coupon`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon`;
CREATE TABLE `ey_shop_coupon` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) NOT NULL DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券金额，例如10',
  `conditions_use` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券库存，例如100',
  `redeem_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换优惠券所需积分，为0则表示免费兑换',
  `redeem_authority` varchar(10) NOT NULL DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) NOT NULL DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_start_time` int(11) NOT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) NOT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券主表';


-- -----------------------------
-- Table structure for `ey_shop_coupon_use`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon_use`;
CREATE TABLE `ey_shop_coupon_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效结束时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';


-- -----------------------------
-- Table structure for `ey_shop_express`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_express`;
CREATE TABLE `ey_shop_express` (
  `express_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `express_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code',
  `express_name` varchar(32) NOT NULL DEFAULT '' COMMENT '物流名称',
  `express_lnitials` varchar(5) NOT NULL DEFAULT '' COMMENT '首字母',
  `is_choose` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '快递公司是否选中(0=否，1=是)',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`express_id`)
) ENGINE=MyISAM AUTO_INCREMENT=598 DEFAULT CHARSET=utf8 COMMENT='快递公司表';

-- -----------------------------
-- Records of `ey_shop_express`
-- -----------------------------
INSERT INTO `ey_shop_express` VALUES ('1', 'yuantong', '圆通快递', 'Y', '1', '97', '1553911076', '1719302210');
INSERT INTO `ey_shop_express` VALUES ('2', 'shentong', '申通快递', 'S', '1', '98', '1553911076', '1719302210');
INSERT INTO `ey_shop_express` VALUES ('3', 'shunfeng', '顺丰快递', 'S', '1', '98', '1553911076', '1715563137');
INSERT INTO `ey_shop_express` VALUES ('4', 'yunda', '韵达快递', 'Y', '1', '99', '1553911076', '1719302211');
INSERT INTO `ey_shop_express` VALUES ('5', 'debangwuliu', '德邦快递', 'D', '1', '99', '1553911076', '1719302213');
INSERT INTO `ey_shop_express` VALUES ('6', 'zhongtong', '中通快递', 'Z', '1', '99', '1553911076', '1719302214');
INSERT INTO `ey_shop_express` VALUES ('7', 'huitongkuaidi', '百世快递', 'B', '1', '99', '1553911076', '1719302215');
INSERT INTO `ey_shop_express` VALUES ('8', 'youzhengguonei', '邮政包裹', 'Y', '0', '99', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('9', 'ems', 'EMS', 'E', '0', '99', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('10', 'youzhengguoji', '邮政国际', 'Y', '0', '99', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('11', 'aolau', 'AOL澳通速递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('12', 'a2u', 'A2U速递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('13', 'aae', 'AAE快递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('14', 'annengwuliu', '安能物流', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('15', 'anxl', '安迅物流', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('16', 'auexpress', '澳邮中国快运', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('17', 'exfresh', '安鲜达', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('18', 'anjie88', '安捷物流', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('19', 'adodoxm', '澳多多国际速递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('20', 'ariesfar', '艾瑞斯远', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('21', 'qdants', 'ANTS EXPRESS', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('22', 'astexpress', '安世通快递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('23', 'gda', '安的快递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('24', 'ausexpress', '澳世速递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('25', 'ibuy8', '爱拜物流', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('26', 'aplusex', 'Aplus物流', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('27', 'adapost', '安达速递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('28', 'adiexpress', '安达易国际速递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('29', 'maxeedexpress', '澳洲迈速快递', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('30', 'onway', '昂威物流', 'A', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('31', 'bcwelt', 'BCWELT', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('32', 'balunzhi', '巴伦支快递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('33', 'xiaohongmao', '北青小红帽', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('34', 'bfdf', '百福东方物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('35', 'bangsongwuliu', '邦送物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('36', 'lbbk', '宝凯物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('37', 'bqcwl', '百千诚物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('38', 'idada', '百成大达物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('39', 'baishiwuliu', '百世快运', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('40', 'baitengwuliu', '百腾物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('41', 'birdex', '笨鸟海淘', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('42', 'bsht', '百事亨通', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('43', 'benteng', '奔腾物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('44', 'cuckooexpess', '布谷鸟速递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('45', 'bgky100', '邦工快运', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('46', 'bosind', '堡昕德速递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('47', 'banma', '斑马物联网', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('48', 'polarisexpress', '北极星快运', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('49', 'beijingfengyue', '北京丰越供应链', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('50', 'europe8', '败欧洲', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('51', 'bmlchina', '标杆物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('52', 'comexpress', '邦通国际', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('53', 'baotongkd', '宝通快递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('54', 'beckygo', '佰麒快递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('55', 'boyol', '贝业物流', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('56', 'bdatong', '八达通快递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('57', 'bangbangpost', '帮帮发', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('58', 'baoxianda', '报通快递', 'B', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('59', 'coe', '中国东方(COE)', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('60', 'cloudexpress', 'CE易欧通国际速递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('61', 'city100', '城市100', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('62', 'chuanxiwuliu', '传喜物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('63', 'chengjisudi', '城际速递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('64', 'lijisong', '立即送', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('65', 'chukou1', '出口易', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('66', 'nanjingshengbang', '晟邦物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('67', 'flyway', '程光快递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('68', 'cbo56', '钏博物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('69', 'cex', '城铁速递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('70', 'cnup', 'CNUP 中联邮', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('71', 'clsp', 'CL日中速运', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('72', 'cnair', 'CNAIR', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('73', 'cangspeed', '仓鼠快递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('74', 'spring56', '春风物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('75', 'cunto', '村通快递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('76', 'longvast', '长风物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('77', 'changjiang', '长江国际速递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('78', 'cncexp', 'C&C国际速递', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('79', 'parcelchina', '诚一物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('80', 'chengtong', '城通物流', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('81', 'otpexpress', '承诺达', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('82', 'sfpost', '曹操到', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('83', 'changwooair', '昌宇国际', 'C', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('84', 'dhl', 'DHL快递（中国件）', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('85', 'dhlen', 'DHL（国际件）', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('86', 'dhlde', 'DHL（德国件）', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('87', 'dtwl', '大田物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('88', 'disifang', '递四方', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('89', 'dayangwuliu', '大洋物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('90', 'dechuangwuliu', '德创物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('91', 'dskd', 'D速物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('92', 'donghanwl', '东瀚物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('93', 'dfpost', '达方物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('94', 'dongjun', '东骏快捷物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('95', 'dindon', '叮咚澳洲转运', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('96', 'dazhong', '大众佐川急便', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('97', 'ahdf', '德方物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('98', 'dehaoyi', '德豪驿', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('99', 'dhlpaket', 'DHL Paket', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('100', 'ubuy', '德国优拜物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('101', 'adlerlogi', '德国雄鹰速递', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('102', 'yunexpress', '德国云快递', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('103', 'di5pll', '递五方云仓', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('104', 'deguo8elog', '德国八易转运', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('105', 'camekong', '到了港', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('106', 'dbstation', 'db-station', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('107', 'dadaoex', '大道物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('108', 'dekuncn', '德坤物流', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('109', 'twkd56', '缔惠盛合', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('110', 'gslexpress', '德尚国际速递', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('111', 'eucpost', '德国 EUC POST', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('112', 'est365', '东方汇', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('113', 'ecotransite', '东西E全运', 'D', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('114', 'euexpress', 'EU-EXPRESS', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('115', 'emsguoji', 'EMS国际快递查询', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('116', 'eshunda', '俄顺达', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('117', 'ewe', 'EWE全球快递', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('118', 'easyexpress', 'EASYEXPRESS国际速递', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('119', 'edtexpress', 'e直运', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('120', 'ecallturn', 'E跨通', 'E', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('121', 'fedex', 'FedEx快递查询', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('122', 'fedexus', 'FedEx（美国）', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('123', 'fox', 'FOX国际速递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('124', 'rufengda', '如风达快递', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('125', 'fkd', '飞康达物流', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('126', 'feibaokuaidi', '飞豹快递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('127', 'fandaguoji', '颿达国际', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('128', 'feiyuanvipshop', '飞远配送', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('129', 'hnfy', '飞鹰物流', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('130', 'fengxingtianxia', '风行天下', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('131', 'flysman', '飞力士物流', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('132', 'fbkd', '飞邦快递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('133', 'sccod', '丰程物流', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('134', 'crazyexpress', '疯狂快递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('135', 'ftlexpress', '法翔速运', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('136', 'ftd', '富腾达快递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('137', 'arkexpress', '方舟国际速递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('138', 'fedroad', 'FedRoad 联邦转运', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('139', 'freakyquick', 'FQ狂派速递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('140', 'fecobv', '丰客物流', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('141', 'fyex', '飞云快递系统', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('142', 'beebird', '锋鸟物流', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('143', 'shipgce', '飞洋快递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('144', 'koali', '番薯国际货运', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('145', 'epanex', '泛捷国际速递', 'F', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('146', 'gaticn', 'GATI快递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('147', 'gts', 'GTS快递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('148', 'guotongkuaidi', '国通快递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('149', 'ndkd', '能达速递', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('150', 'gongsuda', '共速达', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('151', 'gtongsudi', '广通速递（山东）', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('152', 'suteng', '速腾物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('153', 'gdkd', '港快速递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('154', 'hre', '高铁速递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('155', 'gscq365', '哥士传奇速递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('156', 'gjwl', '冠捷物流', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('157', 'xdshipping', '国晶物流', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('158', 'ge2d', 'GE2D跨境物流', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('159', 'gaotieex', '高铁快运', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('160', 'gansuandi', '甘肃安的快递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('161', 'gdct56', '广东诚通物流', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('162', 'ghtexpress', 'GHT物流', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('163', 'goldjet', '高捷快运', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('164', 'gtgogo', 'GT国际快运', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('165', 'gxwl', '光线速递', 'G', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('166', 'tdhy', '华宇物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('167', 'hl', '恒路物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('168', 'hlyex', '好来运快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('169', 'hebeijianhua', '河北建华', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('170', 'huaqikuaiyun', '华企快运', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('171', 'haosheng', '昊盛物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('172', 'hutongwuliu', '户通物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('173', 'hzpl', '华航快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('174', 'huangmajia', '黄马甲快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('175', 'ucs', '合众速递（UCS）', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('176', 'pfcexpress', '皇家物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('177', 'huoban', '伙伴物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('178', 'nedahm', '红马速递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('179', 'huiwen', '汇文配送', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('180', 'nmhuahe', '华赫物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('181', 'hjs', '猴急送', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('182', 'hangyu', '航宇快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('183', 'huilian', '辉联物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('184', 'huanqiu', '环球速运', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('185', 'htwd', '华通务达物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('186', 'hipito', '海派通', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('187', 'hqtd', '环球通达', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('188', 'airgtc', '航空快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('189', 'haoyoukuai', '好又快物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('190', 'ccd', '河南次晨达', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('191', 'hfwuxi', '和丰同城', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('192', 'higo', '黑狗物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('193', 'hyytes', '恒宇运通', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('194', 'hengrui56', '恒瑞物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('195', 'hangrui', '上海航瑞货运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('196', 'ghl', '环创物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('197', 'hnqst', '河南全速通', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('198', 'hitaoe', 'Hi淘易快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('199', 'hhair56', '华瀚快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('200', 'haimibuy', '海米派物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('201', 'ht22', '海淘物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('202', 'hivewms', '海沧无忧', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('203', 'hnht56', '鸿泰物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('204', 'hsgtsd', '海硕高铁速递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('205', 'hltop', '海联快递', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('206', 'hlkytj', '互联快运', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('207', 'haidaibao', '海带宝转运', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('208', 'flowerkd', '花瓣转运', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('209', 'heimao56', '黑猫速运', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('210', 'logistics', '華信物流WTO', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('211', 'hgy56', '环国运物流', 'H', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('212', 'iparcel', 'i-parcel', 'I', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('213', 'jjwl', '佳吉物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('214', 'jywl', '佳怡物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('215', 'jymwl', '加运美快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('216', 'jxd', '急先达物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('217', 'jgsd', '京广速递快件', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('218', 'jykd', '晋越快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('219', 'jd', '京东物流', 'J', '1', '1', '1553911076', '1713493477');
INSERT INTO `ey_shop_express` VALUES ('220', 'jietekuaidi', '捷特快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('221', 'jiuyicn', '久易快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('222', 'jiuyescm', '九曳供应链', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('223', 'junfengguoji', '骏丰国际速递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('224', 'jiajiatong56', '佳家通', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('225', 'jrypex', '吉日优派', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('226', 'jinchengwuliu', '锦程国际物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('227', 'jgwl', '景光物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('228', 'pzhjst', '急顺通', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('229', 'ruexp', '捷网俄全通', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('230', 'jialidatong', '嘉里大通', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('231', 'jmjss', '金马甲', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('232', 'jiacheng', '佳成快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('233', 'jsexpress', '骏绅物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('234', 'hrex', '锦程快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('235', 'jieanda', '捷安达国际速递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('236', 'newsway', '家家通快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('237', 'mapleexpress', '今枫国际快运', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('238', 'jixiangyouau', '吉祥邮（澳洲）', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('239', 'jjx888', '佳捷翔物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('240', 'polarexpress', '极地快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('241', 'jiazhoumao', '加州猫速递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('242', 'juzhongda', '聚中大', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('243', 'jieborne', '捷邦物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('244', 'jxfex', '集先锋速递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('245', 'jiugong', '九宫物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('246', 'jiujiuwl', '久久物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('247', 'jintongkd', '劲通快递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('248', 'jcsuda', '嘉诚速达', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('249', 'jingshun', '景顺物流', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('250', 'fastontime', '加拿大联通快运', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('251', 'khzto', '柬埔寨中通', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('252', 'kjkd', '快捷快递', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('253', 'kangliwuliu', '康力物流', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('254', 'kuayue', '跨越速运', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('255', 'kuaiyouda', '快优达速递', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('256', 'happylink', '开心快递', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('257', 'ksudi', '快速递', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('258', 'kyue', '跨跃国际', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('259', 'kfwnet', '快服务', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('260', 'kuai8', '快8速运', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('261', 'kuaidawuliu', '快达物流', 'K', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('262', 'lianb', '联邦快递（国内）', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('263', 'lhtwl', '联昊通物流', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('264', 'lb', '龙邦速递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('265', 'lejiedi', '乐捷递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('266', 'lanhukuaidi', '蓝弧快递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('267', 'ltexp', '乐天速递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('268', 'lutong', '鲁通快运', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('269', 'ledii', '乐递供应链', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('270', 'lundao', '论道国际物流', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('271', 'lasy56', '林安物流', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('272', 'lsexpress', '6LS EXPRESS', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('273', 'szuem', '联运通物流', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('274', 'blueskyexpress', '蓝天国际航空快递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('275', 'lfexpress', '龙枫国际速递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('276', 'gslhkd', '联合快递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('277', 'longfx', '龙飞祥快递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('278', 'luben', '陆本速递 LUBEN EXPRESS', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('279', 'unitedex', '联合速运', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('280', 'lbex', '龙邦物流', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('281', 'ltparcel', '联通快递', 'L', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('282', 'macroexpressco', 'ME物流', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('283', 'mh', '民航快递', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('284', 'meiguokuaidi', '美国快递', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('285', 'menduimen', '门对门', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('286', 'mingliangwuliu', '明亮物流', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('287', 'minbangsudi', '民邦速递', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('288', 'minshengkuaidi', '闽盛快递', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('289', 'yundaexus', '美国韵达', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('290', 'mchy', '木春货运', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('291', 'meiquick', '美快国际物流', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('292', 'valueway', '美通快递', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('293', 'cnmcpl', '马珂博逻', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('294', 'mailongdy', '迈隆递运', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('295', 'zsmhwl', '明辉物流', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('296', 'mosuda', '魔速达', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('297', 'meibang', '美邦国际快递', 'M', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('298', 'nuoyaao', '偌亚奥国际', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('299', 'nuoer', '诺尔国际物流', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('300', 'nell', '尼尔快递', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('301', 'ndwl', '南方传媒物流', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('302', 'canhold', '能装能送', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('303', 'wanjiatong', '宁夏万家通', 'N', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('304', 'nlebv', '欧亚专线', 'O', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('305', 'oborexpress', 'OBOR Express', 'O', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('306', 'pcaexpress', 'PCA Express', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('307', 'pingandatengfei', '平安达腾飞', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('308', 'peixingwuliu', '陪行物流', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('309', 'pengyuanexpress', '鹏远国际速递', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('310', 'postelbe', 'PostElbe', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('311', 'papascm', '啪啪供应链', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('312', 'bazirim', '皮牙子快递', 'P', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('313', 'qfkd', '全峰快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('314', 'qy', '全一快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('315', 'qrt', '全日通快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('316', 'qckd', '全晨快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('317', 'sevendays', '7天连锁物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('318', 'qbexpress', '秦邦快运', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('319', 'quanxintong', '全信通快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('320', 'quansutong', '全速通国际快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('321', 'qinyuan', '秦远物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('322', 'qichen', '启辰国际物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('323', 'quansu', '全速快运', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('324', 'qzx56', '全之鑫物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('325', 'qskdyxgs', '千顺快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('326', 'zqlwl', '青旅物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('327', 'quanchuan56', '全川物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('328', 'quantwl', '全通快运', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('329', 'yatexpress', '乾坤物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('330', 'guexp', '全联速运', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('331', 'bjqywl', '青云物流', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('332', 'signedexpress', '签收快递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('333', 'express7th', '7号速递', 'Q', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('334', 'riyuwuliu', '日昱物流', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('335', 'rfsd', '瑞丰速递', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('336', 'rrs', '日日顺物流', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('337', 'rytsd', '日益通速递', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('338', 'rrskx', '日日顺快线', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('339', 'gdrz58', '容智快运', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('340', 'rrthk', '日日通国际', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('341', 'homecourier', '如家国际快递', 'R', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('342', 'sewl', '速尔快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('343', 'haihongwangsong', '山东海红', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('344', 'sh', '盛辉物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('345', 'sfwl', '盛丰物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('346', 'shiyunkuaidi', '世运快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('347', 'shangda', '上大物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('348', 'stsd', '三态速递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('349', 'saiaodi', '赛澳递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('350', 'ewl', '申通E物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('351', 'shenganwuliu', '圣安物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('352', 'sxhongmajia', '山西红马甲', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('353', 'suijiawuliu', '穗佳物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('354', 'syjiahuier', '沈阳佳惠尔', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('355', 'shlindao', '上海林道货运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('356', 'sfift', '十方通物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('357', 'shunjiefengda', '顺捷丰达', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('358', 'subida', '速必达物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('359', 'stcd', '速通成达物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('360', 'stkd', '顺通快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('361', 'sendtochina', '速递中国', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('362', 'sihaiet', '四海快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('363', 'staky', '首通快运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('364', 'hnssd56', '顺时达物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('365', 'superb', 'Superb Grace', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('366', 'sfjhd', '圣飞捷快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('367', 'sofast56', '嗖一下同城快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('368', 's2c', 'S2C', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('369', 'chinasqk', 'SQK国际速递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('370', 'shunshid', '顺士达速运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('371', 'synship', 'SYNSHIP快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('372', 'shandiantu', '闪电兔', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('373', 'sdsy888', '首达速运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('374', 'sczpds', '速呈宅配', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('375', 'sureline', 'Sureline冠泰', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('376', 'stosolution', '申通国际', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('377', 'sycawl', '狮爱高铁物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('378', 'sxexpress', '三象速递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('379', 'shangqiao56', '商桥物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('380', 'shd56', '商海德物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('381', 'shenma', '神马快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('382', 'sihiexpress', '四海捷运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('383', 'superoz', '速配鸥翼', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('384', 'fastgoexpress', '速派快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('385', 'zjstky', '苏通快运', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('386', 'suning', '苏宁物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('387', 'shaoke', '捎客物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('388', 'sdto', '速达通跨境物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('389', 'sut56', '速通物流', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('390', 'sundarexpress', '顺达快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('391', 'sxjdfreight', '顺心捷达', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('392', 'shengtongscm', '盛通快递', 'S', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('393', 'tnt', 'TNT快递', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('394', 'tt', '天天快递', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('395', 'tianzong', '天纵物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('396', 'chinatzx', '同舟行物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('397', 'nntengda', '腾达速递', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('398', 'sd138', '泰国138', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('399', 'tongdaxing', '通达兴物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('400', 'tlky', '天联快运', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('401', 'ibenben', '途鲜物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('402', 'krtao', '淘韩国际快递', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('403', 'lntjs', '特急送', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('404', 'tny', 'TNY物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('405', 'djy56', '天翔东捷运', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('406', 'guoeryue', '天天快物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('407', 'tianma', '天马迅达', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('408', 'surpassgo', '天越物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('409', 'tianxiang', '天翔快递', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('410', 'tywl99', '天翼物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('411', 'shpost', '同城快寄', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('412', 'humpline', '驼峰国际', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('413', 'transrush', 'TransRush', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('414', 'tstexp', 'TST速运通', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('415', 'ctoexp', '泰国中通CTO', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('416', 'thaizto', '泰国中通ZTO', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('417', 'tswlcloud', '天使物流云', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('418', 'tzky', '铁中快运', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('419', 'tcxbthai', 'TCXB国际物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('420', 'taimek', '天美快递', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('421', 'taoplus', '淘布斯国际物流', 'T', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('422', 'ups', 'UPS快递查询', 'U', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('423', 'yskd', '优速快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('424', 'usps', 'USPS美国邮政', 'U', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('425', 'ueq', 'UEQ快递', 'U', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('426', 'uex', 'UEX国际物流', 'U', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('427', 'utaoscm', 'UTAO 优到', 'U', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('428', 'wxwl', '万象物流', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('429', 'weitepai', '微特派', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('430', 'wjwl', '万家物流', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('431', 'wanboex', '万博快递', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('432', 'wtdchina', '威时沛运', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('433', 'wzhaunyun', '微转运', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('434', 'gswtkd', '万通快递', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('435', 'wandougongzhu', '豌豆物流', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('436', 'wjkwl', '万家康物流', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('437', 'vps', '维普恩物流', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('438', 'wykjt', '51跨境通', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('439', 'wherexpess', '威盛快递', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('440', 'weilaimingtian', '未来明天快递', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('441', 'wdm', '万达美', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('442', 'wto56kj', '温通物流', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('443', '56kuaiyun', '五六快运', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('444', 'wowvip', '沃埃家', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('445', 'grivertek', '潍鸿', 'W', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('446', 'xbwl', '新邦物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('447', 'xfwl', '信丰物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('448', 'newegg', '新蛋物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('449', 'xianglongyuntong', '祥龙运通物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('450', 'xianchengliansudi', '西安城联速递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('451', 'xilaikd', '喜来快递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('452', 'xsrd', '鑫世锐达', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('453', 'xtb', '鑫通宝物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('454', 'xintianjie', '信天捷快递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('455', 'xaetc', '西安胜峰', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('456', 'xianfeng', '先锋快递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('457', 'sunspeedy', '新速航', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('458', 'xipost', '西邮寄', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('459', 'sinatone', '信联通', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('460', 'sunjex', '新杰物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('461', 'alog', '心怡物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('462', 'csxss', '新时速物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('463', 'xiangteng', '翔腾物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('464', 'westwing', '西翼物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('465', 'littlebearbear', '小熊物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('466', 'huanqiuabc', '中国香港环球快运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('467', 'xinning', '新宁物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('468', 'wlwex', '星空国际', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('469', 'yyexp', '西安运逸快递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('470', 'xiyoug', '西游寄', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('471', 'xlobo', 'xLobo', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('472', 'xunsuexpress', '迅速快递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('473', 'whgjkd', '香港伟豪国际物流', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('474', 'xyd666', '鑫远东速运', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('475', 'xdexpress', '迅达速递', 'X', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('476', 'ytkd', '运通快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('477', 'ycwl', '远成物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('478', 'yfsd', '亚风速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('479', 'yishunhang', '亿顺航', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('480', 'yfwl', '越丰物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('481', 'yad', '源安达快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('482', 'yfh', '原飞航物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('483', 'yinjiesudi', '银捷速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('484', 'yitongfeihong', '一统飞鸿', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('485', 'yuxinwuliu', '宇鑫物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('486', 'yitongda', '易通达', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('487', 'youbijia', '邮必佳', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('488', 'yiqiguojiwuliu', '一柒物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('489', 'yinsu', '音素快运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('490', 'yilingsuyun', '亿领速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('491', 'yujiawuliu', '煜嘉物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('492', 'gml', '英脉物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('493', 'leopard', '云豹国际货运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('494', 'czwlyn', '云南中诚', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('495', 'sdyoupei', '优配速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('496', 'yongchang', '永昌物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('497', 'yufeng', '御风速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('498', 'yousutongda', '优速通达', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('499', 'yongwangda', '永旺达快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('500', 'yingchao', '英超物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('501', 'edlogistics', '益递物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('502', 'yjxlm', '宜家行', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('503', 'onehcang', '一号仓', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('504', 'ycgky', '远成快运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('505', 'yunfeng56', '韵丰物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('506', 'iyoungspeed', '驿扬国际速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('507', 'zgyzt', '一站通快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('508', 'eupackage', '易优包裹', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('509', 'ydglobe', '云达通', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('510', 'el56', 'YLTD', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('511', 'yundx', '运东西', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('512', 'yangbaoguo', '洋包裹', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('513', 'uluckex', '优联吉运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('514', 'ecmscn', '易客满', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('515', 'ubonex', '优邦速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('516', 'yue777', '玥玛速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('517', 'ywexpress', '远为快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('518', 'ezhuanyuan', '易转运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('519', 'yiqisong', '一起送', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('520', 'yongbangwuliu', '永邦国际物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('521', 'yyox', '邮客全球速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('522', 'yihangmall', '易航物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('523', 'yiouzhou', '易欧洲国际物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('524', 'ykouan', '洋口岸', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('525', 'youyou', '优优速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('526', 'ytky168', '运通快运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('527', 'sixroad', '易普递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('528', 'yourscm', '雅澳物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('529', 'euguoji', '易邮国际', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('530', 'uscbexpress', '易境达国际物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('531', 'yfsuyun', '驭丰速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('532', 'yimidida', '壹米滴答', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('533', 'ugoexpress', '邮鸽速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('534', 'youban', '邮邦国际', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('535', 'hkems', '云邮跨境快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('536', 'youlai', '邮来速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('537', 'eta100', '易达国际速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('538', 'yatfai', '一辉物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('539', 'yzswuliu', '亚洲顺物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('540', 'yifankd', '艺凡快递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('541', 'mantoo', '优能物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('542', 'vctrans', '越中国际物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('543', 'yhtlogistics', '宇航通物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('544', 'ycgglobal', 'YCG物流', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('545', 'yidihui', '驿递汇速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('546', 'yuanhhk', '远航国际快运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('547', 'yiyou', '易邮速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('548', 'eusacn', '优莎速运', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('549', 'uhi', '优海国际速递', 'Y', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('550', 'zjs', '宅急送', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('551', 'ztky', '中铁快运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('552', 'ztwl', '中铁物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('553', 'zywl', '中邮物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('554', 'zhimakaimen', '芝麻开门', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('555', 'zhengzhoujianhua', '郑州建华', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('556', 'zhongsukuaidi', '中速快件', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('557', 'zhongtianwanyun', '中天万运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('558', 'zhongruisudi', '中睿速递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('559', 'zhongwaiyun', '中外运速递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('560', 'zengyisudi', '增益速递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('561', 'sujievip', '郑州速捷', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('562', 'ztong', '智通物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('563', 'zhichengtongda', '至诚通达快递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('564', 'zhdwl', '众辉达物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('565', 'kuachangwuliu', '直邮易', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('566', 'topspeedex', '中运全速', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('567', 'otobv', '中欧快运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('568', 'zsky123', '准实快运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('569', 'cnws', '中国翼', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('570', 'zytdscm', '中宇天地', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('571', 'zhuanyunsifang', '转运四方', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('572', 'hrbzykd', '卓烨快递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('573', 'zhuoshikuaiyun', '卓实快运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('574', 'chinaicip', '卓志速运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('575', 'ynztsy', '纵通速运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('576', 'zdepost', '直德邮', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('577', 'chinapostcb', '中邮电商', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('578', 'chunghwa56', '中骅物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('579', 'cosco', '中远e环球', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('580', 'zf365', '珠峰速运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('581', 'zhongtongkuaiyun', '中通快运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('582', 'eucnrail', '中欧国际物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('583', 'chnexp', '中翼国际物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('584', 'cccc58', '中集冷云', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('585', 'auvanda', '中联速递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('586', 'zyzoom', '增速跨境', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('587', 'zhpex', '众派速递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('588', 'byht', '展勤快递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('589', 'zhongchuan', '众川国际', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('590', 'zhonghuanus', '中环转运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('591', 'zhonghuan', '中环快递', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('592', 'uszcn', '转运中国', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('593', 'zhitengwuliu', '志腾物流', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('594', 'zsda56', '转瞬达集运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('595', 'zjgj56', '振捷国际货运', 'Z', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('596', 'jtexpress', '极兔速递', 'J', '0', '100', '1553911076', '1713261929');
INSERT INTO `ey_shop_express` VALUES ('597', 'fengwang', '丰网速运', 'F', '0', '100', '1553911076', '1713261929');

-- -----------------------------
-- Table structure for `ey_shop_freight_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_freight_template`;
CREATE TABLE `ey_shop_freight_template` (
  `template_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `express_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '关联运费模板选择的快递公司ID',
  `template_name` varchar(250) NOT NULL DEFAULT '' COMMENT '运费模板名称',
  `template_ids` text NOT NULL COMMENT '运费模板选择的地址表ID，逗号分割存入',
  `template_data` text NOT NULL COMMENT '运费模板设置的价格数据，serialize序列化存入',
  `special_set` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '运费模板特殊设置(1=不配送区域  2=只配送区域)',
  `special_ids` text NOT NULL COMMENT '运费模板特殊地址表ID，逗号分割存入',
  `special_data` text NOT NULL COMMENT '运费模板特殊设置数据，serialize序列化存入',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '运费模板是否启用(1=启用  2停用)',
  `system` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '运费模板是否系统(1=自定义  2系统)',
  `default` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '运费模板是否默认(1=默认模板  2=非默认模板)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`template_id`),
  KEY `express_id` (`express_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='运费模板表';


-- -----------------------------
-- Table structure for `ey_shop_goods_label`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_goods_label`;
CREATE TABLE `ey_shop_goods_label` (
  `label_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `label_title` varchar(60) NOT NULL DEFAULT '' COMMENT '标签标题',
  `label_pic` varchar(60) NOT NULL DEFAULT '' COMMENT '标签路径',
  `label_intro` varchar(500) NOT NULL DEFAULT '' COMMENT '标签描述',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1:启用; 2:禁用)',
  `selected` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '默认勾选(0:否; 1:是)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='商城商品服务标签';

-- -----------------------------
-- Records of `ey_shop_goods_label`
-- -----------------------------
INSERT INTO `ey_shop_goods_label` VALUES ('1', '运费险', '/test/public/static/admin/images/fuwu1.png', '卖家为您购买的商品投保退货运费险（保单生效以确认订单页展示的运费险为准）', '1', '0', '1701250984', '1714351420');
INSERT INTO `ey_shop_goods_label` VALUES ('2', '货到付款', '/test/public/static/admin/images/fuwu2.png', '支持送货上门后再收款，支持现金、POS机刷卡等方式', '1', '0', '1701250984', '1713861632');
INSERT INTO `ey_shop_goods_label` VALUES ('3', '闪电退款', '/test/public/static/admin/images/fuwu3.png', '闪电退款为会员提供的快速退款服务', '1', '0', '1701250984', '1714351421');
INSERT INTO `ey_shop_goods_label` VALUES ('4', '7天无理由退货', '/test/public/static/admin/images/fuwu4.png', '支持7天无理由退货(拆封后不支持)', '1', '0', '1701250984', '1714351422');

-- -----------------------------
-- Table structure for `ey_shop_goods_label_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_goods_label_bind`;
CREATE TABLE `ey_shop_goods_label_bind` (
  `bind_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID(archives 表 aid 字段)',
  `label_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品服务标签ID(shop_goods_label 表 label_id 字段)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`bind_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `label_id` (`label_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=332 DEFAULT CHARSET=utf8 COMMENT='商城商品服务标签与商品ID关联绑定表';

-- -----------------------------
-- Records of `ey_shop_goods_label_bind`
-- -----------------------------
INSERT INTO `ey_shop_goods_label_bind` VALUES ('305', '50', '3', '1722925397', '1722925397');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('62', '11', '1', '1719221921', '1719221921');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('63', '11', '2', '1719221921', '1719221921');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('64', '11', '3', '1719221921', '1719221921');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('65', '12', '1', '1719222644', '1719222644');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('66', '12', '2', '1719222644', '1719222644');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('67', '12', '3', '1719222644', '1719222644');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('157', '13', '3', '1719881339', '1719881339');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('156', '13', '2', '1719881339', '1719881339');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('155', '13', '1', '1719881339', '1719881339');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('71', '14', '1', '1719223020', '1719223020');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('72', '14', '2', '1719223020', '1719223020');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('73', '14', '3', '1719223020', '1719223020');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('74', '15', '1', '1719223196', '1719223196');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('75', '15', '2', '1719223196', '1719223196');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('76', '15', '3', '1719223196', '1719223196');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('77', '16', '1', '1719223363', '1719223363');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('78', '16', '2', '1719223363', '1719223363');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('79', '16', '3', '1719223363', '1719223363');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('80', '17', '1', '1719223671', '1719223671');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('81', '17', '2', '1719223671', '1719223671');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('82', '17', '3', '1719223671', '1719223671');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('83', '18', '1', '1719275500', '1719275500');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('84', '18', '2', '1719275500', '1719275500');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('85', '18', '3', '1719275500', '1719275500');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('86', '19', '1', '1719275851', '1719275851');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('87', '19', '2', '1719275851', '1719275851');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('88', '19', '3', '1719275851', '1719275851');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('89', '20', '1', '1719276245', '1719276245');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('90', '20', '2', '1719276245', '1719276245');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('91', '20', '3', '1719276245', '1719276245');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('323', '21', '3', '1722993110', '1722993110');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('322', '21', '2', '1722993110', '1722993110');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('321', '21', '1', '1722993110', '1722993110');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('95', '22', '1', '1719276941', '1719276941');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('96', '22', '2', '1719276941', '1719276941');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('97', '22', '3', '1719276941', '1719276941');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('98', '23', '1', '1719277140', '1719277140');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('99', '23', '2', '1719277140', '1719277140');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('100', '23', '3', '1719277140', '1719277140');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('101', '24', '1', '1719277677', '1719277677');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('102', '24', '2', '1719277677', '1719277677');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('103', '24', '3', '1719277677', '1719277677');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('104', '25', '1', '1719277998', '1719277998');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('105', '25', '2', '1719277998', '1719277998');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('106', '25', '3', '1719277998', '1719277998');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('107', '26', '1', '1719278567', '1719278567');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('108', '26', '2', '1719278567', '1719278567');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('109', '26', '3', '1719278567', '1719278567');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('110', '27', '1', '1719278990', '1719278990');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('111', '27', '2', '1719278990', '1719278990');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('112', '27', '3', '1719278990', '1719278990');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('113', '29', '1', '1719280595', '1719280595');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('114', '29', '2', '1719280595', '1719280595');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('115', '29', '3', '1719280595', '1719280595');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('116', '30', '1', '1719280775', '1719280775');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('117', '30', '2', '1719280775', '1719280775');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('118', '30', '3', '1719280775', '1719280775');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('281', '32', '3', '1722506522', '1722506522');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('280', '32', '2', '1722506522', '1722506522');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('279', '32', '1', '1722506522', '1722506522');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('122', '33', '1', '1719281738', '1719281738');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('123', '33', '2', '1719281738', '1719281738');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('124', '33', '3', '1719281738', '1719281738');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('125', '34', '1', '1719282064', '1719282064');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('126', '34', '2', '1719282064', '1719282064');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('127', '34', '3', '1719282064', '1719282064');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('256', '35', '4', '1722418659', '1722418659');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('255', '35', '3', '1722418659', '1722418659');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('254', '35', '1', '1722418659', '1722418659');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('331', '36', '3', '1723024958', '1723024958');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('330', '36', '2', '1723024958', '1723024958');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('327', '37', '3', '1723024350', '1723024350');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('326', '37', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('304', '50', '2', '1722925397', '1722925397');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('303', '50', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('308', '51', '3', '1722925625', '1722925625');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('307', '51', '2', '1722925625', '1722925625');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('306', '51', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('309', '52', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('310', '52', '2', '1722926111', '1722926111');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('311', '52', '3', '1722926111', '1722926111');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('312', '55', '1', '1722927578', '1722927578');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('313', '55', '2', '1722927578', '1722927578');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('314', '55', '3', '1722927578', '1722927578');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('315', '56', '1', '1722928078', '1722928078');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('316', '56', '2', '1722928078', '1722928078');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('317', '56', '3', '1722928078', '1722928078');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('318', '57', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('319', '57', '2', '1722928392', '1722928392');
INSERT INTO `ey_shop_goods_label_bind` VALUES ('320', '57', '3', '1722928392', '1722928392');

-- -----------------------------
-- Table structure for `ey_shop_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order`;
CREATE TABLE `ey_shop_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单结算分佣的分销商ID(同 weapp_dealer 表 dealer_id)',
  `dealer_users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单结算分佣的分销商会员ID(同 users 表 users_id)',
  `dealer_order` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否分销订单(0:否; 1:是;)',
  `dealer_rebate` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分销商佣金计算方式(1:订单商品合计总额; 2:订单实际支付总额;)',
  `handle_rebate` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已进行结算分佣(0:未结算分佣; 1:已结算分佣;)',
  `one_level_rebate` varchar(20) NOT NULL DEFAULT '' COMMENT '结算分佣时一级佣金比例',
  `two_level_rebate` varchar(20) NOT NULL DEFAULT '' COMMENT '结算分佣时二级佣金比例',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款(已下单)，1已付款(待发货)，2已发货(待收货)，3已完成(确认收货)，-1订单取消(已关闭)，4订单过期',
  `payment_method` tinyint(1) DEFAULT '0' COMMENT '订单支付方式，0为在线支付，1为货到付款，默认0',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `order_terminal` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单终端(1:PC; 2:H5; 3:微信小程序; 9:抖音小程序; 10:百度小程序)',
  `contains_virtual` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单是否包含虚拟商品(1=不包含、2=包含)',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '订单手动退款原因',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `express_order` varchar(50) DEFAULT '' COMMENT '发货物流单号',
  `express_name` varchar(32) DEFAULT '' COMMENT '发货物流名称',
  `express_code` varchar(32) DEFAULT '' COMMENT '发货物流code',
  `express_time` int(11) DEFAULT '0' COMMENT '发货时间',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `confirm_time` int(11) DEFAULT '0' COMMENT '收货确认时间',
  `allow_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否允许申请售后维权，0=允许申请维权，1=不允许申请维权',
  `obtain_scores` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '消费获得积分数',
  `is_obtain_scores` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '该订单是否已赠送积分，0=未赠送，1=已赠送',
  `shipping_fee` decimal(10,2) DEFAULT '0.00' COMMENT '订单运费',
  `order_total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `order_total_num` int(10) DEFAULT '0' COMMENT '订单总数',
  `is_total_amount` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否已将实际支付金额(order表order_amount字段)累加到会员累计消费金额(users表order_total_amount字段) (0:未累计; 1:已累计;)',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '收货地址',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '订单类型：0普通订单，1虚拟订单,2-核销订单(单次)',
  `virtual_delivery` text COMMENT '虚拟订单时，卖家发货给买家的回复',
  `admin_note` text COMMENT '管理员操作备注',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `user_note` text COMMENT '会员备注',
  `group` varchar(50) DEFAULT '' COMMENT '订单分组',
  `order_md5` varchar(50) DEFAULT '' COMMENT '订单标识串，删除未付款的重复订单',
  `order_source` tinyint(3) DEFAULT '10' COMMENT '10-普通订单 20-秒杀订单',
  `order_source_id` int(10) DEFAULT '0' COMMENT '来源id(秒杀订单:active_time_id)',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `use_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员的优惠券数据表ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券数据表ID',
  `coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用的优惠券金额',
  `use_coupon_data` text COMMENT '订单使用的优惠券数据',
  `verify_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '核销记录表ID(weapp_verify表)',
  `is_seckill_order` int(11) DEFAULT '0' COMMENT '是否为秒杀插件订单 0-否,是的话写入秒杀活动act_id',
  `logistics_type` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '订单物流类型(1:快递发货; 2:到店核销;)',
  `points_shop_order` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否积分订单(0:普通订单; 1:积分订单;)',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单主表';


-- -----------------------------
-- Table structure for `ey_shop_order_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_comment`;
CREATE TABLE `ey_shop_order_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `total_score` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '总评分，1：好评，2中评，3差评',
  `content` text NOT NULL COMMENT '评论内容',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '晒单图片',
  `admin_reply` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员回复',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：0否，1是',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否匿名评价：0否，1是',
  `is_new_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新版评价：0否，1是',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `details_id` (`details_id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品评价表';


-- -----------------------------
-- Table structure for `ey_shop_order_details`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_details`;
CREATE TABLE `ey_shop_order_details` (
  `details_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `product_name` varchar(100) NOT NULL DEFAULT '' COMMENT '产品名称',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '单个产品数量',
  `data` text COMMENT '序列化额外数据',
  `product_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品单价',
  `prom_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品类型：0普通产品，1虚拟产品',
  `litpic` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `apply_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否申请退换货服务：0 未申请、1已申请',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`details_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单详情表';


-- -----------------------------
-- Table structure for `ey_shop_order_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_log`;
CREATE TABLE `ey_shop_order_log` (
  `action_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `action_user` int(10) DEFAULT '0' COMMENT '操作人；0:用户操作；1以上:管理员id',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态，单条记录状态',
  `express_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '物流状态，0:未发货，1:已发货',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态，0:未支付，1:已支付',
  `action_desc` varchar(255) DEFAULT '' COMMENT '状态描述',
  `action_note` varchar(255) NOT NULL DEFAULT '' COMMENT '操作备注',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`action_id`),
  KEY `order_id` (`order_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单操作记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_service`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service`;
CREATE TABLE `ey_shop_order_service` (
  `service_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型(1:仅换货; 2:退货退款; 3:仅退款)',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `product_name` varchar(200) NOT NULL DEFAULT '' COMMENT '产品名称',
  `product_spec` varchar(200) NOT NULL DEFAULT '' COMMENT '产品规格',
  `product_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品数量',
  `product_img` varchar(500) NOT NULL DEFAULT '' COMMENT '产品图片',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '退换货描述',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '上传的图片',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '退货的收货地址',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '服务单是否被手动关闭并退款',
  `manual_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '服务单手动退款时间',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '服务单手动退款原因',
  `refund_way` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '退款方式(1:退款到余额; 2:线下退款; 3:原路退回(微信))',
  `refund_code` varchar(40) NOT NULL DEFAULT '' COMMENT '退款单号',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `refund_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退还积分',
  `refund_balance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还余额',
  `refund_reason` varchar(100) NOT NULL DEFAULT '' COMMENT '提交维权时的(退货退款 or 换货)原因',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1:审核中; 2:审核通过; 3:审核不通过; 4:已发货; 5:已收货; 6:换货完成; 7:退款完成; 8:服务取消)',
  `audit_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `refund_remark` varchar(500) NOT NULL DEFAULT '' COMMENT '退款备注',
  `users_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '会员发货信息',
  `admin_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '管理员发货信息',
  `admin_note` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员操作备注',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`service_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `order_code` (`order_code`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `details_id` (`details_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务表';


-- -----------------------------
-- Table structure for `ey_shop_order_service_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service_log`;
CREATE TABLE `ey_shop_order_service_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '服务表ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录备注',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `service_id` (`service_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_unified_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_unified_pay`;
CREATE TABLE `ey_shop_order_unified_pay` (
  `unified_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '统一支付订单ID',
  `unified_number` varchar(30) NOT NULL DEFAULT '' COMMENT '统一支付订单编号',
  `unified_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '统一支付订单应付款金额',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_ids` text NOT NULL COMMENT '合并支付的订单ID，serialize序列化存储',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '统一支付订单状态：0未付款，1已付款',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '统一支付订单时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '统一支付订单方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`unified_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单统一支付表';


-- -----------------------------
-- Table structure for `ey_shop_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attr`;
CREATE TABLE `ey_shop_product_attr` (
  `product_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=483 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_shop_product_attr`
-- -----------------------------
INSERT INTO `ey_shop_product_attr` VALUES ('459', '51', '419', '包头', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('473', '37', '433', 'TAYOHYA/多样屋', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('474', '37', '434', '80%聚酯纤维+20%聚酰胺纤维', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('475', '37', '435', '中国大陆', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('476', '37', '436', '纯色', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('477', '37', '437', '浅蓝色,粉红色,象牙白,珊瑚粉,高级灰,香槟咖,樱花粉', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('478', '37', '438', '200', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('479', '37', '439', ' TA070101275ZZ', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('480', '37', '440', '面巾', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('481', '37', '441', '通用', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('482', '37', '442', '33x75cm', '', '1', '0', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attr` VALUES ('458', '51', '418', '女', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('457', '51', '417', '春秋', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('455', '51', '415', '樱花粉,薄荷绿,茉莉紫', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('456', '51', '416', '居家拖鞋', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('454', '51', '414', '简约', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('453', '51', '413', '36,37,38', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('452', '50', '412', '情侣', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('451', '50', '411', '春秋', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('450', '50', '410', ' tt1526451zz', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('449', '50', '409', '居家拖鞋', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('448', '50', '408', '粉红色,蓝色,米黄色', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('447', '50', '407', '上海市', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('446', '50', '406', '中国大陆', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('445', '50', '405', '37,39,42', '', '1', '0', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attr` VALUES ('460', '51', '420', '棉布', '', '1', '0', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attr` VALUES ('461', '52', '421', '玫香怡人全棉四件套', '', '1', '0', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attr` VALUES ('462', '52', '422', '100%棉', '', '1', '0', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attr` VALUES ('463', '52', '423', '200*230cm', '', '1', '0', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attr` VALUES ('464', '52', '424', '40*40', '', '1', '0', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attr` VALUES ('465', '52', '425', '128*68', '', '1', '0', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attr` VALUES ('466', '52', '426', '江苏南通', '', '1', '0', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attr` VALUES ('467', '57', '427', '多样屋', '', '1', '0', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attr` VALUES ('468', '57', '428', '100%棉（除装饰外)', '', '1', '0', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attr` VALUES ('469', '57', '429', '森林物语提花趣生活毛巾系列', '', '1', '0', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attr` VALUES ('470', '57', '430', '绿色,粉色', '', '1', '0', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attr` VALUES ('471', '57', '431', '江苏昆山', '', '1', '0', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attr` VALUES ('472', '57', '432', '方巾:34*35cm、面巾:34*78cm、浴巾:78*145cm', '', '1', '0', '1722928392', '1722928392');

-- -----------------------------
-- Table structure for `ey_shop_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attribute`;
CREATE TABLE `ey_shop_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`list_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=443 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_shop_product_attribute`
-- -----------------------------
INSERT INTO `ey_shop_product_attribute` VALUES ('350', '尺寸', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('428', '材质', '0', '0', '0', '', '1', '100', '0', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attribute` VALUES ('349', '适用对象', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('348', '毛巾类别', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('347', '货号', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('345', '颜色分类', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('430', '颜色', '0', '0', '0', '', '1', '100', '0', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attribute` VALUES ('346', '产品重量[*克(g)/件]', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('344', '流行元素', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('343', '产地', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('342', '面料', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('341', '品牌', '0', '0', '0', '', '1', '100', '0', '1', '1722494835', '1722494835');
INSERT INTO `ey_shop_product_attribute` VALUES ('429', '品名', '0', '0', '0', '', '1', '100', '0', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attribute` VALUES ('427', '品牌', '0', '0', '0', '', '1', '100', '0', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attribute` VALUES ('424', '纱支', '0', '0', '0', '', '1', '100', '0', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attribute` VALUES ('425', '密度', '0', '0', '0', '', '1', '100', '0', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attribute` VALUES ('426', '产地', '0', '0', '0', '', '1', '100', '0', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attribute` VALUES ('423', '尺寸', '0', '0', '0', '', '1', '100', '0', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attribute` VALUES ('422', '材质', '0', '0', '0', '', '1', '100', '0', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attribute` VALUES ('421', '品名', '0', '0', '0', '', '1', '100', '0', '1', '1722926111', '1722926111');
INSERT INTO `ey_shop_product_attribute` VALUES ('419', '款式', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('418', '适用对象', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('417', '适用季节', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('416', '适用场地', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('415', '颜色', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('414', '风格', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('413', '鞋码', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('405', '鞋码', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('406', '产地', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('407', '省份', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('408', '颜色分类', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('409', '适用场地', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('410', '货号', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('411', '适用季节', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('412', '适用对象', '0', '0', '0', '', '1', '100', '0', '1', '1722925397', '1722925397');
INSERT INTO `ey_shop_product_attribute` VALUES ('420', '帮面材质', '0', '0', '0', '', '1', '100', '0', '1', '1722925625', '1722925625');
INSERT INTO `ey_shop_product_attribute` VALUES ('431', '产地', '0', '0', '0', '', '1', '100', '0', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attribute` VALUES ('432', '规格', '0', '0', '0', '', '1', '100', '0', '1', '1722928392', '1722928392');
INSERT INTO `ey_shop_product_attribute` VALUES ('433', '品牌', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('434', '面料', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('435', '产地', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('436', '流行元素', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('437', '颜色分类', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('438', '产品重量[*克(g)/件]', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('439', '货号', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('440', '毛巾类别', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('441', '适用对象', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');
INSERT INTO `ey_shop_product_attribute` VALUES ('442', '尺寸', '0', '0', '0', '', '1', '100', '0', '1', '1723024350', '1723024350');

-- -----------------------------
-- Table structure for `ey_shop_product_attrlist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attrlist`;
CREATE TABLE `ey_shop_product_attrlist` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '列表id',
  `list_name` varchar(60) NOT NULL DEFAULT '' COMMENT '列表名称',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `attr_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数数量',
  `desc` text NOT NULL COMMENT '描述备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '列表排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_shipping_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_shipping_template`;
CREATE TABLE `ey_shop_shipping_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID',
  `template_region` varchar(255) NOT NULL DEFAULT '' COMMENT '模板运送区域',
  `template_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '模板运费',
  `province_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'region表id',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='运费模板表';

-- -----------------------------
-- Records of `ey_shop_shipping_template`
-- -----------------------------
INSERT INTO `ey_shop_shipping_template` VALUES ('1', '北京市', '0.00', '1', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('2', '天津市', '0.00', '338', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('3', '河北省', '0.00', '636', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('4', '山西省', '0.00', '3102', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('5', '内蒙古自治区', '0.00', '4670', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('6', '辽宁省', '0.00', '5827', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('7', '吉林省', '0.00', '7531', '1554775921');
INSERT INTO `ey_shop_shipping_template` VALUES ('8', '黑龙江省', '0.00', '8558', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('9', '上海市', '0.00', '10543', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('10', '江苏省', '0.00', '10808', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('11', '浙江省', '0.00', '12596', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('12', '安徽省', '0.00', '14234', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('13', '福建省', '0.00', '16068', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('14', '江西省', '0.00', '17359', '1554775962');
INSERT INTO `ey_shop_shipping_template` VALUES ('15', '山东省', '0.00', '19280', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('16', '河南省', '0.00', '21387', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('17', '湖北省', '0.00', '24022', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('18', '湖南省', '0.00', '25579', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('19', '广东省', '0.00', '28240', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('20', '广西壮族自治区', '0.00', '30164', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('21', '海南省', '0.00', '31563', '1555483193');
INSERT INTO `ey_shop_shipping_template` VALUES ('22', '重庆市', '0.00', '31929', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('23', '四川省', '0.00', '33007', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('24', '贵州省', '0.00', '37906', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('25', '云南省', '0.00', '39556', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('26', '西藏自治区', '0.00', '41103', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('27', '陕西省', '0.00', '41877', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('28', '甘肃省', '0.00', '43776', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('29', '青海省', '0.00', '45286', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('30', '宁夏回族自治区', '0.00', '45753', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('31', '新疆维吾尔自治区', '0.00', '46047', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('32', '台湾省', '0.00', '47493', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('33', '香港特别行政区', '0.00', '47494', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('34', '澳门特别行政区', '0.00', '47495', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('35', '统一配送价格', '0.00', '100000', '1556618311');
INSERT INTO `ey_shop_shipping_template` VALUES ('36', '海外', '0.00', '47964', '1692667955');

-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='单页附加表';


-- -----------------------------
-- Table structure for `ey_site_scene_str`
-- -----------------------------
DROP TABLE IF EXISTS `ey_site_scene_str`;
CREATE TABLE `ey_site_scene_str` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `scene_str` varchar(255) DEFAULT '',
  `openid` varchar(100) DEFAULT '',
  `add_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `scene_str` (`scene_str`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='扫码公众号登录表';


-- -----------------------------
-- Table structure for `ey_sms_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_log`;
CREATE TABLE `ey_sms_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `source` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送来源，与场景ID对应：0=注册，1=绑定，2=登录密码，3=支付密码，4=找回密码',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `mobile` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '验证码',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送状态,1:成功,0:失败',
  `is_use` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用，1:是，0:否',
  `msg` varchar(255) NOT NULL DEFAULT '' COMMENT '短信内容',
  `ip` varchar(20) DEFAULT 'IP地址',
  `error_msg` text NOT NULL COMMENT '发送短信异常内容',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='手机短信发送记录';


-- -----------------------------
-- Table structure for `ey_sms_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_template`;
CREATE TABLE `ey_sms_template` (
  `tpl_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `tpl_title` varchar(128) NOT NULL DEFAULT '' COMMENT '短信标题',
  `sms_sign` varchar(50) NOT NULL DEFAULT '' COMMENT '短信签名',
  `sms_tpl_code` varchar(100) NOT NULL DEFAULT '' COMMENT '短信模板ID',
  `tpl_content` varchar(1000) NOT NULL DEFAULT '' COMMENT '发送短信内容',
  `send_scene` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '短信发送场景',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `add_time` int(11) NOT NULL COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COMMENT='手机短信发送模板';

-- -----------------------------
-- Records of `ey_sms_template`
-- -----------------------------
INSERT INTO `ey_sms_template` VALUES ('1', '1', '账号注册', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '0', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('2', '1', '手机绑定', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '1', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('3', '1', '找回密码', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '4', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('4', '1', '订单付款', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '5', '0', '1591262356', '1616460912');
INSERT INTO `ey_sms_template` VALUES ('9', '2', '账号注册', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '0', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('10', '2', '手机绑定', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '1', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('11', '2', '找回密码', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '4', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('12', '2', '订单付款', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '5', '0', '1610334638', '1616460912');
INSERT INTO `ey_sms_template` VALUES ('17', '1', '订单发货', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '6', '0', '1591262356', '1616460912');
INSERT INTO `ey_sms_template` VALUES ('19', '2', '订单发货', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '6', '0', '1610334638', '1616460912');
INSERT INTO `ey_sms_template` VALUES ('26', '1', '留言验证', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '7', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('25', '1', '账号登录', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '2', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('29', '2', '账号登录', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '2', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('30', '2', '留言验证', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '7', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('33', '1', '留言表单', '', '', '您有新的留言消息，请查收！', '11', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('35', '2', '留言表单', '', '', '您有新的留言消息，请查收！', '11', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('37', '1', '投稿提醒', '', '', '您有新的会员投稿，请查看！', '20', '0', '1591262356', '1591262356');
INSERT INTO `ey_sms_template` VALUES ('39', '2', '投稿提醒', '', '', '您有新的会员投稿，请查看！', '20', '0', '1610334638', '1610334638');
INSERT INTO `ey_sms_template` VALUES ('41', '1', '订单支付', '', '', '亲，您购买的${goods_title}已支付成功，我们会尽快为您打包，请耐心等待。', '30', '0', '1714295463', '1715589617');
INSERT INTO `ey_sms_template` VALUES ('42', '1', '订单发货', '', '', '亲，您购买的${goods_title}已发货，发货时间：${express_time}', '31', '0', '1714295463', '1714294877');
INSERT INTO `ey_sms_template` VALUES ('43', '1', '订单退款', '', '', '您的退款订单已完成，退款金额：${money}，请确认是否到账', '32', '0', '1714295463', '1714294903');
INSERT INTO `ey_sms_template` VALUES ('44', '1', '充值成功', '', '', '你已成功充值到账，充值金额：${money}，当前余额：${users_money}，如有疑问，请联系我们', '33', '0', '1714295463', '1714294955');
INSERT INTO `ey_sms_template` VALUES ('45', '1', '积分变动', '', '', '您的账户积分发生变动，积分：${score}，当前积分：${users_score}，如有疑问，请联系我们', '34', '0', '1714295463', '1714295017');
INSERT INTO `ey_sms_template` VALUES ('46', '1', '余额变动', '', '', '亲，您的账户余额发生变动，金额：${money}，当前余额：${users_money}，如有疑问，请联系我们', '35', '0', '1714295463', '1714295115');
INSERT INTO `ey_sms_template` VALUES ('47', '2', '订单支付', '', '', '', '30', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('48', '2', '订单发货', '', '', '', '31', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('49', '2', '订单退款', '', '', '', '32', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('50', '2', '充值成功', '', '', '', '33', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('51', '2', '积分变动', '', '', '', '34', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('52', '2', '余额变动', '', '', '', '35', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('53', '1', '订单付款', '', '', '您的${shop_name}店铺在${pay_time}售出${goods_title}，请尽快处理', '50', '0', '1714295463', '1714295410');
INSERT INTO `ey_sms_template` VALUES ('54', '1', '订单收货', '', '', '您的发货订单${order_code}已被签收，签收时间：${confirm_time}，请登录商家后台查看', '51', '0', '1714295463', '1714295430');
INSERT INTO `ey_sms_template` VALUES ('55', '1', '订单维权', '', '', '您的买家发起了维权申请，订单编号：${order_code}，请尽快登录商家后台处理', '52', '0', '1714295463', '1721283146');
INSERT INTO `ey_sms_template` VALUES ('56', '1', '库存预警', '', '', '监测到您店铺的${goods_title}库存不足，请及时补货~', '53', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('57', '2', '订单付款', '', '', '', '50', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('58', '2', '订单收货', '', '', '', '51', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('59', '2', '订单维权', '', '', '', '52', '0', '1714295463', '1714295463');
INSERT INTO `ey_sms_template` VALUES ('60', '2', '库存预警', '', '', '', '53', '0', '1714295463', '1714295463');

-- -----------------------------
-- Table structure for `ey_smtp_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_record`;
CREATE TABLE `ey_smtp_record` (
  `record_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，与场景ID对应：0=默认，2=注册，3=绑定邮箱，4=找回密码',
  `email` varchar(50) DEFAULT '' COMMENT '邮件地址',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `code` varchar(20) DEFAULT '' COMMENT '发送邮件内容',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否使用，默认0，0为未使用，1为使用',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`record_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='邮件发送记录表';

-- -----------------------------
-- Records of `ey_smtp_record`
-- -----------------------------
INSERT INTO `ey_smtp_record` VALUES ('1', '3', '49770271@qq.com', '2', '8823', '1', '1721093234', '1721093240');

-- -----------------------------
-- Table structure for `ey_smtp_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_tpl`;
CREATE TABLE `ey_smtp_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '邮件发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='邮件模板表';

-- -----------------------------
-- Records of `ey_smtp_tpl`
-- -----------------------------
INSERT INTO `ey_smtp_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请查收！', '${content}', '1', '0', '1544763495', '1552638302');
INSERT INTO `ey_smtp_tpl` VALUES ('2', '会员注册', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '2', '0', '1544763495', '1552667056');
INSERT INTO `ey_smtp_tpl` VALUES ('3', '绑定邮箱', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '3', '0', '1544763495', '1552667400');
INSERT INTO `ey_smtp_tpl` VALUES ('4', '找回密码', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '4', '0', '1544763495', '1552663577');
INSERT INTO `ey_smtp_tpl` VALUES ('9', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '0', '1587364685', '1616460912');
INSERT INTO `ey_smtp_tpl` VALUES ('11', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '0', '1616460912', '1616460912');
INSERT INTO `ey_smtp_tpl` VALUES ('12', '投稿提醒', '您有新的投稿文档，请及时查看！', '${content}', '20', '0', '1544763495', '1552667056');
INSERT INTO `ey_smtp_tpl` VALUES ('13', '订单支付', '亲，您购买的${goods_title}已支付成功，我们会尽快为您打包，请耐心等待。', '${content}', '30', '0', '1715589621', '1715589621');
INSERT INTO `ey_smtp_tpl` VALUES ('14', '订单发货', '亲，您购买的${goods_title}已发货，发货时间：${express_time}。', '${content}', '31', '0', '1715589621', '1714286313');
INSERT INTO `ey_smtp_tpl` VALUES ('15', '订单退款', '亲，您的退款订单已完成，退款金额：${money}，请确认是否到账。', '${content}', '32', '0', '1715589621', '1714291758');
INSERT INTO `ey_smtp_tpl` VALUES ('16', '充值成功', '亲，你已成功充值到账，充值金额：${money}，查看详情。', '${content}', '33', '0', '1715589621', '1714291861');
INSERT INTO `ey_smtp_tpl` VALUES ('17', '积分变动', '亲，您的账户积分发生变动，增加或减少积分：${scores}，查看详情。', '${content}', '34', '0', '1715589621', '1714292094');
INSERT INTO `ey_smtp_tpl` VALUES ('18', '余额变动', '亲，您的账户余额发生变动，增加或减少金额：${money}，查看详情。', '${content}', '35', '0', '1715589621', '1714292269');
INSERT INTO `ey_smtp_tpl` VALUES ('19', '订单付款', '您的${shop_name}店铺在${pay_time}售出${goods_title}，请尽快处理', '${content}', '50', '0', '1715589621', '1714292668');
INSERT INTO `ey_smtp_tpl` VALUES ('20', '订单收货', '您的发货订单${order_code}已被签收，签收时间：${confirm_time}，请登录商家后台查看', '${content}', '51', '0', '1715589621', '1714292852');
INSERT INTO `ey_smtp_tpl` VALUES ('21', '订单维权', '您的买家发起了维权申请，订单编号：${order_code}，请尽快登录商家后台处理', '${content}', '52', '0', '1715589621', '1714293865');
INSERT INTO `ey_smtp_tpl` VALUES ('22', '库存预警', '监测到您店铺的${goods_title}库存不足，请及时补货~', '${content}', '53', '0', '1715589621', '1714293965');

-- -----------------------------
-- Table structure for `ey_special_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_content`;
CREATE TABLE `ey_special_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专题附加表';


-- -----------------------------
-- Table structure for `ey_special_node`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_node`;
CREATE TABLE `ey_special_node` (
  `node_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '节点名称',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '节点标识',
  `isauto` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动获取文档',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字（多个中间用'',''分开）',
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `aidlist` text NOT NULL COMMENT '关联文章列表（多个中间用'',''分开）',
  `row` int(5) NOT NULL DEFAULT '10' COMMENT '文档数',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专题节点表';


-- -----------------------------
-- Table structure for `ey_statistics_data`
-- -----------------------------
DROP TABLE IF EXISTS `ey_statistics_data`;
CREATE TABLE `ey_statistics_data` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` int(10) DEFAULT '0',
  `num` int(10) DEFAULT '0',
  `type` mediumint(8) DEFAULT '1' COMMENT '1-浏览量 2-订单 3-销售额 4-新增会员 5-充值金额 6-商品数 7-文章数 8-tag数 9-待审数',
  `total` decimal(8,2) DEFAULT '0.00' COMMENT 'type=3/5用',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 COMMENT='商城欢迎页主题的统计表';

-- -----------------------------
-- Records of `ey_statistics_data`
-- -----------------------------
INSERT INTO `ey_statistics_data` VALUES ('1', '1715529600', '100', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('2', '1715529600', '10', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('3', '1715529600', '0', '3', '0.08');
INSERT INTO `ey_statistics_data` VALUES ('4', '1715616000', '5', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('5', '1718899200', '6', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('6', '1719158400', '57', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('7', '1719158400', '2', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('8', '1719158400', '0', '3', '100.01');
INSERT INTO `ey_statistics_data` VALUES ('9', '1719158400', '7', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('10', '1719244800', '20', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('11', '1719244800', '68', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('12', '1719244800', '8', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('13', '1719244800', '0', '3', '250.05');
INSERT INTO `ey_statistics_data` VALUES ('14', '1719331200', '17', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('15', '1719417600', '43', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('16', '1719417600', '5', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('17', '1719417600', '0', '3', '38.03');
INSERT INTO `ey_statistics_data` VALUES ('18', '1719504000', '76', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('19', '1719763200', '286', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('20', '1719763200', '14', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('21', '1719763200', '0', '3', '38.13');
INSERT INTO `ey_statistics_data` VALUES ('22', '1719849600', '95', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('23', '1719849600', '11', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('24', '1719849600', '0', '3', '0.11');
INSERT INTO `ey_statistics_data` VALUES ('25', '1719936000', '96', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('26', '1720022400', '31', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('27', '1720022400', '3', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('28', '1720022400', '0', '3', '277.94');
INSERT INTO `ey_statistics_data` VALUES ('29', '1720108800', '18', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('30', '1720108800', '6', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('31', '1720108800', '0', '3', '295.01');
INSERT INTO `ey_statistics_data` VALUES ('32', '1720195200', '2', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('33', '1720368000', '5', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('34', '1720627200', '2', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('35', '1720972800', '3', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('36', '1721059200', '4', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('37', '1721059200', '0', '3', '76.02');
INSERT INTO `ey_statistics_data` VALUES ('38', '1721232000', '1', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('39', '1721664000', '14', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('40', '1721750400', '2', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('41', '1721750400', '10', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('42', '1721836800', '3', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('43', '1721923200', '74', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('44', '1721923200', '2', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('45', '1721923200', '0', '3', '117.00');
INSERT INTO `ey_statistics_data` VALUES ('46', '1722182400', '49', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('47', '1722182400', '15', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('48', '1722182400', '0', '3', '4658.83');
INSERT INTO `ey_statistics_data` VALUES ('49', '1722268800', '26', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('50', '1722268800', '4', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('51', '1722268800', '0', '3', '368.05');
INSERT INTO `ey_statistics_data` VALUES ('52', '1722268800', '1', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('53', '1722355200', '14', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('54', '1722355200', '0', '3', '4153.16');
INSERT INTO `ey_statistics_data` VALUES ('55', '1722355200', '1', '4', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('56', '1722355200', '49', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('57', '1722355200', '2', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('58', '1722441600', '78', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('59', '1722441600', '4', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('60', '1722441600', '13', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('61', '1722441600', '0', '3', '40151.67');
INSERT INTO `ey_statistics_data` VALUES ('62', '1722528000', '3', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('63', '1722787200', '18', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('64', '1722787200', '-8', '4', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('65', '1722787200', '4', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('66', '1722787200', '0', '3', '174.62');
INSERT INTO `ey_statistics_data` VALUES ('67', '1722873600', '58', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('68', '1722873600', '5', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('69', '1722873600', '0', '3', '0.04');
INSERT INTO `ey_statistics_data` VALUES ('70', '1722873600', '8', '6', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('71', '1722960000', '178', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('72', '1722960000', '8', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('73', '1722960000', '0', '3', '109.06');
INSERT INTO `ey_statistics_data` VALUES ('74', '1723046400', '33', '1', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('75', '1723046400', '13', '2', '0.00');
INSERT INTO `ey_statistics_data` VALUES ('76', '1723046400', '0', '3', '234.11');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'tagid',
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `count` int(10) unsigned DEFAULT '0' COMMENT '点击',
  `total` int(10) unsigned DEFAULT '0' COMMENT '文档数',
  `weekcc` int(10) unsigned DEFAULT '0' COMMENT '周统计',
  `monthcc` int(10) unsigned DEFAULT '0' COMMENT '月统计',
  `weekup` int(10) unsigned DEFAULT '0' COMMENT '每周更新',
  `monthup` int(10) unsigned DEFAULT '0' COMMENT '每月更新',
  `is_common` tinyint(1) DEFAULT '0' COMMENT '是否常用标签，0=否，1=是',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE,
  KEY `lang` (`add_time`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标签索引表';


-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'tagid',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';


-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(200) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `idcode` varchar(50) DEFAULT '' COMMENT '页面唯一id标识（由 标识符+栏目id或文档id等）组成',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='可视化参数设置';


-- -----------------------------
-- Table structure for `ey_uploads`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads`;
CREATE TABLE `ey_uploads` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) NOT NULL DEFAULT '0' COMMENT '分组ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(500) DEFAULT '' COMMENT '文档标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(500) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` int(11) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `users_id` int(11) DEFAULT '0' COMMENT '用户ID',
  `sort_order` smallint(5) DEFAULT '100' COMMENT '排序',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1已删除 0未删除',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `add_time` (`add_time`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传记录表';


-- -----------------------------
-- Table structure for `ey_uploads_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads_type`;
CREATE TABLE `ey_uploads_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_type` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传分组表';


-- -----------------------------
-- Table structure for `ey_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users`;
CREATE TABLE `ey_users` (
  `users_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `username` varchar(30) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '登录密码',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `is_mobile` tinyint(1) DEFAULT '0' COMMENT '绑定手机号，0为不绑定，1为绑定',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号码（仅用于登录）',
  `is_email` tinyint(1) DEFAULT '0' COMMENT '绑定邮箱，0为不绑定，1为绑定',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT '电子邮件（仅用于登录）',
  `paypwd` varchar(255) DEFAULT '' COMMENT '支付密码，暂时未用到，可保留。',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '用户金额',
  `frozen_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `is_dealer` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '会员是否成为分销商(0:未成为分销商; 1:已成为分销商;)',
  `parent_users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级分销商会员ID',
  `parent_dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级分销商ID',
  `top_users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '顶级分销商会员ID',
  `top_dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '顶级分销商ID',
  `bind_dealer_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '绑定分销商的时间',
  `scores` int(10) DEFAULT '0' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值',
  `reg_time` int(11) unsigned DEFAULT '0' COMMENT '注册时间',
  `reg_ip_val` varchar(15) DEFAULT '' COMMENT '用户注册时的IP地址 (IP值)',
  `reg_ip_text` varchar(50) DEFAULT '' COMMENT '用户注册时的IP地址 (中文)',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_count` int(11) DEFAULT '0' COMMENT '登陆次数',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `province` int(6) DEFAULT '0' COMMENT '省份',
  `city` int(6) DEFAULT '0' COMMENT '市区',
  `district` int(6) DEFAULT '0' COMMENT '县',
  `level` smallint(5) DEFAULT '0' COMMENT '会员等级',
  `open_level_time` int(11) unsigned DEFAULT '0' COMMENT '开通会员级别时间',
  `level_maturity_days` varchar(20) DEFAULT '' COMMENT '会员级别到期天数',
  `discount` decimal(10,2) DEFAULT '1.00' COMMENT '会员折扣，默认1不享受',
  `total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费累计额度',
  `order_total_amount` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '订单累计总额，用于会员自动升级。',
  `is_activation` tinyint(1) DEFAULT '1' COMMENT '是否激活，0否，1是。\r\n后台注册默认为1激活。\r\n前台注册时，当会员功能设置选择后台审核，需后台激活才可以登陆。',
  `register_place` tinyint(1) DEFAULT '2' COMMENT '注册位置。后台注册不受注册验证影响，1为后台注册，2为前台注册。默认为2。',
  `open_id` varchar(50) NOT NULL DEFAULT '' COMMENT '第三方唯一标识openid',
  `thirdparty` tinyint(1) DEFAULT '0' COMMENT '第三方注册类型 0=普通, 1=微信, 2=QQ, 3=手机号, 4=微信小程序， 5=微站点, 6-微信公众号, 7-百度小程序, 8-抖音小程序',
  `is_lock` tinyint(1) DEFAULT '0' COMMENT '是否被锁定冻结',
  `admin_id` int(10) DEFAULT '0' COMMENT '关联管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `unread_notice_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '未读消息数量',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `sex` varchar(10) DEFAULT '保密' COMMENT '性别- 男,女,保密',
  `coin` int(11) unsigned DEFAULT '0' COMMENT '金币',
  `union_id` varchar(50) NOT NULL DEFAULT '' COMMENT '微信用户的unionId',
  `source` tinyint(3) DEFAULT '1' COMMENT '会员来源(1:PC端; 2:H5; 3:微信公众号; 4:微信小程序; 5:百度小程序; 6:抖音小程序)',
  PRIMARY KEY (`users_id`),
  KEY `union_id` (`union_id`) USING BTREE,
  KEY `username` (`username`) USING BTREE,
  KEY `mobile` (`mobile`) USING BTREE,
  KEY `open_id` (`open_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员信息表';


-- -----------------------------
-- Table structure for `ey_users_agreement`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_agreement`;
CREATE TABLE `ey_users_agreement` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` int(10) DEFAULT '0' COMMENT '1=注册协议，2=隐私协议',
  `title` varchar(100) DEFAULT '' COMMENT '协议标题',
  `content` longtext COMMENT '协议内容',
  `update_time` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='注册会员的协议';

-- -----------------------------
-- Records of `ey_users_agreement`
-- -----------------------------
INSERT INTO `ey_users_agreement` VALUES ('1', '1', '隐私协议', '&lt;section class=&quot;ey-show animsition&quot;&gt;&lt;div class=&quot;container&quot;&gt;&lt;div class=&quot;row&quot;&gt;&lt;div class=&quot;col-md-10 col-md-offset-1&quot;&gt;&lt;div class=&quot;ey-editor lazyload clearfix&quot;&gt;&lt;div class=&quot;editorlightgallery&quot;&gt;&lt;p&gt;&lt;a href=&quot;https://www.eyoucms.com/&quot; target=&quot;_blank&quot;&gt;易优cms&lt;/a&gt;用户隐私政策&lt;/p&gt;&lt;p&gt;更新时间：2021年 11 月 22 日&lt;/p&gt;&lt;p&gt;海口快推科技有限公司-易优CMS（以下简称“我们”）深知个人信息对您的重要性，并会尽全力保护您的个人信息安全可靠。我们致力于维持您对我们的信任，恪守以下原则，保护您的个人信息：权责一致原则、目的明确原则、选择同意原则、最少够用原则、确保安全原则、主体参与原则、公开透明原则等。同时，我们承诺，我们将按业界成熟的安全标准，采取相应的安全保护措施来保护您的个人信息。因此我们希望您可以仔细阅读、基于您的充分理解，以明确的方式，做出您认可的真实意思表示。&lt;/p&gt;&lt;p&gt;请在使用我们的产品（或服务）前，仔细阅读和完全理解本政策后选择是否同意本政策的内容。如您已明确表示不同意本政策，我们将不会按照本政策的规定对您的个人信息以收集、保存等形式处理，但请您知悉，这将影响您正常使用我们的产品和/或服务；如您使用或继续使用我们的产品和/或服务，或在我们更新本隐私政策后（我们会在每次更新时作出提示）选择“我已阅读并同意”或继续使用我们的产品/服务，即意味着您同意本隐私政策及其更新内容，并且同意授权我们按照本隐私政策收集、处理和保护您的信息。其中，与您的权益可能存在重大关系的条款我们已用加粗等形式予以提示，请特别关注。&lt;/p&gt;&lt;p&gt;如您不具备完全民事行为能力，请您在监护人陪同下仔细阅读，充分理解本隐私政策，并征得监护人的同意后使用我们的服务或向我们提供信息；特别是，如果您为儿童，我们将为儿童提供更高水平的个人信息保护，请儿童及监护人详细查看&lt;a href=&quot;https://www.eyoucms.com/about/etbhgz/&quot; target=&quot;_self&quot;&gt;《易优CMS儿童个人信息保护规则》&lt;/a&gt; ，并由监护人决定是否同意。&lt;/p&gt;&lt;p&gt;名词解释&lt;/p&gt;&lt;p&gt;除非另有约定，本隐私政策中使用到的名词，通常仅具有以下定义：&lt;/p&gt;&lt;p&gt;1.\r\n 个人信息（出自于GB/T 35273-2020《信息安全技术 \r\n个人信息安全规范》）：是指以电子或者其他方式记录的能够单独或者与其他信息结合识别特定自然人身份或者反映特定自然人活动情况的各种信息。本隐私政策中涉及的个人信息包括自然人的基本资料（包括个人姓名、生日、性别、住址、个人电话号码、电子邮箱地址）、个人身份信息（包括身份证件号码）、个人生物识别信息（包括指纹、面部特征）、网络身份标识信息（包括系统账号、IP地址、个人数字证书等）、个人财产信息（包括银行账号、口令、交易和消费记录、虚拟货币、虚拟交易、兑换码等虚拟财产信息）、通讯录信息、个人上网记录（包括网站浏览记录、软件使用记录、使用中的软件列表）、个人常用设备信息（包括硬件序列号、硬件型号、设备MAC地址、操作系统类型、软件列表、唯一设备识别码）、个人位置信息（包括大概地理位置、精准定位信息）。我们实际具体收集的个人信息种类以下文描述为准。&lt;/p&gt;&lt;p&gt;2.\r\n 个人敏感信息（出自于GB/T 35273-2020《信息安全技术 \r\n个人信息安全规范》）：是指一旦泄露、非法提供或滥用可能危害人身和财产安全，极易导致个人名誉、身心健康受到损害或歧视性待遇等的个人信息。本隐私政策中涉及的个人敏感信息包括您的个人财产信息、个人身份信息、个人生物识别信息、网络身份标识信息、通讯录信息、精准定位信息、收货地址。我们实际具体收集的个人敏感信息种类以下文涉及为准。&lt;/p&gt;&lt;p&gt;3. 设备：是指可用于访问我们的产品和/或服务的装置，例如台式计算机、笔记本电脑、平板电脑或智能手机。&lt;/p&gt;&lt;p&gt;4.\r\n 唯一设备识别码（专属ID或UUID）：是指由设备制造商编入到设备中的一串字符，可用于以独有方式标识相应设备（如IMEI/android \r\nID/IDFA/OpenUDID/GUID/SIM卡IMSI信息等）。唯一设备识别码有多种用途，其中可在不能使用Cookie（例如在移动应用程序中）时用以提供广告。&lt;/p&gt;&lt;p&gt;5. IP地址：每台上网的设备都会指定一个编号，称为互联网协议(IP)地址。这些编号通常都是根据地理区域指定的。IP地址通常可用于识别设备连接至互联网时所在的位置。&lt;/p&gt;&lt;p&gt;6. SSL：SSL（Secure Socket Layer）又称为安全套接层，是在传输通信协议（TCP/IP）上实现的一种安全协议。SSL支持各种类型的网络，同时提供三种基本的安全服务，均通过使用公开密钥和对称密钥技术以达到信息保密的效果。&lt;/p&gt;&lt;p&gt;7.\r\n \r\nCookie：Cookie是包含字符串的小文件，在您登入和使用网站或其他网络内容时发送、存放在您的计算机、移动设备或其他装置内（通常经过加密）。Cookie同类技术是可用于与Cookie类似用途的其他技术，例如：Web\r\n Beacon、Proxy、嵌入式脚本等。&lt;/p&gt;&lt;p&gt;8. 账号：当您注册账号并向我们提供一些个人信息，您就可以更好的使用我们的服务。当您访问易优CMS时，系统会利用这些账号信息对您进行身份验证，以防止未经授权的人员访问您的账号。&lt;/p&gt;&lt;p&gt;9. 匿名化：是指通过对个人信息的技术处理，使得个人信息主体无法被识别或者关联，且处理后的信息不能被复原的过程。&lt;/p&gt;&lt;p&gt;10. 去标识化：是指通过对个人信息的技术处理，使其在不借助额外信息的情况下，无法识别或关联个人信息主体的过程。&lt;/p&gt;&lt;p&gt;11. 服务器日志：通常情况下，我们的服务器会自动记录您在访问网站时所发出的网页请求。这些“服务器日志”通常包括您的网络请求、互联网协议地址、浏览器类型、浏览器语言、请求的日期和时间及可以唯一识别您的浏览器的一个或多个Cookie。&lt;/p&gt;&lt;p&gt;本《隐私政策》将帮助您了解我们如何收集、处理和保护您的信息；帮您了解查询、访问、更正、删除、撤回授权个人信息及注销账号的方式，您可通过以下摘要，了解本《隐私政策》的重点内容：&lt;/p&gt;&lt;p&gt;一、我们如何收集和使用您的个人信息&lt;/p&gt;&lt;p&gt;二、我们如何使用 Cookie 和同类技术&lt;/p&gt;&lt;p&gt;三、我们如何共享、转让、披露您的个人信息&lt;/p&gt;&lt;p&gt;四、我们对您个人信息的存储与保护&lt;/p&gt;&lt;p&gt;五、您的权利&lt;/p&gt;&lt;p&gt;六、我们如何处理未成年人的个人信息&lt;/p&gt;&lt;p&gt;七、您的个人信息如何在全球范围转移&lt;/p&gt;&lt;p&gt;八、本隐私权政策的修订和更新&lt;/p&gt;&lt;p&gt;九、联系我们&lt;/p&gt;&lt;p&gt;十、争议解决&lt;/p&gt;&lt;p&gt;一、我们如何收集和使用您的个人信息&lt;/p&gt;&lt;p&gt;个人信息是指以电子或者其他方式记录的能够单独或者与其他信息结合识别特定自然人身份或者反映特定自然人活动情况的各种信息。易优CMS依据法律法规以及遵循正当、合法、必要的原则而收集和使用您在使用服务过程中主动提供或由于产品和/或服务需要而产生的个人信息。如果我们欲将您的个人信息用于本隐私政策未载明的其它用途，或基于特定目的将收集而来的信息用于其他目的，我们会及时以合理的方式向您告知，并在使用前再次征得您的同意。&lt;/p&gt;&lt;p&gt;我们仅会出于本政策所述的以下场景中，收集和使用您的个人信息：&lt;/p&gt;&lt;p&gt;1、注册账号/快捷登录&lt;/p&gt;&lt;p&gt;（1）手机号注册/快捷登录：当您使用手机号注册/快捷登录易优CMS时，您需要向易优CMS提供手机号，手机号作为您的初始用户名，您可以在您的后台账户管理中进行修改。在此过程中，基于我们与通信运营商的合作，经过您的明示同意，运营商会将您的手机验证码发送给我们，便于我们为您提供快捷的登录服务；&lt;/p&gt;&lt;p&gt;我们收集该类信息是为了：完成注册程序、提供快捷登录功能；为您持续稳定提供专属于注册用户的产品和/或服务；实现您的管理账户，您可以查看您的收藏、会员管理、客户管理、设备管理等内容，并不会因为设备更换而丢失；保护您的账号安全。&lt;/p&gt;&lt;p&gt;您应知悉，手机号码和验证码匹配结果属于您的个人敏感信息，我们收集该类信息是为了满足相关法律法规及政策要求，您可以拒绝提供，但若您拒绝提供可能导致您无法使用我们的手机号注册/快捷登录功能，进而影响您使用专属于注册用户的部分基础服务，但不影响您以其他方式登陆或以游客身份浏览易优CMS页面，请您谨慎考虑后再提供。&lt;/p&gt;&lt;p&gt;（2）通过第三方社交账号登录和绑定：您可以使用第三方社交账号（微信、QQ、微博）登录易优CMS，如果您决定授权上述第三方社交账号登录易优CMS，第三方平台会同步您的头像、昵称、身份验证信息（具体以您的授权第三方社交平台的个人信息为准）给我们，您可以在后台账户管理中进行修改，未经您同意不会用作其他用途；&lt;/p&gt;&lt;p&gt;我们收集该类信息是为了实现通过第三方社交账号在易优CMS的登录、并同易优CMS用户账号进行绑定的功能，如您拒绝提供或授权第三方社交账号登录，将无法使用第三方社交账登录和绑定易优CMS账户，但不影响您直接通过手机号注册/快捷登录。第三方社交账号结合身份验证信息属于您的个人敏感信息，请您谨慎考虑后再提供。&lt;/p&gt;&lt;p&gt;2、商品展示、个性化推荐、发送促销营销信息。&lt;/p&gt;&lt;p&gt;（1）当您成为易优CMS的注册用户，在使用我们产品和/或服务过程中，为识别账号异常状态、了解产品适配性、向您提供更契合您需求的商品页面展示，我们根据您使用产品和/或服务的具体操作会收集、储存您的一些个人信息，这些信息包括：&lt;/p&gt;&lt;p&gt;【日志信息】：当您使用我们的服务时，我们可能会自动收集您对我们服务的详细使用情况，作为有关网络日志保存。日志信息包括您的登录账号、访问日期和时间、IP地址、设备信息、网络环境、网络运营商的信息、您访问的浏览记录、您的下载使用记录、操作系统信息软件安装信息、搜索引擎营销信息等您在使用我们的产品或服务时提供、形成或留存的信息。&lt;/p&gt;&lt;p&gt;【设备信息】：我们可能会根据您在软件安装及使用中授予的具体权限，接收并记录您所使用的设备名称、设备型号、操作系统版本、设备设置、唯一设备标识符、设备环境、移动应用列表等软硬件特征信息、设备所在位置相关信息（包括您授权的GPS位置以及WLAN接入点、蓝牙和基站等传感器信息）。&lt;/p&gt;&lt;p&gt;本项场景/功能涵盖的信息为我们产品和/或服务的基础功能的必要信息，如您拒绝提供上述信息和/或权限将可能导致您无法使用我们的产品与服务，但不影响您使用我们为您提供的其他产品和服务。请注意，单独的设备信息、日志信息是无法识别特定自然人身份的信息。如果我们将这类非个人信息与其他信息结合用于识别特定自然人身份，或者将其与个人信息结合使用，则在结合使用期间，这类非个人信息将被视为个人信息，除取得您授权或法律法规另有规定外，我们会将该类个人信息做匿名化、去标识化处理。这些信息在结合使用期间，将作为您的个人信息按照本隐私政策处理与保护。&lt;/p&gt;&lt;p&gt;（2）商品或服务的推送功能非易优CMS的基础产品和/或服务，仅作为易优CMS进一步优化用户体验向您额外提供的服务，为了进一步贴合您的服务需求，在此过程中，我们将收集您的浏览及搜索记录、收藏信息、设备信息、位置信息、订单信息、手机号码。&lt;/p&gt;&lt;p&gt;我们可能会基于上述一项或几项信息的结合，进行推荐算法建模、程序化广告推荐算法建模、用户行为分析及用户画像，以帮助我们更加了解您如何使用我们的产品与/或服务、维护和改进我们的产品与/或服务或向您提供个性化服务/定向推送，包括我们向您提供相关个性化信息（我们的个性化信息可能会根据信息系统、算法在内的自动化决策机制做出）；我们也可能基于特征标签通过短信、应用内推送向您发送营销信息，提供或推广的商品和服务，包括：功能更新提醒服务、产品/服务新上提醒服务、应用软件和服务及其他社资讯服务；及第三方商品和服务，包括：互联网服务、物流服务、广告服务，以及我们认为可能与您相关的其他商品和服务。&lt;/p&gt;&lt;p&gt;如您不同意授权我们收集上述信息，并不会影响您使用易优CMS的基础产品与服务，如您不希望使用该类个性化推荐服务，您可以通过以下方式进行自主关闭：您可以通过直接点击推送内容的关闭按钮进行关闭；您可通过短信提示回复退订关闭我们的短信推送。&lt;/p&gt;&lt;p&gt;3、分享功能&lt;/p&gt;&lt;p&gt;当您在使用我们的部分产品和/或服务中时，除注册登录账户之外，您可能会主动分享交流而产生互动信息。我们会自动收集您的上述信息，并展示您的昵称、头像、分享的信息内容。特别的，分享功能基于您的明确授权同意，我们将唤醒您的QQ、QQ空间和微博，您可以自行决定使用您的QQ、微博进行图片和链接的分享，此功能为我们接入第三方软件开发工具包所开发的功能，如您拒绝唤醒该功能，您将无法使用分享功能，但不影响您其他功能的正常使用。&lt;/p&gt;&lt;p&gt;我们收集上述信息以实现所具备的功能，如果您不同意我们收集上述信息，您将无法使用部分产品和/或服务包含的互动功能，但不影响您使用我们为您提供的其他产品和服务。&lt;/p&gt;&lt;p&gt;特别希望您注意，在互动分享过程中请您妥善保护自己的个人信息，避免发布您的个人隐私，请您更加谨慎地考虑，是否在使用我们的服务时披露甚至公开分享您的个人信息。如您发现自己的个人信息泄露或您提供的内容涉及他人个人信息或隐私时，尤其是您的账户存在异常，请您立即联系易优CMS官方客服，以便我们及时采取措施。&lt;/p&gt;&lt;p&gt;4、商品交易&lt;/p&gt;&lt;p&gt;仅当您在我们的产品和/或服务中产生购买/积分兑换商品或服务行为时，我们将根据您的购买/兑换行为及购买/兑换的内容收集如下部分或全部的个人信息：交易商品或服务信息、收货人信息（收货人姓名、收货地址及其联系电话）、交易金额、下单时间、订单商户、订单编号、订单状态、支付方式（此功能为我们接入第三方软件开发工具包所开发的功能）、支付账号、支付状态。我们收集上述信息是为了帮助您顺利完成交易、保障您的交易安全、查询订单信息、提供客户服务等。&lt;/p&gt;&lt;p&gt;如果您拒绝我们收集上述信息，将无法在我们的产品和/或服务中购买/兑换商品和/或服务，但不影响您使用我们提供的其他产品和/或服务。&lt;/p&gt;&lt;p&gt;因您购买的商品/兑换可能系第三方卖家提供，或商品配送可能需要第三方物流完成的，为了顺利、安全、准确向您完成货物的交付及配送，商家及物流公司在发货及配送环节内不可避免地会获知您的相关配送信息。我们向您承诺，我们会以最大努力保障您的个人信息安全，我们会严格要求商家及第三方配送公司对您的个人信息保密，只以配送之目的获悉和使用，不得对外泄露或做其他任何用途。&lt;/p&gt;&lt;p&gt;5、支付功能&lt;/p&gt;&lt;p&gt;当您在我们客户端上开通服务、订购商品等发生支付行为时，需要用到支付功能。在支付过程中，我们可能会收集您的第三方支付渠道的user\r\n ID (例如支付宝user ID、微信open \r\nID信息)。上述信息为我们向您提供您购买商品和/或服务所必须的信息，我们无法仅根据该信息获得您的个人财产信息，也不能识别特定自然人身份信息。如果您不同意我们收集上述信息，您将无法使用部分产品和/或服务包含的支付功能，但不影响您使用我们为您提供的其他产品和服务。&lt;/p&gt;&lt;p&gt;6、搜索功能&lt;/p&gt;&lt;p&gt;当您在我们的产品中使用搜索功能时，我们需要收集您的一些信息，其中包括如下个人信息：您的设备信息、您的日志信息，包括您搜索的字或词、您的浏览记录和时间、您搜索的时间以及次数。我们收集这些信息是为了向您快速匹配您所需要的内容以及您可能感兴趣的内容，同时亦为了改进我们的产品和服务。&lt;/p&gt;&lt;p&gt;7、客户服务&lt;/p&gt;&lt;p&gt;当您向易优CMS发起投诉、申诉或进行咨询时，为了您的账号与系统安全，我们可能需要您先行提供账号信息，并与您之前的个人信息相匹配以验证您的用户身份。同时，为了方便与您联系或帮助您解决问题，我们可能还需要您提供姓名、手机号码、电子邮件及其他联系方式等个人信息。另外，我们还会收集您与我们的沟通信息（包括文字/图片/音视频/通话记录形式）、与您的需求相关联的其他必要信息。我们收集这些信息是为了调查事实与帮助您解决问题，如您拒绝提供上述信息，我们可能无法向您及时反馈投诉、申诉或咨询结果。&lt;/p&gt;&lt;p&gt;8、电子签约&lt;/p&gt;&lt;p&gt;（1）您使用我们的部分产品、服务和/或向我们提供原创作品前，需通过在线电子签约系统完成电子签约，在使用在线电子签约系统时，依据相关法律法规，我们需要收集您的个人身份信息、个人生物识别信息以及个人财产信息，包括如下：电子合同文本、签署方信息（签署方姓名、住址及其联系电话）、签署方的身份证号码、面部识别特征、银行账户。此外，我们也可能会再收集一些其他与电子签约相关的信息，包括：合同金额、合同期限、签约时间、合同编号、合同状态、支付方式、支付流水号、支付状态，我们收集这些信息是为了帮助您顺利完成电子签约、保障您的签约安全、查询合同信息、提供合同管理服务等。&lt;/p&gt;&lt;p&gt;（2）您使用在线电子签约系统时，为了完成实名认证服务，我们将依据相关法律法规，根据不同的认证方式按需向在线电子签约系统供应商提供您的个人身份信息、个人生物识别信息以及个人财产信息，包括如下：签署方信息（签署方姓名、联系电话）、签署方的身份证号码、面部识别特征、银行账户；为了准确验证您的身份，在线电子签约系统供应商需将上述信息提供给合法存有您个人信息的第三方机构（有关政府部门、电信运营商、中国银联、支付宝）进行比对核验。我们向您承诺，我们会以最大努力保障您的个人信息安全，严格要求在线电子签约系统供应商对您的个人信息保密，只以实名认证之目的获悉和使用，不得对无关方泄露或做其他任何用途。&lt;/p&gt;&lt;p&gt;9、实名认证&lt;/p&gt;&lt;p&gt;（1）您使用我们的部分产品与/或服务时，需要根据相关法律规定以及我们的指引完成实名认证程序，您也可自行通过【账户主页-实名认证】页面使用实名认证服务。为了完成实名认证服务，我们将依据相关法律法规获取您的个人身份信息、个人生物识别信息等，包括如下：姓名、身份证件号码、面部识别特征。为了准确验证您的身份，我们需将上述信息传输给合法存有您个人信息的第三方机构（有关政府部门）进行比对核验。我们向您承诺，上述信息仅用于实名认证之目的，完成身份核验后将立即自行并要求第三方机构予以删除；但是，为了履行存储注册信息义务，我们将存储您的姓名、身份证件号码。&lt;/p&gt;&lt;p&gt;（2）您理解并确认，我们会以最大努力保障您的个人信息安全，并严格要求第三方机构对您的个人信息保密，只以实名认证之目的获悉和使用，不得对无关方泄露或做其他任何用途。&lt;/p&gt;&lt;p&gt;（3）同时，您需理解，姓名、身份证件号码、面部识别特征、您手持身份证件的照片属于您的个人敏感信息，我们收集该类信息是基于实名认证程序要求，如您拒绝提供可能导致您无法登录账号并使用相关产品功能，请您谨慎考虑后再选择是否提供。&lt;/p&gt;&lt;p&gt;10、开展内部数据分析和研究，第三方SDK统计服务，改善我们的产品或服务&lt;/p&gt;&lt;p&gt;（1）为改善我们的产品和服务，经您授权同意我们可能接入第三方产品和服务或接受第三方SDK统计服务，我们将明确标识由第三方提供，告知您收集数据的类型和用途，对于收集到的您的个人信息，必要时我们将建立安全评估机制和采取个人信息安全保护措施，SDK数据将不含与我们提供产品或服务无关的数据。目前我们产品中包含的第三方SDK服务请具体查阅《易优CMS第三方合作目录》[N2]&amp;nbsp;\r\n \r\n。前述服务商收集和处理信息等行为遵守其自身的隐私条款，而不适用于本政策。为了最大程度保障您的信息安全，我们建议您在使用任何第三方SDK类服务前先行查看其隐私条款。&lt;/p&gt;&lt;p&gt;我们将监督第三方接入及第三方SDK统计服务，并对违规收集您个人信息的行为采取技术检测、及时切断接入等有效措施，以保护您的个人信息不被泄露；此外，为保障您的合法权益，如您发现这等SDK或其他类似的应用程序侵权您的个人信息，您可通过以下途径投诉：客服电话：&amp;nbsp;\r\n &amp;nbsp;&amp;nbsp;&lt;/p&gt;&lt;p&gt;（2）本产品集成友盟U-App SDK终端统计分析、服务友盟U-Push \r\nSDK消息推送服务和友盟厂商推送通道SDK（如小米、华为、oppo、vivo、魅族等），需要您授权友盟SDK提供对应的服务；在您授权后，友盟SDK将收集如下相关的个人信息。设备Mac地址、唯一设备识别码（IMEI/android\r\n ID/IDFA/OPENUDID/GUID、SIM 卡 IMSI \r\n信息）以提供统计分析服务，并通过地理位置校准报表数据准确性，提供基础反作弊能力，以及用于唯一标识设备，以便向目标设备推送消息。采集地理位置甄别推送通道，提高消息推送的区域覆盖率。详见友盟官网（https://www.umeng.com/）上的隐私政策\r\n （https://www.umeng.com/page/policy）条款。&lt;/p&gt;&lt;p&gt;除上述个人信息外，统计分析服务将根据统计维度的不同采集如下信息：SDK/API/JS代码版本、浏览器、互联网服务提供商、平台、时间戳、应用标识符、应用程序版本、应用分发渠道、独立设备标识符、设备型号、传感器参数、终端制造厂商、终端设备操作系统版本、会话启动/停止时间、语言所在地、时区和网络状态（WiFi等）、硬盘、CPU和电池使用情况等。&lt;/p&gt;&lt;p&gt;（3）本产品/服务为改善注册及登陆页面用户体验，集成第三方SDK一键登录服务：闪验SDK，用于帮助实现用户一键登录行为。为了实现网关取号技术，闪验SDK需要获取IP地址、网卡（MAC）地址、\r\n \r\n国际移动设备识别码（IMEI）、OAID（替代IMEI）、sim卡信息，并会收集手机机型、系统类型、系统版本、网络环境、网关取号报错日志等数据以提供统计分析服务能力，并可提供反诈等功能。（注：您提供的上述信息，将在您使用本服务期间持续授权我们使用。在您注销账号时，我们将根据适用法律法规的要求尽快删除或匿名化您的个人信息。）&lt;/p&gt;&lt;p&gt;关于特定功能权限的提示：&lt;/p&gt;&lt;p&gt;您在使用易优CMS产品/服务时，除非经您的明示授权同意，我们不会默认开启您的无限局域网/蜂窝网络、相册、摄像头、消息通知等权限。如您需要关闭您为使用某项功能而开启的权限，大多数移动设备都会支持您的需求，具体方法请联系您的移动设备的服务商或提供商，请您注意，您开启某项权限即代表您授权我们收集您的相关信息来为您提供对应的服务，一旦您关闭即代表您取消了授权，我们将不再基于对应权限继续收集相关信息，但这将导致我们产品/服务的某项功能无法实现。&lt;/p&gt;&lt;p&gt;关于个人敏感信息的提示&lt;/p&gt;&lt;p&gt;个人敏感信息是一旦泄露、非法提供或滥用可能危害人身和财务安全，极易导致个人名誉、身心健康受到损害或歧视性待遇等的个人信息，包括生物识别、宗教信仰、特定身份、医疗健康、金融账户、行踪轨迹等信息，以及不满十四周岁未成年人的个人信息。相关由您提供或我们收集您的信息中，可能包含您的敏感信息，我们会采取严格和特殊加密措施保护您的个人信息，并要求合作第三方对您的个人信息进行严格保密，未经您明示授权，我们不会对外披露您的个人敏感信息或用作其他用途。请您谨慎并留意个人敏感信息，您同意您的个人敏感信息我们可以按照本政策所述的目的和方式来处理。&lt;/p&gt;&lt;p&gt;二、我们如何使用 Cookie 和同类技术&lt;/p&gt;&lt;p&gt;（一）Cookie&lt;/p&gt;&lt;p&gt;（1）在您使用我们的产品与/或服务时，我们可能会使用Cookie和同类技术收集您的一些个人信息，包括：您访问网站的习惯、您的浏览信息、您的登录信息，Cookie和同类技术收集该类信息是为了您使用我们的产品与/或服务的必要、简化您重复操作的步骤（如注册、登录）、便于您查看使用历史（如视频观看历史）、向您提供更切合您个人需要的服务内容和您可能更感兴趣的内容、保护您的信息和账号安全性、提升我们的产品和服务等。&lt;/p&gt;&lt;p&gt;（2）我们不会将\r\n Cookie 用于本政策所述目的之外的任何用途。您可根据自己的偏好管理或删除 Cookie。您可以清除计算机上保存的所有 \r\nCookie，大部分网络浏览器都设有阻止 Cookie \r\n的功能。如果您拒绝我们使用Cookie及同类技术收集和使用您的相关信息，您可在浏览器具备该功能的前提下，通过您的浏览器的设置以管理、（部分/全部）拒绝Cookie与/或同类技术；或删除已经储存在您的计算机、移动设备或其他装置内的Cookie与/或同类技术，从而实现我们无法全部或部分追踪您的个人信息。您如需详细了解如何更改浏览器设置，请具体查看您使用的浏览器的相关设置页面。您理解并知悉：我们的某些产品/服务只能通过使用Cookie或同类技术才可得到实现，如您拒绝使用或删除的，您可能将无法正常使用我们的相关产品与/或服务或无法通过我们的产品与/或服务获得最佳的服务体验，同时也可能会对您的信息保护和账号安全性造成一定的影响。&lt;/p&gt;&lt;p&gt;（二）网站信标和像素标签&lt;/p&gt;&lt;p&gt;除\r\n Cookie 外，我们还会在网站上使用网站信标和像素标签等其他同类技术。例如，我们向您发送的电子邮件可能含有链接至我们网站内容的点击 URL。\r\n 如果您点击该链接，我们则会跟踪此次点击，帮助我们了解您的产品或服务偏好并改善客户服务。网站信标通常是一种嵌入到网站或电子邮件中的透明图像。 \r\n借助于电子邮件中的像素标签，我们能够获知电子邮件是否被打开。如果您不希望自己的活动以这种方式被追踪，则可以随时从我们的寄信名单中退订。&lt;/p&gt;&lt;p&gt;（三）Do Not Track（请勿追踪）&lt;/p&gt;&lt;p&gt;很多网络浏览器均设有\r\n Do Not Track 功能，该功能可向网站发布 Do Not Track \r\n请求。目前，主要互联网标准组织尚未设立相关政策来规定网站应如何应对此类请求。但如果您的浏览器启用了 Do Not \r\nTrack，那么我们的所有网站都会尊重您的选择。&lt;/p&gt;&lt;p&gt;三、我们如何共享、转让、公开披露您的个人信息&lt;/p&gt;&lt;p&gt;（一）共享&lt;/p&gt;&lt;p&gt;我们不会向其他任何公司、组织和个人分享您的个人信息，但以下情况除外：&lt;/p&gt;&lt;p&gt;在获取明确同意的情况下共享：获得您的明确同意后，我们会与其他方共享您的个人信息。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 2、我们可能会根据法律法规规定，或按政府主管部门的强制性要求，对外共享您的个人信息。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 3、与我们的关联公司共享：您的个人信息可能会与我们关联公司共享。我们只会共享必要的个人信息，且受本隐私政策中所声明目的的约束。关联公司如要改变个人信息的处理目的，将再次征求您的授权同意。&lt;/p&gt;&lt;p&gt;&amp;nbsp;\r\n &amp;nbsp; \r\n4、与授权合作伙伴共享：仅为实现本隐私权政策中声明的目的，我们的某些服务将由授权合作伙伴提供。我们可能会与合作伙伴共享您的某些个人信息，以提供更好的客户服务和用户体验。对我们与之共享个人信息的公司、组织和个人，我们会与其签署严格的保密协定，要求他们按照我们的说明、本隐私政策以及其他任何相关的保密和安全措施来处理个人信息。我们的合作伙伴无权将共享的个人信息用于任何其他用途。如果您拒绝我们的合作伙伴在提供服务时收集为提供服务所必须的个人信息，将可能导致您无法在我们的平台中使用该第三方服务。通常我们的合作伙伴有如下几类：1）我们聘请来提供第三方数据统计和分析服务的公司可能需要采集和访问个人数据以进行数据统计和分析。在这种情况下，这些公司\r\n \r\n必须遵守我们的数据隐私和安全要求。我们仅会出于合法、正当、必要、特定、明确的目的共享您的个人信息，并且只会共享提供服务所必要的个人信息。2）我们平台的第三方商家：为实现您购买/积分兑换产品或服务的需求（包括享受售后服务），我们会将您的订单信息与交易相关的信息共享给我们平台的第三方商家。例如，当您在易优CMS积分商城兑换产品时，我们会向该商家提供您的必要信息，以便向您寄送产品。3）委托我们进行信息推广和广告投放的合作伙伴：您授权我们有权与委托我们进行信息推广和广告投放的合作伙伴共享我们使用您的相关信息形成的无法识别您的个人身份的间接用户画像、设备信息、去标识化或匿名化处理后的分析/统计类信息，以帮助其在不识别您个人身份的前提下进行广告或决策建议、提高广告有效触达率、衡量广告和相关服务的有效性。4）为我们的产品和/或服务提供功能支持的服务提供商：包括：提供支付服务的支付机构、提供一键登录服务的运营商、第三方配送公司和其他服务提供商，我们共享信息的目的是可以实现我们产品和/或服务的功能，让您可以正常使用。&lt;/p&gt;&lt;p&gt;（二）转让&lt;/p&gt;&lt;p&gt;1、在获取明确同意的情况下转让：获得您的明确同意后，我们会向其他方转让您的个人信息；&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 2、在涉及合并、收购或破产清算时，如涉及到个人信息转让，我们会在要求新的持有您个人信息的公司、组织继续受此隐私政策的约束，否则我们将要求该公司、组织重新向您征求授权同意。&lt;/p&gt;&lt;p&gt;（三）公开披露&lt;/p&gt;&lt;p&gt;我们仅会在以下情况下，公开披露您的个人信息：&lt;/p&gt;&lt;p&gt;1、获得您明确同意后；&lt;/p&gt;&lt;p&gt;2、基于法律的披露：在法律、法律程序、诉讼或政府主管部门强制性要求的情况下，我们可能会公开披露您的个人信息。&lt;/p&gt;&lt;p&gt;四、我们对您个人信息的存储与保护&lt;/p&gt;&lt;p&gt;1、信息存储&lt;/p&gt;&lt;p&gt;（1）存储地点：我们依照法律法规的规定，仅会将收集到的有关您的个人信息存储于中华人民共和国境内。目前我们暂时不存在跨境存储您的个人信息或向境外提供个人信息的场景。如果确有必要进行数据的跨境传输，我们会单独向您明确告知（包括数据出境的目的、接收方、使用方式与范围、使用内容、安全保障措施、安全风险等），并征得您的授权同意，我们会确保数据接收方有充足的数据保护能力来保护您的个人信息。&lt;/p&gt;&lt;p&gt;（2）\r\n \r\n存储期限：我们在为您提供满足产品和服务目的所必需且最短的期间内保留您的个人信息，例如：当您使用我们的注册及会员功能时，我们需要收集您的手机号码，且在您提供后并在您使用该功能期间，我们需要持续保存您的手机号码，以向您正常提供该功能、保障您的账号和系统安全。此外，我们或对您的相关信息保存至相关法律所规定的必要期限（例如《电子商务法》规定：商品和服务信息、交易信息保存时间自交易完成之日起不少于三年）。&lt;/p&gt;&lt;p&gt;（3）在超出上述存储期限后，我们会对您的个人信息进行删除或匿名化处理。&lt;/p&gt;&lt;p&gt;2、信息保护&lt;/p&gt;&lt;p&gt;（1）我们已使用符合业界标准的安全防护措施保护您提供的个人信息，防止数据遭到未经授权访问、公开披露、使用、修改、损坏或丢失。\r\n 我们会采取一切合理可行的措施，保护您的个人信息。例如，在您的浏览器与“服务”之间交换数据（如信用卡信息）时受 SSL 加密保护； \r\n我们同时对我们网站提供安全浏览方式；我们会使用加密技术确保数据的保密性；我们会使用受信赖的保护机制防止数据遭到恶意攻击； \r\n我们会部署访问控制机制，确保只有授权人员才可访问个人信息；以及我们会举办安全和隐私保护培训课程，加强员工对于保护个人信息重要性的认识。&lt;/p&gt;&lt;p&gt;（2）我们会采取一切合理可行的措施，确保未收集无关的个人信息。我们只会在达成本政策所述目的所需的期限内保留您的个人信息，除非需要延长保留期或受到法律的允许。&lt;/p&gt;&lt;p&gt;（3）互联网并非绝对安全的环境，而且电子邮件、即时通讯、及与其他我们用户的交流方式并未加密，我们强烈建议您不要通过此类方式发送个人信息。请使用复杂密码，协助我们保证您的账号安全。&lt;/p&gt;&lt;p&gt;（4）互联网环境并非百分之百安全，我们将尽力确保或担保您发送给我们的任何信息的安全性。如果我们的物理、技术、或管理防护设施遭到破坏，导致信息被非授权访问、公开披露、篡改、或毁坏，导致您的合法权益受损，我们将承担相应的法律责任。同时，我们还有专业的安全技术和运营团队负责维护，便于及时有效的响应、处置各类安全漏洞和突发事件，联合相关部门进行安全事件溯源和打击。&lt;/p&gt;&lt;p&gt;（5）发生或者可能发生个人信息泄露、篡改、丢失的，我们将立即采取补救措施，并第一时间通知相关部门、负责人及信息主体、监管部门。通知内容包括：1）所泄露、篡改、丢失的信息种类、原因和可能造成的危害；2）我们所采取的补救措施和个人可以采取的减轻危害的措施；3）我们个人信息处理相关负责人的联系方式。同时，我们将及时向您告知：安全事件的基本情况和可能的影响、我们已采取或将要采取的处置措施、您可自主防范和降低风险的建议、对您的补救措施等。我们将及时将事件相关情况以邮件、信函、电话、推送通知等方式告知您，难以逐一告知个人信息主体时，我们会采取合理、有效的方式发布公告。&lt;/p&gt;&lt;p&gt;五、您的权利&lt;/p&gt;&lt;p&gt;按照中国相关的法律、法规、标准，以及其他国家、地区的通行做法，我们保障您对自己的个人信息行使以下权利：&lt;/p&gt;&lt;p&gt;（一）访问您的个人信息&lt;/p&gt;&lt;p&gt;您有权访问您的个人信息，法律法规规定的例外情况除外。如果您想行使数据访问权，可以通过以下方式自行访问：&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 账户信息——如果您希望访问或编辑您的账户中的个人资料信息和支付信息、更改您的密码、添加安全信息或关闭您的账户等，您可以随时在前往个人中心、联系在线客服或通过发送电子邮件至doiio@qq.com。我们将在15个工作日内回复您的访问请求。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 对于您在使用我们的产品或服务过程中产生的其他个人信息，只要我们不需要过多投入，我们会向您提供。如果您想行使数据访问权，请联系在线客服发送电子邮件至doiio@qq.com。&lt;/p&gt;&lt;p&gt;（二）更正您的个人信息&lt;/p&gt;&lt;p&gt;当您发现我们处理的关于您的个人信息有错误时，您有权要求我们做出更正。您可以通过“（一）访问您的个人信息”中罗列的方式提出更正申请。&lt;/p&gt;&lt;p&gt;（三）删除您的个人信息&lt;/p&gt;&lt;p&gt;在以下情形中，您可以通过联系在线客服或发送电子邮件至doiio@qq.com向我们提出删除个人信息的请求：&lt;/p&gt;&lt;p&gt;1、如果我们处理个人信息的行为违反法律法规；&lt;/p&gt;&lt;p&gt;2、如果我们收集、使用您的个人信息，却未征得您的同意；&lt;/p&gt;&lt;p&gt;3、如果我们处理个人信息的行为违反了与您的约定；&lt;/p&gt;&lt;p&gt;4、如果您不再使用我们的产品或服务，或您注销了账号；&lt;/p&gt;&lt;p&gt;5、如果我们不再为您提供产品或服务。&lt;/p&gt;&lt;p&gt;若我们决定响应您的删除请求，我们还将同时通知从我们获得您的个人信息的实体，要求其及时删除，除非法律法规另有规定，或这些实体获得您的独立授权。 当您从我们的服务中删除信息后，我们可能不会立即备份系统中删除相应的信息，但会在备份更新时删除这些信息。&lt;/p&gt;&lt;p&gt;（四）改变您授权同意的范围或撤回您的授权&lt;/p&gt;&lt;p&gt;每个业务功能需要一些基本的个人信息才能得以完成（见本策略“第一部分”）。对于额外收集的个人信息的收集和使用，您可以随时给予或撤回您的授权同意。您可以通过联系在线客服或通过发送电子邮件至doiio@qq.com的方式提出更正申请。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 当您撤回同意后，我们将不再处理相应的个人信息。但您撤回同意的决定，不会影响此前基于您的授权而开展的个人信息处理。&lt;/p&gt;&lt;p&gt;（五）个人信息主体注销账户&lt;/p&gt;&lt;p&gt;您随时可注销此前注册的账户，您可以通过以下方式自行操作：您可以随时联系在线客服或通过发送电子邮件至doiio@qq.com。我们将在15个工作日内回复您的访问请求。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 在注销账户之后，我们将停止为您提供产品或服务，并依据您的要求，删除您的个人信息，法律法规另有规定的除外。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 在技术可行的前提下，例如数据接口匹配，我们还可按您的要求，直接将您的个人信息副本传输给您指定的第三方。&lt;/p&gt;&lt;p&gt;（六）去世用户的个人信息保护&lt;/p&gt;&lt;p&gt;（1）易优CMS将从2021年11月1日起，根据《中华人民共和国个人信息保护法》的相关规定升级死者个人信息保护制度。易优CMS用户（仅限自然人）去世后，其近亲属为了自身的合法、正当利益，可以通过本隐私政策第九条“联系我们”中公示的联系方式，对去世用户的相关个人信息行使查阅、复制、更正、删除等权利，但是去世用户生前另有安排的除外。&lt;/p&gt;&lt;p&gt;（2）您理解并确认，为了充分保护去世用户的个人信息权益，申请行使本条权利的去世用户近亲属需要根据易优CMS的指定流程或客服提示，提交去世用户的身份证明文件、死亡证明文件、申请人的身份证明文件、申请人与去世用户的亲属关系证明文件，并提供申请行使的权利种类、目的。更多关于去世用户的个人信息保护流程、条件等事项请与我们在线客服联系。&lt;/p&gt;&lt;p&gt;（七）约束信息系统自动决策&lt;/p&gt;&lt;p&gt;在某些业务功能中，我们可能仅依据信息系统、算法等在内的非人工自动决策机制做出决定。如果这些决定显著影响您的合法权益，您有权要求我们做出解释，我们也将提供适当的救济方式。&lt;/p&gt;&lt;p&gt;（八）响应您的上述请求&lt;/p&gt;&lt;p&gt;为保障安全，您可能需要提供书面请求，或以其他方式证明您的身份。我们可能会先要求您验证自己的身份，然后再处理您的请求。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 我们将在十五个工作日内做出答复。如您不满意，还可以通过以下途径投诉：&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 电话：0898-32622888&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp;\r\n &amp;nbsp; \r\n对于您合理的请求，我们原则上不收取费用，但对多次重复、超出合理限度的请求，我们将视情收取一定成本费用。对于那些无端重复、需要过多技术手段（例如，需要开发新系统或从根本上改变现行惯例）、给他人合法权益带来风险或者非常不切实际（例如，涉及备份磁带上存放的信息）的请求，我们可能会予以拒绝。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 在以下情形中，按照法律法规要求，我们将无法响应您的请求：&lt;/p&gt;&lt;p&gt;1、与国家安全、国防安全有关的；&lt;/p&gt;&lt;p&gt;2、与公共安全、公共卫生、重大公共利益有关的；&lt;/p&gt;&lt;p&gt;3、与犯罪侦查、起诉和审判等有关的；&lt;/p&gt;&lt;p&gt;4、有充分证据表明您存在主观恶意或滥用权利的；&lt;/p&gt;&lt;p&gt;5、响应您的请求将导致您或其他个人、组织的合法权益受到严重损害的。&lt;/p&gt;&lt;p&gt;六、我们如何处理儿童的个人信息&lt;/p&gt;&lt;p&gt;我们的产品、网站和服务主要面向成人。如果没有父母或监护人的同意，儿童不得创建自己的用户账户。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 对于经父母、监护人同意而收集儿童个人信息的情况，我们只会在受到法律允许、父母或监护人明确同意或者保护儿童所必要的情况下使用或公开披露此信息。&lt;/p&gt;&lt;p&gt;尽管当地法律和习俗对儿童的定义不同，但我们将不满 14周岁的任何人均视为儿童。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 如果我们发现自己在未事先获得可证实的父母同意的情况下收集了儿童的个人信息，则会设法尽快删除相关数据。&lt;/p&gt;&lt;p&gt;七、您的个人信息如何在全球范围转移&lt;/p&gt;&lt;p&gt;原则上，我们在中华人民共和国境内收集和产生的个人信息，将存储在中华人民共和国境内。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 由于我们通过遍布全球的资源和服务器提供产品或服务，这意味着，在获得您的授权同意后，您的个人信息可能会被转移到您使用产品或服务所在国家/地区的境外管辖区，或者受到来自这些管辖区的访问。&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 此类管辖区可能设有不同的数据保护法，甚至未设立相关法律。在此类情况下，我们会确保您的个人信息得到在中华人民共和国境内足够同等的保护。例如，我们会请求您对跨境转移个人信息的同意，或者在跨境数据转移之前实施数据去标识化等安全举措。&lt;/p&gt;&lt;p&gt;八、本隐私权政策如何更新&lt;/p&gt;&lt;p&gt;我们可能适时会对本隐私权政策进行调整或变更，本隐私权政策的任何更新将以标注更新时间的方式公布在我们网站上，除法律法规或监管规定另有强制性规定外，经调整或变更的内容一经通知或公布后生效。如您在隐私权政策调整或变更后继续使用我们提供的任一服务或访问我们相关网站的，我们相信这代表您已充分阅读、理解并接受修改后的隐私权政策并受其约束。&lt;/p&gt;&lt;p&gt;九、如何联系我们&lt;/p&gt;&lt;p&gt;如果您对本隐私政策有任何疑问、意见或建议，通过以下方式与我们联系：电话：0898-32922888&amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;/p&gt;&lt;p&gt;我们设立了个人信息保护专职部门（或个人信息保护专员），您可以通过以下方式与我们联系：电话：0898-32922888；地址：海南省海口市龙华区龙昆南路城西商务中心17楼。&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; 一般情况下，我们将在三个工作日内回复，至迟不超过15个工作日核查处理。&lt;/p&gt;&lt;p&gt;十、争议解决&lt;/p&gt;&lt;p&gt;有关本《隐私政策》的解释及争议解决均应适用中华人民共和国法律。如就本政策的签订、履行等发生任何争议的，双方应尽量友好协商解决；协商不成时，任何一方均可向海口快推科技有限公司住所地享有管辖权的人民法院提起诉讼。&lt;/p&gt;&lt;p&gt;附件一《易优CMS儿童个人信息保护规则》&lt;/p&gt;&lt;p&gt;为了保护儿童个人信息安全，促进儿童健康成长。本规则旨在更详细的向监护人（以下也称“您”）和儿童说明我们如何收集、使用、存储和处理儿童个人信息，以及我们为您与儿童提供的访问、更正、删除、保护这些信息的方式。如果您是儿童用户的监护人，请您在充分理解并同意本规则后再使用我们的产品和/或服务。&lt;/p&gt;&lt;p&gt;一.适用范围&lt;/p&gt;&lt;p&gt;本规则仅适用于在中华人民共和国境内通过网络从事收集、存储、使用、转移、披露儿童个人信息等活动。我们的产品及服务主要面向成年人，因此未成年人不得在未经监护人的许可下注册和登录用户账号。&lt;/p&gt;&lt;p&gt;我们将本着正当必要、本人及监护人知情同意、目的明确、安全保障、依法利用的原则收集、存储、使用、转移、披露儿童个人信息，指定本规则。《隐私政策》展示了我们收集、使用、处理、保护个人信息的一般做法，本规则为《隐私政策》的一部分；如在儿童个人信息保护规则方面，本规则与《隐私政策》正文存在不一致的，本规则优先适用，如本规则中未提及的，则视产品实际情况适用/参照适用《隐私政策》，本规则中涉及的词语含义与《隐私政策》正文中的一致。&lt;/p&gt;&lt;p&gt;给监护人的特别说明：&lt;/p&gt;&lt;p&gt;当我们获悉您的孩子不满十四周岁，我们将根据本政策采取特殊措施保护我们获得的您孩子的个人信息，监护人比我们对您的权益保护更为便利，请帮助我们共同保护您孩子的个人信息和隐私安全，要求他们在您的监护下共同阅读本政策，在您的支持同意下使用我们的产品和/或服务。如果您不同意《隐私政策》及本规则，或任何与注册获取用户账号相关的协议。请您立即要求您的儿童停止访问易优CMS，您同意本规则（包括更新规则）或者您在阅读本规则下同意您的儿童继续使用我们的产品和/或服务、提交个人信息，都表示您同意我们按照本规则收集、存储、使用、转移、披露您儿童个人信息。&lt;/p&gt;&lt;p&gt;给儿童的特别说明：&lt;/p&gt;&lt;p&gt;如果您不满14周岁，请您在通知您的监护人且监护人明确同意本规则之前，不要使用我们的产品和/或服务。&lt;/p&gt;&lt;p&gt;二.我们收集和使用儿童个人信息的规则&lt;/p&gt;&lt;p&gt;1、我们会严格履行法律规定的儿童个人信息保护义务与责任，遵循正当必要、知情同意、目的明确、安全保障、依法利用的原则收集和使用儿童个人信息，不会收集与我们提供的产品和/或服务无关的儿童个人信息，不会违反法律规定和我们与您的约定收集、使用儿童个人信息。&lt;/p&gt;&lt;p&gt;2、我们没有独立的向儿童提供的产品和/或服务，一般情况下，我们收集和使用的儿童个人信息仅发生在《隐私政策》第二部分我们如何收集和使用您的信息，在《隐私政策》指引下，我们一般情况无法主动获取账号使用者的年龄（除非您在个人账户信息中填写）或者确认实际使用人账户信息的真实性，此情况下适用《隐私政策》。一旦我们发现您是儿童，我们会对您的账户信息予以更高程度的保护。除《隐私政策》第二部分外，我们还会收集您与儿童之间监护关系的信息。&lt;/p&gt;&lt;p&gt;3、我们再次以显著、清晰的方式告知儿童监护人，并应当征得儿童监护人的同意，我们可能会收集和使用的儿童的个人信息的规则请您查阅《隐私政策》正文第二章节，因业务需要，当确需超出前述约定的目的、范围收集、使用您监护的儿童的个人信息的，我们会再次征得您的同意。&lt;/p&gt;&lt;p&gt;三.我们共享、转让、公开披露儿童个人信息的规则&lt;/p&gt;&lt;p&gt;(一)共享&lt;/p&gt;&lt;p&gt;对于儿童个人信息，我们仅在本规则所述的目的和范围内或依照法律要求进行共享，除非存在以下一种或多种情形：&lt;/p&gt;&lt;p&gt;1、与作为监护人的您之间的共享；&lt;/p&gt;&lt;p&gt;2、事先已征得您的明确授权同意；&lt;/p&gt;&lt;p&gt;3、如果我们需要改变儿童个人信息的处理目的时，将再次征求您的授权同意。&lt;/p&gt;&lt;p&gt;4、如我们需要委托服务商处理儿童个人信息的，请您放心，我们会对服务商和其服务行为等进行安全评估，签署协议，明确责任、处理事项、处理期限、处理性质和目的等，要求其处理行为不得超出我们的授权范围；&lt;/p&gt;&lt;p&gt;5、有权机关的要求、法律法规等规定的其他情形。&lt;/p&gt;&lt;p&gt;(二) 转让与公开披露&lt;/p&gt;&lt;p&gt;我们会严格履行法律规定的儿童个人信息保护义务与责任，遵循正当必要、知情同意、目的明确、安全保障、依法利用的原则转让、公开披露儿童个人信息。如您希望了解更多，请您查阅《隐私政策》正文第三条。&lt;/p&gt;&lt;p&gt;四、您和/或儿童对儿童个人信息的相关权利&lt;/p&gt;&lt;p&gt;我们的产品和服务为您和儿童提供了多种对儿童个人信息行使相关权利的功能，您可以通过这些功能管理儿童个人信息和儿童的网络生活，包括：&lt;/p&gt;&lt;p&gt;(一)访问权&lt;/p&gt;&lt;p&gt;您或儿童可以在应用程序及WEB端查询和访问儿童的相关个人信息，例如：个人资料信息、视频观看记录、搜索记录、下载记录、收藏记录，详细操作步骤我们已经在《隐私政策》第五条向儿童及其监护人明确告知，您可以参照《隐私政策》进行操作。&lt;/p&gt;&lt;p&gt;(二)更正/修改权&lt;/p&gt;&lt;p&gt;您可以在应用程序及WEB端更正/修改儿童的相关个人信息，例如：个人资料信息；或您可以联系我们解决，我们会在经对您的身份进行验证，且不影响信息的客观性和准确性的情况下进行更正/修改。&lt;/p&gt;&lt;p&gt;同时，如您或儿童发现我们收集、存储、使用、披露的儿童个人信息有错误的，可以联系我们更正，我们会在完成身份验证和核实问题后及时采取措施予以更正。&lt;/p&gt;&lt;p&gt;(三)删除权&lt;/p&gt;&lt;p&gt;1、您和儿童可以在应用程序及WEB端自行删除儿童的相关个人信息，详细操作步骤我们已经在《隐私政策》第五条向儿童及其监护人明确告知，您可以参照《隐私政策》进行操作，上述信息删除或导致您账户下的部分数据丢失，可能导致无法继续使用我们部分产品和/或服务。&lt;/p&gt;&lt;p&gt;2、在以下情形下，您或儿童可以直接向我们提出删除儿童个人信息的请求，我们会在完成身份验证和核实问题后及时采取措施予以删除，包括：&lt;/p&gt;&lt;p&gt;（1）我们违反法律法规规定或我们与监护人的约定收集、存储、使用、转移、披露儿童个人信息的；&lt;/p&gt;&lt;p&gt;（2）我们超出目的范围或者必要期限收集、存储、使用、转移、披露儿童个人信息的；&lt;/p&gt;&lt;p&gt;（3）监护人撤回同意的；&lt;/p&gt;&lt;p&gt;（4）监护人或儿童通过注销等方式终止使用的产品或服务的；&lt;/p&gt;&lt;p&gt;（5）法律法规等规定的其他情形。&lt;/p&gt;&lt;p&gt;(四)提前获知产品和/或服务停止运营权&lt;/p&gt;&lt;p&gt;我们将持续为您提供优质服务，若因特殊原因导致我们的部分或全部产品和/或服务被迫停止运营，我们将提前在显著位置或向您发送推送消息或以其他方式通知您，并将停止对儿童个人信息的收集，删除或匿名化处理我们持有的儿童个人信息。&lt;/p&gt;&lt;p&gt;五、我们存储和保护儿童个人信息的规则&lt;/p&gt;&lt;p&gt;我们依照法律法规的规定，将儿童个人信息存储于中华人民共和国境内。我们仅在为提供我们的产品和服务之目的所必需且最短的期间内保留儿童个人信息。在超出上述存储期限后，我们会对儿童个人信息进行删除或匿名化处理。&lt;/p&gt;&lt;p&gt;我们采用了符合行业标准的安全技术措施及配套的组织架构和管理体系等多层面保护措施来保护儿童个人信息；同时，我们遵循最小授权原则，对工作人员设定了严格的信息访问权限，控制儿童个人信息知悉范围；我们也采取了必要技术措施，避免违法复制、下载儿童个人信息。如您希望了解更多，请您查阅《隐私政策》正文第六条。&lt;/p&gt;&lt;p&gt;六、联系我们&lt;/p&gt;&lt;p&gt;如您对本规则的执行或使用我们的产品和/或服务时遇到的与儿童隐私保护相关的事宜有任何问题（包括问题咨询、投诉等），您可以通过以下任意方式与我们联系：&lt;/p&gt;&lt;p&gt;我们的主体信息：海口快推科技有限公司&lt;/p&gt;&lt;p&gt;我们的邮寄地址：&lt;/p&gt;&lt;p&gt;海南省海口市龙华区龙昆南路城西商务中心17楼&amp;nbsp; 邮编：570000&lt;/p&gt;&lt;p&gt;我们的邮箱：&lt;span style=&quot;color:#222222;font-family:Roboto, PingFang SC, Lantinghei SC, Microsoft Yahei, Hiragino Sans GB, Microsoft Sans Serif, WenQuanYi Micro Hei, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 18px; background-color: rgb(255, 255, 255);&quot;&gt;doiio&lt;/span&gt;&lt;/span&gt;@qq.com&lt;/p&gt;&lt;p&gt;我们的官方客服电话：0898-32622888&lt;/p&gt;&lt;p&gt;我们有专门人员负责对接；您也可以通过《隐私政策》中提供的其他反馈通道与我们联系，我们会尽最大努力为您提供满意的解决方案，并在15个工作日内为您处理完毕。&lt;/p&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/section&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1721271666');

-- -----------------------------
-- Table structure for `ey_users_bottom_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_bottom_menu`;
CREATE TABLE `ey_users_bottom_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '功能开关状态，1=开启，0=关闭',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示, 1--是, 0--否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='会员中心移动端底部菜单表';

-- -----------------------------
-- Records of `ey_users_bottom_menu`
-- -----------------------------
INSERT INTO `ey_users_bottom_menu` VALUES ('1', '首页', 'home/Index/index', 'shouye', '100', '1', '1', '1610334638', '1610334638');
INSERT INTO `ey_users_bottom_menu` VALUES ('2', '下载', 'user/Download/index', 'xiazai', '100', '1', '1', '1610334638', '1610334638');
INSERT INTO `ey_users_bottom_menu` VALUES ('3', '发布', 'user/UsersRelease/article_add', 'fabu', '100', '1', '1', '1610334638', '1713262171');
INSERT INTO `ey_users_bottom_menu` VALUES ('4', '我的', 'user/Users/centre', 'geren', '100', '1', '1', '1610334638', '1610334638');

-- -----------------------------
-- Table structure for `ey_users_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_collection`;
CREATE TABLE `ey_users_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_config`;
CREATE TABLE `ey_users_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '会员功能配置表ID',
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置的value值',
  `desc` varchar(100) DEFAULT '' COMMENT '键名说明',
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COMMENT='会员功能配置表';

-- -----------------------------
-- Records of `ey_users_config`
-- -----------------------------
INSERT INTO `ey_users_config` VALUES ('1', 'shop_open', '1', '', 'shop', '1713337196');
INSERT INTO `ey_users_config` VALUES ('2', 'pay_open', '1', '', 'pay', '1713262172');
INSERT INTO `ey_users_config` VALUES ('3', 'users_reg_notallow', 'www,bbs,ftp,mail,user,users,admin,administrator,eyoucms', '不允许注册的会员名', 'users', '1547890773');
INSERT INTO `ey_users_config` VALUES ('4', 'level_member_upgrade', '1', '', 'level', '1713262171');
INSERT INTO `ey_users_config` VALUES ('5', 'users_open_release', '1', '', 'users', '1713262171');
INSERT INTO `ey_users_config` VALUES ('6', 'shop_open_spec', '1', '', 'shop', '1713400771');
INSERT INTO `ey_users_config` VALUES ('7', 'score_signin_status', '1', '', 'score', '1610334638');
INSERT INTO `ey_users_config` VALUES ('8', 'score_signin_score', '3', '', 'score', '1610334638');
INSERT INTO `ey_users_config` VALUES ('11', 'users_open_register', '0', '', 'users', '1610352452');
INSERT INTO `ey_users_config` VALUES ('12', 'users_open_reg', '0', '', 'users', '1610352452');
INSERT INTO `ey_users_config` VALUES ('13', 'users_verification', '0', '', 'users', '1610352452');
INSERT INTO `ey_users_config` VALUES ('14', 'theme_color', '#ff9600', '', 'theme', '1610616432');
INSERT INTO `ey_users_config` VALUES ('15', 'pay_balance_open', '1', '', 'pay', '1721274302');
INSERT INTO `ey_users_config` VALUES ('16', 'users_login_expiretime', '3600', '', 'users', '1641949807');
INSERT INTO `ey_users_config` VALUES ('17', 'score_name', '积分', '', 'score', '1667356308');
INSERT INTO `ey_users_config` VALUES ('18', 'score_intro', 'a) 积分不可兑现、不可转让,仅可在本平台使用;\r\nb) 您在本平台参加特定活动也可使用积分,详细使用规则以具体活动时的规则为准;\r\nc) 积分的数值精确到个位(小数点后全部舍弃,不进行四舍五入)\r\nd) 买家在完成该笔交易(订单状态为“已签收”)后才能得到此笔交易的相应积分,如购买商品参加店铺其他优惠,则优惠的金额部分不享受积分获取;', '', 'score', '1667356308');
INSERT INTO `ey_users_config` VALUES ('19', 'memgift_open', '0', '', 'memgift', '1673945387');
INSERT INTO `ey_users_config` VALUES ('20', 'order_right_protect_time', '7', '', 'order', '1713257471');
INSERT INTO `ey_users_config` VALUES ('21', 'shop_type', '0', '', 'shop', '1712996605');
INSERT INTO `ey_users_config` VALUES ('22', 'shop_open_shipping', '0', '', 'shop', '1712996605');
INSERT INTO `ey_users_config` VALUES ('23', 'shop_open_offline', '1', '', 'shop', '1713493394');
INSERT INTO `ey_users_config` VALUES ('24', 'shop_prompt', '商品下单后，快递公司会电话联系您确认送货时间，收货时需核对身份证信息。', '', 'shop', '1713142700');
INSERT INTO `ey_users_config` VALUES ('25', 'shop_open_comment', '1', '', 'shop', '1720141059');
INSERT INTO `ey_users_config` VALUES ('26', 'shop_open_comment_audit', '0', '', 'shop', '1712996605');
INSERT INTO `ey_users_config` VALUES ('27', 'order_unpay_close_time', '120', '', 'order', '1712996605');
INSERT INTO `ey_users_config` VALUES ('28', 'order_auto_receipt_time', '7', '', 'order', '1713257471');
INSERT INTO `ey_users_config` VALUES ('29', 'addr_contact_person', '李小姐', '', 'addr', '1719302393');
INSERT INTO `ey_users_config` VALUES ('30', 'addr_contact_phone', '13812345678', '', 'addr', '1719302393');
INSERT INTO `ey_users_config` VALUES ('31', 'addr_shipping_addr', '海南省海口市龙华区城西镇幸福街道88号', '', 'addr', '1719302393');
INSERT INTO `ey_users_config` VALUES ('32', 'score_consume_status', '0', '', 'score', '1714967973');
INSERT INTO `ey_users_config` VALUES ('33', 'score_consume_money', '10', '', 'score', '1713919014');
INSERT INTO `ey_users_config` VALUES ('34', 'score_login_points_open', '0', '', 'score', '1713148169');
INSERT INTO `ey_users_config` VALUES ('35', 'score_login_points_value', '1', '', 'score', '1713148169');
INSERT INTO `ey_users_config` VALUES ('36', 'goods_unit', '件', '', 'goods', '1722930520');
INSERT INTO `ey_users_config` VALUES ('37', 'goods_stock_warning', '10', '', 'goods', '1713257471');
INSERT INTO `ey_users_config` VALUES ('38', 'score_consume_quota', '10', '', 'score', '1713841374');
INSERT INTO `ey_users_config` VALUES ('39', 'dealer_open', '0', '', 'dealer', '1721283991');
INSERT INTO `ey_users_config` VALUES ('40', 'dealer_level', '1', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('41', 'dealer_self_buy', '1', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('42', 'dealer_rebate', '2', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('43', 'dealer_settlement', '1', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('44', 'dealer_settlement_day', '12', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('45', 'dealer_one_level_rebate', '10', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('46', 'dealer_two_level_rebate', '5', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('47', 'dealer_show_rebates', '0', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('48', 'dealer_bind_condition', '1', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('49', 'dealer_apply_type', '5', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('50', 'dealer_least_withdrawal', '1', '', 'dealer', '1713922599');
INSERT INTO `ey_users_config` VALUES ('51', 'users_force_login', '0', '', 'users', '1720142437');
INSERT INTO `ey_users_config` VALUES ('52', 'pay_wechat_open', '0', '', 'pay', '1721274291');
INSERT INTO `ey_users_config` VALUES ('53', 'pay_verify_config', '1', '', 'pay', '1718964348');
INSERT INTO `ey_users_config` VALUES ('54', 'pay_verify_gzh', '1', '', 'pay', '1718964348');
INSERT INTO `ey_users_config` VALUES ('55', 'pay_verify_xcx', '1', '', 'pay', '1718964348');
INSERT INTO `ey_users_config` VALUES ('56', 'goods_synch_images', '1', '', 'goods', '1722926111');
INSERT INTO `ey_users_config` VALUES ('57', 'goods_crossed_price', '1', '', 'goods', '1719282419');
INSERT INTO `ey_users_config` VALUES ('58', 'shop_open_default_comment', '0', '', 'shop', '1719282419');
INSERT INTO `ey_users_config` VALUES ('59', 'shop_default_comment_time', '7', '', 'shop', '1719282419');
INSERT INTO `ey_users_config` VALUES ('60', 'shop_default_comment_content', '此用户没有填写评价', '', 'shop', '1719282419');

-- -----------------------------
-- Table structure for `ey_users_footprint`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_footprint`;
CREATE TABLE `ey_users_footprint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` int(10) DEFAULT '0' COMMENT '频道模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目id',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `users_id` int(10) DEFAULT '0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的足迹';


-- -----------------------------
-- Table structure for `ey_users_forward`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_forward`;
CREATE TABLE `ey_users_forward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='转发记录';


-- -----------------------------
-- Table structure for `ey_users_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_level`;
CREATE TABLE `ey_users_level` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_name` varchar(30) DEFAULT '' COMMENT '级别名称',
  `level_value` int(10) DEFAULT '0' COMMENT '会员等级值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '类型，1=系统，0=用户',
  `amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费额度',
  `down_count` int(10) DEFAULT '0' COMMENT '每天下载次数限制',
  `discount_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '升级条件类型(0:不设置折扣; 1:自定义折扣)',
  `discount` float(10,2) DEFAULT '100.00' COMMENT '折扣率，初始值为100即100%，无折扣',
  `posts_count` int(10) DEFAULT '5' COMMENT '会员投稿次数限制',
  `ask_is_release` tinyint(1) DEFAULT '1' COMMENT '允许在问答中发布问题，1=是，0=否',
  `ask_is_review` tinyint(1) DEFAULT '0' COMMENT '在问答中发布问题或回答是否需要审核，1=是，0=否',
  `upgrade_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '升级条件类型(0:不自动升级; 1:订单金额)',
  `upgrade_order_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '累计完成订单金额满多少自动升级成当前会员等级',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '会员等级状态(0:禁用; 1:启用)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='会员级别表';

-- -----------------------------
-- Records of `ey_users_level`
-- -----------------------------
INSERT INTO `ey_users_level` VALUES ('1', 'LV1', '1', '1', '0.00', '100', '0', '100', '5', '1', '0', '1', '0.00', '1', '0', '1713403510');
INSERT INTO `ey_users_level` VALUES ('2', 'LV2', '2', '0', '0.00', '100', '1', '90', '10', '1', '0', '1', '1000.00', '1', '1611053268', '1713403519');
INSERT INTO `ey_users_level` VALUES ('3', 'LV3', '3', '0', '0.00', '100', '1', '85', '20', '1', '0', '1', '2000.00', '1', '1611053268', '1713403528');
INSERT INTO `ey_users_level` VALUES ('4', 'LV4', '4', '0', '0.00', '100', '1', '80', '5', '1', '0', '1', '3000.00', '1', '1707124692', '1713403539');
INSERT INTO `ey_users_level` VALUES ('5', 'LV5', '5', '0', '0.00', '100', '1', '75', '5', '1', '0', '1', '4000.00', '1', '1707124692', '1713403549');
INSERT INTO `ey_users_level` VALUES ('7', 'LV7', '7', '0', '0.00', '0', '1', '60', '5', '1', '0', '1', '10000.00', '1', '1711503253', '1713403569');
INSERT INTO `ey_users_level` VALUES ('6', 'LV6', '6', '0', '0.00', '0', '1', '70', '5', '1', '0', '1', '5000.00', '1', '1711503197', '1713403556');
INSERT INTO `ey_users_level` VALUES ('8', 'LV8', '8', '0', '0.00', '0', '1', '50', '5', '1', '0', '1', '20000.00', '1', '1711503366', '1713403577');

-- -----------------------------
-- Table structure for `ey_users_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_like`;
CREATE TABLE `ey_users_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我喜欢的';


-- -----------------------------
-- Table structure for `ey_users_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_list`;
CREATE TABLE `ey_users_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `para_id` int(10) NOT NULL DEFAULT '0' COMMENT '属性ID',
  `info` text COMMENT '属性值',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员属性表(信息）';


-- -----------------------------
-- Table structure for `ey_users_log_off`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_log_off`;
CREATE TABLE `ey_users_log_off` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) DEFAULT '0',
  `username` varchar(25) DEFAULT NULL,
  `nickname` varchar(30) DEFAULT NULL,
  `mobile` varchar(25) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '0-审核中 1-通过 2-拒绝',
  `handle_time` int(11) DEFAULT '0' COMMENT '操作时间',
  `admin_id` int(11) DEFAULT '0' COMMENT '操作人',
  `refuse_reason` varchar(255) DEFAULT NULL COMMENT '拒绝原因',
  `add_time` int(11) DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员注销日志表';


-- -----------------------------
-- Table structure for `ey_users_login_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_login_log`;
CREATE TABLE `ey_users_login_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员日志自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `log_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志时间，年月日(例:20230406)',
  `log_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志次数',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员登录日志 - 用于登录赠送积分';


-- -----------------------------
-- Table structure for `ey_users_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_menu`;
CREATE TABLE `ey_users_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `version` varchar(10) DEFAULT 'weapp' COMMENT '分组',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `active_url` varchar(500) DEFAULT '' COMMENT '标记为选中的url',
  `is_userpage` tinyint(1) DEFAULT '0' COMMENT '默认会员首页',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='会员菜单表';

-- -----------------------------
-- Records of `ey_users_menu`
-- -----------------------------
INSERT INTO `ey_users_menu` VALUES ('1', '个人信息', 'v1', 'user/Users/index', '', '1', '100', '1', '1555904190', '1555917737');
INSERT INTO `ey_users_menu` VALUES ('2', '账户充值', 'v1', 'user/Pay/pay_consumer_details', '', '0', '100', '1', '1555904190', '1713262172');
INSERT INTO `ey_users_menu` VALUES ('3', '商城中心', 'v1', 'user/Shop/shop_centre', '', '0', '100', '1', '1555904190', '1713337196');
INSERT INTO `ey_users_menu` VALUES ('4', '会员升级', 'v1', 'user/Level/level_centre', '', '0', '100', '1', '1555904190', '1713262171');
INSERT INTO `ey_users_menu` VALUES ('5', '会员投稿', 'v1', 'user/UsersRelease/release_centre', '', '0', '100', '1', '1555904190', '1713262171');
INSERT INTO `ey_users_menu` VALUES ('6', '我的下载', 'v1', 'user/Download/index', '', '0', '100', '1', '1590484667', '1602320126');
INSERT INTO `ey_users_menu` VALUES ('7', '个人中心', 'v1', 'user/Users/index', '', '1', '100', '1', '1608708057', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('11', '个人中心', 'v2', 'user/Users/index', 'user/Users/index|user/Pay/pay_account_recharge|user/Users/footprint_index|user/Level/level_centre|user/Download/index|user/Users/media_index', '1', '100', '1', '1608708057', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('10', '财务明细', 'v1', 'user/Pay/pay_consumer_details', '', '0', '100', '1', '1608709000', '1713262172');
INSERT INTO `ey_users_menu` VALUES ('12', '我的信息', 'v2', 'user/Users/info', 'user/Users/info', '0', '100', '1', '1608709100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('13', '我的收藏', 'v2', 'user/Users/collection_index', 'user/Users/collection_index', '0', '100', '1', '1608708100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('14', '财务明细', 'v2', 'user/Pay/pay_consumer_details', 'user/Pay/pay_consumer_details|user/Users/score_index', '0', '100', '1', '1608709000', '1713262172');
INSERT INTO `ey_users_menu` VALUES ('15', '我的收藏', 'v1', 'user/Users/collection_index', '', '0', '100', '1', '1590484667', '1614651537');
INSERT INTO `ey_users_menu` VALUES ('16', '积分商城', 'weapp', 'plugins/PointsShop/index', '', '0', '100', '0', '1713233571', '1722937748');

-- -----------------------------
-- Table structure for `ey_users_money`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_money`;
CREATE TABLE `ey_users_money` (
  `moneyid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '金额明细表ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员表ID',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '金额',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '此条记录的账户金额',
  `cause` text COMMENT '事由，暂时在升级消费中使用到，以serialize序列化后存入，用于后续查询。',
  `cause_type` tinyint(1) DEFAULT '0' COMMENT '数据类型,0-消费,1-充值,2-退款,3-订单支付,4-管理员添加,5-管理员减少',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否成功，默认1，0失败，1未付款，2已付款，3已完成，4订单取消。',
  `pay_method` varchar(50) DEFAULT '' COMMENT '支付方式，wechat为微信支付，alipay为支付宝支付，balance为余额支付',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `order_number` varchar(30) DEFAULT '' COMMENT '订单号',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员升级时所升级的会员级别ID，默认0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  PRIMARY KEY (`moneyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='金额明细表';


-- -----------------------------
-- Table structure for `ey_users_notice`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice`;
CREATE TABLE `ey_users_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT '' COMMENT '通知标题',
  `users_id` text NOT NULL COMMENT '用户id',
  `usernames` text NOT NULL COMMENT '用户名字符串',
  `remark` text COMMENT '通知信息',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_read`;
CREATE TABLE `ey_users_notice_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `notice_id` int(10) DEFAULT NULL COMMENT '站内信id',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读, 1---是, 0---否',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除, 1---是, 0---否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户已读站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl`;
CREATE TABLE `ey_users_notice_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '站内信标题',
  `tpl_content` text COMMENT '发送内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '站内信发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='站内信模板表';

-- -----------------------------
-- Records of `ey_users_notice_tpl`
-- -----------------------------
INSERT INTO `ey_users_notice_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请到内容管理中查看！', '${content}', '1', '1', '1616460912', '1616460912');
INSERT INTO `ey_users_notice_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', '1616460912', '1616460912');
INSERT INTO `ey_users_notice_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', '1616460912', '1616460912');
INSERT INTO `ey_users_notice_tpl` VALUES ('7', '投稿提醒', '您有新的投稿文档，请及时查看！', '${content}', '20', '0', '1616460912', '1616460912');

-- -----------------------------
-- Table structure for `ey_users_notice_tpl_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl_content`;
CREATE TABLE `ey_users_notice_tpl_content` (
  `content_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，对应 users_notice_tpl 表 send_scene 字段',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID，不为空则表示管理员接收信息',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID，不为空则表示会员接收信息，暂未使用',
  `content_title` varchar(200) DEFAULT '' COMMENT '通知标题',
  `content` text COMMENT '接收的通知内容',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读，默认0，1是，0否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`content_id`),
  KEY `admin_id` (`admin_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内信发送接收记录表';


-- -----------------------------
-- Table structure for `ey_users_parameter`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_parameter`;
CREATE TABLE `ey_users_parameter` (
  `para_id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '是否为系统属性，系统属性不可删除，1为是，0为否，默认0。',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否禁用属性，1为是，0为否',
  `is_required` tinyint(1) DEFAULT '0' COMMENT '是否为必填属性，1为是，0为否，默认0。',
  `is_reg` tinyint(1) DEFAULT '1' COMMENT '是否为注册表单，1为是，0为否',
  `placeholder` varchar(255) DEFAULT '' COMMENT '提示文字',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`para_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员属性表(字段)';

-- -----------------------------
-- Records of `ey_users_parameter`
-- -----------------------------
INSERT INTO `ey_users_parameter` VALUES ('1', '手机号码', 'mobile_1', 'mobile', '', '1', '0', '0', '1', '', '1', '0', '1591957363');
INSERT INTO `ey_users_parameter` VALUES ('2', '邮箱地址', 'email_2', 'email', '', '1', '0', '1', '1', '', '1', '0', '1591957363');

-- -----------------------------
-- Table structure for `ey_users_recharge_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_recharge_pack`;
CREATE TABLE `ey_users_recharge_pack` (
  `pack_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员充值套餐ID',
  `pack_names` varchar(100) NOT NULL DEFAULT '' COMMENT '会员充值套餐名称',
  `pack_face_value` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员充值套餐充值面值',
  `pack_pay_prices` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员充值套餐购买价格',
  `pack_sales_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员充值套餐销售数量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '会员充值套餐状态(1:开启; 2:关闭;)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pack_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员充值套餐列表';


-- -----------------------------
-- Table structure for `ey_users_recharge_pack_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_recharge_pack_order`;
CREATE TABLE `ey_users_recharge_pack_order` (
  `order_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员充值套餐订单ID',
  `pack_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员充值套餐ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `order_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单状态(1:未支付; 2:已支付(未执行充值); 3:已充值(已执行充值); 4:已过期;)',
  `order_pack_names` varchar(100) NOT NULL DEFAULT '' COMMENT '会员充值套餐名称',
  `order_face_value` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单充值面值',
  `order_pay_prices` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单支付价格',
  `order_pay_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单支付编号(待用)',
  `order_pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `order_pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `order_pay_terminal` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单终端(1:电脑端; 2:手机端; 3:微信小程序; 4:抖音小程序)',
  `order_pay_details` text COMMENT '支付成功返回的数据，serialize序列化存入',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  KEY `pack_id` (`pack_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员充值套餐订单';


-- -----------------------------
-- Table structure for `ey_users_score`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_score`;
CREATE TABLE `ey_users_score` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '积分明细表',
  `type` tinyint(2) DEFAULT '1' COMMENT '类型:1-提问,2-回答,3-最佳答案4-悬赏退回,5-每日签到,6-管理员编辑,7-问题悬赏/获得悬赏,8-消费赠送积分,9-积分兑换/退回,10-登录赠送积分',
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `ask_id` int(10) DEFAULT '0' COMMENT '问题id',
  `reply_id` int(10) DEFAULT '0' COMMENT '回答id',
  `score` varchar(20) NOT NULL DEFAULT '' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值,同score',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `info` varchar(255) DEFAULT '' COMMENT '说明',
  `add_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  `current_score` int(10) DEFAULT '0' COMMENT '当前积分',
  `current_devote` int(10) DEFAULT '0' COMMENT '当前贡献值',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分详情表';


-- -----------------------------
-- Table structure for `ey_users_signin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_signin`;
CREATE TABLE `ey_users_signin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '签到时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户签到表';


-- -----------------------------
-- Table structure for `ey_users_type_manage`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_type_manage`;
CREATE TABLE `ey_users_type_manage` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_name` varchar(30) DEFAULT '' COMMENT '类型名称',
  `level_id` int(10) DEFAULT '0' COMMENT '会员等级ID',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `limit_id` int(10) DEFAULT '0' COMMENT '会员期限限制，存储ID，值对应常量表的admin_member_limit_arr数组',
  `activity` varchar(30) DEFAULT '' COMMENT '活动文案',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员产品类型表';

-- -----------------------------
-- Records of `ey_users_type_manage`
-- -----------------------------
INSERT INTO `ey_users_type_manage` VALUES ('1', '升级为中级会员', '2', '100.00', '2', '', '100', '1564532901', '1610620458');
INSERT INTO `ey_users_type_manage` VALUES ('2', '升级为高级会员', '3', '200.00', '3', '', '100', '1564532901', '1610620458');

-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` longtext COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `position` varchar(30) DEFAULT 'default' COMMENT '插件位置',
  `is_buy` tinyint(1) DEFAULT '0' COMMENT '0-本地,1-线上购买 2-线上购买,但已删除,不显示在我的插件列表',
  `is_upgrade` tinyint(1) DEFAULT '1' COMMENT '是否提示升级',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `quick_sort` int(10) DEFAULT '100' COMMENT '首页快捷菜单专用排序号',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是(首页快捷菜单用)',
  PRIMARY KEY (`id`),
  KEY `code` (`code`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=362 DEFAULT CHARSET=utf8 COMMENT='插件应用表';

-- -----------------------------
-- Records of `ey_weapp`
-- -----------------------------
INSERT INTO `ey_weapp` VALUES ('1', 'Verify', '商品核销', '{\"code\":\"Verify\",\"name\":\"\\u5546\\u54c1\\u6838\\u9500\",\"version\":\"v1.0.4\",\"min_version\":\"v1.1.1\",\"author\":\"chenfy\",\"description\":\"\\u5b9e\\u73b0\\u7ebf\\u4e0a\\u548c\\u7ebf\\u4e0b\\u6d88\\u8d39\\u573a\\u666f\\u7684\\u6253\\u901a\\uff0c\\u8f7b\\u677e\\u4e3a\\u7ebf\\u4e0b\\u5e97\\u94fa\\u5f15\\u6d41\",\"litpic\":\"\\/weapp\\/Verify\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":{\"href\":\"\\/login.php?m=admin&c=Weapp&a=execute&sm=Verify&sc=Verify&sa=config\",\"target\":\"_self\"}}', 'a:2:{s:10:\"openVerify\";i:0;s:16:\"openSecondVerify\";i:0;}', '1', '1', '1', 'default', '0', '1', '100', '1713260411', '1728441391', '3', '1');
INSERT INTO `ey_weapp` VALUES ('2', 'EyouGzhLogin', '后台扫码登录', '{\"code\":\"EyouGzhLogin\",\"name\":\"\\u540e\\u53f0\\u626b\\u7801\\u767b\\u5f55\",\"version\":\"v1.0.3\",\"min_version\":\"v1.1.1\",\"author\":\"\\u5c0f\\u864e\\u54e5\",\"description\":\"\\u652f\\u6301\\u626b\\u7801\\u516c\\u4f17\\u53f7\\u767b\\u5f55\\u3001\\u5fae\\u4fe1\\u5e94\\u7528\\u767b\\u5f55\\uff0c\\u6839\\u636e\\u4e2a\\u4eba\\u9700\\u8981\\u9009\\u62e9\\u4e0d\\u540c\\u7684\\u626b\\u7801\\u65b9\\u5f0f\\uff0c\\u626b\\u7801\\u516c\\u4f17\\u53f7\\u53ef\\u4ee5\\u4e0d\\u9700\\u8981\\u7533\\u8bf7\\u5fae\\u4fe1\\u5e94\\u7528\\uff0c\\u540c\\u65f6\\u4e5f\\u8282\\u7701\\u5fae\\u4fe1\\u5f00\\u653e\\u5e73\\u53f0\\u7684\\u6bcf\\u5e74300\\u5143\\u8d39\\u7528\\u3002\",\"litpic\":\"\\/weapp\\/EyouGzhLogin\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":[]}', 'a:4:{s:7:\"is_open\";i:0;s:4:\"mode\";s:12:\"userGzhLogin\";s:12:\"install_time\";i:0;s:3:\"gzh\";a:2:{s:5:\"force\";i:0;s:6:\"switch\";i:1;}}', '1', '2', '1', 'default', '0', '1', '100', '1713401007', '1723088495', '4', '0');
INSERT INTO `ey_weapp` VALUES ('3', 'Mbackend', 'WAP后台', '{\"code\":\"Mbackend\",\"name\":\"WAP\\u540e\\u53f0\",\"version\":\"v1.0.4\",\"min_version\":\"v1.1.1\",\"author\":\"\\u5c0f\\u864e\\u54e5\",\"description\":\"WAP\\u540e\\u53f0\\u7ba1\\u7406\",\"litpic\":\"\\/weapp\\/Mbackend\\/logo.png\",\"scene\":\"1\",\"subroot\":\"on\",\"permission\":[],\"management\":{\"href\":\"\\/login.php?m=admin&c=Weapp&a=execute&sm=Mbackend&sc=Mbackend&sa=config&isMobile=1\",\"target\":\"_self\"}}', 'a:2:{s:6:\"status\";i:0;s:9:\"loginMode\";a:2:{i:0;s:7:\"default\";i:1;s:12:\"userGzhLogin\";}}', '1', '1', '1', 'default', '0', '1', '100', '1713401011', '1723088495', '5', '1');
INSERT INTO `ey_weapp` VALUES ('4', 'PointsShop', '积分商城', '{\"code\":\"PointsShop\",\"name\":\"\\u79ef\\u5206\\u5546\\u57ce\",\"version\":\"v1.0.3\",\"min_version\":\"v1.1.1\",\"author\":\"chenfy\",\"description\":\"\\u79ef\\u5206\\u8d2d\\u4e70\\u5546\\u54c1\\uff0c\\u5f62\\u6210\\u79ef\\u5206\\u8425\\u9500\\u95ed\\u73af\",\"litpic\":\"\\/weapp\\/PointsShop\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":[]}', 'a:4:{s:10:\"openPoints\";i:0;s:9:\"afterSale\";i:1;s:13:\"afterSaleRule\";i:1;s:17:\"afterSaleRuleDays\";i:15;}', '1', '1', '1', 'default', '0', '1', '100', '1713403402', '1728441391', '2', '1');
INSERT INTO `ey_weapp` VALUES ('5', 'WxLogin', '微信扫码登录', '{\"code\":\"WxLogin\",\"name\":\"\\u5fae\\u4fe1\\u626b\\u7801\\u767b\\u5f55\",\"version\":\"v1.2.3\",\"min_version\":\"v1.1.1\",\"author\":\"\\u5927\\u9ec4\",\"description\":\"\\u7535\\u8111\\u7aef\\u4f1a\\u5458\\u767b\\u5f55\\u65f6\\u53ef\\u4ee5\\u76f4\\u63a5\\u5fae\\u4fe1\\u626b\\u7801\\u767b\\u5f55\",\"litpic\":\"\\/weapp\\/WxLogin\\/logo.png\",\"scene\":\"2\",\"permission\":[]}', '', '1', '2', '1', 'default', '0', '1', '100', '1712902448', '1722934903', '7', '0');
INSERT INTO `ey_weapp` VALUES ('6', 'DealerPlugin', '分销推广', '{\"code\":\"DealerPlugin\",\"name\":\"\\u5206\\u9500\\u63a8\\u5e7f\",\"version\":\"v1.0.2\",\"min_version\":\"v1.1.1\",\"author\":\"chenfy\",\"description\":\"\\u5206\\u9500\\u63a8\\u5e7f\\u548c\\u8fd4\\u4f63\\u7ed3\\u7b97\",\"litpic\":\"\\/weapp\\/DealerPlugin\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":[]}', '', '1', '1', '1', 'default', '0', '1', '100', '1713492361', '1723088495', '6', '1');
INSERT INTO `ey_weapp` VALUES ('7', 'Coupons', '优惠券', '{\"code\":\"Coupons\",\"name\":\"\\u4f18\\u60e0\\u5238\",\"version\":\"v1.0.0\",\"min_version\":\"v1.1.1\",\"author\":\"\\u5c0f\\u864e\\u54e5\",\"description\":\"\\u4f18\\u60e0\\u5238\\u53ef\\u8bbe\\u7f6e\\u4f18\\u60e0\\u91d1\\u989d\\u3001\\u4f7f\\u7528\\u95e8\\u69db\\u3001\\u53d1\\u5238\\u91cf\\u81ea\\u4e3b\\u914d\\u7f6e\\uff0c\\u4fc3\\u8fdb\\u7535\\u5b50\\u5546\\u57ce\\u7684\\u4e0b\\u5355\\u8f6c\\u5316\",\"litpic\":\"\\/weapp\\/Coupons\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":[]}', '', '1', '1', '1', 'default', '0', '1', '100', '1713403408', '1723088495', '1', '1');
INSERT INTO `ey_weapp` VALUES ('8', 'Hupijiaopay', '虎皮椒支付', '{\"code\":\"Hupijiaopay\",\"name\":\"\\u864e\\u76ae\\u6912\\u652f\\u4ed8\",\"version\":\"v1.1.1\",\"min_version\":\"v1.1.1\",\"author\":\"\\u9648\\u98ce\\u4efb\",\"description\":\"\\u864e\\u76ae\\u6912\\u652f\\u4ed8\",\"litpic\":\"\\/weapp\\/Hupijiaopay\\/logo.png\",\"scene\":\"0\",\"permission\":[],\"management\":[]}', '', '0', '1', '1', 'default', '0', '1', '100', '1718963663', '1723088495', '100', '0');
INSERT INTO `ey_weapp` VALUES ('9', 'Querykd', '快递100查询API', '{\"code\":\"Querykd\",\"name\":\"\\u5feb\\u9012100\\u67e5\\u8be2API\",\"version\":\"v1.0.0\",\"min_version\":\"v1.1.1\",\"author\":\"\\u5c0f\\u864e\\u54e5\",\"description\":\"\\u4e00\\u952e\\u63a5\\u5165\\u5feb\\u9012100\\u67e5\\u8be2API\\uff0c\\u53ef\\u5bf9\\u63a5\\u5c0f\\u7a0b\\u5e8f\\u3002\",\"litpic\":\"\\/weapp\\/Querykd\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":[]}', '', '1', '1', '1', 'default', '0', '1', '100', '1718963663', '1723088495', '8', '0');
INSERT INTO `ey_weapp` VALUES ('361', 'Seckill', '秒杀抢购', '{\"code\":\"Seckill\",\"name\":\"\\u79d2\\u6740\\u62a2\\u8d2d\",\"version\":\"v1.1.0\",\"min_version\":\"v1.1.1\",\"author\":\"\\u5927\\u9ec4\",\"description\":\"\\u4f4e\\u4ef7\\u3001\\u9650\\u8d2d\\uff0c\\u5438\\u5f15\\u66f4\\u591a\\u4f1a\\u5458\",\"litpic\":\"\\/weapp\\/Seckill\\/logo.png\",\"scene\":\"0\",\"subroot\":\"on\",\"permission\":[],\"management\":[]}', '', '1', '1', '1', 'default', '0', '1', '100', '1727333140', '0', '100', '0');

-- -----------------------------
-- Table structure for `ey_weapp_coupons`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_coupons`;
CREATE TABLE `ey_weapp_coupons` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) DEFAULT '0' COMMENT '优惠券金额，例如10',
  `coupon_discount` decimal(2,1) DEFAULT '0.0' COMMENT '优惠券折扣,范围0.1-9.9',
  `conditions_use` decimal(10,2) DEFAULT '0.00' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned DEFAULT '0' COMMENT '优惠券库存，例如100',
  `coupon_intro` varchar(1000) DEFAULT '' COMMENT '优惠券说明',
  `redeem_authority` varchar(255) DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_limit` tinyint(3) DEFAULT '0' COMMENT '优惠使用限制,0-不限制,1-不可与会员折扣同时使用',
  `use_limit_num` mediumint(8) DEFAULT '0' COMMENT '每人领取张数,0-不限制',
  `use_start_time` int(11) DEFAULT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) DEFAULT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券主表';


-- -----------------------------
-- Table structure for `ey_weapp_coupons_use`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_coupons_use`;
CREATE TABLE `ey_weapp_coupons_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) DEFAULT '0' COMMENT '优惠券有效结束时间',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `source` tinyint(3) DEFAULT '1' COMMENT '1-前台领取 2-抽奖 3-后台发放',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';


-- -----------------------------
-- Table structure for `ey_weapp_dealer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_dealer`;
CREATE TABLE `ey_weapp_dealer` (
  `dealer_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_name` varchar(30) NOT NULL DEFAULT '' COMMENT '分销商的真实姓名',
  `dealer_mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '分销商的手机号',
  `dealer_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分销商状态(1:正常; 2:冻结;)',
  `dealer_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分销商佣金总额(可用提现总额)',
  `freeze_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分销商冻结总额(申请提现总额)',
  `withdraw_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分销商提现总额(成功提现总额)',
  `system_dealer` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否系统分销商(0:用户分销商; 1:系统分销商;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`dealer_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商信息';


-- -----------------------------
-- Table structure for `ey_weapp_dealer_apply`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_dealer_apply`;
CREATE TABLE `ey_weapp_dealer_apply` (
  `apply_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_name` varchar(30) NOT NULL DEFAULT '' COMMENT '分销商的真实姓名',
  `dealer_mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '分销商的手机号',
  `apply_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '申请方式(0:后台审核; 1:无需审核;)',
  `apply_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `review_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态(1:等待审核; 2:审核通过; 3:审核驳回(可重新申请); 4:拉黑(不允许再申请);)',
  `review_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `review_reason` varchar(500) NOT NULL DEFAULT '' COMMENT '审核原因',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`apply_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商申请';


-- -----------------------------
-- Table structure for `ey_weapp_dealer_money_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_dealer_money_log`;
CREATE TABLE `ey_weapp_dealer_money_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商ID(同 weapp_dealer 表 dealer_id)',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商订单ID(log_type=1结算增加时存入)',
  `withdraw_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商提现ID(log_type=2提现减少时存入)',
  `log_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '记录类型(1:结算增加; 2:提现减少;)',
  `log_before_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '记录本次操作前的分销商佣金',
  `log_action_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '记录本次操作的分销商佣金',
  `log_after_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '记录本次操作后的分销商佣金',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录说明',
  `log_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分销商佣金记录是否显示(1:显示; 2:不显示;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `dealer_id` (`dealer_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `withdraw_id` (`withdraw_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商佣金操作记录';


-- -----------------------------
-- Table structure for `ey_weapp_dealer_withdraw`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_dealer_withdraw`;
CREATE TABLE `ey_weapp_dealer_withdraw` (
  `withdraw_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商ID(同 weapp_dealer 表 dealer_id)',
  `withdraw_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '提现金额',
  `withdraw_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '提现方式 (1余额 2微信)',
  `withdraw_order` varchar(30) NOT NULL DEFAULT '' COMMENT '系统本身提现订单号',
  `review_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态(1:等待审核; 2:审核通过; 3:审核驳回; 4:提现成功(已打款到指定账户);)',
  `review_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `review_reason` varchar(500) NOT NULL DEFAULT '' COMMENT '审核原因',
  `wechat_order` varchar(50) NOT NULL DEFAULT '' COMMENT '微信返回的支付订单号',
  `wechat_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信返回的支付时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`withdraw_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `dealer_id` (`dealer_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商提现';


-- -----------------------------
-- Table structure for `ey_weapp_points_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_points_goods`;
CREATE TABLE `ey_weapp_points_goods` (
  `goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '积分商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '系统文档主表ID(archives 表 aid 字段)',
  `goods_spec` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否有规格(0:无; 1:有;)',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品购买所需价格',
  `goods_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品购买所需积分',
  `goods_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `goods_cookie` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品操作者记录cookie值(时间戳)',
  `goods_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品上下架状态(1:上架; 2:下架;)',
  `goods_shipping` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品运费设置(1:读取系统设置; 2:包邮;)',
  `goods_save` tinyint(1) un