<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace think\template\taglib\eyou;

class TagDiyurl extends Base
{
    protected function _initialize()
    {
        parent::_initialize();
    }

    public function getDiyurl($type = 'tags', $link = '', $vars = '', $suffix = '', $domain = '', $seo_pseudo = '', $seo_pseudo_format = '', $seo_inlet = '', $class = 'ey_active')
    {
        $suffix = !empty($suffix) ? $suffix : true;
        $domain = !empty($domain) ? $domain : false;
        $seo_pseudo = !empty($seo_pseudo) ? $seo_pseudo : null;
        $seo_pseudo_format = !empty($seo_pseudo_format) ? $seo_pseudo_format : null;
        $seo_inlet = !empty($seo_inlet) ? $seo_inlet : null;

        $parseStr = "";
        
        if (in_array(self::$request->controller(), ['Search', 'Lists', 'Tags', 'Buildhtml'])) {
            // 获取URL链接上的所有参数
            $params = self::$request->get();
            // 如果没有模型ID并且是全部商品页面则channelid=2
            if (empty($params['channelid']) && 'goods_all' == self::$request->action()) $params['channelid'] = 2;
            // 获取已处理好的 tid
            $params['tid'] = !empty($this->tid) ? $this->tid : '';
            // 排序条件
            $sortAsc = !empty($params['sort_asc']) && 'desc' == $params['sort_asc'] ? 'asc' : 'desc';
            // 伪静态下则获取 request 数据
            $params['m'] = 'home';
            $params['c'] = !empty($params['c']) ? $params['c'] : self::$request->controller();
            $params['a'] = !empty($params['a']) ? $params['a'] : self::$request->action();

            /*--------------兼容生成静态页面 start---------------*/
            if (self::$request->controller() == 'Buildhtml') {
                if (!empty($params['tid'])) {
                    $params['c'] = 'Lists';
                    $params['a'] = 'index';
                } else if (!empty($params['tagid'])) {
                    $params['c'] = 'Tags';
                    $params['a'] = 'lists';
                }
                unset($params['page']);
                unset($params['_ajax']);
            }
            /*--------------兼容生成静态页面 end---------------*/

            if (empty($params['tid'])) unset($params['tid']);
            // 当前模型、控制器、方法
            $dynamicURL = "{$params['m']}/{$params['c']}/{$params['a']}";
            // 删除指定参数
            unset($params['m'], $params['c'], $params['a'], $params['sort_asc']);
            if (!empty($type) && 'DefaultUrl' == $type) {
                // 默认排序
                $urlList['DefaultUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'default');
            } else if (!empty($type) && 'NewUrl' == $type) {
                // 最新排序
                $urlList['NewUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'new');
            } else if (!empty($type) && 'AppraiseUrl' == $type) {
                // 评价数排序(默认高到低排序)
                $urlList['AppraiseUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'appraise', $sortAsc);
            } else if (!empty($type) && 'SalesUrl' == $type) {
                // 销量数排序(默认高到低排序)
                $urlList['SalesUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'sales', $sortAsc);
            } else if (!empty($type) && 'CollectionUrl' == $type) {
                // 收藏数排序(默认高到低排序)
                $urlList['CollectionUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'collection', $sortAsc);
            } else if (!empty($type) && 'ClickUrl' == $type) {
                // 点击数排序(默认高到低排序)
                $urlList['ClickUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'click', $sortAsc);
            } else if (!empty($type) && 'DownloadUrl' == $type) {
                // 下载数排序(默认高到低排序)
                $urlList['DownloadUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'download', $sortAsc);
            } else if (!empty($type) && 'PriceUrl' == $type) {
                // 价格排序
                $urlList['PriceUrl'] = $this->getSortHtmlCode($dynamicURL, $params, $class, 'price', $sortAsc);
            }
            // 取出指定的URL
            $parseStr = !empty($urlList[$type]) ? $urlList[$type] : '';
        }

        if (empty($parseStr)) {
            switch ($type) {
                case "tags":     // 标签主页
                    $parseStr = tagurl('home/Tags/index');
                    break;
                case "login":     // 登录
                    $parseStr = url('user/Users/login');
                    break;
                case "login_users": // 登录后跳转到会员中心
                    $url = url('user/Users/login');
                    if (stristr($url, '?')) {
                        $parseStr = $url."&referurl=".urlencode(url('user/Users/index'));
                    } else {
                        $parseStr = $url."?referurl=".urlencode(url('user/Users/index'));
                    }
                    break;
                case "reg":     // 注册
                    $parseStr = url('user/Users/reg');
                    break;
                case "mobile":     // 发送手机短信方法
                case "Mobile":     // 发送手机短信方法
                    $parseStr = url('api/Ajax/SendMobileCode');
                    break;
                case "sindex":     // 搜索主页
                    $parseStr = url('home/Search/index');
                    break;
                default:
                    {
                        if (stristr($link, '/')) {
                            $parseStr = url($link, $vars, $suffix, $domain, $seo_pseudo, $seo_pseudo_format, $seo_inlet);
                        } else {
                            $parseStr = "";
                        }
                    }
                    break;
            }
        }

        return $parseStr;
    }

    // --------------------陈风任----------------------- //
    // 获取URL后封装成HTML代码返回
    private function getSortHtmlCode($dynamicURL = '', $params = [], $class = '', $sort = '', $sortAsc = '')
    {
        // 判断当前选中的排序方式进行样式标记
        $classNew = $this->getClassValue($params, $class, $sort);
        // 整合参数数组
        $paramsNew = !empty($sort) ? array_merge($params, ['sort' => $sort]) : $params;
        // 若存在排序条件则执行
        if (!empty($sortAsc) && isset($params['sort']) && $sort == $params['sort']) {
            $paramsNew['sort_asc'] = $sortAsc;
        } else {
            $paramsNew['sort_asc'] = 'desc';
        }
        // 获取动态URL
        $dynamicURL = $this->dynamicURL($dynamicURL, $paramsNew);
        // 获取HTML代码返回
        return $this->getHtmlCode($dynamicURL, $params, $class, $classNew, $sort);
    }

    // 判断当前选中的排序方式进行样式标记
    private function getClassValue($params = [], $class = '', $sort = '')
    {
        $classNew = '';
        if (!empty($params['sort']) && 'new' == $params['sort'] && 'new' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'appraise' == $params['sort'] && 'appraise' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'sales' == $params['sort'] && 'sales' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'collection' == $params['sort'] && 'collection' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'click' == $params['sort'] && 'click' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'download' == $params['sort'] && 'download' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'price' == $params['sort'] && 'price' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else if (!empty($params['sort']) && 'default' == $params['sort'] && 'default' == $sort) {
            $classNew = $class . ' ' . $sort;
        } else {
            $class = !empty($class) ? explode(' ', $class) : [];
            if (!empty($class)) {
                // $class[0] = $sort;
                if (!empty($class[0])) unset($class[0]);
                if (!empty($class)) $classNew = implode(' ', $class);
            }
        }
        return $classNew;
    }

    // 封装纯动态url
    private function dynamicURL($dynamicURL = '', $paramsNew = []) 
    {
        // 拆分URL
        $getMca = !empty($dynamicURL) ? explode('/', $dynamicURL) : [];
        if (empty($getMca)) {
            $returnUrl = ROOT_DIR . '/index.php?m=home&c=Lists&a=index';
        } else {
            $returnUrl = ROOT_DIR . '/index.php?m=' . $getMca[0] . '&c=' . $getMca[1] . '&a=' . $getMca[2];
        }
        // 拼装URL及参数
        $url_screen_var = config('global.url_screen_var');
        foreach (['index','findex','achieve','s','page',$url_screen_var] as $_uk => $_uv) {
            if (isset($paramsNew[$_uv])) {
                unset($paramsNew[$_uv]);
            }
        }
        $paramsNew[$url_screen_var] = 1;
        if (!empty($paramsNew)) $returnUrl .= '&' . http_build_query($paramsNew);
        // 返回URL
        return urldecode($returnUrl);
    }

    // 封装HTML代码
    private function getHtmlCode($dynamicURL = '', $params = [], $class = '', $classNew = '', $sort = '')
    {
        if (empty($dynamicURL)) return false;
        // 选中默认或初始时执行
        if (empty($params['sort'])) $params['sort'] = 'default';
        if ('default' == $params['sort'] && 'default' == $sort) $classNew = $class;
        // 返回已封装的HTML代码
        return " href=\"JavaScript:void(0);\" onclick=\"window.location.href='{$dynamicURL}';\" class=\"{$classNew}\" ";
    }
    // --------------------分割线----------------------- //
}