<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace think\template\taglib\api;

use think\Db;
use app\home\logic\FieldLogic;

/**
 * 秒杀插件
 */
class TagWeappSeckill extends Base
{

    //初始化
    protected function _initialize()
    {
        parent::_initialize();
    }

    /**
     * 获取秒杀列表
     */
    public function getList($page = 1, $pagesize = 10)
    {
        //检测是否安装秒杀插件
        if (is_dir('./weapp/Seckill/')) {
            $SeckillRow = model('Weapp')->getWeappList('Seckill');
            if (!empty($SeckillRow) && 1 != intval($SeckillRow['status'])) {
                return false;
            }
        } else {
            return false;
        }

        $map['in_progress'] = 1;
        $map['activity_channel'] = ['like',"%,".self::$provider.",%"];
        $seckill = Db::name('weapp_seckill')->where($map)->find();
        if (empty($seckill)) return false;

        $seckill['end_time_value'] = intval($seckill['end_time']);
        $seckill['start_time'] = date('Y-m-d H:i:s',$seckill['start_time']);
        $seckill['end_time'] = date('Y/m/d H:i:s',$seckill['end_time']);
        $seckill['status'] = 1;//进行中

        $where = [
            'a.act_id' => $seckill['id'],
        ];
        $field = 'b.*,a.seckill_price,a.seckill_stock,a.buy_users_count,a.buy_count,a.goods_id,a.is_spec';
        $paginate = array(
            'page' => $page,
        );
        $pages = Db::name('weapp_seckill_archives')
            ->alias('a')
            ->join('archives b', 'a.aid = b.aid', 'left')
            ->field($field)
            ->where($where)
            ->order('a.buy_count desc')
            ->paginate($pagesize, false, $paginate);
        $result = $pages->toArray();
        if (!empty($result['data'])) {
            $is_spec_aids = [];
            foreach ($result['data'] as $key => $val) {
                $val['sale_percent'] = 100;
                //单规格 销售比
                if (empty($val['is_spec'])){
                    if (empty($val['buy_count'])){
                        $val['sale_percent'] = 0;
                    }elseif (!empty($val['buy_count']) && !empty($val['seckill_stock'])){
                        $val['sale_percent'] = floor(($val['buy_count']/($val['buy_count']+$val['seckill_stock']))*1000)/10;
                    }
                }

                $val['users_price_arr'] = explode('.', sprintf("%.2f", $val['users_price']));
                $val['litpic'] = $this->get_default_pic($val['litpic']);
                $result['data'][$key] = $val;
                if (!empty($val['is_spec'])) $is_spec_aids[] = $val['aid'];
            }
            if (!empty($is_spec_aids)) {
                $spec_data = Db::name('weapp_seckill_product_spec_value')->where('act_id', $seckill['id'])->where('aid', 'in', $is_spec_aids)
                    ->field('min(seckill_price) as seckill_price,aid')->group('aid')->getAllWithIndex('aid');
                $percent_data = Db::name('weapp_seckill_product_spec_value')->where('act_id', $seckill['id'])->where('aid', 'in', $is_spec_aids)
                    ->field('sum(seckill_stock) as seckill_stock,aid')->group('aid')->getAllWithIndex('aid');
                if (!empty($spec_data)) {
                    foreach ($result['data'] as $key => $val) {
                        //多规格 销售比
                        if (!empty($val['is_spec'])) {
                            if (empty($val['buy_count'])) {
                                $result['data'][$key]['sale_percent'] = 0;
                            } else if (!empty($val['buy_count']) && !empty($percent_data[$val['aid']]['seckill_stock'])) {
                                $result['data'][$key]['sale_percent'] = floor(($val['buy_count'] / ($val['buy_count'] + $percent_data[$val['aid']]['seckill_stock']))*1000)/10;
                            }
                        }
                        if (!empty($spec_data[$val['aid']])) $result['data'][$key]['seckill_price'] = $spec_data[$val['aid']]['seckill_price'];

                        $result['data'][$key]['users_price_arr'] = explode('.', sprintf("%.2f", $result['data'][$key]['users_price']));
                        $result['data'][$key]['seckill_price_arr'] = explode('.', sprintf("%.2f", $result['data'][$key]['seckill_price']));
                    }
                }
            }
        }

        $seckill['arc_list'] = $result;
        return $seckill;
    }

    /**
     * 获取秒杀商品详情
     * $addfields = '', $titlelen = '',
     */
    public function getProductView($goods_id = 0, $users = [])
    {
        //检测是否安装秒杀插件
        if (is_dir('./weapp/Seckill/')) {
            $SeckillRow = model('Weapp')->getWeappList('Seckill');
            if (!empty($SeckillRow) && 1 != intval($SeckillRow['status'])) {
                return false;
            }
        } else {
            return false;
        }

        if (empty($goods_id)) {
            return false;
        }
        $sec_where = [
            'a.goods_id' => $goods_id,
        ];
        $seckill = Db::name('weapp_seckill_archives')
            ->alias('a')
            ->field('b.*,a.*')
            ->join('weapp_seckill b', 'b.id = a.act_id', 'LEFT')
            ->where($sec_where)
            ->find();
        if (empty($seckill)) return false;
        $seckill['start_time'] = date('Y/m/d H:i:s',$seckill['start_time']);
        $seckill['end_time'] = date('Y/m/d H:i:s',$seckill['end_time']);
        $aid = $seckill['aid'];

        $detail = Db::name('archives')
            ->alias('a')
            ->field('a.aid,a.subtitle,a.typeid,a.channel,a.title,a.litpic,a.author,a.click,a.arcrank,a.seo_title,a.seo_keywords,a.seo_description,a.users_price,
            a.sales_num,a.virtual_sales,a.sales_all,a.stock_show,a.stock_count,a.prom_type,a.add_time,a.attrlist_id,b.typename')
            ->join('arctype b', 'a.typeid = b.id', 'left')
            ->where([
                'a.aid' => $aid,
                'a.status' => 1,
                'a.is_del' => 0,
            ])
            ->find();
        if (!empty($detail)) {
            $detail['goodsLabel'] = model('ShopGoodsLabel')->getGoodsLabelList($aid, true);
            $detail['channel_ntitle'] = '商品';
            $detail['seo_title'] = $this->set_arcseotitle($detail['title'], $detail['seo_title']); // seo标题
            $detail['litpic'] = $this->get_default_pic($detail['litpic']); // 默认封面图
            $detail['content'] = '';
            //单规格秒杀库存更新 不能多于商品本来库存
            if ($seckill['seckill_stock'] > $detail['stock_count']) {
                $seckill['seckill_stock'] = $detail['stock_count'];
                Db::name('weapp_seckill_archives')->where('goods_id',$goods_id)->update(['seckill_stock'=>$detail['stock_count'],'update_time'=>getTime()]);
            }
            /*产品参数*/
            if (!empty($detail['attrlist_id'])) { // 新版参数
                $productAttrModel = new \app\home\model\ProductAttr;
                $attr_list = $productAttrModel->getProAttrNew($aid, 'a.attr_id,a.attr_name,b.attr_value,b.aid');
            } else { // 旧版参数
                $productAttrModel = new \app\home\model\ProductAttr;
                $attr_list = $productAttrModel->getProAttr($aid);
            }
            $attr_list = !empty($attr_list[$aid]) ? $attr_list[$aid] : [];
            foreach ($attr_list as $key => $val) {
                $val['attr_value'] = htmlspecialchars_decode($val['attr_value']);
                unset($val['aid']);
                $attr_list[$key] = $val;
            }
            $detail['attr_list'] = !empty($attr_list) ? $attr_list : false;   //产品默认参数

            /*规格数据*/
            $detail['spec_attr'] = $this->getSpecAttr($aid, $goods_id, $users);
            if (!empty($detail['spec_attr']['spec_value'][0])){
                $seckill['seckill_price'] = $detail['spec_attr']['spec_value'][0]['seckill_price'];
                $seckill['seckill_stock'] = $detail['spec_attr']['spec_value'][0]['seckill_stock'];
            }
            if (!empty($seckill['is_spec'])){
                $seckill['seckill_stock_spec'] = Db::name('weapp_seckill_product_spec_value')->where('goods_id',$seckill['goods_id'])->sum('seckill_stock');
            }
            /* END */

            // 产品相册
            $productImgModel = new \app\home\model\ProductImg;
            $image_list = $productImgModel->getProImg($aid, 'aid,image_url,intro');
            $image_list = !empty($image_list[$aid]) ? $image_list[$aid] : [];
            foreach ($image_list as $key => $val) {
                $val['image_url'] = $this->get_default_pic($val['image_url']);
                isset($val['intro']) && $val['intro'] = htmlspecialchars_decode($val['intro']);
                $image_list[$key] = $val;
            }
            $detail['image_list'] = !empty($image_list) ? $image_list : false;

            /*可控制的主表字段列表*/
            $detail['ifcontrolRow'] = Db::name('channelfield')->field('id,name')->where([
                'channel_id' => $detail['channel'],
                'ifmain' => 1,
                'ifeditable' => 1,
                'ifcontrol' => 0,
                'status' => 1,
            ])->getAllWithIndex('name');

            // 设置默认原价
            $detail['old_price'] = $detail['users_price'];
            $detail['product_num'] = 1;
            $detail['spec_value_id'] = '';

            if ('v1.5.1' < getVersion()) {
                //总评论数
                $detail['comment_data_count'] = Db::name('shop_order_comment')->where(['product_id' => $aid, 'is_show' => 1])->count();
                $good_count = Db::name('shop_order_comment')->where(['product_id' => $aid, 'is_show' => 1, 'total_score' => ['egt', 4]])->count();
                //好评率
                $detail['comment_good_count'] = $good_count;
                $detail['comment_good_per'] = !empty($detail['comment_data_count']) ? round($good_count / $detail['comment_data_count'], 2) : 1;
                if ($detail['comment_data_count'] > 0) {
                    $detail['comment_data'] = Db::name('shop_order_comment')
                        ->alias('a')
                        ->field('a.*,b.nickname,b.head_pic')
                        ->join('users b', 'a.users_id = b.users_id', 'left')
                        ->where(['a.product_id' => $aid, 'a.is_show' => 1])
                        ->order('a.total_score asc')
                        ->limit(2)
                        ->select();
                    foreach ($detail['comment_data'] as $k => $v) {
                        if (1 == $v['is_anonymous']) {
                            $v['nickname'] = '匿名用户';
                        }
                        $v['add_time'] = date('Y-m-d H:i:s', $v['add_time']);
                        $v['content'] = unserialize($v['content']);
                        $v['head_pic'] = get_default_pic($v['head_pic'], true);
                        $detail['comment_data'][$k] = $v;
                    }
                }
            }

            $detail['cart_total_num'] = 0;
            if (!empty($users['users_id'])) {
                //购物车数量
                $detail['cart_total_num'] = Db::name('shop_cart')->where(['users_id' => $users['users_id']])->sum('product_num');
            }

            // 获取自定义字段的数据
            $customField = [];
            $addtableName = 'product_content';
            $detailRow = Db::name($addtableName)->field('id,aid,add_time,update_time', true)->where('aid', $aid)->find();
            if (!empty($detailRow)) {
                $fieldLogic = new \app\home\logic\FieldLogic();
                $detailExt = $fieldLogic->getChannelFieldList($detailRow, $detail['channel']); // 自定义字段的数据格式处理
                if (empty($channeltypeInfo['ifsystem'])) { // 自定义模型
                    // 如果存在自定义字段content，默认作为文档的正文内容。
                    // 如果不存在，将获取第一个html类型的内容，作为文档的正文内容。
                    if (!isset($detailExt['content'])) {
                        $contentField = Db::name('channelfield')->where([
                            'channel_id' => $detail['channel'],
                            'dtype' => 'htmltext',
                        ])->getField('name');
                        $detailExt['content'] = !empty($detailExt[$contentField]) ? $detailExt[$contentField] : '';
                    }
                }
                $detail['content'] = $detailExt['content'];
                unset($detailExt['content']);

                // 手机端详情内容
                if (isset($detailExt['content_ey_m'])) {
                    $detail['content'] = empty($detailExt['content_ey_m']) ? $detail['content'] : $detailExt['content_ey_m'];
                    unset($detailExt['content_ey_m']);
                }
                $detail['content'] = $this->html_httpimgurl($detail['content'], true); // 转换内容图片为http路径

                if (!empty($detailExt)) {
                    $field = 'name, title, dtype';
                    $customField = Db::name('channelfield')->field($field)->where([
                        'name' => ['IN', array_keys($detailExt)],
                        'channel_id' => $detail['channel'],
                        'ifeditable' => 1
                    ])->getAllWithIndex('name');
                    if (!empty($customField)) {
                        foreach ($customField as $key => $value) {
                            if ('img' == $value['dtype']) {
                                $customField[$key]['value'] = $this->get_default_pic($detailExt[$key]);
                            } else if ('media' == $value['dtype']) {
                                $customField[$key]['value'] = $this->get_default_pic($detailExt[$key]);
                            } else if ('imgs' == $value['dtype']) {
                                foreach ($detailExt[$key] as $kk => $vv) {
                                    $detailExt[$key][$kk]['image_url'] = $this->get_default_pic($vv['image_url']);
                                }
                                $customField[$key]['value'] = $detailExt[$key];
                            } else {
                                $customField[$key]['value'] = $detailExt[$key];
                            }
                        }
                    }
                }
                $customField = array_values($customField);
            }
            $detail['customField'] = !empty($customField) ? $customField : false;
            $detail['seckill'] = $seckill;
        }

        return $detail;
    }

    // 获取指定商品的规格数据
    private function getSpecAttr($aid = 0, $goods_id = 0, $users = [], $order2 = '')
    {
        $ReturnData = $SpecData = $SpecValue = $SelectSpecData = [];
        if (empty($aid)) return $ReturnData;
        if (empty($users['level_discount'])) $users['level_discount'] = 100;
        // 会员折扣率
        $SelectSpecData['users_discount'] = (intval($users['level_discount']) / 100);
        //查出秒杀使用的规格
//        $spec_value_ids = Db::name('weapp_seckill_product_spec_value')->where(['aid' => $aid, 'goods_id' => $goods_id])->column('spec_value_id');
        $SpecWhere = [
            'aid' => $aid,
//            'spec_value_id' => ['in', $spec_value_ids],
//            'lang' => get_home_lang(),
//            'spec_is_select' => 1,
        ];
        $order = 'spec_value_id asc, spec_id asc';
        $field = '*, false checked';
        $ProductSpecData = Db::name('product_spec_data')->field($field)->where($SpecWhere)->where('spec_is_select',1)->order($order)->select();
        foreach ($ProductSpecData as $key => $value) {
            $ProductSpecData[$key]['spec_image'] = !empty($value['spec_image']) ? get_default_pic($value['spec_image'], true) : '';
        }
        if (!empty($ProductSpecData)) {
            $ProductSpecData = group_same_key($ProductSpecData, 'spec_mark_id');
            foreach ($ProductSpecData as $key => $value) {
//                 $value[0]['checked'] = true;
                $SpecData[] = [
                    'spec_value_id' => $value[0]['spec_value_id'],
                    'spec_mark_id' => $value[0]['spec_mark_id'],
                    'spec_name' => $value[0]['spec_name'],
                    'spec_data_new' => $value,
                ];
            }
            //秒杀商品规格库存
            $order2 = !empty($order2) ? $order2 : 'seckill_price asc';
            $ProductSpecValue = Db::name('weapp_seckill_product_spec_value')->where($SpecWhere)->where(['goods_id' => $goods_id])->order($order2)->select();
            //商品原来规格库存
            $goods_spec_field = 'spec_value_id, spec_price, spec_stock, spec_sales_num';
            $goodsSpec = Db::name('product_spec_value')->where($SpecWhere)->order('spec_price asc')->field($goods_spec_field)->getAllWithIndex('spec_value_id');
            $updateSeckillSpecValue = [];
            foreach ($ProductSpecValue as $k => $v){
                if (!empty($goodsSpec[$v['spec_value_id']])){
                    if ($goodsSpec[$v['spec_value_id']]['spec_stock'] < $v['seckill_stock']){
                        $updateSeckillSpecValue[] = [
                            'value_id' => $v['value_id'],
                            'seckill_stock' => $goodsSpec[$v['spec_value_id']]['spec_stock'],
                            'update_time' => getTime()
                        ];
                    }
                }
            }
            if (!empty($updateSeckillSpecValue)){
                $seckill_spec_value_model = new \weapp\Seckill\model\SeckillProductSpecValue();
                $seckill_spec_value_model->saveAll($updateSeckillSpecValue);
                $ProductSpecValue = $seckill_spec_value_model->where($SpecWhere)->where(['goods_id' => $goods_id])->order($order2)->select();
            }

            if (!empty($ProductSpecValue)) {
                // 默认的规格值，取价格最低者
                $SelectSpecData['spec_value_id'] = explode('_', $ProductSpecValue[0]['spec_value_id']);

                // 若存在规格并且价格存在则覆盖原有价格
                $SelectSpecData['users_price'] = $ProductSpecValue[0]['seckill_price'];

                // 若存在规格并且库存存在则覆盖原有库存
                $SelectSpecData['stock_count'] = $ProductSpecValue[0]['seckill_stock'];

                // 价格及库存
                $SpecValue = $ProductSpecValue;
            }
            foreach ($SpecData as $key => $value) {
                foreach ($value['spec_data_new'] as $kk => $vv) {
                    // 追加默认规格class
                    if (in_array($vv['spec_value_id'], $SelectSpecData['spec_value_id'])) {
                        $SpecData[$key]['spec_data_new'][$kk]['checked'] = true;
                    }
                }
            }
        }

        $ReturnData = [
            'spec_data' => $SpecData,
            'spec_value' => $SpecValue,
            'select_spec_data' => $SelectSpecData
        ];

        return $ReturnData;
    }

    //判断正常商品是否有参与秒杀活动
    public function guideSeckill($aid = 0)
    {
        $map['in_progress'] = 1;
        $map['status'] = 1;
        $map['activity_channel'] = ['like',"%,".self::$provider.",%"];
        $seckill = Db::name('weapp_seckill')->where($map)->find();
        if (empty($seckill)) return false;
        //先拿到当前正在进行的秒杀活动 再判断该商品是否存在
        $where['aid'] = $aid;
        $where['act_id'] = $seckill['id'];
        $goods_id = Db::name('weapp_seckill_archives')->where($where)->value('goods_id');
        return $goods_id;
    }
}