<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace think\template\taglib\api;

use think\Db;
use app\common\logic\DecorationLogic;

/**
 * 广告
 */
class TagAdv extends Base
{
    //初始化
    protected function _initialize()
    {
        parent::_initialize();

    }

    /**
     * 获取广告
     * @author wengxianhu by 2018-4-20
     */
    public function getAdv($pid = '', $orderby = '', $limit = '')
    {
        if (empty($pid)) {
            return false;
        }

        // 排序
        switch ($orderby) {
            case 'content_id':
                $orderby = 'content_id desc';
                break;

            case 'sort_order':
                $orderby = 'sort_order asc';
                break;

            case 'rand':
                $orderby = 'rand()';
                break;
            
            default:
                if (empty($orderby)) {
                    $orderby = 'sort_order asc, content_id desc';
                }
                break;
        }
        $result = Db("applets_ad_content")
            ->where('position_id',$pid)
            ->orderRaw($orderby)
            ->limit($limit)
            ->select();

        // 获取链接名称
        $this->decorationLogic = new DecorationLogic;
        $result = $this->decorationLogic->getAdContentLinkNames($result);

        // 数据处理
        foreach ($result as $key => $val) {
            $val['content_intro'] = htmlspecialchars_decode($val['content_intro']);
            $val['content_images'] = handle_subdir_pic($val['content_images'], 'img',true);
            $result[$key] = $val;
        }

        return [
            'data'=> !empty($result) ? $result : false,
        ];
    }
}