<?php

namespace think\process\bhvcore;

/**
 * 系统行为扩展：新增/更新/删除之后的后置操作
 */
load_trait('controller/Jump');
class BhvadminABegin {
    use \traits\controller\Jump;
    protected static $actionName;
    protected static $controllerName;
    protected static $moduleName;
    protected static $method;
    protected static $code;
    protected static $ca;
    protected static $sc;
    protected static $sa;

    /**
     * 构造方法
     * @param Request $request Request对象
     * @access public
     */
    public function __construct()
    {

    }

    // 行为扩展的执行入口必须是run
    public function run(&$params){
        self::$actionName = request()->action();
        self::$controllerName = request()->controller();
        self::$moduleName = request()->module();
        self::$method = request()->method();
        self::$ca = self::$controllerName . '@' . self::$actionName;
        self::$sc = input('param.sc/s');
        self::$sa = input('param.sa/s');
        $this->_initialize();
    }

    private function _initialize() {
        $this->checkgj();
        $this->checkbz();
        if ('POST' == self::$method) {
            if ('Weapp' == self::$controllerName) {
                $this->instok();
                $this->weapp_init();
            }
        } else {
            $this->ojbkCJ();
        }
    }

    protected function weapp_init() {
        if ('install' == self::$actionName) {
            $id = request()->param('id');
            /*基本信息*/
            $row = M('Weapp')->field('code')->find($id);
            if (empty($row)) {
                return true;
            }
            self::$code = $row['code'];
            /*--end*/
            $this->check_author();
        }
    }
    
    /**
     * @access protected
     */
    protected function check_author($timeout = 3)
    {
        $code = self::$code;

        /*数组键名*/
        $arrKey = binaryJoinChar(config('binary.15'), 13);
        /*--end*/
        $values = array(
            $arrKey => urldecode(request()->host()),
            'code'  => $code,
            'ip'    => GetHostByName($_SERVER['SERVER_NAME']),
            'key_num'=>getWeappVersion(self::$code),
        );
        $upgradeLogic = new \app\admin\logic\UpgradeLogic;
        $upgradeLogic->GetKeyData($values);
        $url = $upgradeLogic->getServiceUrl(true, 'weapp').'/index.php?m=api&c=Weapp&a=get_authortoken';
        $response = @httpRequest($url, 'POST', $values, [], 5);
        $params = json_decode($response,true);

        if (is_array($params) && 0 != $params['errcode']) {
            die($params['errmsg']);
        }

        return true;
    }

    /**
     * @access protected
     */
    private function checkbz()
    {
        $c_arr = [];
        $c_arr[] = array_join_string(array('UG','F','5Q','XB','p'));
        if (in_array(self::$controllerName, $c_arr)) {
            $key0 = array_join_string(array('d','2','Vi','L','n','dl','Yl9','p','c1','9','hd','XRo','b','3J','0b','2','tl','b','g=','='));
            $value = tpcache($key0);
            $value = !empty($value) ? intval($value) : 0;
            if (-1 == $value) {
                $data = ['code' => 0, 'icon'=>4];
                $msg = array_join_string(array('6K+','l5','7O7','57','uf5','Y+q','6ZmQ','5LqO5','o6I5','p2D','5Z','+f5','ZC','N7','7y','B'));
                $this->error($msg, null, $data);
            }
        }
    }

    /**
     * @access protected
     */
    private function checkgj()
    {
        $c_arr = $ca_arr = $sc_arr = [];
        // $c_arr[] = array_join_string(array('UG','M='));
        $ca_arr[] = array_join_string(array('Q2F','uYW','xAY','29u','Zl9','0b3','V0a','WFv','X2F','wa','Q=','='));
        $ca_arr[] = array_join_string(array('TWV','tYm','VyQ','HVzZ','XJz','X2V','kaX','Rfb','W9u','ZXk','='));
        $sc_arr[] = array_join_string(array('Vm','Vy','aW','Z','5'));
        $sc_arr[] = array_join_string(array('RGV','hbG','VyU','Gx1','Z2lu'));
        $sc_arr[] = array_join_string(array('UG9','pbnR','zU2h','vcA','=='));
        $sc_arr[] = array_join_string(array('Q29','1cG','9uc','w=','='));
        if (in_array(self::$controllerName, $c_arr) || in_array(self::$ca, $ca_arr) || in_array(self::$sc, $sc_arr)) {
            $key0 = array_join_string(array('d','2','Vi','L','n','dl','Yl9','p','c1','9','hd','XRo','b','3J','0b','2','tl','b','g=','='));
            $value = tpcache($key0);
            $value = !empty($value) ? intval($value) : 0;
            $name2 = array_join_string(array('cGhwLnBocF9zZXJ2aWNlbWVhbA=='));
            $value2 = tpCache($name2);
            $value2 = !empty($value2) ? intval($value2) : 0;
            if (2 > $value2) {
                $data = ['code' => 0, 'icon'=>4];
                $msg = array_join_string(array('6K+','l5','Yqf','6IO9','5Y+','q6Z','mQ5','LqO6','auY','57','qn5o','6I5p','2D','5Z+','f5','ZC','N7','7y','B'));
                $this->error($msg, null, $data);
            }
        }
    }

    /**
     * abc
     * @access private
     */
    private function ojbkCJ()
    {
        $ca = md5(self::$controllerName.'@'.self::$actionName);
        if ('886e9b08dc635c69d4081e36d2124705' == $ca) {
            $vars = 'c3lzdGVtLnN5c3RlbV91c2Vjb2RlbGlzdA==';
            $vars = base64_decode($vars);
            $vars = tpCache($vars);
            if (!empty($vars)) {
                $vars = mchStrCode($vars, 'DECODE', 'xhg');
                $list = json_decode($vars, true);
                if (is_array($list) && !empty($list)) {
                    $models = input('param.sm/s');
                    if (in_array($models, $list)) {
                        $msg = end($list);
                        $msg = mchStrCode($msg, 'DECODE', 'system');
                        $msg = str_ireplace('_code_', $models, $msg);
                        die($msg);
                    }
                }
            }
        }
    }

    /**
     * @access private
     */
    private function instok()
    {
        $tr = '5a6J6KOF'.'5oiQ5Yqf';
        $ca = md5(self::$controllerName.'@'.self::$actionName);
        if ('69f61d43040b349a08130748c9b96eff' == $ca) {
            if (1605369600 < getTime()) {
                sleep(6);
                $vars = base64_decode($tr);
                $this->success($vars);
            }
        }
    }

}
