<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 陈风任 <491085389@qq.com>
 * Date: 2019-1-25
 */

namespace app\user\controller;

use think\Page;
use think\Db;
use think\Config;
use think\Cookie;
use think\Request;

class Media extends Base
{
    public function _initialize()
    {
        parent::_initialize();
        $this->users_db = Db::name('users');
        $this->media_order_db = Db::name('media_order');
        $this->media_play_record_db = Db::name('media_play_record');
    }

    /**
     * 播放记录
     */
    public function play_index()
    {
        $condition['a.users_id']    = $this->users_id;
        // $condition['b.users_price'] = ['>', 0];
        // 分页
        $count = $this->media_play_record_db
            ->alias('a')
            ->join('archives b', 'a.aid=b.aid', 'inner')
            ->where($condition)
            ->group('a.aid')->count();

        $Page = $pager = new Page($count, 10);
        $show = $Page->show();
        $this->assign('page', $show);
        $this->assign('pager', $pager);

        $total_field = 'select sum(file_time) as total_time from ' . PREFIX . 'media_file where aid= a.aid';

        // 数据查询
        $list = $this->media_play_record_db
            ->where($condition)
            ->alias('a')
            ->field("a.id as play_id,a.file_id,a.aid,sum(a.play_time) as sum_play_time,max(a.update_time) as last_update_time,c.*,b.*,({$total_field}) as total_time,(sum(a.play_time)/({$total_field})) as process")
            ->join('archives b', 'a.aid=b.aid', 'inner')
            ->join('arctype c', 'b.typeid=c.id', 'left')
            ->group('a.aid')
            ->order('process desc')
            ->limit($Page->firstRow . ',' . $Page->listRows)
            ->select();

        $total_time = 0;
        // 订单处理
        foreach ($list as $key => $val) {
            $total_time              += $val['sum_play_time'];
            $val['process']          = (round($val['process'], 2) * 100) . "%";
            $val['sum_play_time']    = gmSecondFormat($val['sum_play_time'], ':');
            $val['sum_file_time']    = gmSecondFormat($val['total_time'], ':');
            $val['last_update_time'] = date('Y-m-d H:i:s', $val['last_update_time']);
            if (!empty($val['litpic'])) {
                $val['litpic'] = handle_subdir_pic($val['litpic']);
            } else {
                $val['litpic'] = get_default_pic();
            }
            $val['arcurl'] = urldecode(arcurl('home/Media/view', $val));
            $list[$key]    = $val;
        }
        // 订单列表
        $eyou['field']['list'] = $list;
        $total_time = gmSecondFormat($total_time, ':');
        $eyou['field']['total_time'] = $total_time;
        $this->assign('eyou', $eyou);

        $this->assign('delurl', url('user/Media/media_play_del'));
        return $this->fetch('users/users_media_play_index');
    }

    public function media_play_del()
    {
        if (IS_AJAX_POST) {
            $id_arr = input('del_id/a');
            $id_arr = eyIntval($id_arr);
            if (!empty($id_arr)) {
                $where = [
                    'id' => ['IN', $id_arr],
                    'users_id' => $this->users_id,
                ];
                $result = $this->media_play_record_db->where($where)->delete(true);
                if (!empty($result)) $this->success('删除成功');
            }
        }
        $this->error('删除失败');
    }

    // 视频产品购买接口
    public function media_order_buy()
    {
        if (IS_AJAX_POST) {
            // 提交的订单信息判断
            $post = input('post.');
            if (empty($post) || empty($post['aid'])) $this->error('操作异常，请刷新重试');

            // 查询是否已购买
            $where = [
                'order_status' => 1,
                'product_id' => intval($post['aid']),
                'users_id' => $this->users_id
            ];
            $MediaCount = Db::name('media_order')->where($where)->count();
            if (!empty($MediaCount)) $this->error('你已购买过，请直接观看');

            // 查看是否已生成过订单
            $where['order_status'] = 0;
            $mediaOrder = Db::name('media_order')->where($where)->order('order_id desc')->find();

            // 查询视频文档内容
            $where = [
                'is_del' => 0,
                'status' => 1,
                'aid' => $post['aid'],
                'arcrank' => ['>', -1]
            ];
            $list = Db::name('archives')->where($where)->find();
            if (empty($list)) $this->error('操作异常，请刷新重试');
            $list['users_price'] = get_discount_price($this->users, $list['users_price']);

            // 订单生成规则
            $time = getTime();
            $orderCode = date('Y') . $time . rand(10, 100);
            if (!empty($mediaOrder)) {
                $OrderID = $mediaOrder['order_id'];
                // 更新订单信息
                $OrderData = [
                    'order_code'      => $orderCode,
                    'users_id'        => $this->users_id,
                    'mobile'          => !empty($this->users['mobile']) ? $this->users['mobile'] : '',
                    'order_status'    => 0,
                    'order_amount'    => $list['users_price'],
                    'product_id'      => $list['aid'],
                    'product_name'    => $list['title'],
                    'product_litpic'  => get_default_pic($list['litpic']),
                    'add_time'        => $time,
                    'update_time'     => $time
                ];
                Db::name('media_order')->where('order_id', $OrderID)->update($OrderData);
            } else {
                // 生成订单并保存到数据库
                $OrderData = [
                    'order_code'      => $orderCode,
                    'users_id'        => $this->users_id,
                    'mobile'          => !empty($this->users['mobile']) ? $this->users['mobile'] : '',
                    'order_status'    => 0,
                    'order_amount'    => $list['users_price'],
                    'pay_time'        => '',
                    'pay_name'        => '',
                    'wechat_pay_type' => '',
                    'pay_details'     => '',
                    'product_id'      => $list['aid'],
                    'product_name'    => $list['title'],
                    'product_litpic'  => get_default_pic($list['litpic']),
                    'add_time'        => $time,
                    'update_time'     => $time
                ];
                $OrderID = Db::name('media_order')->insertGetId($OrderData);
            }

            // 保存成功
            if (!empty($OrderID)) {
                // 支付结束后返回的URL
                $return_url = input('param.return_url/s', url('user/Media/index'));
                $ReturnUrl = !empty($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : $return_url;
                cookie($this->users_id . '_' . $post['aid'] . '_EyouMediaViewUrl', $ReturnUrl);
                // 对ID和订单号加密，拼装url路径
                $Paydata = [
                    'type' => 8,
                    'order_id' => $OrderID,
                    'order_code' => $OrderData['order_code'],
                ];
                // 先 json_encode 后 md5 加密信息
                $Paystr = md5(json_encode($Paydata));
                // 清除之前的 cookie
                Cookie::delete($Paystr);
                // 存入 cookie
                cookie($Paystr, $Paydata);
                // 跳转链接
                $this->success('订单已生成！', urldecode(url('user/Pay/pay_recharge_detail', ['paystr' => $Paystr])));
            }
        } else {
            abort(404);
        }
    }

}