<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\plugins\logic;

use think\Db;
use app\plugins\model\Verify;

/**
 * 逻辑定义
 * Class CatsLogic
 * @package plugins\Logic
 */
load_trait('controller/Jump');
class VerifyLogic
{
    use \traits\controller\Jump;

    // 构造函数
    public function __construct($users = [])
    {
        // 接口参数
        $this->param = input('param.');
        if (empty($this->param['action'])) $this->param['action'] = '';
        // 当前登陆者信息
        $this->users = !empty($users) ? $users : [];
        // 模型层
        $this->verifyModel = new Verify($this->param, $this->users);
    }

    // 核销功能操作(集合方法)
    public function verifyAction($weappInfo = [])
    {
        if (!in_array($this->param['action'], ['getVerifyStoreList'])) {
            // 判断核销功能是否开启，未开启则返回会员中心
            $loadShow = 0;
            $jumpPage = '/pages/user/user';
            if (!isset($weappInfo['data']['openVerify']) || 0 === intval($weappInfo['data']['openVerify'])) {
                $this->success('核销功能已关闭', null, ['verify_open' => 0, 'jumpPage' => $jumpPage, 'loadShow' => $loadShow]);
            }
            if (empty($this->users['verify'])) {
                $this->success('您还不是核销员', null, ['staff_id' => 0, 'jumpPage' => $jumpPage, 'loadShow' => $loadShow]);
            } else if (0 === intval($this->users['verify']['staff_status'])) {
                $this->success('该核销员尚未开启核销权限', null, ['staff_status' => 0, 'jumpPage' => $jumpPage, 'loadShow' => $loadShow]);
            }
        }

        // 判断执行操作
        if ('getVerifyOrder' == $this->param['action']) {
            // 获取核销订单展示信息
            $this->verifyModel->getVerifyOrder();
        } else if ('getVerifyOrderDetails' == $this->param['action']) {
            // 获取核销订单核销详情
            $this->verifyModel->getVerifyOrderDetails();
        } else if ('confirmVerifyOrder' == $this->param['action']) {
            // 确认执行订单核销
            $this->verifyModel->confirmVerifyOrder();
        } else if ('getVerifyStoreList' == $this->param['action']) {
            // 获取核销门店列表
            $this->verifyModel->getVerifyStoreList();
        } else {
            $this->error('请正确操作！');
        }
    }

    // 获取订单核销人员信息
    public function getVerifyStaff($weappInfo = [])
    {
        $result = [];
        if (!empty($weappInfo['status']) && 1 === intval($weappInfo['status']) && !empty($this->users['users_id'])) {
            if (!empty($weappInfo['data']['openVerify']) && 1 === intval($weappInfo['data']['openVerify'])) {
                // 查询核销人员信息
                $where = [
                    'users_id' => $this->users['users_id']
                ];
                $verify = Db::name('weapp_verify_staff')->where($where)->find();
                if (!empty($verify)) $result = $verify;
            }
        }

        return $result;
    }

    // 是否显示订单核销入口
    public function showVerifyOrder($weappInfo = [])
    {
        $result = false;
        if (!empty($weappInfo['status']) && 1 === intval($weappInfo['status'])) {
            if (!empty($weappInfo['data']['openVerify']) && 1 === intval($weappInfo['data']['openVerify'])) {
                if (!empty($this->users['verify']['staff_status']) && 1 === intval($this->users['verify']['staff_status'])) {
                    $result = true;
                }
            }
        }

        return $result;
    }
}
