<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\plugins\logic;

use think\Db;
use think\Config;
use app\plugins\model\PointsShop;

/**
 * 逻辑定义
 * Class CatsLogic
 * @package plugins\Logic
 */

load_trait('controller/Jump');
class PointsShopLogic
{
    use \traits\controller\Jump;

    // 构造函数
    public function __construct($users = [])
    {
        // 接口参数
        $this->param = input('param.');
        // URL参数处理
        $this->param['m'] = !empty($this->param['m']) ? $this->param['m'] : 'plugins';
        $this->param['c'] = !empty($this->param['c']) ? $this->param['c'] : 'DealerPlugin';
        $this->param['a'] = !empty($this->param['a']) ? $this->param['a'] : ACTION_NAME;
        // 接口操作处理
        $this->param['action'] = !empty($this->param['action']) ? $this->param['action'] : '';
        // 当前登陆者信息
        $this->users = !empty($users) ? $users : [];
    }

    // 积分商城插件操作(集合方法)
    public function pointsShopAction($weappInfo = [], $terminal = '', $action = '')
    {
        // 积分商城插件是否正常开启
        $loadShow = 0;
        $jumpPage = '/pages/user/user';
        if (empty($weappInfo) || 1 !== intval($weappInfo['status'])) {
            $this->success('请求失败', null, ['errorMsg' => '商家已禁用积分商城', 'jumpPage' => $jumpPage, 'loadShow' => $loadShow]);
        }
        if (empty($weappInfo['data']['openPoints']) || 1 !== intval($weappInfo['data']['openPoints'])) {
            $this->success('请求失败', null, ['errorMsg' => '商家已关闭积分商城', 'jumpPage' => $jumpPage, 'loadShow' => $loadShow]);
        }

        // 接口操作终端
        $this->param['terminal'] = !empty($terminal) ? $terminal : 'applets';
        // 接口操作处理
        $this->param['action'] = !empty($action) ? $action : $this->param['action'];

        // 模型层
        $pointsShopModel = new PointsShop($this->param, $this->users);
    	// 判断执行操作
        if ('index' == $this->param['action']) {
            // 获取积分商城首页数据
            $pointsShopModel->getPointsShopIndex();
        } else if ('checkIns' == $this->param['action']) {
            // 会员每日签到送积分
            $pointsShopModel->usersDailyCheckIns();
        } else if ('pointsRules' == $this->param['action']) {
            // 获取系统积分规则
            $pointsShopModel->getSystemPointsRules();
        } else if ('pointsDetails' == $this->param['action']) {
            // 获取会员积分明细
            $pointsShopModel->getUsersPointsDetails();
        } else if ('goodsDetails' == $this->param['action']) {
            // 获取积分商品明细
            $pointsShopModel->getPointsGoodsDetails();
        } else if ('goodsBuyPreHandle' == $this->param['action']) {
            // 提交积分商品购买信息
            $pointsShopModel->pointsGoodsBuyPreHandle();
        } else if ('goodsBuyPage' == $this->param['action']) {
            // 提交积分商品购买页面
            $pointsShopModel->pointsGoodsBuyPage();
        } else if ('goodsBuySubmit' == $this->param['action']) {
            // 提交积分商品购买提交
            $pointsShopModel->pointsGoodsBuySubmit();
        } else {
            $this->error('请正确操作');
        }
    }

    // 是否显示积分订单入口
    public function showPointsShop($weappInfo = [])
    {
        $result = false;
        if (!empty($weappInfo['status']) && 1 === intval($weappInfo['status'])) {
            if (!empty($weappInfo['data']['openPoints']) && 1 === intval($weappInfo['data']['openPoints'])) {
                $result = true;
            }
        }

        return $result;
    }
}