<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\plugins\logic;

use think\Db;
use think\Config;
use Grafika\Color;
use Grafika\Grafika;
use app\plugins\model\DealerPlugin;
require_once ROOT_PATH . 'vendor/grafika/src/autoloader.php';

/**
 * 逻辑定义
 * Class CatsLogic
 * @package plugins\Logic
 */

load_trait('controller/Jump');
class DealerPluginLogic
{
    use \traits\controller\Jump;

    // 构造函数
    public function __construct($users = [])
    {
        // 接口参数
        $this->param = input('param.');
        if (empty($this->param['action'])) $this->param['action'] = '';
        // 当前登陆者信息
        $this->users = !empty($users) ? $users : [];
    }

    // 分销商操作(集合方法)
    public function dealerAction($terminal = '', $action = '', $appletsApi = '')
    {
        // 终端
        $this->param['terminal'] = !empty($terminal) ? $terminal : 'applets';
        // 操作
        $this->param['action'] = !empty($action) ? $action : $this->param['action'];
        // H5移动端绑定分销商下级和客户时执行
        if (model('ShopPublicHandle')->detectH5Terminal($terminal)) {
            $dealerParam = cookie('dealerParam') ? cookie('dealerParam') : session('dealerParam');
            $dealerParam = !empty($dealerParam) ? explode('_eyoucms_', json_decode(base64_decode($dealerParam), true)) : [];
            if (!empty($dealerParam[0]) && !empty($dealerParam[1])) {
                $this->param['parent_users_id'] = $dealerParam[0];
                $this->param['parent_dealer_id'] = $dealerParam[1];
            }
        }
        // 模型层
        $dealerModel = new DealerPlugin($this->param, $this->users);
        // 判断执行操作
        if ('query' == $this->param['action']) {
            // 查询分销商申请数据
            $dealerModel->queryDealerApply();
        } else if ('getApply' == $this->param['action']) {
            // 获取分销商申请数据
            $dealerModel->getDealerApply();
        } else if ('addApply' == $this->param['action']) {
            // 添加分销商申请数据
            $dealerModel->addDealerApply();
        } else if ('getDealer' == $this->param['action']) {
            // 获取分销商信息
            $dealerModel->getDealerData();
        } else if ('bindUsers' == $this->param['action']) {
            // 分销商绑定客户处理
            $dealerModel->dealerBindUsersHandle();
        } else if ('getPoster' == $this->param['action']) {
            // 分销商推广海报
            $users_id = !empty($this->users['dealer']['users_id']) ? intval($this->users['dealer']['users_id']) : 0;
            $dealer_id = !empty($this->users['dealer']['dealer_id']) ? intval($this->users['dealer']['dealer_id']) : 0;
            $dealerCommonLogic = new \weapp\DealerPlugin\logic\DealerCommonLogic($appletsApi);
            $dealerPoster = $dealerCommonLogic->getDealerPoster($users_id, $dealer_id, [], $this->param);
            if (model('ShopPublicHandle')->detectH5Terminal($terminal)) {
                return $dealerPoster;
            } else {
                if (isset($dealerPoster['status']) && empty($dealerPoster['status'])) $this->error($dealerPoster['msg']);
                $this->success('生成成功', null, $dealerPoster);
            }
        } else if ('getWithdrawApply' == $this->param['action']) {
            // 获取分销商提现申请信息
            $dealerModel->getDealerData();
        } else if ('addWithdrawApply' == $this->param['action']) {
            // 添加分销商提现申请信息
            $dealerModel->addDealerWithdrawData();
        } else if ('getWithdrawList' == $this->param['action']) {
            // 获取分销商提现申请列表
            $dealerModel->getDealerWithdrawList();
        } else if ('getMoneyList' == $this->param['action']) {
            // 获取分销商佣金明细
            $dealerModel->getDealerMoneyList();
        } else if ('getOrderList' == $this->param['action']) {
            // 获取分销商订单
            $dealerModel->getDealerOrderList();
        } else if ('getCustomerList' == $this->param['action']) {
            // 获取分销商客户
            $dealerModel->getDealerCustomerList();
        } else if ('getSubordinateList' == $this->param['action']) {
            // 获取分销商下级分销商
            $dealerModel->getDealerSubordinateList();
        } else {
            $this->error('请正确操作！');
        }
    }

}