<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\plugins\controller;

use think\Db;
use weapp\Querykd\model\QuerykdModel;

class Querykd extends Base
{
    /**
     * 实例化模型
     */
    private $model;

    /**
     * 构造方法
     */
    public function __construct(){
        parent::__construct();
        $this->model = new QuerykdModel;
    }

    public function query()
    {
        //====================================
        // 实时查询示例代码
        // 授权信息可通过链接查看：https://api.kuaidi100.com/manager/v2/myinfo/enterprise
        //====================================

        $row = $this->model->getWeappData();
        //参数设置
        $apikey = empty($row['data']['apikey']) ? '' : $row['data']['apikey']; // 客户授权key
        $customer = empty($row['data']['customer']) ? '' : $row['data']['customer']; // 查询公司编号
        $openQuerykd = empty($row['data']['openQuerykd']) ? '' : $row['data']['openQuerykd']; // 查询公司编号
        $com = input('param.com/s'); // 快递公司编码
        $num = input('param.num/s'); // 快递单号
        $phone = input('param.phone/s'); // 手机号
        $order = input('param.order/s', 'desc'); // 返回结果排序
        $param = array (
            'com' => trim($com),          // 快递公司编码
            'num' => trim($num),          // 快递单号
            'phone' => trim($phone),      // 手机号
            'from' => '',                 // 出发地城市
            'to' => '',                   // 目的地城市
            'resultv2' => '1',            // 开启行政区域解析
            'show' => '0',                // 返回格式：0：json格式（默认），1：xml，2：html，3：text
            'order' => trim($order)       // 返回结果排序:desc降序（默认）,asc 升序
        );

        if (empty($row['status'])) {
            respose(['code'=>0,'msg'=>"{$row['name']}的插件未启用"]);
        }
        else if (empty($openQuerykd)) {
            respose(['code'=>0,'msg'=>"请先开启{$row['name']}的插件功能"]);
        }
        else if (empty($apikey) || empty($customer)) {
            respose(['code'=>0,'msg'=>"请先填写{$row['name']}的插件配置"]);
        }
        else if (empty($com)) {
            respose(['code'=>0,'msg'=>"请选择快递公司"]);
        }
        else if (empty($num)) {
            respose(['code'=>0,'msg'=>"请填写快递单号"]);
        }
        else if (in_array($com, ['shunfeng', 'shunfengkuaiyun']) && empty($phone)) {
            respose(['code'=>0,'msg'=>"请填写手机号码"]);
        }

        //请求参数
        $post_data = array();
        $post_data['customer'] = $customer;
        $post_data['param'] = json_encode($param, JSON_UNESCAPED_UNICODE);
        $sign = md5($post_data['param'].$apikey.$post_data['customer']);
        $post_data['sign'] = strtoupper($sign);
        
        $url = 'https://poll.kuaidi100.com/poll/query.do';    // 实时查询请求地址
        
        // 发送post请求
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        // 第二个参数为true，表示格式化输出json
        $data = json_decode($result, true);
        $message = empty($data['message']) ? '查询失败' : $data['message'];
        if ('ok' == $message) {
            respose(['code'=>1,'msg'=>$message,'data'=>$data['data']]);
        }
        respose(['code'=>0,'msg'=>$message]);
    }
}