<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\plugins\controller;

use think\Db;
use app\plugins\logic\PointsShopLogic;

class PointsShop extends Base
{
    public $weappCode = 'points_shop/';

    // 构造方法
    public function __construct()
    {
        parent::__construct();
        // 获取用户信息
        $users = GetUsersLatestData();
        if (empty($users)) {
            if (IS_AJAX) {
                $this->error('请先登录！', null, ['url'=>url('user/Users/login')]);
            } else {
                if (isWeixin()) {
                    //微信端
                    $this->redirect(url('user/Users/users_select_login', ['is_ajax'=>0]));
                } else {
                    // 其他端
                    $this->redirect('user/Users/login');
                }
            }
        }
        // 分销逻辑层
        $this->pointsShopLogic = new PointsShopLogic($users);
        // 插件信息
        $this->weappInfo = model('ShopPublicHandle')->getWeappPointsShop();
        // 会员中心配置
        $this->assign('usersConfig', getUsersConfigData('all'));
        // 系统版本
        $this->assign('php_servicemeal', tpCache('php.php_servicemeal'));
    }

    public function errorMsg($result = [])
    {
        $this->error('请求错误，正在前往会员中心', url('user/Users/index'));
    }

    // 获取积分商城首页数据
    public function index($result = [])
    {
        // 获取积分商城首页数据
        $result = !empty($result) ? $result : $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'index');
        if (!empty($result)) {
            // 系统商城订单配置
            $result['systemOrderConfig'] = getUsersConfigData('order');
            // 获取系统积分规则
            $result['systemPointsRules'] = getUsersConfigData('score');
        }

        // dump($result);exit;
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/index');
    }

    // 获取系统积分规则
    public function points_rules($result = [])
    {
        // 获取系统积分规则
        // $result = !empty($result) ? $result : $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'pointsRules');
        // dump($result);exit;
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/points_rules');
    }

    // 获取会员积分明细
    public function points_details($result = [])
    {
        // 获取会员积分明细
        // $result = !empty($result) ? $result : $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'pointsDetails');
        // dump($result);exit;
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/points_details');
    }

    // 获取积分商品明细
    public function goods_details($result = [])
    {
        // 获取积分商品明细
        $result = !empty($result) ? $result : $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'goodsDetails');
        if (!empty($result)) {
            if (0 < intval($result['defaultGoodsSpec'])) {
                $result['defaultGoodsSpec']['aid'] = input('param.aid/d', 0);
                $result['defaultGoodsSpec']['goods_id'] = input('param.goods_id/d', 0);
                $result['defaultGoodsSpec']['spec_keys'] = !empty($result['defaultGoodsSpec']['spec_keys']) ? implode('_', $result['defaultGoodsSpec']['spec_keys']) : '';
                $defaultGoodsSpec = $result['defaultGoodsSpec'];
                $result['pointsGoods']['spec_id'] = !empty($defaultGoodsSpec['spec_id']) ? intval($defaultGoodsSpec['spec_id']) : 0;
                $result['pointsGoods']['spec_keys'] = !empty($defaultGoodsSpec['spec_keys']) ? $defaultGoodsSpec['spec_keys'] : '';
                $result['pointsGoods']['goods_stock'] = !empty($defaultGoodsSpec['goods_stock']) ? intval($defaultGoodsSpec['goods_stock']) : 0;
                $result['pointsGoods']['goods_points'] = !empty($defaultGoodsSpec['goods_points']) ? intval($defaultGoodsSpec['goods_points']) : 0;
                $result['pointsGoods']['goods_price'] = !empty($defaultGoodsSpec['goods_price']) ? unifyPriceHandle($defaultGoodsSpec['goods_price']) : 0;
            }
            $hidden = json_encode([
                'defaultGoodsSpec' => !empty($result['defaultGoodsSpec']) ? $result['defaultGoodsSpec'] : [],
                'allGoodsSpecValue' => !empty($result['allGoodsSpecValue']) ? $result['allGoodsSpecValue'] : [],
            ]);
            $goodsBuyPreHandle = dynamic_url('plugins/PointsShop/goodsBuyPreHandle');
            $result['hidden'] = <<<EOF
<script type="text/javascript">
    var pointsGoodsSpec = {$hidden};
    var goodsBuyPreHandle = "{$goodsBuyPreHandle}";
</script>
EOF;
        }

        // dump($result);exit;
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/goods_details');
    }

    public function goodsBuyPreHandle()
    {
        if (IS_AJAX_POST) {
            $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'goodsBuyPreHandle');
        }
    }

    // 获取积分商品购买页面
    public function goods_buy_page($result = [])
    {
        // 获取积分商品购买页面
        $result = !empty($result) ? $result : $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'goodsBuyPage');
        if (!empty($result)) {
            $result['cacheKeys'] = input('param.cacheKeys/s', '');
            $result['logistics'] = [
                // 核销订单自提点ID
                'store_id' => 0,
                // 默认快递配送
                'logistics_type' => 2,
                // 到店自提地址 div框
                'selectVerifyID' => " id='selectVerifyID' ",
                'selectVerifyInfo' => " id='selectVerifyInfo' ",
                // 快递配送地址 div框
                'selectDeliveryID' => " id='selectDeliveryID' ",
                'selectDeliveryAddress' => " id='selectDeliveryAddress' ",
                // 切换配送方式 - 点击到店自提
                'selectVerify' => " id='selectVerify' onclick='selectLogisticsType(2);' ",
                // 切换配送方式 - 点击快递配送
                'selectDelivery' => " id='selectDelivery' onclick='selectLogisticsType(1);' ",
            ];
            if (empty($result['pointsGoods']['onlyVerify'])) {
                // 订单物流类型(1:快递发货; 2:到店核销;)
                $result['logistics']['logistics_type'] = 1;
                $result['logistics']['selectVerifyID'] .= " style='display: none;' ";
                $result['logistics']['selectVerifyInfo'] .= " style='display: none;' ";
            } else {
                $result['logistics']['selectDeliveryID'] .= " style='display: none;' ";
                $result['logistics']['selectDeliveryAddress'] .= " style='display: none;' ";
            }
            // 支付隐藏域
            $data = [
                'pay_balance_open' => !empty($result['payBalanceOpen']) ? 1 : 0,
                'shop_open_offline' => !empty($result['systemShopConfig']['shop_open_offline']) ? 1 : 0,
                'PromType' => !empty($result['pointsGoods']['prom_type']) ? intval($result['pointsGoods']['prom_type']) : 0,
            ];
            $result['payApiHidden'] = model('ShopPublicHandle')->getPayApiHidden($data);
            // URL数组
            $urlArr = json_encode([
                'shopCentre' => url('user/Shop/shop_centre'),
                'selectVerifyStore' => url('user/Shop/select_verify_store'),
                'shopDelAddress' => dynamic_url('user/Shop/shop_del_address', ['_ajax' => 1]),
                'goodsBuySubmit' => dynamic_url('plugins/PointsShop/goodsBuySubmit', ['_ajax' => 1]),
                'shopInquiryShipping' => dynamic_url('user/Shop/shop_inquiry_shipping', ['_ajax' => 1]),
                'shopAddAddress' => dynamic_url('user/Shop/shop_add_address', ['type'=>'order', 'pointsShop'=>1]),
                'shopEditAddress' => dynamic_url('user/Shop/shop_edit_address', ['type'=>'order', 'pointsShop'=>1]),
            ]);
            // 订单ID和code
            $result['order_id'] = 0;
            $result['order_code'] = '';
            // 全部数据
            $resultArr = json_encode($result);
            $result['hidden'] = <<<EOF
<script type="text/javascript">
    var urlArr = {$urlArr};
    var resultArr = {$resultArr};
</script>
EOF;
        }
        // dump($result);exit;

        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/goods_buy_page');
    }

    public function goodsBuySubmit()
    {
        if (IS_AJAX_POST) {
            $this->pointsShopLogic->pointsShopAction($this->weappInfo, 'h5', 'goodsBuySubmit');
        }
    }
}