<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 陈风任 <491085389@qq.com>
 * Date: 2020-05-22
 */

namespace app\plugins\controller;

use think\Db;
use think\Config;

class Hupijiaopay extends Base
{
    /**
     * 构造方法
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function notify()
    {
        // 获取回调参数
        $postData = input('post.');
        // $postData = [
        //     'trade_order_id' => '20240604171748886535',
        //     'total_fee' => '0.01',
        //     'transaction_id' => '4200002180202406041639266809',
        //     'open_order_id' => '20259147297',
        //     'order_title' => '订单支付',
        //     'status' => 'OD',
        //     'plugins' => 'peixun-5fa-cn',
        //     'attach' => '2|,|2|,|wechat|,|hupijiaoPay',
        //     'nonce_str' => '0917147860',
        //     'time' => '1717489006',
        //     'appid' => '201906153196',
        //     'hash' => '5dec2f88bfd14b44d02bb6dcac734f33',
        // ];
        file_put_contents ( DATA_PATH."notify.php", date ( "Y-m-d H:i:s" ) . "  3:" . var_export($postData, true) . "\r\n", FILE_APPEND );
        $postData = json_decode(json_encode($postData), true);
        $postData['attach'] = !empty($postData['attach']) ? explode('|,|', $postData['attach']) : [];
        if (empty($postData['attach'][0]) || empty($postData['attach'][1]) || empty($postData['attach'][2]) || empty($postData['attach'][3])) exit('failed');

        // 查询支付配置
        $payApiConfig = Db::name('pay_api_config')->where(['pay_mark'=>'Hupijiaopay'])->find();
        if (empty($payApiConfig)) exit('failed');

        // 查询订单并处理
        if (1 === intval($postData['attach'][0])) {
            $where = [
                'users_id' => intval($postData['attach'][1]),
                'order_number' => $postData['trade_order_id']
            ];
            $orderData = Db::name('users_money')->where($where)->find();
        }
        else if (2 === intval($postData['attach'][0])) {
            $where = [
                'users_id' => intval($postData['attach'][1]),
                'order_code' => $postData['trade_order_id']
            ];
            $orderData = Db::name('shop_order')->where($where)->find();
        }

        // 调用接口查询订单是否已完成支付
        session('users_id', intval($orderData['users_id']));
        $orderData['pay_mark'] = 'Hupijiaopay';
        $orderData['pay_type'] = trim($postData['attach'][2]);
        $orderData['unified_id'] = !empty($orderData['moneyid']) ? intval($orderData['moneyid']) : 0;
        $orderData['unified_id'] = empty($orderData['unified_id']) && !empty($orderData['order_id']) ? intval($orderData['order_id']) : 0;
        $orderData['unified_number'] = !empty($postData['trade_order_id']) ? trim($postData['trade_order_id']) : '';
        $orderData['transaction_type'] = intval($postData['attach'][0]);
        file_put_contents ( DATA_PATH."notify.php", date ( "Y-m-d H:i:s" ) . "  4:" . var_export($orderData, true) . "\r\n", FILE_APPEND );
        $controller  = new \app\user\controller\PayApi;
        $controller->order_pay_polling($orderData, true);
        session('users_id', 0);
    }

    // 拼装更新会员数据数组
    private function GetUpUsersData($data = [], $users = [])
    {
        $time = getTime();
        // 会员期限定义数组
        $limit_arr = Config::get('global.admin_member_limit_arr');
        // 到期天数
        $maturity_days = $limit_arr[$data['limit_id']]['maturity_days'];
        // 更新会员属性表的数组
        $result = [
            'level' => $data['level_id'],
            'update_time' => $time,
            'level_maturity_days' => Db::raw('level_maturity_days+'.($maturity_days)),
        ];
        
        // 判断是否需要追加天数，maturity_code在Base层已计算，1表示终身会员天数
        if (1 != $users['maturity_code']) {
            // 判断是否到期，到期则执行，3表示会员在期限内，不需要进行下一步操作
            if (3 != $users['maturity_code']) {
                // 追加天数数组
                $result['open_level_time'] = $time;
                $result['level_maturity_days'] = $maturity_days;
            }
        }

        return $result;
    }
}