<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace app\plugins\controller;

use think\Db;
use app\plugins\logic\DealerPluginLogic;

/**
 * 分销插件控制器
 */

class DealerPlugin extends Base
{
    public $weappCode = 'dealer_plugin/';

    // 构造方法
    public function __construct()
    {
        parent::__construct();
        // 获取用户信息
        $users = GetUsersLatestData();
        // 分销逻辑层
        $this->dealerPluginLogic = new DealerPluginLogic($users);
    }

    public function errorMsg($result = [])
    {
        $this->error('请求错误，正在前往会员中心', url('user/Users/index'));
    }

    // 分销商申请
    public function dealer_apply($result = [])
    {
        if (IS_AJAX_POST) {
            $this->dealerPluginLogic->dealerAction('h5', 'addApply');
        }
        // 查询分销商申请信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getApply');
        // 如果已成为分销商则执行重定向
        if (!empty($result['code']) && 'success' == $result['code']) $this->redirect('plugins/DealerPlugin/dealer_index');
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_apply');
    }

    // 分销商首页
    public function dealer_index($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getDealer');
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_index');
    }

    // 分销商佣金
    public function dealer_money($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getMoneyList');
        // 加载页面数据
        $this->assign($result);
        // 加载分页的文件
        $requestUrl = dynamic_url('plugins/DealerPlugin/dealer_money_list');
        $this->assign('requestUrl', $requestUrl);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_money');
    }

    // 分销商提现列表
    public function dealer_money_list($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getMoneyList');
        // 加载页面数据
        $this->assign($result);
        $dealerMoneyList = $this->fetch($this->weappCode.THEME_STYLE.'/dealer_money_list');
        $this->success('加载成功', null, ['unifiedLoadList' => $dealerMoneyList]);
    }

    public function dealer_order($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getOrderList');
        // 加载页面数据
        $this->assign($result);
        // 加载分页的文件
        $handleRebate = input('param.handleRebate/d', 0);
        $this->assign('handleRebate', $handleRebate);
        $requestUrl = dynamic_url('plugins/DealerPlugin/dealer_order_list', ['handleRebate'=>$handleRebate]);
        $this->assign('requestUrl', $requestUrl);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_order');
    }

    // 分销商订单列表
    public function dealer_order_list($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getOrderList');
        // 加载页面数据
        $this->assign($result);
        $dealerOrderList = $this->fetch($this->weappCode.THEME_STYLE.'/dealer_order_list');
        $this->success('加载成功', null, ['unifiedLoadList' => $dealerOrderList]);
    }

    // 分销商海报
    public function dealer_qrcode()
    {
        // 查询分销商信息
        $posterQrcode = $this->dealerPluginLogic->dealerAction('h5', 'getPoster');
        // 加载页面数据
        $this->assign('posterQrcode', $posterQrcode);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_qrcode');
    }

    // 分销商直接客户
    public function dealer_subcustomer($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getCustomerList');
        // 加载页面数据
        $this->assign($result);
        // 加载分页的文件
        $requestUrl = dynamic_url('plugins/DealerPlugin/dealer_subcustomer_list');
        $this->assign('requestUrl', $requestUrl);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_subcustomer');
    }

    // 分销商直接客户列表
    public function dealer_subcustomer_list($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getCustomerList');
        // 加载页面数据
        $this->assign($result);
        $dealerCustomerList = $this->fetch($this->weappCode.THEME_STYLE.'/dealer_subcustomer_list');
        $this->success('加载成功', null, ['unifiedLoadList' => $dealerCustomerList]);
    }

    // 分销商下级分销商
    public function dealer_subordinate($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getSubordinateList');
        // 加载页面数据
        $this->assign($result);
        // 加载分页的文件
        $requestUrl = dynamic_url('plugins/DealerPlugin/dealer_subordinate_list');
        $this->assign('requestUrl', $requestUrl);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_subordinate');
    }

    // 分销商下级列表
    public function dealer_subordinate_list($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getSubordinateList');
        // 加载页面数据
        $this->assign($result);
        $dealerSubordinateList = $this->fetch($this->weappCode.THEME_STYLE.'/dealer_subordinate_list');
        $this->success('加载成功', null, ['unifiedLoadList' => $dealerSubordinateList]);
    }

    // 分销商提现申请
    public function dealer_withdraw_apply($result = [])
    {
        if (IS_AJAX_POST) {
            $this->dealerPluginLogic->dealerAction('h5', 'addWithdrawApply');
        }
        // 查询分销商提现信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getWithdrawApply');
        // dump($result);exit;
        // 加载页面数据
        $this->assign($result);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_withdraw_apply');
    }

    // 分销商提现首页
    public function dealer_withdraw_index($result = [])
    {
        // 查询分销商提现信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getWithdrawList');
        // 加载页面数据
        $this->assign($result);
        // 加载分页的文件
        $reviewStatus = input('param.reviewStatus/d', 0);
        $this->assign('reviewStatus', $reviewStatus);
        $requestUrl = dynamic_url('plugins/DealerPlugin/dealer_withdraw_list', ['reviewStatus'=>$reviewStatus]);
        $this->assign('requestUrl', $requestUrl);
        return $this->fetch($this->weappCode.THEME_STYLE.'/dealer_withdraw_index');
    }

    // 分销商提现列表
    public function dealer_withdraw_list($result = [])
    {
        // 查询分销商信息
        $result = !empty($result) ? $result : $this->dealerPluginLogic->dealerAction('h5', 'getWithdrawList');
        // 加载页面数据
        $this->assign($result);
        $dealerWithdrawList = $this->fetch($this->weappCode.THEME_STYLE.'/dealer_withdraw_list');
        $this->success('加载成功', null, ['unifiedLoadList' => $dealerWithdrawList]);
    }

    // 删除分销商
    public function delDealerApply()
    {
        if (IS_AJAX_POST) {
            $apply_id = input('param.apply_id/d', 0);
            $where = [
                'apply_id' => intval($apply_id),
                'users_id' => intval($this->users_id),
            ];
            Db::name('weapp_dealer_apply')->where($where)->delete(true);
            $this->success('删除成功');
        }
    }
}