<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

$config = [];
if (file_exists(__DIR__ . "/../../../application/database.php")) {
    $config = require(__DIR__ . "/../../../application/database.php");
}

return array(
    // 数据库类型
    'type'            => empty($config['type']) ? 'mysql' : $config['type'],
    // 服务器地址
    'hostname'        => empty($config['hostname']) ? '127.0.0.1' : $config['hostname'],
    // 数据库名
    'database'        => empty($config['database']) ? 'root' : $config['database'],
    // 用户名
    'username'        => empty($config['username']) ? 'root' : $config['username'],
    // 密码
    'password'        => empty($config['password']) ? '123123123' : $config['password'],
    // 端口
    'hostport'        => empty($config['hostport']) ? '3306' : $config['hostport'],
    // 连接dsn
    'dsn'             => empty($config['dsn']) ? '' : $config['dsn'],
    // 数据库连接参数
    'params'          => empty($config['params']) ? [] : $config['params'],
    // 数据库编码默认采用utf8
    'charset'         => empty($config['charset']) ? 'utf8' : $config['charset'],
    // 数据库表前缀
    'prefix'          => empty($config['prefix']) ? 'ey_' : $config['prefix'] . 'weapp_sp_',
    // 数据库调试模式
    'debug'           => empty($config['debug']) ? false : $config['debug'],
    // 数据库部署方式:0 集中式(单一服务器),1 分布式(主从服务器)
    'deploy'          => empty($config['deploy']) ? 0 : $config['deploy'],
    // 数据库读写是否分离 主从式有效
    'rw_separate'     => empty($config['rw_separate']) ? false : $config['rw_separate'],
    // 读写分离后 主服务器数量
    'master_num'      => empty($config['master_num']) ? 1 : $config['master_num'],
    // 指定从服务器序号
    'slave_no'        => empty($config['slave_no']) ? '' : $config['slave_no'],
    // 是否严格检查字段是否存在
    'fields_strict'   => empty($config['fields_strict']) ? true : $config['fields_strict'],
    // 数据集返回类型
    'resultset_type'  => empty($config['resultset_type']) ? 'array' : $config['resultset_type'],
    // 自动写入时间戳字段
    'auto_timestamp'  => empty($config['auto_timestamp']) ? false : $config['auto_timestamp'],
    // 时间字段取出后的默认时间格式
    'datetime_format' => empty($config['datetime_format']) ? 'Y-m-d H:i:s' : $config['datetime_format'],
    // 是否需要进行SQL性能分析
    'sql_explain'     => empty($config['sql_explain']) ? false : $config['sql_explain'],
    // Builder类
    'builder'         => empty($config['builder']) ? '' : $config['builder'],
    // Query类
    'query'           => empty($config['query']) ? '\\think\\db\\Query' : $config['query'],
    // 是否需要断线重连
    'break_reconnect' => empty($config['break_reconnect']) ? true : $config['break_reconnect'],
);
