<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 陈风任 <491085389@qq.com>
 * Date: 2019-1-7
 */

namespace app\common\model;

use think\Db;
use think\Cache;
use think\Config;
use think\Cookie;

/**
 * 商城会员处理模型
 */
load_trait('controller/Jump');
class ShopUsersHandle
{
    use \traits\controller\Jump;

    private $sendTerminal = '';

    // 构造函数
    public function __construct()
    {
        // 统一接收参数处理
        $this->times = getTime();
        $this->post = input('post.');
        $this->usersData = [];
        $this->globalConfig = [];
        $this->sendTerminal = input('param.sendTerminal/s', 'openSource');
        $this->sendTerminal = !empty($this->sendTerminal) ? trim($this->sendTerminal) : '';
    }

    // 订单提交时基础验证
    public function getUsersAddress($post = [], $usersData = [], $globalConfig = [], $orderUseCoupon = [])
    {
        $this->post = !empty($post) ? $post : $this->post;
        $this->usersData = !empty($usersData) ? $usersData : $this->usersData;
        $this->globalConfig = !empty($globalConfig) ? $globalConfig : $this->globalConfig;

        // 查询会员地址
        $where = [
            'users_id' => intval($this->usersData['users_id'])
        ];
        $select_addr_id = input('param.addr_id/d', 0);
        if (!empty($select_addr_id)) $where['addr_id'] = intval($select_addr_id);
        $address = Db::name('shop_address')->where($where)->order('is_default desc')->find();
        if (!empty($address)) {
            $address['template_money'] = 0;
            $address['region']['province'] = get_region_name($address['province']);
            $address['region']['city'] = get_region_name($address['city']);
            $address['region']['district'] = get_region_name($address['district']);
            $address['region']['detail'] = $address['address'];
            $address['address_all'] = $address['region']['province'] . $address['region']['city'] . $address['region']['district'] . $address['region']['detail'];
            if (!empty($this->globalConfig['shop_open_shipping'])) {
                $where = [
                    'province_id' => intval($address['province'])
                ];
                $template_money = Db::name('shop_shipping_template')->where($where)->getField('template_money');
                if (empty($template_money)) {
                    $where = [
                        'province_id' => 100000,
                    ];
                    $template_money = Db::name('shop_shipping_template')->where($where)->getField('template_money');
                }
                $address['template_money'] = unifyPriceHandle($template_money);
            }
        } else {
            $address['template_money'] = 0;
        }

        // 如果是核销订单则运费置0
        if (!empty($this->globalConfig['onlyVerify'])) $address['template_money'] = 0;

        // 最终支付总金额
        if (!empty($this->post['deliveryShow']) && 1 === intval($this->post['deliveryShow'])) {
            // 订单总金额 + 运费金额
            $this->globalConfig['PayTotalAmount'] = unifyPriceHandle($this->globalConfig['TotalAmount'] + $address['template_money']);
        } else {
            $this->globalConfig['PayTotalAmount'] = unifyPriceHandle($this->globalConfig['TotalAmount']);
        }

        // 使用优惠券则扣除相应金额
        if (isset($this->globalConfig['PayTotalAmount']) && isset($orderUseCoupon['coupon_price'])) {
            $payTotalAmount = floatval($this->globalConfig['PayTotalAmount']) - floatval($orderUseCoupon['coupon_price']);
            $this->globalConfig['PayTotalAmount'] = floatval($payTotalAmount) < 0 ? 0 : unifyPriceHandle($payTotalAmount);
        }

        // 字段兼容
        $address['shipping_fee'] = !empty($address['template_money']) ? $address['template_money'] : 0;

        // 返回数据
        return [$address, $this->globalConfig];
    }

}