<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */
namespace app\common\model;

use think\Db;

/**
 * 商城商品服务标签模型
 */
load_trait('controller/Jump');
class ShopGoodsLabel
{
    use \traits\controller\Jump;

    // 构造函数
    public function __construct()
    {
        // 时间戳
        $this->times = getTime();
        // 商品服务标签列表
        $this->shopGoodsLabelDb = Db::name('shop_goods_label');
        // 商城商品服务标签与商品ID关联绑定表
        $this->shopGoodsLabelBindDb = Db::name('shop_goods_label_bind');
    }

    // 新增商品服务标签
    public function insertGoodsLabel()
    {
        $insert = [
            'label_title' => '',
            'label_pic'   => '',
            'label_intro' => '',
            'status'      => 0,
            'selected'    => 0,
            'add_time'    => $this->times,
            'update_time' => $this->times,
        ];
        $insertID = $this->shopGoodsLabelDb->insertGetId($insert);
        if (!empty($insertID)) {
            return true;
        } else {
            return false;
        }
    }

    // 删除商品服务标签
    public function deleteGoodsLabel()
    {
        $label_id = input('post.label_id/d', 0);
        if (empty($label_id)) $this->error('请选择删除标签');
        $where = [
            'label_id' => intval($label_id),
        ];
        $deleteID = $this->shopGoodsLabelDb->where($where)->delete(true);
        if (!empty($deleteID)) {
            // 同步删除商品标签关联表的指定标签
            $this->shopGoodsLabelBindDb->where($where)->delete(true);
            return true;
        } else {
            return false;
        }
    }

    // 删除空的商品服务标签
    public function deleteEmptyGoodsLabel()
    {
        return $this->shopGoodsLabelDb->where(['label_title' => ['EQ', '']])->delete(true);
    }

    // 获取商品服务标签列表
    public function getGoodsLabelList($aid = 0, $isPort = false, $labelID = 0, $status = 0)
    {
        // 查询商品服务标签与商品关联绑定数据
        $goodsLabelBind = [];
        if (!empty($aid)) {
            $where = [
                'aid' => intval($aid)
            ];
            if (!empty($labelID)) $where['label_id'] = intval($labelID);
            $goodsLabelBind = $this->shopGoodsLabelBindDb->where($where)->select();
            $goodsLabelBind = !empty($goodsLabelBind) ? convert_arr_key($goodsLabelBind, 'label_id') : [];
        }

        // 查询商品标签列表
        $where = [];
        if (!empty($status)) $where['status'] = intval($status);
        if (!empty($labelID)) $where['label_id'] = intval($labelID);
        $goodsLabel = $this->shopGoodsLabelDb->where($where)->select();
        foreach ($goodsLabel as $key => $value) {
            // 图片处理
            // if (!empty($isPort)) {
            //     $value['label_pic'] = handle_subdir_pic($value['label_pic'], 'img', true);
            // } else {
            //     $value['label_pic'] = handle_subdir_pic($value['label_pic']);
            // }

            // 是否选中
            $value['checked'] = '';
            if (!empty($goodsLabelBind[$value['label_id']])) $value['checked'] = 'checked';

            // 覆盖原数据
            $goodsLabel[$key] = $value;

            // 如果是接口访问则去掉未选中的服务标签
            if (!empty($isPort) && empty($value['checked'])) unset($goodsLabel[$key]);
        }
        return $goodsLabel;
    }

    // 保存商品服务标签与商品关联绑定数据
    public function saveGoodsLabelBind($aid = 0, $goodsLabelID = [])
    {
        // 删除指定商品服务标签与商品关联绑定数据
        if (!empty($aid)) $this->shopGoodsLabelBindDb->where(['aid' => intval($aid)])->delete(true);

        // 保存指定商品服务标签与商品关联绑定数据
        if (!empty($goodsLabelID)) {
            $insertAll = [];
            foreach ($goodsLabelID as $key => $value) {
                $insertAll[] = [
                    'aid' => intval($aid),
                    'label_id' => intval($value),
                    'add_time' => $this->times,
                    'update_time' => $this->times,
                ];
            }
            if (!empty($insertAll)) $this->shopGoodsLabelBindDb->insertAll($insertAll);
        }
    }

}