<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */
namespace app\common\model;

use think\Db;

/**
 * 热搜关键字模型
 */
load_trait('controller/Jump');
class SearchHot
{
    use \traits\controller\Jump;

    // 构造函数
    public function __construct()
    {
        // 时间戳
        $this->times = getTime();
        // 热搜关键字列表
        $this->searchhotDb = Db::name('search_hot');
    }

    // 新增热搜关键字
    public function insertKeywords()
    {
        $insert = [
            'word' => '',
            'sort_order'      => 100,
            'add_time'    => $this->times,
            'update_time' => $this->times,
        ];
        $insertID = $this->searchhotDb->insertGetId($insert);
        if ($insertID !== false) {
            return true;
        } else {
            return false;
        }
    }

    // 删除热搜关键字
    public function deleteKeywords()
    {
        $word_id = input('post.word_id/d', 0);
        if (empty($word_id)) $this->error('请选择删除关键字');
        $where = [
            'id' => intval($word_id),
        ];
        $deleteID = $this->searchhotDb->where($where)->delete(true);
        if ($deleteID !== false) {
            return true;
        } else {
            return false;
        }
    }

    // 删除空的热搜关键字
    public function deleteEmptyKeywords()
    {
        return $this->searchhotDb->where(['word' => ['EQ', '']])->delete(true);
    }

    // 获取热搜关键字列表
    public function getKeywordsList($aid = 0, $isPort = false, $wordId = 0)
    {
        // 查询热搜关键字列表
        $where = [];
        if (!empty($wordId)) $where['id'] = intval($wordId);
        $list = $this->searchhotDb->where($where)->select();
        return $list;
    }
}