<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 易而优团队 by 陈风任 <491085389@qq.com>
 * Date: 2021-01-14
 */

namespace app\admin\model;

use think\Db;
use think\Page;

/**
 * 商城模型
 */
load_trait('controller/Jump');
class ShopGoods
{
    use \traits\controller\Jump;

    // 构造函数
    public function __construct($channeltype = 2)
    {
        // 时间戳
        $this->times = getTime();
        // 执行方法
        $this->action = 'insert';
        // 接收参数
        $this->paramArr = input('param.');
        // 模型ID，默认2(商城模型)
        $this->channeltype = intval($channeltype);
        // 数据表
        $this->archives_db = Db::name('archives');
    }

    // 执行商品状态更新
    public function goodsArcrank()
    {
        if (empty($this->paramArr['aids'])) $this->error('请选择商品');
        $where = [
            'aid' => ['IN', eyIntval($this->paramArr['aids'])],
        ];
        $update = [
            'arcrank' => intval($this->paramArr['arcrank']),
            'update_time' => $this->times
        ];
        $resultID = $this->archives_db->where($where)->update($update);
        // 返回结果
        if (!empty($resultID)) {
            return true;
        } else {
            return false;
        }
    }

    // 执行商品复制
    public function goodsCopy()
    {
        if (empty($this->paramArr['aids'])) $this->error('请选择商品');
        $where = [
            'aid' => ['IN', eyIntval($this->paramArr['aids'])],
        ];
        $archives = $this->archives_db->where($where)->find();
        if (empty($archives['aid'])) $this->error('未查询到相关商品');
        $insertID = 0;
        if (!empty($archives)) {
            // 复制商品主表
            unset($archives['aid']);
            $archives['title'] = '副本-'.$archives['title'];
            $archives['sales_num'] = 0;
            $archives['virtual_sales'] = 0;
            $archives['add_time'] = $this->times;
            $archives['update_time'] = $this->times;
            $insertID = $this->archives_db->insertGetId($archives);
            if (!empty($insertID)) {
                // 复制商品内容
                $productContent = Db::name('product_content')->where($where)->find();
                if (!empty($productContent)) {
                    unset($productContent['id']);
                    $productContent['aid'] = $insertID;
                    Db::name('product_content')->insert($productContent);
                }

                // 复制商品参数
                // $whereOr = [
                //     'is_custom' => 1,
                //     'aid' => ['IN', eyIntval($this->paramArr['aids'])],
                // ];
                $shopProductAttr = Db::name('shop_product_attr')->where($where)->order('product_attr_id asc')->select();
                // $shopProductAttr = Db::name('shop_product_attr')->where($where)->whereOr($whereOr)->order('product_attr_id asc')->select();
                if (!empty($shopProductAttr)) {
                    foreach ($shopProductAttr as $key => $value) {
                        unset($shopProductAttr[$key]['product_attr_id']);
                        $shopProductAttr[$key]['aid'] = $insertID;
                    }
                    Db::name('shop_product_attr')->insertAll($shopProductAttr);
                }

                // 复制商品规格
                $productSpecData = Db::name('product_spec_data')->where($where)->order('spec_mark_id asc, spec_value_id asc')->select();
                if (!empty($productSpecData)) {
                    foreach ($productSpecData as $key => $value) {
                        unset($productSpecData[$key]['spec_id']);
                        $productSpecData[$key]['aid'] = $insertID;
                    }
                    Db::name('product_spec_data')->insertAll($productSpecData);
                }
                $productSpecValue = Db::name('product_spec_value')->where($where)->order('value_id asc')->select();
                if (!empty($productSpecValue)) {
                    foreach ($productSpecValue as $key => $value) {
                        unset($productSpecValue[$key]['value_id']);
                        $productSpecValue[$key]['aid'] = $insertID;
                    }
                    Db::name('product_spec_value')->insertAll($productSpecValue);
                }

                // 复制商品图集
                $productImg = Db::name('product_img')->where($where)->order('img_id asc')->select();
                if (!empty($productImg)) {
                    foreach ($productImg as $key => $value) {
                        unset($productImg[$key]['img_id']);
                        $productImg[$key]['aid'] = $insertID;
                    }
                    Db::name('product_img')->insertAll($productImg);
                }

                // 复制商品营销标签
                $goodsLabel = Db::name('shop_goods_label_bind')->where($where)->order('bind_id asc')->select();
                if (!empty($goodsLabel)) {
                    foreach ($goodsLabel as $key => $value) {
                        unset($goodsLabel[$key]['bind_id']);
                        $goodsLabel[$key]['aid'] = $insertID;
                    }
                    Db::name('shop_goods_label_bind')->insertAll($goodsLabel);
                }
            }
        }

        // 返回结果
        if (!empty($insertID)) {
            $td_count = $this->archives_db->where($where)->whereTime('add_time', 'today')->count();
            $ystd_count = $this->archives_db->where($where)->whereTime('add_time', 'yesterday')->count();
            $this->del_statistics($td_count, $ystd_count, 'inc');

            return true;
        } else {
            return false;
        }
    }

    // 执行商品删除
    public function goodsDelete()
    {
        if (empty($this->paramArr['aids'])) $this->error('请选择商品');
        $where = [
            'aid' => ['IN', eyIntval($this->paramArr['aids'])],
        ];
        // query=4 则执行彻底删除
        if (!empty($this->paramArr['query']) && 4 === intval($this->paramArr['query'])) {
            $resultID = $this->archives_db->where($where)->delete(true);
            if (!empty($resultID)) {
                // 同时删除相关的数据表
                model('Product')->afterDel($this->paramArr['aids']);

                // 同时处理积分商品下架
                model('ShopPublicHandle')->pointsGoodsPassiveHandle($this->paramArr['aids']);

                // 查一下删除的商品里有没有昨天和今天发布的，要在统计里减去
                $td_count = $this->archives_db->where($where)->whereTime('add_time','today')->count();
                $ystd_count = $this->archives_db->where($where)->whereTime('add_time','yesterday')->count();
                $this->del_statistics($td_count, $ystd_count, 'dec');
                return true;
            } else {
                return false;
            }
        }
        // 其他则执行伪删除
        else {
            $update = [
                'is_del' => 1,
                'del_method' => 1,
                'update_time' => $this->times
            ];
            $resultID = $this->archives_db->where($where)->update($update);
            // 返回结果
            if (!empty($resultID)) {
                // 同时处理积分商品下架
                model('ShopPublicHandle')->pointsGoodsPassiveHandle($this->paramArr['aids']);

                // 查一下删除的商品里有没有昨天和今天发布的，要在统计里减去
                // $td_count = $this->archives_db->where($where)->whereTime('add_time','today')->count();
                // $ystd_count = $this->archives_db->where($where)->whereTime('add_time','yesterday')->count();
                // $this->del_statistics($td_count, $ystd_count, 'dec');

                return true;
            } else {
                return false;
            }
        }
    }

    // 执行商品恢复
    public function goodsRestore($aid = [])
    {
        if (empty($this->paramArr['aids'])) $this->error('请选择商品');
        // 商品编辑数据
        $where = [
            'aid' => ['IN', eyIntval($this->paramArr['aids'])],
        ];
        $update = [
            'is_del' => 0,
            'del_method' => 0,
            'update_time' => $this->times
        ];
        $resultID = $this->archives_db->where($where)->update($update);
        // 返回结果
        if (!empty($resultID)) {
            // $td_count = $this->archives_db->where($where)->whereTime('add_time','today')->count();
            // $ystd_count = $this->archives_db->where($where)->whereTime('add_time','yesterday')->count();
            // $this->del_statistics($td_count, $ystd_count, 'inc');

            return true;
        } else {
            return false;
        }
    }

    /**
     * @param string $action inc 增加 dec 减少
     */
    private function del_statistics($td_count = 0, $ystd_count = 0, $action = 'inc')
    {
        //写入统计 减去
        if ($td_count > 0){
            eyou_statistics_data(6, $td_count, '', $action);//今天的
        }
        if ($ystd_count > 0){
            $ystd = strtotime('-1 day');
            eyou_statistics_data(6, $ystd_count, $ystd, $action);//昨天的
        }
    }

}