<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\logic;

use think\Model;
use think\Db;

/**
 * 安全中心的逻辑
 * Class CatsLogic
 * @package admin\Logic
 */
load_trait('controller/Jump');
class SecurityLogic extends Model
{
    use \traits\controller\Jump;
    protected static $actionName;
    protected static $controllerName;
    protected static $method;

    /**
     * 析构函数
     */
    function  __construct() {
        self::$actionName = request()->action();
        self::$controllerName = request()->controller();
        self::$method = request()->method();
    }

    /**
     * 控制器方法操作的前置密保验证
     * @return [type] [description]
     */
    public function security_verify_actionbegin()
    {
        $ctl_act = self::$controllerName.'@'.self::$actionName;
        if (in_array(self::$controllerName, ['Filemanager', 'Weapp']) || in_array($ctl_act, ['Arctype@ajax_newtpl','Archives@ajax_newtpl'])) {
            $security = tpSetting('security');

            /*---------强制必须开启密保问题认证 start----------*/
            if (in_array(self::$controllerName, ['Filemanager']) || in_array($ctl_act, ['Arctype@ajax_newtpl','Archives@ajax_newtpl'])) {
                if (empty($security['security_ask_open'])) {
                    $this->error("<span style='display:none;'>__html__</span>需要开启密保问题设置", url('Security/index'), '', 3);
                }
            }
            /*---------强制必须开启密保问题认证 end----------*/

            $nosubmit = input('param.nosubmit/d');
            if ('POST' == self::$method && empty($nosubmit)) {
                if (empty($security['security_ask_open']) || !$this->security_verify_func($ctl_act)) {
                    return true;
                }
                $admin_id = session('?admin_id') ? (int)session('admin_id') : 0;
                $admin_info = Db::name('admin')->field('admin_id,last_ip')->where(['admin_id'=>$admin_id])->find();
                // 当前管理员密保问题验证过的IP地址
                $security_answerverify_ip = !empty($security['security_answerverify_ip']) ? $security['security_answerverify_ip'] : '-1';
                // 同IP不验证
                if ($admin_info['last_ip'] == $security_answerverify_ip) {
                    return true;
                }

                $this->error("<span style='display:none;'>__html__</span>出于安全考虑<br/>请勿非法越过密保答案验证", null, '', 3);
            }
        }
    }

    /**
     * 后台模板渲染后，密保答案验证
     * @param  [type] &$params [description]
     * @return [type]          [description]
     */
    public function security_verify_viewfilter(&$params)
    {
        $ctl_act = self::$controllerName.'@'.self::$actionName;
        if ('GET' == self::$method && in_array(self::$controllerName, ['Filemanager', 'Weapp']) || in_array($ctl_act, ['Arctype@ajax_newtpl','Archives@ajax_newtpl'])) {
            $security = tpSetting('security');
            if (empty($security['security_ask_open']) || !$this->security_verify_func($ctl_act)) {
                return true;
            }
            $admin_id = session('?admin_id') ? (int)session('admin_id') : 0;
            $admin_info = Db::name('admin')->field('admin_id,last_ip')->where(['admin_id'=>$admin_id])->find();
            // 当前管理员二次安全验证过的IP地址
            $security_answerverify_ip = !empty($security['security_answerverify_ip']) ? $security['security_answerverify_ip'] : '-1';
            // 同IP不验证
            if ($admin_info['last_ip'] == $security_answerverify_ip) {
                return true;
            }

            $security_ask = $security['security_ask'];
            $url = url('Security/ajax_answer_verify', ['_ajax'=>1]);
            $replace = <<<EOF
    <script type="text/javascript">
        $(function(){
            autoload_security();
            function autoload_security()
            {
                layer.prompt({
                    title: '密保问题',
                    id: 'layerid_1645598368',
                    btn: ['确定'],
                    shade: layer_shade,
                    closeBtn: 3,
                    success: function(layero, index) {
                        var before_str = "<div style='margin: -8px 0px 10px 0px;color: red;font-weight: bold;'>{$security_ask}</div>";
                        $("#layerid_1645598368").prepend(before_str);
                        $("#layerid_1645598368").find('input').attr('placeholder', '请录入密保答案！');
                        $("#layerid_1645598368").find('input').bind('keydown', function(event) {
                            if (event.keyCode == 13) {
                                security_answer_verify($(this).val());
                            }
                        });
                    },
                    btn2: function(index, layero){
                        window.location.reload();
                        return false;
                    },
                    cancel: function(index, layero){ 
                        history.back();
                        return false; 
                    }
                }, function(value, index) {
                    security_answer_verify(value);
                });
            }

            function security_answer_verify(answer)
            {
                $.ajax({
                    type : 'post',
                    url : "{$url}",
                    data : {answer:answer},
                    dataType : 'json',
                    success : function(res){
                        if (res.code == 1) {
                            layer.closeAll();
                            layer.msg(res.msg, {time: 1000}, function(){
                                window.location.reload();
                            });
                        }else{
                            $('#layerid_1645598368').find('input[type=text]').focus();
                            layer.msg(res.msg, {time: 1000});
                        }
                    },
                    error: function(e) {
                        showErrorAlert(e.responseText);
                    }
                });
            }
        });
    </script>
EOF;

            $params = str_ireplace('</body>', $replace, $params);
        }
    }

    /**
     * 是否验证了密保答案
     */
    public function security_answer_verify()
    {
        $security = tpSetting('security');
        if (!empty($security['security_ask_open'])) {
            $admin_id = session('?admin_id') ? (int)session('admin_id') : 0;
            $admin_info = \think\Db::name('admin')->field('admin_id,last_ip')->where(['admin_id'=>$admin_id])->find();
            // 当前管理员二次安全验证过的IP地址
            $security_answerverify_ip = !empty($security['security_answerverify_ip']) ? $security['security_answerverify_ip'] : '-1';
            // 同IP不验证
            if (empty($admin_info) || $admin_info['last_ip'] != $security_answerverify_ip) {
                return false;
            }  
        }

        return true;
    }

    /**
     * 当前功能是否需要密保问题验证
     * @param
     * @return bool
     */
    private function security_verify_func($ctl_act = '')
    {
        if (empty($ctl_act)) {
            $ctl = request()->controller();
            $act = request()->action();
            $ctl_all = $ctl.'@*';
            $ctl_act = $ctl.'@'.$act;
        } else {
            $ctl_all = preg_replace('/\@([\w\-]+)$/i', '@*', $ctl_act);
        }

        $security = tpSetting('security');
        $security_verifyfunc = !empty($security['security_verifyfunc']) ? json_decode($security['security_verifyfunc'], true) : ['Filemanager@*','Arctype@ajax_newtpl','Archives@ajax_newtpl'];
        if (in_array($ctl_act, ['Filemanager@*','Arctype@ajax_newtpl','Archives@ajax_newtpl'])) {
            return true;
        } else {
            if (!empty($security['security_ask_open'])) {
                if (in_array($ctl_all, $security_verifyfunc) || in_array($ctl_act, $security_verifyfunc)) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * 编辑在线模板验证
     * @return [type] [description]
     */
    public function edit_filemanager_verify()
    {
        $security = tpSetting('security');
        if (empty($security['security_ask_open']) || empty($security['security_answer'])) {
            return '需要开启密保问题设置';
        } else {
            $admin_id = session('?admin_id') ? (int)session('admin_id') : 0;
            $admin_info = Db::name('admin')->field('admin_id,last_ip')->where(['admin_id'=>$admin_id])->find();
            // 当前管理员二次安全验证过的IP地址
            $security_answerverify_ip = !empty($security['security_answerverify_ip']) ? $security['security_answerverify_ip'] : '-1';
            // 同IP不验证
            if (empty($admin_info) || $admin_info['last_ip'] != $security_answerverify_ip) {
                return '出于安全考虑，请勿非法越过密保答案验证';
            }  
        }
        return '';
    }
}
