<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\controller;

use think\Db;

class Water extends Base
{
    public function _initialize() {
        parent::_initialize();
    }

    /**
     * 图片水印配置
     */
    public function conf()
    {
        if (IS_POST) {
            $param = input('post.');
            if (is_http_url($param['mark_img'])){
                $this->error('仅支持本地图片');
            }

            $waterPath = preg_replace('#^(/[/\w\-]+)?(/public/upload/|/uploads/)#i', '$2', $param['mark_img']);
            $waterImgInfo = @getimagesize('.'.$waterPath);
            $waterImgW = !empty($waterImgInfo[0]) ? $waterImgInfo[0] : 0;
            $waterImgH = !empty($waterImgInfo[1]) ? $waterImgInfo[1] : 0;
            if ($waterImgW > 2000 || $waterImgH > 2000) {
                $this->error('水印图片像素不能过大，否则无法对小图片进行水印！');
            }
            empty($param['mark_img_is_remote']) && $param['mark_img_is_remote'] = 0;
            tpCache('water', $param);
            $this->success('操作成功', url('Water/conf'));
        }
        $this->assign('config', tpCache('water'));
        return $this->fetch();
    }
}

