<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\controller;

use think\Db;
use think\Page;

class UsersScore extends Base
{
    /**
     * 构造方法
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $list     = array();
        $param = input('param.');
        $keywords = input('keywords/s');
        $keywords = trim($keywords);
        $condition = [];
//        $condition = [
//            'type' => ['IN', [1, 2, 5, 8, 10]], // 1(提问)、2(回答)、5(签到)、8(消费赠送)、10(登录赠送积分)
//        ];

        // 操作时间查询
        if (!empty($param['add_time'])) {
            $add_time = explode('~', $param['add_time']);
            $start = strtotime(rtrim($add_time[0]));
            $finish = strtotime(rtrim($add_time[1]).' 23:59:59');
            $condition['a.update_time'] = ['between', "$start, $finish"];
        }

        if ($keywords)  $condition['b.nickname|b.email'] = array('LIKE', "%{$keywords}%");

        $count  = Db::name('users_score')->alias('a')->join('users b','a.users_id = b.users_id')->where($condition)->count('id');// 查询满足要求的总记录数
        $Page   = $pager = new Page($count, config('paginate.list_rows'));// 实例化分页类 传入总记录数和每页显示的记录数
        $list   = Db::name('users_score')
            ->alias('a')
            ->field('a.*,b.username,b.head_pic,b.nickname')
            ->join('users b','a.users_id = b.users_id')
            ->where($condition)
            ->order('id desc')
            ->limit($Page->firstRow . ',' . $Page->listRows)
            ->select();

        $show = $Page->show();
        $this->assign('page', $show);
        $this->assign('list', $list);
        $this->assign('pager', $pager);
        return $this->fetch();
    }

    /**
     * 积分设置
     */
    public function conf()
    {
        if (IS_POST) {
            $post = input('post.');
            getUsersConfigData('score', $post);
            $this->success("操作成功", url('UsersScore/conf'));
        }

        $score = getUsersConfigData('score');
        $this->assign('score', $score);
        return $this->fetch();
    }
}