<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\controller;

use think\Db;

class Thumb extends Base
{
    public function _initialize() {
        parent::_initialize();
    }

    /**
     * 缩略图配置
     */
    public function conf()
    {
        if (IS_POST) {
            $param = input('post.');
            isset($param['thumb_width']) && $param['thumb_width'] = preg_replace('/[^0-9]/', '', $param['thumb_width']);
            isset($param['thumb_height']) && $param['thumb_height'] = preg_replace('/[^0-9]/', '', $param['thumb_height']);
            $thumbConfig = tpCache('thumb'); // 旧数据
            tpCache('thumb', $param);
            /*校验配置是否改动，若改动将会清空缩略图目录*/
            unset($param['__token__']);
            if (md5(serialize($param)) != md5(serialize($thumbConfig))) {
                delFile(HTML_ROOT); // 清空缓存页面
                delFile(UPLOAD_PATH.'thumb'); // 清空缩略图
            }
            /*--end*/
            $this->success('操作成功', url('Thumb/conf'));
        }

        $config = tpCache('thumb');
        // 设置缩略图默认配置
        if (!isset($config['thumb_open'])) {
            $thumbextra = config('global.thumb');
            $param = [
                'thumb_open'    => $thumbextra['open'],
                'thumb_mode'    => $thumbextra['mode'],
                'thumb_color'   => $thumbextra['color'],
                'thumb_width'   => $thumbextra['width'],
                'thumb_height'  => $thumbextra['height'],
            ];
            tpCache('thumb', $param);
            $config = tpCache('thumb');
        }
        $this->assign('config',$config);
        return $this->fetch();
    }
}

