<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\controller;

use think\Db;
use think\Page;
use app\common\logic\ClassifyLogic;

class Classify extends Base
{
    public function _initialize()
    {
        parent::_initialize();
        $this->times = getTime();
        $this->arctype_db = Db::name('arctype');
        $this->classify_db = Db::name('classify');
        $this->classifyModel = model('Classify');
        $this->classifyLogic = new ClassifyLogic();
    }

    public function index($page = '')
    {
        // 删除冗余分类
        if (empty($page)) $this->classifyModel->deleteClassify(true);

        $arctype_list = array();
        // 目录列表
        $where = [
            'current_channel' => 1,
        ];
        $arctype_list = $this->classifyLogic->arctype_list(0, 0, false, 0, $where, false);
        // dump($arctype_list);exit;
        $this->assign('arctype_list', $arctype_list);

        // 模型列表
        $channeltype_list = getChanneltypeList();
        $this->assign('channeltype_list', $channeltype_list);

        // 栏目最多级别
        $arctype_max_level = intval(config('global.arctype_max_level'));
        $this->assign('arctype_max_level', $arctype_max_level);
        
        /* 生成静态页面代码 */
        $typeid = input('param.typeid/d',0);
        $is_del = input('param.is_del/d',0);
        $handle = input('param.handle/s','');
        $this->assign('typeid',$typeid);
        $this->assign('is_del',$is_del);
        $seo_pseudo = tpCache('global.seo_pseudo');//URL模式
        $sitemap_zzbaidutoken = config('tpcache.sitemap_zzbaidutoken');//实时推送Url的token
        $bdminipro = Db::name('weapp')->where(['code'=>'BdDiyminipro','status'=>1])->find();
        $typeurl = '';
        if (!empty($typeid)){
            $typeData = $this->classify_db->where(['id'=>$typeid,'is_hidden'=>0,'status'=>1,'is_del'=>0])->find();
            if (!empty($typeData)){
                $typeurl = get_typeurl($typeData);
            }
        }
        $eyou = [
            'handle'=>$handle,
            'typeurl'=>$typeurl,
            'zzbaidutoken'=>$sitemap_zzbaidutoken,
            'bdminipro'=>$bdminipro,
            'seo_pseudo'=>$seo_pseudo
        ];
        $this->assign('eyou',$eyou);
        /* end */

        /*获取所有有子栏目的栏目id*/
        $parent_ids = $this->classify_db->where([
                'parent_id' => ['gt', 0],
                'is_del'    => 0,
            ])->group('parent_id')->cache(true, EYOUCMS_CACHE_TIME, 'classify')->column('parent_id');
        $cookied_treeclicked =  json_decode(cookie('admin-treeClicked-Arr'));
        empty($cookied_treeclicked) && $cookied_treeclicked = [];
        $all_treeclicked = cookie('admin-treeClicked_All');
        empty($all_treeclicked) && $all_treeclicked = [];
        $tree = [
            'has_children'=>!empty($parent_ids) ? 1 : 0,
            'parent_ids'=>json_encode($parent_ids),
            'all_treeclicked'=>$all_treeclicked,
            'cookied_treeclicked'=>$cookied_treeclicked,
            'cookied_treeclicked_arr'=>json_encode($cookied_treeclicked),
        ];
        $this->assign('tree', $tree);
        /* end */

        return $this->fetch(!empty($page) ? strval($page) : '');
    }

    public function classifyAction()
    {
        if (IS_AJAX_POST) {
            $action = input('param.action/s', '');
            if ('insert' == $action) {
                // 添加分类
                $insertID = $this->classifyModel->insertClassify();
                // 成功返回
                if (!empty($insertID)) $this->returnSuccess('添加成功');
            } else if ('update' == $action) {
                // 编辑分类
                $updateID = $this->classifyModel->updateClassify();
                // 成功返回
                if (!empty($updateID)) $this->returnSuccess('保存成功');
            } else if ('delete' == $action) {
                // 编辑分类
                $deleteID = $this->classifyModel->deleteClassify();
                // 成功返回
                if (!empty($deleteID)) $this->returnSuccess('删除成功');
            }
            $this->error('操作失败');
        }
    }

    // 成功返回
    private function returnSuccess($msg = '操作成功', $url = null, $result = [])
    {
        // 获取列表
        $result['html'] = $this->index('index_list');
        $this->success($msg, $url, $result);
    }

}