<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海口快推科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\controller;

use think\Db;
use think\Page;

class Canal extends Base
{
    public function _initialize(){
        parent::_initialize();
    }

    //渠道首页
    public function index()
    {
        $config = [];

        $config['web'] = tpCache('web');
        if (empty($config['web']['web_status_gzh'])) {
            // 微信公众号端
            $config['gzh'] = get_gzh_config();
        }
        if (empty($config['web']['web_status_h5'])) {
            // h5端
            $h5_qrcodeurl = "";
            $pngurl = $this->request->domain().ROOT_DIR.'/h5/';
            $filepath = UPLOAD_PATH."allimg/20230505/h5-".md5($pngurl).".png";
            if (file_exists($filepath)) {
                $h5_qrcodeurl = "{$this->root_dir}/".$filepath;
            } else {
                tp_mkdir(dirname($filepath));
                vendor('wechatpay.phpqrcode.phpqrcode');
                $qrcode = new \QRcode;
                $qrcode->png($pngurl, $filepath, 0, 8, 1);
                $h5_qrcodeurl = "{$this->root_dir}/".$filepath;
            }
            $config['h5']['h5_qrcodeurl'] = $h5_qrcodeurl;

            // 微信小程序
            $weixin_data = tpSetting("OpenMinicode.conf_weixin");
            $weixin_data = !empty($weixin_data) ? json_decode($weixin_data, true) : [];
            $weixin_qrcodeurl = "";
            if (!empty($weixin_data['appid'])) {
                $filepath = UPLOAD_PATH."allimg/20220515/wx-{$weixin_data['appid']}.png";
                if (is_file($filepath)) $weixin_qrcodeurl = "{$this->root_dir}/".$filepath;
            }
            $config['weixin']['weixin_qrcodeurl'] = $weixin_qrcodeurl;

            // 抖音小程序
            $toutiao_data = tpSetting("OpenMinicode.conf_toutiao");
            $toutiao_data = !empty($toutiao_data) ? json_decode($toutiao_data, true) : [];
            $toutiao_qrcodeurl = "";
            if (!empty($toutiao_data['appid'])) {
                $filepath = UPLOAD_PATH."allimg/20220515/tt-{$toutiao_data['appid']}.png";
                if (is_file($filepath)) $toutiao_qrcodeurl = "{$this->root_dir}/".$filepath;
            }
            $config['toutiao']['toutiao_qrcodeurl'] = $toutiao_qrcodeurl;

            // 百度小程序
            $baidu_data = tpSetting("OpenMinicode.conf_baidu");
            $baidu_data = !empty($baidu_data) ? json_decode($baidu_data, true) : [];
            $baidu_qrcodeurl = "";
            if (!empty($baidu_data['appid'])) {
                $filepath = UPLOAD_PATH."allimg/20220515/bd-{$baidu_data['appid']}.png";
                if (is_file($filepath)) $baidu_qrcodeurl = "{$this->root_dir}/".$filepath;
            }
            $config['baidu']['baidu_qrcodeurl'] = $baidu_qrcodeurl;
        }
        $this->assign($config);

        $eyouCmsLogic = new \app\admin\logic\EyouCmsLogic;
        $this->assign('home_url', $eyouCmsLogic->shouye());
        return $this->fetch();
    }

    //更改渠道首页的状态
    public function change_status()
    {
        if (IS_AJAX_POST){
            $name = input('name/s');
            $value = input('value/d');
            if (empty($name)) $this->error('参数名称错误');
            $web[$name] = $value;
            tpCache('web',$web);
            if (1 == $value) {
                $msg = '关闭成功';
            } else {
                $msg = '开启成功';
            }
            $this->success($msg);
        }
        $this->error('请求失败');
    }

    public function regset()
    {
        if (IS_POST) {
            $post = input('post.');
            foreach ($post as $key => $val) {
                if (in_array($key, ['web'])) {
                    continue;
                }
                getUsersConfigData($key, $val);
            }
            $this->success('操作成功');
        }

        $this->assign('info',$this->usersConfig);
        return $this->fetch();
    }

    

    // 小程序备案
    public function conf_wx_filing()
    {
        
        return $this->fetch();
    }

    // 百度小程序
    public function conf_bd_api()
    {
        return $this->fetch();
    }

    // 百度小程序备案
    public function conf_bd_filing()
    {
        return $this->fetch();
    }

    // h5端链接管理
    public function h5_link_conf()
    {
        return $this->fetch();
    }
}