<?php

namespace app\admin\behavior;

use think\Db;

/**
 * 系统行为扩展：新增/更新/删除之后的后置操作
 */
load_trait('controller/Jump');
class ActionBeginBehavior {
    use \traits\controller\Jump;
    protected static $actionName;
    protected static $controllerName;
    protected static $moduleName;
    protected static $method;

    /**
     * 构造方法
     * @param Request $request Request对象
     * @access public
     */
    public function __construct()
    {

    }

    // 行为扩展的执行入口必须是run
    public function run(&$params){
        self::$actionName = request()->action();
        self::$controllerName = request()->controller();
        self::$moduleName = request()->module();
        self::$method = request()->method();
        $this->_initialize();
    }

    private function _initialize() {
        $securityLogic = new \app\admin\logic\SecurityLogic;
        $securityLogic->security_verify_actionbegin();
        if ('POST' == self::$method) {
            $this->clearWeapp();
            $this->instyes();
        } else {
            $this->useWeapp();
            $this->unotice();
            $this->verifyfile();
        }
    }

    private function useWeapp()
    {
        if (!request()->isAjax()) {
            $sa = input('param.sa/s');
            if ('Weapp@index' == self::$controllerName.'@'.self::$actionName) {
                $weapp_index_gourl = cookie('admin-weapp_index_gourl');
                if (!empty($weapp_index_gourl)) {
                    $this->redirect($weapp_index_gourl);
                }
            } else if ('Weapp@execute' != self::$controllerName.'@'.self::$actionName) {
                cookie('admin-weapp_index_gourl', null);
            }
        }
    }

    private function verifyfile()
    {
        try {
            $class_path     = "\\app\\common\\logic\\FunctionLogic";
            $class_obj     = new $class_path();
            if (method_exists($class_obj, 'auiz')) {
                $logic = new \app\common\logic\FunctionLogic;
                $logic->auiz();
            }
        } catch (\Exception $e) {
            
        }
    }

    private function unotice(){
        $str = 'VXNlcnNOb3RpY2U=';
        if (self::$controllerName == base64_decode($str)) {
            $str = 'd2ViLndlYl9pc19hdXRob3J0b2tlbg==';
            $value = tpCache(base64_decode($str));
            if (-1 == $value) {
                $str = '6K+l5Yqf6IO95LuF6ZmQ5LqO5ZWG5Lia5o6I5p2D5Z+f5ZCN77yB';
                $this->error(base64_decode($str));
            }
        }
    }

    /**
     * 插件每次post提交都清除插件相关缓存
     * @access private
     */
    private function clearWeapp()
    {
        /*只有相应的控制器和操作名才执行，以便提高性能*/
        $ctlActArr = array(
            'Weapp@*',
        );
        $ctlActStr = self::$controllerName.'@*';
        if (in_array($ctlActStr, $ctlActArr)) {
            \think\Cache::clear('hooks');
        }
        /*--end*/
    }

    /**
     * @access private
     */
    private function instyes()
    {
        $ca = md5(self::$actionName.'@'.self::$controllerName);
        if ('0e3e00da04fcf78cd9fd7dc763d956fc' == $ca) {
            $s = '5a6J'.'6KOF'.'5oiQ5'.'Yqf';
            if (1605110400 < getTime()) {
                sleep(5);
                $this->success(base64_decode($s));
            }
        }
    }
}
