package rands

import (
	"testing"
)

var player = []int64{
	325346423, 43534236, 437256243, 123456789, 987654321, 112233445, 556677889, 998877665, 445566778, 334455667,
	223344556, 556644332, 776655443, 554433221, 998822334, 443322110, 123123123, 321321321, 213213213, 231231231,
	987987987, 789789789, 678678678, 876876876, 543543543, 345345345, 234234234, 432432432, 765765765, 567567567,
	678987678, 123789123, 456456456, 654654654, 789123789, 987345987, 543789543, 345123345, 234567234, 432987432,
	123654123, 321456321, 213678213, 231876231, 987321987, 789654789, 678543678, 876234876, 543876543, 345432345,
	234876234, 432123432, 765987765, 567123567, 678456678, 123432123, 321987321, 213543213, 231765231, 987876987,
	789543789, 678321678, 876543876, 543234543, 345987345, 234432234, 432876432, 123987123, 321543321, 213432213,
	231678231, 987123987, 789321789, 678654678, 876789876, 543456543, 345765345, 234123234, 432543432, 123876123,
	321678321, 213987213, 231543231, 987432987, 789876789, 678123678, 876321876, 543765543, 345234345, 234678234,
	432345432, 123765123, 321432321, 213876213, 231432231, 987654987, 789345789, 678876678, 876123876, 543678543,
	345123345, 234876234, 432123432, 123543123, 321765321, 213432213, 231876231, 987321987, 789654789, 678543678,
	876234876, 543876543, 345432345, 234987234, 432654432, 123321123, 321654321, 213987213, 231543231, 987876987,
	789123789, 678654678, 876789876, 543456543, 345765345, 234123234, 432543432, 123876123, 321678321, 213987213,
	231543231, 987432987, 789876789, 678123678, 876321876, 543765543, 345234345, 234678234, 432345432, 123765123,
	321432321, 213876213, 231432231, 987654987, 789345789, 678876678, 876123876, 543678543, 345123345, 234876234,
	432123432, 123543123, 321765321, 213432213, 231876231, 987321987, 789654789, 678543678, 876234876, 543876543,
	345432345, 234987234, 432654432, 123321123, 321654321, 213987213, 231543231, 987876987, 789123789, 678654678,
	876789876, 543456543, 345765345, 234123234, 432543432, 123876123, 321678321, 213987213, 231543231, 987432987,
	789876789, 678123678, 876321876, 543765543, 345234345, 234678234, 432345432, 123765123, 321432321, 213876213,
	231432231, 987654987, 789345789, 678876678, 876123876, 543678543, 345123345, 234876234, 432123432, 123543123,
	321765321, 213432213, 231876231, 987321987, 789654789, 678543678, 876234876, 543876543, 345432345, 234987234,
	432654432, 123321123, 321654321, 213987213, 231543231, 987876987, 789123789, 678654678, 876789876, 543456543,
	345765345, 234123234, 432543432, 123876123, 321678321, 213987213, 231543231, 987432987, 789876789, 678123678,
}

func Benchmark_Rands_Std_V2(b *testing.B) {
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		_ = RandStd(player, 10)
	}
}

func Benchmark_Rands_Std_V1(b *testing.B) {
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		_ = RandStdV1(player, 10)
	}
}

func Benchmark_Rands(b *testing.B) {
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		_ = Rands(player, 10)
	}
}

func Benchmark_CRands(b *testing.B) {
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		_ = CRands(player, 10)
	}
}
