﻿using System;
using System.Diagnostics;
using _1RM.Service;

namespace _1RM.Service.DataSource.DAO
{
    public enum EnumDatabaseStatus
    {
        NotConnectedYet,
        AccessDenied,
        LostConnection,
        OK,
        EncryptKeyError, // 数据加密密钥不匹配，唯一的原因是软件未使用官方发布版本.
    }

    public struct DatabaseStatus
    {
        public static DatabaseStatus New(EnumDatabaseStatus status, string extend = "")
        {
            var ret = new DatabaseStatus()
            {
                Status = status,
                ExtendInfo = extend
            };
            return ret;
        }
        public EnumDatabaseStatus Status;
        public string ExtendInfo;
        public string GetErrorMessage => Status.GetErrorInfo() + " (" + ExtendInfo + ")";
    }


    public static class EnumConnectResultErrorInfo
    {
        public static string GetErrorInfo(this EnumDatabaseStatus result)
        {
            var lang = IoC.Get<LanguageService>();
            switch (result)
            {
                case EnumDatabaseStatus.AccessDenied:
                    return lang.Translate("string_database_error_permission_denied");

                case EnumDatabaseStatus.OK:
                    break;

                case EnumDatabaseStatus.NotConnectedYet:
                    return "database: database is notConnected!";

                case EnumDatabaseStatus.LostConnection:
                    return "database: database lost connection!";

                case EnumDatabaseStatus.EncryptKeyError:
                    return $"database: your database is encrypted by a third-part build {Assert.APP_NAME}, this app can not read your data correctly!";

                default:
                    throw new ArgumentOutOfRangeException(nameof(result), result, null);
            }

            return "";
        }
    }
}