import { storiesOf } from '@storybook/vue';
import Media from '../Media.vue';
import Level from '../Level.vue';
import 'bulma';
var components = {
  Media: Media,
  Level: Level
};

function render(template) {
  return {
    template: template,
    components: components
  };
}

storiesOf(Media.name, module).add('default', function () {
  return render("\n      <Media tag=article style=\"margin: 1.25rem\">\n        <p class=\"image is-64x64\" slot=left>\n          <img src=\"http://bulma.io/images/placeholders/128x128.png\">\n        </p>\n        \n        <div class=\"content\">\n          <p>\n            <strong>John Smith</strong> <small>@johnsmith</small> <small>31m</small>\n            <br>\n            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin ornare magna eros, eu pellentesque tortor vestibulum ut. Maecenas non massa sem. Etiam finibus odio quis feugiat facilisis.\n          </p>\n        </div>\n        \n        <Level device=mobile>\n          <Level left>\n            <Level tag=a item>\n              <span class=\"icon is-small\">\uD83D\uDE05</span>\n            </Level>\n            <Level tag=a item>\n              <span class=\"icon is-small\">\uD83D\uDE04</span>\n            </Level>\n            <Level  tag=a item>\n              <span class=\"icon is-small\">\u2764\uFE0F</span>\n            </Level>\n          </Level>\n        </Level>\n        \n        <button slot=right class=\"delete\"></button>\n      </Media>\n      ");
}).add('nesting', function () {
  return render("\n      <div style=\"margin: 1.25rem\">\n        <Media tag=article>\n          <p class=\"image is-64x64\" slot=\"left\">\n            <img src=\"http://bulma.io/images/placeholders/128x128.png\">\n          </p>\n\n          <div class=\"content\">\n            <p>\n              <strong>Barbara Middleton</strong>\n              <br>\n              Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis porta eros lacus, nec ultricies elit blandit non. Suspendisse pellentesque mauris sit amet dolor blandit rutrum. Nunc in tempus turpis.\n              <br>\n              <small><a>Like</a> \xB7 <a>Reply</a> \xB7 3 hrs</small>\n            </p>\n          </div>\n          \n          <div class=\"media-content\">\n            <Media tag=article>\n              <p class=\"image is-48x48\" slot=left>\n                <img src=\"http://bulma.io/images/placeholders/96x96.png\">\n              </p>\n\n              <div class=\"content\">\n                <p>\n                  <strong>Sean Brown</strong>\n                  <br>\n                  Donec sollicitudin urna eget eros malesuada sagittis. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam blandit nisl a nulla sagittis, a lobortis leo feugiat.\n                  <br>\n                  <small><a>Like</a> \xB7 <a>Reply</a> \xB7 2 hrs</small>\n                </p>\n              </div>\n\n              <Media tag=article>\n                Vivamus quis semper metus, non tincidunt dolor. Vivamus in mi eu lorem cursus ullamcorper sit amet nec massa.\n              </Media>\n      \n              <Media tag=article>\n                Morbi vitae diam et purus tincidunt porttitor vel vitae augue. Praesent malesuada metus sed pharetra euismod. Cras tellus odio, tincidunt iaculis diam non, porta aliquet tortor.\n              </Media>\n            </Media>\n        \n            <Media tag=article>\n              <p class=\"image is-48x48\" slot=left>\n                <img src=\"http://bulma.io/images/placeholders/96x96.png\">\n              </p>\n              <div class=\"content\">\n                <p>\n                  <strong>Kayli Eunice </strong>\n                  <br>\n                  Sed convallis scelerisque mauris, non pulvinar nunc mattis vel. Maecenas varius felis sit amet magna vestibulum euismod malesuada cursus libero. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Phasellus lacinia non nisl id feugiat.\n                  <br>\n                  <small><a>Like</a> \xB7 <a>Reply</a> \xB7 2 hrs</small>\n                </p>\n              </div>\n            </Media>\n          </div>\n        </Media>\n        \n        <Media tag=article>\n          <p class=\"image is-64x64\" slot=left>\n            <img src=\"http://bulma.io/images/placeholders/128x128.png\">\n          </p>\n          \n          <div class=\"field\">\n            <p class=\"control\">\n              <textarea class=\"textarea\" placeholder=\"Add a comment...\"></textarea>\n            </p>\n          </div>\n          <div class=\"field\">\n            <p class=\"control\">\n              <button class=\"button\">Post comment</button>\n            </p>\n          </div>\n        </Media>\n      </div>\n      ");
});