import { storiesOf } from '@storybook/vue';
import xTable from '../Table.vue';
import TableRow from '../TableRow.vue';
import 'bulma';
var components = {
  xTable: xTable,
  TableRow: TableRow
};

function render(template) {
  return {
    template: template,
    components: components
  };
}

storiesOf(xTable.name, module).add('default', function () {
  return render("\n     <xTable abstract>\n      <table>\n        <thead>\n          <tr>\n            <th><abbr title=\"Position\">Pos</abbr></th>\n            <th>Team</th>\n            <th><abbr title=\"Played\">Pld</abbr></th>\n            <th><abbr title=\"Won\">W</abbr></th>\n            <th><abbr title=\"Drawn\">D</abbr></th>\n            <th><abbr title=\"Lost\">L</abbr></th>\n            <th><abbr title=\"Goals for\">GF</abbr></th>\n            <th><abbr title=\"Goals against\">GA</abbr></th>\n            <th><abbr title=\"Goal difference\">GD</abbr></th>\n            <th><abbr title=\"Points\">Pts</abbr></th>\n            <th>Qualification or relegation</th>\n          </tr>\n        </thead>\n        <tfoot>\n          <tr>\n            <th><abbr title=\"Position\">Pos</abbr></th>\n            <th>Team</th>\n            <th><abbr title=\"Played\">Pld</abbr></th>\n            <th><abbr title=\"Won\">W</abbr></th>\n            <th><abbr title=\"Drawn\">D</abbr></th>\n            <th><abbr title=\"Lost\">L</abbr></th>\n            <th><abbr title=\"Goals for\">GF</abbr></th>\n            <th><abbr title=\"Goals against\">GA</abbr></th>\n            <th><abbr title=\"Goal difference\">GD</abbr></th>\n            <th><abbr title=\"Points\">Pts</abbr></th>\n            <th>Qualification or relegation</th>\n          </tr>\n        </tfoot>\n        <tbody>\n          <tr>\n            <th>1</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Leicester_City_F.C.\" title=\"Leicester City F.C.\">Leicester City</a> <strong>(C)</strong>\n            </td>\n            <td>38</td>\n            <td>23</td>\n            <td>12</td>\n            <td>3</td>\n            <td>68</td>\n            <td>36</td>\n            <td>+32</td>\n            <td>81</td>\n            <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Champions_League#Group_stage\" title=\"2016\u201317 UEFA Champions League\">Champions League group stage</a></td>\n          </tr>\n          <tr>\n            <th>2</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Arsenal_F.C.\" title=\"Arsenal F.C.\">Arsenal</a></td>\n            <td>38</td>\n            <td>20</td>\n            <td>11</td>\n            <td>7</td>\n            <td>65</td>\n            <td>36</td>\n            <td>+29</td>\n            <td>71</td>\n            <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Champions_League#Group_stage\" title=\"2016\u201317 UEFA Champions League\">Champions League group stage</a></td>\n          </tr>\n          <tr>\n            <th>3</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Tottenham_Hotspur_F.C.\" title=\"Tottenham Hotspur F.C.\">Tottenham Hotspur</a></td>\n            <td>38</td>\n            <td>19</td>\n            <td>13</td>\n            <td>6</td>\n            <td>69</td>\n            <td>35</td>\n            <td>+34</td>\n            <td>70</td>\n            <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Champions_League#Group_stage\" title=\"2016\u201317 UEFA Champions League\">Champions League group stage</a></td>\n          </tr>\n          <TableRow selected abstract>\n            <tr>\n              <th>4</th>\n              <td><a href=\"https://en.wikipedia.org/wiki/Manchester_City_F.C.\" title=\"Manchester City F.C.\">Manchester City</a></td>\n              <td>38</td>\n              <td>19</td>\n              <td>9</td>\n              <td>10</td>\n              <td>71</td>\n              <td>41</td>\n              <td>+30</td>\n              <td>66</td>\n              <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Champions_League#Play-off_round\" title=\"2016\u201317 UEFA Champions League\">Champions League play-off round</a></td>\n            </tr>\n          </TableRow>\n          <tr>\n            <th>5</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Manchester_United_F.C.\" title=\"Manchester United F.C.\">Manchester United</a></td>\n            <td>38</td>\n            <td>19</td>\n            <td>9</td>\n            <td>10</td>\n            <td>49</td>\n            <td>35</td>\n            <td>+14</td>\n            <td>66</td>\n            <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Europa_League#Group_stage\" title=\"2016\u201317 UEFA Europa League\">Europa League group stage</a></td>\n          </tr>\n          <tr>\n            <th>6</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Southampton_F.C.\" title=\"Southampton F.C.\">Southampton</a></td>\n            <td>38</td>\n            <td>18</td>\n            <td>9</td>\n            <td>11</td>\n            <td>59</td>\n            <td>41</td>\n            <td>+18</td>\n            <td>63</td>\n            <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Europa_League#Group_stage\" title=\"2016\u201317 UEFA Europa League\">Europa League group stage</a></td>\n          </tr>\n          <tr>\n            <th>7</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/West_Ham_United_F.C.\" title=\"West Ham United F.C.\">West Ham United</a></td>\n            <td>38</td>\n            <td>16</td>\n            <td>14</td>\n            <td>8</td>\n            <td>65</td>\n            <td>51</td>\n            <td>+14</td>\n            <td>62</td>\n            <td>Qualification for the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_UEFA_Europa_League#Third_qualifying_round\" title=\"2016\u201317 UEFA Europa League\">Europa League third qualifying round</a></td>\n          </tr>\n          <tr>\n            <th>8</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Liverpool_F.C.\" title=\"Liverpool F.C.\">Liverpool</a></td>\n            <td>38</td>\n            <td>16</td>\n            <td>12</td>\n            <td>10</td>\n            <td>63</td>\n            <td>50</td>\n            <td>+13</td>\n            <td>60</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>9</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Stoke_City_F.C.\" title=\"Stoke City F.C.\">Stoke City</a></td>\n            <td>38</td>\n            <td>14</td>\n            <td>9</td>\n            <td>15</td>\n            <td>41</td>\n            <td>55</td>\n            <td>\u221214</td>\n            <td>51</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>10</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Chelsea_F.C.\" title=\"Chelsea F.C.\">Chelsea</a></td>\n            <td>38</td>\n            <td>12</td>\n            <td>14</td>\n            <td>12</td>\n            <td>59</td>\n            <td>53</td>\n            <td>+6</td>\n            <td>50</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>11</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Everton_F.C.\" title=\"Everton F.C.\">Everton</a></td>\n            <td>38</td>\n            <td>11</td>\n            <td>14</td>\n            <td>13</td>\n            <td>59</td>\n            <td>55</td>\n            <td>+4</td>\n            <td>47</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>12</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Swansea_City_A.F.C.\" title=\"Swansea City A.F.C.\">Swansea City</a></td>\n            <td>38</td>\n            <td>12</td>\n            <td>11</td>\n            <td>15</td>\n            <td>42</td>\n            <td>52</td>\n            <td>\u221210</td>\n            <td>47</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>13</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Watford_F.C.\" title=\"Watford F.C.\">Watford</a></td>\n            <td>38</td>\n            <td>12</td>\n            <td>9</td>\n            <td>17</td>\n            <td>40</td>\n            <td>50</td>\n            <td>\u221210</td>\n            <td>45</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>14</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/West_Bromwich_Albion_F.C.\" title=\"West Bromwich Albion F.C.\">West Bromwich Albion</a></td>\n            <td>38</td>\n            <td>10</td>\n            <td>13</td>\n            <td>15</td>\n            <td>34</td>\n            <td>48</td>\n            <td>\u221214</td>\n            <td>43</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>15</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Crystal_Palace_F.C.\" title=\"Crystal Palace F.C.\">Crystal Palace</a></td>\n            <td>38</td>\n            <td>11</td>\n            <td>9</td>\n            <td>18</td>\n            <td>39</td>\n            <td>51</td>\n            <td>\u221212</td>\n            <td>42</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>16</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/A.F.C._Bournemouth\" title=\"A.F.C. Bournemouth\">AFC Bournemouth</a></td>\n            <td>38</td>\n            <td>11</td>\n            <td>9</td>\n            <td>18</td>\n            <td>45</td>\n            <td>67</td>\n            <td>\u221222</td>\n            <td>42</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>17</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Sunderland_A.F.C.\" title=\"Sunderland A.F.C.\">Sunderland</a></td>\n            <td>38</td>\n            <td>9</td>\n            <td>12</td>\n            <td>17</td>\n            <td>48</td>\n            <td>62</td>\n            <td>\u221214</td>\n            <td>39</td>\n            <td></td>\n          </tr>\n          <tr>\n            <th>18</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Newcastle_United_F.C.\" title=\"Newcastle United F.C.\">Newcastle United</a> <strong>(R)</strong>\n            </td>\n            <td>38</td>\n            <td>9</td>\n            <td>10</td>\n            <td>19</td>\n            <td>44</td>\n            <td>65</td>\n            <td>\u221221</td>\n            <td>37</td>\n            <td>Relegation to the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_Football_League_Championship\" title=\"2016\u201317 Football League Championship\">Football League Championship</a></td>\n          </tr>\n          <tr>\n            <th>19</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Norwich_City_F.C.\" title=\"Norwich City F.C.\">Norwich City</a> <strong>(R)</strong>\n            </td>\n            <td>38</td>\n            <td>9</td>\n            <td>7</td>\n            <td>22</td>\n            <td>39</td>\n            <td>67</td>\n            <td>\u221228</td>\n            <td>34</td>\n            <td>Relegation to the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_Football_League_Championship\" title=\"2016\u201317 Football League Championship\">Football League Championship</a></td>    </tr>\n          <tr>\n            <th>20</th>\n            <td><a href=\"https://en.wikipedia.org/wiki/Aston_Villa_F.C.\" title=\"Aston Villa F.C.\">Aston Villa</a> <strong>(R)</strong>\n            </td>\n            <td>38</td>\n            <td>3</td>\n            <td>8</td>\n            <td>27</td>\n            <td>27</td>\n            <td>76</td>\n            <td>\u221249</td>\n            <td>17</td>\n            <td>Relegation to the <a href=\"https://en.wikipedia.org/wiki/2016%E2%80%9317_Football_League_Championship\" title=\"2016\u201317 Football League Championship\">Football League Championship</a></td>\n          </tr>\n        </tbody>\n      </table>\n     </xTable>\n    ");
}).add('bordered', function () {
  return render("<xTable bordered>\n      <thead>\n        <tr>\n          <th>One</th>\n          <th>Two</th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n      </tbody>\n    </xTable>");
}).add('striped', function () {
  return render("<xTable striped>\n      <thead>\n        <tr>\n          <th>One</th>\n          <th>Two</th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n      </tbody>\n    </xTable>");
}).add('narrow', function () {
  return render("<xTable narrow>\n      <thead>\n        <tr>\n          <th>One</th>\n          <th>Two</th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n      </tbody>\n    </xTable>");
}).add('hoverable', function () {
  return render("<xTable hoverable>\n      <thead>\n        <tr>\n          <th>One</th>\n          <th>Two</th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n      </tbody>\n    </xTable>");
}).add('fullwidth', function () {
  return render("<xTable size=fullwidth>\n      <thead>\n        <tr>\n          <th>One</th>\n          <th>Two</th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n      </tbody>\n    </xTable>");
}).add('all', function () {
  return render("<xTable bordered striped narrow hoverable size=fullwidth>\n      <thead>\n        <tr>\n          <th>One</th>\n          <th>Two</th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n        <tr>\n          <td>Three</td>\n          <td>Four</td>\n        </tr>\n      </tbody>\n    </xTable>");
});