import { storiesOf } from '@storybook/vue';
import Columns from '../Columns.vue';
import Column from '../Column.vue';
var i = 0;
var wrap = 4;
var components = {
  Columns: Columns,
  Column: Column
};
var colors = ['#209cee', '#23d160', '#ffdd57', '#ff3860'];

var color = function color(z) {
  return colors[typeof z === 'number' ? z % wrap : i++ % wrap];
};

var p = function p(content, c) {
  return "<p style=\"padding: 1.25rem; background: " + color(c) + "; color: white; text-align: center\">" + content + "</p>";
};

var render = function render(template, limit) {
  if (limit === void 0) {
    limit = 4;
  }

  i = 0;
  wrap = limit;
  return {
    template: template,
    components: components
  };
};

storiesOf(Columns.name, module).add('basic', function () {
  return render("\n      <Columns>\n        <Column>" + p('First Column') + "</Column>\n        <Column>" + p('Second Column') + "</Column>\n        <Column>" + p('Third Column') + "</Column>\n        <Column>" + p('Fourth Column') + "</Column>\n      </Columns>\n      ");
}).add('sizes', function () {
  return render("\n    <div>\n      <Columns>\n        <Column size=\"three-quarters\">" + p('size: three-quarters') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n      </Columns>\n      \n      <Columns>\n        <Column size=\"two-thirds\">" + p('size: two-thirds') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n      </Columns>\n      \n      <Columns>\n        <Column size=\"half\">" + p('size: half') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n      </Columns>\n      \n      <Columns>\n        <Column size=\"one-third\">" + p('size: one-third') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n      </Columns>\n      \n      <Columns>\n        <Column size=\"one-quarter\">" + p('size: one-quarter') + "</Column>\n        <Column>" + p('Auto') + "</Column>\n      </Columns>\n    </div>\n    ");
}).add('12 columns system', function () {
  return render("\n        <div>\n          <Columns>\n            <Column size=2>" + p('size: 2', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=3>" + p('size: 3', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=4>" + p('size: 4', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=5>" + p('size: 5', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=6>" + p('size: 6', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=7>" + p('size: 7', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=8>" + p('size: 8', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=9>" + p('size: 9', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=10>" + p('size: 10', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n            <Column>" + p(1, 2) + "</Column>\n          </Columns>\n          <Columns>\n            <Column size=11>" + p('size: 11', 0) + "</Column>\n            <Column>" + p(1, 1) + "</Column>\n          </Columns>\n        </div>\n      ");
}).add('offset', function () {
  return render("\n        <div>\n            <Columns device=mobile>\n              <Column size=half offset=one-quarter>" + p('size: half, offset: one-quter') + "</Column>\n            </Columns>\n            \n            <Columns device=mobile>\n              <Column size=4 offset=8>" + p('size: 4, offset: 8') + "</Column>\n            </Columns>\n            \n            <Columns device=mobile>\n            <Column size=11 offset=1>" + p('size: 11, offset: 1') + "</Column>\n            </Columns>\n        </div>\n      ");
}).add('narrow', function () {
  return render("\n      <Columns>\n        <Column narrow>\n          <div class=\"box\" style=\"width: 200px;\">\n            " + p("\n            <span class=\"title is-5\">Narrow column</span><br>\n            <span class=\"subtitle\">This column is only 200px wide.</span>\n            ") + "\n          </div>\n        </Column>\n        <Column>\n          <div class=\"box\">\n            " + p("\n            <span class=\"title is-5\">Flexible column</span><br>\n            <span class=\"subtitle\">This column will take up the remaining space available.</span>\n            ") + "\n          </div>\n        </Column>\n      </Columns>\n      ");
}).add('responsiveness', function () {
  return render("\n      <div>\n        <p>Mobile Columns</p>\n        <Columns device=mobile>\n          <Column>" + p(1) + "</Column>\n          <Column>" + p(2) + "</Column>\n          <Column>" + p(3) + "</Column>\n          <Column>" + p(4) + "</Column>\n        </Columns>\n\n        <p>Desktop Columns</p>\n        <Columns device=desktop>\n          <Column>" + p(1) + "</Column>\n          <Column>" + p(2) + "</Column>\n          <Column>" + p(3) + "</Column>\n          <Column>" + p(4) + "</Column>\n        </Columns>\n\n        <p>Different column sizes per breakpoint </p>\n        <Columns>\n          <Column size$mobile=\"three-quarters\" size$tablet=\"two-thirds\" size$desktop=\"half\" size$widescreen=\"one-third\" size$fullhd=\"one-quarter\">" + p('mobile: three-quaters, tablet: two-thirds, desktop: half, widescreen: one-third, fullhd: one-fourth') + "</Column>\n          <Column>" + p(2) + "</Column>\n          <Column>" + p(3) + "</Column>\n          <Column>" + p(4) + "</Column>\n        </Columns>\n      </div>\n      ");
}).add('nesting', function () {
  return render("\n      <Columns>\n        <Column>\n          " + p('First Column', 1) + "\n          <Columns>\n            <Column>" + p('First Nested', 4) + "</Column>\n            <Column>" + p('Second Nested', 3) + "</Column>\n          </Columns>\n        </Column>\n        <Column>\n          " + p('Second Column', 1) + "\n          <Columns>\n            <Column size=half>" + p('size: half', 4) + "</Column>\n            <Column>" + p('auto', 3) + "</Column>\n            <Column>" + p('auto', 3) + "</Column>\n          </Columns>\n        </Column>\n      </Columns>\n      ");
}).add('gapless', function () {
  return render("\n      <div>\n        <p>Default Gap</p>\n        <Columns :gap=false>\n          <Column>" + p('First Column') + "</Column>\n          <Column>" + p('Second Column') + "</Column>\n          <Column>" + p('Third Column') + "</Column>\n          <Column>" + p('Fourth Column') + "</Column>\n        </Columns>\n\n        <p>Multiline Columns</p>\n        <Columns :gap=false multiline>\n          <Column size=3>" + p('1st Column') + "</Column>\n          <Column size=3>" + p('2nd Column') + "</Column>\n          <Column size=3>" + p('3rd Column') + "</Column>\n          <Column size=3>" + p('4th Column') + "</Column>\n          <Column size=half>" + p('5th Column') + "</Column>\n          <Column size=3>" + p('6th Column') + "</Column>\n          <Column size=3>" + p('7th Column') + "</Column>\n          <Column size=one-quarter>" + p('8th Column') + "</Column>\n          <Column>" + p('9th Column') + "</Column>\n        </Columns>\n\n        <p>Custom Gap</p>\n        <Columns gap=8>\n          <Column size=one-third>" + p('Side') + "</Column>\n          <Column>" + p('Main') + "</Column>\n        </Columns>\n        <Columns gap=3>\n          <Column size=one-third>" + p('Default Gap') + "</Column>\n          <Column size=one-third>" + p('Default Gap') + "</Column>\n          <Column size=one-third>" + p('Default Gap') + "</Column>\n        </Columns>\n        <Columns gap=0>\n          <Column>" + p('Zero Gap') + "</Column>\n          <Column>" + p('zero Gap') + "</Column>\n        </Columns>\n      </div>\n    ");
}).add('multiline', function () {
  return render("\n      <Columns multiline>\n        <Column size=3>" + p('1st Column') + "</Column>\n        <Column size=3>" + p('2nd Column') + "</Column>\n        <Column size=3>" + p('3rd Column') + "</Column>\n        <Column size=3>" + p('4th Column') + "</Column>\n        <Column size=half>" + p('5th Column') + "</Column>\n        <Column size=3>" + p('6th Column') + "</Column>\n        <Column size=3>" + p('7th Column') + "</Column>\n        <Column size=one-quarter>" + p('8th Column') + "</Column>\n        <Column>" + p('9th Column') + "</Column>\n      </Columns>\n      ");
}).add('centered', function () {
  return render("\n      <div>\n        <p>Centered</p>\n        <Columns centered>\n          <Column narrow>" + p('Centered Column') + "</Column>\n        </Columns>\n        \n        <p>Centered & Multiline</p>\n        <Columns centered multiline>\n          <Column narrow>" + p('Centered Column') + "</Column>\n          <Column narrow>" + p('Centered Column') + "</Column>\n          <Column narrow>" + p('Centered Column') + "</Column>\n          <Column narrow>" + p('Centered Column') + "</Column>\n          <Column narrow>" + p('Centered Column') + "</Column>\n          <Column narrow>" + p('Centered Column') + "</Column>\n          <Column narrow>" + p('Centered Column') + "</Column>\n        </Columns>\n\n        <p>Vertically Centered</p><br>\n        <Columns vcentered style=\"height: 250px; background: #ccc\">\n          <Column narrow>" + p('Centered Column') + "</Column>\n        </Columns>\n\n        <p>Vertically & Horizontally Centered</p><br>\n        <Columns centered vcentered style=\"height: 250px; background: #ccc\">\n          <Column narrow>" + p('Centered Column') + "</Column>\n        </Columns>\n      </div>\n      ");
});