﻿//--------------------------------------------------------------------------
// 初始化可能用到的变量
//--------------------------------------------------------------------------

// 设定默认打开就播放的文件名(如果在html中没有设置)
file = _root.file;

// 设定flv录像的长和宽(设置成你想要的值都可以)
w = Stage.width;
h = Stage.height;

//--------------------------------------------------------------------------
// 流设置及函数
//--------------------------------------------------------------------------

// 创建并设置网络流
nc = new NetConnection();
nc.connect(null);
ns = new NetStream(nc);

// 创建并设置声音对像
this.createEmptyMovieClip("snd", 0);
snd.attachAudio(ns);
audio = new Sound(snd);
audio.setVolume(100);

// 绑定显示
videoDisplay.attachVideo(ns);

// 从网络流中获取时间元素
ns.onMetaData = function(obj) {
	this.totalTime = obj.duration;
};

// 从网络流中获取状态消息
ns.onStatus = function(object) { 
	if(object.code == "NetStream.Play.Stop") {
		// 影片完成后返回并暂停
		ns.seek(0);
		if(_root.repeat == 'true') { return; } 
		ns.pause();
		playBut._visible = true;
		pauseBut._visible = false;
		videoDisplay._visible = false;
		playText.txt.text = "click to play";
	}
};


//--------------------------------------------------------------------------
// 控制条功能
//--------------------------------------------------------------------------

// 播放影片并隐藏播放按钮
function playMovie() {
	if(!isStarted) {
		ns.play(file);
		playText.txt.text = "loading ..";
		isStarted = true;
	} else {
		ns.pause();
	}
	pauseBut._visible = true;
	playBut._visible = false;
	videoDisplay._visible = true;
}

// 影片暂停并隐藏暂停按钮
function pauseMovie() {
	ns.pause();
	playBut._visible = true;
	pauseBut._visible = false;
};

// 点击影片的动作
videoBg.onPress = function() {
	if(pauseBut._visible == false) {
		playMovie();
	} else {
		pauseMovie();
	}
};

// 点击暂停按钮的动作
pauseBut.onPress = function() {
	pauseMovie();
};

// 点击播放按钮的动作
playBut.onPress = function() {
	playMovie();
};

// 影片载入进度
progressBar.onEnterFrame = function() {
	loaded = this._parent.ns.bytesLoaded;
	total = this._parent.ns.bytesTotal;
	if (loaded == total && loaded > 1000) {
		this.loa._xscale = 100;
		delete this.onEnterFrame;
	} else {
		this.loa._xscale = int(loaded/total*100);
	}
};

// 影片播放进度
progressBar.tme.onEnterFrame = function() {
	this._xscale = ns.time/ns.totalTime*100;
};

// start playhead scrubbing(看不求懂啥意思)
progressBar.loa.onPress = function() {
	this.onEnterFrame = function() {
		scl = (this._xmouse/this._width)*(this._xscale/100)*(this._xscale/100);
		if(scl < 0.02) { scl = 0; }
		ns.seek(scl*ns.totalTime);
	};
};

// stop playhead scrubbing(看不求懂啥意思)
progressBar.loa.onRelease = progressBar.loa.onReleaseOutside = function () { 
	delete this.onEnterFrame;
	pauseBut._visible == false ? videoDisplay.pause() : null;
};

// volume scrubbing(看不求懂啥意思)
volumeBar.back.onPress = function() {
	this.onEnterFrame = function() {
		var xm = this._xmouse;
		if(xm>=0 && xm <= 20) {
			this._parent.mask._width = this._xmouse;
			this._parent._parent.audio.setVolume(this._xmouse*5);
		}
	};
}
volumeBar.back.onRelease = volumeBar.back.onReleaseOutside = function() {
	delete this.onEnterFrame;
}

//--------------------------------------------------------------------------
// 调整大小并定位所有项目
//--------------------------------------------------------------------------
function setDims(w,h) {
	// 设置显示尺寸
	videoDisplay._width = videoBg._width = w;
	videoDisplay._height = videoBg._height = h-20;
	playText._x = w/2-120;
	playText._y = h/2-20;
		
	// 调整项目到左边 .. 
	playBut._y = pauseBut._y = progressBar._y = volumeBar._y = h-20;
	progressBar._width = w-56;
	volumeBar._x = w-38;
}

// 这儿你不用考虑影片的尺寸
setDims(w,h);



//--------------------------------------------------------------------------
// 就这些了,开始播放影片
//--------------------------------------------------------------------------

// 开始播放影片
// 如果没有自动开始播放,它将搜索jpg图片,并隐藏暂停按钮

pauseBut._visible = false;
/*
if(_root.image) { 
	imageStr = _root.image;
} else {
	imageStr = substring(file,0,file.length-3)+"jpg";
}

imageClip.loadMovie(imageStr);
*/
if (_root.autoStart == true) { playMovie(); }
