;
; GBC room overlays, used for the overworld when in GBC mode.
; Each room has $80 bytes, one for each 16x16 tile on the screen
; * THESE DO NOT ACTUALLY REPRESENT THE PHYSICAL ROOM AT ALL! *
; Rather, these are overlaid on top of the physical layout,
; used to provide extra flair in some screens.
;
; These tables are completely ignored outside of GBC mode.
;

;
; GBC room overlays for rooms 00-CB
; Alternate layouts for rooms 06, 0E, 1B, 2B, 79, 8C
; are stored in the second half of the data
;

RoomGBCOverlaysA::

RoomGBCOverlay00::
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $7C, $7D, $00, $80, $4D, $4D, $4D, $81, $00, $7C
    db $EF, $EF, $EF, $37, $0A, $0A, $0A, $38, $EF, $EF
    db $E5, $E5, $1D, $2E, $48, $E0, $49, $4E, $5D, $E5
    db $E5, $1D, $37, $39, $E1, $E0, $3A, $3B, $38, $E5
    db $1D, $37, $37, $09, $09, $09, $09, $09, $7A, $7A
    db $37, $37, $37, $09, $09, $09, $09, $09, $38, $50
    db $37, $37, $2E, $2F, $2F, $2F, $2F, $2F, $4E, $09

RoomGBCOverlay01::
    db $7C, $7D, $00, $7C, $7D, $00, $00, $00, $00, $00
    db $1C, $1C, $7E, $1C, $1C, $7E, $7D, $00, $00, $00
    db $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF
    db $E5, $E5, $E5, $E5, $E5, $1D, $50, $5D, $E5, $E5
    db $E5, $E5, $E5, $1D, $50, $37, $E8, $38, $50, $50
    db $7A, $7A, $7A, $7A, $0A, $33, $E0, $34, $03, $03
    db $50, $50, $50, $37, $0A, $0A, $0A, $0A, $0A, $0A
    db $09, $09, $09, $2E, $2F, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlay02::
    db $00, $00, $00, $00, $00, $00, $7C, $7D, $00, $00
    db $00, $00, $80, $4D, $81, $7C, $1C, $1C, $7E, $7D
    db $EF, $EF, $37, $03, $38, $EF, $EF, $EF, $EF, $EF
    db $E5, $1D, $2E, $2F, $4E, $5D, $E5, $E5, $E5, $1D
    db $50, $4B, $CD, $E1, $D7, $38, $E5, $E5, $E5, $37
    db $03, $03, $03, $03, $03, $38, $50, $50, $50, $4B
    db $03, $03, $03, $03, $03, $38, $03, $03, $03, $03
    db $2F, $2F, $2F, $2F, $2F, $4E, $03, $03, $03, $3D

RoomGBCOverlay03::
    db $80, $4D, $4D, $81, $00, $80, $4D, $4D, $81, $00
    db $37, $03, $03, $4C, $4D, $4B, $03, $03, $38, $00
    db $37, $03, $03, $03, $03, $03, $03, $03, $38, $EF
    db $37, $03, $03, $3D, $2F, $3C, $03, $03, $38, $5D
    db $2E, $2F, $2F, $4E, $E1, $2E, $2F, $2F, $4E, $38
    db $39, $3A, $3A, $3B, $03, $39, $3A, $3A, $3B, $38
    db $03, $03, $03, $03, $03, $03, $C8, $03, $03, $7A
    db $2F, $2F, $48, $4A, $49, $2F, $48, $4A, $49, $4E

RoomGBCOverlay04::
    db $00, $00, $00, $00, $00, $00, $7C, $7D, $00, $00
    db $7C, $7D, $00, $7C, $7D, $7C, $1C, $1C, $7E, $7D
    db $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF
    db $E5, $E5, $1D, $50, $50, $50, $50, $50, $50, $50
    db $E5, $E5, $37, $03, $03, $A0, $03, $03, $03, $03
    db $E5, $E5, $37, $03, $03, $03, $03, $03, $03, $03
    db $7A, $7A, $7A, $03, $03, $03, $20, $03, $03, $03
    db $1D, $50, $2E, $2F, $2F, $2F, $48, $4A, $49, $2F

RoomGBCOverlay05::
    db $00, $00, $00, $00, $7C, $7D, $00, $00, $00, $00
    db $00, $00, $00, $7C, $1C, $1C, $7E, $7D, $00, $00
    db $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF
    db $50, $50, $50, $50, $50, $50, $50, $5D, $E5, $E5
    db $03, $09, $03, $20, $03, $03, $20, $38, $E5, $E5
    db $03, $20, $03, $03, $20, $03, $03, $38, $E5, $E5
    db $03, $03, $03, $09, $03, $20, $03, $38, $E5, $E5
    db $2F, $2F, $2F, $48, $E0, $49, $2F, $4E, $50, $5D

RoomGBCOverlay06::
    db $00, $00, $00, $00, $05, $06, $07, $00, $00, $00
    db $7C, $7D, $00, $80, $63, $64, $65, $81, $7C, $7D
    db $EF, $EF, $EF, $37, $71, $1C, $7F, $38, $EF, $EF
    db $E5, $E5, $1D, $37, $A9, $AA, $BF, $38, $5D, $E5
    db $E5, $E5, $37, $2E, $48, $E0, $49, $4E, $38, $E5
    db $E5, $E5, $37, $3E, $3A, $E0, $3A, $3F, $38, $E5
    db $E5, $1D, $2E, $2F, $48, $E0, $49, $2F, $4E, $5D
    db $E5, $37, $3E, $3A, $3A, $E0, $3A, $3A, $3B, $38

RoomGBCOverlay07::
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $7C, $7D, $00, $80, $4D, $4D, $4D, $4D, $4D, $81
    db $EF, $EF, $EF, $37, $03, $09, $03, $03, $03, $38
    db $E5, $E5, $1D, $4B, $03, $03, $03, $03, $03, $7A
    db $E5, $E5, $37, $D3, $03, $3D, $48, $4A, $49, $4E
    db $E5, $E5, $37, $03, $03, $38, $3A, $3A, $3A, $3B
    db $E5, $E5, $37, $09, $03, $38, $03, $03, $03, $03
    db $E5, $E5, $2E, $2F, $2F, $4E, $E0, $3C, $03, $03

RoomGBCOverlay08::
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $7C, $7D, $00, $00, $00, $00, $7C, $7D
    db $C8, $7A, $7A, $EF, $7A, $EF, $EF, $EF, $7A, $C8
    db $7A, $7A, $7A, $7B, $7A, $7B, $7B, $7B, $7A, $7A
    db $E5, $E5, $E5, $E5, $E5, $E5, $E5, $E5, $E5, $E5
    db $50, $50, $5D, $E5, $1D, $50, $50, $50, $50, $50
    db $03, $03, $38, $E5, $37, $03, $03, $03, $03, $03
    db $03, $09, $38, $1D, $2E, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlay09::
    db $00, $00, $7C, $7D, $00, $00, $00, $00, $00, $00
    db $00, $7C, $1C, $1C, $7E, $7D, $00, $00, $80, $4D
    db $C8, $78, $78, $EF, $EF, $EF, $EF, $78, $78, $03
    db $79, $79, $79, $7B, $7B, $7B, $7B, $79, $C8, $03
    db $E5, $E5, $E5, $E5, $1D, $50, $50, $50, $2E, $2F
    db $50, $50, $50, $50, $4B, $03, $03, $03, $3E, $3A
    db $03, $03, $03, $03, $03, $03, $09, $03, $39, $3A
    db $48, $4A, $49, $3C, $03, $03, $03, $03, $03, $03

RoomGBCOverlay0A::
    db $80, $4D, $4D, $52, $52, $52, $4D, $4D, $4D, $4D
    db $4B, $03, $09, $5B, $E2, $5B, $09, $03, $03, $03
    db $03, $03, $03, $09, $03, $03, $03, $03, $03, $03
    db $03, $03, $03, $03, $03, $03, $03, $03, $09, $03
    db $2F, $2F, $2F, $48, $E0, $49, $3C, $03, $3D, $2F
    db $3A, $3A, $3A, $3A, $E0, $3A, $2E, $2F, $4E, $3A
    db $3A, $E1, $DE, $03, $03, $03, $39, $E1, $3B, $03
    db $03, $03, $37, $03, $03, $03, $03, $03, $03, $03

RoomGBCOverlay0B::
    db $4D, $4D, $4D, $81, $00, $00, $00, $00, $00, $00
    db $03, $03, $03, $4C, $4D, $81, $7C, $7D, $00, $00
    db $03, $03, $03, $03, $03, $38, $EF, $EF, $EF, $EF
    db $03, $03, $03, $03, $03, $7A, $7A, $7B, $7A, $7A
    db $2F, $2F, $2F, $2F, $2F, $4E, $50, $5D, $E5, $E5
    db $3A, $3A, $3A, $3A, $3A, $3B, $03, $78, $78, $78
    db $03, $03, $03, $03, $03, $03, $09, $79, $79, $79
    db $03, $03, $03, $03, $09, $09, $03, $38, $E5, $E5

RoomGBCOverlay0C::
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $7C, $7D, $00, $7C, $7D, $80, $4D, $4D, $81
    db $EF, $78, $78, $7A, $7A, $7A, $7A, $20, $20, $38
    db $7A, $79, $79, $E5, $E5, $1D, $4B, $20, $03, $38
    db $E5, $1D, $50, $50, $5D, $37, $03, $03, $7A, $7A
    db $78, $78, $03, $03, $38, $37, $03, $03, $38, $3F
    db $79, $79, $03, $03, $38, $2E, $2F, $2F, $4E, $3F
    db $E5, $2E, $2F, $E0, $4E, $3E, $53, $3A, $3F, $3F

RoomGBCOverlay0D::
    db $00, $00, $00, $00, $00, $00, $00, $7C, $7D, $00
    db $80, $4D, $4D, $4D, $81, $00, $7C, $1C, $1C, $7D
    db $2E, $2F, $2F, $2F, $4E, $EF, $EF, $EF, $EF, $EF
    db $3E, $3A, $3A, $3A, $3F, $1D, $50, $50, $5D, $E5
    db $7A, $7A, $7A, $7A, $7A, $7A, $03, $03, $38, $E5
    db $3E, $3A, $3A, $3A, $3F, $37, $03, $03, $38, $E5
    db $3E, $E1, $3A, $3A, $3F, $2E, $2F, $2F, $4E, $E5
    db $37, $03, $03, $03, $38, $3E, $3A, $3A, $3F, $E5

RoomGBCOverlay0E::
    db $00, $00, $00, $72, $74, $74, $74, $73, $00, $00
    db $7C, $7E, $7D, $72, $75, $D6, $76, $73, $7C, $7D
    db $EF, $EF, $EF, $72, $74, $74, $74, $73, $EF, $EF
    db $1D, $50, $50, $72, $74, $74, $74, $73, $50, $50
    db $37, $54, $20, $B6, $74, $74, $74, $B7, $03, $03
    db $37, $20, $03, $03, $03, $03, $09, $03, $03, $09
    db $2E, $3C, $03, $09, $03, $03, $03, $03, $03, $03
    db $3E, $2E, $2F, $2F, $48, $4A, $49, $48, $4A, $49

RoomGBCOverlay0F::
    db $00, $00, $00, $00, $00, $00, $7C, $7D, $00, $00
    db $7C, $7D, $00, $00, $7C, $7E, $1C, $1C, $7D, $00
    db $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF, $EF
    db $50, $50, $50, $52, $52, $52, $50, $50, $5D, $E5
    db $03, $09, $03, $B6, $E2, $B7, $03, $09, $38, $E5
    db $03, $03, $03, $03, $03, $03, $03, $03, $38, $E5
    db $03, $03, $03, $03, $03, $03, $3D, $2F, $4E, $E5
    db $2F, $2F, $2F, $2F, $2F, $2F, $4E, $3A, $3F, $E5

RoomGBCOverlay10::
    db $37, $37, $39, $B6, $3A, $E1, $3A, $B6, $3B, $C8
    db $37, $37, $09, $B7, $09, $09, $09, $B7, $09, $09
    db $37, $37, $C8, $09, $09, $09, $09, $09, $C8, $09
    db $37, $37, $03, $03, $03, $09, $03, $03, $03, $09
    db $37, $37, $09, $03, $09, $09, $09, $03, $09, $3D
    db $37, $37, $03, $09, $09, $09, $03, $03, $03, $38
    db $37, $33, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $34
    db $2E, $2F, $2F, $2F, $2F, $2F, $3C, $25, $26, $25

RoomGBCOverlay11::
    db $C8, $C8, $C8, $39, $3A, $3A, $3A, $3A, $3A, $3A
    db $09, $03, $03, $03, $03, $25, $45, $26, $03, $03
    db $09, $09, $03, $09, $03, $27, $E1, $28, $03, $03
    db $09, $09, $03, $09, $03, $03, $03, $03, $03, $03
    db $2F, $2F, $3C, $03, $03, $03, $3D, $2F, $2F, $2F
    db $C8, $6F, $2E, $48, $4A, $49, $4E, $3A, $3A, $3A
    db $C8, $03, $39, $3A, $3A, $3A, $3B, $03, $03, $03
    db $26, $0A, $09, $0A, $0A, $3D, $48, $4A, $49, $3C

RoomGBCOverlay12::
    db $3A, $3A, $3A, $3A, $3A, $3B, $03, $03, $03, $38
    db $03, $03, $03, $03, $09, $03, $03, $03, $03, $38
    db $03, $03, $03, $03, $03, $03, $03, $03, $03, $38
    db $03, $09, $03, $03, $03, $03, $03, $03, $03, $38
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $4E
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3B
    db $03, $03, $03, $03, $03, $03, $03, $03, $03, $03
    db $3D, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlay13::
    db $3A, $3A, $3A, $3A, $3A, $BA, $3A, $3A, $3A, $3B
    db $C8, $03, $C8, $03, $03, $03, $C8, $03, $C8, $03
    db $03, $03, $C8, $03, $C8, $03, $C8, $03, $03, $C8
    db $03, $C8, $03, $03, $03, $03, $C8, $03, $03, $C8
    db $C8, $03, $03, $C8, $03, $C8, $03, $03, $C8, $03
    db $C8, $03, $03, $03, $03, $03, $03, $03, $03, $C8
    db $03, $03, $03, $03, $C8, $03, $03, $C8, $09, $C8
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlay14::
    db $37, $03, $3E, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $37, $03, $39, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $2E, $3C, $03, $03, $03, $03, $03, $03, $03, $03
    db $39, $2E, $2F, $48, $E0, $49, $2F, $2F, $2F, $2F
    db $09, $39, $3A, $3A, $E0, $3A, $3A, $3A, $3A, $3A
    db $C8, $03, $03, $03, $03, $03, $03, $03, $03, $03
    db $03, $C8, $03, $03, $03, $09, $3D, $2F, $2F, $2F
    db $2F, $2F, $2F, $2F, $2F, $2F, $4E, $3A, $3A, $3A

RoomGBCOverlay15::
    db $3A, $3A, $3A, $3A, $E0, $3A, $3A, $3F, $03, $38
    db $3A, $3A, $3A, $3A, $E0, $3A, $3A, $3B, $09, $38
    db $03, $09, $03, $03, $03, $03, $3D, $2F, $2F, $4E
    db $2F, $2F, $2F, $2F, $2F, $2F, $4E, $3A, $E1, $3B
    db $3A, $3A, $3A, $3A, $3A, $3A, $3B, $03, $03, $C8
    db $03, $03, $03, $03, $03, $03, $03, $03, $09, $C8
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $3C
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $2E

RoomGBCOverlay16::
    db $1D, $2E, $2F, $2F, $48, $E0, $49, $2F, $2F, $4E
    db $37, $3E, $3A, $3A, $3A, $E0, $3A, $3A, $3A, $3F
    db $37, $3E, $3A, $3A, $3A, $E0, $3A, $3A, $3A, $3F
    db $2E, $2F, $2F, $2F, $48, $E0, $49, $2F, $2F, $2F
    db $39, $3A, $3A, $3A, $3A, $E0, $3A, $3A, $3A, $3A
    db $C8, $03, $03, $03, $D4, $03, $03, $09, $03, $C8
    db $C8, $09, $03, $03, $03, $03, $03, $03, $03, $C8
    db $2F, $2F, $2F, $2F, $48, $E0, $49, $2F, $2F, $2F

RoomGBCOverlay17::
    db $5D, $1D, $3E, $3A, $3A, $3F, $E0, $37, $03, $09
    db $38, $37, $3E, $3A, $3A, $3F, $E0, $37, $03, $03
    db $38, $37, $39, $E1, $3A, $3B, $03, $2E, $2F, $2F
    db $4E, $37, $20, $03, $20, $09, $03, $39, $3A, $3A
    db $3B, $37, $09, $20, $03, $03, $03, $03, $03, $DD
    db $03, $33, $2F, $2F, $48, $E0, $49, $2F, $2F, $4E
    db $03, $03, $DD, $3A, $3A, $E0, $3A, $3A, $3A, $3F
    db $2F, $2F, $4E, $3A, $3A, $E0, $3A, $3A, $3A, $3F

RoomGBCOverlay18::
    db $03, $03, $38, $37, $39, $3A, $E1, $3A, $E1, $3A
    db $03, $03, $38, $37, $A0, $03, $03, $C8, $09, $03
    db $2F, $2F, $4E, $37, $03, $03, $09, $C8, $03, $03
    db $3A, $3A, $37, $37, $03, $03, $03, $C8, $03, $03
    db $3A, $3A, $37, $33, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $37, $1B, $1B, $1B, $1B, $1B, $1B, $1B
    db $3A, $3A, $2E, $2F, $2F, $2F, $2F, $2F, $3C, $1B
    db $25, $26, $3E, $3A, $3A, $3A, $3A, $3A, $2E, $2F

RoomGBCOverlay19::
    db $3A, $3A, $3A, $37, $03, $03, $03, $03, $09, $03
    db $03, $03, $03, $37, $03, $03, $03, $03, $03, $03
    db $03, $03, $09, $37, $03, $09, $03, $3D, $2F, $2F
    db $03, $03, $03, $2E, $2F, $2F, $2F, $4E, $E1, $3A
    db $2F, $48, $E0, $39, $3A, $3A, $3A, $3B, $1B, $1B
    db $1B, $1B, $1B, $1B, $1B, $1B, $1B, $1B, $1B, $1B
    db $1B, $3D, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $2F, $4E, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay1A::
    db $03, $03, $37, $03, $03, $03, $03, $03, $03, $03
    db $03, $03, $37, $03, $3D, $2F, $2F, $2F, $3C, $03
    db $2F, $2F, $2E, $2F, $4E, $53, $53, $53, $2E, $2F
    db $3A, $3A, $3E, $3A, $3F, $E9, $E9, $E9, $3E, $3A
    db $1B, $1B, $39, $3A, $3B, $E9, $E9, $E9, $39, $3A
    db $1B, $1B, $1B, $1B, $1B, $1B, $1B, $1B, $1B, $1B
    db $2F, $2F, $2F, $3C, $1B, $1B, $1B, $1B, $1B, $1B
    db $3A, $3A, $3A, $2E, $2F, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlay1B::
    db $03, $03, $03, $03, $03, $03, $03, $38, $50, $50
    db $03, $3D, $2F, $3C, $03, $03, $03, $38, $1B, $1B
    db $2F, $4E, $53, $2E, $2F, $2F, $2F, $4E, $1B, $1B
    db $3A, $3F, $E9, $3E, $3A, $3A, $53, $3F, $1B, $1B
    db $3A, $3B, $E9, $39, $3A, $3A, $E9, $3B, $1B, $1B
    db $1B, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $1B, $1B
    db $1B, $3D, $48, $E9, $E9, $E9, $49, $3C, $0E, $1B
    db $2F, $4E, $3A, $E9, $E9, $E9, $3A, $2E, $2F, $2F

RoomGBCOverlay1C::
    db $50, $3E, $3A, $E0, $3F, $3E, $E9, $3A, $3F, $3F
    db $1B, $3E, $3A, $E0, $3F, $3E, $E9, $3A, $3F, $3F
    db $1B, $3E, $3A, $E0, $3F, $3E, $E9, $3A, $3F, $3B
    db $1B, $3E, $3A, $E0, $3F, $39, $E9, $3A, $3B, $1B
    db $1B, $39, $3A, $E0, $3B, $0E, $0E, $0E, $1B, $1B
    db $1B, $1B, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $1B
    db $1B, $3D, $2F, $E9, $2F, $E9, $2F, $E9, $2F, $2F
    db $2F, $4E, $3A, $E9, $3A, $E9, $3A, $E9, $3A, $3A

RoomGBCOverlay1D::
    db $37, $03, $03, $03, $32, $2C, $2D, $3A, $3F, $E5
    db $2E, $2F, $3C, $03, $03, $A0, $38, $3A, $3F, $E5
    db $39, $E1, $37, $03, $03, $03, $38, $3A, $3F, $50
    db $1B, $1B, $2E, $2F, $2F, $2F, $4E, $3A, $3F, $03
    db $1B, $1B, $3E, $3A, $3A, $3A, $3F, $E1, $3B, $03
    db $1B, $1B, $39, $3A, $3A, $3A, $3B, $03, $03, $03
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay1E::
    db $3E, $3E, $3A, $E1, $3A, $3A, $3A, $E1, $3A, $3A
    db $3E, $3E, $DE, $03, $DD, $3A, $DE, $03, $03, $03
    db $39, $3E, $2E, $E0, $4E, $3A, $2E, $2F, $2F, $2F
    db $03, $39, $3E, $E0, $3F, $3A, $3E, $DE, $03, $03
    db $03, $6F, $39, $E0, $3B, $E8, $39, $2E, $2F, $2F
    db $03, $03, $03, $03, $03, $03, $03, $39, $3A, $3A
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay1F::
    db $3A, $3A, $E1, $3A, $3A, $3A, $3F, $E1, $3F, $E5
    db $03, $09, $03, $03, $DD, $3A, $3F, $03, $38, $E5
    db $48, $E0, $49, $2F, $4E, $3A, $3F, $03, $38, $E5
    db $03, $03, $DD, $3A, $3F, $E1, $3B, $03, $38, $E5
    db $2F, $2F, $4E, $BA, $3B, $03, $03, $03, $38, $E5
    db $3A, $3A, $3B, $03, $03, $03, $03, $03, $38, $E5
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $4E, $E5
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3F, $E5

RoomGBCOverlay20::
    db $37, $3A, $3A, $3A, $3A, $3A, $37, $27, $28, $27
    db $37, $3A, $3A, $3A, $3A, $3A, $2E, $2F, $2F, $2F
    db $37, $F7, $FF, $F9, $FF, $F6, $39, $3A, $E1, $3A
    db $2E, $3C, $F7, $FA, $FF, $FF, $F9, $F8, $04, $04
    db $39, $37, $F6, $04, $F7, $FA, $F8, $04, $04, $2B
    db $0E, $37, $FF, $F6, $20, $04, $04, $20, $04, $37
    db $0E, $37, $FF, $FF, $F9, $F9, $F6, $04, $F5, $37
    db $0E, $37, $FB, $FF, $FF, $FF, $F8, $04, $FB, $37

RoomGBCOverlay21::
    db $28, $0A, $0A, $0A, $0A, $38, $3A, $3A, $3A, $37
    db $2F, $2F, $48, $E0, $49, $4E, $3A, $3A, $3A, $37
    db $3A, $E1, $3A, $E0, $3A, $3B, $04, $04, $F5, $37
    db $F7, $FA, $F8, $04, $5C, $5C, $F5, $F9, $FF, $37
    db $2D, $04, $04, $04, $F5, $F9, $FF, $FA, $0A, $37
    db $38, $F6, $5C, $F5, $FF, $FF, $0A, $5C, $0A, $37
    db $38, $FF, $F9, $FF, $FF, $0A, $0A, $0A, $0A, $37
    db $38, $FB, $FF, $FF, $FF, $FF, $FF, $FF, $0A, $37

RoomGBCOverlay22::
    db $38, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $38, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $38, $FF, $F8, $11, $30, $51, $30, $1B, $1B, $51
    db $38, $FC, $13, $17, $30, $51, $1B, $1B, $1B, $1B
    db $38, $F8, $11, $30, $30, $51, $1B, $1B, $1B, $51
    db $38, $04, $11, $30, $1B, $1B, $1B, $51, $51, $1B
    db $38, $04, $11, $1B, $1B, $1B, $1B, $1B, $1B, $1B
    db $38, $04, $11, $1B, $1B, $51, $1B, $1B, $51, $51

RoomGBCOverlay23::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $51, $30, $30, $1B, $1B, $1B, $1B, $51, $1B, $1B
    db $1B, $30, $1B, $1B, $51, $1B, $1B, $1B, $1B, $51
    db $51, $51, $51, $1B, $1B, $1B, $1B, $1B, $51, $51
    db $1B, $1B, $1B, $51, $1B, $1B, $1B, $1B, $1B, $51
    db $1B, $1B, $1B, $1B, $1B, $1B, $51, $1B, $1B, $51
    db $51, $1B, $1B, $1B, $51, $1B, $51, $1B, $1B, $51

RoomGBCOverlay24::
    db $3A, $3A, $B6, $D7, $B6, $3A, $3F, $3A, $3A, $3A
    db $3A, $B6, $B7, $E1, $B7, $B6, $3B, $04, $F7, $FD
    db $1B, $1B, $1B, $1B, $1B, $12, $20, $20, $04, $25
    db $51, $1B, $1B, $1B, $1B, $18, $14, $25, $26, $27
    db $51, $1B, $1B, $1B, $1B, $1B, $12, $27, $28, $F5
    db $51, $1B, $1B, $1B, $1B, $1B, $12, $20, $F5, $FF
    db $51, $1B, $1B, $1B, $1B, $1B, $12, $20, $F7, $FA
    db $51, $51, $51, $1B, $1B, $51, $12, $25, $26, $25

RoomGBCOverlay25::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3E
    db $FA, $F8, $04, $04, $04, $04, $04, $F7, $FF, $39
    db $26, $25, $26, $20, $36, $2F, $3C, $04, $F7, $F8
    db $28, $27, $28, $20, $D4, $20, $37, $04, $04, $04
    db $F9, $FD, $FD, $F6, $04, $04, $2E, $48, $4A, $49
    db $FC, $36, $3C, $F7, $F9, $F6, $39, $3A, $3A, $3A
    db $FA, $F9, $37, $04, $F7, $FF, $F9, $F6, $04, $04
    db $26, $F7, $37, $04, $04, $F7, $FA, $FF, $F9, $F6

RoomGBCOverlay26::
    db $3A, $3A, $3A, $3A, $3A, $E0, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $E0, $3A, $3A, $3A, $3A
    db $04, $F5, $FA, $FD, $F8, $04, $04, $09, $F7, $F9
    db $F5, $FC, $3D, $2F, $48, $4A, $49, $2F, $2F, $2F
    db $2F, $2F, $4E, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3B, $FF, $FF, $F9, $F8, $04, $F7, $FA
    db $F7, $FF, $FF, $FF, $FA, $F8, $3D, $35, $04, $04
    db $04, $FB, $FF, $F8, $04, $3D, $4E, $F6, $04, $04

RoomGBCOverlay27::
    db $3A, $3A, $3F, $3A, $3A, $E0, $3A, $3A, $3A, $3B
    db $3A, $3A, $3B, $04, $F7, $F9, $FC, $09, $04, $04
    db $FA, $F6, $04, $04, $09, $F7, $FA, $F6, $04, $2B
    db $2F, $2F, $48, $4A, $49, $2F, $3C, $FE, $09, $37
    db $3A, $3A, $3A, $3A, $3A, $3A, $37, $FF, $F6, $37
    db $FF, $FF, $0A, $0A, $5C, $5C, $37, $F7, $FC, $37
    db $F7, $FF, $FF, $FF, $F6, $5C, $37, $04, $FB, $37
    db $04, $FB, $FF, $FF, $FF, $F6, $37, $09, $FB, $37

RoomGBCOverlay28::
    db $27, $28, $39, $3A, $3A, $3A, $3A, $3A, $3E, $3A
    db $04, $04, $F7, $F8, $47, $3A, $3A, $3A, $3E, $3A
    db $2D, $F6, $04, $04, $38, $0E, $0E, $0E, $39, $3A
    db $38, $FF, $F9, $F9, $38, $0E, $0E, $0E, $0E, $0E
    db $38, $FF, $FF, $FF, $32, $2C, $2C, $2C, $2C, $2C
    db $38, $FB, $FF, $F8, $04, $20, $F5, $FF, $FA, $FF
    db $38, $FF, $FC, $04, $3D, $2F, $2F, $2F, $3C, $F7
    db $38, $FF, $FF, $F9, $38, $3A, $3A, $3A, $2E, $2F

RoomGBCOverlay29::
    db $3A, $3F, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3F, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3B, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2C, $2D, $0E, $2B, $2C, $2C, $2C, $2C, $2C
    db $FF, $F8, $38, $2C, $31, $F5, $F9, $FF, $F9, $FF
    db $F8, $04, $38, $F5, $F9, $FA, $FA, $FF, $FF, $FA
    db $48, $E0, $4E, $0A, $2B, $2C, $2D, $FB, $FC, $2B

RoomGBCOverlay2A::
    db $3A, $3A, $3A, $3E, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3E, $B6, $B7, $3A, $B6, $B7, $3A
    db $0E, $0E, $0E, $39, $3A, $3A, $E1, $3A, $3A, $3A
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2D, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $F6, $32, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $FF, $F9, $F6, $04, $04, $04, $04, $04, $04, $04
    db $2C, $2D, $FF, $F9, $2B, $2C, $2D, $F9, $F9, $2B

RoomGBCOverlay2B::
    db $3A, $3F, $3A, $E9, $E9, $E9, $3A, $3E, $3A, $3A
    db $3A, $3F, $3A, $E9, $E9, $E9, $3A, $3E, $3A, $3A
    db $3A, $3B, $0E, $0E, $0E, $0E, $0E, $39, $3A, $3A
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2C, $2C, $2C, $54, $2C, $2C, $2C, $2C, $2C
    db $04, $04, $04, $04, $04, $04, $04, $04, $04, $04
    db $2C, $2D, $2B, $2C, $2D, $2B, $2C, $2D, $2B, $2C

RoomGBCOverlay2C::
    db $3A, $3F, $3A, $E9, $3A, $E9, $3A, $E9, $3A, $3A
    db $3A, $3F, $3A, $E9, $3A, $E9, $3A, $E9, $3A, $3A
    db $3A, $3B, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $2B, $2C, $2D, $0E, $2B
    db $0E, $0E, $0E, $2B, $2C, $37, $E8, $38, $2C, $37
    db $2C, $2C, $2C, $31, $0A, $33, $E0, $34, $0A, $33
    db $04, $04, $04, $F7, $FA, $0A, $0A, $0A, $FA, $0A
    db $2D, $2B, $2C, $2D, $04, $2B, $2C, $2D, $04, $2B

RoomGBCOverlay2D::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2D, $0E, $0E, $2B, $2C, $2D, $0E, $2B, $2C
    db $E8, $38, $2C, $2C, $37, $C6, $38, $2C, $31, $F5
    db $2F, $34, $F9, $0A, $33, $E0, $34, $0A, $F9, $FF
    db $0A, $0A, $FF, $FF, $0A, $0A, $0A, $FF, $FA, $F8
    db $2C, $2D, $FB, $FF, $2B, $2C, $2D, $F8, $04, $04

RoomGBCOverlay2E::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $E1, $3A, $3A, $3A, $3A
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2C, $2C, $2D, $0E, $0E, $2B, $2C, $2C, $2C
    db $F9, $FA, $F8, $F2, $0E, $0E, $EA, $F7, $FF, $F9
    db $F8, $6E, $04, $F3, $0E, $0E, $F0, $04, $F7, $FA
    db $04, $04, $04, $F3, $0E, $0E, $F0, $04, $6E, $25
    db $04, $F5, $F6, $F4, $0E, $CA, $F1, $04, $04, $27

RoomGBCOverlay2F::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3F, $2D
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3B, $38
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $38
    db $2C, $2C, $2C, $2C, $2C, $2D, $0E, $0E, $0E, $38
    db $FF, $F9, $F6, $04, $04, $38, $0E, $0E, $0E, $38
    db $FA, $FA, $FF, $F9, $F6, $32, $2D, $CA, $0E, $38
    db $26, $C6, $F7, $FA, $FF, $F6, $38, $0E, $CA, $38
    db $29, $26, $25, $26, $FB, $FF, $38, $0E, $0E, $38

RoomGBCOverlay30::
    db $0E, $37, $FB, $FF, $FF, $F8, $04, $F5, $FF, $37
    db $0E, $37, $44, $FF, $F8, $F5, $52, $52, $52, $37
    db $2B, $31, $FB, $FC, $04, $0A, $5B, $E2, $5B, $37
    db $37, $F9, $FF, $F8, $E8, $F7, $0A, $0A, $0A, $2E
    db $37, $44, $F8, $04, $04, $04, $E8, $E8, $E8, $39
    db $37, $25, $26, $04, $D4, $E8, $E8, $04, $04, $04
    db $37, $27, $29, $26, $04, $F5, $F6, $04, $25, $26
    db $37, $25, $2A, $28, $04, $F7, $FF, $F6, $27, $29

RoomGBCOverlay31::
    db $38, $FB, $FF, $FF, $FF, $FF, $FF, $FF, $0A, $37
    db $38, $FF, $FF, $FA, $FA, $FF, $FF, $FA, $F8, $37
    db $38, $F7, $44, $25, $26, $F7, $F8, $25, $26, $2E
    db $4E, $E8, $E8, $27, $28, $25, $45, $2A, $28, $39
    db $3B, $04, $F5, $0A, $0A, $27, $E1, $28, $0A, $0A
    db $04, $04, $F7, $FF, $FF, $0A, $0A, $FF, $FA, $0A
    db $25, $26, $04, $F7, $FA, $FA, $FA, $F8, $25, $26
    db $2A, $29, $26, $25, $26, $25, $26, $25, $2A, $29

RoomGBCOverlay32::
    db $38, $F6, $11, $1B, $1B, $51, $1B, $1B, $51, $51
    db $38, $44, $11, $30, $1B, $51, $1B, $1B, $1B, $51
    db $4E, $FC, $11, $30, $30, $1B, $51, $1B, $1B, $1B
    db $3B, $FE, $15, $D4, $19, $1B, $1B, $51, $1B, $1B
    db $0A, $FF, $F9, $F6, $11, $30, $30, $1B, $51, $51
    db $0A, $0A, $FF, $44, $15, $10, $19, $30, $51, $1B
    db $25, $26, $25, $26, $25, $26, $25, $2A, $51, $1B
    db $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29

RoomGBCOverlay33::
    db $51, $1B, $1B, $1B, $51, $1B, $51, $1B, $1B, $51
    db $51, $1B, $1B, $1B, $51, $1B, $51, $1B, $1B, $51
    db $1B, $1B, $1B, $1B, $51, $1B, $51, $1B, $1B, $1B
    db $1B, $1B, $1B, $51, $1B, $1B, $51, $1B, $1B, $1B
    db $51, $51, $51, $1B, $1B, $1B, $1B, $51, $51, $51
    db $1B, $1B, $1B, $51, $1B, $1B, $1B, $1B, $1B, $1B
    db $1B, $30, $30, $1B, $1B, $51, $1B, $30, $30, $1B
    db $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29

RoomGBCOverlay34::
    db $51, $51, $51, $1B, $1B, $51, $12, $27, $28, $27
    db $51, $A0, $51, $1B, $1B, $30, $12, $04, $04, $25
    db $1B, $1B, $51, $1B, $1A, $10, $16, $25, $26, $27
    db $1B, $51, $1B, $1A, $16, $25, $26, $27, $28, $F5
    db $51, $51, $1B, $12, $20, $27, $28, $F5, $F9, $FA
    db $1B, $1B, $30, $12, $20, $F5, $FD, $FA, $F8, $25
    db $1B, $30, $29, $26, $F5, $FC, $25, $26, $25, $2A
    db $2A, $29, $2A, $28, $F7, $F8, $27, $29, $2A, $29

RoomGBCOverlay35::
    db $28, $04, $37, $0F, $0F, $0F, $14, $FB, $FF, $FC
    db $26, $F5, $37, $1B, $1B, $30, $12, $F7, $FF, $FC
    db $28, $FB, $37, $1B, $1B, $1A, $16, $04, $F7, $F8
    db $F9, $FF, $2E, $2F, $2F, $2F, $48, $4A, $4A, $49
    db $FA, $FC, $39, $3A, $3A, $B6, $E1, $B6, $3A, $3A
    db $26, $F7, $F6, $6F, $F5, $F6, $04, $04, $04, $04
    db $29, $26, $F7, $FD, $FA, $FA, $FD, $F6, $25, $26
    db $2A, $29, $26, $25, $26, $25, $26, $25, $2A, $29

RoomGBCOverlay36::
    db $04, $F7, $F8, $04, $04, $38, $3B, $FF, $F6, $04
    db $04, $3D, $48, $4A, $49, $4E, $0A, $FF, $FF, $F9
    db $04, $38, $3A, $3A, $3A, $3B, $FF, $FA, $FF, $FF
    db $2F, $4E, $0A, $0A, $FF, $FF, $F8, $04, $FB, $FF
    db $3A, $3B, $0A, $D4, $F7, $F8, $E8, $04, $FB, $FA
    db $F7, $FA, $FF, $F6, $04, $04, $F5, $F9, $F8, $25
    db $25, $26, $FB, $FC, $E8, $F5, $FA, $F8, $25, $2A
    db $2A, $28, $FB, $FF, $F9, $F8, $04, $25, $2A, $29

RoomGBCOverlay37::
    db $F5, $FF, $FF, $FA, $FF, $FA, $37, $F9, $FC, $37
    db $FF, $FF, $F8, $55, $61, $56, $37, $F7, $FA, $2E
    db $FF, $F8, $62, $40, $60, $42, $2E, $3C, $09, $39
    db $FC, $04, $62, $5B, $E2, $5B, $39, $37, $F6, $04
    db $FA, $F9, $F6, $04, $0C, $04, $F5, $37, $FA, $F6
    db $26, $F7, $FF, $F9, $F9, $F9, $FA, $2E, $2F, $2F
    db $28, $04, $F7, $FA, $FA, $F8, $04, $39, $3A, $3A
    db $26, $25, $26, $25, $26, $25, $26, $25, $26, $25

RoomGBCOverlay38::
    db $38, $FB, $FF, $FF, $38, $3A, $3A, $3A, $3E, $3A
    db $4E, $FF, $FA, $F8, $38, $3A, $46, $F6, $39, $3A
    db $3B, $F8, $04, $3D, $4E, $0E, $37, $FF, $0A, $0A
    db $04, $04, $F5, $38, $3F, $0E, $37, $FA, $FF, $FF
    db $F5, $F9, $FA, $38, $3B, $0E, $33, $3C, $FB, $FA
    db $2F, $2F, $2F, $4E, $0E, $0E, $0E, $33, $2F, $2F
    db $3A, $3A, $3A, $3F, $0E, $0E, $0E, $0E, $0E, $0E
    db $26, $04, $47, $3F, $0E, $2B, $2C, $2C, $2C, $2C

RoomGBCOverlay39::
    db $3A, $E0, $3F, $0A, $33, $2F, $34, $0A, $0A, $33
    db $3A, $E0, $3B, $FF, $0A, $0A, $25, $26, $FB, $0A
    db $0A, $0A, $0A, $0A, $FA, $F8, $27, $28, $FB, $FF
    db $FC, $04, $F7, $F8, $04, $04, $F5, $F9, $FF, $FF
    db $FF, $F6, $04, $04, $F5, $F9, $FF, $FF, $FF, $FA
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlay3A::
    db $2F, $34, $0A, $0A, $33, $2F, $34, $0A, $0A, $33
    db $0A, $0A, $FF, $FF, $0A, $0A, $0A, $04, $F7, $0A
    db $FF, $FF, $FF, $FF, $FF, $FA, $F8, $04, $04, $F7
    db $FF, $FF, $FF, $FA, $F8, $3D, $2F, $2F, $2F, $2F
    db $FA, $FA, $F8, $04, $F5, $38, $0E, $0E, $0E, $0E
    db $2F, $2F, $2F, $2F, $2F, $34, $0E, $0E, $2B, $2C
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $25
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $31, $27

RoomGBCOverlay3B::
    db $2F, $34, $33, $2F, $34, $33, $2F, $34, $37, $E8
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $33, $2F
    db $FA, $FF, $FF, $FA, $FA, $0A, $0A, $0A, $0A, $0A
    db $2F, $2F, $2F, $48, $E0, $49, $3C, $0A, $0A, $FF
    db $0E, $0E, $0E, $0E, $0E, $0E, $33, $2F, $3C, $F7
    db $2C, $E0, $2C, $2D, $0E, $0E, $0E, $0E, $37, $04
    db $26, $04, $F7, $38, $0E, $0E, $0E, $0E, $2E, $3C
    db $28, $04, $04, $32, $2C, $2C, $2D, $0E, $3E, $37

RoomGBCOverlay3C::
    db $38, $37, $E8, $38, $F9, $37, $E8, $38, $F9, $37
    db $34, $33, $2F, $34, $0A, $33, $2F, $34, $0A, $33
    db $0A, $0A, $0A, $0A, $FA, $0A, $0A, $0A, $FF, $0A
    db $FF, $FA, $FF, $F8, $04, $F7, $FA, $FF, $FA, $FA
    db $F8, $3D, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $04, $38, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $3D, $4E, $E9, $E9, $E9, $49, $3C, $0E, $0E, $0E
    db $38, $3F, $E9, $E9, $E9, $3A, $2E, $2F, $2F, $2F

RoomGBCOverlay3D::
    db $E8, $38, $FF, $F8, $37, $E8, $38, $04, $04, $04
    db $2F, $34, $FC, $04, $33, $2F, $34, $F9, $F6, $04
    db $0A, $0A, $FA, $F9, $0A, $0A, $0A, $FF, $FF, $F9
    db $FF, $F8, $04, $FB, $FF, $FA, $FF, $FA, $FA, $FF
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $3D, $48, $E9, $E9, $49, $2F, $2F, $2F, $2F
    db $2F, $4E, $3A, $E9, $E9, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay3E::
    db $F5, $FF, $F8, $38, $0E, $2B, $31, $04, $04, $25
    db $FB, $F8, $04, $38, $0E, $37, $04, $04, $04, $27
    db $FC, $3D, $E0, $34, $0E, $37, $04, $04, $04, $25
    db $F8, $38, $0E, $0E, $0E, $37, $04, $04, $04, $27
    db $2F, $34, $CA, $CA, $CA, $33, $2F, $2F, $2F, $2F
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay3F::
    db $2A, $B6, $B7, $66, $FF, $FC, $38, $0E, $0E, $38
    db $28, $5B, $E2, $5B, $0A, $F8, $38, $0E, $0E, $38
    db $26, $0A, $0A, $D4, $F8, $3D, $34, $0E, $0E, $38
    db $28, $04, $04, $04, $04, $38, $0E, $0E, $0E, $38
    db $2F, $2F, $2F, $2F, $E0, $34, $0E, $0E, $0E, $38
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $38
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $4E
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3F

RoomGBCOverlay40::
    db $37, $82, $83, $8E, $04, $04, $F7, $FC, $8F, $82
    db $37, $29, $2A, $87, $08, $04, $04, $F7, $8D, $84
    db $37, $82, $83, $87, $F6, $04, $04, $08, $44, $04
    db $37, $90, $90, $8A, $85, $8E, $04, $8F, $85, $85
    db $37, $88, $84, $84, $84, $8C, $E8, $8D, $84, $84
    db $37, $87, $08, $5C, $5C, $5C, $04, $04, $04, $F7
    db $37, $87, $04, $04, $04, $04, $04, $04, $04, $04
    db $37, $87, $44, $04, $04, $0A, $8F, $85, $85, $85

RoomGBCOverlay41::
    db $83, $82, $83, $82, $83, $82, $83, $82, $83, $82
    db $84, $84, $84, $84, $84, $84, $89, $88, $84, $84
    db $04, $04, $04, $04, $04, $04, $86, $87, $08, $04
    db $85, $85, $8E, $5C, $A0, $5C, $8D, $8C, $44, $04
    db $84, $89, $87, $04, $5C, $04, $04, $E8, $04, $04
    db $F9, $86, $87, $04, $04, $04, $04, $E8, $8F, $85
    db $F7, $86, $87, $04, $04, $08, $0A, $8F, $29, $2A
    db $85, $8B, $87, $44, $04, $04, $0A, $86, $82, $29

RoomGBCOverlay42::
    db $83, $82, $83, $82, $83, $82, $83, $82, $83, $82
    db $84, $89, $88, $92, $89, $90, $88, $84, $84, $84
    db $0A, $86, $87, $E4, $86, $90, $87, $04, $04, $04
    db $0A, $8D, $8C, $E3, $8D, $84, $8C, $04, $04, $04
    db $F7, $0A, $20, $04, $20, $04, $04, $0A, $8F, $85
    db $8E, $08, $04, $20, $04, $04, $44, $0A, $86, $29
    db $8A, $8E, $04, $04, $44, $0A, $8F, $85, $8B, $82
    db $2A, $87, $04, $04, $04, $0A, $86, $29, $2A, $29

RoomGBCOverlay43::
    db $83, $82, $83, $82, $83, $82, $83, $82, $29, $2A
    db $84, $84, $84, $84, $84, $84, $84, $89, $82, $29
    db $04, $04, $04, $04, $F7, $FA, $F6, $8D, $29, $2A
    db $04, $08, $44, $04, $04, $04, $F7, $F8, $27, $28
    db $85, $8E, $04, $04, $04, $04, $44, $04, $08, $04
    db $2A, $87, $0A, $0A, $0A, $0A, $0A, $0A, $04, $04
    db $83, $8A, $85, $85, $85, $85, $85, $8E, $0A, $08
    db $2A, $29, $2A, $29, $2A, $29, $2A, $29, $26, $25

RoomGBCOverlay44::
    db $29, $2A, $29, $26, $04, $04, $25, $2A, $29, $2A
    db $2A, $29, $2A, $28, $04, $04, $27, $28, $27, $28
    db $29, $2A, $28, $E8, $E8, $E8, $20, $F5, $F9, $F9
    db $27, $28, $E8, $E8, $0A, $E8, $E8, $44, $FF, $FF
    db $04, $04, $E8, $0A, $0A, $0A, $E8, $FB, $FF, $FA
    db $0B, $0B, $E8, $E8, $0A, $E8, $E8, $FB, $44, $25
    db $F7, $0B, $0B, $E8, $E8, $E8, $F5, $FF, $F8, $27
    db $26, $FB, $0B, $F6, $04, $F5, $FF, $FC, $04, $25

RoomGBCOverlay45::
    db $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A
    db $27, $28, $27, $29, $2A, $28, $27, $28, $27, $28
    db $44, $F6, $D4, $27, $28, $F5, $F9, $52, $52, $52
    db $FF, $F8, $04, $20, $F5, $FA, $FF, $5B, $E2, $5B
    db $F8, $04, $3D, $2F, $E0, $3C, $0A, $0A, $0A, $0A
    db $26, $20, $38, $1B, $1B, $37, $0A, $0A, $0A, $25
    db $28, $0A, $32, $2C, $2C, $31, $0A, $FF, $FC, $27
    db $26, $FB, $FF, $0A, $0A, $0A, $FF, $FF, $44, $25

RoomGBCOverlay46::
    db $29, $26, $FB, $FF, $F8, $04, $04, $27, $28, $27
    db $27, $28, $0A, $FC, $B6, $B7, $04, $04, $B6, $B7
    db $25, $26, $0A, $0A, $CD, $CE, $04, $04, $CD, $CE
    db $27, $28, $0A, $09, $09, $09, $B6, $B7, $03, $03
    db $0A, $20, $09, $09, $04, $04, $CD, $CE, $03, $B6
    db $26, $09, $04, $B6, $B7, $04, $03, $03, $04, $CD
    db $28, $04, $04, $CD, $CE, $04, $04, $09, $09, $04
    db $26, $03, $03, $04, $04, $B6, $B7, $04, $04, $B6

RoomGBCOverlay47::
    db $28, $27, $28, $27, $28, $27, $29, $2A, $29, $2A
    db $B6, $B7, $04, $04, $04, $09, $27, $29, $2A, $28
    db $CD, $CE, $E8, $09, $04, $B6, $B7, $27, $29, $26
    db $03, $03, $03, $03, $04, $CD, $CE, $04, $27, $28
    db $B7, $04, $04, $04, $09, $09, $04, $03, $25, $26
    db $CE, $04, $B6, $B7, $04, $E8, $03, $03, $27, $28
    db $04, $04, $CD, $CE, $03, $03, $04, $09, $25, $26
    db $B7, $04, $03, $03, $09, $09, $04, $03, $27, $28

RoomGBCOverlay48::
    db $28, $04, $38, $3B, $0E, $9B, $99, $99, $99, $99
    db $3D, $2F, $4E, $0E, $0E, $9A, $96, $96, $96, $96
    db $38, $3A, $3B, $0E, $0E, $9A, $93, $93, $93, $93
    db $38, $0E, $0E, $0E, $0E, $9A, $04, $F5, $F9, $FF
    db $38, $0E, $9B, $99, $99, $9E, $04, $FB, $FF, $FA
    db $38, $0E, $9A, $96, $96, $98, $F5, $FF, $F8, $9B
    db $38, $0E, $9A, $93, $93, $95, $FB, $F8, $9B, $9A
    db $38, $0E, $9A, $25, $26, $F5, $FC, $04, $9A, $9A

RoomGBCOverlay49::
    db $99, $99, $99, $99, $99, $99, $99, $99, $99, $99
    db $96, $96, $96, $96, $96, $96, $96, $96, $96, $96
    db $93, $93, $93, $93, $93, $93, $93, $93, $93, $93
    db $F9, $FF, $F8, $04, $F7, $F8, $04, $F7, $FF, $44
    db $FF, $F8, $25, $26, $25, $26, $C6, $04, $F7, $FA
    db $99, $99, $99, $99, $99, $99, $99, $99, $99, $99
    db $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C
    db $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C

RoomGBCOverlay4A::
    db $99, $99, $99, $99, $99, $99, $9C, $25, $26, $25
    db $96, $96, $96, $96, $96, $96, $9A, $27, $28, $27
    db $93, $93, $93, $93, $93, $93, $9A, $44, $D3, $44
    db $F9, $FF, $F6, $04, $04, $F7, $9A, $44, $44, $44
    db $FF, $FF, $FF, $F9, $F6, $04, $9D, $99, $99, $9C
    db $9C, $FF, $FF, $FF, $FF, $F6, $97, $96, $96, $9A
    db $9A, $9C, $FF, $FF, $FF, $FC, $94, $93, $93, $9A
    db $9A, $9A, $FF, $FF, $FF, $FF, $F9, $FF, $F6, $9A

RoomGBCOverlay4B::
    db $26, $04, $04, $25, $45, $26, $38, $0E, $39, $37
    db $28, $04, $04, $27, $E1, $28, $38, $0E, $0E, $37
    db $04, $04, $04, $04, $04, $F5, $38, $0E, $0E, $37
    db $04, $04, $04, $04, $04, $FB, $38, $0E, $0E, $37
    db $25, $26, $04, $04, $04, $FB, $38, $0E, $0E, $37
    db $27, $28, $04, $04, $F5, $FF, $38, $0E, $0E, $37
    db $25, $26, $04, $04, $FB, $FC, $38, $0E, $0E, $37
    db $27, $28, $04, $F5, $FF, $FC, $38, $0E, $0E, $37

RoomGBCOverlay4C::
    db $38, $3F, $E9, $E9, $E9, $3A, $3E, $3A, $3A, $3A
    db $38, $3B, $E9, $E9, $E9, $3A, $3E, $3A, $3A, $3A
    db $38, $ED, $ED, $EB, $ED, $ED, $39, $3A, $3A, $3A
    db $38, $ED, $ED, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $38, $ED, $EB, $EB, $EB, $EB, $ED, $C8, $EB, $EB
    db $38, $ED, $ED, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $38, $E9, $E9, $2B, $2C, $2C, $2D, $E9, $E9, $2B
    db $38, $E9, $E9, $2E, $2F, $2F, $4E, $E9, $E9, $2E

RoomGBCOverlay4D::
    db $3A, $3F, $3A, $E9, $E9, $3A, $3A, $3A, $3A, $3A
    db $3A, $3F, $3A, $E9, $E9, $3A, $3A, $3A, $3A, $3A
    db $3A, $3B, $EB, $EB, $EB, $ED, $B6, $B7, $B6, $B7
    db $EB, $ED, $C8, $EB, $EB, $ED, $CD, $21, $4F, $CE
    db $EB, $EB, $EB, $EB, $EB, $EB, $ED, $CD, $CE, $EB
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $ED, $EB
    db $2C, $2D, $B6, $B7, $B6, $B7, $B6, $B7, $EB, $EB
    db $2F, $4E, $CD, $CE, $CD, $CE, $CD, $CE, $B6, $B7

RoomGBCOverlay4E::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $B6, $B7, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $CD, $CE, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $EB, $EB, $EB, $EB, $ED, $B6, $B7, $B6, $B7, $B6
    db $EB, $EB, $EB, $EB, $ED, $CD, $CE, $CD, $CE, $CD
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $B6, $B7, $B6, $B7, $C8, $B6, $B7, $B6, $B7, $B6

RoomGBCOverlay4F::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3F
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $ED, $ED, $38
    db $EB, $EB, $EB, $EB, $EB, $ED, $C8, $EB, $ED, $38
    db $B7, $B6, $B7, $ED, $ED, $EE, $EE, $C8, $ED, $38
    db $CE, $CD, $CE, $ED, $ED, $C8, $EC, $EE, $EE, $38
    db $EB, $ED, $ED, $ED, $ED, $ED, $C8, $ED, $ED, $38
    db $B7, $ED, $ED, $ED, $ED, $ED, $ED, $ED, $ED, $38

RoomGBCOverlay50::
    db $37, $87, $04, $04, $04, $0A, $86, $88, $92, $89
    db $37, $87, $08, $04, $04, $0A, $86, $87, $E4, $86
    db $37, $87, $04, $5C, $04, $0A, $8D, $8C, $E3, $86
    db $37, $87, $04, $5C, $44, $F7, $0A, $0A, $0A, $86
    db $37, $87, $08, $5C, $04, $44, $F7, $F8, $04, $86
    db $37, $8A, $85, $8E, $04, $04, $04, $04, $44, $86
    db $37, $29, $2A, $87, $08, $04, $04, $04, $04, $86
    db $37, $82, $83, $8A, $85, $85, $85, $85, $85, $8B

RoomGBCOverlay51::
    db $90, $88, $8C, $04, $04, $04, $0A, $86, $90, $82
    db $88, $8C, $04, $04, $04, $04, $0A, $8D, $89, $29
    db $87, $08, $04, $5C, $5C, $04, $04, $44, $86, $82
    db $87, $04, $5C, $25, $26, $5C, $44, $0A, $86, $29
    db $87, $04, $5C, $27, $28, $5C, $04, $0A, $86, $82
    db $87, $04, $04, $5C, $5C, $04, $0A, $0A, $86, $29
    db $87, $04, $04, $44, $08, $04, $0A, $8F, $8B, $82
    db $8A, $85, $8E, $04, $04, $0A, $0A, $86, $90, $29

RoomGBCOverlay52::
    db $83, $87, $04, $04, $04, $0A, $86, $82, $83, $82
    db $2A, $87, $04, $04, $04, $0A, $8D, $84, $89, $29
    db $83, $87, $04, $04, $08, $04, $0A, $20, $86, $82
    db $2A, $87, $04, $44, $44, $44, $04, $04, $86, $29
    db $83, $87, $04, $44, $44, $44, $04, $04, $86, $82
    db $2A, $87, $0A, $44, $44, $44, $08, $04, $8D, $84
    db $83, $87, $0A, $0A, $04, $04, $04, $04, $04, $08
    db $2A, $87, $08, $0A, $04, $8F, $85, $85, $85, $85

RoomGBCOverlay53::
    db $83, $82, $83, $82, $83, $82, $83, $82, $83, $82
    db $2A, $88, $84, $84, $84, $84, $84, $84, $89, $29
    db $83, $87, $0A, $3D, $2F, $2F, $3C, $0A, $86, $82
    db $2A, $87, $0A, $38, $0E, $0E, $37, $0A, $86, $29
    db $83, $87, $0A, $32, $2C, $2C, $31, $0A, $86, $82
    db $84, $8C, $0A, $0A, $0A, $0A, $0A, $0A, $86, $29
    db $F7, $FD, $FA, $0A, $0A, $0A, $0A, $F8, $86, $82
    db $85, $85, $8E, $0A, $0A, $0A, $F8, $8F, $8B, $29

RoomGBCOverlay54::
    db $28, $F7, $0B, $FA, $F9, $FF, $FA, $F8, $04, $27
    db $26, $04, $0B, $0B, $0B, $0B, $0B, $0B, $04, $25
    db $28, $3D, $2F, $2F, $2F, $3C, $04, $0B, $04, $27
    db $26, $38, $0E, $0E, $0E, $37, $04, $0B, $04, $25
    db $28, $38, $0E, $0E, $0E, $37, $04, $0B, $04, $27
    db $26, $32, $2D, $0E, $0E, $37, $04, $0B, $04, $25
    db $29, $26, $32, $2C, $2C, $31, $04, $0B, $04, $27
    db $2A, $29, $26, $25, $26, $04, $04, $0B, $04, $25

RoomGBCOverlay55::
    db $28, $F7, $44, $FA, $F8, $04, $F7, $FA, $F8, $27
    db $26, $25, $26, $04, $09, $09, $04, $04, $04, $25
    db $28, $27, $28, $04, $20, $04, $25, $26, $04, $27
    db $26, $04, $25, $26, $04, $20, $27, $28, $25, $26
    db $28, $09, $27, $28, $09, $03, $03, $04, $27, $28
    db $26, $04, $09, $09, $03, $04, $04, $04, $04, $09
    db $29, $26, $E8, $03, $03, $03, $04, $09, $09, $04
    db $2A, $29, $26, $25, $26, $25, $26, $F5, $F6, $25

RoomGBCOverlay56::
    db $28, $09, $03, $03, $04, $CD, $CE, $04, $09, $CD
    db $26, $04, $04, $04, $F5, $F6, $B6, $B7, $04, $09
    db $28, $04, $B6, $B7, $F7, $F8, $CD, $CE, $F5, $F6
    db $B6, $B7, $CD, $CE, $B6, $B7, $E8, $04, $F7, $FF
    db $CD, $CE, $09, $E8, $CD, $CE, $03, $03, $03, $F7
    db $09, $09, $03, $03, $04, $04, $09, $09, $03, $B6
    db $03, $03, $04, $09, $09, $04, $04, $04, $04, $CD
    db $26, $25, $26, $25, $26, $25, $26, $25, $26, $25

RoomGBCOverlay57::
    db $CE, $04, $04, $04, $03, $03, $03, $04, $25, $26
    db $09, $09, $04, $03, $09, $04, $03, $03, $27, $28
    db $04, $03, $B6, $B7, $04, $03, $03, $09, $25, $26
    db $F6, $04, $CD, $CE, $03, $03, $04, $04, $27, $28
    db $F8, $04, $09, $09, $03, $B6, $B7, $04, $25, $26
    db $B7, $09, $03, $03, $09, $CD, $CE, $09, $27, $28
    db $CE, $03, $09, $03, $F6, $04, $03, $03, $25, $26
    db $26, $25, $26, $FB, $FC, $25, $26, $25, $2A, $28

RoomGBCOverlay58::
    db $38, $0E, $9A, $27, $28, $FB, $FF, $F6, $9A, $9D
    db $38, $0E, $9A, $25, $26, $FB, $FF, $FF, $9A, $97
    db $38, $0E, $9A, $27, $28, $FB, $FF, $FF, $9A, $94
    db $38, $0E, $9D, $9C, $F5, $44, $FF, $FC, $9A, $0D
    db $38, $0E, $97, $9A, $FB, $FF, $FF, $F8, $9A, $0D
    db $38, $0E, $94, $9A, $FB, $FF, $FC, $20, $9A, $0D
    db $38, $0E, $0E, $9A, $44, $FF, $F8, $20, $9A, $0D
    db $38, $0E, $0E, $9A, $FF, $FC, $25, $26, $9D, $99

RoomGBCOverlay59::
    db $99, $99, $99, $9C, $0C, $0C, $0C, $9B, $99, $99
    db $A4, $A5, $A6, $9D, $99, $99, $99, $9E, $96, $96
    db $A7, $E3, $A8, $B7, $A4, $A5, $A6, $B7, $93, $93
    db $0D, $0D, $0D, $A2, $A7, $E3, $A8, $A2, $0D, $0D
    db $0D, $0D, $0D, $B6, $0D, $0D, $0D, $B6, $0D, $0D
    db $0D, $0D, $0D, $0D, $0D, $0D, $0D, $0D, $0D, $0D
    db $0D, $0D, $0D, $0D, $0D, $0D, $0D, $0D, $0D, $0D
    db $99, $99, $99, $9C, $0D, $0D, $0D, $9B, $99, $99

RoomGBCOverlay5A::
    db $9E, $9A, $FB, $FF, $FF, $FA, $FF, $FF, $FC, $9A
    db $98, $9A, $FB, $FF, $F8, $E8, $F7, $FF, $FF, $9A
    db $95, $9A, $F7, $F8, $04, $04, $04, $F7, $F8, $9A
    db $0D, $9A, $E8, $04, $04, $04, $04, $04, $E8, $9A
    db $0D, $9A, $F6, $04, $04, $E8, $04, $04, $F5, $9A
    db $0D, $9A, $FC, $04, $04, $04, $04, $04, $FB, $9A
    db $0D, $9A, $F8, $E8, $F5, $F9, $F6, $E8, $FB, $9A
    db $99, $9E, $25, $26, $F7, $FF, $FF, $9B, $99, $9E

RoomGBCOverlay5B::
    db $25, $26, $04, $FB, $FF, $F8, $38, $0E, $0E, $37
    db $27, $28, $F5, $44, $F8, $04, $38, $0E, $0E, $37
    db $25, $26, $FB, $FC, $3D, $2F, $34, $0E, $0E, $37
    db $27, $28, $FB, $FC, $38, $0E, $0E, $0E, $0E, $37
    db $25, $26, $FB, $FC, $38, $0E, $0E, $0E, $0E, $37
    db $27, $28, $FB, $F8, $38, $0E, $0E, $0E, $0E, $37
    db $25, $26, $FE, $04, $32, $2C, $2D, $0E, $0E, $37
    db $27, $28, $F8, $04, $25, $26, $38, $0E, $0E, $37

RoomGBCOverlay5C::
    db $38, $E9, $E9, $3E, $3A, $3A, $3F, $E9, $E9, $39
    db $38, $ED, $ED, $37, $04, $04, $38, $ED, $EB, $EB
    db $38, $ED, $ED, $37, $A0, $04, $38, $ED, $EB, $EB
    db $38, $ED, $ED, $37, $04, $04, $38, $ED, $EB, $EB
    db $38, $ED, $ED, $33, $48, $E0, $34, $C8, $EB, $EB
    db $38, $ED, $ED, $EB, $EB, $EB, $C8, $EB, $EB, $EB
    db $38, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $B6, $B7
    db $38, $B6, $B7, $B6, $B7, $B6, $B7, $B6, $4F, $21

RoomGBCOverlay5D::
    db $3A, $3B, $2B, $2C, $2C, $2C, $2C, $2D, $CD, $CE
    db $EB, $ED, $37, $04, $6F, $04, $A0, $38, $EB, $EB
    db $EB, $ED, $33, $3C, $04, $04, $04, $38, $EB, $EB
    db $EB, $EB, $ED, $33, $48, $E0, $49, $34, $EB, $EB
    db $EB, $EB, $EB, $ED, $EB, $EB, $C8, $EB, $EB, $EB
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $B6, $B7, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $4F, $21, $B7, $B6, $B7, $B6, $B7, $B6, $B7, $B6

RoomGBCOverlay5E::
    db $CD, $CE, $CD, $CE, $C8, $CD, $CE, $CD, $CE, $CD
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EC, $C8, $EB
    db $EB, $EC, $EB, $EB, $EB, $EB, $EC, $C8, $EB, $EB
    db $EC, $2B, $2C, $2C, $2D, $EB, $EB, $EB, $EB, $EB
    db $EC, $37, $04, $04, $38, $EB, $EB, $EC, $C8, $EB
    db $EC, $37, $04, $04, $38, $EC, $C8, $EB, $EB, $EB
    db $B7, $33, $2F, $2F, $34, $B6, $B7, $B6, $B7, $B6

RoomGBCOverlay5F::
    db $CE, $ED, $ED, $EE, $EE, $EE, $EB, $EB, $ED, $38
    db $EB, $ED, $ED, $B6, $B7, $B6, $B7, $C8, $ED, $38
    db $EB, $ED, $ED, $CD, $21, $4F, $CE, $C8, $ED, $38
    db $EB, $EB, $EB, $ED, $CD, $CE, $ED, $EE, $EE, $38
    db $EB, $ED, $ED, $EE, $B6, $B7, $EB, $EB, $ED, $38
    db $EB, $ED, $ED, $B6, $4F, $21, $B7, $C8, $ED, $38
    db $EB, $ED, $ED, $CD, $21, $4F, $CE, $C8, $ED, $38
    db $B7, $ED, $ED, $ED, $CD, $CE, $ED, $ED, $ED, $38

RoomGBCOverlay60::
    db $37, $29, $2A, $90, $88, $84, $84, $84, $84, $84
    db $37, $82, $29, $2A, $87, $08, $04, $04, $04, $04
    db $37, $29, $2A, $83, $87, $44, $04, $04, $04, $44
    db $37, $82, $29, $2A, $87, $04, $08, $04, $8F, $85
    db $37, $90, $82, $83, $87, $04, $04, $04, $86, $29
    db $37, $29, $2A, $88, $8C, $04, $44, $04, $86, $82
    db $37, $82, $83, $87, $04, $08, $04, $04, $8D, $84
    db $37, $29, $2A, $87, $F6, $04, $04, $04, $04, $04

RoomGBCOverlay61::
    db $84, $84, $8C, $04, $04, $04, $04, $86, $29, $2A
    db $F7, $0A, $04, $08, $04, $04, $04, $86, $82, $29
    db $04, $0A, $0A, $04, $04, $04, $04, $86, $29, $2A
    db $85, $85, $85, $8E, $04, $04, $5C, $86, $82, $83
    db $2A, $29, $2A, $87, $44, $04, $04, $8D, $84, $84
    db $83, $82, $83, $87, $04, $04, $44, $04, $04, $04
    db $84, $84, $84, $8C, $04, $08, $04, $8F, $85, $85
    db $04, $04, $04, $04, $04, $04, $04, $86, $90, $29

RoomGBCOverlay62::
    db $83, $87, $04, $04, $F5, $86, $90, $90, $90, $90
    db $2A, $87, $F6, $04, $FB, $86, $88, $92, $89, $90
    db $83, $87, $FC, $04, $F7, $86, $87, $E4, $86, $90
    db $90, $87, $F8, $04, $04, $8D, $8C, $E3, $8D, $89
    db $84, $8C, $04, $04, $04, $D4, $04, $04, $04, $86
    db $04, $04, $44, $04, $04, $04, $04, $04, $08, $86
    db $85, $8E, $04, $04, $04, $08, $08, $04, $04, $86
    db $2A, $87, $08, $8F, $85, $85, $85, $85, $85, $8B

RoomGBCOverlay63::
    db $90, $88, $8C, $04, $04, $04, $0A, $86, $90, $82
    db $88, $8C, $04, $04, $04, $04, $0A, $8D, $89, $29
    db $87, $08, $04, $5C, $5C, $04, $04, $44, $86, $82
    db $87, $04, $5C, $25, $26, $5C, $44, $0A, $86, $29
    db $87, $04, $5C, $27, $28, $5C, $04, $0A, $86, $82
    db $87, $04, $04, $5C, $5C, $04, $0A, $0A, $86, $29
    db $87, $04, $04, $44, $08, $04, $0A, $8F, $8B, $82
    db $8A, $85, $8E, $04, $04, $0A, $0A, $86, $90, $29

RoomGBCOverlay64::
    db $29, $2A, $29, $2A, $28, $04, $04, $0B, $F6, $27
    db $2A, $29, $2A, $28, $04, $04, $F5, $0B, $0B, $F9
    db $29, $2A, $29, $26, $04, $04, $FB, $08, $0B, $FF
    db $2A, $28, $27, $29, $26, $04, $F7, $FF, $0B, $0B
    db $28, $44, $44, $27, $29, $26, $04, $F7, $FA, $F8
    db $26, $44, $C4, $44, $27, $29, $26, $04, $04, $04
    db $28, $44, $44, $44, $F8, $27, $28, $20, $04, $04
    db $26, $F7, $FA, $F8, $04, $3D, $48, $E0, $49, $2F

RoomGBCOverlay65::
    db $28, $27, $28, $27, $28, $27, $28, $FB, $FC, $27
    db $F9, $F6, $04, $B6, $C8, $B7, $F5, $FF, $08, $25
    db $08, $F8, $04, $CD, $E1, $CE, $F7, $F8, $25, $2A
    db $0B, $0B, $B6, $B7, $0B, $B6, $B7, $04, $27, $29
    db $04, $0B, $CD, $CE, $0B, $CD, $CE, $20, $D4, $27
    db $04, $0B, $0B, $0B, $0B, $04, $E8, $04, $F5, $F9
    db $04, $04, $04, $04, $04, $04, $E8, $F5, $FF, $FA
    db $2F, $2F, $2F, $2F, $2F, $2F, $3C, $0A, $FC, $25

RoomGBCOverlay66::
    db $28, $27, $28, $27, $28, $27, $28, $27, $28, $27
    db $26, $51, $51, $51, $51, $51, $51, $51, $51, $51
    db $28, $51, $09, $09, $09, $09, $09, $0A, $0A, $B6
    db $26, $51, $0A, $C4, $03, $C4, $0A, $C4, $03, $CD
    db $28, $51, $0A, $0A, $0A, $09, $03, $0A, $0A, $B6
    db $04, $04, $0A, $C4, $03, $C4, $0A, $C4, $09, $CD
    db $04, $04, $0A, $0A, $0A, $03, $09, $09, $0A, $B6
    db $26, $51, $09, $09, $0A, $0A, $0A, $03, $03, $CD

RoomGBCOverlay67::
    db $28, $27, $28, $08, $FC, $27, $28, $27, $29, $26
    db $51, $51, $51, $FB, $FC, $51, $51, $51, $27, $28
    db $B7, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $51
    db $CE, $03, $03, $C4, $0A, $C4, $0A, $C4, $0A, $51
    db $B7, $0A, $03, $03, $09, $0A, $0A, $03, $03, $51
    db $CE, $0A, $03, $C4, $0A, $C4, $0A, $C4, $0A, $51
    db $B7, $0A, $09, $09, $0A, $0A, $0A, $0A, $0A, $51
    db $CE, $0A, $0A, $0A, $0A, $03, $03, $0A, $0A, $51

RoomGBCOverlay68::
    db $38, $0E, $0E, $9A, $FB, $FC, $27, $28, $B7, $96
    db $38, $0E, $0E, $9A, $FB, $F8, $25, $26, $A2, $93
    db $38, $0E, $0E, $9A, $FE, $04, $27, $28, $B6, $F5
    db $38, $0E, $0E, $9A, $FC, $04, $04, $F7, $F9, $FF
    db $38, $0E, $0E, $9A, $FF, $F6, $04, $04, $F7, $FA
    db $38, $0E, $0E, $9A, $FF, $FF, $F9, $F6, $04, $04
    db $38, $0E, $9B, $9E, $F7, $FF, $FF, $FF, $F9, $F9
    db $38, $0E, $9A, $9B, $99, $99, $99, $99, $99, $99

RoomGBCOverlay69::
    db $96, $96, $96, $9A, $0D, $0D, $0D, $9A, $96, $96
    db $93, $93, $93, $9D, $99, $99, $99, $9E, $93, $93
    db $F9, $F6, $5C, $B7, $A4, $A5, $A6, $B7, $5C, $F7
    db $FF, $F8, $5C, $A2, $A7, $E3, $A8, $A2, $5C, $04
    db $F8, $04, $5C, $B6, $5C, $0C, $5C, $B6, $5C, $F5
    db $04, $F5, $F6, $04, $5C, $0C, $5C, $04, $F5, $FF
    db $F9, $FF, $FA, $F6, $5C, $0C, $5C, $F5, $FF, $FF
    db $99, $99, $9B, $9C, $F6, $0C, $F5, $9B, $9C, $99

RoomGBCOverlay6A::
    db $96, $B7, $27, $28, $04, $FB, $FF, $9A, $96, $98
    db $93, $A2, $25, $26, $04, $FB, $FC, $9A, $93, $95
    db $F8, $B6, $27, $28, $F5, $FF, $FF, $9A, $04, $04
    db $04, $04, $04, $04, $FB, $FF, $F8, $9A, $04, $04
    db $F6, $04, $F5, $F9, $FF, $FC, $04, $9A, $E0, $49
    db $FF, $F9, $FF, $FF, $FF, $F8, $04, $9A, $0E, $0E
    db $FF, $FF, $FF, $FF, $F8, $04, $F5, $9D, $9C, $0E
    db $99, $99, $99, $99, $99, $99, $99, $9C, $9A, $0E

RoomGBCOverlay6B::
    db $25, $26, $04, $0D, $27, $28, $38, $0E, $0E, $37
    db $27, $28, $04, $0D, $04, $04, $38, $0E, $0E, $37
    db $04, $04, $04, $0D, $04, $04, $32, $2D, $0E, $37
    db $04, $04, $04, $0D, $0D, $04, $5C, $38, $0E, $37
    db $2F, $3C, $04, $04, $0D, $04, $5C, $38, $0E, $37
    db $0E, $37, $5C, $04, $0D, $25, $26, $38, $0E, $37
    db $0E, $37, $5C, $5C, $0D, $27, $28, $38, $0E, $37
    db $0E, $37, $25, $26, $04, $25, $26, $38, $0E, $37

RoomGBCOverlay6C::
    db $38, $CD, $CE, $CD, $CE, $CD, $CE, $CD, $CE, $CD
    db $38, $ED, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE
    db $38, $ED, $2B, $2C, $2C, $2D, $EC, $EC, $EE, $EE
    db $38, $ED, $37, $A0, $C6, $38, $EC, $EC, $EE, $EE
    db $38, $ED, $37, $04, $04, $38, $ED, $ED, $B6, $B7
    db $38, $ED, $33, $2F, $2F, $34, $ED, $ED, $CD, $CE
    db $38, $ED, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $38, $ED, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB

RoomGBCOverlay6D::
    db $CE, $CD, $CE, $CD, $CE, $CD, $CE, $CD, $CE, $CD
    db $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE
    db $EE, $EE, $EE, $EE, $EE, $B6, $B7, $B6, $B7, $EC
    db $EE, $EE, $EE, $EE, $B6, $4F, $CE, $CD, $CE, $C8
    db $B6, $B7, $ED, $EE, $CD, $CE, $ED, $EE, $EE, $EE
    db $CD, $CE, $ED, $C8, $C8, $EB, $ED, $EE, $EE, $EE
    db $EB, $EB, $EB, $EB, $ED, $C8, $ED, $EE, $EE, $EE
    db $EB, $EB, $EB, $EB, $ED, $C8, $ED, $B6, $B7, $B6

RoomGBCOverlay6E::
    db $CE, $B6, $B7, $B6, $B7, $CD, $CE, $CD, $CE, $CD
    db $EE, $CD, $CE, $CD, $CE, $ED, $EE, $EE, $EE, $EE
    db $EE, $EE, $EE, $EE, $EE, $ED, $C8, $C8, $ED, $EE
    db $C8, $C8, $C8, $ED, $EC, $ED, $EE, $EE, $EE, $C8
    db $EE, $EB, $EB, $EB, $EB, $ED, $ED, $EE, $EE, $EE
    db $EE, $EC, $C8, $C8, $C8, $ED, $ED, $EE, $EE, $EE
    db $EE, $EC, $EE, $EE, $EE, $EE, $ED, $C8, $C8, $EC
    db $B7, $B6, $B7, $B6, $B7, $B6, $B7, $B6, $B7, $B6

RoomGBCOverlay6F::
    db $CE, $ED, $ED, $ED, $C8, $C8, $ED, $EE, $ED, $38
    db $EE, $EE, $EE, $EC, $EE, $C8, $ED, $C8, $ED, $38
    db $EE, $EE, $EE, $EE, $EC, $C8, $ED, $C8, $ED, $38
    db $C8, $C8, $C8, $EC, $EE, $EE, $ED, $C8, $ED, $38
    db $EE, $ED, $ED, $EE, $EC, $EE, $EE, $C8, $ED, $38
    db $EE, $ED, $ED, $C8, $EC, $C8, $C8, $ED, $EE, $38
    db $EE, $EE, $EE, $EE, $EC, $EE, $EE, $EE, $EE, $38
    db $B7, $B6, $B7, $B6, $B7, $B6, $B7, $B6, $B7, $38

RoomGBCOverlay70::
    db $37, $82, $83, $87, $FF, $F6, $04, $04, $04, $04
    db $37, $29, $2A, $87, $F7, $FC, $08, $04, $44, $04
    db $37, $82, $83, $8A, $8E, $FB, $F6, $08, $04, $04
    db $37, $29, $2A, $90, $87, $F7, $FC, $04, $25, $26
    db $31, $82, $83, $90, $87, $44, $FB, $F6, $27, $29
    db $29, $2A, $88, $84, $8C, $04, $FB, $FC, $25, $2A
    db $82, $83, $87, $44, $04, $F5, $FF, $0A, $27, $29
    db $29, $2A, $29, $26, $F5, $FF, $FF, $0A, $25, $2A

RoomGBCOverlay71::
    db $04, $04, $04, $04, $04, $04, $04, $86, $29, $2A
    db $04, $04, $08, $04, $08, $04, $04, $86, $82, $29
    db $04, $04, $04, $25, $26, $25, $26, $86, $29, $2A
    db $25, $26, $20, $27, $28, $27, $28, $86, $82, $29
    db $2A, $28, $04, $04, $44, $04, $25, $2A, $29, $2A
    db $29, $26, $04, $44, $A0, $44, $27, $29, $2A, $29
    db $2A, $29, $26, $04, $44, $04, $04, $27, $29, $2A
    db $29, $2A, $29, $26, $25, $26, $25, $26, $27, $29

RoomGBCOverlay72::
    db $83, $87, $04, $86, $29, $2A, $88, $84, $84, $84
    db $2A, $87, $04, $86, $82, $83, $87, $04, $04, $04
    db $83, $87, $04, $8D, $84, $84, $8C, $04, $8F, $85
    db $2A, $87, $04, $04, $04, $44, $04, $04, $86, $29
    db $83, $87, $44, $04, $04, $04, $04, $5C, $86, $82
    db $2A, $87, $5C, $5C, $5C, $5C, $5C, $5C, $86, $29
    db $29, $2A, $85, $85, $85, $85, $85, $85, $8B, $82
    db $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29

RoomGBCOverlay73::
    db $84, $84, $8C, $04, $04, $0A, $0A, $8D, $89, $82
    db $04, $04, $44, $04, $E8, $F7, $FF, $0A, $86, $29
    db $85, $8E, $04, $08, $04, $08, $F7, $0A, $86, $82
    db $2A, $87, $E8, $04, $5C, $04, $E8, $0A, $86, $29
    db $83, $87, $04, $08, $04, $08, $F5, $0A, $86, $82
    db $2A, $87, $08, $04, $E8, $F5, $0A, $0A, $86, $29
    db $83, $8A, $85, $85, $85, $85, $85, $85, $8B, $82
    db $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29

RoomGBCOverlay74::
    db $28, $03, $03, $03, $03, $38, $3A, $E0, $3A, $3A
    db $26, $3D, $48, $E0, $49, $34, $03, $03, $03, $03
    db $28, $38, $03, $03, $03, $0A, $08, $0A, $03, $03
    db $26, $38, $03, $03, $0A, $08, $5C, $08, $0A, $03
    db $28, $38, $03, $03, $03, $0A, $08, $0A, $03, $03
    db $26, $38, $03, $03, $03, $03, $03, $03, $03, $03
    db $28, $38, $03, $03, $03, $03, $03, $03, $03, $03
    db $26, $32, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlay75::
    db $3A, $3A, $3A, $3A, $3A, $3A, $37, $FF, $F8, $27
    db $03, $03, $03, $03, $03, $03, $37, $0A, $04, $25
    db $03, $03, $03, $20, $03, $03, $37, $0A, $F6, $27
    db $03, $03, $20, $C6, $20, $2B, $31, $0A, $0A, $25
    db $03, $03, $20, $03, $20, $37, $FF, $0A, $F8, $27
    db $03, $03, $03, $20, $03, $37, $0A, $F8, $25, $26
    db $03, $03, $03, $03, $03, $37, $F8, $04, $27, $29
    db $2C, $2C, $2C, $2C, $2C, $31, $04, $04, $25, $2A

RoomGBCOverlay76::
    db $28, $51, $0A, $0A, $09, $09, $03, $0A, $0A, $B6
    db $26, $51, $0A, $09, $C4, $0A, $C4, $03, $0A, $CD
    db $28, $51, $0A, $0A, $0A, $0A, $03, $09, $09, $0A
    db $26, $51, $0A, $0A, $C4, $03, $C5, $03, $0A, $0A
    db $28, $51, $0A, $03, $03, $0A, $0A, $03, $03, $09
    db $25, $26, $51, $51, $51, $51, $51, $51, $51, $51
    db $2A, $28, $3D, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $29, $26, $38, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay77::
    db $B7, $09, $03, $03, $0A, $0A, $0A, $0A, $0A, $51
    db $CE, $0A, $03, $C4, $09, $C4, $03, $C4, $0A, $51
    db $0A, $03, $09, $09, $0A, $0A, $09, $03, $0A, $51
    db $0A, $0A, $03, $C4, $0A, $C4, $03, $0A, $0A, $51
    db $0A, $0A, $0A, $0A, $03, $03, $51, $51, $51, $51
    db $51, $51, $51, $51, $51, $3D, $35, $0A, $0A, $0A
    db $2F, $2F, $2F, $2F, $2F, $4E, $0A, $0A, $25, $26
    db $3A, $3A, $3A, $3A, $3A, $3F, $25, $26, $27, $28

RoomGBCOverlay78::
    db $38, $0E, $9D, $9E, $96, $96, $96, $96, $96, $96
    db $38, $0E, $97, $98, $93, $93, $93, $93, $93, $93
    db $38, $0E, $94, $95, $0E, $0E, $0E, $0E, $0E, $0E
    db $38, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $38, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $32, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $25, $26, $C6, $04, $E8, $E8, $E8, $E8, $E8, $04
    db $27, $28, $25, $26, $25, $26, $25, $26, $25, $26

RoomGBCOverlay79::
    db $96, $96, $9D, $9E, $0D, $0C, $0D, $9D, $9E, $96
    db $93, $93, $97, $98, $AB, $AB, $AB, $97, $98, $93
    db $0E, $0E, $94, $95, $AC, $AC, $AC, $94, $95, $0E
    db $0E, $0E, $0E, $9F, $0D, $0C, $0D, $9F, $0E, $0E
    db $0E, $0E, $0E, $9A, $0D, $0C, $0D, $9A, $0E, $0E
    db $2C, $2C, $2C, $A3, $0D, $0C, $0D, $A3, $2C, $2C
    db $F7, $FA, $FF, $F9, $F6, $0C, $F5, $F9, $FF, $FA
    db $25, $26, $FB, $FF, $FC, $0C, $FB, $FF, $FC, $25

RoomGBCOverlay7A::
    db $96, $96, $96, $96, $96, $96, $96, $9D, $9E, $0E
    db $93, $93, $93, $93, $93, $93, $93, $97, $98, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $94, $95, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $F8, $04, $04, $04, $04, $04, $04, $04, $04, $04
    db $26, $25, $26, $25, $26, $25, $26, $25, $26, $25

RoomGBCOverlay7B::
    db $0E, $37, $27, $28, $04, $27, $28, $38, $0E, $37
    db $0E, $33, $2F, $2F, $D8, $2F, $2F, $34, $0E, $37
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37
    db $0E, $0E, $2B, $2C, $DA, $2C, $2D, $0E, $0E, $37
    db $0E, $0E, $37, $04, $04, $04, $38, $0E, $0E, $37
    db $2C, $2C, $31, $F6, $04, $F5, $32, $2D, $0E, $37
    db $F7, $FA, $FA, $FF, $F9, $FF, $FF, $38, $0E, $37
    db $26, $25, $26, $F7, $FF, $FF, $F8, $38, $0E, $37

RoomGBCOverlay7C::
    db $38, $ED, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $38, $ED, $EC, $EC, $EC, $EC, $EC, $C8, $C8, $C8
    db $38, $ED, $EC, $EC, $EC, $EC, $EC, $EB, $EB, $EB
    db $38, $ED, $EC, $EC, $EC, $EC, $EC, $EB, $EB, $EB
    db $38, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $32, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $3D, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $38, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay7D::
    db $EB, $EB, $EB, $EB, $ED, $C8, $ED, $CD, $CE, $CD
    db $C8, $EB, $EB, $EB, $ED, $C8, $EB, $EB, $EB, $EB
    db $ED, $C8, $C8, $C8, $ED, $C8, $C8, $ED, $EB, $EB
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $ED, $C8, $C8
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay7E::
    db $CE, $CD, $CE, $CD, $CE, $CD, $CE, $CD, $CE, $CD
    db $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $EB, $EB, $C8, $C8, $C8, $C8, $C8, $C8, $C8, $C8
    db $C8, $C8, $C8, $EB, $EB, $EB, $EB, $EB, $EB, $EB
    db $EB, $EB, $EB, $EB, $EB, $C8, $C8, $C8, $EB, $EB
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A

RoomGBCOverlay7F::
    db $CE, $CD, $CE, $CD, $CE, $CD, $CE, $CD, $CE, $38
    db $EB, $EB, $EB, $EB, $ED, $ED, $C8, $C8, $C8, $38
    db $C8, $ED, $ED, $ED, $ED, $ED, $ED, $ED, $C8, $38
    db $EB, $EB, $ED, $ED, $ED, $ED, $ED, $ED, $ED, $38
    db $EB, $EB, $ED, $ED, $ED, $ED, $ED, $ED, $ED, $38
    db $2C, $2D, $ED, $ED, $ED, $2B, $2C, $2C, $2D, $38
    db $2F, $4E, $E9, $E9, $E9, $2E, $2F, $2F, $4E, $38
    db $3A, $3F, $E9, $E9, $E9, $3E, $3A, $3A, $3F, $38

RoomGBCOverlay80::
    db $27, $29, $2A, $28, $FB, $FF, $FF, $44, $27, $29
    db $3C, $27, $28, $04, $F7, $FF, $0A, $0A, $25, $2A
    db $37, $25, $26, $04, $04, $F7, $44, $0A, $27, $29
    db $37, $27, $28, $25, $26, $04, $F7, $0A, $25, $2A
    db $2E, $3C, $25, $2A, $29, $26, $04, $25, $2A, $29
    db $3E, $37, $27, $29, $2A, $28, $04, $27, $29, $2A
    db $39, $37, $25, $2A, $29, $26, $04, $25, $2A, $29
    db $0E, $37, $27, $29, $2A, $28, $04, $27, $29, $2A

RoomGBCOverlay81::
    db $2A, $28, $27, $28, $27, $28, $27, $28, $25, $2A
    db $28, $3D, $2F, $2F, $3C, $52, $52, $52, $27, $29
    db $26, $38, $0E, $0E, $37, $5B, $5B, $5B, $25, $2A
    db $28, $38, $0E, $0E, $33, $3C, $0A, $0A, $27, $29
    db $26, $38, $0E, $0E, $0E, $37, $F7, $44, $25, $2A
    db $28, $32, $2C, $2C, $2C, $31, $04, $FE, $27, $29
    db $26, $F7, $FF, $44, $F8, $04, $F5, $FC, $25, $2A
    db $29, $26, $FB, $FC, $04, $04, $FB, $FC, $27, $29

RoomGBCOverlay82::
    db $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A
    db $2A, $28, $27, $28, $27, $28, $27, $28, $27, $28
    db $28, $5C, $F5, $F6, $55, $5A, $5A, $5A, $56, $F5
    db $26, $5C, $F7, $FC, $57, $59, $59, $59, $58, $FF
    db $28, $5C, $5C, $F7, $5B, $E2, $5B, $E2, $5B, $F7
    db $26, $36, $3C, $5C, $44, $0B, $0B, $0B, $0B, $0B
    db $28, $F5, $37, $5C, $5C, $5C, $5C, $F7, $44, $F9
    db $26, $FB, $2E, $2F, $2F, $2F, $2F, $48, $4A, $49

RoomGBCOverlay83::
    db $29, $2A, $29, $2A, $29, $2A, $29, $2A, $29, $2A
    db $27, $28, $27, $28, $27, $28, $27, $28, $27, $28
    db $F6, $5F, $5F, $5F, $F5, $F9, $44, $F9, $F9, $F9
    db $FC, $60, $E2, $60, $FB, $FF, $FF, $FF, $FF, $FA
    db $44, $20, $04, $20, $FB, $FF, $FF, $FF, $FC, $25
    db $0B, $0B, $20, $F5, $44, $FF, $FF, $FF, $FC, $27
    db $F6, $0B, $F5, $F8, $3D, $35, $FB, $44, $FC, $25
    db $48, $E0, $49, $2F, $4E, $F5, $FF, $FF, $FC, $27

RoomGBCOverlay84::
    db $29, $26, $25, $26, $25, $26, $25, $26, $25, $26
    db $27, $28, $27, $28, $27, $29, $2A, $28, $27, $28
    db $F9, $F6, $5C, $5C, $5C, $27, $28, $36, $3C, $0A
    db $FA, $FF, $F9, $F6, $04, $5C, $25, $26, $2E, $2F
    db $26, $FB, $FF, $FF, $F6, $5C, $27, $28, $3E, $3A
    db $28, $F7, $FF, $FF, $FC, $25, $26, $0A, $39, $E1
    db $26, $04, $FB, $FF, $FC, $27, $28, $F7, $0A, $0A
    db $28, $F5, $FF, $FF, $F8, $25, $26, $04, $FB, $0A

RoomGBCOverlay85::
    db $25, $26, $25, $26, $25, $26, $04, $04, $27, $28
    db $27, $28, $27, $28, $27, $28, $04, $3D, $2F, $2F
    db $F9, $44, $F6, $04, $04, $20, $F5, $38, $3A, $3A
    db $2F, $2F, $2F, $2F, $48, $E0, $49, $4E, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $E0, $3A, $3F, $0A, $25
    db $3A, $3A, $3A, $3A, $3A, $E0, $3A, $3B, $0A, $27
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $44, $25
    db $0A, $0A, $0A, $44, $FF, $0A, $0A, $FF, $F8, $27

RoomGBCOverlay86::
    db $27, $28, $38, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $2F, $2F, $4E, $0A, $0A, $5C, $5C, $5C, $04, $04
    db $3A, $3A, $3F, $0A, $0A, $F9, $F6, $E8, $04, $04
    db $3A, $BA, $3B, $0A, $E8, $F7, $0B, $0B, $0B, $0B
    db $26, $0A, $0A, $0A, $0B, $0B, $E8, $04, $E8, $04
    db $28, $0A, $0A, $0A, $E8, $44, $FD, $0A, $F6, $04
    db $26, $0A, $0A, $FF, $0B, $0A, $E8, $F7, $FC, $25
    db $28, $0A, $0A, $0A, $0B, $F8, $04, $04, $FE, $27

RoomGBCOverlay87::
    db $3A, $3A, $BA, $3A, $3A, $3B, $27, $28, $25, $26
    db $F7, $44, $F9, $FF, $FA, $FD, $F6, $5C, $27, $28
    db $04, $FB, $FF, $44, $25, $26, $44, $F6, $5C, $25
    db $0B, $0B, $44, $0A, $27, $28, $0A, $44, $5C, $27
    db $04, $0B, $0B, $44, $0A, $0A, $44, $F8, $04, $25
    db $04, $04, $0B, $FB, $44, $44, $FC, $04, $04, $27
    db $26, $04, $0B, $0B, $0B, $44, $F8, $04, $25, $26
    db $28, $04, $04, $F7, $0B, $F8, $04, $6E, $27, $28

RoomGBCOverlay88::
    db $25, $26, $27, $28, $27, $28, $27, $28, $27, $28
    db $27, $28, $F5, $F9, $F9, $F9, $44, $F9, $F9, $F9
    db $26, $F5, $FF, $FF, $FA, $FA, $FA, $FF, $FF, $FF
    db $28, $FB, $44, $F8, $25, $45, $26, $F7, $FF, $FF
    db $26, $F7, $FC, $04, $27, $E1, $28, $04, $F7, $44
    db $28, $04, $F7, $FD, $F6, $0B, $0B, $0B, $0B, $0B
    db $25, $26, $25, $26, $FE, $0B, $F5, $44, $FD, $F8
    db $27, $28, $27, $28, $FE, $0B, $FE, $25, $26, $25

RoomGBCOverlay89::
    db $27, $28, $F7, $FF, $F8, $0B, $FF, $FA, $FC, $27
    db $F9, $F6, $5C, $44, $5C, $0B, $FE, $5C, $FE, $25
    db $44, $F8, $5C, $F7, $FD, $0B, $F8, $5C, $FE, $27
    db $FC, $04, $5C, $04, $E8, $0B, $04, $D4, $FE, $25
    db $F8, $5C, $04, $5C, $04, $0B, $04, $F5, $FC, $27
    db $0B, $0B, $0B, $0B, $0B, $0B, $E8, $F7, $44, $25
    db $04, $5C, $04, $5C, $0B, $5C, $04, $5C, $F7, $27
    db $26, $25, $26, $04, $0B, $25, $26, $25, $26, $25

RoomGBCOverlay8A::
    db $28, $27, $28, $27, $28, $27, $28, $27, $28, $27
    db $26, $04, $2B, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $28, $2B, $31, $F8, $B6, $C3, $B7, $F7, $FF, $FF
    db $26, $37, $F8, $04, $CD, $E1, $CE, $04, $F7, $FF
    db $28, $37, $B6, $B7, $04, $0B, $D4, $B6, $B7, $FB
    db $26, $37, $CD, $CE, $04, $0B, $04, $CD, $CE, $44
    db $28, $37, $F6, $04, $04, $0B, $04, $04, $F5, $FA
    db $26, $37, $FF, $F6, $04, $0B, $F5, $F9, $FC, $3D

RoomGBCOverlay8B::
    db $28, $27, $28, $04, $FB, $FF, $F6, $38, $0E, $37
    db $2C, $2C, $2D, $F5, $FF, $FF, $44, $38, $0E, $37
    db $FF, $44, $38, $F7, $44, $FA, $FF, $38, $0E, $37
    db $FF, $FC, $32, $2C, $2C, $2D, $FB, $38, $0E, $37
    db $FF, $FF, $F6, $5C, $5C, $38, $FC, $38, $0E, $37
    db $FF, $FA, $F8, $5C, $5C, $38, $FE, $38, $0E, $37
    db $F8, $5C, $5C, $5C, $5C, $38, $FB, $38, $0E, $37
    db $2F, $48, $4A, $4A, $49, $4E, $FC, $38, $0E, $37

RoomGBCOverlay8C::
    db $38, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $38, $B9, $B9, $B9, $B9, $B9, $47, $3A, $3A, $3A
    db $38, $B3, $B3, $B3, $B3, $B3, $38, $70, $47, $3A
    db $38, $B3, $B3, $B3, $B3, $B3, $F2, $04, $38, $0E
    db $38, $B9, $B8, $B9, $B8, $B9, $F3, $04, $F2, $0E
    db $38, $B6, $B9, $B9, $B9, $B6, $F4, $04, $F3, $0E
    db $38, $B7, $B9, $B9, $B9, $B7, $38, $04, $F4, $0E
    db $38, $2F, $48, $E0, $49, $2F, $4E, $04, $38, $0E

RoomGBCOverlay8D::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $BA, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $46, $04, $04, $47, $3A, $3A, $3A, $3A
    db $0E, $0E, $37, $04, $04, $38, $0E, $0E, $0E, $0E
    db $0E, $0E, $37, $04, $04, $32, $2C, $E0, $2C, $2C
    db $0E, $0E, $37, $04, $04, $04, $04, $04, $04, $04
    db $0E, $0E, $33, $2F, $48, $E0, $49, $2F, $3C, $6E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04

RoomGBCOverlay8E::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $3A, $3A, $3A, $3A, $46, $04, $04, $04, $09, $04
    db $0E, $0E, $0E, $0E, $33, $2F, $48, $E0, $49, $2F
    db $2C, $2C, $2D, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $04, $04, $32, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $6E, $20, $20, $5C, $5C, $04, $20, $04, $6E, $04
    db $04, $6E, $04, $6E, $04, $04, $6E, $04, $6E, $04

RoomGBCOverlay8F::
    db $3A, $3F, $E9, $E9, $E9, $3E, $3A, $3A, $3F, $38
    db $E1, $3F, $E9, $E9, $E9, $3E, $3A, $3A, $3B, $38
    db $04, $38, $0E, $0E, $0E, $37, $25, $26, $3D, $34
    db $2F, $34, $0E, $0E, $0E, $37, $27, $28, $38, $0E
    db $0E, $0E, $0E, $0E, $0E, $37, $0A, $6F, $38, $0E
    db $2C, $2C, $2D, $0E, $0E, $37, $0A, $0A, $38, $0E
    db $04, $20, $38, $0E, $0E, $37, $FA, $0A, $38, $0E
    db $04, $04, $38, $0E, $0E, $37, $04, $F7, $38, $0E

RoomGBCOverlay90::
    db $0E, $37, $25, $2A, $29, $26, $04, $25, $2A, $29
    db $0E, $37, $27, $29, $2A, $28, $04, $27, $29, $2A
    db $0E, $37, $25, $2A, $28, $0A, $5C, $04, $27, $29
    db $0E, $37, $27, $28, $0A, $F8, $04, $04, $25, $2A
    db $0E, $37, $25, $26, $0A, $04, $04, $04, $27, $29
    db $0E, $37, $27, $28, $FC, $D4, $04, $F5, $25, $2A
    db $0E, $37, $25, $26, $FB, $F6, $0B, $44, $27, $29
    db $0E, $37, $27, $28, $FB, $FF, $0B, $0A, $25, $2A

RoomGBCOverlay91::
    db $2A, $28, $FB, $F8, $04, $F5, $FF, $F8, $25, $2A
    db $28, $F5, $F8, $04, $F5, $FF, $FC, $04, $27, $29
    db $26, $FE, $25, $26, $F7, $44, $FF, $F6, $04, $27
    db $28, $FE, $27, $28, $04, $F7, $FA, $FF, $F6, $25
    db $26, $FB, $F6, $04, $04, $25, $26, $FB, $FC, $27
    db $28, $FB, $44, $F6, $04, $27, $28, $FB, $F8, $25
    db $26, $F7, $FA, $F8, $04, $F5, $F9, $F8, $25, $2A
    db $29, $26, $25, $26, $F5, $FF, $FC, $25, $2A, $29

RoomGBCOverlay92::
    db $28, $FB, $39, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $26, $FE, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $FB
    db $28, $FE, $0C, $0C, $44, $44, $44, $0C, $0C, $FB
    db $26, $FE, $0C, $44, $0C, $91, $0C, $44, $0C, $FB
    db $28, $FE, $0C, $44, $0C, $5E, $0C, $44, $0C, $FB
    db $26, $FE, $0C, $44, $0C, $0C, $0C, $44, $0C, $F7
    db $28, $FE, $0C, $0C, $44, $44, $44, $0C, $0C, $0B
    db $26, $FE, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $F5

RoomGBCOverlay93::
    db $3A, $E0, $3A, $3A, $3B, $FB, $FF, $FF, $FC, $25
    db $FC, $0B, $FB, $FA, $FA, $FA, $44, $FA, $F8, $27
    db $FC, $0B, $F8, $5C, $5C, $5C, $F7, $0B, $0B, $0B
    db $FC, $0B, $5C, $55, $5A, $56, $5C, $0B, $F5, $25
    db $FC, $0B, $5C, $40, $41, $42, $5C, $0B, $FC, $27
    db $F8, $0B, $5C, $5B, $E2, $5B, $5C, $0B, $FC, $25
    db $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B, $FC, $27
    db $F9, $F9, $F9, $F9, $F9, $F9, $F9, $F9, $FC, $25

RoomGBCOverlay94::
    db $26, $FB, $FF, $F8, $04, $27, $28, $0A, $0A, $0A
    db $28, $FB, $FC, $D4, $5C, $20, $F5, $0A, $0A, $0A
    db $0B, $0B, $0B, $0B, $5C, $20, $0B, $0B, $0B, $0B
    db $26, $F7, $F8, $5C, $5C, $25, $26, $F5, $44, $0A
    db $28, $04, $5C, $5C, $25, $2A, $28, $0A, $FF, $0A
    db $26, $25, $26, $25, $2A, $28, $0A, $0A, $FF, $FF
    db $29, $2A, $29, $2A, $28, $F5, $FF, $FF, $FF, $0A
    db $2A, $29, $2A, $29, $26, $FB, $0A, $0A, $0A, $0A

RoomGBCOverlay95::
    db $0A, $0A, $0A, $0A, $FF, $FF, $0A, $0A, $0A, $25
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $5C, $27
    db $0B, $0B, $5C, $25, $26, $0A, $0A, $0A, $0A, $0A
    db $0A, $0B, $0B, $27, $28, $2B, $2C, $2D, $0A, $0A
    db $0A, $0A, $0B, $0B, $0B, $37, $E8, $38, $0A, $0A
    db $F6, $04, $0A, $0A, $0B, $33, $E0, $34, $0B, $0B
    db $0A, $F9, $FF, $0A, $0B, $0B, $0B, $0B, $0B, $0A
    db $0A, $0A, $0A, $0A, $F9, $0A, $F9, $0A, $25, $26

RoomGBCOverlay96::
    db $26, $FB, $FF, $FF, $0B, $04, $04, $F5, $F8, $25
    db $28, $0A, $FF, $F8, $0B, $F5, $F9, $FC, $E8, $27
    db $F9, $FF, $0A, $E8, $0B, $F7, $FF, $F8, $04, $25
    db $0A, $F7, $FF, $F6, $0B, $E8, $FE, $5C, $25, $2A
    db $0A, $E8, $F7, $F8, $0B, $F5, $F8, $04, $27, $29
    db $0B, $0B, $0B, $0B, $0B, $FE, $E8, $F5, $F6, $27
    db $0A, $0A, $0A, $FD, $FD, $FA, $FD, $FA, $F8, $25
    db $25, $26, $25, $26, $25, $26, $25, $26, $25, $2A

RoomGBCOverlay97::
    db $26, $04, $04, $04, $0B, $04, $04, $2B, $2C, $2C
    db $28, $04, $04, $04, $0B, $04, $04, $EA, $F5, $F9
    db $26, $04, $E8, $04, $0B, $0B, $0B, $F0, $FB, $44
    db $29, $26, $04, $04, $04, $04, $04, $F1, $F7, $FA
    db $2A, $28, $04, $E8, $BB, $BC, $6E, $2E, $E0, $49
    db $28, $04, $09, $04, $BD, $BE, $04, $39, $E0, $3A
    db $26, $6E, $04, $25, $26, $04, $04, $04, $04, $25
    db $29, $26, $25, $2A, $29, $26, $25, $26, $25, $2A

RoomGBCOverlay98::
    db $2C, $2C, $2C, $2D, $FE, $0B, $FE, $27, $28, $27
    db $F9, $44, $F6, $38, $FE, $0B, $F7, $FD, $F6, $25
    db $FF, $FA, $F8, $38, $FE, $0B, $0B, $D4, $FE, $27
    db $F8, $3D, $E0, $4E, $FB, $F6, $E8, $F5, $FC, $25
    db $2F, $4E, $E0, $3B, $F7, $F8, $0B, $44, $FC, $27
    db $3A, $3B, $0B, $0B, $0B, $0B, $0B, $FB, $FC, $25
    db $26, $44, $FA, $F8, $0B, $F7, $FD, $FA, $F8, $27
    db $29, $26, $25, $26, $0B, $25, $26, $25, $26, $25

RoomGBCOverlay99::
    db $28, $27, $28, $04, $0B, $27, $28, $27, $28, $27
    db $26, $F6, $5C, $04, $0B, $04, $5C, $04, $5C, $25
    db $28, $44, $04, $E8, $0B, $5C, $04, $E8, $04, $27
    db $26, $FE, $5C, $04, $0B, $04, $5C, $44, $5C, $F5
    db $28, $FE, $04, $E8, $0B, $5C, $04, $E8, $F5, $FA
    db $26, $FE, $5C, $04, $0B, $0B, $0B, $0B, $0B, $0B
    db $28, $44, $FD, $F9, $F9, $F9, $F6, $0B, $44, $FA
    db $26, $25, $26, $FB, $FF, $44, $F8, $0B, $25, $26

RoomGBCOverlay9A::
    db $28, $37, $FB, $FC, $04, $0B, $F7, $FA, $FF, $38
    db $26, $37, $FF, $FF, $F6, $0B, $0B, $0B, $F7, $38
    db $28, $33, $2F, $2F, $3C, $F5, $F6, $0B, $36, $34
    db $F9, $FA, $F6, $04, $33, $35, $FE, $0B, $04, $F5
    db $F8, $04, $F7, $F9, $FD, $F9, $F8, $0B, $F5, $FF
    db $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B, $FB, $FF
    db $FA, $FD, $FA, $FD, $FA, $FD, $FA, $FD, $FA, $FA
    db $25, $26, $25, $26, $25, $26, $25, $26, $25, $26

RoomGBCOverlay9B::
    db $3A, $3A, $3A, $3A, $3A, $3B, $FB, $38, $0E, $37
    db $25, $26, $04, $F7, $FF, $F9, $44, $38, $0E, $37
    db $27, $28, $04, $3D, $48, $E0, $49, $34, $0E, $2E
    db $F9, $F6, $04, $38, $0E, $0E, $0E, $0E, $0E, $39
    db $44, $FC, $3D, $34, $0E, $0E, $0E, $0E, $0E, $0E
    db $FF, $F8, $38, $0E, $0E, $2B, $2C, $2C, $2C, $2C
    db $F8, $04, $38, $0E, $0E, $37, $F5, $F9, $44, $F8
    db $25, $26, $38, $0E, $0E, $37, $44, $FF, $FC, $2B

RoomGBCOverlay9C::
    db $38, $3A, $3A, $E0, $3A, $E1, $3B, $04, $38, $0E
    db $38, $3A, $46, $04, $04, $04, $04, $04, $38, $0E
    db $4E, $0E, $2E, $48, $4A, $49, $2F, $2F, $4E, $0E
    db $3B, $0E, $39, $3A, $3A, $3A, $3A, $3A, $3B, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C
    db $04, $04, $04, $04, $04, $04, $04, $04, $04, $04
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlay9D::
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04
    db $0E, $2B, $2C, $2C, $2C, $2C, $2D, $0E, $37, $04
    db $0E, $37, $C6, $B9, $B9, $B8, $38, $0E, $37, $6E
    db $0E, $33, $2F, $48, $E0, $49, $34, $0E, $37, $04
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $31, $6E
    db $04, $04, $04, $04, $04, $04, $04, $04, $04, $04
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlay9E::
    db $04, $6E, $04, $6E, $04, $04, $6E, $04, $6E, $04
    db $04, $20, $20, $20, $5C, $20, $6E, $20, $20, $04
    db $6E, $6E, $6E, $6E, $6E, $6E, $6E, $04, $20, $6E
    db $04, $6E, $04, $20, $20, $20, $5C, $5C, $20, $04
    db $04, $04, $04, $04, $20, $6E, $6E, $20, $20, $6E
    db $6E, $6E, $6E, $6E, $04, $04, $04, $04, $04, $04
    db $04, $04, $5C, $20, $20, $5C, $20, $04, $20, $04
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlay9F::
    db $04, $04, $38, $0E, $0E, $37, $04, $04, $38, $0E
    db $04, $5C, $38, $0E, $0E, $37, $04, $04, $38, $0E
    db $6E, $5C, $32, $2C, $2C, $31, $04, $04, $38, $0E
    db $04, $5C, $6E, $04, $04, $04, $04, $04, $38, $0E
    db $6E, $6E, $6E, $04, $04, $04, $36, $3C, $38, $0E
    db $04, $04, $04, $04, $20, $20, $04, $37, $38, $0E
    db $04, $04, $04, $04, $04, $04, $04, $37, $38, $0E
    db $2C, $2C, $2D, $04, $2B, $2C, $2C, $31, $38, $0E

RoomGBCOverlayA0::
    db $0E, $37, $25, $26, $FB, $FC, $0B, $0A, $27, $28
    db $0E, $37, $27, $28, $F7, $F8, $0B, $0B, $0B, $0B
    db $0E, $37, $36, $3C, $5C, $5C, $5C, $3D, $35, $F5
    db $0E, $37, $F6, $2E, $48, $4A, $49, $4E, $5C, $FB
    db $0E, $37, $FC, $39, $3A, $3A, $3A, $3B, $F9, $44
    db $0E, $37, $FB, $F6, $62, $61, $62, $F7, $FA, $FA
    db $0E, $37, $FB, $44, $62, $04, $62, $0B, $0B, $0B
    db $0E, $37, $FB, $FF, $F9, $F9, $F6, $0B, $F5, $25

RoomGBCOverlayA1::
    db $27, $28, $27, $28, $0A, $0A, $0A, $27, $28, $27
    db $0B, $0B, $55, $5A, $56, $0A, $FF, $F9, $F9, $F9
    db $F6, $0B, $57, $59, $58, $52, $F7, $44, $FF, $FF
    db $FC, $0B, $5B, $E2, $5B, $E2, $62, $0A, $FF, $FF
    db $FC, $0B, $0B, $0B, $E6, $0A, $0A, $0A, $0A, $FF
    db $FA, $FD, $44, $0A, $0A, $0A, $0A, $0A, $FF, $FF
    db $0B, $0B, $F7, $FA, $FA, $FA, $FA, $FA, $44, $FA
    db $26, $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B

RoomGBCOverlayA2::
    db $28, $FB, $FD, $FD, $FD, $FD, $FD, $FD, $FD, $FF
    db $F9, $FC, $62, $62, $62, $62, $62, $62, $62, $FB
    db $FF, $FC, $62, $0A, $0A, $0A, $0A, $25, $26, $0A
    db $FF, $44, $62, $0A, $52, $52, $52, $27, $28, $0A
    db $FF, $FC, $62, $0A, $5B, $E2, $5B, $0A, $62, $FB
    db $FF, $FC, $62, $0A, $0A, $0B, $0A, $0A, $62, $FB
    db $FA, $F8, $62, $62, $62, $0B, $62, $62, $62, $FB
    db $0B, $0B, $0B, $0B, $0B, $0B, $F5, $F9, $F9, $FF

RoomGBCOverlayA3::
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $27
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $25
    db $0A, $0A, $5C, $5C, $5C, $5C, $5C, $5C, $0A, $27
    db $0A, $0A, $5C, $5C, $5C, $5C, $5C, $5C, $0A, $25
    db $0A, $0A, $5C, $5C, $5C, $5C, $5C, $5C, $0A, $27
    db $0A, $0A, $5C, $5C, $5C, $5C, $5C, $5C, $0A, $25
    db $0A, $0A, $5C, $5C, $5C, $5C, $5C, $5C, $0A, $27
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $25

RoomGBCOverlayA4::
    db $28, $27, $28, $27, $28, $F7, $0A, $0A, $0A, $0A
    db $26, $0A, $0A, $0A, $0A, $04, $0A, $0A, $0A, $0A
    db $28, $0A, $25, $45, $26, $04, $25, $26, $0A, $0A
    db $26, $F6, $27, $E1, $28, $04, $27, $28, $0A, $0A
    db $28, $44, $F6, $04, $D4, $F5, $0A, $0A, $36, $2F
    db $26, $0A, $FF, $F9, $44, $0A, $0A, $0A, $25, $26
    db $28, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $27, $28
    db $26, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $25, $26

RoomGBCOverlayA5::
    db $04, $F5, $0A, $0A, $0A, $0A, $0A, $0A, $27, $28
    db $F5, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $2B, $2C
    db $0A, $0A, $0A, $2B, $2C, $2C, $2C, $2C, $31, $F5
    db $0A, $0A, $0A, $EA, $04, $0A, $04, $04, $F7, $FF
    db $3C, $0A, $0A, $F0, $0A, $04, $0A, $04, $04, $FB
    db $37, $0A, $0A, $F1, $04, $0A, $04, $04, $F5, $FF
    db $37, $0A, $0A, $37, $04, $04, $04, $F5, $FA, $FA
    db $37, $0A, $0A, $2E, $2F, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlayA6::
    db $27, $28, $27, $28, $27, $28, $27, $28, $27, $28
    db $2C, $2C, $2C, $2D, $0F, $0F, $0F, $0F, $0F, $6E
    db $F9, $F9, $F6, $38, $0E, $0E, $0E, $0E, $0E, $0E
    db $FF, $FF, $FC, $38, $0E, $1A, $10, $19, $0E, $0E
    db $FF, $FF, $FF, $38, $0E, $12, $5C, $11, $0E, $0E
    db $FF, $FA, $FF, $38, $0E, $12, $04, $11, $0E, $0E
    db $F8, $04, $F7, $38, $0E, $18, $0F, $17, $0E, $0E
    db $48, $E0, $49, $4E, $0E, $0E, $0E, $0E, $0E, $0E

RoomGBCOverlayA7::
    db $27, $28, $27, $28, $27, $29, $2A, $28, $27, $29
    db $6E, $0F, $0F, $14, $F5, $27, $28, $F5, $F8, $27
    db $0E, $0E, $0E, $12, $F7, $F9, $F9, $FC, $0B, $0B
    db $0E, $0E, $0E, $12, $04, $F7, $FA, $F8, $0B, $F5
    db $0E, $0E, $0E, $12, $04, $25, $26, $0B, $0B, $FB
    db $0E, $0E, $0E, $12, $04, $27, $28, $0B, $F5, $2B
    db $0E, $0E, $0E, $12, $04, $25, $26, $0B, $FE, $37
    db $0E, $0E, $0E, $12, $04, $27, $28, $0B, $FB, $37

RoomGBCOverlayA8::
    db $2A, $28, $27, $28, $0B, $27, $28, $27, $28, $27
    db $28, $F5, $F9, $F9, $0B, $F6, $25, $26, $04, $04
    db $0B, $0B, $0B, $0B, $0B, $FC, $27, $28, $04, $04
    db $F9, $FC, $2B, $2C, $2C, $2C, $2C, $2D, $04, $04
    db $FF, $F8, $37, $04, $6F, $F5, $F6, $32, $2D, $6E
    db $2C, $2C, $31, $F5, $F9, $FF, $FF, $F6, $38, $04
    db $25, $26, $F5, $FF, $FF, $FA, $FA, $FF, $38, $04
    db $27, $28, $FB, $2B, $2C, $2C, $2D, $FE, $38, $04

RoomGBCOverlayA9::
    db $28, $27, $28, $FB, $44, $F8, $04, $0B, $27, $28
    db $04, $F5, $FD, $FA, $F8, $04, $04, $0B, $04, $25
    db $F5, $FC, $6E, $6E, $6E, $6E, $6E, $0B, $04, $27
    db $F7, $44, $6E, $04, $04, $F5, $F6, $0B, $0B, $0B
    db $6E, $6E, $6E, $04, $F5, $6E, $44, $6E, $F5, $F9
    db $04, $04, $04, $04, $44, $FD, $F8, $6E, $F7, $FF
    db $04, $6E, $04, $6E, $FE, $6E, $04, $6E, $04, $F7
    db $04, $04, $04, $F5, $FF, $F6, $04, $6E, $04, $25

RoomGBCOverlayAA::
    db $27, $28, $27, $28, $27, $29, $2A, $28, $27, $28
    db $26, $04, $F5, $F6, $25, $2A, $29, $26, $F5, $F9
    db $28, $F5, $F8, $D4, $27, $28, $27, $28, $F7, $FF
    db $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B, $F7
    db $F9, $F6, $25, $26, $25, $26, $25, $26, $D3, $04
    db $FF, $FC, $27, $28, $27, $28, $27, $28, $F5, $F9
    db $FA, $FA, $FD, $FD, $FD, $FD, $FD, $FD, $FA, $F8
    db $26, $25, $26, $25, $26, $25, $26, $25, $26, $25

RoomGBCOverlayAB::
    db $27, $28, $38, $0E, $0E, $37, $0A, $FF, $44, $37
    db $F6, $04, $38, $0E, $0E, $37, $0A, $FF, $FF, $37
    db $FF, $F6, $38, $0E, $0E, $33, $3C, $44, $FC, $37
    db $FF, $FC, $32, $2D, $0E, $0E, $37, $F7, $FC, $37
    db $FB, $FF, $F6, $38, $0E, $0E, $37, $C6, $FB, $37
    db $FA, $FA, $F8, $F2, $0E, $0E, $EA, $F5, $F8, $37
    db $04, $6E, $04, $F3, $0E, $0E, $F0, $FE, $6E, $37
    db $26, $25, $26, $F4, $0E, $0E, $F1, $FF, $F6, $37

RoomGBCOverlayAC::
    db $3D, $3C, $B3, $B3, $B3, $B3, $B3, $B3, $B3, $3D
    db $38, $37, $B3, $B3, $B3, $B3, $B3, $B3, $B3, $38
    db $38, $37, $AD, $AF, $B1, $E7, $AD, $AF, $B1, $38
    db $38, $37, $AE, $B0, $B2, $E3, $AE, $B0, $B2, $38
    db $38, $37, $03, $03, $03, $B9, $03, $03, $03, $38
    db $38, $37, $03, $03, $03, $B9, $03, $03, $03, $38
    db $38, $37, $03, $03, $B9, $B9, $B9, $03, $03, $38
    db $38, $2E, $2F, $2F, $48, $E0, $49, $2F, $2F, $4E

RoomGBCOverlayAD::
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $B6, $03, $03, $03, $03, $B6, $03, $03, $03, $03
    db $B6, $03, $03, $B8, $03, $B6, $03, $B8, $03, $03
    db $B6, $03, $03, $B6, $03, $B6, $03, $B6, $03, $B6
    db $B6, $03, $03, $B6, $03, $B7, $03, $B6, $03, $B7
    db $B6, $03, $03, $B6, $03, $03, $03, $B6, $03, $03
    db $B6, $03, $03, $B6, $03, $03, $03, $B6, $B6, $B6

RoomGBCOverlayAE::
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $03, $03, $03, $03, $03, $B6, $03, $03, $03, $03
    db $03, $03, $B8, $B9, $03, $B6, $03, $B9, $B8, $03
    db $B6, $03, $B9, $B9, $B9, $B6, $B9, $B9, $B9, $03
    db $B7, $03, $B8, $B9, $C6, $B6, $03, $B9, $B8, $03
    db $03, $03, $03, $03, $03, $B6, $03, $03, $03, $03
    db $B6, $B6, $B6, $B6, $B6, $B6, $B6, $B6, $B6, $B6

RoomGBCOverlayAF::
    db $2F, $2F, $4E, $03, $2E, $2F, $3C, $09, $38, $0E
    db $3A, $3A, $3B, $03, $39, $3A, $37, $03, $38, $0E
    db $03, $03, $B6, $B9, $B9, $03, $37, $03, $38, $0E
    db $03, $B8, $B6, $B9, $B6, $B8, $37, $03, $38, $0E
    db $03, $03, $B6, $B9, $B6, $03, $37, $03, $38, $0E
    db $03, $B8, $B7, $B9, $B7, $B8, $37, $03, $32, $2D
    db $03, $03, $B9, $B9, $B9, $03, $37, $03, $03, $38
    db $B6, $03, $B6, $B9, $B6, $03, $2E, $3C, $03, $38

RoomGBCOverlayB0::
    db $0E, $37, $44, $FA, $FA, $FF, $FC, $0B, $FE, $27
    db $0E, $37, $52, $52, $52, $FB, $FC, $0B, $FE, $25
    db $0E, $37, $5B, $E2, $5B, $F7, $F8, $0B, $FE, $27
    db $0E, $37, $F6, $04, $04, $04, $0B, $0B, $44, $25
    db $0E, $37, $FF, $F9, $F6, $0B, $0B, $04, $5C, $27
    db $0E, $37, $FB, $FF, $FC, $0B, $F5, $F6, $5C, $25
    db $0E, $37, $F7, $FA, $FC, $0B, $FB, $F8, $25, $2A
    db $0E, $37, $25, $26, $FE, $0B, $FE, $25, $2A, $29

RoomGBCOverlayB1::
    db $28, $F5, $F9, $F9, $F9, $F9, $F9, $44, $F9, $F9
    db $26, $F7, $FF, $44, $FF, $FF, $FA, $FA, $FF, $FF
    db $28, $5F, $60, $60, $60, $60, $60, $5F, $FB, $FF
    db $26, $60, $0A, $55, $61, $56, $0A, $60, $FB, $44
    db $28, $F5, $0A, $57, $59, $58, $0A, $FF, $FF, $FF
    db $26, $F7, $0A, $5B, $E2, $5B, $0A, $FF, $FF, $FF
    db $29, $26, $F7, $F8, $04, $F7, $FA, $FA, $44, $FA
    db $2A, $29, $26, $25, $26, $25, $26, $25, $26, $25

RoomGBCOverlayB2::
    db $F9, $F9, $FD, $FD, $FD, $FD, $FA, $44, $FA, $FF
    db $FF, $FC, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $FB
    db $44, $FC, $0C, $0D, $0D, $0D, $0D, $0D, $0C, $FB
    db $FF, $FC, $0C, $0D, $25, $45, $26, $0D, $0C, $FB
    db $FF, $FC, $0C, $0D, $27, $E1, $28, $0D, $0C, $FB
    db $FF, $FC, $0C, $0D, $0D, $0D, $0D, $0D, $0C, $FB
    db $FA, $44, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $F7
    db $26, $25, $26, $25, $26, $25, $26, $25, $26, $25

RoomGBCOverlayB3::
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $27
    db $FF, $FF, $FF, $F8, $5C, $5C, $5C, $F7, $3D, $2F
    db $FF, $FF, $FC, $5C, $55, $5A, $56, $5C, $38, $0E
    db $FF, $FF, $FC, $5C, $40, $41, $42, $5C, $38, $0E
    db $FF, $44, $FC, $5C, $5B, $E2, $5B, $5C, $38, $0E
    db $FF, $FF, $FC, $5C, $04, $04, $04, $5C, $38, $0E
    db $FA, $FA, $FA, $F6, $5C, $5C, $25, $26, $38, $0E
    db $26, $25, $26, $25, $26, $25, $2A, $28, $32, $2C

RoomGBCOverlayB4::
    db $28, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $27, $28
    db $3C, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $25, $26
    db $37, $0A, $0A, $0A, $0A, $0A, $E8, $0A, $27, $28
    db $37, $0A, $0A, $0A, $0A, $E8, $E8, $E8, $25, $26
    db $37, $0A, $0A, $25, $26, $D4, $E8, $E8, $27, $28
    db $37, $25, $26, $27, $28, $0A, $0A, $E8, $25, $26
    db $37, $27, $29, $26, $0A, $0A, $0A, $0A, $27, $28
    db $31, $25, $2A, $28, $0A, $0A, $0A, $0A, $25, $26

RoomGBCOverlayB5::
    db $37, $0A, $0A, $39, $6A, $6C, $6C, $6C, $6A, $3A
    db $37, $0A, $0A, $B6, $6B, $62, $C2, $62, $6B, $1B
    db $37, $0A, $0A, $B7, $11, $1B, $1B, $1B, $1A, $10
    db $37, $0A, $0A, $B6, $15, $10, $10, $10, $16, $04
    db $37, $0A, $0A, $B7, $B6, $04, $B6, $04, $B6, $04
    db $37, $0A, $0A, $0A, $B7, $6E, $C0, $6E, $B7, $04
    db $37, $0A, $0A, $0A, $0A, $F6, $04, $04, $6E, $F5
    db $2E, $2F, $2F, $2F, $2F, $48, $E0, $49, $2F, $2F

RoomGBCOverlayB6::
    db $3A, $E0, $3A, $3B, $0E, $0E, $0E, $0E, $0E, $0E
    db $1A, $10, $10, $19, $0E, $1A, $19, $0E, $1A, $10
    db $16, $04, $04, $11, $0E, $18, $17, $0E, $18, $0F
    db $04, $13, $0F, $17, $0E, $0E, $0E, $0E, $0E, $0E
    db $04, $11, $0E, $0E, $0E, $0E, $1A, $19, $0E, $0E
    db $04, $11, $0E, $1A, $19, $0E, $18, $17, $0E, $0E
    db $F6, $11, $0E, $18, $17, $0E, $0E, $0E, $0E, $0E
    db $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F, $2F

RoomGBCOverlayB7::
    db $0E, $0E, $0E, $12, $04, $25, $26, $0B, $FE, $37
    db $10, $19, $0E, $12, $04, $27, $28, $0B, $FE, $37
    db $0F, $17, $0E, $18, $14, $04, $25, $26, $FE, $37
    db $0E, $0E, $0E, $0E, $12, $04, $27, $28, $FB, $37
    db $0E, $0E, $0E, $0E, $12, $0A, $25, $26, $FE, $37
    db $0E, $0E, $0E, $3D, $35, $0A, $27, $28, $FE, $37
    db $0E, $0E, $0E, $38, $0A, $0A, $25, $26, $FB, $37
    db $2F, $2F, $2F, $4E, $D3, $D3, $27, $28, $FB, $37

RoomGBCOverlayB8::
    db $25, $26, $FB, $37, $04, $04, $38, $FC, $38, $F6
    db $27, $28, $FB, $2E, $2F, $2F, $4E, $FB, $38, $FF
    db $25, $26, $FE, $39, $3A, $E1, $3B, $FC, $38, $0A
    db $27, $28, $FB, $44, $F8, $04, $F7, $F8, $38, $0A
    db $25, $26, $F7, $F8, $04, $3D, $2F, $2F, $4E, $0A
    db $27, $29, $26, $04, $F5, $38, $3A, $E1, $3B, $6E
    db $25, $2A, $28, $04, $FB, $38, $0A, $0A, $0A, $04
    db $27, $29, $26, $04, $F7, $38, $0A, $6E, $FE, $6E

RoomGBCOverlayB9::
    db $04, $04, $04, $F7, $44, $FA, $F6, $6E, $04, $27
    db $F6, $6E, $04, $6E, $FE, $6E, $FE, $6E, $F5, $44
    db $FC, $04, $04, $04, $F7, $FD, $F8, $6E, $FB, $FF
    db $F8, $6E, $04, $04, $20, $6E, $6E, $6E, $FB, $FF
    db $04, $04, $04, $04, $6E, $F5, $FD, $F9, $FF, $FA
    db $6E, $6E, $6E, $04, $6E, $FE, $3D, $2F, $2F, $2F
    db $04, $04, $04, $04, $F5, $FF, $38, $0E, $0E, $0E
    db $6E, $04, $6E, $04, $44, $FC, $38, $0E, $0E, $0E

RoomGBCOverlayBA::
    db $28, $27, $28, $27, $28, $27, $28, $27, $28, $27
    db $F9, $F6, $04, $04, $04, $04, $04, $04, $04, $04
    db $44, $FF, $F6, $3D, $2F, $2F, $48, $E0, $49, $2F
    db $FF, $FF, $F8, $38, $0E, $0E, $0E, $0E, $0E, $0E
    db $FA, $F8, $3D, $34, $0E, $2B, $2C, $2C, $2C, $2C
    db $2F, $2F, $34, $0E, $0E, $37, $0A, $0A, $0A, $0A
    db $0E, $0E, $0E, $0E, $0E, $33, $E0, $3C, $0A, $0A
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $0A, $25

RoomGBCOverlayBB::
    db $28, $27, $28, $38, $0E, $0E, $37, $FB, $44, $37
    db $04, $04, $04, $38, $0E, $0E, $37, $FF, $FC, $37
    db $2F, $2F, $2F, $34, $0E, $0E, $37, $0A, $F8, $37
    db $0E, $0E, $0E, $0E, $0E, $2B, $31, $0A, $5C, $37
    db $2C, $2C, $2C, $2C, $2C, $31, $0A, $0A, $04, $37
    db $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A, $5C, $37
    db $FA, $FF, $FF, $FC, $5C, $0A, $0A, $FF, $0A, $37
    db $26, $FB, $FF, $FF, $F9, $FF, $44, $FF, $0A, $37

RoomGBCOverlayBC::
    db $38, $39, $3A, $3A, $3A, $E0, $3A, $3A, $3A, $3B
    db $38, $03, $03, $B9, $B9, $B9, $B6, $B9, $03, $03
    db $38, $03, $B9, $B6, $B6, $B6, $B7, $B9, $03, $03
    db $38, $03, $B9, $B6, $B7, $B7, $B9, $B9, $03, $03
    db $38, $03, $B9, $B6, $B8, $B9, $B9, $B6, $B6, $B6
    db $38, $03, $B9, $B7, $B9, $B9, $B9, $B6, $B7, $B7
    db $38, $03, $03, $03, $03, $03, $03, $B7, $03, $03
    db $32, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlayBD::
    db $B7, $03, $03, $B6, $03, $03, $03, $B7, $B7, $B7
    db $03, $03, $03, $B6, $03, $03, $03, $03, $03, $03
    db $03, $03, $03, $B6, $B8, $03, $03, $03, $03, $03
    db $03, $03, $03, $B6, $03, $03, $B6, $B6, $B6, $B6
    db $B6, $B6, $B6, $B6, $03, $03, $B6, $B7, $B7, $B7
    db $B7, $B7, $B7, $B7, $03, $03, $B6, $03, $03, $03
    db $03, $03, $03, $03, $03, $03, $B7, $03, $03, $03
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlayBE::
    db $B7, $B7, $B7, $B7, $B7, $B7, $B7, $B6, $B7, $B7
    db $03, $03, $03, $03, $03, $B9, $B8, $B6, $03, $03
    db $03, $03, $B6, $03, $B9, $B9, $B9, $B6, $03, $03
    db $B6, $03, $B6, $03, $B9, $B9, $B9, $B6, $B6, $B6
    db $B7, $03, $B6, $03, $B8, $B9, $03, $B7, $B7, $B7
    db $03, $03, $B6, $03, $03, $03, $03, $03, $03, $03
    db $03, $03, $B7, $03, $03, $03, $03, $03, $03, $03
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C, $2C

RoomGBCOverlayBF::
    db $B7, $03, $B6, $B9, $B6, $03, $39, $37, $03, $38
    db $03, $03, $B7, $B9, $B7, $03, $03, $37, $03, $38
    db $03, $03, $03, $03, $03, $03, $03, $37, $09, $38
    db $B6, $03, $B6, $B8, $B6, $03, $03, $37, $03, $38
    db $B7, $B9, $B7, $B9, $B7, $B9, $03, $37, $03, $38
    db $03, $B9, $B9, $03, $B9, $B8, $03, $37, $03, $38
    db $03, $03, $03, $03, $03, $03, $03, $37, $09, $38
    db $2C, $2C, $2C, $2C, $2C, $2C, $2C, $31, $03, $38

RoomGBCOverlayC0::
    db $0E, $37, $27, $28, $F7, $0B, $F8, $27, $28, $27
    db $0E, $37, $F6, $04, $D4, $0B, $0B, $F5, $F9, $FD
    db $2B, $31, $36, $3C, $F6, $04, $0B, $44, $3D, $2F
    db $37, $F5, $F6, $2E, $2F, $48, $43, $49, $4E, $F5
    db $37, $FB, $FF, $39, $3A, $3A, $3A, $3A, $3B, $FB
    db $37, $FF, $FF, $FF, $FA, $44, $0B, $FB, $F9, $FA
    db $37, $F7, $FA, $F8, $0B, $0B, $0B, $F7, $3D, $2F
    db $2E, $2F, $2F, $48, $43, $49, $2F, $2F, $4E, $F8

RoomGBCOverlayC1::
    db $28, $27, $28, $27, $28, $27, $28, $27, $28, $27
    db $FD, $FD, $FD, $FD, $F9, $44, $FD, $FD, $F9, $F9
    db $2F, $2F, $2F, $35, $FB, $FC, $5C, $5C, $FB, $FA
    db $F9, $FF, $FA, $FD, $FA, $FA, $F9, $F9, $FC, $25
    db $FF, $FC, $5C, $5C, $5C, $E8, $F7, $FF, $FC, $27
    db $FA, $FF, $F9, $F9, $F6, $04, $3D, $35, $FE, $25
    db $35, $FB, $44, $FF, $FF, $F6, $38, $F5, $44, $27
    db $F5, $FF, $FF, $FF, $FF, $FF, $38, $F7, $FC, $25

RoomGBCOverlayC2::
    db $28, $27, $28, $27, $28, $27, $28, $27, $28, $27
    db $F9, $F9, $F9, $F9, $F9, $FA, $44, $F9, $F9, $F9
    db $FA, $FF, $44, $FF, $F8, $04, $F7, $FA, $FA, $F8
    db $26, $F7, $FA, $F8, $04, $25, $26, $25, $26, $25
    db $28, $25, $26, $E8, $04, $27, $28, $27, $28, $27
    db $26, $27, $28, $E8, $E8, $E8, $F5, $F9, $F9, $FD
    db $28, $F5, $F6, $04, $04, $F5, $FF, $FF, $F8, $25
    db $26, $FB, $FC, $04, $04, $FB, $FF, $FC, $25, $2A

RoomGBCOverlayC3::
    db $28, $27, $28, $27, $28, $27, $29, $26, $25, $26
    db $FD, $FD, $F9, $F9, $F9, $F6, $27, $28, $27, $29
    db $04, $04, $F7, $44, $FA, $FF, $F6, $04, $04, $27
    db $26, $25, $26, $FE, $5C, $FB, $44, $F6, $5C, $25
    db $28, $27, $28, $FB, $F9, $FF, $FA, $FF, $F6, $27
    db $FD, $F9, $F9, $FF, $44, $FC, $5C, $FB, $F8, $25
    db $26, $F7, $FA, $FA, $FF, $FF, $F9, $F8, $04, $27
    db $29, $26, $25, $26, $2B, $2C, $2C, $2C, $2D, $25

RoomGBCOverlayC4::
    db $25, $2A, $29, $26, $0A, $0A, $0A, $0A, $27, $28
    db $2A, $28, $27, $28, $0A, $0A, $0A, $0A, $0A, $0A
    db $28, $0A, $D4, $0A, $0A, $1A, $10, $10, $10, $10
    db $26, $0A, $0A, $0A, $1A, $16, $E8, $D4, $04, $04
    db $29, $26, $E8, $0A, $12, $04, $13, $0F, $0F, $25
    db $2A, $28, $6E, $1A, $16, $04, $11, $D4, $1B, $27
    db $28, $E8, $0A, $12, $04, $D4, $11, $1B, $1B, $1B
    db $26, $0A, $0A, $12, $04, $04, $15, $10, $10, $10

RoomGBCOverlayC5::
    db $39, $3A, $3A, $3A, $3A, $3A, $E0, $3A, $3A, $3A
    db $0A, $0A, $0A, $0A, $25, $26, $0A, $0A, $0A, $0A
    db $10, $19, $D4, $0A, $27, $29, $26, $0A, $0A, $0A
    db $04, $15, $10, $10, $19, $27, $28, $D4, $6E, $25
    db $26, $0F, $14, $44, $15, $10, $10, $19, $0A, $27
    db $28, $1B, $18, $14, $04, $20, $D4, $11, $0A, $25
    db $1B, $1B, $1B, $12, $D4, $13, $0F, $17, $0A, $27
    db $19, $1B, $1B, $12, $44, $11, $0A, $0A, $0A, $25

RoomGBCOverlayC6::
    db $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A, $3A
    db $0A, $0A, $0A, $0A, $0A, $6E, $0A, $6F, $0A, $6E
    db $0A, $0A, $2B, $2C, $2C, $2D, $0A, $5C, $0A, $0A
    db $26, $0A, $2E, $2F, $2F, $4E, $0A, $0A, $0A, $6E
    db $28, $0A, $39, $E1, $3A, $3B, $6E, $6E, $6E, $6E
    db $26, $0A, $6E, $0A, $D3, $D3, $D3, $D3, $D3, $D3
    db $28, $0A, $6E, $5C, $5C, $5C, $5C, $5C, $5C, $0A
    db $26, $0A, $6E, $D3, $D3, $D3, $0A, $D3, $D3, $D3

RoomGBCOverlayC7::
    db $3A, $3A, $3A, $3B, $D3, $D3, $D3, $6E, $FB, $37
    db $D3, $5C, $D3, $D3, $5C, $5C, $5C, $6E, $FE, $37
    db $0A, $5C, $D3, $D3, $5C, $D3, $5C, $6E, $FC, $37
    db $D3, $5C, $5C, $5C, $5C, $5C, $5C, $6E, $FB, $37
    db $D3, $D3, $D3, $D3, $D3, $D3, $5C, $6E, $FE, $37
    db $D3, $D3, $5C, $5C, $5C, $D3, $5C, $6E, $FC, $37
    db $0A, $5C, $D3, $D3, $5C, $D3, $5C, $6E, $FC, $37
    db $D3, $0A, $D3, $D3, $0A, $D3, $0A, $6E, $FB, $37

RoomGBCOverlayC8::
    db $03, $27, $28, $09, $09, $38, $0A, $6E, $FE, $6E
    db $03, $09, $03, $3D, $2F, $4E, $0A, $FA, $FA, $F9
    db $09, $04, $09, $38, $3A, $3B, $6E, $6E, $04, $F7
    db $3D, $2F, $2F, $4E, $0A, $0A, $F6, $04, $3D, $2F
    db $38, $3A, $E1, $3B, $0A, $FF, $F8, $04, $38, $0E
    db $38, $0A, $0A, $0A, $0A, $FC, $04, $04, $38, $0E
    db $38, $0A, $0A, $0A, $FF, $FC, $04, $3D, $4E, $0E
    db $38, $0A, $0A, $FF, $FF, $F8, $04, $38, $3F, $0E

RoomGBCOverlayC9::
    db $6E, $04, $6E, $04, $F7, $F8, $38, $0E, $0E, $0E
    db $F6, $04, $04, $3D, $2F, $2F, $34, $CA, $0E, $0E
    db $FC, $04, $F5, $38, $0E, $0E, $0E, $0E, $0E, $0E
    db $48, $E0, $49, $34, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
    db $0E, $0E, $CA, $0E, $0E, $51, $0E, $0E, $0E, $0E
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E

RoomGBCOverlayCA::
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $0A, $27
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $FC, $25
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $FE, $27
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $F8, $25
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04, $27
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04, $25
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04, $27
    db $0E, $0E, $0E, $0E, $0E, $0E, $0E, $37, $04, $25

RoomGBCOverlayCB::
    db $28, $0A, $FF, $FF, $FA, $FF, $44, $0A, $0A, $2E
    db $26, $44, $0A, $F8, $04, $F7, $0A, $0A, $0A, $39
    db $28, $0A, $F8, $5C, $F5, $F6, $5C, $25, $26, $04
    db $26, $FE, $04, $F5, $FF, $FF, $F6, $27, $29, $26
    db $28, $0A, $F6, $F7, $FF, $44, $F8, $D4, $27, $28
    db $26, $0A, $0A, $5C, $FB, $F8, $5C, $F5, $44, $FC
    db $28, $0A, $0A, $0A, $F8, $04, $F5, $44, $25, $26
    db $26, $0A, $0A, $FC, $04, $F5, $FF, $FC, $27, $28

; Unused, padding
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    db $00, $00, $00, $00
