; Array indexed by entity type, see ENTITY_* constants
;
; bits 0-3: number of allocated sprites in OAM memory,
; bit 4: display shadow on posZ > 0 if set (ENTITY_PHYSICS_SHADOW),
; bit 5: item can be picked up (ENTITY_PHYSICS_GRABBABLE),
; bit 6: doesn't react to projectiles if set (arrow, hookshot, etc.) (ENTITY_PHYSICS_PROJECTILE_NOCLIP),
; bit 7: doesn't hurt Link on collision if set (ENTITY_PHYSICS_HARMLESS)
;
; See wEntitiesPhysicsFlagsTable
PhysicsFlagsForEntity::
._00 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._01 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._02 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._03 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._04 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._05 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
IF __PATCH_0__
; Bug: With this patch you can fire a projectile through a pushable
; block while it moves into its new position
._06 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_GRABBABLE
ELSE
._06 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
ENDC
._07 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._08 db 3 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._09 db 2 | ENTITY_PHYSICS_SHADOW
._0A db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._0B db 2 | ENTITY_PHYSICS_SHADOW
._0C db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._0D db 2 | ENTITY_PHYSICS_SHADOW
._0E db 2 | ENTITY_PHYSICS_SHADOW
._0F db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._10 db 2 | ENTITY_PHYSICS_SHADOW
._11 db 8 | ENTITY_PHYSICS_SHADOW
._12 db 2 | ENTITY_PHYSICS_SHADOW
._13 db 1 | ENTITY_PHYSICS_SHADOW
._14 db 2 | ENTITY_PHYSICS_SHADOW
._15 db 2
._16 db 2
._17 db 2
._18 db 2 | ENTITY_PHYSICS_SHADOW
._19 db 2
._1A db 2 | ENTITY_PHYSICS_SHADOW
._1B db 2 | ENTITY_PHYSICS_SHADOW
._1C db 1 | ENTITY_PHYSICS_SHADOW
._1D db 2
._1E db 2 | ENTITY_PHYSICS_SHADOW
._1F db 2 | ENTITY_PHYSICS_SHADOW
._20 db 2 | ENTITY_PHYSICS_SHADOW
._21 db 2
._22 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._23 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._24 db 2 | ENTITY_PHYSICS_SHADOW
._25 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_GRABBABLE
._26 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_GRABBABLE
._27 db 2
._28 db 2 | ENTITY_PHYSICS_SHADOW
._29 db 2
._2A db 2
._2B db 1 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._2C db 2 | ENTITY_PHYSICS_SHADOW
._2D db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._2E db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._2F db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._30 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._31 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._32 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._33 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._34 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._35 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._36 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._37 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._38 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._39 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._3A db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._3B db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._3C db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._3D db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._3E db 2 | ENTITY_PHYSICS_HARMLESS
._3F db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._40 db 4 | ENTITY_PHYSICS_HARMLESS
._41 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._42 db 2 | ENTITY_PHYSICS_HARMLESS
._43 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._44 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._45 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._46 db 2 | ENTITY_PHYSICS_HARMLESS
._47 db 2 | ENTITY_PHYSICS_HARMLESS
._48 db 2 | ENTITY_PHYSICS_HARMLESS
._49 db 2 | ENTITY_PHYSICS_HARMLESS
IF __PATCH_0__
; Fixes two bugs with the Color Dungeon Book in the library:
; - Link can no longer try to pick it up
; - It no longer casts a weird shadow
; However, it also introduces a new bug:
; - Projectiles now bounce off it instead of passing "over" it
._4A db 2 | ENTITY_PHYSICS_HARMLESS
ELSE
._4A db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_GRABBABLE | ENTITY_PHYSICS_SHADOW
ENDC
._4B db 2 | ENTITY_PHYSICS_HARMLESS
._4C db 1 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._4D db 2 | ENTITY_PHYSICS_HARMLESS
._4E db 2 | ENTITY_PHYSICS_HARMLESS
._4F db 2 | ENTITY_PHYSICS_HARMLESS
._50 db 2 | ENTITY_PHYSICS_SHADOW
._51 db 2
._52 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._53 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._54 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._55 db 2
._56 db 2
._57 db 2
._58 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._59 db 8
._5A db 8 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._5B db 0
._5C db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._5D db 2
._5E db 0
._5F db 0
._60 db 2
._61 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._62 db 8
._63 db 2
._64 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._65 db 0
._66 db 2 | ENTITY_PHYSICS_HARMLESS
._67 db 2
._68 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._69 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._6A db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._6B db 2 | ENTITY_PHYSICS_HARMLESS
._6C db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._6D db 2 | ENTITY_PHYSICS_SHADOW
._6E db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._6F db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._70 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._71 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._72 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._73 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._74 db 3 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._75 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._76 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._77 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._78 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._79 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._7A db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._7B db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._7C db 0
._7D db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._7E db 2
._7F db 2 | ENTITY_PHYSICS_HARMLESS
._80 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._81 db 0
._82 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._83 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._84 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._85 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._86 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._87 db 2 | ENTITY_PHYSICS_SHADOW
._88 db 4 | ENTITY_PHYSICS_HARMLESS
._89 db $C
._8A db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._8B db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._8C db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._8D db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._8E db 8
._8F db 2 | ENTITY_PHYSICS_SHADOW
._90 db 2 | ENTITY_PHYSICS_SHADOW
._91 db 3 | ENTITY_PHYSICS_SHADOW
._92 db 4 | ENTITY_PHYSICS_SHADOW
._93 db 2 | ENTITY_PHYSICS_SHADOW
._94 db 0 | ENTITY_PHYSICS_HARMLESS
._95 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._96 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._97 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._98 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._99 db 2 | ENTITY_PHYSICS_SHADOW
._9A db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._9B db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._9C db 2 | ENTITY_PHYSICS_SHADOW
._9D db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._9E db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._9F db 2 | ENTITY_PHYSICS_SHADOW
._A0 db 2 | ENTITY_PHYSICS_SHADOW
._A1 db 2 | ENTITY_PHYSICS_SHADOW
._A2 db 4 | ENTITY_PHYSICS_SHADOW
._A3 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._A4 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._A5 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._A6 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._A7 db $A | ENTITY_PHYSICS_HARMLESS
._A8 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._A9 db 2
._AA db 2 | ENTITY_PHYSICS_SHADOW
._AB db 2 | ENTITY_PHYSICS_SHADOW
._AC db 2 | ENTITY_PHYSICS_SHADOW
._AD db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._AE db 2 | ENTITY_PHYSICS_SHADOW
._AF db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_GRABBABLE
._B0 db 2
._B1 db 2 | ENTITY_PHYSICS_HARMLESS
._B2 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._B3 db 2 | ENTITY_PHYSICS_HARMLESS
._B4 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._B5 db 2 | ENTITY_PHYSICS_HARMLESS
._B6 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._B7 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._B8 db 5 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._B9 db 2 | ENTITY_PHYSICS_SHADOW
._BA db 3 | ENTITY_PHYSICS_SHADOW
._BB db 2 | ENTITY_PHYSICS_SHADOW
._BC db 2 | ENTITY_PHYSICS_SHADOW
._BD db 3 | ENTITY_PHYSICS_SHADOW
._BE db 6 | ENTITY_PHYSICS_SHADOW
._BF db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._C0 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._C1 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._C2 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._C3 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._C4 db 8 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._C5 db 2 | ENTITY_PHYSICS_SHADOW
._C6 db 2 | ENTITY_PHYSICS_SHADOW
._C7 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._C8 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._C9 db 1 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._CA db 8 | ENTITY_PHYSICS_HARMLESS
._CB db 2
._CC db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._CD db 5 | ENTITY_PHYSICS_HARMLESS
._CE db 4 | ENTITY_PHYSICS_HARMLESS
._CF db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._D0 db 2 | ENTITY_PHYSICS_HARMLESS
._D1 db 2 | ENTITY_PHYSICS_HARMLESS
._D2 db 2 | ENTITY_PHYSICS_HARMLESS
._D3 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._D4 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._D5 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._D6 db 2 | ENTITY_PHYSICS_HARMLESS
._D7 db 2
._D8 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._D9 db 8 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._DA db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._DB db 8 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._DC db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._DD db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._DE db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._DF db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._E0 db 3 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._E1 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._E2 db 2 | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._E3 db 2 | ENTITY_PHYSICS_SHADOW
._E4 db 3 | ENTITY_PHYSICS_SHADOW
._E5 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._E6 db 0 | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_SHADOW
._E7 db 0 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._E8 db 0
._E9 db 3 | ENTITY_PHYSICS_SHADOW
._EA db 3 | ENTITY_PHYSICS_SHADOW
._EB db 3 | ENTITY_PHYSICS_SHADOW
._EC db 4 | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_GRABBABLE
._ED db 4 | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_GRABBABLE
._EE db 4 | ENTITY_PHYSICS_SHADOW | ENTITY_PHYSICS_PROJECTILE_NOCLIP | ENTITY_PHYSICS_GRABBABLE
._EF db 2 | ENTITY_PHYSICS_HARMLESS
._F0 db 2 | ENTITY_PHYSICS_HARMLESS
._F1 db 2 | ENTITY_PHYSICS_HARMLESS
._F2 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._F3 db 4 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_SHADOW
._F4 db $C
._F5 db 2 | ENTITY_PHYSICS_HARMLESS | ENTITY_PHYSICS_PROJECTILE_NOCLIP
._F6 db 2 | ENTITY_PHYSICS_HARMLESS
._F7 db 2 | ENTITY_PHYSICS_HARMLESS
._F8 db 6
._F9 db $C
._FA db 3 | ENTITY_PHYSICS_HARMLESS
