; Gameplay-related enums values

; Constants

DEF NAME_LENGTH                EQU 5

; Values for wGameplayType
DEF GAMEPLAY_INTRO             EQU $00
DEF GAMEPLAY_CREDITS           EQU $01
DEF GAMEPLAY_FILE_SELECT       EQU $02
DEF GAMEPLAY_FILE_NEW          EQU $03
DEF GAMEPLAY_FILE_DELETE       EQU $04
DEF GAMEPLAY_FILE_COPY         EQU $05
DEF GAMEPLAY_FILE_SAVE         EQU $06
DEF GAMEPLAY_WORLD_MAP         EQU $07
DEF GAMEPLAY_CUTSCENE          EQU $08
DEF GAMEPLAY_MARIN_BEACH       EQU $09
DEF GAMEPLAY_WF_MURAL          EQU $0A
DEF GAMEPLAY_WORLD             EQU $0B
DEF GAMEPLAY_INVENTORY         EQU $0C
DEF GAMEPLAY_PHOTO_ALBUM       EQU $0D
DEF GAMEPLAY_PHOTO_DIZZY_LINK  EQU $0E
DEF GAMEPLAY_PHOTO_NICE_LINK   EQU $0F
DEF GAMEPLAY_PHOTO_MARIN_CLIFF EQU $10
DEF GAMEPLAY_PHOTO_MARIN_WELL  EQU $11
DEF GAMEPLAY_PHOTO_MABE        EQU $12
DEF GAMEPLAY_PHOTO_ULRIRA      EQU $13
DEF GAMEPLAY_PHOTO_BOW_WOW     EQU $14
DEF GAMEPLAY_PHOTO_THIEF       EQU $15
DEF GAMEPLAY_PHOTO_FISHERMAN   EQU $16
DEF GAMEPLAY_PHOTO_ZORA        EQU $17
DEF GAMEPLAY_PHOTO_KANALET     EQU $18
DEF GAMEPLAY_PHOTO_GHOST       EQU $19
DEF GAMEPLAY_PHOTO_BRIDGE      EQU $1A

; Values for wGameplaySubtype
; (depends on the gameplay type)
; GAMEPLAY_INTRO Subtype
DEF GAMEPLAY_INTRO_SEA         EQU $03
DEF GAMEPLAY_INTRO_LINK_FACE   EQU $04
DEF GAMEPLAY_INTRO_LIGHTNING   EQU $05
DEF GAMEPLAY_INTRO_BEACH       EQU $07
DEF GAMEPLAY_INTRO_TITLE       EQU $0B

; GAMEPLAY_FILE_SAVE Subtype
DEF GAMEPLAY_FILE_SAVE_INITIAL      EQU $00
DEF GAMEPLAY_FILE_SAVE_MAP_FADE_OUT EQU $01
DEF GAMEPLAY_FILE_SAVE_DELAY1       EQU $02
DEF GAMEPLAY_FILE_SAVE_DELAY2       EQU $03
DEF GAMEPLAY_FILE_SAVE_VISIBLE      EQU $04
DEF GAMEPLAY_FILE_SAVE_INTERACTIVE  EQU $05
DEF GAMEPLAY_FILE_SAVE_FADE_OUT     EQU $06

; GAMEPLAY_WORLD Subtype
DEF GAMEPLAY_WORLD_LOAD_0           EQU $00
DEF GAMEPLAY_WORLD_LOAD_1           EQU $01
DEF GAMEPLAY_WORLD_LOAD_2           EQU $02
DEF GAMEPLAY_WORLD_LOAD_3           EQU $03
DEF GAMEPLAY_WORLD_LOAD_4           EQU $04
DEF GAMEPLAY_WORLD_LOAD_5           EQU $05
DEF GAMEPLAY_WORLD_LOAD_6           EQU $06
DEF GAMEPLAY_WORLD_INTERACTIVE      EQU $07

; GAMEPLAY_INVENTORY Subtype
DEF GAMEPLAY_INVENTORY_INITIAL      EQU $00
DEF GAMEPLAY_INVENTORY_MAP_FADE_OUT EQU $01
DEF GAMEPLAY_INVENTORY_DELAY1       EQU $02
DEF GAMEPLAY_INVENTORY_DELAY2       EQU $03
DEF GAMEPLAY_INVENTORY_DELAY3       EQU $04
DEF GAMEPLAY_INVENTORY_DELAY4       EQU $05
DEF GAMEPLAY_INVENTORY_DELAY5       EQU $06
DEF GAMEPLAY_INVENTORY_FADE_IN      EQU $07
DEF GAMEPLAY_INVENTORY_INTERACTIVE  EQU $08
DEF GAMEPLAY_INVENTORY_STATUS_IN    EQU $09
DEF GAMEPLAY_INVENTORY_STATUS       EQU $0A
DEF GAMEPLAY_INVENTORY_STATUS_OUT   EQU $0B
DEF GAMEPLAY_INVENTORY_FADE_OUT     EQU $0C

; Identifiers of entities during Intro sequence
DEF ENTITY_INTRO_SHIP          EQU $05
DEF ENTITY_INTRO_MARIN         EQU $06
DEF ENTITY_INTRO_INERT_LINK    EQU $07
DEF ENTITY_INTRO_SPARKLE       EQU $08

; Values for wRoomTransitionState
DEF ROOM_TRANSITION_NONE             EQU $00
DEF ROOM_TRANSITION_LOAD_ROOM        EQU $01
DEF ROOM_TRANSITION_LOAD_SPRITES     EQU $02
DEF ROOM_TRANSITION_CONFIGURE_SCROLL EQU $03
DEF ROOM_TRANSITION_FIRST_HALF       EQU $04
DEF ROOM_TRANSITION_SECOND_HALF      EQU $05

; Cooldown time after closing photo album
DEF PHOTO_ALBUM_COOLDOWN         EQU $18

; Values for wLinkMotionState
; Only the first two values are interactive
DEF LINK_MOTION_DEFAULT              EQU $00 ; ground, flying with rooster, etc
DEF LINK_MOTION_SWIMMING             EQU $01
DEF LINK_MOTION_TYPE_NON_INTERACTIVE EQU $02
DEF LINK_MOTION_UNSTUCKING           EQU $02
DEF LINK_MOTION_MAP_FADE_OUT         EQU $03
DEF LINK_MOTION_MAP_FADE_IN          EQU $04
DEF LINK_MOTION_REVOLVING_DOOR       EQU $05
DEF LINK_MOTION_FALLING_DOWN         EQU $06
DEF LINK_MOTION_PASS_OUT             EQU $07
DEF LINK_MOTION_RECOVER              EQU $08
DEF LINK_MOTION_TELEPORT             EQU $09
DEF LINK_MOTION_UNKNOWN_0A           EQU $0A ; sliding? used with blaino

; Values for hLinkAnimationState
DEF LINK_ANIMATION_STATE_STANDING_DOWN                     EQU $00
DEF LINK_ANIMATION_STATE_WALKING_DOWN                      EQU $01
DEF LINK_ANIMATION_STATE_UNKNOWN_02                        EQU $02
DEF LINK_ANIMATION_STATE_UNKNOWN_03                        EQU $03
DEF LINK_ANIMATION_STATE_STANDING_UP                       EQU $04
DEF LINK_ANIMATION_STATE_WALKING_UP                        EQU $05
DEF LINK_ANIMATION_STATE_STANDING_LEFT                     EQU $06
DEF LINK_ANIMATION_STATE_WALKING_LEFT                      EQU $07
DEF LINK_ANIMATION_STATE_UNKNOWN_08                        EQU $08
DEF LINK_ANIMATION_STATE_UNKNOWN_09                        EQU $09
DEF LINK_ANIMATION_STATE_STANDING_RIGHT                    EQU $0A
DEF LINK_ANIMATION_STATE_WALKING_RIGHT                     EQU $0B
DEF LINK_ANIMATION_STATE_HOOKSHOT_CHAIN_DOWN               EQU $0E
DEF LINK_ANIMATION_STATE_HOOKSHOT_CHAIN_UP                 EQU $0F
DEF LINK_ANIMATION_STATE_HOOKSHOT_CHAIN_LEFT               EQU $10
DEF LINK_ANIMATION_STATE_HOOKSHOT_CHAIN_RIGHT              EQU $11
DEF LINK_ANIMATION_STATE_UNKNOWN_12                        EQU $12
DEF LINK_ANIMATION_STATE_UNKNOWN_13                        EQU $13
DEF LINK_ANIMATION_STATE_UNKNOWN_14                        EQU $14
DEF LINK_ANIMATION_STATE_UNKNOWN_15                        EQU $15
DEF LINK_ANIMATION_STATE_UNKNOWN_16                        EQU $16
DEF LINK_ANIMATION_STATE_UNKNOWN_17                        EQU $17
DEF LINK_ANIMATION_STATE_UNKNOWN_18                        EQU $18
DEF LINK_ANIMATION_STATE_UNKNOWN_19                        EQU $19
DEF LINK_ANIMATION_STATE_STANDING_PUSHING_DOWN             EQU $1A
DEF LINK_ANIMATION_STATE_WALKING_PUSHING_DOWN              EQU $1B
DEF LINK_ANIMATION_STATE_STANDING_PUSHING_UP               EQU $1C
DEF LINK_ANIMATION_STATE_WALKING_PUSHING_UP                EQU $1D
DEF LINK_ANIMATION_STATE_STANDING_PUSHING_LEFT             EQU $1E
DEF LINK_ANIMATION_STATE_WALKING_PUSHING_LEFT              EQU $1F
DEF LINK_ANIMATION_STATE_STANDING_PUSHING_RIGHT            EQU $20
DEF LINK_ANIMATION_STATE_WALKING_PUSHING_RIGHT             EQU $21
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_DOWN              EQU $22
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_DOWN               EQU $23
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_USE_DOWN          EQU $24
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_USE_DOWN           EQU $25
DEF LINK_ANIMATION_STATE_STANDING_MIRROR_SHIELD_USE_DOWN   EQU $26
DEF LINK_ANIMATION_STATE_WALKING_MIRROR_SHIELD_USE_DOWN    EQU $27
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_USE_LEFT          EQU $28
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_USE_LEFT           EQU $29
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_USE_RIGHT         EQU $2A
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_USE_RIGHT          EQU $2B
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_RIGHT             EQU $2C
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_RIGHT              EQU $2D
DEF LINK_ANIMATION_STATE_STANDING_MIRROR_SHIELD_RIGHT      EQU $2E
DEF LINK_ANIMATION_STATE_WALKING_MIRROR_SHIELD_RIGHT       EQU $2F
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_USE_UP            EQU $30
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_USE_UP             EQU $31
DEF LINK_ANIMATION_STATE_STANDING_MIRROR_SHIELD_USE_UP     EQU $32
DEF LINK_ANIMATION_STATE_WALKING_MIRROR_SHIELD_USE_UP      EQU $33
DEF LINK_ANIMATION_STATE_STANDING_SHIELD_UP                EQU $34
DEF LINK_ANIMATION_STATE_WALKING_SHIELD_UP                 EQU $35
DEF LINK_ANIMATION_STATE_GRABBING_RIGHT                    EQU $36
DEF LINK_ANIMATION_STATE_PULLING_RIGHT                     EQU $37
DEF LINK_ANIMATION_STATE_GRABBING_LEFT                     EQU $38
DEF LINK_ANIMATION_STATE_PULLING_LEFT                      EQU $39
DEF LINK_ANIMATION_STATE_GRABBING_UP                       EQU $3A
DEF LINK_ANIMATION_STATE_PULLING_UP                        EQU $3B
DEF LINK_ANIMATION_STATE_GRABBING_DOWN                     EQU $3C
DEF LINK_ANIMATION_STATE_PULLING_DOWN                      EQU $3D
DEF LINK_ANIMATION_STATE_STANDING_LIFTING_RIGHT            EQU $3E
DEF LINK_ANIMATION_STATE_WALKING_LIFTING_RIGHT             EQU $3F
DEF LINK_ANIMATION_STATE_STANDING_LIFTING_LEFT             EQU $40
DEF LINK_ANIMATION_STATE_WALKING_LIFTING_LEFT              EQU $41
DEF LINK_ANIMATION_STATE_STANDING_LIFTING_UP               EQU $42
DEF LINK_ANIMATION_STATE_WALKING_LIFTING_UP                EQU $43
DEF LINK_ANIMATION_STATE_STANDING_LIFTING_DOWN             EQU $44
DEF LINK_ANIMATION_STATE_WALKING_LIFTING_DOWN              EQU $45
DEF LINK_ANIMATION_STATE_HOLD_SWIMMING_1_RIGHT             EQU $46
DEF LINK_ANIMATION_STATE_MOVING_SWIMMING_1_RIGHT           EQU $47
DEF LINK_ANIMATION_STATE_HOLD_SWIMMING_1_LEFT              EQU $48
DEF LINK_ANIMATION_STATE_MOVING_SWIMMING_1_LEFT            EQU $49
DEF LINK_ANIMATION_STATE_HOLD_SWIMMING_1_UP                EQU $4A
DEF LINK_ANIMATION_STATE_MOVING_SWIMMING_1_UP              EQU $4B
DEF LINK_ANIMATION_STATE_HOLD_SWIMMING_1_DOWN              EQU $4C
DEF LINK_ANIMATION_STATE_MOVING_SWIMMING_1_DOWN            EQU $4D
DEF LINK_ANIMATION_STATE_HOLD_SWIMMING_2                   EQU $4E
DEF LINK_ANIMATION_STATE_MOVING_SWIMMING_2                 EQU $4F
DEF LINK_ANIMATION_STATE_UNKNOWN_50                        EQU $50
DEF LINK_ANIMATION_STATE_UNKNOWN_51                        EQU $51
DEF LINK_ANIMATION_STATE_UNKNOWN_52                        EQU $52
DEF LINK_ANIMATION_STATE_UNKNOWN_53                        EQU $53
DEF LINK_ANIMATION_STATE_UNKNOWN_54                        EQU $54
DEF LINK_ANIMATION_STATE_FALLING_PIT_1                     EQU $55
DEF LINK_ANIMATION_STATE_FALLING_PIT_2                     EQU $56
DEF LINK_ANIMATION_STATE_FALLING_PIT_3                     EQU $57
DEF LINK_ANIMATION_STATE_STANDING_SIDE_SCROLL_LEFT_DOWN    EQU $58
DEF LINK_ANIMATION_STATE_WALKING_SIDE_SCROLL_LEFT_DOWN     EQU $59
DEF LINK_ANIMATION_STATE_STANDING_SIDE_SCROLL_RIGHT_UP     EQU $5B
DEF LINK_ANIMATION_STATE_WALKING_SIDE_SCROLL_RIGHT_UP      EQU $5C
DEF LINK_ANIMATION_STATE_JUMPING_1                         EQU $5E
DEF LINK_ANIMATION_STATE_JUMPING_2                         EQU $5F
DEF LINK_ANIMATION_STATE_JUMPING_3                         EQU $60
DEF LINK_ANIMATION_STATE_UNKNOWN_61                        EQU $61
DEF LINK_ANIMATION_STATE_UNKNOWN_62                        EQU $62
DEF LINK_ANIMATION_STATE_UNKNOWN_63                        EQU $63
DEF LINK_ANIMATION_STATE_UNKNOWN_64                        EQU $64
DEF LINK_ANIMATION_STATE_UNKNOWN_65                        EQU $65
DEF LINK_ANIMATION_STATE_UNKNOWN_66                        EQU $66
DEF LINK_ANIMATION_STATE_UNKNOWN_67                        EQU $67
DEF LINK_ANIMATION_STATE_UNKNOWN_68                        EQU $68
DEF LINK_ANIMATION_STATE_UNKNOWN_69                        EQU $69
DEF LINK_ANIMATION_STATE_UNKNOWN_6A                        EQU $6A
DEF LINK_ANIMATION_STATE_UNKNOWN_6B                        EQU $6B
DEF LINK_ANIMATION_STATE_GOT_ITEM                          EQU $6C
DEF LINK_ANIMATION_STATE_UNKNOWN_75                        EQU $75
DEF LINK_ANIMATION_STATE_HIDDEN                            EQU $FF

; Values for wSwordDirection
DEF SWORD_DIRECTION_RIGHT        EQU $00
DEF SWORD_DIRECTION_RIGHT_BOTTOM EQU $01
DEF SWORD_DIRECTION_BOTTOM       EQU $02
DEF SWORD_DIRECTION_LEFT_BOTTOM  EQU $03
DEF SWORD_DIRECTION_LEFT         EQU $04
DEF SWORD_DIRECTION_LEFT_TOP     EQU $05
DEF SWORD_DIRECTION_TOP          EQU $06
DEF SWORD_DIRECTION_RIGHT_TOP    EQU $07

; Values for wSwordAnimationState
DEF SWORD_ANIMATION_STATE_NONE         EQU $00
DEF SWORD_ANIMATION_STATE_DRAW         EQU $01
DEF SWORD_ANIMATION_STATE_SWING_START  EQU $02
DEF SWORD_ANIMATION_STATE_SWING_MIDDLE EQU $03
DEF SWORD_ANIMATION_STATE_SWING_END    EQU $04
DEF SWORD_ANIMATION_STATE_HOLDING      EQU $05

; Charge amount needed for spin attack
DEF MAX_SWORD_CHARGE          EQU $28
; using spin attack max value
DEF USING_SPIN_ATTACK_MAX     EQU $20

; Charge amount needed to run
DEF MAX_PEGASUS_BOOTS_CHARGE  EQU $20

; Values for wLinkGroundStatus
DEF GROUND_STATUS_NORMAL  EQU $00
DEF GROUND_STATUS_STEPS   EQU $01
DEF GROUND_STATUS_SLOW    EQU $03 ; wet or grassy
DEF GROUND_STATUS_PIT     EQU $07

; Maximum number of frames during which the player can
; slip over a pit without falling into it.
DEF PIT_MAX_SLIPPING       EQU 24

; Values for wTransitionGfx
DEF TRANSITION_GFX_NONE         EQU $00 ; no transition
DEF TRANSITION_GFX_DREAM_SHRINE EQU $01 ; wavy transition when sleeping in the Dream Shrine
DEF TRANSITION_GFX_MANBO_IN     EQU $02 ; wavy transition when departing using Manbo's Mambo
DEF TRANSITION_GFX_MANBO_OUT    EQU $03 ; wavy transition when arriving using Manbo's Mambo
DEF TRANSITION_GFX_FLOATING     EQU $FE ; slow up-and-down motion
DEF TRANSITION_GFX_WIND_FISH    EQU $FF ; wavy transition when the Wind Fish appears and disappears

; Chest content
; @TODO Some marked "unused" aren't used in actual chest tables,
; but may be used in other events
DEF CHEST_POWER_BRACELET   EQU $00
DEF CHEST_SHIELD           EQU $01
DEF CHEST_BOW              EQU $02 ; POI: Unused
DEF CHEST_HOOKSHOT         EQU $03 ; Unused?
DEF CHEST_MAGIC_ROD        EQU $04
DEF CHEST_PEGASUS_BOOTS    EQU $05
DEF CHEST_OCARINA          EQU $06
DEF CHEST_FEATHER          EQU $07
DEF CHEST_SHOVEL           EQU $08 ; POI: Unused
DEF CHEST_MAGIC_POWDER_BAG EQU $09 ; Unused?
DEF CHEST_BOMB             EQU $0A
DEF CHEST_SWORD            EQU $0B ; Unused?
DEF CHEST_FLIPPERS         EQU $0C
DEF CHEST_MAGNIFYING_LENS  EQU $0D ; Unused?
DEF CHEST_MEDICINE         EQU $10
DEF CHEST_TAIL_KEY         EQU $11
DEF CHEST_ANGLER_KEY       EQU $12 ; Unused?
DEF CHEST_FACE_KEY         EQU $13 ; Unused?
DEF CHEST_BIRD_KEY         EQU $14 ; Unused?
DEF CHEST_GOLD_LEAF        EQU $15 ; Unused?
; Dungeon items
DEF CHEST_MAP              EQU $16
DEF CHEST_COMPASS          EQU $17
DEF CHEST_STONE_BEAK       EQU $18
DEF CHEST_NIGHTMARE_KEY    EQU $19
DEF CHEST_SMALL_KEY        EQU $1A
; Treasure
DEF CHEST_RUPEES_50        EQU $1B
DEF CHEST_RUPEES_20        EQU $1C
DEF CHEST_RUPEES_100       EQU $1D
DEF CHEST_RUPEES_200       EQU $1E
DEF CHEST_RUPEES_500       EQU $1F ; POI: Unused
DEF CHEST_SEASHELL         EQU $20
; Miscellaneous
DEF CHEST_MESSAGE          EQU $21 ; used in Catfish's Maw
DEF CHEST_ZOL              EQU $22 ; green slime enemy

; Values for wTradeSequenceItem
DEF TRADING_ITEM_NONE              EQU $00
DEF TRADING_ITEM_YOSHI_DOLL        EQU $01
DEF TRADING_ITEM_RIBBON            EQU $02
DEF TRADING_ITEM_DOG_FOOD          EQU $03
DEF TRADING_ITEM_BANANAS           EQU $04
DEF TRADING_ITEM_STICK             EQU $05
DEF TRADING_ITEM_HONEYCOMB         EQU $06
DEF TRADING_ITEM_PINEAPPLE         EQU $07
DEF TRADING_ITEM_HIBISCUS          EQU $08
DEF TRADING_ITEM_LETTER            EQU $09
DEF TRADING_ITEM_BROOM             EQU $0A
DEF TRADING_ITEM_FISHING_HOOK      EQU $0B
DEF TRADING_ITEM_NECKLACE          EQU $0C
DEF TRADING_ITEM_SCALE             EQU $0D
DEF TRADING_ITEM_MAGNIFYING_LENS   EQU $0E

; Values for hRoomStatus and wOverworldRoomStatus
;
; Flags can be combined. For example, visiting the first dungeon's screen (80)
; and opening it with the key (10) would put that byte at 90.
DEF ROOM_STATUS_NONE            EQU $00
DEF ROOM_STATUS_DOOR_OPEN_RIGHT EQU $01
DEF ROOM_STATUS_DOOR_OPEN_LEFT  EQU $02
DEF ROOM_STATUS_DOOR_OPEN_UP    EQU $04
DEF ROOM_STATUS_DOOR_OPEN_DOWN  EQU $08
DEF ROOM_STATUS_EVENT_1         EQU $10
DEF ROOM_STATUS_EVENT_2         EQU $20
DEF ROOM_STATUS_EVENT_3         EQU $40
DEF ROOM_STATUS_VISITED         EQU $80

; Value for wOverworldRoomStatus (and similar constants)
;
; Flags can be combined. For example, visiting the first dungeon's screen (80)
; and opening it with the key (10) would put that byte at 90.
DEF OW_ROOM_STATUS_UNVISITED    EQU $00
DEF OW_ROOM_STATUS_OPENED       EQU $04 ; door or bombable entrance opened
DEF OW_ROOM_STATUS_CHANGED      EQU $10 ; e.g. sword taken on the beach
DEF OW_ROOM_STATUS_OWL_TALKED   EQU $20
DEF OW_ROOM_STATUS_UNKNOWN      EQU $40
DEF OW_ROOM_STATUS_VISITED      EQU $80

DEF OW_ROOM_STATUS_FLAG_UNVISITED    EQU 0
DEF OW_ROOM_STATUS_FLAG_OPENED       EQU 2 ; door or bombable entrance opened
DEF OW_ROOM_STATUS_FLAG_CHANGED      EQU 4 ; e.g. sword taken on the beach
DEF OW_ROOM_STATUS_FLAG_OWL_TALKED   EQU 5
DEF OW_ROOM_STATUS_FLAG_UNKNOWN_6    EQU 6
DEF OW_ROOM_STATUS_FLAG_VISITED      EQU 7

; Values for hStaircase
DEF STAIRCASE_NONE     EQU $00 ; no staircase in the room
DEF STAIRCASE_INACTIVE EQU $01 ; staircase in the room, but can't be used yet (e.g. when Link just landed on top of it)
DEF STAIRCASE_ACTIVE   EQU $02 ; staircase in the room, can be used

; Price to pay to play the Trendy game
DEF TRENDY_GAME_PRICE         EQU 10

; Price to pay to use the raft
DEF RAFT_GAME_PRICE           EQU 100

; Price to pay to play the fishing game
DEF FISHING_GAME_PRICE        EQU 10

; Fishing game rewards
DEF FISHING_GAME_SMALL_REWARD EQU 05
DEF FISHING_GAME_LARGE_REWARD EQU 20

; one heart equals XX health
DEF ONE_HEART EQU $08

DEF LOW_MAX_HEALTH    EQU $07
DEF MEDIUM_MAX_HEALTH EQU $0B
;HIGH_MAX_HEALTH   EQU

DEF MIN_HEARTS          EQU $03
DEF MAX_HEARTS          EQU $0E

; how much time has to pass until the player can receive damage again
DEF DAMAGE_COOLDOWN_TIME EQU $A0

; power up values
DEF POWER_UP_NONE             EQU 0
DEF POWER_UP_PIECE_OF_POWER   EQU 1
DEF POWER_UP_GUARDIAN_ACORN   EQU 2

; arrow values
DEF ARROW_MAX_ACTIVE_COUNT    EQU 2 ; maximun amount of arrows in the air
DEF BOMB_ARROW_COOLDOWN       EQU 6 ; number of frames, until bomb / arrow can be used again

; speed of the hookshot in x or y direction
DEF HOOKSHOT_CHAIN_SPEED      EQU $30

; Values for wActivePowerUp
DEF ACTIVE_POWER_UP_NONE            EQU 0
DEF ACTIVE_POWER_UP_PIECE_OF_POWER  EQU 1
DEF ACTIVE_POWER_UP_GUARDIAN_ACORN  EQU 2

DEF GUARDIAN_ACORN_COUNTER_MAX                   EQU $0C ; defines after how many random drops a guardian acorn is dropped
DEF PIECE_OF_POWER_COUNTER_MAX_LOW_MAX_HEALTH    EQU $1E ; defines after how many random drops a piece of power is dropped
DEF PIECE_OF_POWER_COUNTER_MAX_MEDIUM_MAX_HEALTH EQU $23
DEF PIECE_OF_POWER_COUNTER_MAX_HIGH_MAX_HEALTH   EQU $28

; values for wGoldenLeavesCount
DEF GOLDEN_LEAVES_5 EQU 5
DEF SLIME_KEY       EQU 6

; values for wEntitiesDroppedItemTable
DEF DROP_RANDOM   EQU $00
DEF DROP_POWER_UP EQU $01

; drop chances
DEF DROP_CHANCE_0_PERCENT  EQU %00000000
DEF DROP_CHANCE_50_PERCENT EQU %00000001
DEF DROP_CHANCE_25_PERCENT EQU %00000011

DEF DROP_DESPAWN_TIME   EQU $80 ; frames until entity despawns
DEF DROP_COUNTDOWN_TIME EQU $18 ; frames dropped entity is blinking before despawn

; Recoil from sword hits
DEF SWORD_RECOIL_GENIE_JAR_DEFAULT  EQU $20
DEF SWORD_RECOIL_GENIE_JAR_STRONGER EQU $30
DEF SWORD_RECOIL_DEFAULT            EQU $30

; constants for wIsBowWowFollowingLink
;
; There exist code, where multiple checks are done.
; All values are combined with OR-operations and then masked once.
; To avoid collisions, the highest bit is used here for KIDNAPPED.
DEF BOW_WOW_AT_HOME   EQU $00
DEF BOW_WOW_FOLLOWING EQU $01
DEF BOW_WOW_KIDNAPPED EQU $80

; values for wTunicType
DEF TUNIC_GREEN  EQU $00
DEF TUNIC_RED    EQU $01
DEF TUNIC_BLUE   EQU $02

; Values for wItemUsageContext
DEF ITEM_USAGE_NEAR_NPC     EQU $01 ; set when near an NPC, to stop item usage
DEF ITEM_USAGE_READING_TEXT EQU $02 ; set when reading non-dialog text, to stop item usage
DEF ITEM_USAGE_ON_RAFT      EQU $80 ; set when on the raft, to freeze the raft when using an item
