; Maximum number of loaded entities
DEF MAX_ENTITIES EQU $10

; End marker in a list of entities
DEF ENTITIES_END EQU $FF

; Values for wEntitiesStatusTable
DEF ENTITY_STATUS_DISABLED   EQU 0
DEF ENTITY_STATUS_DYING      EQU 1
DEF ENTITY_STATUS_FALLING    EQU 2
DEF ENTITY_STATUS_DESTROYING EQU 3
DEF ENTITY_STATUS_INIT       EQU 4
DEF ENTITY_STATUS_ACTIVE     EQU 5
DEF ENTITY_STATUS_STUNNED    EQU 6
DEF ENTITY_STATUS_LIFTED     EQU 7
DEF ENTITY_STATUS_THROWN     EQU 8

; Values for wEntitiesOptions1Table
DEF ENTITY_OPT1_IS_BOSS                EQU $80
DEF ENTITY_OPT1_SWORD_CLINK_OFF        EQU $40
DEF ENTITY_OPT1_ALLOW_OUT_OF_BOUNDS    EQU $20
DEF ENTITY_OPT1_IMMUNE_WATER_PIT       EQU $10
DEF ENTITY_OPT1_SPLASH_IN_WATER        EQU $08
DEF ENTITY_OPT1_IS_MINI_BOSS           EQU $04
DEF ENTITY_OPT1_EXCLUDED_FROM_KILL_ALL EQU $02
DEF ENTITY_OPT1_MOVE_PIT_WATER         EQU $01
DEF ENTITY_OPT1_NONE                   EQU $00
; Bit numbers for wEntitiesOptions1Table
DEF ENTITY_OPT1_B_IS_BOSS                EQU 7
DEF ENTITY_OPT1_B_SWORD_CLINK_OFF        EQU 6
DEF ENTITY_OPT1_B_ALLOW_OUT_OF_BOUNDS    EQU 5
DEF ENTITY_OPT1_B_IMMUNE_WATER_PIT       EQU 4
DEF ENTITY_OPT1_B_SPLASH_IN_WATER        EQU 3
DEF ENTITY_OPT1_B_IS_MINI_BOSS           EQU 2
DEF ENTITY_OPT1_B_EXCLUDED_FROM_KILL_ALL EQU 1
DEF ENTITY_OPT1_B_MOVE_PIT_WATER         EQU 0

; Values for wEntitiesPhysicsFlagsTable
DEF ENTITY_PHYSICS_HARMLESS             EQU $80 ; The entity does not damage Link
DEF ENTITY_PHYSICS_PROJECTILE_NOCLIP    EQU $40 ; Projectiles pass through the entity
DEF ENTITY_PHYSICS_GRABBABLE            EQU $20 ; TODO: Implies that the entity can be grabbed with the Power Bracelet, or picked up/collected, depending on entity's private state?
DEF ENTITY_PHYSICS_SHADOW               EQU $10 ; The entity casts a shadow
; Mask for all the physics flags
DEF ENTITY_PHYSICS_MASK                 EQU $F0
; Bit numbers for wEntitiesPhysicsFlagsTable
DEF ENTITY_PHYSICS_B_HARMLESS           EQU 7
DEF ENTITY_PHYSICS_B_GRABBABLE          EQU 5
DEF ENTITY_PHYSICS_B_PROJECTILE_NOCLIP  EQU 6
DEF ENTITY_PHYSICS_B_SHADOW             EQU 4

; Values for wEntitiesTypeTable
; (See also EntityHandlersTable)
DEF ENTITY_ARROW                         EQU $00
DEF ENTITY_BOOMERANG                     EQU $01
DEF ENTITY_BOMB                          EQU $02
DEF ENTITY_HOOKSHOT_CHAIN                EQU $03
DEF ENTITY_MAGIC_ROD_FIREBALL            EQU $04
DEF ENTITY_LIFTABLE_ROCK                 EQU $05
DEF ENTITY_PUSHED_BLOCK                  EQU $06 ; The entity spawned when pushing an OBJECT_PUSHABLE_BLOCK, before it's moved into its new position
DEF ENTITY_CHEST_WITH_ITEM               EQU $07
DEF ENTITY_MAGIC_POWDER_SPRINKLE         EQU $08
DEF ENTITY_OCTOROK                       EQU $09
DEF ENTITY_OCTOROK_ROCK                  EQU $0A
DEF ENTITY_MOBLIN                        EQU $0B
DEF ENTITY_MOBLIN_ARROW                  EQU $0C
DEF ENTITY_TEKTITE                       EQU $0D
DEF ENTITY_LEEVER                        EQU $0E
DEF ENTITY_ARMOS_STATUE                  EQU $0F
DEF ENTITY_HIDING_GHINI                  EQU $10
DEF ENTITY_GIANT_GHINI                   EQU $11
DEF ENTITY_GHINI                         EQU $12
DEF ENTITY_BROKEN_HEART_CONTAINER        EQU $13 ; Killable; crashes the game if you run into it; works if you use the Magic Powder on it
DEF ENTITY_MOBLIN_SWORD                  EQU $14
DEF ENTITY_ANTI_FAIRY                    EQU $15
DEF ENTITY_SPARK_COUNTER_CLOCKWISE       EQU $16
DEF ENTITY_SPARK_CLOCKWISE               EQU $17
DEF ENTITY_POLS_VOICE                    EQU $18
DEF ENTITY_KEESE                         EQU $19
DEF ENTITY_STALFOS_AGGRESSIVE            EQU $1A
DEF ENTITY_ZOL                           EQU $1B
DEF ENTITY_GEL                           EQU $1C
;ENTITY_DISABLED                     EQU $1D
DEF ENTITY_STALFOS_EVASIVE               EQU $1E
DEF ENTITY_GIBDO                         EQU $1F
DEF ENTITY_HARDHAT_BEETLE                EQU $20
DEF ENTITY_WIZROBE                       EQU $21
DEF ENTITY_WIZROBE_PROJECTILE            EQU $22
DEF ENTITY_LIKE_LIKE                     EQU $23
DEF ENTITY_IRON_MASK                     EQU $24
DEF ENTITY_SMALL_EXPLOSION_ENEMY         EQU $25
DEF ENTITY_SMALL_EXPLOSION_ENEMY_2       EQU $26
DEF ENTITY_SPIKE_TRAP                    EQU $27
DEF ENTITY_MIMIC                         EQU $28
DEF ENTITY_MINI_MOLDORM                  EQU $29
DEF ENTITY_LASER                         EQU $2A
DEF ENTITY_LASER_BEAM                    EQU $2B
DEF ENTITY_SPIKED_BEETLE                 EQU $2C
DEF ENTITY_DROPPABLE_HEART               EQU $2D
DEF ENTITY_DROPPABLE_RUPEE               EQU $2E
DEF ENTITY_DROPPABLE_FAIRY               EQU $2F
DEF ENTITY_KEY_DROP_POINT                EQU $30
DEF ENTITY_SWORD_SHIELD_PICKUP           EQU $31
DEF ENTITY_IRON_MASKS_MASK               EQU $32
DEF ENTITY_PIECE_OF_POWER                EQU $33
DEF ENTITY_GUARDIAN_ACORN                EQU $34
DEF ENTITY_HEART_PIECE                   EQU $35
DEF ENTITY_HEART_CONTAINER               EQU $36
DEF ENTITY_DROPPABLE_ARROWS              EQU $37
DEF ENTITY_DROPPABLE_BOMBS               EQU $38
DEF ENTITY_INSTRUMENT_OF_THE_SIRENS      EQU $39
DEF ENTITY_SLEEPY_TOADSTOOL              EQU $3A
DEF ENTITY_DROPPABLE_MAGIC_POWDER        EQU $3B
DEF ENTITY_HIDING_SLIME_KEY              EQU $3C
DEF ENTITY_DROPPABLE_SECRET_SEASHELL     EQU $3D
DEF ENTITY_MARIN                         EQU $3E
DEF ENTITY_TARIN                         EQU $3F
DEF ENTITY_WITCH                         EQU $40
DEF ENTITY_OWL_EVENT                     EQU $41
DEF ENTITY_OWL_STATUE                    EQU $42
DEF ENTITY_SEASHELL_MANSION_TREES        EQU $43
DEF ENTITY_YARNA_TALKING_BONES           EQU $44
DEF ENTITY_BOULDERS                      EQU $45
DEF ENTITY_MOVING_BLOCK_LEFT_TOP         EQU $46
DEF ENTITY_MOVING_BLOCK_LEFT_BOTTOM      EQU $47
DEF ENTITY_MOVING_BLOCK_BOTTOM_LEFT      EQU $48
DEF ENTITY_MOVING_BLOCK_BOTTOM_RIGHT     EQU $49
DEF ENTITY_COLOR_DUNGEON_BOOK            EQU $4A
DEF ENTITY_POT                           EQU $4B
;ENTITY_DISABLED                     EQU $4C
DEF ENTITY_SHOP_OWNER                    EQU $4D
DEF ENTITY_4E                            EQU $4E ; unknown
DEF ENTITY_TRENDY_GAME_OWNER             EQU $4F
DEF ENTITY_BOO_BUDDY                     EQU $50
DEF ENTITY_KNIGHT                        EQU $51
DEF ENTITY_TRACTOR_DEVICE                EQU $52
DEF ENTITY_TRACTOR_DEVICE_REVERSE        EQU $53
DEF ENTITY_FISHERMAN_FISHING_GAME        EQU $54
DEF ENTITY_BOUNCING_BOMBITE              EQU $55
DEF ENTITY_TIMER_BOMBITE                 EQU $56
DEF ENTITY_PAIRODD                       EQU $57
DEF ENTITY_PAIRODD_PROJECTILE            EQU $58
DEF ENTITY_MOLDORM                       EQU $59
DEF ENTITY_FACADE                        EQU $5A
DEF ENTITY_SLIME_EYE                     EQU $5B
DEF ENTITY_GENIE                         EQU $5C
DEF ENTITY_SLIME_EEL                     EQU $5D
DEF ENTITY_GHOMA                         EQU $5E
DEF ENTITY_MASTER_STALFOS                EQU $5F
DEF ENTITY_DODONGO_SNAKE                 EQU $60
DEF ENTITY_WARP                          EQU $61
DEF ENTITY_HOT_HEAD                      EQU $62
DEF ENTITY_EVIL_EAGLE                    EQU $63
DEF ENTITY_SOUTH_FACE_SHRINE_DOOR        EQU $64 ; unknown ; @TODO unused Eagle's Tower split-screen vfx
DEF ENTITY_ANGLER_FISH                   EQU $65
DEF ENTITY_CRYSTAL_SWITCH                EQU $66
DEF ENTITY_67                            EQU $67 ; unknown
DEF ENTITY_HOOKSHOT_BRIDGE               EQU $68
DEF ENTITY_MOVING_BLOCK_MOVER            EQU $69
DEF ENTITY_RAFT_RAFT_OWNER               EQU $6A
DEF ENTITY_TEXT_DEBUGGER                 EQU $6B
DEF ENTITY_CUCCO                         EQU $6C
DEF ENTITY_BOW_WOW                       EQU $6D
DEF ENTITY_BUTTERFLY                     EQU $6E
DEF ENTITY_DOG                           EQU $6F
DEF ENTITY_KID_70                        EQU $70
DEF ENTITY_KID_71                        EQU $71
DEF ENTITY_KID_72                        EQU $72
DEF ENTITY_KID_73                        EQU $73
DEF ENTITY_PAPAHLS_WIFE                  EQU $74
DEF ENTITY_GRANDMA_ULRIRA                EQU $75
DEF ENTITY_MR_WRITE                      EQU $76
DEF ENTITY_GRANDPA_ULRIRA                EQU $77
DEF ENTITY_YIP_YIP                       EQU $78
DEF ENTITY_MADAM_MEOWMEOW                EQU $79
DEF ENTITY_CROW                          EQU $7A
DEF ENTITY_CRAZY_TRACY                   EQU $7B
DEF ENTITY_GIANT_GOPONGA_FLOWER          EQU $7C
DEF ENTITY_GOPONGA_FLOWER_PROJECTILE     EQU $7D
DEF ENTITY_GOPONGA_FLOWER                EQU $7E
DEF ENTITY_TURTLE_ROCK_HEAD              EQU $7F
DEF ENTITY_TELEPHONE                     EQU $80
DEF ENTITY_ROLLING_BONES                 EQU $81
DEF ENTITY_ROLLING_BONES_BAR             EQU $82
DEF ENTITY_DREAM_SHRINE_BED              EQU $83
DEF ENTITY_BIG_FAIRY                     EQU $84
DEF ENTITY_MR_WRITES_BIRD                EQU $85
DEF ENTITY_FLOATING_ITEM                 EQU $86
DEF ENTITY_DESERT_LANMOLA                EQU $87
DEF ENTITY_ARMOS_KNIGHT                  EQU $88
DEF ENTITY_HINOX                         EQU $89
DEF ENTITY_TILE_GLINT_SHOWN              EQU $8A
DEF ENTITY_TILE_GLINT_HIDDEN             EQU $8B
DEF ENTITY_RAISABLE_BLOCK_SHIFTED_RIGHT  EQU $8C ; unused
DEF ENTITY_RAISABLE_BLOCK_SHIFTED_DOWN   EQU $8D ; unused
DEF ENTITY_CUE_BALL                      EQU $8E
DEF ENTITY_MASKED_MIMIC_GORIYA           EQU $8F
DEF ENTITY_THREE_OF_A_KIND               EQU $90
DEF ENTITY_ANTI_KIRBY                    EQU $91
DEF ENTITY_SMASHER                       EQU $92
DEF ENTITY_MAD_BOMBER                    EQU $93
DEF ENTITY_KANALET_BOMBABLE_WALL         EQU $94
DEF ENTITY_RICHARD                       EQU $95
DEF ENTITY_RICHARD_FROG                  EQU $96
DEF ENTITY_DIVABLE_WATER                 EQU $97
DEF ENTITY_HORSE_PIECE                   EQU $98
DEF ENTITY_WATER_TEKTITE                 EQU $99
DEF ENTITY_FLYING_TILES                  EQU $9A
DEF ENTITY_HIDING_ZOL                    EQU $9B
DEF ENTITY_STAR                          EQU $9C
DEF ENTITY_LIFTABLE_STATUE               EQU $9D
DEF ENTITY_FIREBALL_SHOOTER              EQU $9E
DEF ENTITY_GOOMBA                        EQU $9F
DEF ENTITY_PEAHAT                        EQU $A0
DEF ENTITY_SNAKE                         EQU $A1
DEF ENTITY_PIRANHA_PLANT                 EQU $A2
DEF ENTITY_SIDE_VIEW_PLATFORM_HORIZONTAL EQU $A3
DEF ENTITY_SIDE_VIEW_PLATFORM_VERTICAL   EQU $A4
DEF ENTITY_SIDE_VIEW_PLATFORM            EQU $A5
DEF ENTITY_SIDE_VIEW_WEIGHTS             EQU $A6
DEF ENTITY_SMASHABLE_PILLAR              EQU $A7
DEF ENTITY_WRECKING_BALL                 EQU $A8
DEF ENTITY_BLOOPER                       EQU $A9
DEF ENTITY_CHEEP_CHEEP_HORIZONTAL        EQU $AA
DEF ENTITY_CHEEP_CHEEP_VERTICAL          EQU $AB
DEF ENTITY_CHEEP_CHEEP_JUMPING           EQU $AC
DEF ENTITY_KIKI_THE_MONKEY               EQU $AD
DEF ENTITY_WINGED_OCTOROK                EQU $AE
DEF ENTITY_TRADING_ITEM                  EQU $AF
DEF ENTITY_PINCER                        EQU $B0
DEF ENTITY_HOLE_FILLER                   EQU $B1
DEF ENTITY_BEETLE_SPAWNER                EQU $B2
DEF ENTITY_HONEYCOMB                     EQU $B3
DEF ENTITY_TARIN_BEEKEEPER               EQU $B4
DEF ENTITY_BEAR                          EQU $B5
DEF ENTITY_PAPAHL                        EQU $B6
DEF ENTITY_MERMAID                       EQU $B7
DEF ENTITY_FISHERMAN_UNDER_BRIDGE        EQU $B8
DEF ENTITY_BUZZ_BLOB                     EQU $B9
DEF ENTITY_BOMBER                        EQU $BA
DEF ENTITY_BUSH_CRAWLER                  EQU $BB
DEF ENTITY_GRIM_CREEPER                  EQU $BC
DEF ENTITY_VIRE                          EQU $BD
DEF ENTITY_BLAINO                        EQU $BE
DEF ENTITY_ZOMBIE                        EQU $BF
DEF ENTITY_MAZE_SIGNPOST                 EQU $C0
DEF ENTITY_MARIN_AT_THE_SHORE            EQU $C1
DEF ENTITY_MARIN_AT_TAL_TAL_HEIGHTS      EQU $C2
DEF ENTITY_MAMU_AND_FROGS                EQU $C3
DEF ENTITY_WALRUS                        EQU $C4
DEF ENTITY_URCHIN                        EQU $C5
DEF ENTITY_SAND_CRAB                     EQU $C6
DEF ENTITY_MANBO_AND_FISHES              EQU $C7
DEF ENTITY_BUNNY_CALLING_MARIN           EQU $C8
DEF ENTITY_MUSICAL_NOTE                  EQU $C9
DEF ENTITY_MAD_BATTER                    EQU $CA
DEF ENTITY_ZORA                          EQU $CB
DEF ENTITY_FISH                          EQU $CC
DEF ENTITY_BANANAS_SCHULE_SALE           EQU $CD
DEF ENTITY_MERMAID_STATUE                EQU $CE
DEF ENTITY_SEASHELL_MANSION              EQU $CF
DEF ENTITY_ANIMAL_D0                     EQU $D0
DEF ENTITY_ANIMAL_D1                     EQU $D1
DEF ENTITY_ANIMAL_D2                     EQU $D2
DEF ENTITY_BUNNY_D3                      EQU $D3
DEF ENTITY_GHOST                         EQU $D4
DEF ENTITY_ROOSTER                       EQU $D5
DEF ENTITY_SIDE_VIEW_POT                 EQU $D6
DEF ENTITY_THWIMP                        EQU $D7
DEF ENTITY_THWOMP                        EQU $D8
DEF ENTITY_THWOMP_RAMMABLE               EQU $D9
DEF ENTITY_PODOBOO                       EQU $DA
DEF ENTITY_GIANT_BUBBLE                  EQU $DB
DEF ENTITY_FLYING_ROOSTER_EVENTS         EQU $DC
DEF ENTITY_BOOK                          EQU $DD
DEF ENTITY_EGG_SONG_EVENT                EQU $DE
DEF ENTITY_SWORD_BEAM                    EQU $DF
DEF ENTITY_MONKEY                        EQU $E0
DEF ENTITY_WITCH_RAT                     EQU $E1
DEF ENTITY_FLAME_SHOOTER                 EQU $E2
DEF ENTITY_POKEY                         EQU $E3
DEF ENTITY_MOBLIN_KING                   EQU $E4
DEF ENTITY_FLOATING_ITEM_2               EQU $E5
DEF ENTITY_FINAL_NIGHTMARE               EQU $E6
DEF ENTITY_KANALET_CASTLE_GATE_SWITCH    EQU $E7
DEF ENTITY_ENDING_OWL_STAIR_CLIMBING     EQU $E8
DEF ENTITY_COLOR_SHELL_RED               EQU $E9
DEF ENTITY_COLOR_SHELL_GREEN             EQU $EA
DEF ENTITY_COLOR_SHELL_BLUE              EQU $EB
DEF ENTITY_COLOR_GHOUL_RED               EQU $EC
DEF ENTITY_COLOR_GHOUL_GREEN             EQU $ED
DEF ENTITY_COLOR_GHOUL_BLUE              EQU $EE
DEF ENTITY_ROTOSWITCH_RED                EQU $EF
DEF ENTITY_ROTOSWITCH_YELLOW             EQU $F0
DEF ENTITY_ROTOSWITCH_BLUE               EQU $F1
DEF ENTITY_FLYING_HOPPER_BOMBS           EQU $F2
DEF ENTITY_HOPPER                        EQU $F3
DEF ENTITY_AVALAUNCH                     EQU $F4
DEF ENTITY_BOUNCING_BOULDER              EQU $F5
DEF ENTITY_COLOR_GUARDIAN_BLUE           EQU $F6
DEF ENTITY_COLOR_GUARDIAN_RED            EQU $F7
DEF ENTITY_GIANT_BUZZ_BLOB               EQU $F8
DEF ENTITY_HARDHIT_BEETLE                EQU $F9
DEF ENTITY_PHOTOGRAPHER                  EQU $FA
; unused                             EQU $FB
; unused                             EQU $FC
; unused                             EQU $FD
; unused                             EQU $FE
DEF ENTITY_NONE                          EQU $FF
