/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/milvus-io/milvus-operator/apis/milvus.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// MilvusLister helps list Milvuses.
// All objects returned here must be treated as read-only.
type MilvusLister interface {
	// List lists all Milvuses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.Milvus, err error)
	// Milvuses returns an object that can list and get Milvuses.
	Milvuses(namespace string) MilvusNamespaceLister
	MilvusListerExpansion
}

// milvusLister implements the MilvusLister interface.
type milvusLister struct {
	indexer cache.Indexer
}

// NewMilvusLister returns a new MilvusLister.
func NewMilvusLister(indexer cache.Indexer) MilvusLister {
	return &milvusLister{indexer: indexer}
}

// List lists all Milvuses in the indexer.
func (s *milvusLister) List(selector labels.Selector) (ret []*v1beta1.Milvus, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Milvus))
	})
	return ret, err
}

// Milvuses returns an object that can list and get Milvuses.
func (s *milvusLister) Milvuses(namespace string) MilvusNamespaceLister {
	return milvusNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// MilvusNamespaceLister helps list and get Milvuses.
// All objects returned here must be treated as read-only.
type MilvusNamespaceLister interface {
	// List lists all Milvuses in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.Milvus, err error)
	// Get retrieves the Milvus from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.Milvus, error)
	MilvusNamespaceListerExpansion
}

// milvusNamespaceLister implements the MilvusNamespaceLister
// interface.
type milvusNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Milvuses in the indexer for a given namespace.
func (s milvusNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.Milvus, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Milvus))
	})
	return ret, err
}

// Get retrieves the Milvus from the indexer for a given namespace and name.
func (s milvusNamespaceLister) Get(name string) (*v1beta1.Milvus, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("milvus"), name)
	}
	return obj.(*v1beta1.Milvus), nil
}
