/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	milvusiov1beta1 "github.com/milvus-io/milvus-operator/apis/milvus.io/v1beta1"
	versioned "github.com/milvus-io/milvus-operator/pkg/client/clientset/versioned"
	internalinterfaces "github.com/milvus-io/milvus-operator/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/milvus-io/milvus-operator/pkg/client/listers/milvus.io/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// MilvusInformer provides access to a shared informer and lister for
// Milvuses.
type MilvusInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.MilvusLister
}

type milvusInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewMilvusInformer constructs a new informer for Milvus type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewMilvusInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredMilvusInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredMilvusInformer constructs a new informer for Milvus type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredMilvusInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.MilvusV1beta1().Milvuses(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.MilvusV1beta1().Milvuses(namespace).Watch(context.TODO(), options)
			},
		},
		&milvusiov1beta1.Milvus{},
		resyncPeriod,
		indexers,
	)
}

func (f *milvusInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredMilvusInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *milvusInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&milvusiov1beta1.Milvus{}, f.defaultInformer)
}

func (f *milvusInformer) Lister() v1beta1.MilvusLister {
	return v1beta1.NewMilvusLister(f.Informer().GetIndexer())
}
