/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1beta1 "github.com/milvus-io/milvus-operator/apis/milvus.io/v1beta1"
	scheme "github.com/milvus-io/milvus-operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MilvusesGetter has a method to return a MilvusInterface.
// A group's client should implement this interface.
type MilvusesGetter interface {
	Milvuses(namespace string) MilvusInterface
}

// MilvusInterface has methods to work with Milvus resources.
type MilvusInterface interface {
	Create(ctx context.Context, milvus *v1beta1.Milvus, opts v1.CreateOptions) (*v1beta1.Milvus, error)
	Update(ctx context.Context, milvus *v1beta1.Milvus, opts v1.UpdateOptions) (*v1beta1.Milvus, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.Milvus, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.MilvusList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Milvus, err error)
	MilvusExpansion
}

// milvuses implements MilvusInterface
type milvuses struct {
	client rest.Interface
	ns     string
}

// newMilvuses returns a Milvuses
func newMilvuses(c *MilvusV1beta1Client, namespace string) *milvuses {
	return &milvuses{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the milvus, and returns the corresponding milvus object, and an error if there is any.
func (c *milvuses) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Milvus, err error) {
	result = &v1beta1.Milvus{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("milvuses").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Milvuses that match those selectors.
func (c *milvuses) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.MilvusList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.MilvusList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("milvuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested milvuses.
func (c *milvuses) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("milvuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a milvus and creates it.  Returns the server's representation of the milvus, and an error, if there is any.
func (c *milvuses) Create(ctx context.Context, milvus *v1beta1.Milvus, opts v1.CreateOptions) (result *v1beta1.Milvus, err error) {
	result = &v1beta1.Milvus{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("milvuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(milvus).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a milvus and updates it. Returns the server's representation of the milvus, and an error, if there is any.
func (c *milvuses) Update(ctx context.Context, milvus *v1beta1.Milvus, opts v1.UpdateOptions) (result *v1beta1.Milvus, err error) {
	result = &v1beta1.Milvus{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("milvuses").
		Name(milvus.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(milvus).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the milvus and deletes it. Returns an error if one occurs.
func (c *milvuses) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("milvuses").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *milvuses) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("milvuses").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched milvus.
func (c *milvuses) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Milvus, err error) {
	result = &v1beta1.Milvus{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("milvuses").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
