/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1beta1 "github.com/milvus-io/milvus-operator/apis/milvus.io/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeMilvuses implements MilvusInterface
type FakeMilvuses struct {
	Fake *FakeMilvusV1beta1
	ns   string
}

var milvusesResource = schema.GroupVersionResource{Group: "milvus.io", Version: "v1beta1", Resource: "milvuses"}

var milvusesKind = schema.GroupVersionKind{Group: "milvus.io", Version: "v1beta1", Kind: "Milvus"}

// Get takes name of the milvus, and returns the corresponding milvus object, and an error if there is any.
func (c *FakeMilvuses) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Milvus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(milvusesResource, c.ns, name), &v1beta1.Milvus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Milvus), err
}

// List takes label and field selectors, and returns the list of Milvuses that match those selectors.
func (c *FakeMilvuses) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.MilvusList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(milvusesResource, milvusesKind, c.ns, opts), &v1beta1.MilvusList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.MilvusList{ListMeta: obj.(*v1beta1.MilvusList).ListMeta}
	for _, item := range obj.(*v1beta1.MilvusList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested milvuses.
func (c *FakeMilvuses) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(milvusesResource, c.ns, opts))

}

// Create takes the representation of a milvus and creates it.  Returns the server's representation of the milvus, and an error, if there is any.
func (c *FakeMilvuses) Create(ctx context.Context, milvus *v1beta1.Milvus, opts v1.CreateOptions) (result *v1beta1.Milvus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(milvusesResource, c.ns, milvus), &v1beta1.Milvus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Milvus), err
}

// Update takes the representation of a milvus and updates it. Returns the server's representation of the milvus, and an error, if there is any.
func (c *FakeMilvuses) Update(ctx context.Context, milvus *v1beta1.Milvus, opts v1.UpdateOptions) (result *v1beta1.Milvus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(milvusesResource, c.ns, milvus), &v1beta1.Milvus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Milvus), err
}

// Delete takes name of the milvus and deletes it. Returns an error if one occurs.
func (c *FakeMilvuses) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(milvusesResource, c.ns, name), &v1beta1.Milvus{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeMilvuses) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(milvusesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.MilvusList{})
	return err
}

// Patch applies the patch and returns the patched milvus.
func (c *FakeMilvuses) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Milvus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(milvusesResource, c.ns, name, pt, data, subresources...), &v1beta1.Milvus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Milvus), err
}
