### AOF和RDB？<Badge text="重点" type="danger" />

**AOF**

每执行一条**写操作**命令，就将该命令以追加的方式写入到 AOF 文件，然后在恢复时，以逐一执行命令的方式来进行数据恢复。用 AOF 日志的方式来恢复数据很慢，因为 Redis 执行命令由单线程负责的，AOF 日志恢复数据的方式是顺序执行日志里的每一条命令，如果 AOF 日志很大，这个过程就会很慢了。

**RDB**

RDB 快照是记录某一个瞬间的内存数据，记录的是实际数据，而 AOF 文件记录的是命令操作的日志，而不是实际的数据。因此在 Redis 恢复数据时， RDB 恢复数据的效率会比 AOF 高些，因为直接将 RDB 文件读入内存就可以，不需要像 AOF 那样还需要额外执行操作命令的步骤才能恢复数据。

RDB快照是全量快照，也就是说每次执行快照，都是把内存中的所有数据都记录到磁盘中。如果频率太频繁，可能会对 Redis 性能产生影响。如果频率太低，服务器故障时，丢失的数据会更多。通常可能设置至少 5 分钟才保存一次快照，这时如果 Redis 出现宕机等情况，意味着最多可能丢失 5 分钟数据。

**AOF-RDB混用**

在 AOF 重写日志时，fork出来的重写子进程会先将与主线程共享的内存数据以 RDB 方式写入到 AOF 文件，然后主线程处理的操作命令会被记录在重写缓冲区里，重写缓冲区里的增量命令会以 AOF 方式写入到 AOF 文件，写入完成后通知主进程将新的含有 RDB 格式和 AOF 格式的 AOF 文件替换旧的的 AOF 文件。文件的前半部分是 RDB 格式的全量数据，后半部分是 AOF 格式的增量数据。

这样的好处在于，重启 Redis 加载数据的时候，由于前半部分是 RDB 内容，这样**加载的时候速度会很快**。加载完 RDB 的内容后，才会加载后半部分的 AOF 内容，这里的内容是 Redis 后台子进程重写 AOF 期间，主线程处理的操作命令，可以使得**数据更少的丢失**。缺点是AOF文件的可读性变差了。



### AOF的三种写回策略？<Badge text="重点" type="danger" />

Always、Everysec 和 No，这三种策略在可靠性上是从高到低，而在性能上从低到高。

**Always**是每次写操作命令执行完后，同步将 AOF 日志数据写回硬盘；**Everysec**每次写操作命令执行完后，先将命令写入到 AOF 文件的内核缓冲区，然后每隔一秒将缓冲区里的内容写回到硬盘；**No**就是不控制写回硬盘的时机。每次写操作命令执行完后，先将命令写入到 AOF 文件的内核缓冲区，再由操作系统决定何时将缓冲区内容写回硬盘。



### AOF的磁盘重写机制？<Badge text="重点" type="danger" />

随着执行的命令越多，AOF 文件的体积自然也会越来越大，为了避免日志文件过大， Redis 提供了 AOF 重写机制，它会直接扫描数据中所有的键值对数据，然后为每一个键值对生成一条写操作命令，接着将该命令写入到新的 AOF 文件，重写完成后，就替换掉现有的 AOF 日志。重写的过程是由后台子进程完成的，这样可以使得主进程可以继续正常处理命令。





### 为什么先执行Redis命令，再把数据写入AOF日志呢？<Badge text="了解" type="info" />

**好处**：

- **保证正确写入**：如果当前的命令语法有问题，错误的命令记录到 AOF 日志里后可能还会进行语法检查。先执行Redis命令，再把数据写入AOF日志可以保证写入的都是正确可执行的命令。
- **不阻塞当前写操作**：因为当写操作命令执行成功后才会将命令记录到AOF日志，避免写入阻塞。

**缺陷**：

- **数据可能会丢失：** 执行写操作命令和记录日志是两个过程，Redis还没来得及将命令写入到硬盘时发生宕机，数据会有丢失的风险。
- **阻塞其他操作：** 不会阻塞当前命令的执行，但因为 AOF 日志也是在主线程中执行，所以当 Redis 把日志文件写入磁盘的时候，还是会阻塞后续的操作无法执行。



### AOF的重写的具体过程？<Badge text="了解" type="info" />

触发重写机制后，主进程会创建重写 AOF 的子进程，此时父子进程共享物理内存，重写子进程只会对这个内存进行只读。重写 AOF 子进程读取数据库里的所有数据，并逐一把内存数据的键值对转换成一条命令，再将命令记录到重写日志。

在发生写操作的时候，操作系统才会去复制物理内存，这样是为了防止 fork 创建子进程时，由于物理内存数据的复制时间过长而导致父进程长时间阻塞的问题。



### AOF子进程的内存数据跟主进程的内存数据不一致怎么办？<Badge text="了解" type="info" />

Redis设置了一个 **AOF 重写缓冲区**，这个缓冲区在创建 bgrewriteaof 子进程之后开始使用。在重写 AOF 期间，当 Redis 执行完一个写命令之后，它会**同时将这个写命令写入到AOF 缓冲区和AOF 重写缓冲区**。当子进程完成 AOF 重写工作后，会向主进程发送一条信号。主进程收到该信号后，会调用一个信号处理函数，将 AOF 重写缓冲区中的所有内容追加到新的 AOF 的文件中，使得新旧两个 AOF 文件所保存的数据库状态一致；新的 AOF 的文件进行改名，覆盖现有的 AOF 文件。

::: tip 提示

Redis 的重写 AOF 过程是由后台子进程 bgrewriteaof 来完成的，这有两个好处：

- 子进程进行 AOF 重写期间，主进程可以继续处理命令请求，从而避免阻塞主进程；
- 子进程带有主进程的数据副本，使用子进程而不是线程，因为如果是使用线程，多线程之间会共享内存，那么在修改共享内存数据的时候，需要通过加锁来保证数据的安全，而这样就会降低性能。创建子进程时，父子进程是共享内存数据的，不过这个共享的内存只能以只读的方式，而当父子进程任意一方修改了该共享内存，会发生写时复制，于是父子进程就有了独立的数据副本，不用加锁来保证数据安全。

:::

### RDB 在执行快照的时候，数据能修改吗？<Badge text="了解" type="info" />

可以。执行 bgsave 过程中，Redis 依然**可以继续处理操作命令**的，数据是能被修改的，采用的是写时复制技术（Copy-On-Write, COW）。执行 bgsave 命令的时候，会通过 fork（）创建子进程，此时子进程和父进程是共享同一片内存数据的，因为创建子进程的时候，会复制父进程的页表，但是页表指向的物理内存还是一个，由于共享父进程的所有数据，可以直接读取主线程里的内存数据，并将数据写入到 RDB 文件。此时如果主线程执行读操作，则主线程和 bgsave 子进程互相不影响。如果主线程要修改共享数据里的某一块数据，就会发生写时复制，数据的物理内存就会被复制一份，主线程在这个数据副本进行修改操作。与此同时，子进程可以继续把原来的数据写入到 RDB 文件。



### Redis过期机制？<Badge text="掌握" type="tip" />

三种过期删除策略：

- 定时删除：**在设置 key 的过期时间时，同时创建一个定时事件，当时间到达时，由事件处理器执行 key 的删除操作。**

  - **优点**：内存可以被尽快地释放。定时删除对内存是最友好的。

  - **缺点**：定时删除策略对 CPU 不友好，删除过期 key 可能会占用相当一部分 CPU 时间，CPU 紧张的情况下将 CPU 用于删除和当前任务无关的过期键上，会对服务器的响应时间和吞吐量造成影响。

- 惰性删除：**不主动删除过期键，每次从数据库访问 key 时检测 key 是否过期，如果过期则删除该key。**

  - **优点**：只会使用很少的系统资源，对 CPU 最友好。

  - **缺点**：如果一个 key 已经过期，而这个 key 又仍然保留在数据库中，那么只要这个过期 key 一直没有被访问，它所占用的内存就不会释放。惰性删除策略对内存不友好。

- 定期删除：**每隔一段时间随机从数据库中取出一定数量的 key 进行检查，并删除其中的过期key。**
  - **优点**：限制删除操作执行的时长和频率来减少删除操作对 CPU 的影响，同时也能删除一部分过期的数据减少了过期键对空间的无效占用。
  - **缺点**：内存清理方面没有定时删除效果好，同时没有惰性删除使用的系统资源少。难以确定删除操作执行的时长和频率。

**Redis 选择惰性删除+定期删除这两种策略配和使用**，以求在合理使用 CPU 时间和避免内存浪费之间取得平衡。Redis 在访问或者修改 key 之前，都会调用 expireIfNeeded 函数对其进行检查，检查 key 是否过期：

- 如果过期，则删除该 key，然后返回 null 客户端；
- 如果没有过期，不做任何处理，然后返回正常的键值对给客户端；

从过期字典中随机抽取 20 个 key；检查这 20 个 key 是否过期，并删除已过期的 key；已过期 key 的数量占比随机抽取 key 的数量大于 25%，则继续重复步骤直到比重小于25%。





### Redis的内存淘汰策略？<Badge text="掌握" type="tip" />

**不进行数据淘汰的策略**

它表示当运行内存超过最大设置内存时，不淘汰任何数据，这时如果有新的数据写入，则会触发 OOM，只是单纯的查询或者删除操作的话还是可以正常工作。

**进行数据淘汰的策略**

在设置了过期时间的数据中进行淘汰：

- **volatile-random**：随机淘汰设置了过期时间的任意键值
- **volatile-ttl**：优先淘汰更早过期的键值
- **volatile-lru**：淘汰所有设置了过期时间的键值中，最久未使用的键值
- **volatile-lfu**：淘汰所有设置了过期时间的键值中，最少使用的键值

在所有数据范围内进行淘汰：

- **allkeys-random**：随机淘汰任意键值
- **allkeys-lru**：淘汰整个键值中最久未使用的键值
- **allkeys-lfu**：淘汰整个键值中最少使用的键值



### Redis持久化时对过期键会如何处理的？<Badge text="了解" type="info" />

**RDB**

RDB分文生成阶段和加载阶段，生成阶段会对key进行过期检查，过期的key不会保存到RDB文件中；加载阶段看服务器是主服务器还是从服务器，如果是主服务器，在载入 RDB 文件时，程序会对文件中保存的键进行检查，过期键不会被载入到数据库中；如果从服务器，在载入 RDB 文件时，不论键是否过期都会被载入到数据库中。但由于主从服务器在进行数据同步时，从服务器的数据会被清空。过期键对载入 RDB 文件的从服务器也不会造成影响。

**AOF**

AOF文件写入阶段和AOF重写阶段。写入阶段如果数据库某个过期键还没被删除，AOF 文件会保留此过期键，当此过期键被删除后，Redis 会向 AOF 文件追加一条 DEL 命令来显式地删除该键值。重写阶段会对 Redis 中的键值对进行检查，已过期的键不会被保存到重写后的 AOF 文件中。



### Redis主从模式中，对过期键会如何处理？<Badge text="了解" type="info" />

从库不会进行过期扫描，即使从库中的 key 过期了，如果有客户端访问从库时，依然可以得到 key 对应的值。从库的过期键处理依靠主服务器控制，**主库在 key 到期时，会在 AOF 文件里增加一条 del 指令，同步到所有的从库**，从库通过执行这条 del 指令来删除过期的 key。
