---
title: 文件系统
author: ["jjd","枫长"]
---



### 文件系统虚拟化？

- 文件是操作系统进行存储时使用最多的抽象之一，每个文件实际上是一个**有名字的字符序列**，也可以把文件叫做虚拟磁盘，我们实际操作时都是在操作文件而非直接操作硬盘中的数据。序列内容为**文件数据**，而序列长度，修改时间等描述文件数据的属性特征的其他信息被称为**文件元数据**。
- 文件系统就是管理文件数据与文件元数据的系统，即文件系统。文件系统提供文件抽象并实现文件访问所需要的接口。考虑到存储空间太大，文件以数据块为单位进行访问，一个块一般4KB。
- 当应用程序想访问或写入一些数据到存储设备上时，它会采用Linux系统提供的open，write，read等系统调用；在处理系统调用时，内核会调用**虚拟文件系统**（VFS）来处理文件请求，虚拟文件系统负责管理具体的文件系统如inode文件系统，FAT32文件系统等。

### 什么是硬链接与符号连接？

硬链接（hard link）和符号链接（symbolic link，也称为软链接）是Unix和类Unix文件系统中两种不同的文件链接类型。它们用于创建文件或目录的引用。

**硬链接**

硬链接是文件系统中一个文件的额外引用。在Unix和类Unix文件系统中，每个文件都有一个称为inode的数据结构来存储文件的元数据，例如文件权限、所有者、大小等。每个文件都有一个或多个文件名（硬链接），它们指向相应的inode。换句话说，硬链接是文件名和inode之间的关联。

硬链接的特点如下：

- 硬链接不能跨文件系统。由于硬链接直接关联到inode，它只能在同一个文件系统中创建。
- 硬链接不能引用目录。这是为了防止文件系统中出现循环引用和其他不一致性问题。
- 删除一个文件的所有硬链接会导致文件被删除。当一个文件的最后一个硬链接被删除时，文件系统将释放该文件的inode以及占用的存储空间。
- 硬链接不影响原始文件的访问。所有硬链接都指向相同的inode，因此访问任何一个硬链接实际上是访问原始文件。

**符号链接**

符号链接是一种特殊的文件，它包含指向另一个文件或目录的路径。与硬链接直接关联到inode不同，符号链接通过路径名来引用目标文件。当用户或应用程序访问符号链接时，文件系统会自动将其重定向到目标路径。

符号链接的特点如下：

- 符号链接可以跨文件系统。由于符号链接通过路径名引用目标文件，它可以链接到其他文件系统中的文件或目录。
- 符号链接可以引用目录。这使得符号链接在文件系统组织和目录结构管理中非常有用。
- 删除符号链接不会影响目标文件。当删除一个符号链接时，只有链接本身被删除，而目标文件保持不变。
- 符号链接可能引起死链接（dangling link）。如果目标文件被删除或移动，符号链接将指向一个不存在的路径，导致死链接。

### 讲一讲Inode文件系统结构？

Inode（索引节点）是UNIX和类UNIX文件系统中的一个重要概念。Inode是文件系统中的一个数据结构，用于存储文件或目录的元数据（metadata），例如文件大小、时间戳、权限、所有者等。Inode还包含了指向实际文件数据块（data block）的指针，这些数据块存储了文件的内容。

在UNIX和类UNIX文件系统中，每个文件或目录都有一个唯一的Inode号（Inode number），用于唯一标识文件系统中的对象。文件名只是一个用户友好的引用，实际上是指向Inode号的指针。这种设计允许文件系统以更高效的方式管理和访问文件，同时提供了硬链接等高级功能。以下是Inode文件系统结构的几个关键组成部分：

- **Inode表**：Inode表是文件系统中一个预先分配的区域，用于存储Inode数据结构。每个Inode在Inode表中占用固定大小的空间，通常为128字节或256字节。文件系统在格式化时会预先分配一定数量的Inode，这些Inode数量决定了文件系统能够容纳的最大文件和目录数量。
- **数据块**：数据块（data block）是文件系统中用于存储文件内容的基本单位。数据块的大小通常为4KB、8KB或更大。每个Inode包含了指向文件数据块的指针，这些指针可以直接指向数据块（直接块指针），也可以指向间接块（间接块指针）、二次间接块（双间接块指针）或三次间接块（三间接块指针）。
- **目录项**：目录项（directory entry）是文件系统中表示目录结构的数据结构。每个目录项包含一个文件名和一个对应的Inode号。目录项存储在目录文件的数据块中，通过Inode号可以找到目录项所指向的文件或子目录的Inode和数据块。
- **超级块**：超级块（superblock）是文件系统中存储文件系统元数据的区域。超级块包含了文件系统的基本信息，如文件系统类型、大小、块大小、Inode数量等。操作系统在挂载文件系统时会读取超级块，以确定文件系统的参数和状态。

![image-20230410154719558](C:\Users\zijing2333\AppData\Roaming\Typora\typora-user-images\image-20230410154719558.png)



### 讲一讲FAT文件系统与UNIX文件系统？

FAT（File Allocation Table）文件系统和UNIX文件系统是两种不同的文件系统结构。

**FAT文件系统**

FAT文件系统最初是为MS-DOS操作系统设计的，后来成为了Windows操作系统中的一个主要文件系统。FAT文件系统有多个版本，包括FAT12、FAT16和FAT32。FAT文件系统的核心组件是文件分配表（File Allocation Table），它是一个记录文件数据块使用情况的表格

FAT文件系统的特点如下：

- 结构简单：FAT文件系统的结构相对简单，易于实现和维护。它是通过链表的形式管理数据块，**随机访问能力较差**。
- 跨平台兼容性：由于FAT文件系统的普及程度很高，大多数操作系统都支持FAT文件系统。这使得FAT文件系统成为了很多可移动存储设备（如U盘、SD卡等）的首选文件系统。
- 局限性：FAT文件系统在文件权限管理、文件大小限制和磁盘空间利用率等方面存在一定的局限性。例如，FAT32文件系统不支持超过4GB的单个文件（因为链表管理的原因，访问最后一个数据块要遍历完所有数据块的指针，所以大文件性能很差），而且没有类似UNIX文件系统中的文件权限和所有权管理功能。

**UNIX文件系统**

UNIX文件系统通常指代在UNIX和类UNIX操作系统中使用的一系列文件系统，这类系统相比于FAT**主要提升了随机访问的能力**，并且支持链接。

UNIX文件系统的特点如下：

- Inode结构：UNIX文件系统使用Inode（索引节点）来存储文件元数据，这种设计使得文件系统可以更高效地管理和访问文件。
- 权限管理：UNIX文件系统支持详细的文件权限和所有权管理，允许对文件和目录进行读、写和执行权限的控制。
- 硬链接和符号链接：UNIX文件系统支持硬链接和符号链接，这些链接类型可以用于创建文件和目录的引用，实现更灵活的文件系统组织和管理。
- 日志功能：许多UNIX文件系统（如EXT4、XFS等）具有日志功能，这有助于提高文件系统的数据一致性和恢复能力。

在实际应用中，这两种文件系统有各自的优势和适用场景。

FAT文件系统通常适用于以下场景：

- 可移动存储设备：由于FAT文件系统在各种操作系统中都有很好的支持，它成为了许多可移动存储设备（如U盘、SD卡等）的默认文件系统。
- 嵌入式系统：FAT文件系统简单的结构和较低的系统资源需求使其在嵌入式系统和低端设备中非常受欢迎。

UNIX文件系统通常适用于以下场景：

- UNIX和类UNIX操作系统：在这些操作系统中，UNIX文件系统（如EXT4、XFS等）是默认或推荐的文件系统。
- 服务器和高性能计算：由于UNIX文件系统在性能、可靠性和扩展性方面的优势，它们通常被用于服务器和高性能计算系统。

除了FAT和UNIX文件系统外，还有其他类型的文件系统，如Windows中的NTFS和macOS中的APFS等。

### 文件传输中断后如何续传，讲一讲Rsync算法？

当文件传输过程中遇到中断，如网络故障或其他原因，需要一种方法来继续传输，而不是从头开始。续传功能可以有效地减少重复传输的数据量，从而提高传输效率。Rsync算法是一种用于文件同步和增量备份的高效算法，可以实现文件传输的续传功能。

Rsync算法基于滚动哈希（rolling hash）和数据块签名的方法来实现文件同步。以下是Rsync算法的基本步骤：

1. 将目标文件分割成固定大小或可变大小的数据块。对于每个数据块，计算两个哈希值：一个弱哈希值（如Adler-32校验和）和一个强哈希值（如MD5或SHA-1散列）。
2. 将这些哈希值（也称为数据块签名）发送到接收方。接收方在本地查找与目标文件相同的文件，通常是一个旧版本或部分传输的文件。
3. 接收方将本地文件划分为与发送方相同大小的数据块，并计算每个数据块的弱哈希值。
4. 接收方使用滚动哈希方法，在本地文件中寻找与发送方数据块相匹配的哈希值。通过比较弱哈希值，接收方可以快速找到潜在的匹配数据块。为了避免误报，接收方还会比较强哈希值来确认数据块是否真正匹配。
5. 接收方将匹配的数据块信息（如数据块索引和偏移量）发送回发送方。
6. 发送方根据接收方返回的匹配信息，仅发送目标文件中未匹配的数据块，从而实现增量更新和续传功能。

Rsync算法的主要优势是它可以在不传输整个文件的情况下检测和同步文件的差异。这种方法在大文件、低带宽和不稳定网络连接的场景中非常高效。不过Rsync算法本身并不负责文件传输，而是需要与其他文件传输协议（如SSH、FTP等）结合使用。

Rsync算法已经被广泛应用于各种文件同步和备份工具中，如Linux中的`rsync`命令。这些工具提供了丰富的选项和功能，可以实现文件传输的续传、增量备份、压缩传输等高级功能。