---
title: IP面试常见题
---



### DNS查询服务器的基本流程？<Badge text="重要" type="danger" />

- 客户机向其本地域名服务器发出DNS请求报文
- 本地域名服务器收到请求后，**查询本地缓存**，假设没有该记录，则以DNS客户的身份向**根域名**服务器发出解析请求
- **根域名**服务器收到请求后，判断该域名所属域，将对应的**顶级域名服务器**的IP地址返回给本地域名服务器
- 本地域名服务器向**顶级域名服务器**发出解析请求报文
- 顶级域名服务器收到请求后，将所对应的**授权域名服务器**的IP地址返回给本地域名服务器
- 本地域名服务器向授权域名服务器发起解析请求报文
- 授权域名服务器收到请求后，将**查询结果返回给本地域名服务器**
- 本地域名服务器将查询结果保存到**本地缓存**，**同时**返回给客户机

. —- .com —– qq.com —– [www.qq.com](http://www.qq.com/) –ip给客户机。

如果是转发模式，则与上一步骤相反，从下往上找。[www.qq.com](http://www.qq.com/) => qq.com => .com => .



### DNS采用TCP还是UDP，为什么？<Badge text="了解" type="info" />

DNS在进行区域传输的时候使用TCP协议，**其它时候则使用UDP协议**。TCP与UDP传送字节的长度限制不同，一般情况下一个DNS的UDP包的最大长度是**512**字节。

区域传输使用TCP协议的原因大概是：

- 区域传输的数据量相比单次DNS查询的数据量要大得多
- 区域传输对数据的可靠性和准确性相比普通的DNS查询要要高得多，因此使用TCP协议

域名解析时一般返回的内容都不超过512字节，首选的通讯协议是UDP。使用UDP传输，不用经过TCP三次握手，这样DNS服务器负载更低，响应更快。



### DNS劫持是什么？解决办法？<Badge text="了解" type="info" />

#### 概念

DNS重定向，通过覆盖计算机的TCP/IP设置，将个人查询重定向到域名服务器DNS。这可以通过使用恶意软件或修改服务器的设置来实现，一旦执行DNS劫持的个人控制了DNS，他们就可以使用它来将流量引导到不同的网站。

**本地DNS劫持**

攻击者在用户的计算机上安装木马恶意软件，并更改本地DNS设置以将用户重定向到恶意站点。

**路由器DNS劫持**

攻击者接管路由器并覆盖DNS设置，从而影响连接到该路由器的所有用户。

**中间DNS攻击的人**

攻击者拦截用户和DNS服务器之间的通信，并提供指向恶意站点的不同目标IP地址。

#### 解决方法

- 加强域名账户的安全防护能力，使用有别于其他平台的用户名和强密码，定期对密码进行更换。

- 定期查看域名账户信息、域名whois信息、域名解析状态，每天site网站检查是否存在非个人设定网页，发现异常及时联系域名服务商。

- 锁定域名解析状态，不允许通过DNS服务商网站修改记录，使用此方法后，需要做域名解析都要通过服务商来完成，这样可以从根本上杜绝通过攻击服务商修改解析记录的方法。




### 浏览器输入一个URL到显示器显示的过程？<Badge text="重要" type="danger" />

**键盘输入**

输入键盘字符后键盘就会产生扫描数据，并将其缓冲存在寄存器中，然后键盘通过总线给 CPU 发送中断请求。CPU 收到中断请求后，操作系统会保存被中断进程的 CPU 上下文，然后调用键盘的中断处理程序。键盘中断处理函数从键盘的寄存器的缓冲区读取扫描码，再根据扫描码找到用户在键盘输入的字符的ASCII 码。然后把 ASCII 码放到读缓冲区队列，显示器会定时从读缓冲区队列读取数据放到写缓冲区队列，最后把写缓冲区队列的数据一个一个写入到显示器的寄存器中的数据缓冲区，最后将这些数据显示在屏幕里。

**URL解析**

浏览器会首先从缓存中找是否存在域名，如果存在就直接取出对应的ip地址，如果没有就开启一个DNS域名解析器。DNS域名解析器会首先访问顶级域名服务器，将对应的IP发给客户端；然后访问根域名解析器，将对应的IP发给客户端；最后访问本地域名服务器，得到最终的ip地址。

**TCP连接**

在URL解析过程中得到真实的IP地址之后，会调用Socket函数建立TCP连接。

**HTTP请求**

浏览器向服务器发起一个 HTTP请求，HTTP协议是建立在TCP协议之上的应用层协议，其本质是建立起的 TCP连接中，按照 HTTP协议标准发送一个索要网页的请求。请求包含请求行、请求头、请求体三个部分组成，有GET、POST等主要方法。

**浏览器接收响应**

服务器在收到浏览器发送的HTTP请求之后，会将收到的HTTP报文封装成HTTP的Request对象，并通过不同的Web服务器进行处理，处理完的结果以HTTP的Response对象返回，主要包括状态码，响应头，响应报文三个部分。

**页面渲染**

浏览器根据响应开始显示页面，首先解析 HTML文件构建DOM树，然后解析CSS文件构建渲染树，等到渲染树构建完成后，浏览器开始布局渲染树并将其绘制到屏幕上。

**断开连接**

客户端和服务器通过四次挥手终止TCP连接。



### PING是怎么工作的？<Badge text="重要" type="danger" />

::: tip

ICMP主要的功能包括：确认IP包是否成功送达目标地址、报告发送过程中IP包被废弃的原因、改善网络设置等。在IP通信中如果某个IP包因为某种原因未能达到目标地址，具体的原因将由ICMP通知。

:::

ping命令执行的时候，源主机首先会构建一个ICMP回送请求消息数据包，由ICMP协议将这个数据包连同服务端IP一起交给IP层，IP层将以服务端IP作为目的地址，本机IP地址作为源地址，协议字段设置为1，再加上一些其他控制信息，构建一个IP数据包；然后加入MAC头；如果在本地ARP映射表中查找出服务端IP所对应的MAC地址，则可以直接使用，如果没有，则需要发送ARP协议查询MAC地址。获得MAC地址后，由数据链路层构建一个数据帧，目的地址是IP层传过来的MAC地址，源地址则是本机的MAC地址；还要附加上一些控制信息，依据以太网的介质访问规则将它们传送出去。

目的收到这个数据帧后，先检查它的目的MAC地址，并和本机的MAC地址对比，如符合，则接收，否则就丢弃。接收后检查该数据帧，将IP数据包从帧中提取出来，交给本机的IP层。IP层检查后，将有用的信息提取后交给ICMP协议。主机B会构建一个ICMP回送响应消息数据包，回送响应数据包的类型字段为0，序号为接收到的请求数据包中的序号，然后再发送出去给主机A。

在规定的时候间内，源主机如果没有接到ICMP的应答包，则说明目标主机不可达；如果接收到了ICMP回送响应消息，则说明目标主机可达。



### Cookie和Session的关系和区别是什么？<Badge text="重要" type="danger" />

#### Cookie

**概念**

Cookie是服务器发送到用户浏览器并保存在本地的一小块数据，它会在浏览器下次向同一服务器再发起请求时被携带并发送到服务器上。通常，它用于告知服务器两个请求是否来自同一浏览器。

如保持用户的登录状态，**Cookie 使基于无状态的 HTTP 协议记录稳定的状态信息成为了可能**。

**作用**

- 会话状态管理（如用户登录状态、购物车、游戏分数或其它需要记录的信息）
- 个性化设置（如用户自定义设置、主题等）
- 浏览器行为跟踪（如跟踪分析用户行为等）

#### Session

Session代表着服务器和客户端一次会话的过程。Session 对象存储特定用户会话所需的属性及配置信息。这样，当用户在应用程序的 Web 页之间跳转时，存储在 Session 对象中的变量将不会丢失，而是在整个用户会话中一直存在下去。当客户端关闭会话，或者 Session 超时失效时会话结束。

#### 差别

- **作用范围不同**：Cookie 保存在客户端（浏览器），Session 保存在服务端
- **存取方式的不同**：Cookie 只能保存 ASCII，Session 可以存任意数据类型
- **有效期不同**：Cookie 可设置为长时间保持，比如经常使用的默认登录功能，Session 一般失效时间较短，客户端关闭或者 Session 超时都会失效
- **隐私策略不同**：Cookie 存储在客户端，比较容易遭到不法获取；Session 存储在服务端，安全性相对 Cookie 要好一些
- **存储大小不同**：单个 Cookie 保存的数据不能超过 4K，Session 可存储数据远高于 Cookie



### iPv4和iPv6的区别？<Badge text="了解" type="info" />

- IPv6的首部长度是40个字节，相对IPv4的首部长度24字节要长，但IPv6首部结构比IPv4简单。

- IPv6 把 IP 地址由 32 位增加到 128 位，从而能够支持更大的地址空间。IPv6 简化了路由， 加快了路由速度。

- IPv6 的可选项不放入报头，而是放在一个个独立的扩展头部。如果不指定路由器不会打开处理扩展头部， IPv6 放宽了对可选项长度的严格要求 (IPv4 的可选项总长最多为 40 字节) ，并可根据需要随时引入新选项。 

- IPv6协议支持地址自动配置，这是一种即插即用的机制。IPv6节点通过地址自动配置得到IPv6地址和网关地址。IPv6支持无状态地址自动配置和状态地址自动配置两种地址自动配置方式。它会给配置128位的地址带来很大的方便，特别是无状态地址自动配置。

- 在IPv6 中加入了关于身份验证、数据一致性和保密性的内容。



### 什么是跨域，什么情况下会发生跨域请求？<Badge text="掌握" type="tip" />

#### 概念

指的是浏览器不能执行其他网站的脚本。它是由浏览器的同源策略造成的。a页面想获取b页面资源，如果a、b页面的协议、域名、端口、子域名不同，所进行的访问行动都是跨域的，而浏览器为了安全问题一般都限制了跨域访问，也就是不允许跨域请求资源。

#### 解决方法

- **Nginx**：使用Nginx作为代理服务器和用户交互，用户就只需要在80端口上进行交互就可以了，这样就避免了跨域问题。
- **JSONP**：网页通过添加一个script元素，向服务器请求 JSON 数据，服务器收到请求后，将数据放在一个指定名字的回调函数的参数位置传回来。缺点是只支持get请求，不支持post请求。
- **CORS**：跨域资源分享。





[^1]: http://www.zhanghuihui.cloud/2022/10/03/%E8%AE%A1%E7%AE%97%E6%9C%BA%E7%BD%91%E7%BB%9C%E9%9D%A2%E7%BB%8F/

