# Generated by Django 2.0.5 on 2018-05-12 15:42

import datetime
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('user', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='RechargeRecord',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='编号')),
                ('value', models.FloatField(verbose_name='金额')),
                ('time', models.DateTimeField(default=datetime.datetime.now, verbose_name='充值时间')),
                ('mode', models.CharField(choices=[('alipay', '支付宝'), ('wechatpay', '微信'), ('cash', '现金')], max_length=10, verbose_name='充值方式')),
                ('card_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user.Card', verbose_name='卡号')),
            ],
            options={
                'verbose_name': '充值记录',
                'verbose_name_plural': '充值记录',
            },
        ),
        migrations.CreateModel(
            name='Student',
            fields=[
                ('student_id', models.CharField(max_length=20, primary_key=True, serialize=False, verbose_name='学号')),
                ('college', models.CharField(max_length=40, verbose_name='学院')),
                ('sex', models.CharField(choices=[('female', '女'), ('male', '男')], max_length=10, verbose_name='性别')),
                ('grade', models.CharField(max_length=10, verbose_name='u年级')),
                ('dormitory', models.CharField(max_length=20, verbose_name='寝室')),
                ('card_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user.Card', verbose_name='卡号')),
            ],
            options={
                'verbose_name': '学生信息',
                'verbose_name_plural': '学生信息',
                'ordering': ['student_id'],
            },
        ),
    ]
