# Generated by Django 2.0.5 on 2018-05-12 15:42

import datetime
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('user', '0002_rechargerecord_student'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccessRecord',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='编号')),
                ('time', models.DateTimeField(default=datetime.datetime.now, verbose_name='时间')),
                ('location', models.CharField(default=' ', max_length=40, verbose_name='地点')),
                ('card_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user.Card', verbose_name='卡号')),
            ],
            options={
                'verbose_name': '门禁记录',
                'verbose_name_plural': '门禁记录',
            },
        ),
        migrations.CreateModel(
            name='ConsumeRecord',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='编号')),
                ('value', models.FloatField(verbose_name='消费金额')),
                ('time', models.DateTimeField(default=datetime.datetime.now, verbose_name='消费时间')),
                ('location', models.CharField(default=' ', max_length=40, verbose_name='消费地点')),
                ('card_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user.Card', verbose_name='卡号')),
            ],
            options={
                'verbose_name': '消费记录',
                'verbose_name_plural': '消费记录',
            },
        ),
        migrations.CreateModel(
            name='Library',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='编号')),
                ('book_id', models.CharField(max_length=10, verbose_name='书本编号')),
                ('borrow_time', models.DateField(default=datetime.datetime.today, verbose_name='借书日期')),
                ('ending_time', models.DateField(default=datetime.datetime(2018, 6, 11, 23, 42, 45, 382306), verbose_name='应还时间')),
                ('state', models.CharField(choices=[('returned', '已归还'), ('unreturned', '借阅中')], max_length=12, verbose_name='状态')),
                ('card_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='user.Card', verbose_name='卡号')),
            ],
            options={
                'verbose_name': '图书借阅信息',
                'verbose_name_plural': '图书借阅信息',
            },
        ),
    ]
