/*
 Navicat Premium Data Transfer

 Source Server         : local-test
 Source Server Type    : MySQL
 Source Server Version : 50711
 Source Host           : localhost
 Source Database       : weather

 Target Server Type    : MySQL
 Target Server Version : 50711
 File Encoding         : utf-8

 Date: 06/01/2016 17:36:41 PM
*/

SET NAMES utf8;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
--  Table structure for `aqi`
-- ----------------------------
DROP TABLE IF EXISTS `aqi`;
CREATE TABLE `aqi` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `PM25` int(11) DEFAULT NULL,
  `O3` int(11) DEFAULT NULL,
  `SO2` int(11) DEFAULT NULL,
  `NO2` int(11) DEFAULT NULL,
  `CO` int(11) DEFAULT NULL,
  `PM10` int(11) DEFAULT NULL,
  `major` int(11) DEFAULT NULL,
  `district` bigint(20) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `aqi_station`
-- ----------------------------
DROP TABLE IF EXISTS `aqi_station`;
CREATE TABLE `aqi_station` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `station` bigint(20) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `PM25` int(11) DEFAULT NULL,
  `PM10` int(11) DEFAULT NULL,
  `O3` int(11) DEFAULT NULL,
  `major` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `city`
-- ----------------------------
DROP TABLE IF EXISTS `city`;
CREATE TABLE `city` (
  `id` bigint(20) NOT NULL,
  `ishot` int(11) NOT NULL,
  `pinyin` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  `province` bigint(20) NOT NULL,
  `title` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Records of `city`
-- ----------------------------
BEGIN;
INSERT INTO `city` VALUES ('101', '1', 'beijing', '1', '北京'), ('201', '1', 'shanghai', '2', '上海'), ('301', '1', 'tianjin', '3', '天津'), ('401', '1', 'chongqing', '4', '重庆'), ('501', '1', 'haerbin', '5', '哈尔滨'), ('502', '1', 'qiqihaer', '5', '齐齐哈尔'), ('503', '1', 'mudanjiang', '5', '牡丹江'), ('504', '1', 'jiamusi', '5', '佳木斯'), ('505', '1', 'suihua', '5', '绥化'), ('506', '1', 'heihe', '5', '黑河'), ('507', '1', 'daxinganling', '5', '大兴安岭'), ('508', '1', 'yichun', '5', '伊春'), ('509', '1', 'daqing', '5', '大庆'), ('510', '1', 'qitaihe', '5', '七台河'), ('511', '1', 'jixi', '5', '鸡西'), ('512', '1', 'hegang', '5', '鹤岗'), ('513', '1', 'shuangyashan', '5', '双鸭山'), ('601', '1', 'changchun', '6', '长春'), ('602', '1', 'jilin', '6', '吉林'), ('603', '2', 'yanbian', '6', '延边'), ('604', '1', 'siping', '6', '四平'), ('605', '1', 'tonghua', '6', '通化'), ('606', '1', 'baicheng', '6', '白城'), ('607', '1', 'liaoyuan', '6', '辽源'), ('608', '1', 'songyuan', '6', '松原'), ('609', '1', 'baishan', '6', '白山'), ('701', '1', 'shenyang', '7', '沈阳'), ('702', '1', 'dalian', '7', '大连'), ('703', '1', 'anshan', '7', '鞍山'), ('704', '1', 'fushun', '7', '抚顺'), ('705', '1', 'benxi', '7', '本溪'), ('706', '1', 'dandong', '7', '丹东'), ('707', '1', 'jinzhou1', '7', '锦州'), ('708', '1', 'yingkou', '7', '营口'), ('709', '1', 'fuxin', '7', '阜新'), ('710', '1', 'liaoyang', '7', '辽阳'), ('711', '1', 'tieling', '7', '铁岭'), ('712', '1', 'chaoyang1', '7', '朝阳'), ('713', '1', 'panjin', '7', '盘锦'), ('714', '1', 'huludao', '7', '葫芦岛'), ('801', '1', 'huhehaote', '8', '呼和浩特'), ('802', '1', 'baotou', '8', '包头'), ('803', '1', 'wuhai', '8', '乌海'), ('804', '2', 'wulanchabu', '8', '乌兰察布'), ('805', '1', 'tongliao', '8', '通辽'), ('806', '1', 'chifeng', '8', '赤峰'), ('807', '1', 'eerduosi', '8', '鄂尔多斯'), ('808', '2', 'bayanzhuoer', '8', '巴彦淖尔'), ('809', '2', 'xilingguole', '8', '锡林郭勒'), ('810', '2', 'hulunbeier', '8', '呼伦贝尔'), ('811', '2', 'xinganmeng', '8', '兴安盟'), ('812', '2', 'alashanmeng', '8', '阿拉善盟'), ('901', '1', 'shijiazhuang', '9', '石家庄'), ('902', '1', 'baoding', '9', '保定'), ('903', '1', 'zhangjiakou', '9', '张家口'), ('904', '1', 'chengde', '9', '承德'), ('905', '1', 'tangshan', '9', '唐山'), ('906', '1', 'langfang', '9', '廊坊'), ('907', '1', 'cangzhou', '9', '沧州'), ('908', '1', 'hengshui', '9', '衡水'), ('909', '1', 'xingtai', '9', '邢台'), ('910', '1', 'handan', '9', '邯郸'), ('911', '1', 'qinhuangdao', '9', '秦皇岛'), ('1001', '1', 'taiyuan', '10', '太原'), ('1002', '1', 'datong', '10', '大同'), ('1003', '1', 'yangquan', '10', '阳泉'), ('1004', '1', 'jinzhong', '10', '晋中'), ('1005', '1', 'changzhi', '10', '长治'), ('1006', '1', 'jincheng', '10', '晋城'), ('1007', '1', 'linfen', '10', '临汾'), ('1008', '1', 'yuncheng', '10', '运城'), ('1009', '1', 'shuozhou', '10', '朔州'), ('1010', '1', 'xinzhou', '10', '忻州'), ('1011', '1', 'lvliang', '10', '吕梁'), ('1101', '1', 'xian', '11', '西安'), ('1102', '1', 'xianyang', '11', '咸阳'), ('1103', '1', 'yanan', '11', '延安'), ('1104', '1', 'yulin', '11', '榆林'), ('1105', '1', 'weinan', '11', '渭南'), ('1106', '1', 'shangluo', '11', '商洛'), ('1107', '1', 'ankang', '11', '安康'), ('1108', '1', 'hanzhong', '11', '汉中'), ('1109', '1', 'baoji', '11', '宝鸡'), ('1110', '1', 'tongchuan', '11', '铜川'), ('1111', '1', 'yangling', '11', '杨凌'), ('1201', '1', 'jinan', '12', '济南'), ('1202', '1', 'qingdao', '12', '青岛'), ('1203', '1', 'zibo', '12', '淄博'), ('1204', '1', 'dezhou', '12', '德州'), ('1205', '1', 'yantai', '12', '烟台'), ('1206', '1', 'weifang', '12', '潍坊'), ('1207', '1', 'jining1', '12', '济宁'), ('1208', '1', 'taian1', '12', '泰安'), ('1209', '1', 'linyi2', '12', '临沂'), ('1210', '1', 'heze', '12', '菏泽'), ('1211', '1', 'binzhou', '12', '滨州'), ('1212', '1', 'dongying', '12', '东营'), ('1213', '1', 'weihai', '12', '威海'), ('1214', '1', 'zaozhuang', '12', '枣庄'), ('1215', '1', 'rizhao', '12', '日照'), ('1216', '1', 'laiwu', '12', '莱芜'), ('1217', '1', 'liaocheng', '12', '聊城'), ('1301', '1', 'wulumuqi', '13', '乌鲁木齐'), ('1302', '1', 'kelamayi', '13', '克拉玛依'), ('1303', '1', 'shihezi', '13', '石河子'), ('1304', '1', 'changji', '13', '昌吉'), ('1305', '1', 'tulufan', '13', '吐鲁番'), ('1306', '2', 'bazhou1', '13', '巴州'), ('1307', '1', 'alaer', '13', '阿拉尔'), ('1308', '1', 'akesu', '13', '阿克苏'), ('1309', '1', 'kashi', '13', '喀什'), ('1310', '2', 'yili', '13', '伊犁'), ('1311', '1', 'tacheng', '13', '塔城'), ('1312', '1', 'hami', '13', '哈密'), ('1313', '1', 'hetian', '13', '和田'), ('1314', '1', 'aletai', '13', '阿勒泰'), ('1315', '2', 'kezhou', '13', '克州'), ('1316', '2', 'bozhou', '13', '博州'), ('1401', '1', 'lasa', '14', '拉萨'), ('1402', '1', 'rikaze', '14', '日喀则'), ('1403', '1', 'shannan', '14', '山南'), ('1404', '1', 'linzhi', '14', '林芝'), ('1405', '1', 'changdu', '14', '昌都'), ('1406', '1', 'naqu', '14', '那曲'), ('1407', '1', 'ali', '14', '阿里'), ('1501', '1', 'xining', '15', '西宁'), ('1502', '1', 'haidong', '15', '海东'), ('1503', '1', 'huangnan', '15', '黄南'), ('1504', '1', 'hainan', '15', '海南'), ('1505', '1', 'guoluo', '15', '果洛'), ('1506', '1', 'yushu1', '15', '玉树'), ('1507', '1', 'haixi', '15', '海西'), ('1508', '1', 'haibei', '15', '海北'), ('1509', '1', 'geermu', '15', '格尔木'), ('1601', '1', 'lanzhou', '16', '兰州'), ('1602', '1', 'dingxi', '16', '定西'), ('1603', '1', 'pingliang', '16', '平凉'), ('1604', '2', 'qingyang', '16', '庆阳'), ('1605', '1', 'wuwei', '16', '武威'), ('1606', '1', 'jinchang', '16', '金昌'), ('1607', '1', 'zhangye', '16', '张掖'), ('1608', '1', 'jiuquan', '16', '酒泉'), ('1609', '1', 'tianshui', '16', '天水'), ('1610', '2', 'longnan1', '16', '陇南'), ('1611', '1', 'linxia', '16', '临夏'), ('1612', '2', 'gannan', '16', '甘南'), ('1613', '1', 'baiyin', '16', '白银'), ('1614', '1', 'jiayuguan', '16', '嘉峪关'), ('1701', '1', 'yinchuan', '17', '银川'), ('1702', '1', 'shizuishan', '17', '石嘴山'), ('1703', '1', 'wuzhong', '17', '吴忠'), ('1704', '1', 'guyuan1', '17', '固原'), ('1705', '1', 'zhongwei', '17', '中卫'), ('1801', '1', 'zhengzhou', '18', '郑州'), ('1802', '1', 'anyang', '18', '安阳'), ('1803', '1', 'xinxiang', '18', '新乡'), ('1804', '1', 'xuchang', '18', '许昌'), ('1805', '1', 'pingdingshan', '18', '平顶山'), ('1806', '1', 'xinyang', '18', '信阳'), ('1807', '1', 'nanyang', '18', '南阳'), ('1808', '1', 'kaifeng', '18', '开封'), ('1809', '1', 'luoyang', '18', '洛阳'), ('1810', '1', 'shangqiu', '18', '商丘'), ('1811', '1', 'jiaozuo', '18', '焦作'), ('1812', '1', 'hebi', '18', '鹤壁'), ('1813', '1', 'puyang', '18', '濮阳'), ('1814', '1', 'zhoukou', '18', '周口'), ('1815', '1', 'luohe', '18', '漯河'), ('1816', '1', 'zhumadian', '18', '驻马店'), ('1817', '1', 'sanmenxia', '18', '三门峡'), ('1818', '1', 'jiyuan', '18', '济源'), ('1901', '1', 'nanjing', '19', '南京'), ('1902', '1', 'wuxi1', '19', '无锡'), ('1903', '1', 'zhenjiang', '19', '镇江'), ('1904', '1', 'suzhou', '19', '苏州'), ('1905', '1', 'nantong', '19', '南通'), ('1906', '1', 'yangzhou', '19', '扬州'), ('1907', '1', 'yancheng', '19', '盐城'), ('1908', '1', 'xuzhou', '19', '徐州'), ('1909', '1', 'huaian1', '19', '淮安'), ('1910', '1', 'lianyungang', '19', '连云港'), ('1911', '1', 'changzhou', '19', '常州'), ('1912', '1', 'taizhou2', '19', '泰州'), ('1913', '1', 'suqian', '19', '宿迁'), ('2001', '1', 'wuhan', '20', '武汉'), ('2002', '1', 'xiangyang', '20', '襄阳'), ('2003', '1', 'ezhou', '20', '鄂州'), ('2004', '1', 'xiaogan', '20', '孝感'), ('2005', '1', 'huanggang', '20', '黄冈'), ('2006', '1', 'huangshi', '20', '黄石'), ('2007', '1', 'xianning', '20', '咸宁'), ('2008', '1', 'jingzhou', '20', '荆州'), ('2009', '1', 'yichang', '20', '宜昌'), ('2010', '1', 'enshi', '20', '恩施'), ('2011', '1', 'shiyan', '20', '十堰'), ('2012', '1', 'shennongjia', '20', '神农架'), ('2013', '1', 'suizhou', '20', '随州'), ('2014', '1', 'jingmen', '20', '荆门'), ('2015', '1', 'tianmen', '20', '天门'), ('2016', '1', 'xiantao', '20', '仙桃'), ('2017', '1', 'qianjiang1', '20', '潜江'), ('2101', '1', 'hangzhou', '21', '杭州'), ('2102', '1', 'huzhou', '21', '湖州'), ('2103', '1', 'jiaxing', '21', '嘉兴'), ('2104', '1', 'ningbo', '21', '宁波'), ('2105', '1', 'shaoxing', '21', '绍兴'), ('2106', '1', 'taizhou', '21', '台州'), ('2107', '1', 'wenzhou', '21', '温州'), ('2108', '1', 'lishui', '21', '丽水'), ('2109', '1', 'jinhua', '21', '金华'), ('2110', '1', 'quzhou1', '21', '衢州'), ('2111', '1', 'zhoushan', '21', '舟山'), ('2201', '1', 'hefei', '22', '合肥'), ('2202', '1', 'bengbu', '22', '蚌埠'), ('2203', '1', 'wuhu', '22', '芜湖'), ('2204', '1', 'huainan', '22', '淮南'), ('2205', '1', 'maanshan', '22', '马鞍山'), ('2206', '1', 'anqing', '22', '安庆'), ('2207', '1', 'suzhou1', '22', '宿州'), ('2208', '1', 'fuyang1', '22', '阜阳'), ('2209', '1', 'bozhou2', '22', '亳州'), ('2210', '1', 'huangshan', '22', '黄山'), ('2211', '1', 'chuzhou1', '22', '滁州'), ('2212', '1', 'huaibei', '22', '淮北'), ('2213', '1', 'tongling', '22', '铜陵'), ('2214', '1', 'xuancheng', '22', '宣城'), ('2215', '1', 'luan', '22', '六安'), ('2216', '1', 'chaohu', '22', '巢湖'), ('2217', '1', 'chizhou', '22', '池州'), ('2301', '1', 'fuzhou', '23', '福州'), ('2302', '1', 'xiamen', '23', '厦门'), ('2303', '1', 'ningde', '23', '宁德'), ('2304', '1', 'putian', '23', '莆田'), ('2305', '1', 'quanzhou', '23', '泉州'), ('2306', '1', 'zhangzhou', '23', '漳州'), ('2307', '1', 'longyan', '23', '龙岩'), ('2308', '1', 'sanming', '23', '三明'), ('2309', '1', 'nanping', '23', '南平'), ('2310', '1', 'diaoyudao', '23', '钓鱼岛'), ('2401', '1', 'nanchang', '24', '南昌'), ('2402', '1', 'jiujiang', '24', '九江'), ('2403', '1', 'shangrao', '24', '上饶'), ('2404', '1', 'fuzhou1', '24', '抚州'), ('2405', '1', 'yichun1', '24', '宜春'), ('2406', '1', 'jian1', '24', '吉安'), ('2407', '1', 'ganzhou', '24', '赣州'), ('2408', '1', 'jingdezhen', '24', '景德镇'), ('2409', '1', 'pingxiang1', '24', '萍乡'), ('2410', '1', 'xinyu', '24', '新余'), ('2411', '1', 'yingtan', '24', '鹰潭'), ('2501', '1', 'changsha', '25', '长沙'), ('2502', '1', 'xiangtan', '25', '湘潭'), ('2503', '1', 'zhuzhou', '25', '株洲'), ('2504', '1', 'hengyang', '25', '衡阳'), ('2505', '1', 'chenzhou', '25', '郴州'), ('2506', '1', 'changde', '25', '常德'), ('2507', '1', 'yiyang1', '25', '益阳'), ('2508', '1', 'loudi', '25', '娄底'), ('2509', '1', 'shaoyang', '25', '邵阳'), ('2510', '1', 'yueyang', '25', '岳阳'), ('2511', '1', 'zhangjiajie', '25', '张家界'), ('2512', '1', 'huaihua', '25', '怀化'), ('2514', '1', 'yongzhou', '25', '永州'), ('2515', '2', 'xiangxi', '25', '湘西'), ('2601', '1', 'guiyang1', '26', '贵阳'), ('2602', '1', 'zunyi', '26', '遵义'), ('2603', '1', 'anshun', '26', '安顺'), ('2604', '2', 'qiannan', '26', '黔南'), ('2605', '2', 'qiandongnan', '26', '黔东南'), ('2606', '1', 'tongren', '26', '铜仁'), ('2607', '1', 'bijie', '26', '毕节'), ('2608', '2', 'liupanshui', '26', '六盘水'), ('2609', '2', 'qianxinan', '26', '黔西南'), ('2701', '1', 'chengdu', '27', '成都'), ('2702', '1', 'panzhihua', '27', '攀枝花'), ('2703', '1', 'zigong', '27', '自贡'), ('2704', '1', 'mianyang', '27', '绵阳'), ('2705', '1', 'nanchong', '27', '南充'), ('2706', '1', 'dazhou', '27', '达州'), ('2707', '1', 'suining1', '27', '遂宁'), ('2708', '1', 'guangan', '27', '广安'), ('2709', '1', 'bazhong', '27', '巴中'), ('2710', '1', 'luzhou', '27', '泸州'), ('2711', '1', 'yibin', '27', '宜宾'), ('2712', '1', 'neijiang', '27', '内江'), ('2713', '1', 'ziyang1', '27', '资阳'), ('2714', '1', 'leshan', '27', '乐山'), ('2715', '1', 'meishan', '27', '眉山'), ('2716', '1', 'liangshan1', '27', '凉山'), ('2717', '1', 'yaan', '27', '雅安'), ('2718', '1', 'ganzi', '27', '甘孜'), ('2719', '1', 'aba', '27', '阿坝'), ('2720', '1', 'deyang', '27', '德阳'), ('2721', '1', 'guangyuan', '27', '广元'), ('2801', '1', 'guangzhou', '28', '广州'), ('2802', '1', 'shaoguan', '28', '韶关'), ('2803', '1', 'huizhou', '28', '惠州'), ('2804', '1', 'meizhou', '28', '梅州'), ('2805', '1', 'shantou', '28', '汕头'), ('2806', '1', 'shenzhen', '28', '深圳'), ('2807', '1', 'zhuhai', '28', '珠海'), ('2808', '1', 'foshan', '28', '佛山'), ('2809', '1', 'zhaoqing', '28', '肇庆'), ('2810', '1', 'zhanjiang', '28', '湛江'), ('2811', '1', 'jiangmen', '28', '江门'), ('2812', '1', 'heyuan', '28', '河源'), ('2813', '1', 'qingyuan3', '28', '清远'), ('2814', '1', 'yunfu', '28', '云浮'), ('2815', '1', 'chaozhou', '28', '潮州'), ('2816', '1', 'dongguan', '28', '东莞'), ('2817', '1', 'zhongshan', '28', '中山'), ('2818', '1', 'yangjiang', '28', '阳江'), ('2819', '1', 'jieyang', '28', '揭阳'), ('2820', '1', 'maoming', '28', '茂名'), ('2821', '1', 'shanwei', '28', '汕尾'), ('2901', '1', 'kunming', '29', '昆明'), ('2902', '1', 'dali1', '29', '大理'), ('2903', '1', 'honghe', '29', '红河'), ('2904', '1', 'qujing', '29', '曲靖'), ('2905', '1', 'baoshan1', '29', '保山'), ('2906', '1', 'wenshan', '29', '文山'), ('2907', '1', 'yuxi', '29', '玉溪'), ('2908', '1', 'chuxiong', '29', '楚雄'), ('2909', '1', 'puer', '29', '普洱'), ('2910', '1', 'zhaotong', '29', '昭通'), ('2911', '1', 'lincang', '29', '临沧'), ('2912', '1', 'nujiang', '29', '怒江'), ('2913', '2', 'diqing', '29', '迪庆'), ('2914', '1', 'lijiang', '29', '丽江'), ('2915', '1', 'dehong', '29', '德宏'), ('2916', '2', 'xishuangbanna', '29', '西双版纳'), ('3001', '1', 'nanning', '30', '南宁'), ('3002', '1', 'chongzuo', '30', '崇左'), ('3003', '1', 'liuzhou', '30', '柳州'), ('3004', '1', 'laibin', '30', '来宾'), ('3005', '1', 'guilin', '30', '桂林'), ('3006', '1', 'wuzhou', '30', '梧州'), ('3007', '1', 'hezhou', '30', '贺州'), ('3008', '1', 'guigang', '30', '贵港'), ('3009', '1', 'yulin1', '30', '玉林'), ('3010', '1', 'baise', '30', '百色'), ('3011', '1', 'qinzhou', '30', '钦州'), ('3012', '1', 'hechi', '30', '河池'), ('3013', '1', 'beihai', '30', '北海'), ('3014', '1', 'fangchenggang', '30', '防城港'), ('3101', '1', 'haikou', '31', '海口'), ('3102', '1', 'sanya', '31', '三亚'), ('3103', '1', 'dongfang', '31', '东方'), ('3104', '1', 'lingao', '31', '临高'), ('3105', '1', 'chengmai', '31', '澄迈'), ('3106', '1', 'danzhou', '31', '儋州'), ('3107', '1', 'changjiang', '31', '昌江'), ('3108', '1', 'baisha', '31', '白沙'), ('3109', '1', 'qiongzhong', '31', '琼中'), ('3110', '1', 'dingan', '31', '定安'), ('3111', '1', 'tunchang', '31', '屯昌'), ('3112', '1', 'qionghai', '31', '琼海'), ('3113', '1', 'wenchang', '31', '文昌'), ('3114', '1', 'baoting', '31', '保亭'), ('3115', '1', 'wanning', '31', '万宁'), ('3116', '1', 'lingshui', '31', '陵水'), ('3117', '1', 'xisha', '31', '西沙'), ('3118', '1', 'nanshadao', '31', '南沙岛'), ('3119', '1', 'ledong', '31', '乐东'), ('3120', '1', 'wuzhishan', '31', '五指山'), ('3201', '1', 'hongkong', '32', '香港'), ('3301', '1', 'aomen', '33', '澳门'), ('3401', '1', 'taibei', '34', '台北'), ('3402', '1', 'gaoxiong', '34', '高雄'), ('3404', '1', 'taizhong', '34', '台中'), ('3405', '1', 'taiwan', '34', '台湾'), ('3406', '1', 'xinbei', '34', '新北');
COMMIT;

-- ----------------------------
--  Table structure for `district`
-- ----------------------------
DROP TABLE IF EXISTS `district`;
CREATE TABLE `district` (
  `id` bigint(20) NOT NULL,
  `city` bigint(20) NOT NULL,
  `ishot` int(11) NOT NULL,
  `pinyin` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  `pinyin_aqi` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  `title` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  `altitude` decimal(10,5) NOT NULL,
  `area_code` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `latitude` decimal(10,5) NOT NULL,
  `longitude` decimal(10,5) NOT NULL,
  `zipcode` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Records of `district`
-- ----------------------------
BEGIN;
INSERT INTO `district` VALUES ('101010100', '101', '1', 'beijing', 'beijing', '北京', '33.00000', '', '39.90400', '116.39100', '100000'), ('101010200', '102', '0', 'haidian', '', '海淀', '47.00000', '', '39.59000', '116.17000', '100080'), ('101010300', '103', '0', 'chaoyang', 'chaoyang', '朝阳', '37.00000', '', '39.57000', '116.29000', '100016'), ('101010400', '104', '0', 'shunyi', '', '顺义', '40.00000', '', '40.14700', '116.71600', '101300'), ('101010500', '105', '0', 'huairou', '', '怀柔', '76.00000', '', '40.64300', '116.58100', '101400'), ('101010600', '106', '0', 'tongzhou', '', '通州', '41.00000', '', '39.55000', '116.38000', '101100'), ('101010700', '107', '0', 'changping', '', '昌平', '80.00000', '', '40.20600', '116.16500', '102200'), ('101010800', '108', '0', 'yanqing', '', '延庆', '489.00000', '', '40.52500', '116.14800', '102100'), ('101010900', '109', '0', 'fengtai', '', '丰台', '57.00000', '', '39.85900', '116.28600', '100071'), ('101011000', '110', '0', 'shijingshan', '', '石景山', '67.00000', '', '39.56000', '116.11000', '100043'), ('101011100', '111', '0', 'daxing', '', '大兴', '41.00000', '', '39.63900', '116.47500', '102600'), ('101011200', '112', '0', 'fangshan', '', '房山', '49.00000', '', '37.89800', '111.30800', '102400'), ('101011300', '113', '0', 'miyun', '', '密云', '73.00000', '', '40.50900', '117.08700', '101500'), ('101011400', '114', '0', 'mentougou', '', '门头沟', '94.00000', '', '39.55000', '116.07000', '102300'), ('101011500', '115', '0', 'pinggu', '', '平谷', '29.00000', '', '40.20400', '117.15000', '101200'), ('101020100', '201', '1', 'shanghai', 'shanghai', '上海', '19.00000', '', '31.21300', '121.44500', '200000'), ('101020200', '202', '0', 'minhang', '', '闵行', '10.00000', '', '31.07000', '121.23000', '201100'), ('101020300', '203', '0', 'baoshan', '', '宝山', '8.00000', '', '31.41700', '121.48300', '201900'), ('101020500', '205', '0', 'jiading', '', '嘉定', '9.00000', '', '31.36300', '121.26300', '201800'), ('101020600', '206', '0', 'nanhui', '', '南汇', '9.00000', '', '31.00700', '121.71200', '201300'), ('101020700', '207', '0', 'jinshan', '', '金山', '9.00000', '', '30.82400', '121.21100', '201500'), ('101020800', '208', '0', 'qingpu', '', '青浦', '9.00000', '', '31.11500', '121.08700', '201700'), ('101020900', '209', '0', 'songjiang', '', '松江', '9.00000', '', '31.02900', '121.19000', '201600'), ('101021000', '210', '0', 'fengxian', '', '奉贤', '9.00000', '', '30.90800', '121.55100', '201400'), ('101021100', '211', '0', 'chongming', '', '崇明', '9.00000', '', '31.65800', '121.52600', '202150'), ('101021200', '212', '0', 'xujiahui', '', '徐家汇', '19.00000', '', '31.21300', '121.44500', '200000'), ('101021300', '213', '0', 'pudong', '', '浦东', '44.00000', '', '31.22196', '121.54472', '200000'), ('101030100', '301', '1', 'tianjin', 'tianjin', '天津', '5.00000', '', '39.11700', '117.24600', '300000'), ('101030200', '302', '0', 'wuqing', '', '武清', '10.00000', '', '39.42300', '117.06500', '301700'), ('101030300', '303', '0', 'baodi', '', '宝坻', '11.00000', '', '39.59500', '117.41800', '301800'), ('101030400', '304', '0', 'dongli', '', '东丽', '5.00000', '', '39.04000', '117.25000', '300301'), ('101030500', '305', '0', 'xiqing', '', '西青', '4.00000', '', '39.05000', '117.04000', '300380'), ('101030600', '306', '0', 'beichen', '', '北辰', '4.00000', '', '39.13000', '117.07000', '300400'), ('101030700', '307', '0', 'ninghe', '', '宁河', '12.00000', '', '39.38600', '117.66800', '301500'), ('101030800', '308', '0', 'hangu', '', '汉沽', '6.00000', '', '39.14000', '117.46000', '300480'), ('101030900', '309', '0', 'jinghai', '', '静海', '11.00000', '', '38.82900', '116.98300', '301600'), ('101031000', '310', '0', 'jinnan', '', '津南', '9.00000', '', '38.59000', '117.22000', '300350'), ('101031100', '311', '0', 'tanggu', '', '塘沽', '13.00000', '', '39.00000', '117.43000', '300450'), ('101031200', '312', '0', 'dagang', '', '大港', '5.00000', '', '38.50000', '117.30000', '300270'), ('101031400', '314', '0', 'jixian', '', '蓟县', '20.00000', '', '40.04600', '117.40800', '301900'), ('101040100', '401', '1', 'chongqing', 'chongqing', '重庆', '260.00000', '', '29.58100', '106.54900', '400000'), ('101040200', '402', '0', 'yongchuan', '', '永川', '376.00000', '', '29.25100', '105.85300', '402160'), ('101040300', '403', '0', 'hechuan', '', '合川', '231.00000', '', '30.11400', '106.31800', '401520'), ('101040400', '404', '0', 'nanchuan', '', '南川', '560.00000', '', '29.13700', '107.16100', '408400'), ('101040500', '405', '0', 'jiangjin', '', '江津', '256.00000', '', '28.99800', '106.20500', '402260'), ('101040600', '406', '0', 'wansheng', '', '万盛', '326.00000', '', '28.57000', '106.56000', '400800'), ('101040700', '407', '0', 'yubei', '', '渝北', '438.00000', '', '29.43000', '106.38000', '401120'), ('101040800', '408', '0', 'beibei', '', '北碚', '243.00000', '', '29.51000', '106.27000', '400700'), ('101040900', '409', '0', 'banan', '', '巴南', '244.00000', '', '29.23000', '106.31000', '401320'), ('101041000', '410', '0', 'changshou', '', '长寿', '379.00000', '', '29.97200', '107.14800', '401220'), ('101041100', '411', '0', 'qianjiang', '', '黔江', '609.00000', '', '30.36000', '112.76500', '409000'), ('101041300', '413', '0', 'wanzhou', '', '万州', '189.00000', '', '30.46000', '108.24000', '404000'), ('101041400', '414', '0', 'fuling', '', '涪陵', '273.00000', '', '29.68600', '107.32500', '408000'), ('101041500', '415', '0', 'kaixian', '', '开县', '166.00000', '', '31.12000', '108.26000', '405400'), ('101041600', '416', '0', 'chengkou', '', '城口', '800.00000', '', '31.91900', '108.77000', '405900'), ('101041700', '417', '0', 'yunyang', '', '云阳', '297.00000', '', '31.00900', '108.82700', '404500'), ('101041800', '418', '0', 'wuxi', '', '巫溪', '340.00000', '', '31.24000', '109.37000', '405800'), ('101041900', '419', '0', 'fengjie', '', '奉节', '608.00000', '', '30.93600', '109.38700', '404600'), ('101042000', '420', '0', 'wushan', '', '巫山', '271.00000', '', '31.12300', '109.87400', '404700'), ('101042100', '421', '0', 'tongnan', '', '潼南', '296.00000', '', '30.11200', '105.77200', '402660'), ('101042200', '422', '0', 'dianjiang', '', '垫江', '417.00000', '', '30.24900', '107.44400', '408300'), ('101042300', '423', '0', 'liangping', '', '梁平', '459.00000', '', '30.65900', '107.73600', '405200'), ('101042400', '424', '0', 'zhongxian', '', '忠县', '326.00000', '', '30.18000', '108.02000', '404300'), ('101042500', '425', '0', 'shizhu', '', '石柱', '570.00000', '', '30.00000', '108.07000', '409100'), ('101042600', '426', '0', 'dazu', '', '大足', '395.00000', '', '29.62000', '105.74900', '402360'), ('101042700', '427', '0', 'rongchang', '', '荣昌', '330.00000', '', '29.46900', '105.51000', '402460'), ('101042800', '428', '0', 'tongliang', '', '铜梁', '276.00000', '', '29.80900', '106.02700', '402560'), ('101042900', '429', '0', 'bishan', '', '璧山', '290.00000', '', '29.58500', '106.19600', '402760'), ('101043000', '430', '0', 'fengdu', '', '丰都', '215.00000', '', '29.91200', '107.83400', '408200'), ('101043100', '431', '0', 'wulong', '', '武隆', '273.00000', '', '29.35400', '107.65600', '408500'), ('101043200', '432', '0', 'pengshui', '', '彭水', '322.00000', '', '29.18000', '108.10000', '409600'), ('101043300', '433', '0', 'qijiang', '', '綦江', '255.00000', '', '28.82100', '106.64900', '401420'), ('101043400', '434', '0', 'youyang', '', '酉阳', '666.00000', '', '28.50000', '108.46000', '409800'), ('101043600', '436', '0', 'xiushan', '', '秀山', '364.00000', '', '28.27000', '108.59000', '409900'), ('101050101', '501', '1', 'haerbin', 'haerbin', '哈尔滨', '143.00000', '', '45.75800', '126.64500', '150000'), ('101050102', '501', '0', 'shuangcheng', '', '双城', '167.00000', '', '45.42100', '126.19300', '150100'), ('101050103', '501', '0', 'hulan', '', '呼兰', '125.00000', '', '46.13100', '126.73100', '150500'), ('101050104', '501', '0', 'acheng', '', '阿城', '175.00000', '', '45.60100', '127.15700', '150300'), ('101050105', '501', '0', 'binxian', '', '宾县', '193.00000', '', '45.47000', '127.27000', '150400'), ('101050106', '501', '0', 'yilan', '', '依兰', '101.00000', '', '46.24600', '129.71400', '154800'), ('101050107', '501', '0', 'bayan', 'bayanchuoer', '巴彦', '135.00000', '', '46.28900', '127.22700', '151800'), ('101050108', '501', '0', 'tonghe', '', '通河', '110.00000', '', '46.24600', '128.78400', '150900'), ('101050109', '501', '0', 'fangzheng', '', '方正', '120.00000', '', '45.85500', '128.88900', '150800'), ('101050110', '501', '0', 'yanshou', '', '延寿', '157.00000', '', '45.46100', '128.49900', '150701'), ('101050111', '501', '0', 'shangzhi', '', '尚志', '191.00000', '', '45.03900', '128.21800', '150601'), ('101050112', '501', '0', 'wuchang', '', '五常', '196.00000', '', '44.54000', '127.09000', '150200'), ('101050113', '501', '0', 'mulan', '', '木兰', '114.00000', '', '46.25200', '127.91100', '151900'), ('101050201', '502', '1', 'qiqihaer', 'qiqihaer', '齐齐哈尔', '155.00000', '', '47.34300', '123.96400', '161000'), ('101050202', '502', '0', 'nehe', '', '讷河', '273.00000', '', '48.43800', '125.14500', '161300'), ('101050203', '502', '0', 'longjiang', '', '龙江', '187.00000', '', '47.19700', '122.99200', '161100'), ('101050204', '502', '0', 'gannan1', '', '甘南', '165.00000', '', '48.06000', '123.68700', '162100'), ('101050205', '502', '0', 'fuyu', '', '富裕', '147.00000', '', '47.48000', '124.29000', '161200'), ('101050206', '502', '0', 'yian', '', '依安', '232.00000', '', '47.54000', '125.18000', '161500'), ('101050207', '502', '0', 'baiquan', '', '拜泉', '240.00000', '', '47.58800', '126.02800', '161700'), ('101050208', '502', '0', 'keshan', '', '克山', '295.00000', '', '48.20400', '125.65900', '161600'), ('101050209', '502', '0', 'kedong', '', '克东', '92.00000', '', '47.99700', '126.33400', '161800'), ('101050210', '502', '0', 'tailai', '', '泰来', '151.00000', '', '46.67600', '123.49600', '162400'), ('101050301', '503', '1', 'mudanjiang', 'mudanjiang', '牡丹江', '243.00000', '', '44.57900', '129.61100', '157000'), ('101050302', '503', '0', 'hailin', '', '海林', '262.00000', '', '44.90800', '129.08800', '157100'), ('101050303', '503', '0', 'muling', '', '穆棱', '267.00000', '', '44.47500', '130.35600', '157500'), ('101050304', '503', '0', 'linkou', '', '林口', '274.00000', '', '45.31500', '130.03100', '157600'), ('101050305', '503', '0', 'suifenhe', '', '绥芬河', '498.00000', '', '44.41400', '131.08100', '157300'), ('101050306', '503', '0', 'ningan', '', '宁安', '272.00000', '', '44.20000', '129.28000', '157400'), ('101050307', '503', '0', 'dongning', '', '东宁', '118.00000', '', '44.12400', '130.81300', '157200'), ('101050401', '504', '1', 'jiamusi', '', '佳木斯', '82.00000', '', '46.79600', '130.36400', '154000'), ('101050402', '504', '0', 'tangyuan', '', '汤原', '96.00000', '', '46.93700', '130.23700', '154700'), ('101050403', '504', '0', 'fuyuan', '', '抚远', '66.00000', '', '47.93800', '134.38000', '156500'), ('101050404', '504', '0', 'huachuan', '', '桦川', '79.00000', '', '46.88000', '130.66700', '154300'), ('101050405', '504', '0', 'huanan', '', '桦南', '183.00000', '', '46.28300', '130.59500', '154400'), ('101050406', '504', '0', 'tongjiang', '', '同江', '59.00000', '', '47.39000', '132.30000', '156400'), ('101050407', '504', '0', 'fujin', '', '富锦', '65.00000', '', '47.19000', '132.43300', '156100'), ('101050501', '505', '1', 'suihua', '', '绥化', '180.00000', '', '46.63200', '126.99100', '152000'), ('101050502', '505', '0', 'zhaodong', '', '肇东', '148.00000', '', '45.96500', '125.83900', '151100'), ('101050503', '505', '0', 'anda', '', '安达', '150.00000', '', '46.52000', '125.39300', '151400'), ('101050504', '505', '0', 'hailun', '', '海伦', '240.00000', '', '47.41600', '126.98700', '152300'), ('101050505', '505', '0', 'mingshui', '', '明水', '250.00000', '', '47.19800', '125.86500', '151700'), ('101050506', '505', '0', 'wangkui', '', '望奎', '170.00000', '', '46.83700', '126.57500', '152100'), ('101050507', '505', '0', 'lanxi', '', '兰西', '164.00000', '', '46.15000', '126.16000', '151500'), ('101050508', '505', '0', 'qinggang', '', '青冈', '206.00000', '', '46.79900', '125.84400', '151600'), ('101050509', '505', '0', 'qingan', '', '庆安', '186.00000', '', '46.53000', '127.29000', '152400'), ('101050510', '505', '0', 'suiling', '', '绥棱', '204.00000', '', '47.57100', '127.65600', '152200'), ('101050601', '506', '1', 'heihe', '', '黑河', '243.00000', '', '50.24600', '127.48800', '164300'), ('101050602', '506', '0', 'nenjiang', '', '嫩江', '235.00000', '', '49.85200', '125.78200', '161400'), ('101050603', '506', '0', 'sunwu', '', '孙吴', '113.00000', '', '49.33300', '127.33400', '164200'), ('101050604', '506', '0', 'xunke', '', '逊克', '204.00000', '', '49.35000', '128.28000', '164400'), ('101050605', '506', '0', 'wudalianchi', '', '五大连池', '272.00000', '', '48.72500', '126.20300', '164100'), ('101050606', '506', '0', 'beian', '', '北安', '236.00000', '', '48.17000', '126.31000', '164000'), ('101050701', '507', '1', 'daxinganling', '', '大兴安岭', '167.00000', '', '51.89800', '124.81500', '165000'), ('101050702', '507', '0', 'tahe', '', '塔河', '522.00000', '', '52.74900', '124.56900', '165200'), ('101050703', '507', '0', 'mohe', '', '漠河', '434.00000', '', '52.90300', '122.73100', '165300'), ('101050704', '507', '0', 'huma', '', '呼玛', '372.00000', '', '51.89800', '124.81500', '165100'), ('101050705', '507', '0', 'huzhong', '', '呼中', '496.00000', '', '52.03000', '123.40000', '165036'), ('101050706', '507', '0', 'xinlin', '', '新林', '178.00000', '', '51.42000', '124.20000', '165023'), ('101050708', '507', '0', 'jiagedaqi', '', '加格达奇', '372.00000', '', '50.40000', '124.12000', '165000'), ('101050801', '508', '1', 'yichun', '', '伊春', '246.00000', '', '47.00500', '128.28300', '153000'), ('101050802', '508', '0', 'wuyiling', '', '乌伊岭', '191.00000', '', '48.34000', '129.26000', '153038'), ('101050803', '508', '0', 'wuying', '', '五营', '299.00000', '', '48.07000', '129.15000', '153033'), ('101050804', '508', '0', 'tieli', '', '铁力', '213.00000', '', '46.96800', '128.51400', '152500'), ('101050805', '508', '0', 'jiayin', '', '嘉荫', '405.00000', '', '48.78700', '129.96500', '153200'), ('101050901', '509', '1', 'daqing', 'daqing', '大庆', '151.00000', '', '46.59300', '125.01600', '163000'), ('101050902', '509', '0', 'lindian', '', '林甸', '220.00000', '', '47.14800', '124.81800', '162300'), ('101050903', '509', '0', 'zhaozhou', '', '肇州', '150.00000', '', '45.89900', '125.29100', '151200'), ('101050904', '509', '0', 'zhaoyuan', '', '肇源', '129.00000', '', '45.30000', '125.05000', '151300'), ('101050905', '509', '0', 'duerbote', '', '杜尔伯特', '145.00000', '', '46.83000', '124.42000', '166200'), ('101051002', '510', '1', 'qitaihe', '', '七台河', '221.00000', '', '45.95500', '130.85500', '154600'), ('101051003', '510', '0', 'boli', '', '勃利', '234.00000', '', '45.75000', '130.58000', '154500'), ('101051101', '511', '1', 'jixi', '', '鸡西', '238.00000', '', '45.28200', '130.97000', '158100'), ('101051102', '511', '0', 'hulin', '', '虎林', '104.00000', '', '45.99900', '133.04200', '158400'), ('101051103', '511', '0', 'mishan', '', '密山', '151.00000', '', '45.46700', '132.19000', '158300'), ('101051104', '511', '0', 'jidong', '', '鸡东', '178.00000', '', '45.26900', '131.18200', '158200'), ('101051201', '512', '1', 'hegang', '', '鹤岗', '231.00000', '', '47.32600', '130.27900', '154100'), ('101051202', '512', '0', 'suibin', '', '绥滨', '63.00000', '', '47.45900', '131.82100', '156200'), ('101051203', '512', '0', 'luobei', '', '萝北', '85.00000', '', '47.77800', '130.85300', '154204'), ('101051301', '513', '1', 'shuangyashan', '', '双鸭山', '176.00000', '', '46.62900', '131.14700', '155100'), ('101051302', '513', '0', 'jixian1', '', '集贤', '106.00000', '', '46.82300', '131.14500', '154900'), ('101051303', '513', '0', 'baoqing', '', '宝清', '84.00000', '', '46.34200', '132.37300', '156600'), ('101051304', '513', '0', 'raohe', '', '饶河', '56.00000', '', '46.48000', '134.00000', '156700'), ('101051305', '513', '0', 'youyi', '', '友谊', '65.00000', '', '46.78200', '131.80000', ''), ('101060101', '601', '1', 'changchun', 'changchun', '长春', '239.00000', '', '43.87100', '125.32400', '130000'), ('101060102', '601', '0', 'nongan', '', '农安', '190.00000', '', '44.25000', '125.10000', '130200'), ('101060103', '601', '0', 'dehui', '', '德惠', '185.00000', '', '43.75800', '125.31200', '130326'), ('101060104', '601', '0', 'jiutai', '', '九台', '176.00000', '', '44.18400', '125.96000', '130500'), ('101060105', '601', '0', 'yushu', '', '榆树', '206.00000', '', '44.50000', '126.32000', '130400'), ('101060106', '601', '0', 'shuangyang', '', '双阳', '236.00000', '', '43.60000', '125.72600', '130600'), ('101060201', '602', '1', 'jilin', 'jilin', '吉林', '184.00000', '', '43.85000', '126.56700', '132000'), ('101060202', '602', '0', 'shulan', '', '舒兰', '258.00000', '', '44.30000', '127.07700', '132600'), ('101060203', '602', '0', 'yongji', '', '永吉', '232.00000', '', '43.42000', '126.31000', '132200'), ('101060204', '602', '0', 'jiaohe', '', '蛟河', '295.00000', '', '43.68100', '127.33200', '132500'), ('101060205', '602', '0', 'panshi', '', '磐石', '339.00000', '', '43.06100', '126.15600', '132300'), ('101060206', '602', '0', 'huadian', '', '桦甸', '264.00000', '', '43.02400', '127.00100', '132400'), ('101060301', '603', '0', 'yanji', '', '延吉', '178.00000', '', '42.90700', '129.51200', '133000'), ('101060302', '603', '0', 'dunhua', '', '敦化', '525.00000', '', '43.60700', '128.34000', '133700'), ('101060303', '603', '0', 'antu', '', '安图', '369.00000', '', '42.70600', '128.49000', '133600'), ('101060304', '603', '0', 'wangqing', '', '汪清', '242.00000', '', '43.58000', '130.00600', '133200'), ('101060305', '603', '0', 'helong', '', '和龙', '475.00000', '', '42.47400', '128.89400', '133500'), ('101060307', '603', '0', 'longjing', '', '龙井', '245.00000', '', '42.88600', '129.37100', '133400'), ('101060308', '603', '0', 'hunchun', '', '珲春', '38.00000', '', '42.54000', '130.17000', '133300'), ('101060309', '603', '0', 'tumen', '', '图们', '141.00000', '', '43.00500', '129.76200', '133100'), ('101060401', '604', '1', 'siping', '', '四平', '166.00000', '', '43.16100', '124.36500', '136000'), ('101060402', '604', '0', 'shuangliao', '', '双辽', '117.00000', '', '43.73200', '123.69700', '136400'), ('101060403', '604', '0', 'lishu', '', '梨树', '164.00000', '', '43.29600', '124.32100', '136500'), ('101060404', '604', '0', 'gongzhuling', '', '公主岭', '201.00000', '', '43.65500', '124.97800', '136100'), ('101060405', '604', '0', 'yitong', '', '伊通', '249.00000', '', '43.21000', '125.17000', '130700'), ('101060501', '605', '1', 'tonghua', '', '通化', '404.00000', '', '41.72100', '125.92900', '134001'), ('101060502', '605', '0', 'meihekou', '', '梅河口', '341.00000', '', '42.57700', '125.85100', '135000'), ('101060503', '605', '0', 'liuhe', '', '柳河', '363.00000', '', '42.23600', '125.94200', '135300'), ('101060504', '605', '0', 'huinan', '', '辉南', '307.00000', '', '42.54400', '126.35900', '135100'), ('101060505', '605', '0', 'jian', '', '集安', '179.00000', '', '41.06000', '126.09000', '134200'), ('101060506', '605', '0', 'tonghuaxian', '', '通化县', '373.00000', '', '41.40000', '125.45000', '134100'), ('101060601', '606', '1', 'baicheng', '', '白城', '156.00000', '', '45.61500', '122.83900', '137000'), ('101060602', '606', '0', 'taonan', '', '洮南', '152.00000', '', '45.53100', '122.48200', '137100'), ('101060603', '606', '0', 'daan', '', '大安', '139.00000', '', '45.30000', '124.16000', '131300'), ('101060604', '606', '0', 'zhenlai', '', '镇赉', '142.00000', '', '45.87800', '123.42700', '137300'), ('101060605', '606', '0', 'tongyu', '', '通榆', '151.00000', '', '44.74500', '122.78800', '137200'), ('101060701', '607', '1', 'liaoyuan', '', '辽源', '254.00000', '', '42.90300', '125.13400', '136200'), ('101060702', '607', '0', 'dongfeng', '', '东丰', '343.00000', '', '42.76300', '125.43600', '136300'), ('101060703', '607', '0', 'dongliao', '', '东辽', '268.00000', '', '42.91000', '124.97900', '136600'), ('101060801', '608', '1', 'songyuan', '', '松原', '141.00000', '', '45.11000', '124.50000', '138000'), ('101060802', '608', '0', 'qianan', '', '乾安', '148.00000', '', '45.00000', '124.01000', '131400'), ('101060803', '608', '0', 'qianguo', '', '前郭', '137.00000', '', '45.07000', '124.50000', '131100'), ('101060804', '608', '0', 'changling', '', '长岭', '190.00000', '', '44.33600', '123.92700', '131500'), ('101060805', '608', '0', 'fuyu1', '', '扶余', '198.00000', '', '44.58000', '126.00000', '131200'), ('101060901', '609', '1', 'baishan', '', '白山', '523.00000', '', '41.52500', '126.39500', '134300'), ('101060902', '609', '0', 'jingyu', '', '靖宇', '550.00000', '', '42.46000', '126.88700', '135200'), ('101060903', '609', '0', 'linjiang', '', '临江', '334.00000', '', '41.48000', '126.55000', '134600'), ('101060904', '609', '0', 'donggang', '', '东岗', '775.00000', '', '42.06000', '127.34000', '134504'), ('101060905', '609', '0', 'changbai', '', '长白', '778.00000', '', '42.21000', '128.10000', '134400'), ('101060906', '609', '0', 'fusong', '', '抚松', '588.00000', '', '42.32600', '127.26600', '134500'), ('101060907', '609', '0', 'jiangyuan', '', '江源', '608.00000', '', '42.05300', '126.58200', '134700'), ('101070101', '701', '1', 'shenyang', 'shenyang', '沈阳', '51.00000', '', '41.79900', '123.41800', '110000'), ('101070103', '701', '0', 'liaozhong', '', '辽中', '14.00000', '', '41.48700', '122.78800', '110200'), ('101070104', '701', '0', 'kangping', '', '康平', '119.00000', '', '42.77500', '123.18400', '110500'), ('101070105', '701', '0', 'faku', '', '法库', '100.00000', '', '42.39400', '123.25100', '110400'), ('101070106', '701', '0', 'xinmin', '', '新民', '32.00000', '', '41.59000', '122.50000', '110300'), ('101070201', '702', '1', 'dalian', 'dalian', '大连', '100.00000', '', '38.94400', '121.57600', '116000'), ('101070202', '702', '0', 'wafangdian', 'wafangdian', '瓦房店', '120.00000', '', '39.73700', '121.75900', '116300'), ('101070203', '702', '0', 'jinzhou', '', '金州', '37.00000', '', '41.12400', '121.09200', '116100'), ('101070204', '702', '0', 'pulandian', '', '普兰店', '32.00000', '', '39.24000', '121.58000', '116200'), ('101070205', '702', '0', 'lvshun', '', '旅顺', '62.00000', '', '38.49000', '121.14000', '160000'), ('101070206', '702', '0', 'changhai', '', '长海', '34.00000', '', '39.52700', '122.98700', '116500'), ('101070207', '702', '0', 'zhuanghe', '', '庄河', '39.00000', '', '39.84000', '123.00000', '116400'), ('101070301', '703', '1', 'anshan', 'maanshan', '鞍山', '72.00000', '', '41.11500', '122.97700', '114000'), ('101070302', '703', '0', 'taian', '', '台安', '9.00000', '', '41.23000', '122.26000', '114100'), ('101070303', '703', '0', 'xiuyan', '', '岫岩', '81.00000', '', '40.17000', '123.17000', '114300'), ('101070304', '703', '0', 'haicheng', '', '海城', '27.00000', '', '40.82600', '122.72400', '114200'), ('101070401', '704', '1', 'fushun', 'fushun', '抚顺', '329.00000', '', '41.85900', '123.90600', '113000'), ('101070402', '704', '0', 'xinbin', '', '新宾', '358.00000', '', '41.72200', '125.03400', ''), ('101070403', '704', '0', 'qingyuan', '', '清原', '235.00000', '', '42.06000', '124.55000', '113300'), ('101070404', '704', '0', 'zhangdang', '', '章党', '120.00000', '', '41.55000', '124.05000', '113006'), ('101070501', '705', '1', 'benxi', 'benxi', '本溪', '183.00000', '', '41.30200', '123.76500', '117000'), ('101070502', '705', '0', 'benxixian', '', '本溪县', '211.00000', '', '41.18000', '124.17000', '117100'), ('101070504', '705', '0', 'huanren', '', '桓仁', '249.00000', '', '41.16000', '125.21000', '117200'), ('101070601', '706', '1', 'dandong', 'dandong', '丹东', '12.00000', '', '40.11000', '124.35700', '118000'), ('101070602', '706', '0', 'fengcheng', '', '凤城', '74.00000', '', '40.45200', '124.06700', '118100'), ('101070603', '706', '0', 'kuandian', '', '宽甸', '262.00000', '', '40.43000', '124.47000', '118200'), ('101070604', '706', '0', 'donggang1', '', '东港', '8.00000', '', '39.99000', '123.86100', '118000'), ('101070701', '707', '1', 'jinzhou1', 'jinzhou', '锦州', '70.00000', '', '41.11600', '121.14400', '121000'), ('101070702', '707', '0', 'linghai', '', '凌海', '58.00000', '', '41.19000', '121.22000', '121200'), ('101070704', '707', '0', 'yixian', '', '义县', '70.00000', '', '41.31000', '121.14000', '121100'), ('101070705', '707', '0', 'heishan', '', '黑山', '38.00000', '', '41.79900', '122.19800', '121400'), ('101070706', '707', '0', 'beizhen', '', '北镇', '80.00000', '', '41.35000', '121.46000', '121300'), ('101070801', '708', '1', 'yingkou', 'yingkou', '营口', '4.00000', '', '40.68600', '122.27800', '115000'), ('101070802', '708', '0', 'dashiqiao', '', '大石桥', '12.00000', '', '40.37000', '122.29000', '115100'), ('101070803', '708', '0', 'gaizhou', '', '盖州', '28.00000', '', '40.25000', '122.21000', '115200'), ('101070901', '709', '1', 'fuxin', 'fuxin', '阜新', '172.00000', '', '42.01900', '121.64700', '123000'), ('101070902', '709', '0', 'zhangwu', '', '彰武', '84.00000', '', '42.48900', '122.42400', '123200'), ('101071001', '710', '1', 'liaoyang', 'liaoyang', '辽阳', '26.00000', '', '41.26600', '123.17100', '111000'), ('101071002', '710', '0', 'liaoyangxian', '', '辽阳县', '31.00000', '', '41.12000', '123.04000', '111200'), ('101071003', '710', '0', 'dengta', '', '灯塔', '43.00000', '', '41.41500', '123.27800', '111300'), ('101071004', '710', '0', 'gongchangling', '', '弓长岭', '58.00000', '', '41.14800', '123.43800', ''), ('101071101', '711', '1', 'tieling', 'tieling', '铁岭', '82.00000', '', '42.29100', '123.83100', '112000'), ('101071102', '711', '0', 'kaiyuan', '', '开原', '99.00000', '', '42.32000', '124.03000', '112300'), ('101071103', '711', '0', 'changtu', '', '昌图', '165.00000', '', '43.02200', '123.98700', '112500'), ('101071104', '711', '0', 'xifeng', '', '西丰', '201.00000', '', '42.44000', '124.45000', '112400'), ('101071105', '711', '0', 'diaobingshan', '', '铁法', '94.00000', '', '42.46800', '123.54400', ''), ('101071201', '712', '1', 'chaoyang1', 'chaoyang', '朝阳', '176.00000', '', '41.57900', '120.45600', '122000'), ('101071203', '712', '0', 'lingyuan', '', '凌源', '418.00000', '', '41.01600', '119.23300', '122500'), ('101071204', '712', '0', 'kazuo', '', '喀左', '298.00000', '', '41.05000', '119.43000', '122300'), ('101071205', '712', '0', 'beipiao', '', '北票', '182.00000', '', '41.83500', '120.77600', '122100'), ('101071207', '712', '0', 'jianpingxian', '', '建平县', '425.00000', '', '41.23000', '119.42000', '122400'), ('101071301', '713', '1', 'panjin', 'panjin', '盘锦', '4.00000', '', '41.15300', '122.27700', '124000'), ('101071302', '713', '0', 'dawa', '', '大洼', '5.00000', '', '40.96700', '122.00000', '124200'), ('101071303', '713', '0', 'panshan', '', '盘山', '4.00000', '', '41.15300', '122.27700', '124000'), ('101071401', '714', '1', 'huludao', 'huludao', '葫芦岛', '14.00000', '', '40.69900', '120.84000', '125000'), ('101071402', '714', '0', 'jianchang', '', '建昌', '368.00000', '', '40.75700', '119.75300', '125300'), ('101071403', '714', '0', 'suizhong', '', '绥中', '16.00000', '', '40.30300', '120.04700', '125200'), ('101071404', '714', '0', 'xingcheng', '', '兴城', '10.00000', '', '40.35000', '120.42000', '125100'), ('101080101', '801', '1', 'huhehaote', 'huhehaote', '呼和浩特', '1065.00000', '', '40.81900', '111.68600', '010000'), ('101080102', '801', '0', 'tuzuoqi', '', '土左旗', '1022.00000', '', '40.41000', '111.09000', '010100'), ('101080103', '801', '0', 'tuoxian', '', '托县', '1018.00000', '', '40.16000', '111.11000', '010200'), ('101080104', '801', '0', 'helin', '', '和林', '1154.00000', '', '40.23000', '111.48000', '011500'), ('101080105', '801', '0', 'qingshuihe', '', '清水河', '1191.00000', '', '39.88500', '111.72400', '011600'), ('101080106', '801', '0', 'hushijiaoqu', '', '呼市郊区', '1053.00000', '', '40.48000', '111.42000', '010020'), ('101080107', '801', '0', 'wuchuan', '', '武川', '1598.00000', '', '41.06000', '111.27000', '011700'), ('101080201', '802', '1', 'baotou', 'baotou', '包头', '1069.00000', '', '40.65700', '109.80900', '014000'), ('101080202', '802', '0', 'baiyunebo', '', '白云鄂博', '1613.00000', '', '41.46000', '109.58000', '014080'), ('101080203', '802', '0', 'mandula', '', '满都拉', '1226.00000', '', '42.32000', '110.08000', '11926'), ('101080204', '802', '0', 'tuyouqi', '', '土右旗', '1001.00000', '', '40.33000', '110.32000', '014100'), ('101080205', '802', '0', 'guyang', '', '固阳', '1361.00000', '', '41.10800', '110.18400', '014200'), ('101080206', '802', '0', 'damaoqi', '', '达茂旗', '1376.00000', '', '41.42000', '110.26000', '011900'), ('101080207', '802', '0', 'xilamuren', '', '希拉穆仁', '1603.00000', '', '41.19000', '111.14000', '011915'), ('101080301', '803', '1', 'wuhai', 'wuhai', '乌海', '1093.00000', '', '39.49300', '106.70500', '016000'), ('101080401', '804', '0', 'jining', '', '集宁', '1422.00000', '', '41.03100', '113.09100', '012000'), ('101080402', '804', '0', 'zhuozi', '', '卓资', '1453.00000', '', '40.95000', '112.40300', '012300'), ('101080403', '804', '0', 'huade', '', '化德', '1485.00000', '', '41.95500', '114.17800', '013350'), ('101080404', '804', '0', 'shangdu', '', '商都', '1387.00000', '', '41.72600', '113.69800', '013450'), ('101080406', '804', '0', 'xinghe', '', '兴和', '1253.00000', '', '40.53000', '113.52000', '013650'), ('101080407', '804', '0', 'liangcheng', '', '凉城', '1259.00000', '', '40.50300', '112.52700', '013750'), ('101080408', '804', '0', 'chayouqianqi', '', '察右前旗', '1318.00000', '', '40.48000', '113.13000', '012200'), ('101080409', '804', '0', 'chayouzhongqi', '', '察右中旗', '1749.00000', '', '41.16000', '112.37000', '013550'), ('101080410', '804', '0', 'chayouhouqi', '', '察右后旗', '1425.00000', '', '41.27000', '113.11000', '012400'), ('101080411', '804', '0', 'siziwangqi', '', '四子王旗', '1490.00000', '', '41.32000', '111.41000', '011800'), ('101080412', '804', '0', 'fengzhen', '', '丰镇', '1193.00000', '', '40.55900', '113.29200', '012100'), ('101080501', '805', '1', 'tongliao', 'tongliao', '通辽', '180.00000', '', '43.65600', '122.34000', '028000'), ('101080502', '805', '0', 'shebotu', '', '舍伯吐', '183.00000', '', '44.02000', '122.01000', '029322'), ('101080503', '805', '0', 'kezuozhongqi', '', '科左中旗', '147.00000', '', '44.08000', '123.18000', '029300'), ('101080504', '805', '0', 'kezuohouqi', '', '科左后旗', '249.00000', '', '42.58000', '122.21000', '028100'), ('101080505', '805', '0', 'qinglongshan', '', '青龙山', '400.00000', '', '42.24000', '121.04000', '28314'), ('101080506', '805', '0', 'kailu', '', '开鲁', '242.00000', '', '43.72100', '121.13800', '028400'), ('101080507', '805', '0', 'kulun', '', '库伦', '287.00000', '', '42.44000', '121.47000', '028200'), ('101080508', '805', '0', 'naiman', '', '奈曼', '364.00000', '', '42.89400', '120.94900', '028300'), ('101080509', '805', '0', 'zhalute', '', '扎鲁特', '266.00000', '', '44.34000', '120.54000', '029100'), ('101080510', '805', '0', 'gaoliban', '', '高力板', '204.00000', '', '44.53000', '121.49000', '029408'), ('101080511', '805', '0', 'bayaertuhushuo', '', '巴雅尔吐胡硕', '629.00000', '', '45.04000', '120.20000', '029123'), ('101080601', '806', '1', 'chifeng', 'chifeng', '赤峰', '570.00000', '', '42.26100', '118.95200', '024000'), ('101080603', '806', '0', 'aluqi', '', '阿鲁旗', '375.00000', '', '43.53000', '120.03000', '025550'), ('101080604', '806', '0', 'haoertu', '', '浩尔吐', '711.00000', '', '44.27000', '119.18000', '025462'), ('101080605', '806', '0', 'balinzuoqi', '', '巴林左旗', '486.00000', '', '43.59000', '119.24000', '025450'), ('101080606', '806', '0', 'balinyouqi', '', '巴林右旗', '623.00000', '', '43.32000', '118.39000', '025150'), ('101080607', '806', '0', 'linxi', '', '林西', '800.00000', '', '43.36000', '118.04000', '025250'), ('101080608', '806', '0', 'keshiketeng', '', '克什克腾', '1005.00000', '', '43.15000', '117.32000', '025350'), ('101080609', '806', '0', 'wengniute', '', '翁牛特', '633.00000', '', '42.57000', '119.02000', '024500'), ('101080610', '806', '0', 'gangzi', '', '岗子', '961.00000', '', '42.35000', '118.25000', '024000'), ('101080611', '806', '0', 'kalaqin', '', '喀喇沁', '737.00000', '', '41.56000', '118.42000', '024400'), ('101080612', '806', '0', 'balihan', '', '八里罕', '41.00000', '', '41.31000', '118.45000', '024400'), ('101080613', '806', '0', 'ningcheng', '', '宁城', '551.00000', '', '41.58000', '118.83400', '024200'), ('101080614', '806', '0', 'aohan', '', '敖汉', '589.00000', '', '42.35400', '120.18300', '024300'), ('101080615', '806', '0', 'baoguotu', '', '宝国吐', '402.00000', '', '42.20000', '120.42000', '024323'), ('101080701', '807', '1', 'eerduosi', 'eerduozi', '鄂尔多斯', '10000.00000', '', '39.82500', '110.02300', '017000'), ('101080703', '807', '0', 'dalate', '', '达拉特', '1012.00000', '', '40.24000', '110.02000', '014300'), ('101080704', '807', '0', 'zhungeer', '', '准格尔', '1041.00000', '', '39.86000', '111.24000', '017100'), ('101080705', '807', '0', 'eqianqi', '', '鄂前旗', '1335.00000', '', '38.11000', '107.29000', '016200'), ('101080706', '807', '0', 'henan', '', '河南', '1211.00000', '', '37.51000', '108.43000', '017309'), ('101080707', '807', '0', 'yikewusu', '', '伊克乌素', '1185.00000', '', '40.03000', '107.51000', '017417'), ('101080708', '807', '0', 'etuoke', '', '鄂托克', '1381.00000', '', '39.06000', '107.59000', '016100'), ('101080709', '807', '0', 'hangjinqi', '', '杭锦旗', '1390.00000', '', '39.51000', '108.44000', '017400'), ('101080710', '807', '0', 'wushenqi', '', '乌审旗', '1309.00000', '', '38.36000', '108.50000', '017300'), ('101080711', '807', '0', 'yijinhuoluo', '', '伊金霍洛', '1331.00000', '', '39.34000', '109.44000', '017200'), ('101080712', '807', '0', 'wushenzhao', '', '乌审召', '1313.00000', '', '39.06000', '109.02000', '017314'), ('101080713', '807', '0', 'dongsheng', '', '东胜', '1461.00000', '', '39.82500', '110.02300', '017000'), ('101080801', '808', '0', 'linhe', '', '临河', '1041.00000', '', '40.73800', '107.43300', '015000'), ('101080802', '808', '0', 'wuyuan', '', '五原', '1024.00000', '', '41.06000', '108.16000', '015100'), ('101080803', '808', '0', 'dengkou', '', '磴口', '1057.00000', '', '40.56300', '106.67900', '015200'), ('101080804', '808', '0', 'wuqianqi', '', '乌前旗', '1022.00000', '', '40.44000', '108.39000', '014400'), ('101080805', '808', '0', 'dashetai', '', '大佘太', '1080.00000', '', '41.01000', '109.08000', '014423'), ('101080806', '808', '0', 'wuzhongqi', '', '乌中旗', '1290.00000', '', '41.34000', '108.31000', '015300'), ('101080807', '808', '0', 'wuhouqi', '', '乌后旗', '1578.00000', '', '41.27000', '106.59000', '015500'), ('101080808', '808', '0', 'hailisu', '', '海力素', '1511.00000', '', '41.24000', '106.24000', '015506'), ('101080809', '808', '0', 'narenbaolige', '', '那仁宝力格', '1183.00000', '', '44.37000', '114.09000', '026100'), ('101080810', '808', '0', 'hangjinhouqi', '', '杭锦后旗', '1058.00000', '', '40.54000', '107.08000', '015400'), ('101080901', '809', '0', 'xilinhaote', '', '锡林浩特', '991.00000', '', '43.56000', '116.03800', '026000'), ('101080903', '809', '0', 'erlianhaote', 'erlianhaote', '二连浩特', '966.00000', '', '43.39000', '111.58000', '011100'), ('101080904', '809', '0', 'abaga', '', '阿巴嘎', '1128.00000', '', '44.01000', '114.57000', '026100'), ('101080906', '809', '0', 'suzuoqi', '', '苏左旗', '1038.00000', '', '43.52000', '113.38000', '013150'), ('101080907', '809', '0', 'suyouqi', '', '苏右旗', '1103.00000', '', '42.45000', '112.39000', '012500'), ('101080908', '809', '0', 'zhurihe', '', '朱日和', '1152.00000', '', '42.24000', '112.54000', '012516'), ('101080909', '809', '0', 'dongwuqi', '', '东乌旗', '841.00000', '', '45.31000', '116.58000', '026300'), ('101080910', '809', '0', 'xiwuqi', '', '西乌旗', '997.00000', '', '44.35000', '117.36000', '026200'), ('101080911', '809', '0', 'taibusiqi', '', '太仆寺', '1469.00000', '', '41.53000', '115.16000', '027000'), ('101080912', '809', '0', 'xianghuang', '', '镶黄旗', '1322.00000', '', '42.14000', '113.50000', '013250'), ('101080913', '809', '0', 'zhengxiangbaiqi', '', '正镶白旗', '1348.00000', '', '42.57400', '114.93200', '027100'), ('101080914', '809', '0', 'zhenglanqi', '', '正兰旗', '1301.00000', '', '42.15000', '115.59000', '027200'), ('101080915', '809', '0', 'duolun', '', '多伦', '1247.00000', '', '42.22200', '116.42200', '027300'), ('101080916', '809', '0', 'boketu', '', '博克图', '742.00000', '', '48.46000', '121.55000', '022181'), ('101080917', '809', '0', 'wulagai', '', '乌拉盖', '867.00000', '', '45.43000', '118.48000', '026308'), ('101081001', '810', '0', 'hailaer', '', '海拉尔', '613.00000', '', '49.28200', '120.05300', '021000'), ('101081002', '810', '0', 'xiaoergou', '', '小二沟', '287.00000', '', '49.12000', '123.43000', '022450'), ('101081003', '810', '0', 'arongqi', '', '阿荣旗', '220.00000', '', '48.61700', '123.15500', '162750'), ('101081004', '810', '0', 'molidawa', '', '莫力达瓦', '194.00000', '', '48.28000', '124.29000', '162850'), ('101081005', '810', '0', 'elunchunqi', '', '鄂伦春旗', '425.00000', '', '50.35000', '123.44000', '022450'), ('101081006', '810', '0', 'ewenkeqi', '', '鄂温克旗', '622.00000', '', '49.09000', '119.45000', '021100'), ('101081007', '810', '0', 'chenqi', '', '陈旗', '578.00000', '', '49.19000', '119.26000', '021500'), ('101081008', '810', '0', 'xinzuoqi', '', '新左旗', '644.00000', '', '48.13000', '118.16000', '021200'), ('101081009', '810', '0', 'xinyouqi', '', '新右旗', '556.00000', '', '48.40000', '116.49000', '021300'), ('101081010', '810', '0', 'manzhouli', '', '满洲里', '662.00000', '', '49.48100', '117.53900', '021400'), ('101081011', '810', '0', 'yakeshi', '', '牙克石', '670.00000', '', '49.27400', '121.47400', '022150'), ('101081012', '810', '0', 'zhalantun', '', '扎兰屯', '308.00000', '', '48.00000', '122.44000', '162650'), ('101081014', '810', '0', 'eerguna', '', '额尔古纳', '582.00000', '', '50.15000', '120.11000', '022250'), ('101081015', '810', '0', 'genhe', '', '根河', '982.00000', '', '50.47000', '121.31000', '022350'), ('101081016', '810', '0', 'tulihe', '', '图里河', '733.00000', '', '50.29000', '121.41000', '022167'), ('101081101', '811', '0', 'wulanhaote', '', '乌兰浩特', '276.00000', '', '46.06800', '122.07100', '137400'), ('101081102', '811', '0', 'aershan', '', '阿尔山', '1028.00000', '', '47.10000', '119.57000', '137400'), ('101081103', '811', '0', 'keyouzhongqi', '', '科右中旗', '251.00000', '', '45.03000', '121.28000', '029400'), ('101081104', '811', '0', 'huerle', '', '胡尔勒', '335.00000', '', '46.43000', '122.05000', '137617'), ('101081105', '811', '0', 'zhalaite', '', '扎赉特', '189.00000', '', '46.43000', '122.54000', '137600'), ('101081106', '811', '0', 'suolun', '', '索伦', '501.00000', '', '46.36000', '121.13000', '137414'), ('101081107', '811', '0', 'tuquan', '', '突泉', '307.00000', '', '45.63200', '121.44900', '137500'), ('101081108', '811', '0', 'huolinguole', '', '霍林郭勒', '825.00000', '', '45.53000', '119.67000', '029200'), ('101081109', '811', '0', 'keyouqianqi', '', '科右前旗', '284.00000', '', '46.06300', '122.06900', ''), ('101081201', '812', '0', 'azuoqi', '', '阿左旗', '1563.00000', '', '39.64100', '105.11100', '750300'), ('101081202', '812', '0', 'ayouqi', '', '阿右旗', '1512.00000', '', '39.13000', '101.41000', '737300'), ('101081203', '812', '0', 'ejina', '', '额济纳', '941.00000', '', '41.57000', '101.04000', '735400'), ('101081204', '812', '0', 'guanzihu', '', '拐子湖', '960.00000', '', '41.22000', '102.22000', '735400'), ('101081205', '812', '0', 'jilantai', '', '吉兰太', '1033.00000', '', '39.47000', '105.45000', '750333'), ('101081206', '812', '0', 'xilingaole', '', '锡林高勒', '1235.00000', '', '39.05000', '105.23000', '750318'), ('101081207', '812', '0', 'toudaohu', '', '头道湖', '1343.00000', '', '38.03000', '105.08000', '750312'), ('101081208', '812', '0', 'zhongquanzi', '', '中泉子', '1241.00000', '', '39.18000', '102.42000', '737309'), ('101081209', '812', '0', 'nuoergong', '', '诺尔公', '1326.00000', '', '40.10000', '104.48000', '750322'), ('101081210', '812', '0', 'yabulai', '', '雅布赖', '1241.00000', '', '39.18000', '102.42000', '737309'), ('101081211', '812', '0', 'wusitai', '', '乌斯泰', '1343.00000', '', '38.03000', '105.08000', '750312'), ('101081212', '812', '0', 'luanjingtan', '', '孪井滩', '1235.00000', '', '39.05000', '105.23000', '750318'), ('101090101', '901', '1', 'shijiazhuang', 'shijiazhuang', '石家庄', '82.00000', '', '38.04200', '114.49800', '050000'), ('101090102', '901', '0', 'jingxing', '', '井陉', '256.00000', '', '38.02000', '114.08000', '050300'), ('101090103', '901', '0', 'zhengding', '', '正定', '76.00000', '', '38.16200', '114.54200', '050800'), ('101090104', '901', '0', 'luancheng', '', '栾城', '53.00000', '', '37.91000', '114.63400', '051430'), ('101090105', '901', '0', 'xingtang', '', '行唐', '99.00000', '', '38.27000', '114.33000', '050600'), ('101090106', '901', '0', 'lingshou', '', '灵寿', '110.00000', '', '38.50300', '114.15700', '050500'), ('101090107', '901', '0', 'gaoyi', '', '高邑', '50.00000', '', '37.61800', '114.60700', '051330'), ('101090108', '901', '0', 'shenze', '', '深泽', '38.00000', '', '38.20600', '115.22100', '052560'), ('101090109', '901', '0', 'zanhuang', '', '赞皇', '137.00000', '', '37.60200', '114.28300', '051230'), ('101090110', '901', '0', 'wuji', '', '无极', '47.00000', '', '38.17900', '114.95000', '052460'), ('101090111', '901', '0', 'pingshan', '', '平山', '131.00000', '', '38.15000', '114.12000', '050400'), ('101090112', '901', '0', 'yuanshi', '', '元氏', '51.00000', '', '37.79900', '114.40700', '051130'), ('101090113', '901', '0', 'zhaoxian', '', '赵县', '40.00000', '', '37.46000', '114.44000', '051530'), ('101090114', '901', '0', 'xinji', '', '辛集', '42.00000', '', '37.55000', '115.13000', '052360'), ('101090115', '901', '0', 'gaocheng', '', '藁城', '55.00000', '', '38.07800', '114.81900', '052160'), ('101090116', '901', '0', 'jinzhou2', '', '晋州', '44.00000', '', '38.03400', '115.04400', '052260'), ('101090117', '901', '0', 'xinle', '', '新乐', '76.00000', '', '38.21000', '114.41000', '050700'), ('101090118', '901', '0', 'luquan1', '', '鹿泉', '118.00000', '', '38.08300', '114.30800', ''), ('101090201', '902', '1', 'baoding', 'baoding', '保定', '19.00000', '', '38.86800', '115.48400', '071000'), ('101090202', '902', '0', 'mancheng', '', '满城', '40.00000', '', '38.93600', '115.23300', '072150'), ('101090203', '902', '0', 'fuping', '', '阜平', '283.00000', '', '38.51000', '114.11000', '073200'), ('101090204', '902', '0', 'xushui', '', '徐水', '17.00000', '', '39.01000', '115.39000', '072550'), ('101090205', '902', '0', 'tangxian', '', '唐县', '67.00000', '', '38.44000', '114.59000', '072350'), ('101090206', '902', '0', 'gaoyang', '', '高阳', '12.00000', '', '38.64700', '115.79700', '071500'), ('101090207', '902', '0', 'rongcheng', '', '容城', '15.00000', '', '39.03000', '115.51000', '071700'), ('101090209', '902', '0', 'laiyuan', '', '涞源', '846.00000', '', '39.36400', '114.70800', '074300'), ('101090210', '902', '0', 'wangdu', '', '望都', '46.00000', '', '38.65800', '115.16700', '072450'), ('101090211', '902', '0', 'anxin', '', '安新', '7.00000', '', '38.88000', '115.87500', '071600'), ('101090212', '902', '0', 'yixian1', '', '易县', '57.00000', '', '39.21000', '115.30000', '074200'), ('101090214', '902', '0', 'quyang', '', '曲阳', '105.00000', '', '38.71400', '114.64100', '073100'), ('101090215', '902', '0', 'lixian', '', '蠡县', '20.00000', '', '38.29000', '115.34000', '071400'), ('101090216', '902', '0', 'shunping', '', '顺平', '53.00000', '', '38.50000', '115.09000', '072250'), ('101090217', '902', '0', 'xiongxian', '', '雄县', '11.00000', '', '38.59000', '116.06000', '071800'), ('101090218', '902', '0', 'zhuozhou', '', '涿州', '30.00000', '', '39.47700', '115.99400', '072750'), ('101090219', '902', '0', 'dingzhou', '', '定州', '59.00000', '', '38.45600', '115.03100', '073000'), ('101090220', '902', '0', 'anguo', '', '安国', '31.00000', '', '38.40100', '115.33000', '071200'), ('101090221', '902', '0', 'gaobeidian', '', '高碑店', '30.00000', '', '39.20000', '115.51000', '074000'), ('101090222', '902', '0', 'laishui', '', '涞水', '59.00000', '', '39.39200', '115.70800', ''), ('101090223', '902', '0', 'dingxing', '', '定兴', '29.00000', '', '39.27000', '115.77400', ''), ('101090224', '902', '0', 'qingyuan1', '', '清苑', '20.00000', '', '38.75700', '115.48500', ''), ('101090225', '902', '0', 'boye', '', '博野', '24.00000', '', '38.45800', '115.45900', ''), ('101090301', '903', '1', 'zhangjiakou', 'zhangjiakou', '张家口', '726.00000', '', '40.76400', '114.93900', '075000'), ('101090302', '903', '0', 'xuanhua', '', '宣化', '630.00000', '', '40.34000', '115.02000', '075100'), ('101090303', '903', '0', 'zhangbei', '', '张北', '1394.00000', '', '41.25400', '114.81200', '076450'), ('101090304', '903', '0', 'kangbao', '', '康保', '1425.00000', '', '41.79600', '114.57300', '076650'), ('101090305', '903', '0', 'guyuan', '', '沽源', '1414.00000', '', '41.40000', '115.42000', '076550'), ('101090306', '903', '0', 'shangyi', '', '尚义', '1380.00000', '', '41.12500', '114.13000', '076750'), ('101090307', '903', '0', 'yuxian1', '', '蔚县', '911.00000', '', '39.50000', '114.34000', '075700'), ('101090308', '903', '0', 'yangyuan', '', '阳原', '940.00000', '', '40.13400', '114.35700', '075800'), ('101090309', '903', '0', 'huaian', '', '怀安', '802.00000', '', '40.41000', '114.24000', '076150'), ('101090310', '903', '0', 'wanquan', '', '万全', '756.00000', '', '40.84400', '114.58700', '076250'), ('101090311', '903', '0', 'huailai', '', '怀来', '542.00000', '', '40.33100', '115.61900', '075400'), ('101090312', '903', '0', 'zhuolu', '', '涿鹿', '531.00000', '', '39.47700', '115.99400', '075600'), ('101090313', '903', '0', 'chicheng', '', '赤城', '887.00000', '', '40.95000', '115.94100', '075500'), ('101090314', '903', '0', 'chongli', '', '崇礼', '1249.00000', '', '41.03100', '115.18400', '076350'), ('101090402', '904', '1', 'chengde', 'chengde', '承德', '386.00000', '', '41.03300', '118.02600', '067000'), ('101090403', '904', '0', 'chengdexian', '', '承德县', '270.00000', '', '40.46000', '118.10000', '067400'), ('101090404', '904', '0', 'xinglong', '', '兴隆', '584.00000', '', '40.25000', '117.29000', '067300'), ('101090405', '904', '0', 'pingquan', '', '平泉', '506.00000', '', '41.02300', '118.79800', '067500'), ('101090406', '904', '0', 'luanping', '', '滦平', '530.00000', '', '40.95900', '117.26700', '068250'), ('101090407', '904', '0', 'longhua', '', '隆化', '563.00000', '', '41.49000', '117.55100', '068150'), ('101090408', '904', '0', 'fengning', '', '丰宁', '662.00000', '', '41.13000', '116.38000', '068350'), ('101090409', '904', '0', 'kuancheng', '', '宽城', '306.00000', '', '40.36000', '118.29000', '067600'), ('101090410', '904', '0', 'weichang', '', '围场', '845.00000', '', '41.56000', '117.45000', '068450'), ('101090501', '905', '1', 'tangshan', 'tangshan', '唐山', '29.00000', '', '39.61600', '118.18000', '063000'), ('101090502', '905', '0', 'fengnan', '', '丰南', '5.00000', '', '39.43100', '118.15500', '063300'), ('101090503', '905', '0', 'fengrun', '', '丰润', '35.00000', '', '39.80400', '118.06000', '064000'), ('101090504', '905', '0', 'luanxian', '', '滦县', '47.00000', '', '39.44000', '118.45000', '063700'), ('101090505', '905', '0', 'luannan', '', '滦南', '17.00000', '', '39.40400', '118.62500', '063500'), ('101090506', '905', '0', 'laoting', '', '乐亭', '12.00000', '', '39.36500', '118.99500', '063600'), ('101090507', '905', '0', 'qianxi', '', '迁西', '108.00000', '', '40.09000', '118.18000', '064300'), ('101090508', '905', '0', 'yutian', '', '玉田', '19.00000', '', '39.76800', '117.72700', '064100'), ('101090509', '905', '0', 'tanghai', '', '唐海', '6.00000', '', '39.28400', '118.41000', '063200'), ('101090510', '905', '0', 'zunhua', '', '遵化', '56.00000', '', '40.14000', '117.89900', '064200'), ('101090511', '905', '0', 'qianan1', '', '迁安', '50.00000', '', '40.00000', '118.43000', '064400'), ('101090512', '905', '0', 'caofeidian', '', '曹妃甸', '22.00000', '', '39.10000', '118.45000', '063015'), ('101090601', '906', '1', 'langfang', 'langfang', '廊坊', '15.00000', '', '39.52400', '116.71900', '065000'), ('101090602', '906', '0', 'guan', '', '固安', '25.00000', '', '36.53100', '115.52800', '065500'), ('101090603', '906', '0', 'yongqing', '', '永清', '13.00000', '', '39.29900', '116.55000', '065600'), ('101090604', '906', '0', 'xianghe', '', '香河', '14.00000', '', '39.46000', '116.59000', '065400'), ('101090605', '906', '0', 'dacheng', '', '大城', '8.00000', '', '38.67400', '116.56500', '065900'), ('101090606', '906', '0', 'wenan', '', '文安', '7.00000', '', '38.52000', '116.27000', '065800'), ('101090607', '906', '0', 'dachang', '', '大厂', '18.00000', '', '38.67400', '116.56500', '065300'), ('101090608', '906', '0', 'bazhou', '', '霸州', '11.00000', '', '39.10300', '116.59300', '065700'), ('101090609', '906', '0', 'sanhe', '', '三河', '20.00000', '', '39.94900', '117.00400', '065200'), ('101090701', '907', '1', 'cangzhou', 'cangzhou', '沧州', '11.00000', '', '38.27400', '116.84700', '061000'), ('101090702', '907', '0', 'qingxian', '', '青县', '9.00000', '', '38.35000', '116.50000', '062650'), ('101090703', '907', '0', 'dongguang', '', '东光', '15.00000', '', '37.88900', '116.67300', '061600'), ('101090704', '907', '0', 'haixing', '', '海兴', '7.00000', '', '38.11300', '117.55500', '061200'), ('101090705', '907', '0', 'yanshan', '', '盐山', '9.00000', '', '38.02000', '117.14000', '061300'), ('101090706', '907', '0', 'suning', '', '肃宁', '15.00000', '', '38.41300', '115.87400', '062350'), ('101090707', '907', '0', 'nanpi', '', '南皮', '17.00000', '', '38.00500', '116.80000', '061500'), ('101090708', '907', '0', 'wuqiao', '', '吴桥', '17.00000', '', '37.63300', '116.53100', '061800'), ('101090709', '907', '0', 'xianxian', '', '献县', '14.00000', '', '38.11000', '116.07000', '062250'), ('101090710', '907', '0', 'mengcun', '', '孟村', '9.00000', '', '38.03000', '117.05000', '061400'), ('101090711', '907', '0', 'botou', '', '泊头', '15.00000', '', '38.06500', '116.38600', '062150'), ('101090712', '907', '0', 'renqiu', '', '任丘', '9.00000', '', '38.74800', '116.18600', '062550'), ('101090713', '907', '0', 'huanghua', '', '黄骅', '8.00000', '', '38.38800', '117.44200', '061100'), ('101090714', '907', '0', 'hejian', '', '河间', '14.00000', '', '38.48800', '116.27500', '062450'), ('101090716', '907', '0', 'cangxian', '', '沧县', '7.00000', '', '38.30900', '116.86200', ''), ('101090801', '908', '1', 'hengshui', 'hengshui', '衡水', '22.00000', '', '37.71400', '115.62800', '053000'), ('101090802', '908', '0', 'zaoqiang', '', '枣强', '25.00000', '', '37.43600', '115.76900', '053100'), ('101090803', '908', '0', 'wuyi', '', '武邑', '22.00000', '', '37.48000', '115.53000', '053400'), ('101090804', '908', '0', 'wuqiang', '', '武强', '19.00000', '', '38.04400', '115.91500', '053300'), ('101090805', '908', '0', 'raoyang', '', '饶阳', '20.00000', '', '38.22600', '115.72200', '052760'), ('101090806', '908', '0', 'anping', '', '安平', '27.00000', '', '38.21800', '115.49900', '053600'), ('101090807', '908', '0', 'gucheng', '', '故城', '29.00000', '', '37.21000', '115.59000', '253800'), ('101090808', '908', '0', 'jingxian', '', '景县', '19.00000', '', '37.41000', '116.18000', '053500'), ('101090809', '908', '0', 'fucheng', '', '阜城', '20.00000', '', '37.89200', '116.30400', '053700'), ('101090810', '908', '0', 'jizhou', '', '冀州', '23.00000', '', '37.33000', '115.34000', '053200'), ('101090811', '908', '0', 'shenzhou', '', '深州', '27.00000', '', '38.00000', '115.33000', '052860'), ('101090901', '909', '1', 'xingtai', 'xingtai', '邢台', '77.00000', '', '37.13400', '114.77100', '054000'), ('101090902', '909', '0', 'lincheng', '', '临城', '114.00000', '', '37.46100', '114.33400', '054300'), ('101090904', '909', '0', 'neiqiu', '', '内丘', '78.00000', '', '37.30600', '114.29300', '054200'), ('101090905', '909', '0', 'baixiang', '', '柏乡', '36.00000', '', '37.52600', '114.68400', '055450'), ('101090906', '909', '0', 'longyao', '', '隆尧', '34.00000', '', '37.38400', '114.78600', '055350'), ('101090907', '909', '0', 'nanhe', '', '南和', '43.00000', '', '36.99900', '114.73500', '054400'), ('101090908', '909', '0', 'ningjin', '', '宁晋', '32.00000', '', '37.60200', '115.00800', '055550'), ('101090909', '909', '0', 'julu', '', '巨鹿', '31.00000', '', '37.27400', '115.03000', '055250'), ('101090910', '909', '0', 'xinhe', '', '新河', '31.00000', '', '37.31000', '115.14000', '051730'), ('101090911', '909', '0', 'guangzong', '', '广宗', '33.00000', '', '37.07300', '115.19000', '054600'), ('101090912', '909', '0', 'pingxiang', '', '平乡', '35.00000', '', '37.04000', '115.02000', '054500'), ('101090913', '909', '0', 'weixian1', '', '威县', '35.00000', '', '36.59000', '115.15000', '054700'), ('101090914', '909', '0', 'qinghe', '', '清河', '33.00000', '', '37.05400', '115.67400', '054800'), ('101090915', '909', '0', 'linxi1', '', '临西', '36.00000', '', '36.51000', '115.29000', '054900'), ('101090916', '909', '0', 'nangong', '', '南宫', '29.00000', '', '37.26700', '115.44900', '051800'), ('101090917', '909', '0', 'shahe', '', '沙河', '69.00000', '', '36.93800', '114.24300', '054100'), ('101090918', '909', '0', 'renxian', '', '任县', '37.00000', '', '37.08000', '114.42000', '055150'), ('101091001', '910', '1', 'handan', 'handan', '邯郸', '68.00000', '', '36.60000', '114.49500', '056000'), ('101091002', '910', '0', 'fengfeng', '', '峰峰', '128.00000', '', '36.25000', '114.13000', '056200'), ('101091003', '910', '0', 'linzhang', '', '临漳', '66.00000', '', '36.25800', '114.55400', '056600'), ('101091004', '910', '0', 'chengan', '', '成安', '58.00000', '', '36.27000', '114.42000', '056700'), ('101091005', '910', '0', 'daming', '', '大名', '47.00000', '', '36.29100', '115.22400', '056900'), ('101091006', '910', '0', 'shexian', '', '涉县', '471.00000', '', '36.34000', '113.40000', '056400'), ('101091007', '910', '0', 'cixian', '', '磁县', '71.00000', '', '36.23000', '114.23000', '056500'), ('101091008', '910', '0', 'feixiang', '', '肥乡', '52.00000', '', '36.57600', '114.81800', '057550'), ('101091009', '910', '0', 'yongnian', '', '永年', '61.00000', '', '36.75100', '114.62200', '057150'), ('101091010', '910', '0', 'qiuxian', '', '邱县', '38.00000', '', '36.49000', '115.10000', '057450'), ('101091011', '910', '0', 'jize', '', '鸡泽', '37.00000', '', '36.86100', '114.84900', '057350'), ('101091012', '910', '0', 'guangping', '', '广平', '50.00000', '', '36.48500', '115.00000', '057650'), ('101091013', '910', '0', 'guantao', '', '馆陶', '43.00000', '', '36.33000', '115.17000', '057750'), ('101091014', '910', '0', 'weixian', '', '魏县', '52.00000', '', '36.21000', '114.57000', '056800'), ('101091015', '910', '0', 'quzhou', '', '曲周', '41.00000', '', '36.46000', '114.57000', '057250'), ('101091016', '910', '0', 'wuan', '', '武安', '235.00000', '', '36.43000', '114.12000', '056300'), ('101091101', '911', '1', 'qinhuangdao', 'qinhuangdao', '秦皇岛', '3.00000', '', '39.93200', '119.60100', '066000'), ('101091102', '911', '0', 'qinglong', '', '青龙', '229.00000', '', '40.40700', '118.95000', '066500'), ('101091103', '911', '0', 'changli', '', '昌黎', '15.00000', '', '39.62200', '119.05300', '066600'), ('101091104', '911', '0', 'funing', '', '抚宁', '23.00000', '', '39.53000', '119.14000', '066300'), ('101091105', '911', '0', 'lulong', '', '卢龙', '57.00000', '', '39.92900', '118.95700', '066400'), ('101091106', '911', '0', 'beidaihe', '', '北戴河', '57.00000', '', '39.92900', '118.95700', '066100'), ('101100101', '1001', '1', 'taiyuan', 'taiyuan', '太原', '780.00000', '', '37.89300', '112.55100', '030000'), ('101100102', '1001', '0', 'qingxu', '', '清徐', '775.00000', '', '37.61300', '112.49000', '030400'), ('101100103', '1001', '0', 'yangqu', '', '阳曲', '898.00000', '', '38.18300', '112.68000', '030100'), ('101100104', '1001', '0', 'loufan', '', '娄烦', '1171.00000', '', '38.04200', '111.77700', '030300'), ('101100105', '1001', '0', 'gujiao', '', '古交', '1012.00000', '', '37.55000', '112.10000', '030200'), ('101100106', '1001', '0', 'jiancaopingqu', '', '尖草坪区', '808.00000', '', '37.56000', '112.29000', '030023'), ('101100107', '1001', '0', 'xiaodianqu', '', '小店区', '777.00000', '', '37.44000', '112.33000', '030032'), ('101100201', '1002', '1', 'datong', 'datong', '大同', '1069.00000', '', '40.06000', '113.17000', '037000'), ('101100202', '1002', '0', 'yanggao', '', '阳高', '1051.00000', '', '40.17400', '113.78400', '038100'), ('101100203', '1002', '0', 'datongxian', '', '大同县', '1035.00000', '', '40.02000', '113.35000', '037300'), ('101100204', '1002', '0', 'tianzhen', '', '天镇', '1016.00000', '', '40.45300', '114.21300', '038200'), ('101100205', '1002', '0', 'guangling', '', '广灵', '979.00000', '', '39.76800', '114.13800', '037500'), ('101100206', '1002', '0', 'lingqiu', '', '灵丘', '940.00000', '', '39.35100', '114.21800', '034400'), ('101100207', '1002', '0', 'hunyuan', '', '浑源', '1093.00000', '', '39.62100', '113.67100', '037400'), ('101100208', '1002', '0', 'zuoyun', '', '左云', '1338.00000', '', '40.00100', '112.76900', '037100'), ('101100301', '1003', '1', 'yangquan', 'yangquan', '阳泉', '743.00000', '', '37.92700', '113.50900', '045000'), ('101100302', '1003', '0', 'yuxian', '', '盂县', '954.00000', '', '38.04000', '113.25000', '045100'), ('101100303', '1003', '0', 'pingding', '', '平定', '753.00000', '', '37.88800', '113.73700', '045200'), ('101100401', '1004', '1', 'jinzhong', 'jinzhong', '晋中', '768.00000', '', '37.20100', '112.17800', '030600'), ('101100402', '1004', '0', 'yuci', '', '榆次', '832.00000', '', '37.63600', '112.84000', '030600'), ('101100403', '1004', '0', 'yushe', '', '榆社', '1042.00000', '', '37.13500', '112.92700', '031800'), ('101100404', '1004', '0', 'zuoquan', '', '左权', '1133.00000', '', '37.01000', '113.44300', '032600'), ('101100405', '1004', '0', 'heshun', '', '和顺', '1267.00000', '', '37.32300', '113.50000', '032700'), ('101100406', '1004', '0', 'xiyang', '', '昔阳', '877.00000', '', '37.36000', '113.42000', '045300'), ('101100407', '1004', '0', 'shouyang', '', '寿阳', '1061.00000', '', '37.81600', '113.10300', '031700'), ('101100408', '1004', '0', 'taigu', '', '太谷', '783.00000', '', '37.38500', '112.76400', '030800'), ('101100409', '1004', '0', 'qixian', '', '祁县', '769.00000', '', '37.21000', '112.21000', '030900'), ('101100410', '1004', '0', 'pingyao', '', '平遥', '768.00000', '', '37.11000', '112.13000', '031100'), ('101100411', '1004', '0', 'lingshi', '', '灵石', '810.00000', '', '36.82400', '111.70400', '031300'), ('101100412', '1004', '0', 'jiexiu', '', '介休', '747.00000', '', '37.02300', '111.94900', '031200'), ('101100501', '1005', '1', 'changzhi', 'changzhi', '长治', '991.00000', '', '36.18700', '113.10300', '046000'), ('101100502', '1005', '0', 'licheng', '', '黎城', '770.00000', '', '36.64100', '113.37800', '047600'), ('101100503', '1005', '0', 'tunliu', '', '屯留', '953.00000', '', '36.34800', '112.74000', '046100'), ('101100504', '1005', '0', 'lucheng', '', '潞城', '949.00000', '', '36.36700', '113.23400', '047500'), ('101100505', '1005', '0', 'xiangyuan', '', '襄垣', '879.00000', '', '36.31000', '113.02000', '046200'), ('101100506', '1005', '0', 'pingshun', '', '平顺', '1088.00000', '', '36.20500', '113.46000', '047400'), ('101100507', '1005', '0', 'wuxiang', '', '武乡', '966.00000', '', '36.89300', '113.15800', '046300'), ('101100508', '1005', '0', 'qinxian', '', '沁县', '962.00000', '', '36.46000', '112.41000', '046400'), ('101100509', '1005', '0', 'zhangzi', '', '长子', '951.00000', '', '36.09200', '112.74200', '046600'), ('101100510', '1005', '0', 'qinyuan', '', '沁源', '1001.00000', '', '36.67800', '112.25700', '046500'), ('101100511', '1005', '0', 'huguan', '', '壶关', '1031.00000', '', '36.02100', '113.38800', '047300'), ('101100601', '1006', '1', 'jincheng', 'jincheng', '晋城', '744.00000', '', '35.50200', '112.82600', '048000'), ('101100602', '1006', '0', 'qinshui', '', '沁水', '887.00000', '', '35.72600', '112.35800', '048200'), ('101100603', '1006', '0', 'yangcheng', '', '阳城', '659.00000', '', '35.45100', '112.32500', '048100'), ('101100604', '1006', '0', 'lingchuan', '', '陵川', '1311.00000', '', '35.47000', '113.16000', '048300'), ('101100605', '1006', '0', 'gaoping', '', '高平', '837.00000', '', '35.82100', '112.93400', '048400'), ('101100606', '1006', '0', 'zezhou', '', '泽州', '875.00000', '', '35.46600', '112.79400', ''), ('101100701', '1007', '1', 'linfen', 'linfen', '临汾', '450.00000', '', '36.11600', '111.44900', '041000'), ('101100702', '1007', '0', 'quwo', '', '曲沃', '473.00000', '', '35.71300', '111.48400', '043400'), ('101100703', '1007', '0', 'yonghe', '', '永和', '918.00000', '', '36.72800', '110.60500', '041400'), ('101100704', '1007', '0', 'xixian', '', '隰县', '1054.00000', '', '36.42000', '110.57000', '041300'), ('101100705', '1007', '0', 'daning', '', '大宁', '753.00000', '', '36.44200', '110.74000', '042300'), ('101100706', '1007', '0', 'beiqu', '', '吉县', '853.00000', '', '36.10000', '110.60000', '042200'), ('101100707', '1007', '0', 'xiangfen', '', '襄汾', '428.00000', '', '35.53000', '111.25000', '041500'), ('101100708', '1007', '0', 'puxian', '', '蒲县', '1040.00000', '', '36.24000', '111.06000', '041200'), ('101100709', '1007', '0', 'fenxi', '', '汾西', '1013.00000', '', '36.62900', '111.45400', '031500'), ('101100710', '1007', '0', 'hongtong', '', '洪洞', '464.00000', '', '36.32400', '111.61600', '041600'), ('101100711', '1007', '0', 'huozhou', '', '霍州', '568.00000', '', '36.58000', '111.83200', '031400'), ('101100712', '1007', '0', 'xiangning', '', '乡宁', '964.00000', '', '35.58000', '110.51000', '042100'), ('101100713', '1007', '0', 'yicheng', '', '翼城', '585.00000', '', '35.44000', '111.42000', '043500'), ('101100714', '1007', '0', 'houma', '', '侯马', '435.00000', '', '35.61800', '111.35800', '043000'), ('101100715', '1007', '0', 'fushan', '', '浮山', '818.00000', '', '35.96500', '111.89600', '042600'), ('101100716', '1007', '0', 'anze', '', '安泽', '862.00000', '', '36.19900', '112.28600', '042500'), ('101100717', '1007', '0', 'guxian', '', '古县', '664.00000', '', '36.16000', '111.55000', '042400'), ('101100801', '1008', '1', 'yuncheng', 'yuncheng', '运城', '376.00000', '', '35.10600', '110.95400', '044000'), ('101100802', '1008', '0', 'linyi', '', '临猗', '390.00000', '', '35.09000', '110.43000', '044100'), ('101100803', '1008', '0', 'jishan', '', '稷山', '391.00000', '', '35.60200', '110.95400', '043200'), ('101100804', '1008', '0', 'wanrong', '', '万荣', '590.00000', '', '35.38500', '110.70800', '044200'), ('101100805', '1008', '0', 'hejin', '', '河津', '460.00000', '', '35.63100', '110.69000', '043300'), ('101100806', '1008', '0', 'xinjiang', '', '新绛', '432.00000', '', '35.37000', '111.13000', '043100'), ('101100807', '1008', '0', 'jiangxian', '', '绛县', '762.00000', '', '35.31000', '111.34000', '043600'), ('101100808', '1008', '0', 'wenxi', '', '闻喜', '470.00000', '', '35.37300', '111.31400', '043800'), ('101100809', '1008', '0', 'yuanqu', '', '垣曲', '485.00000', '', '35.21200', '111.78600', '043700'), ('101100810', '1008', '0', 'yongji1', '', '永济', '355.00000', '', '34.53000', '110.27000', '044500'), ('101100811', '1008', '0', 'ruicheng', '', '芮城', '507.00000', '', '34.69400', '110.69400', '044600'), ('101100812', '1008', '0', 'xiaxian', '', '夏县', '404.00000', '', '35.10000', '111.14000', '044400'), ('101100813', '1008', '0', 'pinglu', '', '平陆', '411.00000', '', '34.86300', '111.25900', '044300'), ('101100901', '1009', '1', 'shuozhou', 'shuozhou', '朔州', '1092.00000', '', '39.31500', '112.41700', '038500'), ('101100902', '1009', '0', 'pinglu1', '', '平鲁', '1409.00000', '', '34.86300', '111.25900', '036800'), ('101100903', '1009', '0', 'shanyin', '', '山阴', '1046.00000', '', '39.47400', '112.74800', '038400'), ('101100904', '1009', '0', 'youyu', '', '右玉', '1348.00000', '', '39.99500', '112.37000', '037200'), ('101100905', '1009', '0', 'yingxian', '', '应县', '1002.00000', '', '39.34000', '113.10000', '037600'), ('101100906', '1009', '0', 'huairen', '', '怀仁', '1046.00000', '', '39.78000', '113.09400', '038300'), ('101101001', '1010', '1', 'xinzhou', 'qizhou', '忻州', '799.00000', '', '38.44200', '112.61200', '034000'), ('101101002', '1010', '0', 'dingxiang', '', '定襄', '760.00000', '', '38.49600', '113.01300', '035400'), ('101101003', '1010', '0', 'wutaixian', '', '五台县', '1097.00000', '', '38.50000', '113.22000', '035502'), ('101101004', '1010', '0', 'hequ', '', '河曲', '862.00000', '', '39.17500', '111.35800', '036500'), ('101101005', '1010', '0', 'pianguan', '', '偏关', '1050.00000', '', '39.43700', '111.68100', '036400'), ('101101006', '1010', '0', 'shenchi', '', '神池', '1526.00000', '', '39.16400', '112.00200', '036100'), ('101101007', '1010', '0', 'ningwu', '', '宁武', '1437.00000', '', '38.82900', '112.22800', '036000'), ('101101008', '1010', '0', 'daixian', '', '代县', '861.00000', '', '39.01000', '112.54000', '034200'), ('101101009', '1010', '0', 'fanshi', '', '繁峙', '934.00000', '', '39.20000', '113.55000', '034300'), ('101101010', '1010', '0', 'wutaishan', '', '五台山', '2210.00000', '', '39.02000', '113.32000', '035500'), ('101101011', '1010', '0', 'bode', '', '保德', '894.00000', '', '39.01000', '111.05000', '036600'), ('101101012', '1010', '0', 'jingle', '', '静乐', '1213.00000', '', '38.40700', '112.02500', '035100'), ('101101013', '1010', '0', 'kelan', '', '岢岚', '1394.00000', '', '38.73000', '111.54000', '036300'), ('101101014', '1010', '0', 'wuzhai', '', '五寨', '1403.00000', '', '38.98200', '111.73700', '036200'), ('101101015', '1010', '0', 'yuanping', '', '原平', '828.00000', '', '38.86600', '112.68200', '034100'), ('101101100', '1011', '1', 'lvliang', 'luliang', '吕梁', '951.00000', '', '37.54100', '111.26900', '033000'), ('101101101', '1011', '0', 'lishi1', '', '离石', '951.00000', '', '37.54100', '111.26900', '033000'), ('101101102', '1011', '0', 'linxian', '', '临县', '1164.00000', '', '37.58000', '111.00000', '033200'), ('101101103', '1011', '0', 'xingxian', '', '兴县', '1014.00000', '', '38.28000', '111.08000', '035300'), ('101101104', '1011', '0', 'lanxian', '', '岚县', '1184.00000', '', '38.17000', '111.39000', '035200'), ('101101105', '1011', '0', 'liulin', '', '柳林', '861.00000', '', '37.39200', '110.85800', '033300'), ('101101106', '1011', '0', 'shilou', '', '石楼', '1107.00000', '', '37.06200', '110.73300', '032500'), ('101101107', '1011', '0', 'fangshan1', '', '方山', '1212.00000', '', '37.89800', '111.30800', '033100'), ('101101108', '1011', '0', 'jiaokou', '', '交口', '1407.00000', '', '36.97300', '111.30800', '032400'), ('101101109', '1011', '0', 'zhongyang', '', '中阳', '1212.00000', '', '37.26500', '111.16200', '033400'), ('101101110', '1011', '0', 'xiaoyi', '', '孝义', '771.00000', '', '37.09000', '111.45000', '032300');
INSERT INTO `district` VALUES ('101101111', '1011', '0', 'fenyang', '', '汾阳', '749.00000', '', '37.31400', '111.73100', '032200'), ('101101112', '1011', '0', 'wenshui', '', '文水', '762.00000', '', '37.43400', '111.90800', '032100'), ('101101113', '1011', '0', 'jiaocheng', '', '交城', '760.00000', '', '37.68000', '111.84800', '030501'), ('101110101', '1101', '1', 'xian', 'xian', '西安', '399.00000', '', '34.28500', '108.96900', '710000'), ('101110102', '1101', '0', 'changan', '', '长安', '439.00000', '', '34.09000', '108.55000', '710100'), ('101110103', '1101', '0', 'lintong', '', '临潼', '425.00000', '', '34.24000', '109.14000', '710600'), ('101110104', '1101', '0', 'lantian', '', '蓝田', '542.00000', '', '34.09000', '109.46800', '710500'), ('101110105', '1101', '0', 'zhouzhi', '', '周至', '434.00000', '', '33.97000', '108.09100', '710400'), ('101110106', '1101', '0', 'huxian', '', '户县', '415.00000', '', '34.07000', '108.37000', '710300'), ('101110107', '1101', '0', 'gaoling', '', '高陵', '379.00000', '', '34.51600', '109.05600', '710200'), ('101110200', '1102', '1', 'xianyang', 'xianyang', '咸阳', '473.00000', '', '34.32800', '108.59100', '712000'), ('101110201', '1102', '0', 'sanyuan', '', '三原', '0.00000', '', '34.70800', '108.97200', '713800'), ('101110202', '1102', '0', 'liquan', '', '礼泉', '544.00000', '', '34.59000', '108.49700', '713200'), ('101110203', '1102', '0', 'yongshou', '', '永寿', '995.00000', '', '34.81200', '108.14900', '713400'), ('101110204', '1102', '0', 'chunhua', '', '淳化', '1014.00000', '', '34.88200', '108.56500', '711200'), ('101110205', '1102', '0', 'jingyang', '', '泾阳', '428.00000', '', '34.60200', '108.73300', '713700'), ('101110206', '1102', '0', 'wugong', '', '武功', '449.00000', '', '34.29000', '108.21900', '712200'), ('101110207', '1102', '0', 'qianxian', '', '乾县', '637.00000', '', '34.33000', '108.14000', '713300'), ('101110208', '1102', '0', 'binxian1', '', '彬县', '842.00000', '', '35.02000', '108.06000', '713500'), ('101110209', '1102', '0', 'changwu', '', '长武', '1207.00000', '', '35.15800', '107.80800', '713600'), ('101110210', '1102', '0', 'xunyi', '', '旬邑', '1278.00000', '', '35.10000', '108.18000', '711300'), ('101110211', '1102', '0', 'xingping', '', '兴平', '412.00000', '', '34.17000', '108.17000', '713100'), ('101110300', '1103', '1', 'yanan', 'yanan', '延安', '959.00000', '', '36.59700', '109.47500', '716000'), ('101110301', '1103', '0', 'yanchang', '', '延长', '805.00000', '', '36.52800', '110.09700', '717100'), ('101110302', '1103', '0', 'yanchuan', '', '延川', '801.00000', '', '36.86400', '110.03100', '717200'), ('101110303', '1103', '0', 'zichang', '', '子长', '1066.00000', '', '37.24900', '109.61900', '717300'), ('101110304', '1103', '0', 'yichuan', '', '宜川', '841.00000', '', '36.04000', '110.11000', '716200'), ('101110305', '1103', '0', 'fuxian', '', '富县', '921.00000', '', '36.00000', '109.23000', '727500'), ('101110306', '1103', '0', 'zhidan', '', '志丹', '1219.00000', '', '36.77800', '108.63000', '717500'), ('101110307', '1103', '0', 'ansai', '', '安塞', '1069.00000', '', '36.92100', '109.14500', '717400'), ('101110308', '1103', '0', 'ganquan', '', '甘泉', '1005.00000', '', '36.37300', '109.16600', '716100'), ('101110309', '1103', '0', 'luochuan', '', '洛川', '1159.00000', '', '35.71700', '109.53900', '727400'), ('101110310', '1103', '0', 'huangling', '', '黄陵', '0.00000', '', '35.58900', '108.98700', '727300'), ('101110311', '1103', '0', 'huanglong', '', '黄龙', '1089.00000', '', '35.72400', '109.96200', '715700'), ('101110312', '1103', '0', 'wuqi', '', '吴起', '1331.00000', '', '36.98300', '108.09800', '717600'), ('101110401', '1104', '1', 'yulin', '', '榆林', '1059.00000', '', '38.28900', '109.74300', '719000'), ('101110402', '1104', '0', 'fugu', '', '府谷', '1024.00000', '', '39.01000', '111.00000', '719400'), ('101110403', '1104', '0', 'shenmu', '', '神木', '941.00000', '', '38.83700', '110.29500', '719300'), ('101110404', '1104', '0', 'jiaxian', '', '佳县', '895.00000', '', '38.02000', '110.29000', '719200'), ('101110405', '1104', '0', 'dingbian', '', '定边', '1361.00000', '', '37.35100', '107.81600', '718600'), ('101110406', '1104', '0', 'jingbian', '', '靖边', '1337.00000', '', '37.50000', '108.81300', '718500'), ('101110407', '1104', '0', 'hengshan', '', '横山', '1108.00000', '', '37.56000', '109.14000', '719100'), ('101110408', '1104', '0', 'mizhi', '', '米脂', '873.00000', '', '37.87600', '110.15000', '718100'), ('101110409', '1104', '0', 'zizhou', '', '子洲', '896.00000', '', '37.53100', '109.81200', '718400'), ('101110410', '1104', '0', 'suide', '', '绥德', '929.00000', '', '37.51000', '110.38600', '718000'), ('101110411', '1104', '0', 'wubu', '', '吴堡', '746.00000', '', '37.31000', '110.43000', '718200'), ('101110412', '1104', '0', 'qingjian', '', '清涧', '939.00000', '', '37.07000', '110.07000', '718300'), ('101110413', '1104', '0', 'yuyang', '', '榆阳', '1138.00000', '', '38.27100', '109.68700', ''), ('101110501', '1105', '1', 'weinan', 'weinan', '渭南', '350.00000', '', '34.52600', '109.57400', '714000'), ('101110502', '1105', '0', 'huaxian', '', '华县', '342.00000', '', '34.31000', '109.44000', '714100'), ('101110503', '1105', '0', 'tongguan', '', '潼关', '557.00000', '', '34.51900', '110.29400', '714300'), ('101110504', '1105', '0', 'dali', '', '大荔', '369.00000', '', '34.80300', '109.99900', '715100'), ('101110505', '1105', '0', 'baishui', '', '白水', '806.00000', '', '35.26000', '109.52400', '715600'), ('101110506', '1105', '0', 'fuping1', '', '富平', '473.00000', '', '34.47000', '109.11000', '711700'), ('101110507', '1105', '0', 'pucheng', '', '蒲城', '500.00000', '', '34.57000', '109.35000', '715500'), ('101110508', '1105', '0', 'chengcheng', '', '澄城', '680.00000', '', '35.19000', '109.89200', '715200'), ('101110509', '1105', '0', 'heyang', '', '合阳', '710.00000', '', '35.21200', '110.20400', '715300'), ('101110510', '1105', '0', 'hancheng', '', '韩城', '459.00000', '', '35.58300', '110.36500', '715400'), ('101110511', '1105', '0', 'huayin', '', '华阴', '353.00000', '', '34.52300', '110.04100', '714200'), ('101110601', '1106', '1', 'shangluo', '', '商洛', '744.00000', '', '33.52000', '109.58000', '726000'), ('101110602', '1106', '0', 'luonan', '', '洛南', '960.00000', '', '34.14700', '110.20600', '726100'), ('101110603', '1106', '0', 'zhashui', '', '柞水', '818.00000', '', '33.40000', '109.07000', '711400'), ('101110604', '1106', '0', 'shangzhou', '', '商州', '715.00000', '', '33.80000', '109.80000', ''), ('101110605', '1106', '0', 'zhenan', '', '镇安', '694.00000', '', '33.26000', '109.09000', '711500'), ('101110606', '1106', '0', 'danfeng', '', '丹凤', '613.00000', '', '33.65700', '110.46900', '726200'), ('101110607', '1106', '0', 'shangnan', '', '商南', '524.00000', '', '33.42500', '110.71200', '726300'), ('101110608', '1106', '0', 'shanyang', '', '山阳', '661.00000', '', '33.43300', '110.00700', '726400'), ('101110701', '1107', '1', 'ankang', '', '安康', '291.00000', '', '32.68400', '109.01400', '725000'), ('101110702', '1107', '0', 'ziyang', '', '紫阳', '505.00000', '', '32.32000', '108.32000', '725300'), ('101110703', '1107', '0', 'shiquan', '', '石泉', '485.00000', '', '33.05000', '108.25400', '725200'), ('101110704', '1107', '0', 'hanyin', '', '汉阴', '413.00000', '', '32.89700', '108.45500', '725100'), ('101110705', '1107', '0', 'xunyang', '', '旬阳', '441.00000', '', '32.51000', '109.22000', '725700'), ('101110706', '1107', '0', 'langao', '', '岚皋', '439.00000', '', '32.23300', '108.90100', '725400'), ('101110707', '1107', '0', 'pingli', '', '平利', '430.00000', '', '32.24000', '109.27300', '725500'), ('101110708', '1107', '0', 'baihe', '', '白河', '324.00000', '', '32.73200', '109.91500', '725800'), ('101110709', '1107', '0', 'zhenping', '', '镇坪', '995.00000', '', '31.54000', '109.32000', '725600'), ('101110710', '1107', '0', 'ningshan', '', '宁陕', '802.00000', '', '33.48300', '108.49400', '711600'), ('101110801', '1108', '1', 'hanzhong', '', '汉中', '510.00000', '', '33.07100', '107.02500', '723000'), ('101110802', '1108', '0', 'lueyang', '', '略阳', '797.00000', '', '33.36700', '106.11000', '724300'), ('101110803', '1108', '0', 'mianxian', '', '勉县', '548.00000', '', '33.10000', '106.42000', '724200'), ('101110804', '1108', '0', 'liuba', '', '留坝', '1032.00000', '', '33.58100', '106.98300', '724100'), ('101110805', '1108', '0', 'yangxian', '', '洋县', '470.00000', '', '33.13000', '107.33000', '723300'), ('101110806', '1108', '0', 'chenggu', '', '城固', '487.00000', '', '33.20300', '107.26700', '723200'), ('101110807', '1108', '0', 'xixiang', '', '西乡', '448.00000', '', '32.59000', '107.43000', '723500'), ('101110808', '1108', '0', 'fuoping', '', '佛坪', '1089.00000', '', '33.32000', '107.59000', '723400'), ('101110809', '1108', '0', 'ningqiang', '', '宁强', '855.00000', '', '32.91300', '106.03700', '724400'), ('101110810', '1108', '0', 'nanzheng', '', '南郑', '538.00000', '', '32.76200', '106.94300', '723100'), ('101110811', '1108', '0', 'zhenba', '', '镇巴', '694.00000', '', '32.49600', '107.85400', '723600'), ('101110901', '1109', '1', 'baoji', 'baoji', '宝鸡', '614.00000', '', '34.38100', '107.14900', '721000'), ('101110903', '1109', '0', 'qianyang', '', '千阳', '752.00000', '', '34.39000', '107.08000', '721100'), ('101110904', '1109', '0', 'linyou', '', '麟游', '1066.00000', '', '34.76400', '107.67800', '721500'), ('101110905', '1109', '0', 'qishan', '', '岐山', '671.00000', '', '34.37900', '107.71300', '722400'), ('101110906', '1109', '0', 'fengxiang', '', '凤翔', '782.00000', '', '34.56000', '107.41400', '721400'), ('101110907', '1109', '0', 'fufeng', '', '扶风', '587.00000', '', '34.41600', '107.89400', '722200'), ('101110908', '1109', '0', 'meixian', '', '眉县', '518.00000', '', '34.16000', '107.44000', '722300'), ('101110909', '1109', '0', 'taibai', '', '太白', '1544.00000', '', '33.91500', '107.41600', '721600'), ('101110910', '1109', '0', 'fengxian1', '', '凤县', '994.00000', '', '30.90800', '121.55100', '721700'), ('101110911', '1109', '0', 'longxian', '', '陇县', '925.00000', '', '34.54000', '106.50000', '721200'), ('101110912', '1109', '0', 'chencang', '', '陈仓', '564.00000', '', '34.22000', '107.24000', '721300'), ('101111001', '1110', '1', 'tongchuan', 'tongchuan', '铜川', '980.00000', '', '35.07300', '109.06800', '727000'), ('101111002', '1110', '0', 'yaoxian', '', '耀县', '711.00000', '', '34.56000', '108.59000', '727100'), ('101111003', '1110', '0', 'yijun', '', '宜君', '1394.00000', '', '35.35900', '109.20400', '727200'), ('101111004', '1110', '0', 'yaozhou', '', '耀州', '630.00000', '', '34.91300', '108.97400', '727100'), ('101111101', '1111', '1', 'yangling', '', '杨凌', '511.00000', '', '34.28000', '108.07000', '712100'), ('101120101', '1201', '1', 'jinan', 'jinan', '济南', '169.00000', '', '36.66300', '117.00900', '250000'), ('101120102', '1201', '0', 'changqing', '', '长清', '49.00000', '', '36.47000', '116.79500', '250300'), ('101120103', '1201', '0', 'shanghe', '', '商河', '22.00000', '', '37.32800', '117.20500', '251600'), ('101120104', '1201', '0', 'zhangqiu', 'zhangqiu', '章丘', '123.00000', '', '36.75000', '117.46100', '250200'), ('101120105', '1201', '0', 'pingyin', '', '平阴', '40.00000', '', '36.20500', '116.40200', '250400'), ('101120106', '1201', '0', 'jiyang', '', '济阳', '21.00000', '', '37.00300', '117.16900', '251400'), ('101120107', '1201', '0', 'shizhongqu', '', '天桥', '0.00000', '', '0.00000', '0.00000', ''), ('101120201', '1202', '1', 'qingdao', 'qingdao', '青岛', '75.00000', '', '36.08800', '120.34300', '266000'), ('101120202', '1202', '0', 'laoshan', '', '崂山', '44.00000', '', '36.10000', '120.25000', '266100'), ('101120204', '1202', '0', 'jimo', 'jimo', '即墨', '30.00000', '', '36.45200', '120.55500', '266200'), ('101120205', '1202', '0', 'jiaozhou', 'jiaozhou', '胶州', '16.00000', '', '36.25200', '119.92500', '266300'), ('101120206', '1202', '0', 'jiaonan', 'jiaonan', '胶南', '13.00000', '', '35.86300', '119.90700', '266400'), ('101120207', '1202', '0', 'laixi', 'laixi', '莱西', '52.00000', '', '36.85500', '120.43500', '266600'), ('101120208', '1202', '0', 'pingdu', 'pingdu', '平度', '52.00000', '', '36.76400', '119.91900', '266700'), ('101120301', '1203', '1', 'zibo', 'zibo', '淄博', '39.00000', '', '36.78800', '118.05000', '255000'), ('101120302', '1203', '0', 'zichuan', '', '淄川', '98.00000', '', '36.38000', '117.57000', '255100'), ('101120303', '1203', '0', 'boshan', '', '博山', '192.00000', '', '36.31000', '117.50000', '255200'), ('101120304', '1203', '0', 'gaoqing', '', '高青', '12.00000', '', '37.18400', '117.80800', '256300'), ('101120305', '1203', '0', 'zhoucun', '', '周村', '46.00000', '', '36.49000', '117.52000', '255300'), ('101120306', '1203', '0', 'yiyuan', '', '沂源', '303.00000', '', '36.16000', '118.16900', '256100'), ('101120307', '1203', '0', 'huantai', '', '桓台', '20.00000', '', '36.97900', '118.00600', '256400'), ('101120308', '1203', '0', 'linzi', '', '临淄', '56.00000', '', '36.50000', '118.20000', '255400'), ('101120401', '1204', '1', 'dezhou', 'dezhou', '德州', '23.00000', '', '37.44600', '116.27900', '253000'), ('101120402', '1204', '0', 'wucheng', '', '武城', '27.00000', '', '37.21300', '116.07500', '253300'), ('101120403', '1204', '0', 'linyi1', '', '临邑', '18.00000', '', '37.11000', '116.52000', '251500'), ('101120404', '1204', '0', 'lingxian', '', '陵县', '19.00000', '', '37.20000', '116.34000', '253500'), ('101120405', '1204', '0', 'qihe', '', '齐河', '23.00000', '', '36.71500', '116.72800', '251100'), ('101120406', '1204', '0', 'leling', '', '乐陵', '13.00000', '', '37.65900', '117.13400', '253600'), ('101120407', '1204', '0', 'qingyun', '', '庆云', '9.00000', '', '37.82900', '117.45000', '253700'), ('101120408', '1204', '0', 'pingyuan', '', '平原', '23.00000', '', '37.09000', '116.26000', '253121'), ('101120409', '1204', '0', 'ningjin1', '', '宁津', '17.00000', '', '37.60200', '115.00800', '253400'), ('101120410', '1204', '0', 'xiajin', '', '夏津', '33.00000', '', '36.55000', '115.57000', '253200'), ('101120411', '1204', '0', 'yucheng', '', '禹城', '25.00000', '', '36.56000', '116.38000', '251200'), ('101120501', '1205', '1', 'yantai', 'yantai', '烟台', '57.00000', '', '37.54300', '121.36000', '264000'), ('101120502', '1205', '0', 'laizhou', 'laizhou', '莱州', '49.00000', '', '37.23100', '119.92600', '261400'), ('101120503', '1205', '0', 'changdao', '', '长岛', '43.00000', '', '37.92300', '120.73900', '265800'), ('101120504', '1205', '0', 'penglai', 'penglai', '蓬莱', '48.00000', '', '37.62400', '120.86400', '265600'), ('101120505', '1205', '0', 'longkou', '', '龙口', '5.00000', '', '37.60900', '120.48100', '265700'), ('101120506', '1205', '0', 'zhaoyuan1', 'zhaoyuan', '招远', '82.00000', '', '37.21000', '120.23000', '265400'), ('101120507', '1205', '0', 'qixia', '', '栖霞', '166.00000', '', '37.18000', '120.49000', '265300'), ('101120508', '1205', '0', 'fushan1', '', '福山', '34.00000', '', '37.49800', '121.26800', '265500'), ('101120509', '1205', '0', 'muping', '', '牟平', '13.00000', '', '37.23000', '121.35000', '264100'), ('101120510', '1205', '0', 'laiyang', '', '莱阳', '54.00000', '', '36.87100', '120.74400', '265200'), ('101120511', '1205', '0', 'haiyang', '', '海阳', '64.00000', '', '36.87800', '121.14900', '265100'), ('101120601', '1206', '1', 'weifang', 'weifang', '潍坊', '23.00000', '', '36.70700', '119.09400', '261000'), ('101120602', '1206', '0', 'qingzhou', '', '青州', '116.00000', '', '36.67400', '118.47200', '262500'), ('101120603', '1206', '0', 'shouguang', 'shouguang', '寿光', '30.00000', '', '37.01500', '118.85100', '262700'), ('101120604', '1206', '0', 'linqu', '', '临朐', '110.00000', '', '36.34100', '118.52800', '262600'), ('101120605', '1206', '0', 'changle', '', '昌乐', '73.00000', '', '36.54700', '118.94800', '262400'), ('101120606', '1206', '0', 'changyi', '', '昌邑', '9.00000', '', '36.77900', '119.42600', '261300'), ('101120607', '1206', '0', 'anqiu', '', '安丘', '67.00000', '', '36.36200', '119.10100', '262100'), ('101120608', '1206', '0', 'gaomi', '', '高密', '37.00000', '', '36.41900', '119.71900', '261500'), ('101120609', '1206', '0', 'zhucheng', '', '诸城', '96.00000', '', '35.59000', '119.25000', '262200'), ('101120701', '1207', '1', 'jining1', 'jining', '济宁', '48.00000', '', '35.39900', '116.58000', '272000'), ('101120702', '1207', '0', 'jiaxiang', '', '嘉祥', '40.00000', '', '35.41600', '116.30600', '272400'), ('101120703', '1207', '0', 'weishan', '', '微山', '39.00000', '', '34.89600', '116.99400', '277600'), ('101120704', '1207', '0', 'yutai', '', '鱼台', '39.00000', '', '35.03700', '116.60100', '272300'), ('101120705', '1207', '0', 'yanzhou', '', '兖州', '53.00000', '', '35.56300', '116.73900', '272000'), ('101120706', '1207', '0', 'jinxiang', '', '金乡', '41.00000', '', '35.04500', '116.30000', '272200'), ('101120707', '1207', '0', 'wenshang', '', '汶上', '43.00000', '', '35.72800', '116.49000', '272500'), ('101120708', '1207', '0', 'sishui', '', '泗水', '111.00000', '', '35.63200', '117.34200', '273200'), ('101120709', '1207', '0', 'liangshan', '', '梁山', '41.00000', '', '35.79900', '116.10400', '272600'), ('101120710', '1207', '0', 'qufu', '', '曲阜', '69.00000', '', '35.63100', '117.04300', '273100'), ('101120711', '1207', '0', 'zoucheng', '', '邹城', '80.00000', '', '35.25000', '117.00000', '273500'), ('101120801', '1208', '1', 'taian1', 'taian', '泰安', '132.00000', '', '36.18100', '117.12800', '271000'), ('101120802', '1208', '0', 'xintai', '', '新泰', '199.00000', '', '35.54000', '117.44000', '271200'), ('101120804', '1208', '0', 'feicheng', '', '肥城', '109.00000', '', '36.10100', '116.73100', '271600'), ('101120805', '1208', '0', 'dongping', '', '东平', '48.00000', '', '35.97400', '116.35000', '271500'), ('101120806', '1208', '0', 'ningyang', '', '宁阳', '63.00000', '', '35.82100', '116.95200', '271400'), ('101120901', '1209', '1', 'linyi2', 'linyi', '临沂', '66.00000', '', '35.05700', '118.33600', '276000'), ('101120902', '1209', '0', 'junan', '', '莒南', '113.00000', '', '35.20700', '118.87500', '276600'), ('101120903', '1209', '0', 'yinan', '', '沂南', '131.00000', '', '35.54700', '118.42500', '276300'), ('101120904', '1209', '0', 'cangshan', '', '苍山', '50.00000', '', '34.54000', '118.06000', '277700'), ('101120905', '1209', '0', 'linshu', '', '临沭', '68.00000', '', '34.89600', '118.64500', '276700'), ('101120906', '1209', '0', 'tancheng', '', '郯城', '38.00000', '', '34.66000', '118.29700', '276100'), ('101120907', '1209', '0', 'mengyin', '', '蒙阴', '203.00000', '', '35.73700', '117.99300', '276200'), ('101120908', '1209', '0', 'pingyi', '', '平邑', '167.00000', '', '36.20500', '116.40200', '273300'), ('101120909', '1209', '0', 'feixian', '', '费县', '120.00000', '', '35.15000', '117.57000', '273400'), ('101120910', '1209', '0', 'yishui', '', '沂水', '161.00000', '', '35.90300', '118.62000', '276400'), ('101121001', '1210', '1', 'heze', 'heze', '菏泽', '51.00000', '', '35.24000', '115.43600', '274000'), ('101121002', '1210', '0', 'juancheng', '', '鄄城', '51.00000', '', '35.56500', '115.51800', '274600'), ('101121003', '1210', '0', 'yuncheng1', '', '郓城', '46.00000', '', '35.36000', '115.55000', '274700'), ('101121004', '1210', '0', 'dongming', '', '东明', '60.00000', '', '35.20200', '115.02900', '274500'), ('101121005', '1210', '0', 'dingtao', '', '定陶', '52.00000', '', '35.10900', '115.56100', '274100'), ('101121006', '1210', '0', 'juye', '', '巨野', '41.00000', '', '35.30400', '116.00200', '274900'), ('101121007', '1210', '0', 'caoxian', '', '曹县', '50.00000', '', '34.49000', '115.33000', '274400'), ('101121008', '1210', '0', 'chengwu', '', '成武', '45.00000', '', '34.99000', '115.95600', '274200'), ('101121009', '1210', '0', 'shanxian', '', '单县', '44.00000', '', '34.48000', '116.04000', '274300'), ('101121101', '1211', '1', 'binzhou', 'binzhou', '滨州', '12.00000', '', '37.36900', '118.00900', '256600'), ('101121102', '1211', '0', 'boxing', '', '博兴', '14.00000', '', '37.17500', '118.21400', '256500'), ('101121103', '1211', '0', 'wudi', '', '无棣', '7.00000', '', '37.94900', '117.78500', '251900'), ('101121104', '1211', '0', 'yangxin', '', '阳信', '11.00000', '', '37.39000', '117.34000', '251800'), ('101121105', '1211', '0', 'huimin', '', '惠民', '12.00000', '', '37.33800', '117.55600', '251700'), ('101121106', '1211', '0', 'zhanhua', '', '沾化', '8.00000', '', '37.82500', '118.04600', '256800'), ('101121107', '1211', '0', 'zouping', '', '邹平', '25.00000', '', '36.91400', '117.63300', '256200'), ('101121201', '1212', '1', 'dongying', 'dongying', '东营', '6.00000', '', '37.45500', '118.47200', '257000'), ('101121202', '1212', '0', 'hekou', '', '河口', '10.00000', '', '37.53000', '118.32000', '257200'), ('101121203', '1212', '0', 'kenli', '', '垦利', '9.00000', '', '37.59100', '118.65800', '257500'), ('101121204', '1212', '0', 'lijin', '', '利津', '11.00000', '', '37.62800', '118.41800', '257400'), ('101121205', '1212', '0', 'guangrao', '', '广饶', '16.00000', '', '37.13700', '118.60300', '257300'), ('101121301', '1213', '1', 'weihai', 'weihai', '威海', '61.00000', '', '37.49800', '122.11500', '264200'), ('101121302', '1213', '0', 'wendeng', 'wendeng', '文登', '56.00000', '', '37.18500', '122.01800', '264400'), ('101121303', '1213', '0', 'rongcheng2', 'rongcheng', '荣成', '40.00000', '', '37.10000', '122.23000', '264300'), ('101121304', '1213', '0', 'rushan', 'rushan', '乳山', '38.00000', '', '36.93700', '121.51600', '264500'), ('101121305', '1213', '0', 'chengshantou', '', '成山头', '48.00000', '', '37.24000', '122.41000', '264321'), ('101121306', '1213', '0', 'shidao', '', '石岛', '20.00000', '', '36.52000', '122.26000', '264309'), ('101121401', '1214', '1', 'zaozhuang', 'zaozhuang', '枣庄', '75.00000', '', '34.86700', '117.55200', '277100'), ('101121402', '1214', '0', 'xuecheng', '', '薛城', '46.00000', '', '34.47000', '117.15000', '277000'), ('101121403', '1214', '0', 'yicheng1', '', '峄城', '59.00000', '', '34.77200', '117.59100', '277300'), ('101121404', '1214', '0', 'taierzhuang', '', '台儿庄', '28.00000', '', '34.34000', '117.44000', '277400'), ('101121405', '1214', '0', 'tengzhou', '', '滕州', '66.00000', '', '35.06600', '117.10900', '277500'), ('101121501', '1215', '1', 'rizhao', 'rizhao', '日照', '37.00000', '', '35.41900', '119.44700', '276800'), ('101121502', '1215', '0', 'wulian', '', '五莲', '148.00000', '', '35.75600', '119.22600', '262300'), ('101121503', '1215', '0', 'juxian', '', '莒县', '112.00000', '', '35.35000', '118.50000', '276500'), ('101121601', '1216', '1', 'laiwu', 'laiwu', '莱芜', '229.00000', '', '36.19100', '117.66500', '271100'), ('101121701', '1217', '1', 'liaocheng', 'liaocheng', '聊城', '34.00000', '', '36.44700', '115.97100', '252000'), ('101121702', '1217', '0', 'guanxian', '', '冠县', '41.00000', '', '36.29000', '115.27000', '252500'), ('101121703', '1217', '0', 'yanggu', '', '阳谷', '44.00000', '', '36.11600', '115.87600', '252300'), ('101121704', '1217', '0', 'gaotang', '', '高唐', '29.00000', '', '36.83700', '116.23400', '251300'), ('101121705', '1217', '0', 'chiping', '', '茌平', '32.00000', '', '36.56600', '116.15300', '252100'), ('101121706', '1217', '0', 'donge', '', '东阿', '37.00000', '', '36.21000', '116.14000', '252200'), ('101121707', '1217', '0', 'linqing', '', '临清', '35.00000', '', '36.77800', '115.74500', '252600'), ('101121709', '1217', '0', 'shenxian', '', '莘县', '47.00000', '', '36.02000', '115.35000', '252400'), ('101130101', '1301', '1', 'wulumuqi', 'wulumuqi', '乌鲁木齐', '936.00000', '', '43.78100', '87.58500', '830000'), ('101130103', '1301', '0', 'xiaoquzi', '', '小渠子', '2121.00000', '', '43.34000', '87.06000', '830034'), ('101130105', '1301', '0', 'dabancheng', '', '达坂城', '1105.00000', '', '43.21000', '88.19000', '830039'), ('101130108', '1301', '0', 'wulumuqimushizhan', '', '乌鲁木齐牧试站', '2356.00000', '', '43.17000', '87.07000', '830000'), ('101130109', '1301', '0', 'tianchi', '', '天池', '1935.00000', '', '43.53000', '88.07000', '831500'), ('101130110', '1301', '0', 'baiyanggou', '', '白杨沟', '2356.00000', '', '43.17000', '87.07000', '830000'), ('101130201', '1302', '1', 'kelamayi', 'kelamayi', '克拉玛依', '453.00000', '', '45.59700', '84.86700', '834000'), ('101130202', '1302', '0', 'wuerhe', '', '乌尔禾', '304.00000', '', '46.11200', '85.67300', ''), ('101130203', '1302', '0', 'baijiantan', '', '白碱滩', '278.00000', '', '45.70000', '85.13600', ''), ('101130301', '1303', '1', 'shihezi', '', '石河子', '444.00000', '', '44.29900', '86.03700', '832000'), ('101130302', '1303', '0', 'paotai', '', '炮台', '338.00000', '', '44.51000', '85.15000', '832066'), ('101130303', '1303', '0', 'mosuowan', '', '莫索湾', '348.00000', '', '45.01000', '86.06000', '832047'), ('101130401', '1304', '1', 'changji', '', '昌吉', '579.00000', '', '44.01500', '87.29400', '831100'), ('101130402', '1304', '0', 'hutubi', '', '呼图壁', '524.00000', '', '44.24000', '86.60500', '831200'), ('101130403', '1304', '0', 'miquan', '', '米泉', '601.00000', '', '44.37700', '87.65300', '831400'), ('101130404', '1304', '0', 'fukang', '', '阜康', '548.00000', '', '44.37700', '88.25100', '831500'), ('101130405', '1304', '0', 'jimusaer', '', '吉木萨尔', '736.00000', '', '44.01000', '89.10000', '831700'), ('101130406', '1304', '0', 'qitai', '', '奇台', '794.00000', '', '44.45000', '90.28800', '831800'), ('101130407', '1304', '0', 'manasi', '', '玛纳斯', '473.00000', '', '44.19000', '86.12000', '832200'), ('101130408', '1304', '0', 'mulei', '', '木垒', '1272.00000', '', '43.50000', '90.17000', '831900'), ('101130409', '1304', '0', 'caijiahu', '', '蔡家湖', '441.00000', '', '44.12000', '87.32000', '831304'), ('101130501', '1305', '1', 'tulufan', '', '吐鲁番', '37.00000', '', '42.79400', '88.64300', '838000'), ('101130502', '1305', '0', 'tuokexun', '', '托克逊', '2.00000', '', '42.48000', '88.38000', '838100'), ('101130504', '1305', '0', 'shanshan', '', '鄯善', '399.00000', '', '42.51000', '90.14000', '838200'), ('101130601', '1306', '0', 'kuerle', 'kuerle', '库尔勒', '933.00000', '', '41.75300', '86.13400', '841000'), ('101130602', '1306', '0', 'luntai', '', '轮台', '978.00000', '', '41.47000', '84.15000', '841600'), ('101130603', '1306', '0', 'yuli', '', '尉犁', '887.00000', '', '41.21000', '86.16000', '841500'), ('101130604', '1306', '0', 'ruoqiang', '', '若羌', '890.00000', '', '39.02000', '88.10000', '841800'), ('101130605', '1306', '0', 'qiemo', '', '且末', '1248.00000', '', '38.09000', '85.33000', '841900'), ('101130606', '1306', '0', 'hejing', '', '和静', '1110.00000', '', '42.79000', '85.02000', '841300'), ('101130607', '1306', '0', 'yanqi', '', '焉耆', '1058.00000', '', '42.05000', '86.34000', '841100'), ('101130608', '1306', '0', 'heshuo', '', '和硕', '1087.00000', '', '42.15000', '86.48000', '841200'), ('101130610', '1306', '0', 'bayinbuluke', '', '巴音布鲁克', '2459.00000', '', '43.02000', '84.09000', '841314'), ('101130611', '1306', '0', 'tieganlike', '', '铁干里克', '847.00000', '', '40.38000', '87.42000', '841506'), ('101130612', '1306', '0', 'bohu', '', '博湖', '1050.00000', '', '41.90000', '86.72000', '841000'), ('101130613', '1306', '0', 'tazhong', '', '塔中', '1099.00000', '', '39.00000', '83.67000', '841000'), ('101130701', '1307', '1', 'alaer', '', '阿拉尔', '1013.00000', '', '40.30000', '81.03000', '843300'), ('101130801', '1308', '1', 'akesu', '', '阿克苏', '1105.00000', '', '41.17200', '80.25700', '843000'), ('101130802', '1308', '0', 'wushi', '', '乌什', '1397.00000', '', '41.13000', '79.14000', '843400'), ('101130803', '1308', '0', 'wensu', '', '温宿', '1134.00000', '', '41.60700', '80.48500', '843100'), ('101130804', '1308', '0', 'baicheng1', '', '拜城', '1230.00000', '', '42.02700', '81.83300', '842300'), ('101130805', '1308', '0', 'xinhe1', '', '新和', '1015.00000', '', '41.32000', '82.37000', '842100'), ('101130806', '1308', '0', 'shaya', '', '沙雅', '982.00000', '', '40.47900', '82.91000', '842200'), ('101130807', '1308', '0', 'kuche', '', '库车', '1083.00000', '', '41.43000', '83.04000', '842000'), ('101130808', '1308', '0', 'keping', '', '柯坪', '1163.00000', '', '40.30000', '79.03000', '843600'), ('101130809', '1308', '0', 'awati', '', '阿瓦提', '1046.00000', '', '40.39000', '80.24000', '843200'), ('101130901', '1309', '1', 'kashi', '', '喀什', '1291.00000', '', '39.46000', '75.98700', '844000'), ('101130902', '1309', '0', 'yingjisha', '', '英吉沙', '1299.00000', '', '38.56000', '76.10000', '844500'), ('101130903', '1309', '0', 'tashikuergan', '', '塔什库尔干', '3094.00000', '', '37.47000', '75.14000', '845250'), ('101130904', '1309', '0', 'maigaiti', '', '麦盖提', '1180.00000', '', '38.55000', '77.38000', '844600'), ('101130905', '1309', '0', 'shache', '', '莎车', '1232.00000', '', '38.26000', '77.16000', '844700'), ('101130906', '1309', '0', 'yecheng', '', '叶城', '1360.00000', '', '37.55000', '77.24000', '844900'), ('101130907', '1309', '0', 'zepu', '', '泽普', '1275.00000', '', '38.11000', '77.16000', '844800'), ('101130908', '1309', '0', 'bachu', '', '巴楚', '1118.00000', '', '39.52600', '78.60100', '843800'), ('101130909', '1309', '0', 'yuepuhu', '', '岳普湖', '1208.00000', '', '39.15000', '76.47000', '844400'), ('101130910', '1309', '0', 'jiashi', '', '伽师', '1211.00000', '', '39.61300', '77.19400', '844300'), ('101130911', '1309', '0', 'shufu', '', '疏附', '1337.00000', '', '39.37600', '75.85800', ''), ('101130912', '1309', '0', 'shule', '', '疏勒', '1285.00000', '', '39.40900', '76.04800', ''), ('101131001', '1310', '0', 'yining', '', '伊宁', '663.00000', '', '43.91000', '81.30300', '835000'), ('101131002', '1310', '0', 'chabuchaer', '', '察布查尔', '604.00000', '', '43.51000', '81.09000', '835300'), ('101131003', '1310', '0', 'nileke', '', '尼勒克', '1106.00000', '', '43.48000', '82.34000', '835700'), ('101131004', '1310', '0', 'yiningxian', '', '伊宁县', '771.00000', '', '43.58000', '81.32000', '835100'), ('101131005', '1310', '0', 'gongliu', '', '巩留', '777.00000', '', '43.28000', '82.14000', '835400'), ('101131006', '1310', '0', 'xinyuan', '', '新源', '929.00000', '', '43.27000', '83.18000', '835800'), ('101131007', '1310', '0', 'zhaosu', '', '昭苏', '1855.00000', '', '42.83200', '81.01200', '835600'), ('101131008', '1310', '0', 'tekesi', '', '特克斯', '1211.00000', '', '43.11000', '81.46000', '835500'), ('101131009', '1310', '0', 'huocheng', '', '霍城', '641.00000', '', '44.32800', '80.78200', '835200'), ('101131010', '1310', '0', 'huoerguosi', '', '霍尔果斯', '774.00000', '', '44.12000', '80.25000', '835215'), ('101131011', '1310', '0', 'kuitunshi', '', '奎屯', '516.00000', '', '44.42300', '84.89600', ''), ('101131101', '1311', '1', 'tacheng', '', '塔城', '537.00000', '', '46.74700', '82.97400', '834700'), ('101131102', '1311', '0', 'yumin', '', '裕民', '716.00000', '', '45.95900', '82.84500', '834800'), ('101131103', '1311', '0', 'emin', '', '额敏', '523.00000', '', '46.62700', '84.31400', '834600'), ('101131104', '1311', '0', 'hebukesaier', '', '和布克赛尔', '1294.00000', '', '46.47000', '85.43000', '834400'), ('101131105', '1311', '0', 'tuoli', '', '托里', '1078.00000', '', '45.69100', '83.96300', '834500'), ('101131106', '1311', '0', 'wusu', '', '乌苏', '478.00000', '', '44.26000', '84.40000', '833000'), ('101131107', '1311', '0', 'shawan', '', '沙湾', '523.00000', '', '44.33500', '85.55400', '832100'), ('101131108', '1311', '0', 'hebukesaiermengguzizhixian', '', '和丰', '0.00000', '', '0.00000', '0.00000', ''), ('101131201', '1312', '1', 'hami', '', '哈密', '739.00000', '', '42.83900', '93.50400', '839000'), ('101131203', '1312', '0', 'balikun', '', '巴里坤', '1651.00000', '', '43.36000', '93.00000', '839200'), ('101131204', '1312', '0', 'yiwu', '', '伊吾', '1730.00000', '', '29.29200', '120.04300', '839300'), ('101131301', '1313', '1', 'hetian', '', '和田', '1375.00000', '', '37.11100', '79.91600', '848000'), ('101131302', '1313', '0', 'pishan', '', '皮山', '1376.00000', '', '37.37000', '78.17000', '845150'), ('101131303', '1313', '0', 'cele', '', '策勒', '1337.00000', '', '37.01000', '80.48000', '848300'), ('101131304', '1313', '0', 'moyu', '', '墨玉', '1327.00000', '', '37.17000', '79.43000', '848100'), ('101131305', '1313', '0', 'luopu', '', '洛浦', '1349.00000', '', '37.05000', '80.10000', '848200'), ('101131306', '1313', '0', 'mingfeng', '', '民丰', '1411.00000', '', '37.04000', '82.43000', '848500'), ('101131307', '1313', '0', 'yutian1', '', '于田', '1423.00000', '', '37.36900', '81.95300', '848400'), ('101131401', '1314', '1', 'aletai', '', '阿勒泰', '738.00000', '', '47.83800', '88.12500', '836500'), ('101131402', '1314', '0', 'habahe', '', '哈巴河', '535.00000', '', '48.03000', '86.24000', '836700'), ('101131405', '1314', '0', 'jimunai', '', '吉木乃', '984.00000', '', '47.26000', '85.52000', '836800'), ('101131406', '1314', '0', 'buerjin', '', '布尔津', '476.00000', '', '47.42000', '86.52000', '836600'), ('101131407', '1314', '0', 'fuhai', '', '福海', '503.00000', '', '47.07000', '87.28000', '836400'), ('101131408', '1314', '0', 'fuyun', '', '富蕴', '811.00000', '', '46.52300', '89.47300', '836100'), ('101131409', '1314', '0', 'qinghe1', '', '青河', '1220.00000', '', '46.16800', '90.47000', '836200'), ('101131501', '1315', '0', 'atushi', '', '阿图什', '1300.00000', '', '40.16300', '76.62500', '845350'), ('101131502', '1315', '0', 'wuqia', '', '乌恰', '2178.00000', '', '39.43000', '75.15000', '845450'), ('101131503', '1315', '0', 'aketao', '', '阿克陶', '1325.00000', '', '39.09000', '75.57000', '845550'), ('101131504', '1315', '0', 'aheqi', '', '阿合奇', '1986.00000', '', '40.56000', '78.27000', '843500'), ('101131601', '1316', '0', 'bole', '', '博乐', '533.00000', '', '44.60600', '82.89100', '833400'), ('101131602', '1316', '0', 'wenquan', '', '温泉', '1354.00000', '', '44.99900', '80.81300', '833500'), ('101131603', '1316', '0', 'jinghe', '', '精河', '321.00000', '', '44.58600', '82.79200', '833300'), ('101131606', '1316', '0', 'alashankou', '', '阿拉山口', '286.00000', '', '45.11000', '82.35000', '833400'), ('101140101', '1401', '1', 'lasa', 'lasa', '拉萨', '3650.00000', '', '29.65600', '91.12600', '850000'), ('101140102', '1401', '0', 'dangxiong', '', '当雄', '4201.00000', '', '30.29000', '91.06000', '851500'), ('101140103', '1401', '0', 'nimu', '', '尼木', '3811.00000', '', '29.26000', '90.10000', '851300'), ('101140104', '1401', '0', 'linzhou1', '', '林周', '3772.00000', '', '29.89500', '91.26100', ''), ('101140105', '1401', '0', 'duilongdeqing', '', '堆龙德庆', '3988.00000', '', '29.66100', '90.95400', ''), ('101140106', '1401', '0', 'qushui', '', '曲水', '3589.00000', '', '29.35700', '90.73000', ''), ('101140107', '1401', '0', 'dazi', '', '达孜', '3712.00000', '', '29.66900', '91.35300', ''), ('101140108', '1401', '0', 'mozhugongka', '', '墨竹工卡', '4135.00000', '', '29.83000', '91.72600', ''), ('101140201', '1402', '1', 'rikaze', 'rikaze', '日喀则', '3837.00000', '', '29.27400', '88.89900', '857000'), ('101140202', '1402', '0', 'lazi', '', '拉孜', '4001.00000', '', '29.05000', '87.38000', '858100'), ('101140203', '1402', '0', 'nanmulin', '', '南木林', '4001.00000', '', '29.41000', '89.06000', '857100'), ('101140204', '1402', '0', 'nielamu', '', '聂拉木', '3811.00000', '', '28.11000', '85.58000', '858300'), ('101140205', '1402', '0', 'dingri', '', '定日', '4302.00000', '', '28.38000', '87.05000', '858200'), ('101140206', '1402', '0', 'jiangzi', '', '江孜', '4041.00000', '', '28.55000', '89.36000', '857400'), ('101140207', '1402', '0', 'pali', '', '帕里', '4301.00000', '', '27.44000', '89.05000', '857601'), ('101140208', '1402', '0', 'zhongba', '', '仲巴', '4759.00000', '', '29.65300', '84.17500', ''), ('101140209', '1402', '0', 'saga', '', '萨嘎', '4827.00000', '', '29.31800', '85.22200', ''), ('101140210', '1402', '0', 'jilong', '', '吉隆', '4812.00000', '', '28.85800', '85.31100', ''), ('101140211', '1402', '0', 'angren', '', '昂仁', '4849.00000', '', '29.29600', '87.23800', ''), ('101140212', '1402', '0', 'dingjie', '', '定结', '4284.00000', '', '29.23000', '89.77500', ''), ('101140213', '1402', '0', 'sajia', '', '萨迦', '4450.00000', '', '28.90100', '88.01700', ''), ('101140214', '1402', '0', 'xietongmen', '', '谢通门', '4262.00000', '', '29.43200', '88.26100', ''), ('101140216', '1402', '0', 'gangba', '', '岗巴', '4645.00000', '', '28.27300', '88.52500', ''), ('101140217', '1402', '0', 'bailang', '', '白朗', '4388.00000', '', '29.10200', '89.25900', ''), ('101140218', '1402', '0', 'yadong', '', '亚东', '3636.00000', '', '27.47600', '88.90200', ''), ('101140219', '1402', '0', 'kangma', '', '康马', '4445.00000', '', '28.56200', '89.69100', ''), ('101140220', '1402', '0', 'renbu', '', '仁布', '3920.00000', '', '29.23100', '89.84100', ''), ('101140301', '1403', '1', 'shannan', 'shannan', '山南', '3553.00000', '', '29.15000', '91.46000', '856000'), ('101140302', '1403', '0', 'gongga', '', '贡嘎', '3663.00000', '', '29.29000', '90.98200', ''), ('101140303', '1403', '0', 'zhanang', '', '札囊', '3661.00000', '', '29.24100', '91.33400', ''), ('101140304', '1403', '0', 'jiacha', '', '加查', '3261.00000', '', '29.09000', '92.35000', '856400'), ('101140305', '1403', '0', 'langkazi', '', '浪卡子', '4433.00000', '', '28.58000', '90.24000', '851100'), ('101140306', '1403', '0', 'cuona', '', '错那', '4281.00000', '', '27.59000', '91.57000', '856700'), ('101140307', '1403', '0', 'longzi', '', '隆子', '3861.00000', '', '28.25000', '92.28000', '856600'), ('101140308', '1403', '0', 'zedang', '', '泽当', '3553.00000', '', '29.15000', '91.46000', '856000'), ('101140309', '1403', '0', 'naidong', '', '乃东', '3616.00000', '', '29.22400', '91.77700', ''), ('101140310', '1403', '0', 'sangri', '', '桑日', '3616.00000', '', '29.25900', '92.00900', ''), ('101140311', '1403', '0', 'luozha', '', '洛扎', '3906.00000', '', '28.38100', '90.86100', ''), ('101140312', '1403', '0', 'cuomei', '', '措美', '4240.00000', '', '28.43700', '91.43600', ''), ('101140313', '1403', '0', 'qiongjie', '', '琼结', '3792.00000', '', '29.02800', '91.67900', ''), ('101140314', '1403', '0', 'qusong', '', '曲松', '4044.00000', '', '29.05700', '92.20500', ''), ('101140401', '1404', '1', 'linzhi', 'linzhi', '林芝', '3001.00000', '', '29.80800', '94.38500', '850400'), ('101140402', '1404', '0', 'bomi', '', '波密', '2737.00000', '', '29.52000', '95.46000', '860300'), ('101140403', '1404', '0', 'milin', '', '米林', '2948.00000', '', '29.13000', '94.13000', '860500'), ('101140404', '1404', '0', 'chayu', '', '察隅', '2331.00000', '', '28.39000', '97.28000', '860600'), ('101140405', '1404', '0', 'gongbujiangda', '', '工布江达', '4439.00000', '', '29.88700', '93.24300', ''), ('101140406', '1404', '0', 'langxian', '', '朗县', '3476.00000', '', '29.04600', '93.09600', ''), ('101140407', '1404', '0', 'motuo', '', '墨脱', '2961.00000', '', '29.30300', '95.31400', ''), ('101140501', '1405', '1', 'changdu', 'changdu', '昌都', '3307.00000', '', '31.38700', '97.08100', '854000'), ('101140502', '1405', '0', 'dingqing', '', '丁青', '3874.00000', '', '31.25000', '95.36000', '855700'), ('101140503', '1405', '0', 'bianba', '', '边坝', '3648.00000', '', '30.94000', '94.69800', ''), ('101140504', '1405', '0', 'luolong', '', '洛隆', '3640.00000', '', '30.45000', '95.50000', '855400'), ('101140505', '1405', '0', 'zuogong', '', '左贡', '3781.00000', '', '29.40000', '97.50000', '854400'), ('101140506', '1405', '0', 'mangkang', '', '芒康', '3871.00000', '', '29.41000', '98.36000', '854500'), ('101140507', '1405', '0', 'leiwuqi', '', '类乌齐', '4338.00000', '', '31.21700', '96.58800', ''), ('101140508', '1405', '0', 'basu', '', '八宿', '4378.00000', '', '30.05400', '96.91600', ''), ('101140509', '1405', '0', 'jiangda', '', '江达', '4128.00000', '', '31.50600', '98.20800', ''), ('101140510', '1405', '0', 'chaya', '', '察雅', '3772.00000', '', '30.66100', '97.55900', ''), ('101140511', '1405', '0', 'gongjue', '', '贡觉', '4245.00000', '', '30.86800', '98.27000', ''), ('101140601', '1406', '1', 'naqu', 'naqu', '那曲', '4808.00000', '', '31.21500', '92.04800', '852000'), ('101140602', '1406', '0', 'nima', '', '尼玛', '4709.00000', '', '31.11000', '91.08100', ''), ('101140603', '1406', '0', 'jiali', '', '嘉黎', '4490.00000', '', '30.40000', '93.17000', '852400'), ('101140604', '1406', '0', 'bange', '', '班戈', '4701.00000', '', '31.22000', '90.01000', '852500'), ('101140605', '1406', '0', 'anduo', '', '安多', '4801.00000', '', '32.21000', '91.06000', '853400'), ('101140606', '1406', '0', 'suoxian', '', '索县', '4024.00000', '', '31.53000', '93.47000', '852200'), ('101140607', '1406', '0', 'nierong', '', '聂荣', '4874.00000', '', '32.11400', '92.29000', ''), ('101140608', '1406', '0', 'baqing', '', '巴青', '4501.00000', '', '31.92300', '94.06000', ''), ('101140609', '1406', '0', 'biru', '', '比如', '5253.00000', '', '31.48100', '93.68100', ''), ('101140701', '1407', '1', 'ali', 'alidiqu', '阿里', '3901.00000', '', '30.17000', '81.15000', '859000'), ('101140702', '1407', '0', 'gaize', '', '改则', '4416.00000', '', '32.09000', '84.25000', '859200'), ('101140703', '1407', '0', 'shenzha', '', '申扎', '4674.00000', '', '30.57000', '88.38000', '853100'), ('101140704', '1407', '0', 'shiquanhe', '', '狮泉河', '4279.00000', '', '32.30000', '80.05000', '859000'), ('101140705', '1407', '0', 'pulan', '', '普兰', '3901.00000', '', '30.17000', '81.15000', '859500'), ('101140706', '1407', '0', 'zhada', '', '札达', '4423.00000', '', '31.48100', '79.80100', ''), ('101140707', '1407', '0', 'gaer', '', '噶尔', '4994.00000', '', '32.12100', '80.04900', ''), ('101140708', '1407', '0', 'ritu', '', '日土', '4998.00000', '', '33.41900', '79.64300', ''), ('101140709', '1407', '0', 'geji', '', '革吉', '4684.00000', '', '32.39200', '81.11900', ''), ('101140710', '1407', '0', 'cuoqin', '', '措勤', '5011.00000', '', '31.08800', '85.04300', ''), ('101150101', '1501', '1', 'xining', 'xining', '西宁', '2296.00000', '', '36.62100', '101.77800', '810000'), ('101150102', '1501', '0', 'datong1', '', '大通', '2452.00000', '', '40.15500', '113.19100', '810100'), ('101150103', '1501', '0', 'huangyuan', '', '湟源', '2635.00000', '', '36.59500', '101.14900', '812100'), ('101150104', '1501', '0', 'huangzhong', '', '湟中', '2665.00000', '', '36.62300', '101.57600', '811600'), ('101150201', '1502', '1', 'haidong', '', '海东', '2130.00000', '', '36.30000', '102.06000', '810600'), ('101150202', '1502', '0', 'ledu', '', '乐都', '1982.00000', '', '36.53000', '102.43800', '810700'), ('101150203', '1502', '0', 'minhe', '', '民和', '1815.00000', '', '36.19000', '102.51000', '810800'), ('101150204', '1502', '0', 'huzhu', '', '互助', '2481.00000', '', '36.49000', '101.57000', '810500'), ('101150205', '1502', '0', 'hualong', '', '化隆', '2836.00000', '', '36.06000', '102.16000', '810900'), ('101150206', '1502', '0', 'xunhua', '', '循化', '1870.00000', '', '35.50000', '102.33000', '811100'), ('101150207', '1502', '0', 'lenghu', '', '冷湖', '2771.00000', '', '38.45000', '93.20000', '817400'), ('101150208', '1502', '0', 'pingan', '', '平安', '213.00000', '', '36.50000', '102.10000', '810600'), ('101150301', '1503', '1', 'huangnan', '', '黄南', '3501.00000', '', '34.44000', '101.36000', '811300'), ('101150302', '1503', '0', 'jianzha', '', '尖扎', '2086.00000', '', '35.57000', '102.02000', '811200'), ('101150303', '1503', '0', 'zeku', '', '泽库', '3664.00000', '', '35.02000', '101.28000', '811400'), ('101150304', '1503', '0', 'henan1', '', '河南', '3500.00000', '', '34.73000', '101.60000', '811500'), ('101150305', '1503', '0', 'tongren1', '', '同仁', '2532.00000', '', '35.51100', '102.00900', ''), ('101150401', '1504', '1', 'hainan', '', '海南', '2836.00000', '', '36.16000', '100.37000', '813000'), ('101150404', '1504', '0', 'guide', '', '贵德', '2238.00000', '', '35.95100', '101.47000', '811700'), ('101150406', '1504', '0', 'xinghai', '', '兴海', '3324.00000', '', '35.35000', '99.59000', '813300'), ('101150407', '1504', '0', 'guinan', '', '贵南', '3202.00000', '', '35.73100', '100.89100', '813100'), ('101150408', '1504', '0', 'tongde', '', '同德', '3149.00000', '', '35.15000', '100.36000', '813200'), ('101150409', '1504', '0', 'gonghe', '', '共和', '284.00000', '', '36.27000', '100.62000', '813000'), ('101150501', '1505', '1', 'guoluo', '', '果洛', '3721.00000', '', '34.28000', '100.15000', '814000'), ('101150502', '1505', '0', 'banma', '', '班玛', '3531.00000', '', '32.56000', '100.45000', '814300'), ('101150503', '1505', '0', 'gande', '', '甘德', '4051.00000', '', '33.58000', '99.54000', '814100'), ('101150504', '1505', '0', 'dari', '', '达日', '3969.00000', '', '33.45000', '99.39000', '814200'), ('101150505', '1505', '0', 'jiuzhi', '', '久治', '3630.00000', '', '33.26000', '101.29000', '624700'), ('101150506', '1505', '0', 'madu', '', '玛多', '4274.00000', '', '34.55000', '98.13000', '813500'), ('101150507', '1505', '0', 'duoxian1', '', '多县', '0.00000', '', '0.00000', '0.00000', ''), ('101150508', '1505', '0', 'maqin', '', '玛沁', '3721.00000', '', '34.28000', '100.15000', '814000'), ('101150601', '1506', '1', 'yushu1', '', '玉树', '3682.00000', '', '32.89800', '96.70700', '815000'), ('101150602', '1506', '0', 'chenduo', '', '称多', '3995.00000', '', '33.36000', '97.10400', ''), ('101150603', '1506', '0', 'zhiduo', '', '治多', '4181.00000', '', '33.51000', '95.36000', '815400'), ('101150604', '1506', '0', 'zaduo', '', '杂多', '4069.00000', '', '32.54000', '95.18000', '815300'), ('101150605', '1506', '0', 'nangqian', '', '囊谦', '3645.00000', '', '32.12000', '96.29000', '815200'), ('101150606', '1506', '0', 'qumacai', '', '曲麻莱', '4176.00000', '', '34.08000', '95.47000', '815500'), ('101150701', '1507', '1', 'haixi', '', '海西', '2982.00000', '', '37.22000', '97.22000', '817000'), ('101150708', '1507', '0', 'tianjun', '', '天峻', '3418.00000', '', '38.09500', '98.42400', '817200'), ('101150709', '1507', '0', 'wulan', '', '乌兰', '2951.00000', '', '36.55000', '98.29000', '817100'), ('101150712', '1507', '0', 'mangai', '', '茫崖', '2947.00000', '', '38.15000', '90.51000', '817500'), ('101150713', '1507', '0', 'dachaidan', '', '大柴旦', '3174.00000', '', '37.51000', '95.22000', '817300'), ('101150716', '1507', '0', 'delingha', '', '德令哈', '2771.00000', '', '38.45000', '93.20000', '817400'), ('101150801', '1508', '1', 'haibei', '', '海北', '3302.00000', '', '37.20000', '100.08000', '812200'), ('101150802', '1508', '0', 'menyuan', '', '门源', '2851.00000', '', '37.23000', '101.37000', '810300'), ('101150803', '1508', '0', 'qilian', '', '祁连', '2789.00000', '', '38.26600', '99.62700', '810400'), ('101150804', '1508', '0', 'haiman', '', '海晏', '3011.00000', '', '36.55000', '100.59000', '812200'), ('101150806', '1508', '0', 'gangcha', '', '刚察', '3302.00000', '', '37.33000', '100.13000', '812300'), ('101150901', '1509', '1', 'geermu', '', '格尔木', '2809.00000', '', '36.25000', '94.54000', '816000'), ('101150902', '1509', '0', 'dulan', '', '都兰', '3193.00000', '', '36.22300', '97.29600', '816100'), ('101160101', '1601', '1', 'lanzhou', 'lanzhou', '兰州', '1518.00000', '', '36.06800', '103.75100', '730000'), ('101160102', '1601', '0', 'gaolan', '', '皋兰', '1670.00000', '', '36.45600', '103.88400', '730200'), ('101160103', '1601', '0', 'yongdeng', '', '永登', '2119.00000', '', '36.60600', '103.23800', '730300'), ('101160104', '1601', '0', 'yuzhong', '', '榆中', '1875.00000', '', '36.00800', '104.19800', '730100'), ('101160201', '1602', '1', 'dingxi', '', '定西', '1898.00000', '', '35.67400', '104.61400', '743000'), ('101160202', '1602', '0', 'tongwei', '', '通渭', '1769.00000', '', '35.21200', '105.22100', '743300'), ('101160203', '1602', '0', 'longxi', '', '陇西', '1729.00000', '', '35.12300', '104.61000', '748100'), ('101160204', '1602', '0', 'weiyuan', '', '渭源', '2112.00000', '', '35.08000', '104.12000', '748200'), ('101160205', '1602', '0', 'lintao', '', '临洮', '1888.00000', '', '35.22000', '103.52000', '730500'), ('101160206', '1602', '0', 'zhangxian', '', '漳县', '1883.00000', '', '34.51000', '104.27000', '748300'), ('101160207', '1602', '0', 'minxian', '', '岷县', '2316.00000', '', '34.26000', '104.01000', '748400'), ('101160208', '1602', '0', 'anding', '', '安定', '190.00000', '', '35.58000', '104.62000', '744300'), ('101160301', '1603', '1', 'pingliang', '', '平凉', '1348.00000', '', '35.54200', '106.68100', '744000'), ('101160302', '1603', '0', 'jingchuan', '', '泾川', '1030.00000', '', '35.34800', '107.43300', '744300'), ('101160303', '1603', '0', 'lingtai', '', '灵台', '967.00000', '', '35.06400', '107.43400', '744400'), ('101160304', '1603', '0', 'chongxin', '', '崇信', '1150.00000', '', '35.21800', '107.01400', '744200'), ('101160305', '1603', '0', 'huating', '', '华亭', '1456.00000', '', '35.20600', '106.62400', '744100'), ('101160306', '1603', '0', 'zhuanglang', '', '庄浪', '1617.00000', '', '35.25600', '106.08500', '744600'), ('101160307', '1603', '0', 'jingning', '', '静宁', '1659.00000', '', '35.38400', '105.71600', '743400'), ('101160308', '1603', '0', 'kongtong', '', '崆峒', '1348.00000', '', '35.54200', '106.68100', '744000'), ('101160401', '1604', '0', 'xifeng1', '', '庆阳', '1095.00000', '', '35.90200', '107.74700', '745100'), ('101160403', '1604', '0', 'huanxian', '', '环县', '1256.00000', '', '36.35000', '107.18000', '745700'), ('101160404', '1604', '0', 'huachi', '', '华池', '1270.00000', '', '36.49600', '108.01400', '745600'), ('101160405', '1604', '0', 'heshui', '', '合水', '1299.00000', '', '36.03800', '108.28200', '745400'), ('101160406', '1604', '0', 'zhengning', '', '正宁', '1443.00000', '', '35.42500', '108.28400', '745300'), ('101160407', '1604', '0', 'ningxian', '', '宁县', '1222.00000', '', '35.25000', '108.00000', '745200'), ('101160408', '1604', '0', 'zhenyuan', '', '镇原', '1173.00000', '', '35.41000', '107.11000', '744500'), ('101160409', '1604', '0', 'qingcheng', '', '庆城', '1095.00000', '', '35.90200', '107.74700', '745100'), ('101160501', '1605', '1', 'wuwei', '', '武威', '1532.00000', '', '37.92500', '102.63200', '733000'), ('101160502', '1605', '0', 'minqin', '', '民勤', '1369.00000', '', '38.76800', '103.01000', '733300'), ('101160503', '1605', '0', 'gulang', '', '古浪', '2073.00000', '', '37.52600', '103.27900', '733100'), ('101160505', '1605', '0', 'tianzhu', '', '天祝', '2419.00000', '', '36.98000', '103.13000', '733200'), ('101160601', '1606', '1', 'jinchang', 'jinchang', '金昌', '1510.00000', '', '38.46700', '102.16700', '737100'), ('101160602', '1606', '0', 'yongchang', '', '永昌', '1977.00000', '', '38.51300', '102.04900', '737200'), ('101160701', '1607', '1', 'zhangye', '', '张掖', '1484.00000', '', '38.93300', '100.45700', '734000'), ('101160702', '1607', '0', 'sunan', '', '肃南', '2312.00000', '', '38.50000', '99.37000', '734400'), ('101160703', '1607', '0', 'minle', '', '民乐', '2282.00000', '', '38.39300', '100.85300', '734500'), ('101160704', '1607', '0', 'linze', '', '临泽', '1455.00000', '', '39.33000', '100.18500', '734200'), ('101160705', '1607', '0', 'gaotai', '', '高台', '1333.00000', '', '39.48100', '99.59400', '734300'), ('101160706', '1607', '0', 'shandan', '', '山丹', '1766.00000', '', '38.48600', '101.22200', '734100'), ('101160801', '1608', '1', 'jiuquan', '', '酒泉', '1479.00000', '', '39.74300', '98.50900', '735000'), ('101160803', '1608', '0', 'jinta', '', '金塔', '1271.00000', '', '40.36400', '99.14700', '735300'), ('101160804', '1608', '0', 'akesai', '', '阿克塞', '2727.00000', '', '39.40900', '94.26500', ''), ('101160805', '1608', '0', 'guazhou', '', '瓜州', '1172.00000', '', '40.85200', '95.86200', '736100'), ('101160806', '1608', '0', 'subei', '', '肃北', '2159.00000', '', '39.31000', '94.53000', '736300'), ('101160807', '1608', '0', 'yumen', '', '玉门', '1527.00000', '', '40.16000', '97.02000', '735200'), ('101160808', '1608', '0', 'dunhuang', '', '敦煌', '1140.00000', '', '40.65000', '94.13300', '736200'), ('101160901', '1609', '1', 'tianshui', '', '天水', '1143.00000', '', '34.57600', '105.70900', '741000'), ('101160903', '1609', '0', 'qingshui', '', '清水', '1379.00000', '', '34.75300', '106.13000', '741400'), ('101160904', '1609', '0', 'qinan', '', '秦安', '1226.00000', '', '34.52000', '105.40000', '741600'), ('101160905', '1609', '0', 'gangu', '', '甘谷', '1272.00000', '', '34.78700', '105.24300', '741200'), ('101160906', '1609', '0', 'wushan1', '', '武山', '1496.00000', '', '34.68300', '104.86600', '741300'), ('101160907', '1609', '0', 'zhangjiachuan', '', '张家川', '1666.00000', '', '34.59000', '106.12000', '741500'), ('101160908', '1609', '0', 'maiji', '', '麦积', '1085.00000', '', '34.33000', '105.53000', '741020'), ('101161001', '1610', '0', 'wudu', '', '武都', '1082.00000', '', '33.25100', '105.10000', '746000'), ('101161002', '1610', '0', 'chengxian', '', '成县', '971.00000', '', '33.45000', '105.43000', '742500'), ('101161003', '1610', '0', 'wenxian', '', '文县', '1017.00000', '', '32.57000', '104.40000', '746400'), ('101161004', '1610', '0', 'dangchang', '', '宕昌', '1754.00000', '', '33.97200', '104.41500', '748500'), ('101161005', '1610', '0', 'kangxian', '', '康县', '1225.00000', '', '33.20000', '105.36000', '746500'), ('101161006', '1610', '0', 'xihe', '', '西和', '1579.00000', '', '34.02000', '105.18000', '742100'), ('101161007', '1610', '0', 'lixian1', '', '礼县', '1405.00000', '', '34.11000', '105.11000', '742200'), ('101161008', '1610', '0', 'huixian', '', '徽县', '930.00000', '', '35.55900', '113.66400', '742300'), ('101161009', '1610', '0', 'liangdang', '', '两当', '1041.00000', '', '33.87800', '106.39200', '742400'), ('101161101', '1611', '1', 'linxia', '', '临夏', '1919.00000', '', '35.60100', '103.20600', '731100'), ('101161102', '1611', '0', 'kangle', '', '康乐', '2001.00000', '', '35.20400', '103.61800', '731500'), ('101161103', '1611', '0', 'yongjing', '', '永靖', '1649.00000', '', '35.98500', '103.25200', '731600'), ('101161104', '1611', '0', 'guanghe', '', '广河', '1954.00000', '', '35.45500', '103.62700', '731300'), ('101161105', '1611', '0', 'hezheng', '', '和政', '2138.00000', '', '35.32800', '103.28600', '731200'), ('101161106', '1611', '0', 'dongxiang', '', '东乡', '2429.00000', '', '35.40000', '103.24000', '731400'), ('101161107', '1611', '0', 'jishishan', '', '积石山', '2339.00000', '', '35.60000', '102.80000', ''), ('101161201', '1612', '0', 'hezuo', '', '合作', '2911.00000', '', '35.00000', '102.54000', '747000'), ('101161202', '1612', '0', 'lintan', '', '临潭', '2812.00000', '', '34.79500', '103.68600', '747500'), ('101161203', '1612', '0', 'zhuoni', '', '卓尼', '2545.00000', '', '34.68400', '103.16700', '747600'), ('101161204', '1612', '0', 'zhouqu', '', '舟曲', '1401.00000', '', '33.62400', '104.31000', '746300'), ('101161205', '1612', '0', 'diebu', '', '迭部', '2401.00000', '', '33.99100', '103.50100', '747400'), ('101161206', '1612', '0', 'maqu', '', '玛曲', '3473.00000', '', '34.00000', '102.05000', '747300'), ('101161207', '1612', '0', 'luqu', '', '碌曲', '3107.00000', '', '34.39500', '102.48800', '747200'), ('101161208', '1612', '0', 'xiahe', '', '夏河', '2931.00000', '', '35.12000', '102.31000', '747100'), ('101161301', '1613', '1', 'baiyin', '', '白银', '1711.00000', '', '36.54900', '104.20100', '730900'), ('101161302', '1613', '0', 'jingyuan', '', '靖远', '1400.00000', '', '36.34000', '104.41000', '730600'), ('101161303', '1613', '0', 'huining', '', '会宁', '1740.00000', '', '35.93000', '105.01000', '730700'), ('101161304', '1613', '0', 'pingchuan', '', '平川', '1621.00000', '', '36.80000', '104.80000', ''), ('101161305', '1613', '0', 'jingtai', '', '景泰', '1631.00000', '', '37.17900', '104.14600', '730400'), ('101161401', '1614', '1', 'jiayuguan', 'jiayuguan', '嘉峪关', '1655.00000', '', '39.45000', '98.17000', '735100'), ('101170101', '1701', '1', 'yinchuan', 'yinchuan', '银川', '1113.00000', '', '38.46800', '106.26300', '750000'), ('101170102', '1701', '0', 'yongning', '', '永宁', '1118.00000', '', '38.15000', '106.15000', '750100'), ('101170103', '1701', '0', 'lingwu', '', '灵武', '1117.00000', '', '37.93700', '106.51800', '751400'), ('101170104', '1701', '0', 'helan', '', '贺兰', '1108.00000', '', '38.66200', '106.41800', '750200'), ('101170201', '1702', '1', 'shizuishan', 'shizuishan', '石嘴山', '1102.00000', '', '39.01600', '106.37200', '753000'), ('101170202', '1702', '0', 'huinong', '', '惠农', '1092.00000', '', '39.18100', '106.64900', '753200'), ('101170203', '1702', '0', 'pingluo', '', '平罗', '1100.00000', '', '38.92500', '106.39600', '753400'), ('101170204', '1702', '0', 'taole', '', '陶乐', '1103.00000', '', '38.71500', '106.64900', '753500'), ('101170301', '1703', '1', 'wuzhong', '', '吴忠', '1122.00000', '', '37.98500', '106.19600', '751100'), ('101170302', '1703', '0', 'tongxin', '', '同心', '1345.00000', '', '37.04500', '105.98600', '751300'), ('101170303', '1703', '0', 'yanchi', '', '盐池', '1349.00000', '', '37.62300', '107.08100', '751500'), ('101170306', '1703', '0', 'qingtongxia', '', '青铜峡', '1128.00000', '', '37.89900', '105.90800', '751600'), ('101170401', '1704', '1', 'guyuan1', '', '固原', '1753.00000', '', '36.09300', '106.24700', '756000'), ('101170402', '1704', '0', 'xiji', '', '西吉', '1918.00000', '', '35.58000', '105.43000', '756200'), ('101170403', '1704', '0', 'longde', '', '隆德', '2080.00000', '', '35.57400', '106.03800', '756300'), ('101170404', '1704', '0', 'jinyuan1', '', '泾源', '1949.00000', '', '35.30000', '106.19000', '756400'), ('101170406', '1704', '0', 'pengyang', '', '彭阳', '1482.00000', '', '35.85000', '106.63000', '756500'), ('101170501', '1705', '1', 'zhongwei', '', '中卫', '1227.00000', '', '37.34600', '104.98800', '755000'), ('101170502', '1705', '0', 'zhongning', '', '中宁', '1185.00000', '', '37.48000', '105.75400', '751200'), ('101170504', '1705', '0', 'haiyuan', '', '海原', '1856.00000', '', '36.58500', '105.66900', '756100'), ('101180101', '1801', '1', 'zhengzhou', 'zhengzhou', '郑州', '111.00000', '', '34.75800', '113.64100', '450000'), ('101180102', '1801', '0', 'gongyi', '', '巩义', '166.00000', '', '34.44000', '112.58000', '451200'), ('101180103', '1801', '0', 'xingyang', '', '荥阳', '142.00000', '', '34.48000', '113.26000', '450100'), ('101180104', '1801', '0', 'dengfeng', '', '登封', '428.00000', '', '34.43100', '113.01900', '452400'), ('101180105', '1801', '0', 'xinmi', '', '新密', '289.00000', '', '34.31000', '113.22000', '452300'), ('101180106', '1801', '0', 'xinzheng', '', '新郑', '111.00000', '', '34.24000', '113.44000', '451100'), ('101180107', '1801', '0', 'zhongmou', '', '中牟', '80.00000', '', '34.70800', '113.99400', '451400'), ('101180108', '1801', '0', 'shangjie', '', '上街', '157.00000', '', '34.83800', '113.27700', ''), ('101180201', '1802', '1', 'anyang', 'anyang', '安阳', '76.00000', '', '36.09300', '114.34100', '455000'), ('101180202', '1802', '0', 'tangyin', '', '汤阴', '75.00000', '', '35.88600', '114.45900', '456100'), ('101180203', '1802', '0', 'huaxian1', '', '滑县', '66.00000', '', '35.35000', '114.30000', '456450'), ('101180204', '1802', '0', 'neihuang', '', '内黄', '52.00000', '', '35.89000', '114.78200', '456350'), ('101180205', '1802', '0', 'linzhou', '', '林州', '309.00000', '', '36.04000', '113.49000', '456500'), ('101180301', '1803', '1', 'xinxiang', '', '新乡', '74.00000', '', '35.30900', '113.86300', '453000'), ('101180302', '1803', '0', 'huojia', '', '获嘉', '78.00000', '', '35.19300', '113.63900', '453800'), ('101180303', '1803', '0', 'yuanyang', '', '原阳', '78.00000', '', '35.03000', '113.57000', '453500'), ('101180304', '1803', '0', 'huixian1', '', '辉县', '98.00000', '', '35.55900', '113.66400', '453600'), ('101180305', '1803', '0', 'weihui', '', '卫辉', '71.00000', '', '35.51300', '114.08900', '453100'), ('101180306', '1803', '0', 'yanjin', '', '延津', '72.00000', '', '35.09000', '114.11000', '453200'), ('101180307', '1803', '0', 'fengqiu', '', '封丘', '71.00000', '', '35.06100', '114.50500', '453300'), ('101180308', '1803', '0', 'changyuan', '', '长垣', '63.00000', '', '35.18600', '114.74900', '453400'), ('101180401', '1804', '1', 'xuchang', 'xuchang', '许昌', '68.00000', '', '34.02200', '113.80500', '461000'), ('101180402', '1804', '0', 'yanling', '', '鄢陵', '60.00000', '', '34.01000', '114.17900', '461200'), ('101180403', '1804', '0', 'xiangcheng', '', '襄城', '81.00000', '', '33.51000', '113.30000', '452600'), ('101180404', '1804', '0', 'changge', '', '长葛', '89.00000', '', '34.24300', '113.85500', '461500'), ('101180405', '1804', '0', 'yuzhou1', '', '禹州', '117.00000', '', '34.19900', '113.35300', '461670'), ('101180501', '1805', '1', 'pingdingshan', 'pingdingshan', '平顶山', '86.00000', '', '33.74000', '113.29300', '467000'), ('101180502', '1805', '0', 'jiaxian1', '', '郏县', '119.00000', '', '33.59000', '113.12000', '467100'), ('101180503', '1805', '0', 'baofeng', '', '宝丰', '138.00000', '', '33.90800', '113.00700', '467400'), ('101180504', '1805', '0', 'ruzhou', '', '汝州', '214.00000', '', '34.11000', '112.50000', '467500'), ('101180505', '1805', '0', 'yexian', '', '叶县', '88.00000', '', '33.36000', '113.39000', '467200'), ('101180506', '1805', '0', 'wugang', '', '舞钢', '91.00000', '', '33.20000', '113.32000', '462500'), ('101180507', '1805', '0', 'lushan', '', '鲁山', '148.00000', '', '33.45000', '112.53000', '467346'), ('101180508', '1805', '0', 'shilong', '', '石龙', '203.00000', '', '33.90000', '112.88500', ''), ('101180601', '1806', '1', 'xinyang', 'xinyang', '信阳', '115.00000', '', '32.12500', '114.06000', '464000'), ('101180602', '1806', '0', 'xixian1', '', '息县', '50.00000', '', '32.21000', '114.44000', '464300'), ('101180603', '1806', '0', 'luoshan', '', '罗山', '56.00000', '', '32.02200', '114.43500', '464200'), ('101180604', '1806', '0', 'guangshan', '', '光山', '51.00000', '', '31.94900', '114.85600', '465450'), ('101180605', '1806', '0', 'xinxian1', '', '新县', '131.00000', '', '31.38000', '114.51000', '465550'), ('101180606', '1806', '0', 'huaibin', '', '淮滨', '35.00000', '', '32.44700', '115.30300', '464400'), ('101180607', '1806', '0', 'huangchuan', '', '潢川', '43.00000', '', '32.12600', '115.13600', '465150'), ('101180608', '1806', '0', 'gushi', '', '固始', '58.00000', '', '32.17000', '115.63800', '465250'), ('101180609', '1806', '0', 'shangcheng', '', '商城', '79.00000', '', '31.74300', '115.37700', '465350'), ('101180701', '1807', '1', 'nanyang', 'nanyang', '南阳', '131.00000', '', '32.99600', '112.52700', '473000'), ('101180702', '1807', '0', 'nanzhao', '', '南召', '200.00000', '', '33.46300', '112.37500', '474650'), ('101180703', '1807', '0', 'fangcheng', '', '方城', '162.00000', '', '33.34200', '113.01100', '473200'), ('101180704', '1807', '0', 'sheqi', '', '社旗', '124.00000', '', '32.97700', '112.97900', '473300'), ('101180705', '1807', '0', 'xixia', '', '西峡', '252.00000', '', '33.18000', '111.30000', '474550'), ('101180706', '1807', '0', 'neixiang', '', '内乡', '160.00000', '', '33.21500', '111.85700', '474350'), ('101180707', '1807', '0', 'zhenping1', '', '镇平', '194.00000', '', '33.03000', '112.14000', '474200'), ('101180708', '1807', '0', 'xichuan', '', '淅川', '196.00000', '', '33.08000', '111.30000', '474450'), ('101180709', '1807', '0', 'xinye', '', '新野', '90.00000', '', '32.33000', '112.23000', '473500'), ('101180710', '1807', '0', 'tanghe', '', '唐河', '110.00000', '', '32.63100', '112.86700', '473400'), ('101180711', '1807', '0', 'dengzhou', '', '邓州', '113.00000', '', '32.42000', '112.05000', '474100'), ('101180712', '1807', '0', 'tongbai', '', '桐柏', '149.00000', '', '32.49300', '113.40700', '474750'), ('101180801', '1808', '1', 'kaifeng', 'kaifeng', '开封', '73.00000', '', '34.78700', '114.33900', '475000'), ('101180802', '1808', '0', 'qixian1', '', '杞县', '61.00000', '', '34.32000', '114.47000', '475200'), ('101180803', '1808', '0', 'weishi', '', '尉氏', '68.00000', '', '34.40800', '114.15900', '452100'), ('101180804', '1808', '0', 'tongxu', '', '通许', '64.00000', '', '34.42100', '114.47000', '452200'), ('101180805', '1808', '0', 'lankao', '', '兰考', '72.00000', '', '34.88600', '114.98200', '475300'), ('101180901', '1809', '1', 'luoyang', 'luoyang', '洛阳', '138.00000', '', '34.67100', '112.36100', '471000'), ('101180902', '1809', '0', 'xinan', '', '新安', '257.00000', '', '34.43000', '112.09000', '471800'), ('101180903', '1809', '0', 'mengjin', '', '孟津', '325.00000', '', '34.84400', '112.50300', '471100'), ('101180904', '1809', '0', 'yiyang', '', '宜阳', '196.00000', '', '34.30000', '112.11000', '471600'), ('101180905', '1809', '0', 'luoning', '', '洛宁', '330.00000', '', '34.36100', '111.47900', '471700'), ('101180906', '1809', '0', 'yichuan1', '', '伊川', '198.00000', '', '34.25000', '112.25000', '471300'), ('101180907', '1809', '0', 'songxian', '', '嵩县', '328.00000', '', '34.09000', '112.05000', '471400'), ('101180908', '1809', '0', 'yanshi1', '', '偃师', '117.00000', '', '34.64000', '112.73700', '471900'), ('101180909', '1809', '0', 'luanchuan', '', '栾川', '752.00000', '', '33.92300', '111.61600', '471500'), ('101180910', '1809', '0', 'ruyang', '', '汝阳', '345.00000', '', '34.09000', '112.28000', '471200'), ('101180911', '1809', '0', 'jili', '', '吉利', '143.00000', '', '34.89200', '112.58700', ''), ('101181001', '1810', '1', 'shangqiu', 'shangqiu', '商丘', '51.00000', '', '34.43400', '115.63500', '476000'), ('101181003', '1810', '0', 'suixian', '', '睢县', '57.00000', '', '35.55900', '113.66400', '476900'), ('101181004', '1810', '0', 'minquan', '', '民权', '61.00000', '', '34.70100', '115.14200', '476800'), ('101181005', '1810', '0', 'yucheng1', '', '虞城', '47.00000', '', '34.23000', '115.53000', '476300'), ('101181006', '1810', '0', 'zhecheng', '', '柘城', '48.00000', '', '34.10400', '115.28800', '476200'), ('101181007', '1810', '0', 'ningling', '', '宁陵', '55.00000', '', '34.44200', '115.29500', '476700'), ('101181008', '1810', '0', 'xiayi', '', '夏邑', '41.00000', '', '33.15000', '116.08000', '476400'), ('101181009', '1810', '0', 'yongcheng', '', '永城', '33.00000', '', '34.00400', '116.30500', '476600'), ('101181101', '1811', '1', 'jiaozuo', 'jiaozuo', '焦作', '114.00000', '', '35.24200', '113.15300', '454150'), ('101181102', '1811', '0', 'xiuwu', '', '修武', '86.00000', '', '35.14000', '113.25000', '454350'), ('101181103', '1811', '0', 'wuzhi', '', '武陟', '96.00000', '', '35.03400', '113.39200', '454950'), ('101181104', '1811', '0', 'qinyang', '', '沁阳', '120.00000', '', '35.14700', '112.88700', '454550'), ('101181106', '1811', '0', 'boai', '', '博爱', '130.00000', '', '35.11000', '113.03000', '454450'), ('101181107', '1811', '0', 'wenxian1', '', '温县', '109.00000', '', '34.57000', '113.06000', '454800'), ('101181108', '1811', '0', 'mengzhou', '', '孟州', '123.00000', '', '34.55000', '112.47000', '454750'), ('101181201', '1812', '1', 'hebi', 'hebi', '鹤壁', '177.00000', '', '35.89800', '114.16800', '458000'), ('101181202', '1812', '0', 'xunxian', '', '浚县', '63.00000', '', '35.41000', '114.33000', '456250'), ('101181203', '1812', '0', 'qixian2', '', '淇县', '74.00000', '', '35.37000', '114.11000', '456750');
INSERT INTO `district` VALUES ('101181301', '1813', '1', 'puyang', 'puyang', '濮阳', '53.00000', '', '35.70200', '114.99500', '457000'), ('101181302', '1813', '0', 'taiqian', '', '台前', '43.00000', '', '35.97100', '115.88100', '457600'), ('101181303', '1813', '0', 'nanle', '', '南乐', '50.00000', '', '36.09600', '115.24100', '457400'), ('101181304', '1813', '0', 'qingfeng', '', '清丰', '50.00000', '', '35.93500', '115.17500', '457300'), ('101181305', '1813', '0', 'fanxian', '', '范县', '49.00000', '', '35.55000', '115.29000', '457500'), ('101181401', '1814', '1', 'zhoukou', 'zhoukou', '周口', '48.00000', '', '33.63400', '114.64100', '466000'), ('101181402', '1814', '0', 'fugou', '', '扶沟', '59.00000', '', '34.09800', '114.42700', '461300'), ('101181403', '1814', '0', 'taikang', '', '太康', '54.00000', '', '34.09600', '114.83000', '475400'), ('101181404', '1814', '0', 'huaiyang', '', '淮阳', '46.00000', '', '33.67000', '114.86300', '466700'), ('101181405', '1814', '0', 'xihua', '', '西华', '54.00000', '', '33.47000', '114.31000', '466600'), ('101181406', '1814', '0', 'shangshui', '', '商水', '47.00000', '', '33.52000', '114.55400', '466100'), ('101181407', '1814', '0', 'xiangcheng1', '', '项城', '45.00000', '', '33.27000', '114.53000', '466200'), ('101181408', '1814', '0', 'dancheng', '', '郸城', '43.00000', '', '33.62300', '115.31700', '477100'), ('101181409', '1814', '0', 'luyi', '', '鹿邑', '41.00000', '', '33.91000', '115.34300', '477250'), ('101181410', '1814', '0', 'shenqiu', '', '沈丘', '42.00000', '', '33.30800', '115.16100', '466300'), ('101181501', '1815', '1', 'luohe', 'luohe', '漯河', '62.00000', '', '33.56300', '114.02600', '462000'), ('101181502', '1815', '0', 'linying', '', '临颍', '61.00000', '', '33.85200', '113.93400', '462600'), ('101181503', '1815', '0', 'wuyang', '', '舞阳', '92.00000', '', '33.56100', '113.65900', '462400'), ('101181601', '1816', '1', 'zhumadian', 'zhumadian', '驻马店', '84.00000', '', '32.98000', '114.01700', '463000'), ('101181602', '1816', '0', 'xiping', '', '西平', '61.00000', '', '33.23000', '114.00000', '463900'), ('101181603', '1816', '0', 'suiping', '', '遂平', '64.00000', '', '33.15000', '113.89800', '463100'), ('101181604', '1816', '0', 'shangcai', '', '上蔡', '61.00000', '', '33.30900', '114.40500', '463800'), ('101181605', '1816', '0', 'runan', '', '汝南', '50.00000', '', '33.00000', '114.20000', '463300'), ('101181606', '1816', '0', 'biyang', '', '泌阳', '143.00000', '', '32.86500', '113.43300', '463700'), ('101181607', '1816', '0', 'pingyu', '', '平舆', '45.00000', '', '32.95900', '114.65700', '463400'), ('101181608', '1816', '0', 'xincai', '', '新蔡', '39.00000', '', '32.44000', '114.59000', '463500'), ('101181609', '1816', '0', 'queshan', '', '确山', '86.00000', '', '32.75000', '113.93200', '463200'), ('101181610', '1816', '0', 'zhengyang', '', '正阳', '80.00000', '', '32.54000', '114.54100', '463600'), ('101181701', '1817', '1', 'sanmenxia', 'sanmenxia', '三门峡', '412.00000', '', '34.77900', '111.19500', '472000'), ('101181702', '1817', '0', 'lingbao', '', '灵宝', '475.00000', '', '34.42800', '110.77300', '472500'), ('101181703', '1817', '0', 'mianchi', '', '渑池', '521.00000', '', '34.83800', '111.79000', '472400'), ('101181704', '1817', '0', 'lushi', '', '卢氏', '570.00000', '', '33.97100', '110.96800', '472200'), ('101181705', '1817', '0', 'yima', '', '义马', '515.00000', '', '34.74700', '111.86600', ''), ('101181706', '1817', '0', 'shanxian1', '', '陕县', '361.00000', '', '34.78200', '111.19500', ''), ('101181801', '1818', '1', 'jiyuan', 'xinxiang', '济源', '141.00000', '', '35.09100', '112.39400', '454600'), ('101190101', '1901', '1', 'nanjing', 'nanjing', '南京', '8.00000', '', '32.04800', '118.76900', '210000'), ('101190102', '1901', '0', 'lishui2', '', '溧水', '24.00000', '', '31.40000', '119.02000', '211200'), ('101190103', '1901', '0', 'gaochun', '', '高淳', '15.00000', '', '31.36200', '118.95400', '211300'), ('101190104', '1901', '0', 'jiangning', '', '江宁', '24.00000', '', '31.87000', '118.79900', '211100'), ('101190105', '1901', '0', 'luhe1', '', '六合', '14.00000', '', '32.39600', '118.81900', '211500'), ('101190106', '1901', '0', 'jiangpu', '', '江浦', '10.00000', '', '32.02700', '118.52000', '211800'), ('101190107', '1901', '0', 'pukou', '', '浦口', '10.00000', '', '32.02700', '118.52000', '211800'), ('101190201', '1902', '1', 'wuxi1', 'wuxi', '无锡', '5.00000', '', '31.57400', '120.28800', '214000'), ('101190202', '1902', '0', 'jiangyin', 'jiangyin', '江阴', '13.00000', '', '31.84400', '120.29100', '214400'), ('101190203', '1902', '0', 'yixing', 'yixing', '宜兴', '17.00000', '', '31.37700', '119.81800', '214200'), ('101190204', '1902', '0', 'xishan', '', '锡山', '8.00000', '', '31.58700', '120.35700', '214100'), ('101190301', '1903', '1', 'zhenjiang', 'zhenjiang', '镇江', '27.00000', '', '32.20200', '119.43400', '212000'), ('101190302', '1903', '0', 'danyang', '', '丹阳', '9.00000', '', '31.93500', '119.64500', '212300'), ('101190303', '1903', '0', 'yangzhong', '', '扬中', '6.00000', '', '32.16800', '119.83000', '212200'), ('101190304', '1903', '0', 'jurong', 'jurong', '句容', '27.00000', '', '31.92400', '119.16900', '212400'), ('101190305', '1903', '0', 'dantu', '', '丹徒', '29.00000', '', '32.10000', '119.50000', '212100'), ('101190401', '1904', '1', 'suzhou', 'suzhou', '苏州', '11.00000', '', '31.30900', '120.61200', '215000'), ('101190402', '1904', '0', 'changshu', 'changshu', '常熟', '9.00000', '', '31.66400', '120.80000', '215500'), ('101190403', '1904', '0', 'zhangjiagang', 'zhangjiagang', '张家港', '7.00000', '', '31.88000', '120.64000', '215600'), ('101190404', '1904', '0', 'kunshan', 'kunshan', '昆山', '9.00000', '', '31.32000', '120.97600', '215300'), ('101190405', '1904', '0', 'wuzhong1', '', '吴中', '9.00000', '', '31.26800', '120.62300', '215000'), ('101190407', '1904', '0', 'wujiang', 'wujiang', '吴江', '9.00000', '', '30.99400', '120.62300', '215200'), ('101190408', '1904', '0', 'taicang', 'taicang', '太仓', '10.00000', '', '31.54600', '121.15400', '215400'), ('101190501', '1905', '1', 'nantong', 'nantong', '南通', '11.00000', '', '32.01600', '120.84000', '226000'), ('101190502', '1905', '0', 'haian', '', '海安', '5.00000', '', '32.32000', '120.27000', '226600'), ('101190503', '1905', '0', 'rugao', '', '如皋', '6.00000', '', '32.24500', '120.58600', '226500'), ('101190504', '1905', '0', 'rudong', '', '如东', '5.00000', '', '32.40000', '121.05000', '226400'), ('101190507', '1905', '0', 'qidong', '', '启东', '12.00000', '', '31.48000', '121.40000', '226200'), ('101190508', '1905', '0', 'haimen', 'haimen', '海门', '10.00000', '', '31.97700', '121.29500', '226100'), ('101190509', '1905', '0', 'tongzhou1', '', '通州', '85.00000', '', '32.10000', '121.08000', '226300'), ('101190601', '1906', '1', 'yangzhou', 'yangzhou', '扬州', '15.00000', '', '32.38600', '119.42700', '225000'), ('101190602', '1906', '0', 'baoying', '', '宝应', '8.00000', '', '33.21600', '119.42600', '225800'), ('101190603', '1906', '0', 'yizheng', '', '仪征', '15.00000', '', '32.41700', '119.18600', '211400'), ('101190604', '1906', '0', 'gaoyou', '', '高邮', '10.00000', '', '32.84700', '119.50200', '225600'), ('101190605', '1906', '0', 'jiangdu', '', '江都', '10.00000', '', '32.54800', '119.67900', '225200'), ('101190606', '1906', '0', 'hanjiang1', '', '邗江', '9.00000', '', '32.37500', '119.39200', '225100'), ('101190701', '1907', '1', 'yancheng', 'yancheng', '盐城', '3.00000', '', '33.38700', '120.13000', '224000'), ('101190702', '1907', '0', 'xiangshui', '', '响水', '8.00000', '', '34.13000', '119.36000', '224600'), ('101190703', '1907', '0', 'binhai', '', '滨海', '5.00000', '', '34.09500', '119.98600', '224500'), ('101190704', '1907', '0', 'funing1', '', '阜宁', '6.00000', '', '33.48000', '119.48000', '224400'), ('101190705', '1907', '0', 'sheyang', '', '射阳', '7.00000', '', '33.74900', '120.25000', '224300'), ('101190706', '1907', '0', 'jianhu', '', '建湖', '7.00000', '', '33.48300', '119.82400', '224700'), ('101190707', '1907', '0', 'dongtai', '', '东台', '5.00000', '', '32.79400', '120.50800', '224200'), ('101190708', '1907', '0', 'dafeng', '', '大丰', '7.00000', '', '33.23700', '120.53600', '224100'), ('101190709', '1907', '0', 'yandu', '', '盐都', '0.00000', '', '20.00000', '120.00000', '224000'), ('101190801', '1908', '1', 'xuzhou', 'xuzhou', '徐州', '42.00000', '', '34.26300', '117.18800', '221006'), ('101190802', '1908', '0', 'tongshan1', '', '铜山', '41.00000', '', '34.27000', '117.18800', '221100'), ('101190803', '1908', '0', 'fengxian2', '', '丰县', '41.00000', '', '30.90800', '121.55100', '221700'), ('101190804', '1908', '0', 'peixian', '', '沛县', '40.00000', '', '34.43000', '116.55000', '221600'), ('101190805', '1908', '0', 'pizhou', '', '邳州', '24.00000', '', '34.18000', '117.51000', '221300'), ('101190806', '1908', '0', 'suining2', '', '睢宁', '24.00000', '', '33.91000', '117.94000', '221200'), ('101190807', '1908', '0', 'xinyi', '', '新沂', '29.00000', '', '34.21000', '118.21000', '221400'), ('101190901', '1909', '1', 'huaian1', 'huaian', '淮安', '8.00000', '', '33.49900', '119.13600', '223000'), ('101190902', '1909', '0', 'jinhu', '', '金湖', '29.00000', '', '33.02000', '119.11900', '211600'), ('101190903', '1909', '0', 'xuyi', '', '盱眙', '43.00000', '', '32.59000', '118.31000', '211700'), ('101190904', '1909', '0', 'hongze', '', '洪泽', '20.00000', '', '33.22800', '118.81400', '223100'), ('101190905', '1909', '0', 'lianshui', '', '涟水', '10.00000', '', '33.86200', '119.31800', '223400'), ('101190906', '1909', '0', 'huaiyinqu', '', '淮阴区', '15.00000', '', '33.40000', '119.02000', '223300'), ('101190908', '1909', '0', 'chuzhou', '', '淮安区', '8.00000', '', '33.49900', '119.13600', '223200'), ('101191001', '1910', '1', 'lianyungang', 'lianyungang', '连云港', '4.00000', '', '34.59900', '119.16700', '222000'), ('101191002', '1910', '0', 'donghai', '', '东海', '35.00000', '', '34.56000', '118.78700', '222300'), ('101191003', '1910', '0', 'ganyu', '', '赣榆', '3.00000', '', '34.90200', '119.02700', '222100'), ('101191004', '1910', '0', 'guanyun', '', '灌云', '5.00000', '', '34.42000', '119.42700', '222200'), ('101191005', '1910', '0', 'guannan', '', '灌南', '6.00000', '', '34.21900', '119.46400', '223500'), ('101191101', '1911', '1', 'changzhou', 'changzhou', '常州', '8.00000', '', '31.76600', '119.94800', '213000'), ('101191102', '1911', '0', 'liyang', 'liyang', '溧阳', '8.00000', '', '31.42200', '119.37600', '213300'), ('101191103', '1911', '0', 'jintan', 'jintan', '金坛', '10.00000', '', '31.72500', '119.52200', '213200'), ('101191104', '1911', '0', 'wujin', '', '武进', '6.00000', '', '31.78300', '119.95200', '213100'), ('101191201', '1912', '1', 'taizhou2', 'taizhoushi', '泰州', '10.00000', '', '32.48800', '119.90400', '225300'), ('101191202', '1912', '0', 'xinghua', '', '兴化', '7.00000', '', '32.56000', '119.50000', '225700'), ('101191203', '1912', '0', 'taixing', '', '泰兴', '9.00000', '', '32.18800', '120.09200', '225400'), ('101191204', '1912', '0', 'jiangyan', '', '姜堰', '6.00000', '', '32.31000', '120.09000', '225500'), ('101191205', '1912', '0', 'jingjiang2', '', '靖江', '8.00000', '', '32.03800', '120.28200', '214500'), ('101191301', '1913', '1', 'suqian', 'suqian', '宿迁', '28.00000', '', '33.93300', '118.28300', '223800'), ('101191302', '1913', '0', 'shuyang', '', '沭阳', '9.00000', '', '34.15700', '118.83500', '223600'), ('101191303', '1913', '0', 'siyang', '', '泗阳', '16.00000', '', '33.69500', '118.60900', '223700'), ('101191304', '1913', '0', 'sihong', '', '泗洪', '17.00000', '', '33.47000', '118.34700', '223900'), ('101191305', '1913', '0', 'suyu', '', '宿豫', '15.00000', '', '33.94900', '118.43500', '223800'), ('101200101', '2001', '1', 'wuhan', 'wuhan', '武汉', '27.00000', '', '30.57300', '114.27900', '430000'), ('101200102', '2001', '0', 'caidian', '', '蔡甸', '39.00000', '', '30.35000', '114.00000', '430100'), ('101200103', '2001', '0', 'huangpi', '', '黄陂', '32.00000', '', '30.52000', '114.24000', '432200'), ('101200104', '2001', '0', 'xinzhou1', '', '新洲', '38.00000', '', '30.51000', '114.48000', '431400'), ('101200105', '2001', '0', 'jiangxia', '', '江夏', '38.00000', '', '30.21000', '114.19000', '430200'), ('101200106', '2001', '0', 'dongxihu', '', '东西湖', '39.00000', '', '30.63100', '114.12900', ''), ('101200201', '2002', '1', 'xiangyang', 'xiangyan', '襄阳', '70.00000', '', '32.08200', '112.09600', '441000'), ('101200202', '2002', '0', 'xiangzhou1', '', '襄州', '68.00000', '', '32.18000', '112.15000', '441100'), ('101200203', '2002', '0', 'baokang', '', '保康', '330.00000', '', '31.73600', '111.15000', '441600'), ('101200204', '2002', '0', 'nanzhang', '', '南漳', '108.00000', '', '31.62600', '111.77700', '441500'), ('101200205', '2002', '0', 'yicheng2', '', '宜城', '67.00000', '', '31.43000', '112.14000', '441400'), ('101200206', '2002', '0', 'laohekou', '', '老河口', '91.00000', '', '32.40600', '111.75500', '441800'), ('101200207', '2002', '0', 'gucheng1', '', '谷城', '88.00000', '', '32.16000', '111.38000', '441700'), ('101200208', '2002', '0', 'zaoyang', '', '枣阳', '127.00000', '', '32.03200', '112.78700', '441200'), ('101200301', '2003', '1', 'ezhou', 'ezhou', '鄂州', '22.00000', '', '30.41100', '114.85800', '436000'), ('101200302', '2003', '0', 'liangzihu', '', '梁子湖', '68.00000', '', '30.08500', '114.66500', ''), ('101200401', '2004', '1', 'xiaogan', 'xiaogan', '孝感', '26.00000', '', '30.91900', '113.90000', '432100'), ('101200402', '2004', '0', 'anlu', '', '安陆', '54.00000', '', '31.26700', '113.62800', '432600'), ('101200403', '2004', '0', 'yunmeng', '', '云梦', '34.00000', '', '30.98800', '113.75400', '432500'), ('101200404', '2004', '0', 'dawu', '', '大悟', '72.00000', '', '30.93500', '101.15500', '432800'), ('101200405', '2004', '0', 'yingcheng', '', '应城', '32.00000', '', '30.93300', '113.54700', '432400'), ('101200406', '2004', '0', 'hanchuan', '', '汉川', '26.00000', '', '30.61800', '113.66300', '432300'), ('101200407', '2004', '0', 'xiaochang', '', '孝昌', '44.00000', '', '31.23400', '113.93600', ''), ('101200501', '2005', '1', 'huanggang', 'huanggan', '黄冈', '41.00000', '', '30.27000', '114.53000', '438000'), ('101200502', '2005', '0', 'hongan', '', '红安', '76.00000', '', '31.17000', '114.37000', '438400'), ('101200503', '2005', '0', 'macheng', '', '麻城', '59.00000', '', '31.23400', '115.07300', '438300'), ('101200504', '2005', '0', 'luotian', '', '罗田', '104.00000', '', '30.93000', '115.43600', '438600'), ('101200505', '2005', '0', 'yingshan', '', '英山', '126.00000', '', '30.44000', '115.40000', '438700'), ('101200506', '2005', '0', 'xishui', '', '浠水', '51.00000', '', '30.27000', '115.15000', '438200'), ('101200507', '2005', '0', 'qichun', '', '蕲春', '32.00000', '', '30.33500', '115.57200', '438300'), ('101200508', '2005', '0', 'huangmei', '', '黄梅', '24.00000', '', '30.01700', '115.92500', '438500'), ('101200509', '2005', '0', 'wuxue', '', '武穴', '20.00000', '', '30.01700', '115.59300', '435400'), ('101200510', '2005', '0', 'tuanfeng', '', '团风', '23.00000', '', '30.63100', '114.86700', ''), ('101200601', '2006', '1', 'huangshi', 'huangshi', '黄石', '21.00000', '', '30.21200', '115.10100', '435000'), ('101200602', '2006', '0', 'daye', '', '大冶', '38.00000', '', '30.09300', '114.88500', '435100'), ('101200603', '2006', '0', 'yangxin1', '', '阳新', '47.00000', '', '29.51000', '115.12000', '435200'), ('101200604', '2006', '0', 'tieshan', '', '铁山', '49.00000', '', '30.20700', '114.89500', ''), ('101200605', '2006', '0', 'xialu', '', '下陆', '36.00000', '', '30.17600', '114.95200', ''), ('101200606', '2006', '0', 'xisaishan', '', '西塞山', '40.00000', '', '30.19800', '115.11200', ''), ('101200701', '2007', '1', 'xianning', 'xianning', '咸宁', '62.00000', '', '29.87300', '114.27100', '437000'), ('101200702', '2007', '0', 'chibi', '', '赤壁', '47.00000', '', '29.43000', '113.53000', '437300'), ('101200703', '2007', '0', 'jiayu', '', '嘉鱼', '36.00000', '', '30.04400', '114.07200', '437200'), ('101200704', '2007', '0', 'chongyang', '', '崇阳', '79.00000', '', '29.44600', '114.03400', '437500'), ('101200705', '2007', '0', 'tongcheng', '', '通城', '100.00000', '', '29.15000', '113.48000', '437400'), ('101200706', '2007', '0', 'tongshan', '', '通山', '74.00000', '', '29.36000', '114.30000', '437600'), ('101200801', '2008', '1', 'jingzhou', 'jingzhou', '荆州', '34.00000', '', '30.20000', '112.11000', '434000'), ('101200802', '2008', '0', 'jiangling', '', '江陵', '36.00000', '', '30.29200', '112.44300', '434100'), ('101200803', '2008', '0', 'gongan', '', '公安', '39.00000', '', '30.04000', '112.13000', '434300'), ('101200804', '2008', '0', 'shishou', '', '石首', '37.00000', '', '29.72600', '112.51600', '434400'), ('101200805', '2008', '0', 'jianli', '', '监利', '31.00000', '', '29.81400', '112.95500', '433300'), ('101200806', '2008', '0', 'honghu', '', '洪湖', '28.00000', '', '29.92400', '113.60600', '433200'), ('101200807', '2008', '0', 'songzi', '', '松滋', '67.00000', '', '30.13500', '111.64600', '434200'), ('101200901', '2009', '1', 'yichang', 'yichang', '宜昌', '134.00000', '', '30.70800', '111.28100', '443000'), ('101200902', '2009', '0', 'yuanan', '', '远安', '126.00000', '', '31.04000', '111.38000', '444200'), ('101200903', '2009', '0', 'zigui', '', '秭归', '296.00000', '', '30.91700', '110.65800', '443600'), ('101200904', '2009', '0', 'xingshan', '', '兴山', '276.00000', '', '31.14000', '110.46000', '443700'), ('101200905', '2009', '0', 'yichangxian', '', '宜昌县', '0.00000', '', '0.00000', '0.00000', ''), ('101200906', '2009', '0', 'wufeng', '', '五峰', '618.00000', '', '30.12000', '110.39000', '443400'), ('101200907', '2009', '0', 'dangyang', '', '当阳', '92.00000', '', '30.84600', '111.81000', '444100'), ('101200908', '2009', '0', 'changyang', '', '长阳', '144.00000', '', '30.28000', '111.11000', '443500'), ('101200909', '2009', '0', 'yidu', '', '宜都', '72.00000', '', '30.23000', '111.27000', '443300'), ('101200910', '2009', '0', 'zhijiang', '', '枝江', '51.00000', '', '30.47200', '111.65500', '443200'), ('101200911', '2009', '0', 'sanxia', '', '三峡', '138.00000', '', '30.52000', '111.05000', '443200'), ('101200912', '2009', '0', 'yiling', '', '夷陵', '117.00000', '', '30.46000', '111.19000', '443100'), ('101201001', '2010', '1', 'enshi', 'enshi', '恩施', '458.00000', '', '30.27500', '109.47400', '445000'), ('101201002', '2010', '0', 'lichuan', '', '利川', '1073.00000', '', '30.17000', '108.56000', '445400'), ('101201003', '2010', '0', 'jianshi', '', '建始', '612.00000', '', '30.50800', '110.01000', '445300'), ('101201004', '2010', '0', 'xianfeng', '', '咸丰', '777.00000', '', '29.41000', '109.09000', '445600'), ('101201005', '2010', '0', 'xuanen', '', '宣恩', '533.00000', '', '30.00000', '109.29000', '445500'), ('101201006', '2010', '0', 'hefeng1', '', '鹤峰', '538.00000', '', '29.93600', '110.19900', '445800'), ('101201007', '2010', '0', 'laifeng', '', '来凤', '460.00000', '', '29.39200', '109.24600', '445700'), ('101201008', '2010', '0', 'badong', '', '巴东', '33.00000', '', '30.81300', '110.31200', '444300'), ('101201101', '2011', '1', 'shiyan', 'shiyan', '十堰', '287.00000', '', '32.61900', '110.77200', '442000'), ('101201102', '2011', '0', 'zhuxi', '', '竹溪', '450.00000', '', '32.19000', '109.41000', '442300'), ('101201103', '2011', '0', 'yunxi', '', '郧西', '250.00000', '', '33.03200', '110.05200', '442600'), ('101201104', '2011', '0', 'yunxian', '', '郧县', '204.00000', '', '32.51000', '110.49000', '442500'), ('101201105', '2011', '0', 'zhushan', '', '竹山', '309.00000', '', '32.06800', '110.27800', '442200'), ('101201106', '2011', '0', 'fangxian', '', '房县', '427.00000', '', '32.02000', '110.46000', '442100'), ('101201107', '2011', '0', 'danjiangkou', '', '丹江口', '136.00000', '', '32.60800', '111.19000', '442700'), ('101201108', '2011', '0', 'maojian', '', '茅箭', '221.00000', '', '32.59400', '110.84300', ''), ('101201109', '2011', '0', 'zhangwan', '', '张湾', '281.00000', '', '32.65400', '110.75800', ''), ('101201201', '2012', '1', 'shennongjia', 'shennongjia', '神农架', '937.00000', '', '31.73300', '110.73300', '442400'), ('101201301', '2013', '1', 'suizhou', 'suizhou', '随州', '98.00000', '', '31.70900', '113.36300', '441300'), ('101201302', '2013', '0', 'guangshui', '', '广水', '95.00000', '', '31.74000', '113.82600', '432700'), ('101201401', '2014', '1', 'jingmen', 'jingmen', '荆门', '112.00000', '', '31.03100', '112.19500', '448000'), ('101201402', '2014', '0', 'zhongxiang', '', '钟祥', '66.00000', '', '31.15800', '112.56300', '431900'), ('101201403', '2014', '0', 'jingshan', '', '京山', '69.00000', '', '31.07800', '113.10400', '431800'), ('101201404', '2014', '0', 'duodao', '', '掇刀', '96.00000', '', '30.96900', '112.15500', ''), ('101201405', '2014', '0', 'shayang', '', '沙洋', '35.00000', '', '30.70000', '112.58200', ''), ('101201406', '2014', '0', 'shashi', 'changsha', '沙市', '33.00000', '', '30.28700', '112.31000', ''), ('101201501', '2015', '1', 'tianmen', '', '天门', '36.00000', '', '30.64200', '113.02900', '431700'), ('101201601', '2016', '1', 'xiantao', 'xiantao', '仙桃', '30.00000', '', '30.37500', '113.45100', '433000'), ('101201701', '2017', '1', 'qianjiang1', 'qianjiang', '潜江', '32.00000', '', '30.42700', '112.89100', '433100'), ('101210101', '2101', '1', 'hangzhou', 'hangzhou', '杭州', '43.00000', '', '30.31900', '120.16500', '310000'), ('101210102', '2101', '0', 'xiaoshan', '', '萧山', '42.00000', '', '30.12000', '120.19000', '311200'), ('101210103', '2101', '0', 'tonglu', '', '桐庐', '42.00000', '', '29.84600', '119.57300', '311500'), ('101210104', '2101', '0', 'chunan', '', '淳安', '172.00000', '', '29.37000', '119.01000', '311700'), ('101210105', '2101', '0', 'jiande', '', '建德', '87.00000', '', '29.49200', '119.33200', '311600'), ('101210106', '2101', '0', 'yuhang', '', '余杭', '195.00000', '', '30.41900', '120.29900', '311100'), ('101210107', '2101', '0', 'linan', 'linan', '临安', '134.00000', '', '30.14000', '119.42000', '311300'), ('101210108', '2101', '0', 'fuyang', 'fuyangshi', '富阳', '48.00000', '', '30.03000', '119.57000', '311400'), ('101210201', '2102', '1', 'huzhou', 'huzhou', '湖州', '4.00000', '', '30.86400', '120.09600', '313000'), ('101210202', '2102', '0', 'changxing', '', '长兴', '8.00000', '', '30.94800', '119.83100', '313100'), ('101210203', '2102', '0', 'anji', '', '安吉', '22.00000', '', '30.62400', '119.55800', '313300'), ('101210204', '2102', '0', 'deqing', '', '德清', '23.00000', '', '30.32000', '120.04000', '313200'), ('101210301', '2103', '1', 'jiaxing', 'jiaxing', '嘉兴', '6.00000', '', '30.75800', '120.74900', '314000'), ('101210302', '2103', '0', 'jiashan', '', '嘉善', '9.00000', '', '30.89300', '120.88800', '314100'), ('101210303', '2103', '0', 'haining', '', '海宁', '11.00000', '', '30.46200', '120.56800', '314400'), ('101210304', '2103', '0', 'tongxiang', '', '桐乡', '7.00000', '', '30.63800', '120.47800', '314500'), ('101210305', '2103', '0', 'pinghu', '', '平湖', '7.00000', '', '30.72300', '121.10400', '314200'), ('101210306', '2103', '0', 'haiyan1', '', '海盐', '6.00000', '', '30.49500', '120.88100', '314300'), ('101210401', '2104', '1', 'ningbo', 'ningbo', '宁波', '23.00000', '', '29.87200', '121.54200', '315000'), ('101210403', '2104', '0', 'cixi', '', '慈溪', '4.00000', '', '30.18100', '121.33700', '315300'), ('101210404', '2104', '0', 'yuyao', '', '余姚', '13.00000', '', '29.94800', '121.17200', '315400'), ('101210405', '2104', '0', 'fenghua', '', '奉化', '9.00000', '', '29.59300', '121.41100', '315500'), ('101210406', '2104', '0', 'xiangshan', '', '象山', '4.00000', '', '29.28000', '121.52000', '315700'), ('101210408', '2104', '0', 'ninghai', '', '宁海', '25.00000', '', '29.31300', '121.46800', '315600'), ('101210410', '2104', '0', 'beilun', '', '北仑', '50.00000', '', '29.88000', '121.83000', '315800'), ('101210411', '2104', '0', 'yinzhou', '', '鄞州', '195.00000', '', '29.81600', '121.54700', '315100'), ('101210412', '2104', '0', 'zhenhai', '', '镇海', '4.00000', '', '29.59000', '121.36000', '315000'), ('101210501', '2105', '1', 'shaoxing', 'shaoxing', '绍兴', '8.00000', '', '29.99200', '120.57900', '312000'), ('101210502', '2105', '0', 'zhuji', 'zhuji', '诸暨', '13.00000', '', '29.67900', '120.20900', '311800'), ('101210503', '2105', '0', 'shangyu', '', '上虞', '16.00000', '', '29.95300', '120.87900', '312300'), ('101210504', '2105', '0', 'xinchang', '', '新昌', '112.00000', '', '29.31000', '120.53000', '312500'), ('101210505', '2105', '0', 'shengzhou', '', '嵊州', '108.00000', '', '29.36000', '120.49000', '312400'), ('101210601', '2106', '1', 'taizhou', 'taizhou', '台州', '9.00000', '', '28.82900', '121.17600', '318000'), ('101210603', '2106', '0', 'yuhuan', '', '玉环', '99.00000', '', '28.12600', '121.21300', '317600'), ('101210604', '2106', '0', 'sanmen', 'sanmenxia', '三门', '11.00000', '', '29.00300', '121.46200', '317100'), ('101210605', '2106', '0', 'tiantai', '', '天台', '60.00000', '', '29.14500', '120.97000', '317200'), ('101210606', '2106', '0', 'xianju', '', '仙居', '52.00000', '', '28.51000', '120.43000', '317300'), ('101210607', '2106', '0', 'wenling', '', '温岭', '34.00000', '', '28.39000', '121.41700', '317500'), ('101210609', '2106', '0', 'hongjia', '', '洪家', '2.00000', '', '28.37000', '121.25000', '318015'), ('101210610', '2106', '0', 'linhai', '', '临海', '9.00000', '', '28.49300', '121.89300', '317000'), ('101210611', '2106', '0', 'jiaojiang', '', '椒江', '195.00000', '', '28.67300', '121.44300', '318000'), ('101210612', '2106', '0', 'huangyan', '', '黄岩', '195.00000', '', '28.65000', '121.26200', '318020'), ('101210613', '2106', '0', 'luqiao', '', '路桥', '195.00000', '', '28.58300', '121.36500', '318000'), ('101210701', '2107', '1', 'wenzhou', 'wenzhou', '温州', '29.00000', '', '28.00300', '120.64800', '325000'), ('101210702', '2107', '0', 'taishun', '', '泰顺', '506.00000', '', '27.56500', '119.93300', '325500'), ('101210703', '2107', '0', 'wencheng', '', '文成', '130.00000', '', '27.76900', '120.01500', '325300'), ('101210704', '2107', '0', 'pingyang', '', '平阳', '11.00000', '', '27.64700', '120.37100', '325400'), ('101210705', '2107', '0', 'ruian', '', '瑞安', '37.00000', '', '27.47000', '120.37000', '325200'), ('101210706', '2107', '0', 'dongtou', '', '洞头', '69.00000', '', '27.84300', '121.13900', '325700'), ('101210707', '2107', '0', 'yueqing', '', '乐清', '8.00000', '', '28.07000', '120.58000', '325600'), ('101210708', '2107', '0', 'yongjia', '', '永嘉', '35.00000', '', '28.29300', '120.65300', '325100'), ('101210709', '2107', '0', 'cangnan', '', '苍南', '11.00000', '', '27.64700', '120.37100', '325800'), ('101210801', '2108', '1', 'lishui', 'lishui', '丽水', '62.00000', '', '28.45200', '119.90900', '323000'), ('101210802', '2108', '0', 'suichang', '', '遂昌', '239.00000', '', '28.51400', '119.09700', '323300'), ('101210803', '2108', '0', 'longquan', '', '龙泉', '196.00000', '', '28.03800', '119.06600', '323700'), ('101210804', '2108', '0', 'jinyun', '', '缙云', '179.00000', '', '28.67700', '120.15400', '321401'), ('101210805', '2108', '0', 'qingtian', '', '青田', '59.00000', '', '28.20700', '120.11600', '323900'), ('101210806', '2108', '0', 'yunhe', '', '云和', '160.00000', '', '28.10700', '119.54900', '323600'), ('101210807', '2108', '0', 'qingyuan2', '', '庆元', '372.00000', '', '27.37000', '119.04000', '323800'), ('101210808', '2108', '0', 'songyang', '', '松阳', '195.00000', '', '28.44900', '119.48200', '323400'), ('101210809', '2108', '0', 'jingning1', '', '景宁', '160.00000', '', '28.10700', '119.54900', '323500'), ('101210901', '2109', '1', 'jinhua', 'jinhua', '金华', '65.00000', '', '29.10700', '119.64900', '321000'), ('101210902', '2109', '0', 'pujiang', '', '浦江', '85.00000', '', '29.28000', '119.53000', '322200'), ('101210903', '2109', '0', 'lanxi1', '', '兰溪', '48.00000', '', '29.13000', '119.28000', '321100'), ('101210904', '2109', '0', 'yiwu1', 'yiwu', '义乌', '79.00000', '', '29.29200', '120.04300', '322000'), ('101210905', '2109', '0', 'dongyang', '', '东阳', '92.00000', '', '29.23000', '120.40000', '322100'), ('101210906', '2109', '0', 'wuyi1', '', '武义', '104.00000', '', '28.53000', '119.48000', '321200'), ('101210907', '2109', '0', 'yongkang', '', '永康', '99.00000', '', '28.93100', '120.11300', '321300'), ('101210908', '2109', '0', 'panan', '', '磐安', '195.00000', '', '29.05400', '120.45000', '322300'), ('101211001', '2110', '1', 'quzhou1', 'quzhou', '衢州', '83.00000', '', '28.95600', '118.86800', '324000'), ('101211002', '2110', '0', 'changshan', '', '常山', '134.00000', '', '28.99600', '118.50300', '324200'), ('101211003', '2110', '0', 'kaihua', '', '开化', '154.00000', '', '29.20300', '118.32600', '324300'), ('101211004', '2110', '0', 'longyou', '', '龙游', '66.00000', '', '29.00900', '119.19300', '324400'), ('101211005', '2110', '0', 'jiangshan', '', '江山', '95.00000', '', '28.56900', '118.59500', '324100'), ('101211006', '2110', '0', 'qujiang1', '', '衢江', '66.00000', '', '28.98100', '118.93300', ''), ('101211101', '2111', '1', 'zhoushan', 'zhoushan', '舟山', '37.00000', '', '30.04400', '122.16200', '316000'), ('101211102', '2111', '0', 'shengsi', '', '嵊泗', '81.00000', '', '30.71900', '122.52200', '202450'), ('101211104', '2111', '0', 'daishan', '', '岱山', '9.00000', '', '30.28500', '122.15800', '316200'), ('101211105', '2111', '0', 'putuo', '', '普陀', '83.00000', '', '29.57000', '122.18000', '316100'), ('101211106', '2111', '0', 'dinghai', '', '定海', '37.00000', '', '30.04400', '122.16200', '316000'), ('101220101', '2201', '1', 'hefei', 'hefei', '合肥', '37.00000', '', '31.86100', '117.27500', '230000'), ('101220102', '2201', '0', 'changfeng', '', '长丰', '28.00000', '', '32.27300', '117.14700', '231100'), ('101220103', '2201', '0', 'feidong', '', '肥东', '25.00000', '', '31.92300', '117.59800', '231600'), ('101220104', '2201', '0', 'feixi', '', '肥西', '22.00000', '', '31.75700', '117.06100', '231200'), ('101220201', '2202', '1', 'bengbu', 'bengpu', '蚌埠', '29.00000', '', '32.94400', '117.37300', '233000'), ('101220202', '2202', '0', 'huaiyuan', '', '怀远', '19.00000', '', '33.01500', '117.03500', '233400'), ('101220203', '2202', '0', 'guzhen', '', '固镇', '19.00000', '', '33.25300', '117.32200', '233700'), ('101220204', '2202', '0', 'wuhe', '', '五河', '16.00000', '', '33.13000', '117.74900', '233300'), ('101220301', '2203', '1', 'wuhu', 'wuhu', '芜湖', '15.00000', '', '31.34100', '118.36100', '241000'), ('101220302', '2203', '0', 'fanchang', '', '繁昌', '27.00000', '', '31.05000', '118.11000', '241200'), ('101220303', '2203', '0', 'wuhuxian', '', '芜湖县', '20.00000', '', '31.09000', '118.35000', '241100'), ('101220304', '2203', '0', 'nanling', '', '南陵', '13.00000', '', '30.91100', '118.23400', '242400'), ('101220401', '2204', '1', 'huainan', 'huainan', '淮南', '33.00000', '', '32.66200', '117.02000', '232000'), ('101220402', '2204', '0', 'fengtai1', '', '凤台', '22.00000', '', '32.78400', '116.57200', '232100'), ('101220403', '2204', '0', 'panji', '', '潘集', '23.00000', '', '32.80000', '116.80000', ''), ('101220501', '2205', '1', 'maanshan', 'maanshan', '马鞍山', '23.00000', '', '31.70900', '118.35600', '243000'), ('101220502', '2205', '0', 'dangtu', '', '当涂', '9.00000', '', '31.49200', '118.61500', '243100'), ('101220601', '2206', '1', 'anqing', 'anqing', '安庆', '20.00000', '', '30.49800', '117.04700', '246000'), ('101220602', '2206', '0', 'zongyang', '', '枞阳', '39.00000', '', '30.43000', '117.13000', '246700'), ('101220603', '2206', '0', 'taihu', '', '太湖', '71.00000', '', '30.45500', '116.12200', '246400'), ('101220604', '2206', '0', 'qianshan', '', '潜山', '35.00000', '', '30.76400', '116.50200', '246300'), ('101220605', '2206', '0', 'huaining', '', '怀宁', '15.00000', '', '30.58900', '116.76500', '246100'), ('101220606', '2206', '0', 'susong', '', '宿松', '55.00000', '', '30.10700', '116.23000', '246500'), ('101220607', '2206', '0', 'wangjiang', '', '望江', '26.00000', '', '30.23700', '116.68000', '246200'), ('101220608', '2206', '0', 'yuexi', '', '岳西', '434.00000', '', '30.52000', '116.22000', '246600'), ('101220609', '2206', '0', 'tongcheng1', '', '桐城', '82.00000', '', '31.04000', '116.57000', '231400'), ('101220701', '2207', '1', 'suzhou1', 'suzhoushi', '宿州', '27.00000', '', '33.62900', '117.00200', '234000'), ('101220702', '2207', '0', 'dangshan', '', '砀山', '48.00000', '', '34.46300', '116.39600', '235300'), ('101220703', '2207', '0', 'lingbi', '', '灵璧', '24.00000', '', '33.69400', '117.51400', '234200'), ('101220704', '2207', '0', 'sixian', '', '泗县', '20.00000', '', '33.28000', '117.52000', '234300'), ('101220705', '2207', '0', 'xiaoxian', '', '萧县', '35.00000', '', '34.11000', '116.58000', '235200'), ('101220801', '2208', '1', 'fuyang1', 'fuyang', '阜阳', '38.00000', '', '32.91000', '115.81600', '236000'), ('101220802', '2208', '0', 'funan', '', '阜南', '32.00000', '', '32.65900', '115.61100', '236300'), ('101220803', '2208', '0', 'yingshang', '', '颍上', '25.00000', '', '32.66300', '116.26900', '236200'), ('101220804', '2208', '0', 'linquan', '', '临泉', '36.00000', '', '32.87400', '115.19500', '236400'), ('101220805', '2208', '0', 'jieshou', '', '界首', '38.00000', '', '33.26700', '115.38200', '236500'), ('101220806', '2208', '0', 'taihe', '', '太和', '33.00000', '', '33.10000', '115.43000', '236600'), ('101220901', '2209', '1', 'bozhou2', 'bozhou', '亳州', '42.00000', '', '33.87400', '115.76600', '236800'), ('101220902', '2209', '0', 'guoyang', '', '涡阳', '30.00000', '', '33.30000', '116.12000', '233600'), ('101220903', '2209', '0', 'lixin', '', '利辛', '28.00000', '', '33.12400', '116.13900', '236700'), ('101220904', '2209', '0', 'mengcheng', '', '蒙城', '27.00000', '', '33.20700', '116.54100', '233500'), ('101221001', '2210', '1', 'huangshan', 'huangshan', '黄山', '1835.00000', '', '30.10000', '118.16700', '245000'), ('101221002', '2210', '0', 'huangshanqu', '', '黄山区', '193.00000', '', '30.18000', '118.08000', '245000'), ('101221003', '2210', '0', 'tunxi', '', '屯溪', '142.00000', '', '29.43000', '118.17000', '245000'), ('101221004', '2210', '0', 'qimen', '', '祁门', '140.00000', '', '29.85200', '117.57500', '245600'), ('101221005', '2210', '0', 'yixian2', '', '黟县', '228.00000', '', '29.56000', '117.56000', '245500'), ('101221006', '2210', '0', 'shexian2', '', '歙县', '169.00000', '', '29.52000', '118.26000', '245200'), ('101221007', '2210', '0', 'xiuning', '', '休宁', '171.00000', '', '29.47000', '118.11000', '245400'), ('101221008', '2210', '0', 'huangshanfengjingqu', '', '黄山风景区', '142.00000', '', '29.43000', '118.17000', '245000'), ('101221101', '2211', '1', 'chuzhou1', 'chuzhou', '滁州', '33.00000', '', '32.31400', '118.30500', '239000'), ('101221102', '2211', '0', 'fengyang', '', '凤阳', '27.00000', '', '32.83400', '117.54700', '233100'), ('101221103', '2211', '0', 'mingguang', '', '明光', '35.00000', '', '32.47000', '117.59000', '239400'), ('101221104', '2211', '0', 'dingyuan', '', '定远', '72.00000', '', '32.45500', '117.64500', '233200'), ('101221105', '2211', '0', 'quanjiao', '', '全椒', '32.00000', '', '32.04600', '118.11000', '239500'), ('101221106', '2211', '0', 'laian', '', '来安', '40.00000', '', '32.27000', '118.25000', '239200'), ('101221107', '2211', '0', 'tianchang', '', '天长', '21.00000', '', '32.70800', '118.94100', '239300'), ('101221201', '2212', '1', 'huaibei', 'huaibei', '淮北', '34.00000', '', '33.98100', '116.85800', '235000'), ('101221202', '2212', '0', 'suixi', '', '濉溪', '32.00000', '', '33.56000', '116.47000', '235100'), ('101221301', '2213', '1', 'tongling', 'tongling', '铜陵', '38.00000', '', '30.94800', '117.78100', '244000'), ('101221401', '2214', '1', 'xuancheng', 'xuancheng', '宣城', '31.00000', '', '30.94200', '118.74700', '242000'), ('101221402', '2214', '0', 'jingxian1', '', '泾县', '36.00000', '', '30.41000', '118.24000', '242500'), ('101221403', '2214', '0', 'jingde', '', '旌德', '220.00000', '', '30.30800', '118.49600', '242600'), ('101221404', '2214', '0', 'ningguo', '', '宁国', '92.00000', '', '30.53400', '119.01200', '242300'), ('101221405', '2214', '0', 'jixi1', '', '绩溪', '191.00000', '', '30.05000', '118.35000', '245300'), ('101221406', '2214', '0', 'guangde', '', '广德', '49.00000', '', '30.90100', '119.34900', '242200'), ('101221407', '2214', '0', 'langxi', '', '郎溪', '12.00000', '', '31.06000', '119.18400', '242100'), ('101221501', '2215', '1', 'luan', 'liuan', '六安', '60.00000', '', '31.74100', '116.48300', '237000'), ('101221502', '2215', '0', 'huoqiu', '', '霍邱', '33.00000', '', '32.17800', '116.18800', '237400'), ('101221503', '2215', '0', 'shouxian', '', '寿县', '24.00000', '', '32.33000', '116.47000', '232200'), ('101221505', '2215', '0', 'jinzhai', '', '金寨', '95.00000', '', '31.46300', '115.77500', '237300'), ('101221506', '2215', '0', 'huoshan', '', '霍山', '73.00000', '', '31.28000', '116.20900', '237200'), ('101221507', '2215', '0', 'shucheng', '', '舒城', '22.00000', '', '31.29200', '116.82900', '231300'), ('101221601', '2216', '1', 'chaohu', 'chaohushi', '巢湖', '0.00000', '', '0.00000', '0.00000', ''), ('101221602', '2216', '0', 'lujiang', '', '庐江', '0.00000', '', '0.00000', '0.00000', ''), ('101221603', '2216', '0', 'wuwei1', '', '无为', '0.00000', '', '0.00000', '0.00000', ''), ('101221604', '2216', '0', 'hanshan', '', '含山', '0.00000', '', '0.00000', '0.00000', ''), ('101221605', '2216', '0', 'hexian', '', '和县', '0.00000', '', '0.00000', '0.00000', ''), ('101221701', '2217', '1', 'chizhou', 'chizhou', '池州', '35.00000', '', '30.64800', '117.48500', '247100'), ('101221702', '2217', '0', 'dongzhi', '', '东至', '18.00000', '', '30.03200', '116.97200', '247200'), ('101221703', '2217', '0', 'qingyang1', '', '青阳', '31.00000', '', '30.38000', '117.52000', '242800'), ('101221704', '2217', '0', 'jiuhuashan', '', '九华山', '647.00000', '', '30.29000', '117.47000', '242811'), ('101221705', '2217', '0', 'shitai', '', '石台', '65.00000', '', '30.19600', '117.59400', '245100'), ('101230101', '2301', '1', 'fuzhou', 'fuzhou', '福州', '85.00000', '', '26.07100', '119.30300', '350000'), ('101230102', '2301', '0', 'minqing', '', '闽清', '40.00000', '', '26.23700', '118.76200', '350800'), ('101230103', '2301', '0', 'minhou', '', '闽侯', '50.00000', '', '26.19400', '119.14200', '350100'), ('101230104', '2301', '0', 'luoyuan', '', '罗源', '57.00000', '', '26.51500', '119.47400', '350600'), ('101230105', '2301', '0', 'lianjiang', '', '连江', '7.00000', '', '26.12000', '119.32000', '350500'), ('101230107', '2301', '0', 'yongtai', '', '永泰', '87.00000', '', '25.85900', '118.79700', '350700'), ('101230108', '2301', '0', 'pingtan', '', '平潭', '31.00000', '', '25.53000', '119.77700', '350400'), ('101230110', '2301', '0', 'changle1', '', '长乐', '8.00000', '', '25.96300', '119.52300', '350200'), ('101230111', '2301', '0', 'fuqing', '', '福清', '39.00000', '', '25.58900', '119.36200', '350300'), ('101230201', '2302', '1', 'xiamen', 'xiamen', '厦门', '138.00000', '', '24.44500', '118.07000', '361000'), ('101230202', '2302', '0', 'tongan', '', '同安', '29.00000', '', '24.43000', '118.08000', '361100'), ('101230301', '2303', '1', 'ningde', '', '宁德', '33.00000', '', '26.68300', '119.53300', '352000'), ('101230302', '2303', '0', 'gutian', '', '古田', '363.00000', '', '26.58400', '118.96800', '352200'), ('101230303', '2303', '0', 'xiapu', '', '霞浦', '13.00000', '', '26.53000', '120.00000', '355100'), ('101230304', '2303', '0', 'shouning', '', '寿宁', '815.00000', '', '27.43000', '119.47300', '355500'), ('101230305', '2303', '0', 'zhouning', '', '周宁', '900.00000', '', '27.10200', '119.30500', '355400'), ('101230306', '2303', '0', 'fuan', '', '福安', '46.00000', '', '27.06000', '119.39000', '355000'), ('101230307', '2303', '0', 'zherong', '', '柘荣', '670.00000', '', '27.20900', '119.89700', '355300'), ('101230308', '2303', '0', 'fuding', '', '福鼎', '38.00000', '', '27.20900', '120.39700', '355200'), ('101230309', '2303', '0', 'pingnan', '', '屏南', '871.00000', '', '26.95100', '118.95500', '352300'), ('101230401', '2304', '1', 'putian', 'putian', '莆田', '85.00000', '', '25.45100', '119.02200', '351100'), ('101230402', '2304', '0', 'xianyou', '', '仙游', '77.00000', '', '25.22000', '118.42000', '351200'), ('101230403', '2304', '0', 'xiuyugang', '', '秀屿港', '23.00000', '', '25.14000', '118.59000', '351156'), ('101230404', '2304', '0', 'hanjiang', '', '涵江', '9.00000', '', '25.50000', '119.06000', '351100'), ('101230405', '2304', '0', 'xiuyu', '', '秀屿', '21.00000', '', '25.30000', '119.05000', '351100'), ('101230406', '2304', '0', 'licheng1', '', '荔城', '11.00000', '', '25.30000', '119.00000', '351100'), ('101230407', '2304', '0', 'chengxiang', '', '城厢', '13.00000', '', '25.30000', '118.90000', '351100'), ('101230501', '2305', '1', 'quanzhou', 'quanzhou', '泉州', '55.00000', '', '24.91400', '118.58300', '362000'), ('101230502', '2305', '0', 'anxi', '', '安溪', '67.00000', '', '25.07000', '118.15000', '362400'), ('101230504', '2305', '0', 'yongchun', '', '永春', '170.00000', '', '25.38000', '118.10100', '362600'), ('101230505', '2305', '0', 'dehua', '', '德化', '517.00000', '', '25.66700', '118.23800', '362500'), ('101230506', '2305', '0', 'nanan', '', '南安', '45.00000', '', '24.58000', '118.22000', '362300'), ('101230507', '2305', '0', 'chongwu', '', '崇武', '22.00000', '', '24.54000', '118.55000', '362131'), ('101230508', '2305', '0', 'huian', '', '惠安', '25.00000', '', '25.02200', '118.80300', '362100'), ('101230509', '2305', '0', 'jinjiang', '', '晋江', '55.00000', '', '24.91400', '118.58300', '362200'), ('101230510', '2305', '0', 'shishi', '', '石狮', '30.00000', '', '24.73600', '118.63200', '362700'), ('101230601', '2306', '1', 'zhangzhou', 'zhangzhou', '漳州', '29.00000', '', '24.51700', '117.65500', '363000'), ('101230602', '2306', '0', 'changtai', '', '长泰', '42.00000', '', '24.72800', '117.78400', '363900'), ('101230603', '2306', '0', 'nanjing2', '', '南靖', '31.00000', '', '24.31000', '117.22000', '363600'), ('101230604', '2306', '0', 'pinghe', '', '平和', '42.00000', '', '24.31000', '117.20400', '363700'), ('101230605', '2306', '0', 'longhai', '', '龙海', '8.00000', '', '24.40000', '117.81600', '363100'), ('101230606', '2306', '0', 'zhangpu', '', '漳浦', '54.00000', '', '24.02800', '117.81500', '363200'), ('101230607', '2306', '0', 'zhaoan', '', '诏安', '28.00000', '', '23.46000', '117.08000', '363500'), ('101230608', '2306', '0', 'dongshan', '', '东山', '54.00000', '', '23.67500', '117.42400', '363400'), ('101230609', '2306', '0', 'yunxiao', '', '云霄', '20.00000', '', '23.99200', '117.31800', '363300'), ('101230610', '2306', '0', 'huaan', '', '华安', '161.00000', '', '25.01000', '117.32000', '363800'), ('101230701', '2307', '1', 'longyan', 'longyan', '龙岩', '357.00000', '', '25.09500', '117.02500', '364000'), ('101230702', '2307', '0', 'changting', '', '长汀', '311.00000', '', '25.67400', '116.34100', '366300'), ('101230703', '2307', '0', 'liancheng', '', '连城', '382.00000', '', '25.58000', '116.85300', '366200'), ('101230704', '2307', '0', 'wuping', '', '武平', '267.00000', '', '25.14300', '116.11700', '364300'), ('101230705', '2307', '0', 'shanghang', '', '上杭', '200.00000', '', '25.10800', '116.60300', '364200'), ('101230706', '2307', '0', 'yongding', '', '永定', '222.00000', '', '24.73100', '116.74400', '364100'), ('101230707', '2307', '0', 'zhangping', '', '漳平', '203.00000', '', '25.34700', '117.45500', '364400'), ('101230801', '2308', '1', 'sanming', 'sanming', '三明', '213.00000', '', '26.23600', '117.60100', '365000'), ('101230802', '2308', '0', 'ninghua', '', '宁化', '359.00000', '', '26.31700', '116.71100', '365400'), ('101230803', '2308', '0', 'qingliu', '', '清流', '310.00000', '', '26.07500', '116.90800', '365300'), ('101230804', '2308', '0', 'taining', '', '泰宁', '345.00000', '', '26.84400', '117.14500', '354400'), ('101230805', '2308', '0', 'jiangle', '', '将乐', '175.00000', '', '26.74700', '117.37500', '353300'), ('101230806', '2308', '0', 'jianning', '', '建宁', '342.00000', '', '26.82500', '116.78400', '354500'), ('101230807', '2308', '0', 'mingxi', '', '明溪', '360.00000', '', '26.39700', '117.18700', '365200'), ('101230808', '2308', '0', 'shaxian1', '', '沙县', '120.00000', '', '26.24000', '117.48000', '365500'), ('101230809', '2308', '0', 'youxi', '', '尤溪', '135.00000', '', '26.14200', '118.22600', '365100'), ('101230810', '2308', '0', 'yongan', '', '永安', '206.00000', '', '25.58000', '117.21000', '366000'), ('101230811', '2308', '0', 'datian', '', '大田', '401.00000', '', '25.82000', '117.76600', '366100'), ('101230901', '2309', '1', 'nanping', 'nanping', '南平', '127.00000', '', '26.63700', '118.16900', '353000'), ('101230902', '2309', '0', 'shunchang', '', '顺昌', '174.00000', '', '26.91500', '117.86700', '353200'), ('101230903', '2309', '0', 'guangze', '', '光泽', '264.00000', '', '27.64500', '117.34000', '354100'), ('101230904', '2309', '0', 'shaowu', '', '邵武', '219.00000', '', '27.26000', '117.43100', '354000'), ('101230905', '2309', '0', 'wuyishan', '', '武夷山', '220.00000', '', '27.46000', '118.02000', '354300'), ('101230906', '2309', '0', 'pucheng1', '', '浦城', '277.00000', '', '27.55000', '118.32000', '353400'), ('101230907', '2309', '0', 'jianyang', '', '建阳', '196.00000', '', '27.20000', '118.07000', '354200'), ('101230908', '2309', '0', 'songxi', '', '松溪', '201.00000', '', '27.63500', '118.73000', '353500'), ('101230909', '2309', '0', 'zhenghe', '', '政和', '221.00000', '', '27.29300', '118.90500', '353600'), ('101230910', '2309', '0', 'jianou', '', '建瓯', '156.00000', '', '27.03000', '118.19000', '353100'), ('101231001', '2310', '1', 'diaoyudao', '', '钓鱼岛', '362.00000', '', '25.73000', '123.46000', ''), ('101240101', '2401', '1', 'nanchang', 'nanchang', '南昌', '46.00000', '', '28.67100', '115.88900', '330000'), ('101240102', '2401', '0', 'xinjian', '', '新建', '37.00000', '', '28.42000', '115.50000', '330100'), ('101240103', '2401', '0', 'nanchangxian', '', '南昌县', '29.00000', '', '28.33000', '115.57000', '330200'), ('101240104', '2401', '0', 'anyi', '', '安义', '39.00000', '', '28.80300', '115.60300', '330500'), ('101240105', '2401', '0', 'jinxian', '', '进贤', '31.00000', '', '28.46600', '116.28500', '331700'), ('101240106', '2401', '0', 'donghuqu', '', '莲塘', '0.00000', '', '0.00000', '0.00000', ''), ('101240201', '2402', '1', 'jiujiang', 'jiujiang', '九江', '37.00000', '', '29.72200', '115.99100', '332000'), ('101240202', '2402', '0', 'ruichang', '', '瑞昌', '26.00000', '', '29.62300', '115.41300', '332200'), ('101240203', '2402', '0', 'lushan1', '', '庐山', '1165.00000', '', '29.35000', '115.59000', '332900'), ('101240204', '2402', '0', 'wuning', '', '武宁', '80.00000', '', '29.22900', '114.95800', '332300'), ('101240205', '2402', '0', 'dean', '', '德安', '43.00000', '', '29.20000', '115.46000', '330400'), ('101240206', '2402', '0', 'yongxiu', '', '永修', '36.00000', '', '29.13500', '115.82100', '330300'), ('101240207', '2402', '0', 'hukou', '', '湖口', '41.00000', '', '29.68200', '116.26900', '332500'), ('101240208', '2402', '0', 'pengze', '', '彭泽', '64.00000', '', '29.82700', '116.62800', '332700'), ('101240209', '2402', '0', 'xingzi', '', '星子', '36.00000', '', '29.27000', '116.03000', '332800'), ('101240210', '2402', '0', 'duchang', '', '都昌', '43.00000', '', '29.34500', '116.30700', '332600'), ('101240212', '2402', '0', 'xiushui', '', '修水', '147.00000', '', '29.02000', '114.35000', '332400'), ('101240213', '2402', '0', 'gongqingcheng', '', '澎泽', '0.00000', '', '0.00000', '0.00000', ''), ('101240301', '2403', '1', 'shangrao', 'shangrao', '上饶', '115.00000', '', '28.45100', '117.95600', '334000'), ('101240302', '2403', '0', 'poyang', '', '鄱阳', '41.00000', '', '29.24200', '116.74100', '333100'), ('101240303', '2403', '0', 'wuyuan1', '', '婺源', '82.00000', '', '29.16000', '117.51000', '333200'), ('101240305', '2403', '0', 'yugan', '', '余干', '22.00000', '', '28.70000', '116.56800', '335100'), ('101240306', '2403', '0', 'wannian', '', '万年', '56.00000', '', '28.70800', '117.01600', '335500'), ('101240307', '2403', '0', 'dexing', '', '德兴', '88.00000', '', '28.96400', '117.73800', '334200'), ('101240308', '2403', '0', 'shangraoxian', '', '上饶县', '85.00000', '', '28.28000', '117.55000', '334100'), ('101240309', '2403', '0', 'yiyang2', '', '弋阳', '65.00000', '', '28.24000', '117.26000', '334400'), ('101240310', '2403', '0', 'hengfeng', '', '横峰', '79.00000', '', '28.51500', '117.61300', '334300'), ('101240311', '2403', '0', 'yanshan2', '', '铅山', '58.00000', '', '30.76400', '116.50200', '334500'), ('101240312', '2403', '0', 'yushan', '', '玉山', '114.00000', '', '28.74800', '118.14700', '334700'), ('101240313', '2403', '0', 'guangfeng', '', '广丰', '96.00000', '', '28.34300', '118.25300', '334600'), ('101240401', '2404', '1', 'fuzhou1', 'fuzhoushi', '抚州', '47.00000', '', '26.18000', '119.36200', '344000'), ('101240402', '2404', '0', 'guangchang', '', '广昌', '145.00000', '', '26.73700', '116.33900', '344900'), ('101240403', '2404', '0', 'lean', '', '乐安', '180.00000', '', '27.26000', '115.50000', '344300'), ('101240404', '2404', '0', 'chongren', '', '崇仁', '76.00000', '', '27.68000', '116.03800', '344200'), ('101240405', '2404', '0', 'jinxi', '', '金溪', '126.00000', '', '27.55000', '116.47000', '344800'), ('101240406', '2404', '0', 'zixi', '', '资溪', '221.00000', '', '27.69900', '117.03800', '335300'), ('101240407', '2404', '0', 'yihuang', '', '宜黄', '88.00000', '', '27.38200', '116.24700', '344400'), ('101240408', '2404', '0', 'nancheng', '', '南城', '82.00000', '', '27.53500', '116.67500', '344700'), ('101240409', '2404', '0', 'nanfeng', '', '南丰', '107.00000', '', '27.10600', '116.45100', '344500'), ('101240410', '2404', '0', 'lichuan1', '', '黎川', '131.00000', '', '27.18000', '116.56000', '344600'), ('101240411', '2404', '0', 'dongxiang1', '', '东乡', '51.00000', '', '28.27100', '116.59900', '331800'), ('101240501', '2405', '1', 'yichun1', 'yichun', '宜春', '132.00000', '', '27.79300', '114.37100', '336000'), ('101240502', '2405', '0', 'tonggu', '', '铜鼓', '256.00000', '', '28.60600', '114.40500', '336200'), ('101240503', '2405', '0', 'yifeng', '', '宜丰', '91.00000', '', '28.45500', '114.76300', '336300'), ('101240504', '2405', '0', 'wanzai', '', '万载', '100.00000', '', '28.23200', '114.29300', '336100'), ('101240505', '2405', '0', 'shanggao', '', '上高', '67.00000', '', '28.23200', '114.81800', '336400'), ('101240506', '2405', '0', 'jingan', '', '靖安', '81.00000', '', '28.52000', '115.22000', '330600'), ('101240507', '2405', '0', 'fengxin', '', '奉新', '54.00000', '', '28.71600', '115.14100', '330700'), ('101240508', '2405', '0', 'gaoan', '', '高安', '46.00000', '', '28.25000', '115.23000', '330800'), ('101240509', '2405', '0', 'zhangshu', '', '樟树', '31.00000', '', '27.99100', '115.40200', '331200'), ('101240510', '2405', '0', 'fengcheng1', '', '丰城', '30.00000', '', '28.07300', '115.78900', '331100'), ('101240601', '2406', '1', 'jian1', 'jian', '吉安', '70.00000', '', '27.14100', '114.95800', '343100'), ('101240602', '2406', '0', 'jianxian', '', '吉安县', '70.00000', '', '27.14100', '114.95800', '343100'), ('101240603', '2406', '0', 'jishui', '', '吉水', '63.00000', '', '27.19300', '115.24200', '331600'), ('101240604', '2406', '0', 'xingan', '', '新干', '48.00000', '', '27.46000', '115.24000', '331300'), ('101240605', '2406', '0', 'xiajiang', '', '峡江', '50.00000', '', '27.34000', '115.10000', '331400'), ('101240606', '2406', '0', 'yongfeng', '', '永丰', '88.00000', '', '27.08700', '115.59800', '331500'), ('101240607', '2406', '0', 'yongxin', '', '永新', '145.00000', '', '26.98000', '114.15500', '343400'), ('101240608', '2406', '0', 'jinggangshan', '', '井冈山', '838.00000', '', '26.58600', '114.20600', '343600'), ('101240609', '2406', '0', 'wanan', '', '万安', '97.00000', '', '26.28000', '114.40000', '343800'), ('101240610', '2406', '0', 'suichuan', '', '遂川', '125.00000', '', '26.32500', '114.51400', '343900'), ('101240611', '2406', '0', 'taihe1', '', '泰和', '65.00000', '', '26.48000', '114.55000', '343700'), ('101240612', '2406', '0', 'anfu', '', '安福', '86.00000', '', '27.34100', '114.39900', '343200'), ('101240613', '2406', '0', 'longshi', '', '宁冈', '259.00000', '', '26.69600', '114.01200', '343500'), ('101240701', '2407', '1', 'ganzhou', 'ganzhou', '赣州', '125.00000', '', '25.83200', '114.91600', '341000'), ('101240702', '2407', '0', 'chongyi', '', '崇义', '252.00000', '', '25.65100', '114.26300', '341300'), ('101240703', '2407', '0', 'shangyou', '', '上犹', '141.00000', '', '25.92900', '114.33300', '341200'), ('101240704', '2407', '0', 'nankang', '', '南康', '129.00000', '', '25.85500', '114.70100', '341400'), ('101240705', '2407', '0', 'dayu', '', '大余', '210.00000', '', '25.43600', '114.34800', '341500'), ('101240706', '2407', '0', 'xinfeng', '', '信丰', '164.00000', '', '25.24000', '114.56000', '341600'), ('101240707', '2407', '0', 'ningdu', '', '宁都', '207.00000', '', '26.61800', '115.98000', '342800'), ('101240708', '2407', '0', 'shicheng', '', '石城', '231.00000', '', '26.28300', '116.36500', '342700'), ('101240709', '2407', '0', 'ruijin', '', '瑞金', '194.00000', '', '25.92100', '116.01300', '342500'), ('101240710', '2407', '0', 'yudu', '', '于都', '137.00000', '', '25.94900', '115.50300', '342300'), ('101240711', '2407', '0', 'huichang', '', '会昌', '168.00000', '', '25.52700', '115.75200', '342600'), ('101240712', '2407', '0', 'anyuan', '', '安远', '298.00000', '', '25.24100', '115.39100', '342100'), ('101240713', '2407', '0', 'quannan', '', '全南', '257.00000', '', '24.84800', '114.51500', '341800'), ('101240714', '2407', '0', 'longnan', '', '龙南', '207.00000', '', '24.74900', '114.67900', '341700'), ('101240715', '2407', '0', 'dingnan', '', '定南', '252.00000', '', '24.80800', '115.08900', '341900'), ('101240716', '2407', '0', 'xunwu', '', '寻乌', '303.00000', '', '24.57000', '115.39000', '342200'), ('101240717', '2407', '0', 'xingguo', '', '兴国', '150.00000', '', '26.21000', '115.21000', '342400'), ('101240718', '2407', '0', 'ganxian', '', '赣县', '157.00000', '', '25.86000', '115.00200', ''), ('101240801', '2408', '1', 'jingdezhen', 'jingdezhen', '景德镇', '63.00000', '', '29.29300', '117.20300', '333000'), ('101240802', '2408', '0', 'leping', '', '乐平', '38.00000', '', '29.02800', '117.25500', '333300'), ('101240803', '2408', '0', 'fuliang', '', '浮梁', '95.00000', '', '29.37800', '117.23700', ''), ('101240901', '2409', '1', 'pingxiang1', 'pingxiang', '萍乡', '110.00000', '', '27.63300', '113.83700', '337000'), ('101240902', '2409', '0', 'lianhua', '', '莲花', '181.00000', '', '27.21600', '113.95600', '337100'), ('101240903', '2409', '0', 'shangli', '', '上栗', '99.00000', '', '27.87700', '113.79400', ''), ('101240904', '2409', '0', 'anyuan1', '', '安源', '126.00000', '', '23.60000', '113.80000', ''), ('101240905', '2409', '0', 'luxi3', '', '芦溪', '156.00000', '', '27.63700', '114.03400', ''), ('101240906', '2409', '0', 'xiangdong', '', '湘东', '120.00000', '', '27.65400', '113.73700', ''), ('101241001', '2410', '1', 'xinyu', 'xinyu', '新余', '79.00000', '', '27.80400', '114.92400', '336500'), ('101241002', '2410', '0', 'fenyi', '', '分宜', '93.00000', '', '27.82500', '114.67900', '336600'), ('101241101', '2411', '1', 'yingtan', 'yingtan', '鹰潭', '65.00000', '', '28.23800', '117.03400', '335000'), ('101241102', '2411', '0', 'yujiang', '', '余江', '44.00000', '', '28.34400', '116.91500', '335200'), ('101241103', '2411', '0', 'guixi', '', '贵溪', '52.00000', '', '28.24300', '117.19100', '335400'), ('101250101', '2501', '1', 'changsha', 'changsha', '长沙', '66.00000', '', '28.19700', '112.96700', '410000'), ('101250102', '2501', '0', 'ningxiang', '', '宁乡', '73.00000', '', '28.18600', '112.33400', '410600'), ('101250103', '2501', '0', 'liuyang', '', '浏阳', '98.00000', '', '28.21100', '113.71700', '410300'), ('101250104', '2501', '0', 'mapoling', '', '马坡岭', '46.00000', '', '28.12000', '113.05000', '410125'), ('101250105', '2501', '0', 'wangcheng', '', '望城', '43.00000', '', '28.37700', '112.80700', '410205'), ('101250201', '2502', '1', 'xiangtan', 'xiangtan', '湘潭', '64.00000', '', '27.86700', '112.90800', '411100'), ('101250202', '2502', '0', 'shaoshan', '', '韶山', '90.00000', '', '27.94000', '112.51800', '411300'), ('101250203', '2502', '0', 'xiangxiang', '', '湘乡', '85.00000', '', '27.45000', '112.30000', '411400'), ('101250301', '2503', '1', 'zhuzhou', 'zhuzhou', '株洲', '72.00000', '', '27.86300', '113.10900', '412003'), ('101250302', '2503', '0', 'youxian', '', '攸县', '101.00000', '', '27.00000', '113.21000', '412300'), ('101250303', '2503', '0', 'liling', '', '醴陵', '75.00000', '', '27.67400', '113.46400', '412200'), ('101250305', '2503', '0', 'chaling', '', '茶陵', '135.00000', '', '26.81700', '113.63600', '412400'), ('101250306', '2503', '0', 'yanling1', '', '炎陵', '227.00000', '', '26.49000', '113.77300', '412500'), ('101250401', '2504', '1', 'hengyang', 'hengyang', '衡阳', '103.00000', '', '26.90200', '112.61400', '421001'), ('101250402', '2504', '0', 'hengshan1', '', '衡山', '62.00000', '', '27.14000', '112.52000', '421300'), ('101250403', '2504', '0', 'hengdong', '', '衡东', '67.00000', '', '27.11400', '113.00800', '421400'), ('101250404', '2504', '0', 'qidong1', '', '祁东', '152.00000', '', '26.48000', '112.06000', '421600'), ('101250405', '2504', '0', 'hengyangxian', '', '衡阳县', '91.00000', '', '26.59000', '112.22000', '421200'), ('101250406', '2504', '0', 'changning', '', '常宁', '116.00000', '', '24.72000', '99.66200', '421500'), ('101250407', '2504', '0', 'hengnan', '', '衡南', '70.00000', '', '26.76800', '112.88900', '421101'), ('101250408', '2504', '0', 'leiyang', '', '耒阳', '83.00000', '', '26.41400', '112.92200', '421800'), ('101250409', '2504', '0', 'nanyue', '', '南岳', '1268.00000', '', '27.18000', '112.42000', '421900'), ('101250501', '2505', '1', 'chenzhou', 'zhuzhoushi', '郴州', '184.00000', '', '25.78300', '112.98700', '423000'), ('101250502', '2505', '0', 'guiyang', '', '桂阳', '329.00000', '', '25.45000', '112.43000', '424400'), ('101250503', '2505', '0', 'jiahe', '', '嘉禾', '213.00000', '', '25.61300', '112.41000', '424500'), ('101250504', '2505', '0', 'yizhang', '', '宜章', '223.00000', '', '25.29500', '112.79000', '424200'), ('101250505', '2505', '0', 'linwu', '', '临武', '292.00000', '', '25.35600', '112.56000', '424300'), ('101250507', '2505', '0', 'zixing', '', '资兴', '138.00000', '', '25.92700', '113.42200', '423400'), ('101250508', '2505', '0', 'rucheng', '', '汝城', '608.00000', '', '25.34000', '113.41000', '424100'), ('101250509', '2505', '0', 'anren', '', '安仁', '102.00000', '', '26.56300', '113.35300', '423600'), ('101250510', '2505', '0', 'yongxing', '', '永兴', '122.00000', '', '26.23600', '113.16000', '423300'), ('101250511', '2505', '0', 'guidong', '', '桂东', '834.00000', '', '25.97400', '113.92300', '423500'), ('101250512', '2505', '0', 'suxian', '', '苏仙', '167.00000', '', '25.83300', '113.05000', '423000'), ('101250601', '2506', '1', 'changde', 'changde', '常德', '35.00000', '', '29.04800', '111.69200', '415000'), ('101250602', '2506', '0', 'anxiang', '', '安乡', '38.00000', '', '29.45500', '112.14400', '415600'), ('101250603', '2506', '0', 'taoyuan', '', '桃源', '47.00000', '', '28.90300', '111.22500', '415700'), ('101250604', '2506', '0', 'hanshou', '', '汉寿', '32.00000', '', '28.87700', '112.00200', '415900'), ('101250605', '2506', '0', 'lixian2', '', '澧县', '40.00000', '', '29.39000', '111.45000', '415500'), ('101250606', '2506', '0', 'linli', '', '临澧', '51.00000', '', '29.53500', '111.63200', '415200'), ('101250607', '2506', '0', 'shimen', '', '石门', '119.00000', '', '29.70100', '111.01600', '415300'), ('101250608', '2506', '0', 'jinshi', 'tianjin', '津市', '51.00000', '', '29.62800', '111.88100', ''), ('101250700', '2507', '1', 'yiyang1', 'yiyang', '益阳', '46.00000', '', '28.34000', '112.23000', '413000'), ('101250701', '2507', '0', 'heshanqu', '', '赫山区', '46.00000', '', '28.34000', '112.23000', '413000'), ('101250702', '2507', '0', 'nanxian', '', '南县', '35.00000', '', '29.22000', '112.24000', '413200'), ('101250703', '2507', '0', 'taojiang', '', '桃江', '49.00000', '', '28.44800', '111.96200', '413400'), ('101250704', '2507', '0', 'anhua', '', '安化', '129.00000', '', '28.31100', '111.34600', '413500'), ('101250705', '2507', '0', 'yuanjiang', '', '沅江', '36.00000', '', '28.94800', '112.59700', '413100'), ('101250801', '2508', '1', 'loudi', 'loudi', '娄底', '151.00000', '', '27.75000', '111.98300', '417000'), ('101250802', '2508', '0', 'shuangfeng', '', '双峰', '100.00000', '', '27.45000', '112.17000', '417700'), ('101250803', '2508', '0', 'lengshuijiang', '', '冷水江', '248.00000', '', '27.67900', '111.46000', '417500'), ('101250805', '2508', '0', 'xinhua', '', '新化', '213.00000', '', '27.45000', '111.18000', '417600'), ('101250806', '2508', '0', 'lianyuan', '', '涟源', '165.00000', '', '27.68000', '110.70000', '417100'), ('101250901', '2509', '1', 'shaoyang', 'shaoyang', '邵阳', '248.00000', '', '26.99400', '111.25500', '422000'), ('101250902', '2509', '0', 'longhui', '', '隆回', '268.00000', '', '27.33300', '110.93200', '422200'), ('101250903', '2509', '0', 'dongkou', '', '洞口', '323.00000', '', '27.12000', '110.54100', '422300'), ('101250904', '2509', '0', 'xinshao', '', '新邵', '242.00000', '', '27.19000', '111.27000', '422900'), ('101250905', '2509', '0', 'shaodong', '', '邵东', '253.00000', '', '27.19700', '111.83100', '422800'), ('101250906', '2509', '0', 'suining', '', '绥宁', '307.00000', '', '26.35000', '110.09000', '422600'), ('101250907', '2509', '0', 'xinning', '', '新宁', '304.00000', '', '26.27000', '110.51000', '422700'), ('101250908', '2509', '0', 'wugang1', '', '武冈', '340.00000', '', '26.44000', '110.38000', '422400'), ('101250909', '2509', '0', 'chengbu', '', '城步', '476.00000', '', '26.22000', '110.91000', '422500'), ('101250910', '2509', '0', 'shaoyangxian', '', '邵阳县', '278.00000', '', '27.00000', '111.16000', '422100'), ('101251001', '2510', '1', 'yueyang', 'yueyang', '岳阳', '54.00000', '', '29.37800', '113.09500', '414000'), ('101251002', '2510', '0', 'huarong', '', '华容', '23.00000', '', '29.48800', '112.66800', '414200'), ('101251003', '2510', '0', 'xiangyin', '', '湘阴', '55.00000', '', '28.41000', '112.53000', '414600'), ('101251004', '2510', '0', 'miluo', '', '汨罗', '47.00000', '', '28.74600', '113.15600', '414400'), ('101251005', '2510', '0', 'pingjiang', '', '平江', '106.00000', '', '28.76600', '113.65900', '410400'), ('101251006', '2510', '0', 'linxiang', '', '临湘', '55.00000', '', '29.29000', '113.27000', '414300'), ('101251101', '2511', '1', 'zhangjiajie', 'zhangjiajie', '张家界', '185.00000', '', '29.13300', '110.48200', '427000'), ('101251102', '2511', '0', 'sangzhi', '', '桑植', '322.00000', '', '29.54100', '110.22800', '427100'), ('101251103', '2511', '0', 'cili', '', '慈利', '100.00000', '', '29.38200', '110.94500', '427200'), ('101251104', '2511', '0', 'wulingyuan', '', '武陵源', '321.00000', '', '29.35100', '110.56400', '427400'), ('101251201', '2512', '1', 'huaihua', '', '怀化', '262.00000', '', '27.55300', '109.94500', '418000'), ('101251203', '2512', '0', 'yuanling', '', '沅陵', '152.00000', '', '28.55200', '110.60600', '419600'), ('101251204', '2512', '0', 'chenxi', '', '辰溪', '141.00000', '', '27.90300', '110.21500', '419500'), ('101251205', '2512', '0', 'jingzhou1', '', '靖州', '321.00000', '', '26.34000', '109.40000', '418400'), ('101251206', '2512', '0', 'huitong', '', '会同', '281.00000', '', '26.90800', '109.78600', '418300'), ('101251207', '2512', '0', 'tongdao', '', '通道', '397.00000', '', '26.10000', '109.47000', '418500'), ('101251208', '2512', '0', 'mayang', '', '麻阳', '174.00000', '', '27.53000', '109.48000', '419400'), ('101251209', '2512', '0', 'xinhuang', '', '新晃', '356.00000', '', '27.22000', '109.10000', '419200'), ('101251210', '2512', '0', 'zhijiang1', '', '芷江', '273.00000', '', '30.47200', '111.65500', '419100'), ('101251211', '2512', '0', 'xupu', '', '溆浦', '205.00000', '', '27.55000', '110.36000', '419300'), ('101251212', '2512', '0', 'zhongfang', '', '中方', '227.00000', '', '27.41600', '109.93800', '418005'), ('101251213', '2512', '0', 'hongjiang', '', '洪江', '171.00000', '', '27.32000', '110.12300', '418100'), ('101251401', '2514', '1', 'yongzhou', 'yongzhou', '永州', '173.00000', '', '26.11100', '111.57600', '425000'), ('101251402', '2514', '0', 'qiyang', '', '祁阳', '111.00000', '', '26.44600', '111.91300', '426100'), ('101251403', '2514', '0', 'dongan', '', '东安', '168.00000', '', '26.24000', '111.17000', '425900'), ('101251404', '2514', '0', 'shuangpai', '', '双牌', '162.00000', '', '25.88800', '111.68700', '425200'), ('101251405', '2514', '0', 'daoxian', '', '道县', '191.00000', '', '25.32000', '111.36000', '425300'), ('101251406', '2514', '0', 'ningyuan', '', '宁远', '204.00000', '', '25.66500', '111.98900', '425600'), ('101251407', '2514', '0', 'jiangyong', '', '江永', '227.00000', '', '25.20100', '111.24000', '425400'), ('101251408', '2514', '0', 'lanshan', '', '蓝山', '275.00000', '', '25.31400', '112.18100', '425800'), ('101251409', '2514', '0', 'xintian', '', '新田', '222.00000', '', '25.55000', '112.12000', '425700'), ('101251410', '2514', '0', 'jianghua', '', '江华', '263.00000', '', '25.11000', '111.27000', '425500'), ('101251411', '2514', '0', 'lengshuitan', '', '冷水滩', '114.00000', '', '26.53400', '111.63100', '425000'), ('101251501', '2515', '0', 'jishou', '', '吉首', '204.00000', '', '28.31300', '109.77800', '416000'), ('101251502', '2515', '0', 'baojing', '', '保靖', '324.00000', '', '28.66200', '109.50500', '416500'), ('101251503', '2515', '0', 'yongshun', '', '永顺', '269.00000', '', '29.07600', '109.98500', '416700'), ('101251504', '2515', '0', 'guzhang', '', '古丈', '302.00000', '', '28.58200', '110.01300', '416300'), ('101251505', '2515', '0', 'fenghuang', '', '凤凰', '350.00000', '', '28.02700', '109.54600', '416200'), ('101251506', '2515', '0', 'luxi', '', '泸溪', '171.00000', '', '28.17000', '110.09000', '416100'), ('101251507', '2515', '0', 'longshan', '', '龙山', '487.00000', '', '29.20400', '109.52400', '416800'), ('101251508', '2515', '0', 'huayuan', '', '花垣', '342.00000', '', '28.40500', '109.45000', '416400'), ('101260101', '2601', '1', 'guiyang1', 'guiyang', '贵阳', '1223.00000', '', '26.57200', '106.70000', '550000'), ('101260102', '2601', '0', 'baiyun', '', '白云', '1281.00000', '', '26.41000', '106.37000', '55000'), ('101260103', '2601', '0', 'huaxi', '', '花溪', '1096.00000', '', '26.25000', '106.40000', '55000'), ('101260104', '2601', '0', 'wudang', '', '乌当', '1100.00000', '', '26.38000', '106.46000', '55000'), ('101260105', '2601', '0', 'xifeng2', '', '息烽', '1040.00000', '', '27.06000', '106.44000', '551100');
INSERT INTO `district` VALUES ('101260106', '2601', '0', 'kaiyang', '', '开阳', '1277.00000', '', '27.07300', '107.00800', '550300'), ('101260107', '2601', '0', 'xiuwen', '', '修文', '1242.00000', '', '26.51000', '106.36000', '550200'), ('101260108', '2601', '0', 'qingzhen', '', '清镇', '1266.00000', '', '26.68300', '106.33300', '551400'), ('101260109', '2601', '0', 'xiaohe', '', '小河', '1111.00000', '', '26.50900', '106.69200', ''), ('101260110', '2601', '0', 'yunyan', '', '云岩', '1085.00000', '', '26.58100', '106.70500', ''), ('101260111', '2601', '0', 'nanming', '', '南明', '1093.00000', '', '26.56600', '106.71300', ''), ('101260201', '2602', '1', 'zunyi', 'zunyi', '遵义', '845.00000', '', '27.69800', '106.90700', '563000'), ('101260202', '2602', '0', 'zunyixian', '', '遵义县', '954.00000', '', '27.32000', '106.49000', '563100'), ('101260203', '2602', '0', 'renhuai', '', '仁怀', '877.00000', '', '27.79200', '106.40100', '564500'), ('101260204', '2602', '0', 'suiyang', '', '绥阳', '889.00000', '', '28.15600', '107.24500', '563300'), ('101260205', '2602', '0', 'meitan', '', '湄潭', '793.00000', '', '27.77400', '107.47300', '564100'), ('101260206', '2602', '0', 'fenggang', '', '凤冈', '712.00000', '', '27.94700', '107.73600', '564200'), ('101260207', '2602', '0', 'tongzi', '', '桐梓', '973.00000', '', '28.42400', '106.85800', '563200'), ('101260208', '2602', '0', 'chishui', '', '赤水', '317.00000', '', '28.50600', '105.93300', '564700'), ('101260209', '2602', '0', 'xishui1', '', '习水', '1181.00000', '', '28.20000', '106.13000', '564600'), ('101260210', '2602', '0', 'daozhen', '', '道真', '687.00000', '', '28.53000', '107.36000', '563500'), ('101260211', '2602', '0', 'zhengan', '', '正安', '680.00000', '', '28.33000', '107.27000', '563400'), ('101260212', '2602', '0', 'wuchuan1', '', '务川', '660.00000', '', '28.31000', '107.53000', '564300'), ('101260213', '2602', '0', 'yuqing', '', '余庆', '621.00000', '', '27.41500', '107.72400', '564400'), ('101260214', '2602', '0', 'huichuan', '', '汇川', '984.00000', '', '27.73000', '106.95000', '563000'), ('101260215', '2602', '0', 'honghuagang', '', '红花岗', '863.00000', '', '27.65600', '106.89800', ''), ('101260301', '2603', '1', 'anshun', '', '安顺', '1394.00000', '', '26.24800', '105.92500', '561000'), ('101260302', '2603', '0', 'puding', '', '普定', '1272.00000', '', '26.35200', '105.71900', '562100'), ('101260303', '2603', '0', 'zhenning', '', '镇宁', '1275.00000', '', '26.03000', '105.46000', '561200'), ('101260304', '2603', '0', 'pingba', '', '平坝', '1297.00000', '', '26.44900', '106.27800', '561100'), ('101260305', '2603', '0', 'ziyun', '', '紫云', '1196.00000', '', '25.46000', '106.05000', '550800'), ('101260306', '2603', '0', 'guanling', '', '关岭', '1090.00000', '', '25.56000', '105.36000', '561300'), ('101260401', '2604', '0', 'duyun', '', '都匀', '786.00000', '', '26.25200', '107.50200', '558000'), ('101260402', '2604', '0', 'guiding', '', '贵定', '1002.00000', '', '26.43100', '107.17700', '551300'), ('101260403', '2604', '0', 'wengan', '', '瓮安', '1095.00000', '', '27.04000', '107.28000', '550400'), ('101260404', '2604', '0', 'changshun', '', '长顺', '1141.00000', '', '25.97100', '106.42700', '550700'), ('101260405', '2604', '0', 'fuquan', '', '福泉', '926.00000', '', '26.79200', '107.50400', '550500'), ('101260406', '2604', '0', 'huishui', '', '惠水', '992.00000', '', '25.99000', '106.74400', '550600'), ('101260407', '2604', '0', 'longli', '', '龙里', '1088.00000', '', '26.49800', '107.00600', '551200'), ('101260408', '2604', '0', 'luodian', '', '罗甸', '442.00000', '', '25.41500', '106.73000', '550100'), ('101260409', '2604', '0', 'pingtang', '', '平塘', '709.00000', '', '25.80700', '107.06000', '558300'), ('101260410', '2604', '0', 'dushan', '', '独山', '1015.00000', '', '25.61300', '107.56800', '558200'), ('101260411', '2604', '0', 'sandu', '', '三都', '419.00000', '', '25.59000', '107.52000', '558100'), ('101260412', '2604', '0', 'libo', '', '荔波', '430.00000', '', '25.38400', '107.96300', '558400'), ('101260501', '2605', '0', 'kaili', '', '凯里', '723.00000', '', '26.58000', '107.95300', '556000'), ('101260502', '2605', '0', 'cengong', '', '岑巩', '434.00000', '', '27.34300', '108.68400', '557800'), ('101260503', '2605', '0', 'shibing', '', '施秉', '524.00000', '', '27.05700', '108.17500', '556200'), ('101260504', '2605', '0', 'zhenyuan1', '', '镇远', '512.00000', '', '27.03000', '108.25000', '557700'), ('101260505', '2605', '0', 'huangping', '', '黄平', '834.00000', '', '26.98600', '107.90000', '556100'), ('101260507', '2605', '0', 'majiang', '', '麻江', '983.00000', '', '26.45000', '107.60400', '557600'), ('101260508', '2605', '0', 'danzhai', '', '丹寨', '964.00000', '', '26.25300', '107.93300', '557500'), ('101260509', '2605', '0', 'sansui', '', '三穗', '627.00000', '', '26.93300', '108.79500', '556500'), ('101260510', '2605', '0', 'taijiang', '', '台江', '643.00000', '', '26.62600', '108.30300', '556300'), ('101260511', '2605', '0', 'jianhe', '', '剑河', '508.00000', '', '26.63400', '108.67200', '556400'), ('101260512', '2605', '0', 'leishan', '', '雷山', '839.00000', '', '26.30100', '108.12500', '557100'), ('101260513', '2605', '0', 'liping', '', '黎平', '569.00000', '', '26.11700', '109.06200', '557300'), ('101260514', '2605', '0', 'tianzhu1', '', '天柱', '400.00000', '', '26.93100', '109.23200', '556600'), ('101260515', '2605', '0', 'jinping', '', '锦屏', '344.00000', '', '26.58600', '109.10600', '556700'), ('101260516', '2605', '0', 'rongjiang', '', '榕江', '287.00000', '', '26.03800', '108.40000', '557200'), ('101260517', '2605', '0', 'congjiang', '', '从江', '235.00000', '', '25.68000', '108.70900', '557400'), ('101260601', '2606', '1', 'tongren', '', '铜仁', '281.00000', '', '27.71800', '109.17900', '554300'), ('101260602', '2606', '0', 'jiangkou', '', '江口', '370.00000', '', '27.71600', '108.79000', '554400'), ('101260603', '2606', '0', 'yuping', '', '玉屏', '375.00000', '', '27.14000', '108.53000', '554000'), ('101260604', '2606', '0', 'wanshan', '', '万山', '883.00000', '', '27.31000', '109.12000', '554200'), ('101260605', '2606', '0', 'sinan', '', '思南', '418.00000', '', '27.83900', '108.16600', '565100'), ('101260607', '2606', '0', 'yinjiang', '', '印江', '456.00000', '', '28.01000', '108.24000', '555200'), ('101260608', '2606', '0', 'shiqian', '', '石阡', '468.00000', '', '27.50300', '108.15200', '555100'), ('101260609', '2606', '0', 'yanhe', '', '沿河', '333.00000', '', '28.34000', '108.30000', '565300'), ('101260610', '2606', '0', 'dejiang', '', '德江', '541.00000', '', '28.31900', '108.10100', '565200'), ('101260611', '2606', '0', 'songtao', '', '松桃', '407.00000', '', '28.09000', '109.11000', '554100'), ('101260701', '2607', '1', 'bijie', '', '毕节', '1512.00000', '', '27.30900', '105.27900', '551700'), ('101260702', '2607', '0', 'hezhang', '', '赫章', '1536.00000', '', '27.11900', '104.60700', '553200'), ('101260703', '2607', '0', 'jinsha', '', '金沙', '922.00000', '', '27.44100', '106.25400', '551800'), ('101260704', '2607', '0', 'weining', '', '威宁', '2239.00000', '', '26.52000', '104.17000', '553100'), ('101260705', '2607', '0', 'dafang', '', '大方', '1704.00000', '', '27.21800', '105.70000', '551600'), ('101260706', '2607', '0', 'nayong', '', '纳雍', '1461.00000', '', '26.80300', '105.27700', '553300'), ('101260707', '2607', '0', 'zhijin', '', '织金', '1319.00000', '', '26.65900', '105.76000', '552100'), ('101260708', '2607', '0', 'qianxi1', '', '黔西', '1233.00000', '', '27.03300', '106.02000', '551500'), ('101260801', '2608', '0', 'shuicheng', '', '水城', '1817.00000', '', '26.35000', '104.52000', '553000'), ('101260802', '2608', '0', 'liuzhi', '', '六枝', '1364.00000', '', '26.14000', '105.27000', '553400'), ('101260804', '2608', '0', 'panxian', '', '盘县', '1517.00000', '', '25.47000', '104.37000', '553500'), ('101260901', '2609', '0', 'xingyi1', '', '兴义', '1301.00000', '', '25.05000', '104.54000', '562400'), ('101260902', '2609', '0', 'qinglong1', '', '晴隆', '1554.00000', '', '25.86800', '105.21500', '561400'), ('101260903', '2609', '0', 'xingren', '', '兴仁', '1379.00000', '', '25.26000', '105.11000', '562300'), ('101260904', '2609', '0', 'zhenfeng', '', '贞丰', '1064.00000', '', '25.41500', '105.67300', '562200'), ('101260905', '2609', '0', 'wangmo', '', '望谟', '567.00000', '', '25.26200', '106.18700', '552300'), ('101260907', '2609', '0', 'anlong', '', '安龙', '1394.00000', '', '25.15000', '105.32800', '552400'), ('101260908', '2609', '0', 'ceheng', '', '册亨', '585.00000', '', '24.96800', '105.82300', '552200'), ('101260909', '2609', '0', 'puan', '', '普安', '1649.00000', '', '25.47000', '104.58000', '561500'), ('101270101', '2701', '1', 'chengdu', 'chengdu', '成都', '507.00000', '', '30.67000', '104.07100', '610000'), ('101270102', '2701', '0', 'longquanyi', '', '龙泉驿', '515.00000', '', '30.33000', '104.15000', '610100'), ('101270103', '2701', '0', 'xindu', '', '新都', '497.00000', '', '30.50000', '104.09000', '610500'), ('101270104', '2701', '0', 'wenjiang', '', '温江', '541.00000', '', '30.42000', '103.50000', '611100'), ('101270105', '2701', '0', 'jintang', '', '金堂', '449.00000', '', '30.72000', '104.62100', '610400'), ('101270106', '2701', '0', 'shuangliu', '', '双流', '496.00000', '', '30.44800', '104.02900', '610200'), ('101270107', '2701', '0', 'pixian', '', '郫县', '561.00000', '', '30.49000', '103.53000', '611730'), ('101270108', '2701', '0', 'dayi', '', '大邑', '525.00000', '', '30.62200', '103.39100', '611330'), ('101270109', '2701', '0', 'pujiang1', '', '蒲江', '516.00000', '', '30.12000', '103.31000', '611630'), ('101270110', '2701', '0', 'xinjin', '', '新津', '462.00000', '', '30.26000', '103.48000', '611430'), ('101270111', '2701', '0', 'dujiangyan', '', '都江堰', '707.00000', '', '31.05700', '103.61000', '611830'), ('101270112', '2701', '0', 'pengzhou', '', '彭州', '583.00000', '', '30.59000', '103.56000', '611930'), ('101270113', '2701', '0', 'qionglai', '', '邛崃', '503.00000', '', '30.37700', '103.41700', '611500'), ('101270114', '2701', '0', 'chongzhou', '', '崇州', '534.00000', '', '30.38000', '103.40000', '611200'), ('101270201', '2702', '1', 'panzhihua', 'panzhihua', '攀枝花', '1191.00000', '', '26.55000', '101.73300', '617000'), ('101270202', '2702', '0', 'renhe', '', '仁和', '1112.00000', '', '26.30000', '101.44000', '617000'), ('101270203', '2702', '0', 'miyi', '', '米易', '1106.00000', '', '26.95300', '101.97100', '617200'), ('101270204', '2702', '0', 'yanbian1', '', '盐边', '1141.00000', '', '26.88400', '101.59900', '617100'), ('101270301', '2703', '1', 'zigong', 'zigong', '自贡', '357.00000', '', '29.35700', '104.76300', '643000'), ('101270302', '2703', '0', 'fushun1', '', '富顺', '302.00000', '', '29.18300', '104.99900', '643200'), ('101270303', '2703', '0', 'rongxian', '', '荣县', '382.00000', '', '29.27000', '104.26000', '643100'), ('101270401', '2704', '1', 'mianyang', 'mianyang', '绵阳', '472.00000', '', '31.47500', '104.72700', '621000'), ('101270402', '2704', '0', 'santai', '', '三台', '405.00000', '', '31.07600', '105.00200', '621100'), ('101270403', '2704', '0', 'yanting', '', '盐亭', '422.00000', '', '31.23300', '105.46100', '621600'), ('101270404', '2704', '0', 'anxian', '', '安县', '600.00000', '', '31.39000', '104.25000', '622650'), ('101270405', '2704', '0', 'zitong', '', '梓潼', '571.00000', '', '31.67100', '105.20700', '622150'), ('101270406', '2704', '0', 'beichuan', '', '北川', '639.00000', '', '31.95200', '104.24300', '622750'), ('101270407', '2704', '0', 'pingwu', '', '平武', '877.00000', '', '32.52300', '104.41400', '622550'), ('101270408', '2704', '0', 'jiangyou', '', '江油', '532.00000', '', '31.92900', '104.90300', '621700'), ('101270501', '2705', '1', 'nanchong', 'nanchong', '南充', '310.00000', '', '30.79700', '106.08300', '637000'), ('101270502', '2705', '0', 'nanbu', '', '南部', '386.00000', '', '31.34800', '105.91100', '637300'), ('101270503', '2705', '0', 'yingshan1', '', '营山', '340.00000', '', '31.04000', '106.33000', '638150'), ('101270504', '2705', '0', 'pengan', '', '蓬安', '324.00000', '', '31.02000', '106.25000', '638250'), ('101270505', '2705', '0', 'yilong', '', '仪陇', '658.00000', '', '31.43300', '106.55900', '637600'), ('101270506', '2705', '0', 'xichong', '', '西充', '362.00000', '', '30.59000', '105.53000', '637200'), ('101270507', '2705', '0', 'langzhong', '', '阆中', '385.00000', '', '31.60700', '106.04600', '637400'), ('101270601', '2706', '1', 'dazhou', 'dazhou', '达州', '344.00000', '', '31.12000', '107.30000', '635000'), ('101270602', '2706', '0', 'xuanhan', '', '宣汉', '390.00000', '', '31.22000', '107.43000', '636150'), ('101270603', '2706', '0', 'kaijiang', '', '开江', '452.00000', '', '31.02500', '107.89300', '636250'), ('101270604', '2706', '0', 'dazhu', '', '大竹', '397.00000', '', '30.66700', '107.25700', '635100'), ('101270605', '2706', '0', 'quxian', '', '渠县', '296.00000', '', '30.51000', '106.58000', '635200'), ('101270606', '2706', '0', 'wanyuan', '', '万源', '674.00000', '', '31.99300', '108.00200', '636350'), ('101270607', '2706', '0', 'dachuan', '', '通川', '344.00000', '', '31.12000', '107.30000', '635000'), ('101270608', '2706', '0', 'daxian', '', '达县', '420.00000', '', '31.22700', '107.50000', ''), ('101270701', '2707', '1', 'suining1', 'suiing', '遂宁', '280.00000', '', '30.50900', '105.57500', '629000'), ('101270702', '2707', '0', 'pengxi', '', '蓬溪', '395.00000', '', '30.46000', '105.42000', '629100'), ('101270703', '2707', '0', 'shehong', '', '射洪', '332.00000', '', '30.90000', '105.40900', '629200'), ('101270801', '2708', '1', 'guangan', 'guangan', '广安', '336.00000', '', '30.47700', '106.63500', '638500'), ('101270802', '2708', '0', 'yuechi', '', '岳池', '396.00000', '', '30.52900', '106.41600', '638350'), ('101270803', '2708', '0', 'wusheng', '', '武胜', '315.00000', '', '30.36300', '106.19500', '638450'), ('101270804', '2708', '0', 'linshui', '', '邻水', '357.00000', '', '30.28100', '107.00000', '635300'), ('101270805', '2708', '0', 'huaying', '', '华蓥', '327.00000', '', '30.37000', '106.75000', '638650'), ('101270901', '2709', '1', 'bazhong', 'bazhong', '巴中', '416.00000', '', '31.85600', '106.76200', '635500'), ('101270902', '2709', '0', 'tongjiang1', '', '通江', '402.00000', '', '31.56000', '107.14000', '635700'), ('101270903', '2709', '0', 'nanjiang', '', '南江', '582.00000', '', '32.30700', '106.78000', '635600'), ('101270904', '2709', '0', 'pingchang', '', '平昌', '378.00000', '', '31.56000', '107.20400', '635400'), ('101271001', '2710', '1', 'luzhou', 'luzhou', '泸州', '335.00000', '', '28.88900', '105.44400', '646000'), ('101271003', '2710', '0', 'luxian', '', '泸县', '322.00000', '', '28.59000', '105.27000', '646100'), ('101271004', '2710', '0', 'hejiang', '', '合江', '284.00000', '', '28.74200', '105.95100', '646200'), ('101271005', '2710', '0', 'xuyong', '', '叙永', '379.00000', '', '28.10000', '105.26000', '646400'), ('101271006', '2710', '0', 'gulin', '', '古蔺', '538.00000', '', '28.00900', '105.95300', '646500'), ('101271007', '2710', '0', 'naxi', '', '纳溪', '367.00000', '', '28.78000', '105.38000', '646300'), ('101271101', '2711', '1', 'yibin', 'yibin', '宜宾', '342.00000', '', '28.76500', '104.62200', '644000'), ('101271103', '2711', '0', 'yibinxian', '', '宜宾县', '333.00000', '', '28.42000', '104.33000', '644600'), ('101271104', '2711', '0', 'nanxi', '', '南溪', '294.00000', '', '28.88100', '104.91400', '644100'), ('101271105', '2711', '0', 'jiangan', '', '江安', '275.00000', '', '28.44000', '105.04000', '644200'), ('101271106', '2711', '0', 'changning1', '', '长宁', '276.00000', '', '24.72000', '99.66200', '644300'), ('101271107', '2711', '0', 'gaoxian1', '', '高县', '358.00000', '', '28.26000', '104.31000', '645150'), ('101271108', '2711', '0', 'gongxian', '', '珙县', '368.00000', '', '28.23000', '104.47000', '644500'), ('101271109', '2711', '0', 'junlian', '', '筠连', '457.00000', '', '28.10000', '104.31000', '645250'), ('101271110', '2711', '0', 'xingwen', '', '兴文', '354.00000', '', '28.19000', '105.14000', '644400'), ('101271111', '2711', '0', 'pingshan1', '', '屏山', '0.00000', '', '28.39000', '104.09000', '645350'), ('101271201', '2712', '1', 'neijiang', 'neijing', '内江', '352.00000', '', '29.58400', '105.05600', '641000'), ('101271202', '2712', '0', 'dongxing', '', '东兴', '350.00000', '', '29.37000', '105.07000', '641100'), ('101271203', '2712', '0', 'weiyuan1', '', '威远', '353.00000', '', '29.31000', '104.40000', '642450'), ('101271204', '2712', '0', 'zizhong', '', '资中', '367.00000', '', '29.80300', '104.78400', '641200'), ('101271205', '2712', '0', 'longchang', '', '隆昌', '374.00000', '', '29.36500', '105.23900', '642150'), ('101271301', '2713', '1', 'ziyang1', 'ziyang', '资阳', '358.00000', '', '30.13000', '104.64800', '641300'), ('101271302', '2713', '0', 'anyue', '', '安岳', '336.00000', '', '29.99000', '105.35500', '642350'), ('101271303', '2713', '0', 'lezhi', '', '乐至', '462.00000', '', '30.34000', '105.02400', '641500'), ('101271304', '2713', '0', 'jianyang1', '', '简阳', '448.00000', '', '30.23000', '104.33000', '641400'), ('101271401', '2714', '1', 'leshan', 'leshan', '乐山', '422.00000', '', '29.56400', '103.74700', '614000'), ('101271402', '2714', '0', 'qianwei', '', '犍为', '389.00000', '', '29.15000', '103.57000', '614400'), ('101271403', '2714', '0', 'jingyan', '', '井研', '398.00000', '', '29.65900', '104.06100', '612660'), ('101271404', '2714', '0', 'jiajiang', '', '夹江', '408.00000', '', '29.78000', '103.51400', '614100'), ('101271405', '2714', '0', 'muchuan', '', '沐川', '397.00000', '', '29.01400', '103.84400', '614500'), ('101271406', '2714', '0', 'ebian', '', '峨边', '640.00000', '', '29.14000', '103.16000', '614300'), ('101271407', '2714', '0', 'mabian', '', '马边', '542.00000', '', '28.50000', '103.33000', '614600'), ('101271408', '2714', '0', 'emei', '', '峨眉', '447.00000', '', '29.36000', '103.29000', '614200'), ('101271409', '2714', '0', 'emeishan', '', '峨眉山', '3049.00000', '', '29.49900', '103.39200', '614200'), ('101271501', '2715', '1', 'meishan', 'meishan', '眉山', '412.00000', '', '30.05300', '103.82900', '612160'), ('101271502', '2715', '0', 'renshou', '', '仁寿', '437.00000', '', '29.98600', '104.20700', '612560'), ('101271503', '2715', '0', 'pengshan', '', '彭山', '436.00000', '', '30.24100', '103.84900', '612760'), ('101271504', '2715', '0', 'hongya', '', '洪雅', '463.00000', '', '29.70200', '103.17600', '620360'), ('101271505', '2715', '0', 'danleng', '', '丹棱', '497.00000', '', '30.01000', '103.31000', '612260'), ('101271506', '2715', '0', 'qingshen', '', '青神', '395.00000', '', '29.81700', '103.83800', '620400'), ('101271601', '2716', '1', 'liangshan1', 'liangshan', '凉山', '1593.00000', '', '35.79900', '116.10400', '615000'), ('101271603', '2716', '0', 'muli', '', '木里', '2427.00000', '', '27.56000', '101.16000', '615800'), ('101271604', '2716', '0', 'yanyuan', '', '盐源', '2545.00000', '', '27.69400', '101.38700', '615700'), ('101271605', '2716', '0', 'dechang', '', '德昌', '1384.00000', '', '27.33400', '102.17700', '615500'), ('101271606', '2716', '0', 'huili', '', '会理', '1789.00000', '', '26.62200', '102.23300', '615100'), ('101271607', '2716', '0', 'huidong', '', '会东', '1700.00000', '', '22.96900', '114.98900', '615200'), ('101271608', '2716', '0', 'ningnan', '', '宁南', '996.00000', '', '27.04000', '102.45000', '615400'), ('101271609', '2716', '0', 'puge', '', '普格', '1433.00000', '', '27.52700', '102.55600', '615300'), ('101271610', '2716', '0', 'xichang', '', '西昌', '1593.00000', '', '27.54000', '102.16000', '615000'), ('101271611', '2716', '0', 'jinyang', '', '金阳', '1453.00000', '', '27.66800', '103.22200', '616250'), ('101271612', '2716', '0', 'zhaojue', '', '昭觉', '2134.00000', '', '28.05600', '102.84100', '616150'), ('101271613', '2716', '0', 'xide', '', '喜德', '1819.00000', '', '28.18000', '102.26000', '616750'), ('101271614', '2716', '0', 'mianning', '', '冕宁', '1778.00000', '', '28.33000', '102.10000', '615600'), ('101271615', '2716', '0', 'yuexi1', '', '越西', '1660.00000', '', '28.39000', '102.31000', '616650'), ('101271616', '2716', '0', 'ganluo', '', '甘洛', '1062.00000', '', '28.97300', '102.74300', '616850'), ('101271617', '2716', '0', 'leibo', '', '雷波', '1255.00000', '', '28.32200', '103.52600', '616550'), ('101271618', '2716', '0', 'meigu', '', '美姑', '2083.00000', '', '28.42600', '103.10200', '616450'), ('101271619', '2716', '0', 'butuo', '', '布拖', '246.00000', '', '27.72000', '102.80000', '615350'), ('101271701', '2717', '1', 'yaan', 'yaan', '雅安', '629.00000', '', '29.99000', '102.99700', '625000'), ('101271702', '2717', '0', 'mingshan', '', '名山', '693.00000', '', '30.11800', '103.21600', '625100'), ('101271703', '2717', '0', 'yingjing', '', '荥经', '764.00000', '', '29.47000', '102.51000', '625200'), ('101271704', '2717', '0', 'hanyuan', '', '汉源', '798.00000', '', '29.40700', '102.63500', '625300'), ('101271705', '2717', '0', 'shimian', '', '石棉', '875.00000', '', '29.19200', '102.25100', '625400'), ('101271706', '2717', '0', 'tianquan', '', '天全', '757.00000', '', '30.08700', '102.58500', '625500'), ('101271707', '2717', '0', 'lushan2', '', '芦山', '685.00000', '', '30.09000', '102.56000', '625600'), ('101271708', '2717', '0', 'baoxing', '', '宝兴', '1011.00000', '', '30.55700', '102.72200', '625700'), ('101271801', '2718', '1', 'ganzi', 'ganzi', '甘孜', '3394.00000', '', '30.46700', '107.03300', '626700'), ('101271802', '2718', '0', 'kangding', '', '康定', '2616.00000', '', '30.03000', '101.58000', '626000'), ('101271803', '2718', '0', 'luding', '', '泸定', '1322.00000', '', '29.77300', '102.09200', '626100'), ('101271804', '2718', '0', 'danba', '', '丹巴', '1948.00000', '', '30.53000', '101.53000', '626300'), ('101271805', '2718', '0', 'jiulong', '', '九龙', '2994.00000', '', '29.00000', '101.30000', '626200'), ('101271806', '2718', '0', 'yajiang', '', '雅江', '2599.00000', '', '30.02000', '101.01000', '627450'), ('101271807', '2718', '0', 'daofu', '', '道孚', '2959.00000', '', '30.59000', '101.07000', '626400'), ('101271808', '2718', '0', 'luhuo', '', '炉霍', '3250.00000', '', '31.24000', '100.40000', '626500'), ('101271809', '2718', '0', 'xinlong', '', '新龙', '2999.00000', '', '30.56000', '100.19000', '626800'), ('101271810', '2718', '0', 'dege', '', '德格', '3185.00000', '', '31.44000', '98.34000', '627250'), ('101271811', '2718', '0', 'baiyu', '', '白玉', '3261.00000', '', '31.13000', '98.50000', '627150'), ('101271812', '2718', '0', 'shiqu', '', '石渠', '4201.00000', '', '32.59000', '98.06000', '627350'), ('101271813', '2718', '0', 'seda', '', '色达', '3896.00000', '', '32.17000', '100.20000', '626600'), ('101271814', '2718', '0', 'litang', '', '理塘', '3951.00000', '', '29.83300', '100.12100', '624300'), ('101271815', '2718', '0', 'batang', '', '巴塘', '2590.00000', '', '29.70100', '99.35300', '627650'), ('101271816', '2718', '0', 'xiangcheng2', '', '乡城', '2842.00000', '', '28.56000', '99.48000', '627850'), ('101271817', '2718', '0', 'daocheng', '', '稻城', '3729.00000', '', '29.03000', '100.18000', '627750'), ('101271818', '2718', '0', 'derong', '', '得荣', '2424.00000', '', '28.43000', '99.17000', '627950'), ('101271901', '2719', '1', 'aba', 'anba', '阿坝', '3277.00000', '', '32.90100', '101.76500', '624600'), ('101271902', '2719', '0', 'wenchuan', '', '汶川', '1327.00000', '', '31.24300', '103.30200', '623000'), ('101271903', '2719', '0', 'lixian3', '', '理县', '1885.00000', '', '31.26000', '103.10000', '623100'), ('101271904', '2719', '0', 'maoxian', '', '茂县', '1592.00000', '', '31.41000', '103.51000', '623200'), ('101271905', '2719', '0', 'songpan', '', '松潘', '2852.00000', '', '32.39000', '103.34000', '623300'), ('101271906', '2719', '0', 'jiuzhaigou', '', '九寨沟', '1407.00000', '', '33.16000', '104.14000', '623400'), ('101271907', '2719', '0', 'jinchuan', '', '金川', '2171.00000', '', '31.29000', '102.04000', '624100'), ('101271908', '2719', '0', 'xiaojin', '', '小金', '2372.00000', '', '31.00000', '102.21000', '624200'), ('101271909', '2719', '0', 'heishui', '', '黑水', '2401.00000', '', '32.24400', '103.04600', '623500'), ('101271910', '2719', '0', 'maerkang', '', '马尔康', '2666.00000', '', '31.54000', '102.14000', '624000'), ('101271911', '2719', '0', 'rangtang', '', '壤塘', '3287.00000', '', '32.16000', '100.59000', '624300'), ('101271912', '2719', '0', 'nuoergai', '', '若尔盖', '3441.00000', '', '33.35000', '102.58000', '624500'), ('101271913', '2719', '0', 'hongyuan', '', '红原', '3493.00000', '', '32.58700', '102.59300', '624400'), ('101272001', '2720', '1', 'deyang', 'deyang', '德阳', '501.00000', '', '31.14700', '104.37500', '618000'), ('101272002', '2720', '0', 'zhongjiang', '', '中江', '425.00000', '', '30.90400', '104.80300', '618100'), ('101272003', '2720', '0', 'guanghan', '', '广汉', '475.00000', '', '31.02400', '104.30200', '618300'), ('101272004', '2720', '0', 'shifang', '', '什邡', '533.00000', '', '31.08000', '104.11000', '618400'), ('101272005', '2720', '0', 'mianzhu', '', '绵竹', '589.00000', '', '31.42500', '104.12800', '618200'), ('101272006', '2720', '0', 'luojiang', '', '罗江', '502.00000', '', '31.32000', '104.50000', '618500'), ('101272101', '2721', '1', 'guangyuan', 'guangyuan', '广元', '495.00000', '', '32.44600', '105.81900', '628000'), ('101272102', '2721', '0', 'wangcang', '', '旺苍', '485.00000', '', '32.14000', '106.17000', '628200'), ('101272103', '2721', '0', 'qingchuan', '', '青川', '802.00000', '', '32.59000', '105.12000', '628100'), ('101272104', '2721', '0', 'jiange', '', '剑阁', '535.00000', '', '31.90500', '105.49800', '628300'), ('101272105', '2721', '0', 'cangxi', '', '苍溪', '461.00000', '', '31.89500', '106.08900', '628400'), ('101280101', '2801', '1', 'guangzhou', 'guangzhou', '广州', '43.00000', '', '23.10800', '113.26500', '510000'), ('101280102', '2801', '0', 'panyu', '', '番禺', '10.00000', '', '22.57000', '113.22000', '511400'), ('101280103', '2801', '0', 'conghua', '', '从化', '35.00000', '', '23.65500', '113.66600', '510900'), ('101280104', '2801', '0', 'zengcheng', '', '增城', '9.00000', '', '23.35900', '113.73800', '511300'), ('101280105', '2801', '0', 'huadu', '', '花都', '7.00000', '', '23.23000', '113.13000', '510800'), ('101280201', '2802', '1', 'shaoguan', 'shaoguan', '韶关', '65.00000', '', '24.80500', '113.58900', '512000'), ('101280202', '2802', '0', 'ruyuan', '', '乳源', '98.00000', '', '24.47000', '113.16000', '512700'), ('101280203', '2802', '0', 'shixing', '', '始兴', '104.00000', '', '24.57000', '114.04000', '512500'), ('101280204', '2802', '0', 'wengyuan', '', '翁源', '136.00000', '', '24.22000', '114.04000', '512600'), ('101280205', '2802', '0', 'lechang', '', '乐昌', '103.00000', '', '25.24200', '113.21700', '512200'), ('101280206', '2802', '0', 'renhua', '', '仁化', '96.00000', '', '25.20300', '113.77000', '512300'), ('101280207', '2802', '0', 'nanxiong', '', '南雄', '135.00000', '', '25.18300', '114.33000', '512400'), ('101280208', '2802', '0', 'xinfeng1', '', '新丰', '161.00000', '', '24.03000', '114.12000', '511100'), ('101280209', '2802', '0', 'qujiang', '', '曲江', '598.00000', '', '24.41000', '113.36000', '512100'), ('101280210', '2802', '0', 'zhenjiang1', '', '浈江', '110.00000', '', '24.80000', '113.60000', ''), ('101280211', '2802', '0', 'wujiang1', '', '武江', '61.00000', '', '24.80000', '113.50000', ''), ('101280301', '2803', '1', 'huizhou', 'huizhou', '惠州', '22.00000', '', '23.09600', '114.39800', '516000'), ('101280302', '2803', '0', 'boluo', '', '博罗', '16.00000', '', '23.11000', '114.17000', '516100'), ('101280303', '2803', '0', 'huiyang', '', '惠阳', '22.00000', '', '23.09600', '114.39800', '516200'), ('101280304', '2803', '0', 'huidong1', '', '惠东', '44.00000', '', '22.96900', '114.98900', '516300'), ('101280305', '2803', '0', 'longmen', '', '龙门', '71.00000', '', '23.37800', '114.27000', '516800'), ('101280401', '2804', '1', 'meizhou', 'meizhou', '梅州', '89.00000', '', '24.32100', '116.11900', '514000'), ('101280402', '2804', '0', 'xingning', '', '兴宁', '126.00000', '', '24.09000', '115.44000', '514500'), ('101280403', '2804', '0', 'jiaoling', '', '蕉岭', '106.00000', '', '24.64600', '116.21800', '514100'), ('101280404', '2804', '0', 'dabu', '', '大埔', '81.00000', '', '24.34600', '116.62100', '514200'), ('101280406', '2804', '0', 'fengshun', '', '丰顺', '39.00000', '', '23.91800', '116.27400', '514300'), ('101280407', '2804', '0', 'pingyuan1', '', '平远', '152.00000', '', '24.35000', '115.54000', '514600'), ('101280408', '2804', '0', 'wuhua', '', '五华', '122.00000', '', '23.78100', '115.66500', '514400'), ('101280409', '2804', '0', 'meixian1', '', '梅县', '89.00000', '', '24.32100', '116.11900', '514700'), ('101280501', '2805', '1', 'shantou', 'shantou', '汕头', '7.00000', '', '23.35500', '116.67600', '515000'), ('101280502', '2805', '0', 'chaoyang2', '', '潮阳', '7.00000', '', '23.16000', '116.35000', '515100'), ('101280503', '2805', '0', 'chenghai', '', '澄海', '5.00000', '', '23.50200', '116.80500', '515800'), ('101280504', '2805', '0', 'nanao', '', '南澳', '8.00000', '', '23.26000', '117.02000', '515900'), ('101280601', '2806', '1', 'shenzhen', 'shenzhen', '深圳', '40.00000', '', '22.54400', '114.10900', '518001'), ('101280701', '2807', '1', 'zhuhai', 'zhuhai', '珠海', '46.00000', '', '22.24800', '113.56500', '519000'), ('101280702', '2807', '0', 'doumen', '', '斗门', '20.00000', '', '22.24000', '113.24900', '519100'), ('101280703', '2807', '0', 'jinwan', '', '金湾', '0.00000', '', '21.20000', '113.30000', ''), ('101280800', '2808', '1', 'foshan', 'foshan', '佛山', '13.00000', '', '22.82800', '113.16700', '528000'), ('101280801', '2808', '0', 'shunde', '', '顺德', '13.00000', '', '22.82800', '113.16700', '528300'), ('101280802', '2808', '0', 'sanshui', '', '三水', '9.00000', '', '23.26700', '112.90900', '528100'), ('101280803', '2808', '0', 'nanhai', '', '南海', '7.00000', '', '23.05800', '113.04700', '528200'), ('101280804', '2808', '0', 'gaoming', '', '高明', '25.00000', '', '22.88900', '112.84800', ''), ('101280901', '2809', '1', 'zhaoqing', 'zhaoqing', '肇庆', '41.00000', '', '23.05100', '112.45200', '526000'), ('101280902', '2809', '0', 'guangning', '', '广宁', '56.00000', '', '23.67100', '112.38900', '526300'), ('101280903', '2809', '0', 'sihui', '', '四会', '48.00000', '', '23.44800', '112.63100', '526200'), ('101280905', '2809', '0', 'deqing1', '', '德庆', '28.00000', '', '23.09000', '111.46000', '526600'), ('101280906', '2809', '0', 'huaiji', '', '怀集', '57.00000', '', '23.93900', '112.19700', '526400'), ('101280907', '2809', '0', 'fengkai', '', '封开', '38.00000', '', '23.59800', '111.68900', '526500'), ('101280908', '2809', '0', 'gaoyao', '', '高要', '41.00000', '', '23.05100', '112.45200', '526100'), ('101281001', '2810', '1', 'zhanjiang', 'zhanjiang', '湛江', '28.00000', '', '21.19000', '110.38400', '524000'), ('101281002', '2810', '0', 'wuchuan2', '', '吴川', '30.00000', '', '21.26000', '110.46000', '524500'), ('101281003', '2810', '0', 'leizhou', '', '雷州', '29.00000', '', '20.55000', '110.06000', '524200'), ('101281004', '2810', '0', 'xuwen', '', '徐闻', '72.00000', '', '20.20000', '110.10000', '524100'), ('101281005', '2810', '0', 'lianjiang1', '', '廉江', '28.00000', '', '21.38000', '110.17000', '524400'), ('101281006', '2810', '0', 'chikan', '', '赤坎', '17.00000', '', '21.20000', '110.30000', ''), ('101281007', '2810', '0', 'suixi1', '', '遂溪', '28.00000', '', '21.23000', '110.15000', '524300'), ('101281008', '2810', '0', 'potou', '', '坡头', '7.00000', '', '21.20000', '110.30000', ''), ('101281009', '2810', '0', 'xiashan', '', '霞山', '10.00000', '', '21.20000', '110.30000', ''), ('101281010', '2810', '0', 'mazhang', '', '麻章', '30.00000', '', '21.20000', '110.33000', ''), ('101281101', '2811', '1', 'jiangmen', 'jiangmen', '江门', '21.00000', '', '22.78000', '113.08800', '529000'), ('101281103', '2811', '0', 'kaiping', '', '开平', '18.00000', '', '22.31000', '112.52400', '529300'), ('101281104', '2811', '0', 'xinhui', '', '新会', '35.00000', '', '22.32000', '113.02000', '529100'), ('101281105', '2811', '0', 'enping', '', '恩平', '25.00000', '', '22.20400', '112.26300', '529400'), ('101281106', '2811', '0', 'taishan', '', '台山', '33.00000', '', '22.10400', '112.69800', '529200'), ('101281107', '2811', '0', 'pengjiang', '', '蓬江', '4.00000', '', '22.60000', '113.00000', ''), ('101281108', '2811', '0', 'heshan', '', '鹤山', '21.00000', '', '22.78000', '113.08800', '529700'), ('101281109', '2811', '0', 'jianghai', '', '江海', '0.00000', '', '22.50000', '113.10000', ''), ('101281201', '2812', '1', 'heyuan', 'heyuan', '河源', '41.00000', '', '23.73400', '114.68600', '517000'), ('101281202', '2812', '0', 'zijin', '', '紫金', '141.00000', '', '23.47600', '115.05100', '517400'), ('101281203', '2812', '0', 'lianping', '', '连平', '215.00000', '', '24.34200', '114.58200', '517100'), ('101281204', '2812', '0', 'heping', '', '和平', '175.00000', '', '24.43300', '114.97300', '517200'), ('101281205', '2812', '0', 'longchuan', '', '龙川', '102.00000', '', '24.06000', '115.15000', '517300'), ('101281206', '2812', '0', 'dongyuan', '', '东源', '147.00000', '', '23.80000', '114.80000', ''), ('101281301', '2813', '1', 'qingyuan3', 'qingyuan', '清远', '17.00000', '', '23.65500', '113.11000', '511500'), ('101281302', '2813', '0', 'liannan', '', '连南', '115.00000', '', '24.43000', '112.17000', '513300'), ('101281303', '2813', '0', 'lianzhou', '', '连州', '97.00000', '', '24.47000', '112.23000', '513400'), ('101281304', '2813', '0', 'lianshan', '', '连山', '300.00000', '', '24.34000', '112.09000', '513200'), ('101281305', '2813', '0', 'yangshan', '', '阳山', '70.00000', '', '24.44900', '112.68900', '513100'), ('101281306', '2813', '0', 'fogang', '', '佛冈', '69.00000', '', '23.52000', '113.32000', '511600'), ('101281307', '2813', '0', 'yingde', '', '英德', '44.00000', '', '24.19700', '113.33200', '513000'), ('101281308', '2813', '0', 'qingxin', '', '清新', '90.00000', '', '23.70000', '113.00000', ''), ('101281401', '2814', '1', 'yunfu', 'yunfu', '云浮', '103.00000', '', '22.93000', '112.04000', '527300'), ('101281402', '2814', '0', 'luoding', '', '罗定', '58.00000', '', '22.69200', '111.46600', '527200'), ('101281403', '2814', '0', 'xinxing', '', '新兴', '33.00000', '', '22.43000', '112.13000', '527400'), ('101281404', '2814', '0', 'yunan', '', '郁南', '30.00000', '', '23.06400', '111.62800', '527100'), ('101281406', '2814', '0', 'yunan1', '', '云安', '99.00000', '', '23.10000', '112.00000', ''), ('101281501', '2815', '1', 'chaozhou', 'chaozhou', '潮州', '11.00000', '', '23.66700', '116.63400', '515600'), ('101281502', '2815', '0', 'raoping', '', '饶平', '11.00000', '', '23.86800', '116.93800', '515700'), ('101281503', '2815', '0', 'chaoan', '', '潮安', '7.00000', '', '23.50000', '116.60000', ''), ('101281601', '2816', '1', 'dongguan', 'dongguan', '东莞', '20.00000', '', '23.04700', '113.73600', '523000'), ('101281701', '2817', '1', 'zhongshan', 'zhongshan', '中山', '3.00000', '', '22.52800', '113.35900', '528400'), ('101281801', '2818', '1', 'yangjiang', 'yangjiang', '阳江', '24.00000', '', '21.84600', '111.92300', '529500'), ('101281802', '2818', '0', 'yangchun', '', '阳春', '34.00000', '', '22.26300', '111.72000', '529600'), ('101281803', '2818', '0', 'yangdong', '', '阳东', '2.00000', '', '21.90000', '111.90000', ''), ('101281804', '2818', '0', 'yangxi', '', '阳西', '17.00000', '', '21.75000', '111.62700', ''), ('101281901', '2819', '1', 'jieyang', 'jieyang', '揭阳', '7.00000', '', '23.53500', '116.35000', '522000'), ('101281902', '2819', '0', 'jiexi', '', '揭西', '42.00000', '', '23.49000', '115.89300', '515400'), ('101281903', '2819', '0', 'puning', '', '普宁', '27.00000', '', '23.31200', '116.03300', '515300'), ('101281904', '2819', '0', 'huilai', '', '惠来', '14.00000', '', '23.03200', '116.24300', '515200'), ('101281905', '2819', '0', 'jiedong', '', '揭东', '28.00000', '', '23.50000', '116.50000', ''), ('101282001', '2820', '1', 'maoming', 'maoming', '茂名', '25.00000', '', '21.67100', '110.89100', '525000'), ('101282002', '2820', '0', 'gaozhou', '', '高州', '35.00000', '', '22.00900', '110.99500', '525200'), ('101282003', '2820', '0', 'huazhou', '', '化州', '35.00000', '', '21.84600', '110.53500', '525100'), ('101282004', '2820', '0', 'dianbai', '', '电白', '13.00000', '', '21.70100', '111.14700', '525400'), ('101282005', '2820', '0', 'xinyi1', '', '信宜', '84.00000', '', '22.21000', '110.56000', '525300'), ('101282006', '2820', '0', 'maogang', '', '茂港', '10.00000', '', '21.50000', '110.00000', ''), ('101282101', '2821', '1', 'shanwei', 'shanwei', '汕尾', '13.00000', '', '22.76600', '115.35300', '516600'), ('101282102', '2821', '0', 'haifeng', '', '海丰', '6.00000', '', '22.97600', '115.27000', '516400'), ('101282103', '2821', '0', 'lufeng', '', '陆丰', '11.00000', '', '22.57000', '115.39000', '516500'), ('101282104', '2821', '0', 'luhe', '', '陆河', '54.00000', '', '23.30000', '115.70000', ''), ('101290101', '2901', '1', 'kunming', 'kunming', '昆明', '1897.00000', '', '25.05100', '102.70200', '650000'), ('101290103', '2901', '0', 'dongchuan', '', '东川', '1253.00000', '', '26.15400', '103.05200', '654100'), ('101290104', '2901', '0', 'xundian', '', '寻甸', '1874.00000', '', '25.33000', '103.16000', '655200'), ('101290105', '2901', '0', 'jinning', '', '晋宁', '1892.00000', '', '24.60100', '102.53100', '650600'), ('101290106', '2901', '0', 'yiliang', '', '宜良', '1533.00000', '', '24.55000', '103.10000', '652100'), ('101290107', '2901', '0', 'shilin', '', '石林', '1681.00000', '', '24.44000', '103.16000', '652200'), ('101290108', '2901', '0', 'chenggong', '', '呈贡', '1907.00000', '', '24.85800', '102.85000', '650500'), ('101290109', '2901', '0', 'fumin', '', '富民', '1693.00000', '', '25.37400', '102.56800', '650400'), ('101290110', '2901', '0', 'songming', '', '嵩明', '1920.00000', '', '25.27800', '102.99800', '651700'), ('101290111', '2901', '0', 'luquan', '', '禄劝', '1672.00000', '', '25.35000', '102.26000', '651500'), ('101290112', '2901', '0', 'anning', '', '安宁', '1847.00000', '', '24.81700', '102.39600', '650300'), ('101290113', '2901', '0', 'taihuashan', '', '太华山', '2367.00000', '', '24.57000', '102.37000', '650100'), ('101290201', '2902', '1', 'dali1', 'dali', '大理', '1992.00000', '', '25.69800', '100.15300', '671000'), ('101290202', '2902', '0', 'yunlong', '', '云龙', '1666.00000', '', '25.92400', '99.31500', '672700'), ('101290203', '2902', '0', 'yangbi', '', '漾濞', '1627.00000', '', '25.41000', '99.57000', '672500'), ('101290204', '2902', '0', 'yongping', '', '永平', '1618.00000', '', '25.40000', '99.61100', '672600'), ('101290205', '2902', '0', 'binchuan', '', '宾川', '1440.00000', '', '25.87400', '100.62600', '671600'), ('101290206', '2902', '0', 'midu', '', '弥渡', '1661.00000', '', '25.15600', '100.55900', '675600'), ('101290207', '2902', '0', 'xiangyun', '', '祥云', '2004.00000', '', '25.29000', '100.35000', '672100'), ('101290208', '2902', '0', 'weishan1', '', '巍山', '1744.00000', '', '25.22700', '100.30700', '672400'), ('101290209', '2902', '0', 'jianchuan', '', '剑川', '2192.00000', '', '26.43700', '99.76700', '671300'), ('101290210', '2902', '0', 'eryuan', '', '洱源', '2070.00000', '', '26.11900', '99.94700', '671200'), ('101290211', '2902', '0', 'heqing', '', '鹤庆', '2198.00000', '', '26.32800', '100.26400', '671500'), ('101290212', '2902', '0', 'nanjian', '', '南涧', '1406.00000', '', '25.03000', '100.32000', '675700'), ('101290301', '2903', '1', 'honghe', 'honghe', '红河', '972.00000', '', '23.26300', '102.22000', '654400'), ('101290302', '2903', '0', 'shiping', '', '石屏', '1420.00000', '', '23.70600', '102.42900', '662200'), ('101290303', '2903', '0', 'jianshui', '', '建水', '1310.00000', '', '23.70500', '102.88900', '654300'), ('101290304', '2903', '0', 'mile', '', '弥勒', '1416.00000', '', '24.25000', '103.43700', '652300'), ('101290305', '2903', '0', 'yuanyang1', '', '元阳', '256.00000', '', '23.10000', '102.45000', '662400'), ('101290306', '2903', '0', 'lvchun', '', '绿春', '1645.00000', '', '23.00000', '102.24000', '662500'), ('101290307', '2903', '0', 'kaiyuan1', '', '开远', '1056.00000', '', '23.42000', '103.15000', '661600'), ('101290308', '2903', '0', 'gejiu', '', '个旧', '1689.00000', '', '23.31600', '103.14700', '661400'), ('101290309', '2903', '0', 'mengzi', '', '蒙自', '1305.00000', '', '23.30200', '103.51400', '661100'), ('101290310', '2903', '0', 'pingbian', '', '屏边', '1412.00000', '', '22.59000', '103.41000', '661200'), ('101290311', '2903', '0', 'luxi1', '', '泸西', '1705.00000', '', '24.32000', '103.46000', '652400'), ('101290312', '2903', '0', 'jinping1', '', '金平', '1261.00000', '', '26.58600', '109.10600', '661500'), ('101290313', '2903', '0', 'hekou1', '', '河口', '138.00000', '', '22.30000', '103.57000', '661300'), ('101290401', '2904', '1', 'qujing', 'qujing', '曲靖', '1906.00000', '', '25.48700', '103.79300', '655000'), ('101290402', '2904', '0', 'zhanyi', '', '沾益', '1900.00000', '', '25.35000', '103.50000', '655500'), ('101290403', '2904', '0', 'luliang', '', '陆良', '1846.00000', '', '25.03800', '103.71300', '655600'), ('101290404', '2904', '0', 'fuyuan1', '', '富源', '1853.00000', '', '25.40000', '104.15000', '655500'), ('101290405', '2904', '0', 'malong', '', '马龙', '2037.00000', '', '25.37800', '103.50700', '655100'), ('101290406', '2904', '0', 'shizong', '', '师宗', '1846.00000', '', '24.67600', '104.13900', '655700'), ('101290407', '2904', '0', 'luoping', '', '罗平', '1483.00000', '', '24.96800', '104.32700', '655800'), ('101290408', '2904', '0', 'huize', '', '会泽', '2113.00000', '', '26.43100', '103.48300', '654200'), ('101290409', '2904', '0', 'xuanwei', '', '宣威', '1984.00000', '', '26.13000', '104.05000', '655400'), ('101290501', '2905', '1', 'baoshan1', 'baoshan', '保山', '1655.00000', '', '25.11800', '99.15600', '678000'), ('101290503', '2905', '0', 'longling', '', '龙陵', '1529.00000', '', '24.48300', '98.80800', '678300'), ('101290504', '2905', '0', 'sidian', '', '施甸', '1470.00000', '', '24.44000', '99.11000', '678200'), ('101290505', '2905', '0', 'changning2', '', '昌宁', '1660.00000', '', '24.72000', '99.66200', '678100'), ('101290506', '2905', '0', 'tengchong', '', '腾冲', '1655.00000', '', '25.24400', '98.43300', '679100'), ('101290601', '2906', '1', 'wenshan', 'wenshan', '文山', '1273.00000', '', '23.40900', '104.07300', '663000'), ('101290602', '2906', '0', 'xichou', '', '西畴', '1528.00000', '', '23.27000', '104.41000', '663500'), ('101290603', '2906', '0', 'maguan', '', '马关', '1335.00000', '', '22.95900', '104.26700', '663700'), ('101290604', '2906', '0', 'malipo', '', '麻栗坡', '1092.00000', '', '23.18600', '104.92400', '663600'), ('101290605', '2906', '0', 'yanshan1', '', '砚山', '1556.00000', '', '23.37000', '104.20000', '663100'), ('101290606', '2906', '0', 'qiubei', '', '丘北', '1453.00000', '', '24.10700', '104.07300', '663200'), ('101290607', '2906', '0', 'guangnan', '', '广南', '1251.00000', '', '23.98100', '105.05400', '663300'), ('101290608', '2906', '0', 'funing2', '', '富宁', '690.00000', '', '23.39000', '105.38000', '663400'), ('101290701', '2907', '1', 'yuxi', 'yuxi', '玉溪', '1638.00000', '', '24.35200', '102.54100', '653100'), ('101290702', '2907', '0', 'chengjiang', '', '澄江', '1747.00000', '', '24.40000', '102.54000', '652500'), ('101290703', '2907', '0', 'jiangchuan', '', '江川', '1732.00000', '', '24.36100', '102.74700', '652600'), ('101290704', '2907', '0', 'tonghai', '', '通海', '1808.00000', '', '24.08300', '102.69600', '652700'), ('101290705', '2907', '0', 'huaning', '', '华宁', '1610.00000', '', '24.27800', '102.97900', '652800'), ('101290706', '2907', '0', 'xinping', '', '新平', '1495.00000', '', '24.04000', '101.58000', '653400'), ('101290707', '2907', '0', 'yimen', '', '易门', '1576.00000', '', '24.70200', '102.11300', '651100'), ('101290708', '2907', '0', 'eshan', '', '峨山', '1540.00000', '', '24.11000', '102.24000', '653200'), ('101290709', '2907', '0', 'yuanjiang1', '', '元江', '398.00000', '', '28.94800', '112.59700', '653300'), ('101290801', '2908', '1', 'chuxiong', 'chuxiong', '楚雄', '1773.00000', '', '25.03300', '101.54000', '675000'), ('101290802', '2908', '0', 'dayao', '', '大姚', '1880.00000', '', '25.97300', '101.27800', '675400'), ('101290803', '2908', '0', 'yuanmou', '', '元谋', '1121.00000', '', '25.74700', '101.85800', '651300'), ('101290804', '2908', '0', 'yaoan', '', '姚安', '1875.00000', '', '25.32000', '101.26000', '675300'), ('101290805', '2908', '0', 'mouding', '', '牟定', '1769.00000', '', '25.20000', '101.31000', '675500'), ('101290806', '2908', '0', 'nanhua', '', '南华', '1859.00000', '', '25.03800', '101.22800', '675200'), ('101290807', '2908', '0', 'wuding', '', '武定', '1712.00000', '', '25.76200', '102.20100', '651600'), ('101290808', '2908', '0', 'lufeng1', '', '禄丰', '1570.00000', '', '25.09000', '102.04000', '651200'), ('101290809', '2908', '0', 'shuangbai', '', '双柏', '1969.00000', '', '24.56900', '101.54600', '675100'), ('101290810', '2908', '0', 'yongren', '', '永仁', '1531.00000', '', '26.17400', '101.56800', '651400'), ('101290901', '2909', '1', 'puer', '', '普洱', '1303.00000', '', '22.76700', '101.08300', '665000'), ('101290902', '2909', '0', 'jinggu', '', '景谷', '914.00000', '', '23.30000', '100.42000', '666400'), ('101290903', '2909', '0', 'jingdong', '', '景东', '1164.00000', '', '24.28000', '100.52000', '676200'), ('101290904', '2909', '0', 'lancang', '', '澜沧', '1054.00000', '', '22.34000', '99.56000', '665600'), ('101290906', '2909', '0', 'mojiang', '', '墨江', '1283.00000', '', '23.26000', '101.43000', '654800'), ('101290907', '2909', '0', 'jiangcheng', '', '江城', '1121.00000', '', '22.35000', '101.51000', '665900'), ('101290908', '2909', '0', 'menglian', '', '孟连', '951.00000', '', '22.20000', '99.37000', '665800'), ('101290909', '2909', '0', 'ximeng', '', '西盟', '1900.00000', '', '22.44000', '99.27000', '665700'), ('101290911', '2909', '0', 'zhenyuan3', '', '镇沅', '1248.00000', '', '23.53000', '100.53000', '666500'), ('101290912', '2909', '0', 'ninger', '', '宁洱', '1321.00000', '', '23.02000', '101.17000', '665100'), ('101291001', '2910', '1', 'zhaotong', 'shaotong', '昭通', '1950.00000', '', '27.34000', '103.71900', '657000'), ('101291002', '2910', '0', 'ludian', '', '鲁甸', '1916.00000', '', '27.25800', '103.41100', '657100'), ('101291003', '2910', '0', 'yiliang1', '', '彝良', '880.00000', '', '27.38000', '104.03000', '657600'), ('101291004', '2910', '0', 'zhenxiong', '', '镇雄', '1668.00000', '', '27.55900', '104.80400', '657200'), ('101291005', '2910', '0', 'weixin', '', '威信', '1173.00000', '', '27.90500', '105.00300', '657900'), ('101291006', '2910', '0', 'qiaojia', '', '巧家', '841.00000', '', '26.98200', '103.15100', '654600'), ('101291007', '2910', '0', 'suijiang', '', '绥江', '413.00000', '', '28.51300', '104.02800', '657700'), ('101291008', '2910', '0', 'yongshan', '', '永善', '877.00000', '', '28.01500', '103.64200', '657300'), ('101291009', '2910', '0', 'yanjin1', '', '盐津', '483.00000', '', '28.04000', '104.15000', '657500'), ('101291010', '2910', '0', 'daguan', '', '大关', '1064.00000', '', '27.91500', '103.90900', '657400'), ('101291011', '2910', '0', 'shuifu', '', '水富', '337.00000', '', '28.63000', '104.40700', '657800'), ('101291101', '2911', '1', 'lincang', 'lincang', '临沧', '1464.00000', '', '23.90000', '100.03300', '677000'), ('101291102', '2911', '0', 'cangyuan', '', '沧源', '1281.00000', '', '23.09000', '99.16000', '677400'), ('101291103', '2911', '0', 'gengma', '', '耿马', '1105.00000', '', '23.33000', '99.24000', '677500'), ('101291104', '2911', '0', 'shuangjiang', '', '双江', '1043.00000', '', '23.28000', '99.48000', '677300'), ('101291105', '2911', '0', 'fengqing', '', '凤庆', '1589.00000', '', '24.63300', '99.87000', '675900'), ('101291106', '2911', '0', 'yongde', '', '永德', '1607.00000', '', '24.10200', '99.46800', '677600'), ('101291107', '2911', '0', 'yunxian1', '', '云县', '1108.00000', '', '24.27000', '100.08000', '675800'), ('101291108', '2911', '0', 'zhenkang', '', '镇康', '1009.00000', '', '23.94400', '99.02000', '677700'), ('101291201', '2912', '1', 'nujiang', 'lujiang', '怒江', '1596.00000', '', '27.45000', '98.40000', '673100'), ('101291203', '2912', '0', 'fugong', '', '福贡', '1191.00000', '', '26.99400', '98.86200', '673400'), ('101291204', '2912', '0', 'lanping', '', '兰坪', '2345.00000', '', '26.25000', '99.25000', '671400'), ('101291205', '2912', '0', 'lushui', '', '泸水', '1804.00000', '', '26.03800', '98.86000', '673200'), ('101291206', '2912', '0', 'liuku', '', '六库', '901.00000', '', '26.52000', '98.51000', '673100'), ('101291207', '2912', '0', 'gongshan', '', '贡山', '1596.00000', '', '27.45000', '98.40000', '673500'), ('101291301', '2913', '0', 'xianggelila', 'xianggelila', '香格里拉', '3278.00000', '', '27.81500', '99.70400', '674400'), ('101291302', '2913', '0', 'deqin', '', '德钦', '3320.00000', '', '28.27000', '98.53000', '674500'), ('101291303', '2913', '0', 'weixi', '', '维西', '2325.00000', '', '27.10000', '99.17000', '674600'), ('101291304', '2913', '0', 'zhongdian', '', '中甸', '3278.00000', '', '27.81500', '99.70400', '674400'), ('101291401', '2914', '1', 'lijiang', 'lijiang', '丽江', '2394.00000', '', '26.90300', '100.22200', '674100'), ('101291402', '2914', '0', 'yongsheng', '', '永胜', '2131.00000', '', '26.53300', '100.78500', '674200'), ('101291403', '2914', '0', 'huaping', '', '华坪', '1242.00000', '', '26.65600', '101.24900', '617300'), ('101291404', '2914', '0', 'ninglang', '', '宁蒗', '2242.00000', '', '27.18000', '100.51000', '674300'), ('101291501', '2915', '1', 'dehong', 'dehong', '德宏', '915.00000', '', '24.26000', '98.35000', '678400'), ('101291503', '2915', '0', 'longchuan1', '', '陇川', '968.00000', '', '24.22000', '97.57000', '678700'), ('101291504', '2915', '0', 'yingjiang', '', '盈江', '828.00000', '', '24.86800', '97.89900', '679300'), ('101291506', '2915', '0', 'ruili', '', '瑞丽', '776.00000', '', '24.01000', '97.78900', '678600'), ('101291507', '2915', '0', 'lianghe', '', '梁河', '1013.00000', '', '24.73700', '98.33800', '679200'), ('101291508', '2915', '0', 'luxi2', '', '潞西', '915.00000', '', '24.26000', '98.35000', '678400'), ('101291601', '2916', '0', 'jinghong', '', '景洪', '554.00000', '', '22.02300', '100.97100', '666100'), ('101291603', '2916', '0', 'menghai', '', '勐海', '1177.00000', '', '21.99000', '100.31900', '666200'), ('101291605', '2916', '0', 'mengla', '', '勐腊', '633.00000', '', '21.77700', '101.46900', '666300'), ('101300101', '3001', '1', 'nanning', 'nanning', '南宁', '126.00000', '', '22.83800', '108.29500', '530000'), ('101300103', '3001', '0', 'yongning1', '', '邕宁', '79.00000', '', '22.46000', '108.29000', '530200'), ('101300104', '3001', '0', 'hengxian', '', '横县', '77.00000', '', '22.42000', '109.15000', '530300'), ('101300105', '3001', '0', 'longan', '', '隆安', '101.00000', '', '23.11000', '107.42000', '532700'), ('101300106', '3001', '0', 'mashan', '', '马山', '174.00000', '', '23.72200', '108.09900', '530600'), ('101300107', '3001', '0', 'shanglin', '', '上林', '117.00000', '', '23.49900', '108.61900', '530500'), ('101300108', '3001', '0', 'wuming', '', '武鸣', '115.00000', '', '23.22900', '108.22500', '530100'), ('101300109', '3001', '0', 'binyang', '', '宾阳', '126.00000', '', '23.18000', '108.89400', '530400'), ('101300201', '3002', '1', 'chongzuo', '', '崇左', '107.00000', '', '22.33300', '107.33300', '532200'), ('101300202', '3002', '0', 'tiandeng', '', '天等', '438.00000', '', '23.09000', '107.07000', '532800'), ('101300203', '3002', '0', 'longzhou', '', '龙州', '130.00000', '', '22.45100', '106.88500', '532400'), ('101300204', '3002', '0', 'pingxiang2', '', '凭祥', '243.00000', '', '22.06000', '106.45000', '532600'), ('101300205', '3002', '0', 'daxin', '', '大新', '258.00000', '', '22.79800', '107.08000', '532300'), ('101300206', '3002', '0', 'fusui', '', '扶绥', '92.00000', '', '22.56900', '107.81700', '532100'), ('101300207', '3002', '0', 'ningming', '', '宁明', '163.00000', '', '21.99000', '107.29500', '532500'), ('101300301', '3003', '1', 'liuzhou', 'liuzhou', '柳州', '98.00000', '', '24.31500', '109.37300', '545000'), ('101300302', '3003', '0', 'liucheng', '', '柳城', '107.00000', '', '24.63400', '109.21700', '545200'), ('101300304', '3003', '0', 'luzhai', '', '鹿寨', '95.00000', '', '24.53600', '109.81600', '545600'), ('101300305', '3003', '0', 'liujiang', '', '柳江', '102.00000', '', '24.20600', '109.32900', '545100'), ('101300306', '3003', '0', 'rongan', '', '融安', '122.00000', '', '25.13000', '109.24000', '545400'), ('101300307', '3003', '0', 'rongshui', '', '融水', '123.00000', '', '25.05000', '109.15000', '545300'), ('101300308', '3003', '0', 'sanjiang', '', '三江', '198.00000', '', '25.47000', '109.36000', '545500'), ('101300401', '3004', '1', 'laibin', '', '来宾', '85.00000', '', '23.67200', '109.15800', '546100'), ('101300402', '3004', '0', 'xicheng', '', '忻城', '139.00000', '', '24.04000', '108.39000', '546200'), ('101300403', '3004', '0', 'jinxiu', '', '金秀', '774.00000', '', '24.08000', '110.11000', '545700'), ('101300404', '3004', '0', 'xiangzhou', '', '象州', '91.00000', '', '23.58000', '109.41000', '545800'), ('101300405', '3004', '0', 'wuxuan', '', '武宣', '70.00000', '', '23.61900', '109.68600', '545900'), ('101300406', '3004', '0', 'heshan1', '', '合山', '312.00000', '', '23.80200', '108.87400', '546500'), ('101300501', '3005', '1', 'guilin', 'guilin', '桂林', '166.00000', '', '25.28100', '110.27700', '541000'), ('101300503', '3005', '0', 'longsheng', '', '龙胜', '269.00000', '', '25.48000', '110.00000', '541700'), ('101300504', '3005', '0', 'yongfu', '', '永福', '157.00000', '', '25.03500', '109.92000', '541800'), ('101300505', '3005', '0', 'lingui', '', '临桂', '158.00000', '', '25.25600', '110.04600', '541100'), ('101300506', '3005', '0', 'xingan1', 'xingan', '兴安', '224.00000', '', '25.37000', '110.40000', '541300'), ('101300507', '3005', '0', 'lingchuan1', '', '灵川', '169.00000', '', '25.25000', '110.19000', '541200'), ('101300508', '3005', '0', 'quanzhou3', '', '全州', '197.00000', '', '25.56000', '111.04000', '541500'), ('101300509', '3005', '0', 'guanyang', '', '灌阳', '259.00000', '', '25.46800', '111.02500', '541600'), ('101300510', '3005', '0', 'yangshuo', '', '阳朔', '135.00000', '', '24.84800', '110.44600', '541900'), ('101300511', '3005', '0', 'gongcheng', '', '恭城', '168.00000', '', '24.50000', '110.49000', '542500'), ('101300512', '3005', '0', 'pingle', '', '平乐', '105.00000', '', '24.57400', '110.79500', '542400'), ('101300513', '3005', '0', 'lipu', '', '荔浦', '168.00000', '', '24.52100', '110.38000', '546600'), ('101300514', '3005', '0', 'ziyuan', '', '资源', '409.00000', '', '26.05200', '110.59600', '541400'), ('101300601', '3006', '1', 'wuzhou', '', '梧州', '117.00000', '', '23.47700', '111.31500', '543000'), ('101300602', '3006', '0', 'tengxian', '', '藤县', '59.00000', '', '23.22000', '110.55000', '543300'), ('101300604', '3006', '0', 'cangwu', '', '苍梧', '45.00000', '', '23.80200', '111.25500', '543100'), ('101300605', '3006', '0', 'mengshan', '', '蒙山', '147.00000', '', '24.12100', '110.53700', '546700'), ('101300606', '3006', '0', 'cenxi', '', '岑溪', '100.00000', '', '22.91100', '111.05000', '543200'), ('101300607', '3006', '0', 'changzhou1', '', '长洲', '0.00000', '', '0.00000', '0.00000', ''), ('101300701', '3007', '1', 'hezhou', '', '贺州', '110.00000', '', '24.25000', '111.31000', '542800'), ('101300702', '3007', '0', 'zhaoping', '', '昭平', '108.00000', '', '24.02400', '110.93900', '546800'), ('101300703', '3007', '0', 'fuchuan', '', '富川', '194.00000', '', '24.49000', '111.16000', '542700'), ('101300704', '3007', '0', 'zhongshan1', '', '钟山', '138.00000', '', '24.33000', '111.19000', '542600'), ('101300801', '3008', '1', 'guigang', '', '贵港', '56.00000', '', '23.04600', '109.54200', '537100'), ('101300802', '3008', '0', 'guiping', '', '桂平', '48.00000', '', '23.33600', '110.03800', '537200'), ('101300803', '3008', '0', 'pingnan1', '', '平南', '38.00000', '', '23.53900', '110.39200', '537300'), ('101300901', '3009', '1', 'yulin1', '', '玉林', '85.00000', '', '22.63200', '110.14800', '537000'), ('101300902', '3009', '0', 'bobai', '', '博白', '70.00000', '', '22.05800', '109.92100', '537600'), ('101300903', '3009', '0', 'beiliu', '', '北流', '103.00000', '', '22.53300', '110.45700', '537400'), ('101300904', '3009', '0', 'rongxian1', '', '容县', '97.00000', '', '22.51000', '110.32000', '537500'), ('101300905', '3009', '0', 'luchuan', '', '陆川', '121.00000', '', '22.24100', '110.25100', '537700'), ('101300906', '3009', '0', 'xingye', '', '兴业', '157.00000', '', '22.74800', '109.86800', '537800'), ('101301001', '3010', '1', 'baise', '', '百色', '176.00000', '', '23.92000', '106.52500', '533000'), ('101301002', '3010', '0', 'napo', '', '那坡', '795.00000', '', '23.22600', '105.81200', '533900'), ('101301003', '3010', '0', 'tianyang', '', '田阳', '110.00000', '', '23.80600', '106.92900', '533600'), ('101301004', '3010', '0', 'debao', '', '德保', '636.00000', '', '23.34700', '106.56900', '533700'), ('101301005', '3010', '0', 'jingxi', '', '靖西', '740.00000', '', '23.21700', '106.37300', '533800'), ('101301006', '3010', '0', 'tiandong', '', '田东', '112.00000', '', '23.64300', '107.16000', '531500'), ('101301007', '3010', '0', 'pingguo', '', '平果', '110.00000', '', '23.54900', '107.59000', '531400'), ('101301008', '3010', '0', 'longlin', '', '隆林', '674.00000', '', '24.47000', '105.20000', '533400'), ('101301009', '3010', '0', 'xilin', '', '西林', '722.00000', '', '24.30000', '105.06000', '533500'), ('101301010', '3010', '0', 'leye', '', '乐业', '973.00000', '', '24.83000', '106.49200', '533200'), ('101301011', '3010', '0', 'lingyun', '', '凌云', '439.00000', '', '24.36100', '106.65900', '533100'), ('101301012', '3010', '0', 'tianlin', '', '田林', '282.00000', '', '24.37600', '105.98800', '533300'), ('101301101', '3011', '1', 'qinzhou', '', '钦州', '6.00000', '', '21.95600', '108.61500', '535000'), ('101301102', '3011', '0', 'pubei', '', '浦北', '69.00000', '', '22.28200', '109.54700', '535300'), ('101301103', '3011', '0', 'lingshan', '', '灵山', '70.00000', '', '22.25300', '109.12300', '535400'), ('101301201', '3012', '1', 'hechi', '', '河池', '211.00000', '', '24.69700', '107.83700', '547000'), ('101301202', '3012', '0', 'tiane', '', '天峨', '250.00000', '', '25.00000', '107.10000', '547300'), ('101301203', '3012', '0', 'donglan', '', '东兰', '286.00000', '', '24.53800', '107.40500', '547400'), ('101301204', '3012', '0', 'bama', '', '巴马', '253.00000', '', '24.18000', '107.15000', '547500'), ('101301205', '3012', '0', 'huanjiang', '', '环江', '206.00000', '', '24.50000', '108.15000', '547100'), ('101301206', '3012', '0', 'luocheng', '', '罗城', '329.00000', '', '24.45000', '108.54000', '546400'), ('101301207', '3012', '0', 'yizhou', '', '宜州', '150.00000', '', '24.29000', '108.40000', '546300'), ('101301208', '3012', '0', 'fengshan', '', '凤山', '486.00000', '', '24.54200', '106.98300', '547600'), ('101301209', '3012', '0', 'nandan', '', '南丹', '697.00000', '', '25.15400', '107.45000', '547200'), ('101301210', '3012', '0', 'andu', '', '都安', '174.00000', '', '23.56000', '108.06000', '530700'), ('101301211', '3012', '0', 'dahua', '', '大化', '339.00000', '', '23.74900', '107.99100', '530800'), ('101301301', '3013', '1', 'beihai', 'beihai', '北海', '13.00000', '', '21.48500', '109.10500', '536000'), ('101301302', '3013', '0', 'hepu', '', '合浦', '9.00000', '', '21.68100', '109.30900', '536100'), ('101301303', '3013', '0', 'weizhoudao', '', '涠洲岛', '55.00000', '', '21.02000', '109.06000', '536004'), ('101301401', '3014', '1', 'fangchenggang', '', '防城港', '14.00000', '', '21.69000', '108.35200', '535600'), ('101301402', '3014', '0', 'shangsi', '', '上思', '184.00000', '', '22.04900', '107.90900', '535500'), ('101301403', '3014', '0', 'dongxing1', '', '东兴', '23.00000', '', '21.32000', '107.58000', '538100'), ('101301405', '3014', '0', 'fangcheng1', '', '防城', '31.00000', '', '21.76900', '108.35400', '535600'), ('101310101', '3101', '1', 'haikou', 'haikou', '海口', '18.00000', '', '20.03900', '110.34300', '570000'), ('101310201', '3102', '1', 'sanya', 'sanya', '三亚', '7.00000', '', '18.28900', '109.44700', '572000'), ('101310202', '3102', '1', 'dongfang', '', '东方', '12.00000', '', '19.06000', '108.37000', '572600'), ('101310203', '3102', '1', 'lingao', '', '临高', '32.00000', '', '19.79200', '109.70100', '571800'), ('101310204', '3102', '1', 'chengmai', '', '澄迈', '32.00000', '', '19.69100', '109.98800', '571900'), ('101310205', '3102', '1', 'danzhou', '', '儋州', '169.00000', '', '19.31000', '109.35000', '571700'), ('101310206', '3102', '1', 'changjiang', '', '昌江', '102.00000', '', '19.16000', '109.03000', '572700'), ('101310207', '3102', '1', 'baisha', '', '白沙', '221.00000', '', '19.14000', '109.26000', '572800'), ('101310208', '3102', '1', 'qiongzhong', '', '琼中', '249.00000', '', '19.02000', '109.50000', '572900'), ('101310209', '3102', '1', 'dingan', '', '定安', '25.00000', '', '19.42000', '110.20000', '571200'), ('101310210', '3102', '1', 'tunchang', '', '屯昌', '119.00000', '', '19.36600', '110.03100', '571600'), ('101310211', '3102', '1', 'qionghai', '', '琼海', '27.00000', '', '19.22300', '110.39500', '571400'), ('101310212', '3102', '1', 'wenchang', '', '文昌', '26.00000', '', '19.75900', '110.75000', '571300'), ('101310214', '3102', '1', 'baoting', '', '保亭', '66.00000', '', '18.39000', '109.42000', '572300'), ('101310215', '3102', '1', 'wanning', '', '万宁', '10.00000', '', '18.84600', '110.28500', '571500'), ('101310216', '3102', '1', 'lingshui', '', '陵水', '15.00000', '', '18.30000', '110.02000', '572400'), ('101310217', '3102', '1', 'xisha', '', '西沙', '5.00000', '', '16.50000', '112.20000', '573100'), ('101310220', '3102', '1', 'nanshadao', '', '南沙', '5.00000', '', '10.23000', '114.22000', '573101'), ('101310221', '3102', '1', 'ledong', '', '乐东', '164.00000', '', '18.45000', '109.10000', '572500'), ('101310222', '3102', '1', 'wuzhishan', '', '五指山', '329.00000', '', '18.46000', '109.31000', '572200'), ('101320101', '3201', '1', 'hongkong', 'hongkong', '香港', '79.00000', '', '22.30700', '114.17700', '999077'), ('101320103', '3201', '0', 'xinjie', '', '新界', '33.00000', '', '22.38100', '114.18800', '999077'), ('101330101', '3301', '1', 'aomen', 'macau', '澳门', '59.00000', '', '22.20200', '113.54400', '999078'), ('101330102', '3301', '0', 'dangzidao', '', '氹仔岛', '59.00000', '', '22.20200', '113.54400', ''), ('101330103', '3301', '0', 'luhuandao', '', '路环岛', '59.00000', '', '22.20200', '113.54400', ''), ('101340101', '3401', '1', 'taibei', 'taibei', '台北', '9.00000', '', '25.04000', '121.51600', '000222'), ('101340102', '3401', '0', 'taoyuan1', 'taoyuan', '桃园', '97.00000', '', '24.99800', '121.30600', ''), ('101340103', '3401', '0', 'xinzhu', 'xinzhu', '新竹', '27.00000', '', '24.80900', '120.95800', ''), ('101340104', '3401', '0', 'yilan1', 'yilan', '宜兰', '23.00000', '', '24.75700', '121.74100', ''), ('101340201', '3402', '1', 'gaoxiong', 'gaoxiong', '高雄', '33.00000', '', '22.61900', '120.27600', '000800'), ('101340202', '3402', '0', 'jiayi', '', '嘉义', '112.00000', '', '23.48700', '120.44100', ''), ('101340203', '3402', '0', 'tainan', 'tainan', '台南', '18.00000', '', '23.00400', '120.20000', ''), ('101340204', '3402', '0', 'taidong', 'taidong', '台东', '33.00000', '', '22.76400', '121.15100', ''), ('101340205', '3402', '0', 'pingdong', 'pingdong', '屏东', '23.00000', '', '22.68200', '120.48500', ''), ('101340401', '3404', '1', 'taizhong', 'taizhong', '台中', '78.00000', '', '24.14400', '120.67000', '000400'), ('101340402', '3404', '0', 'miaoli', 'miaoli', '苗栗', '73.00000', '', '24.55800', '120.81200', ''), ('101340403', '3404', '0', 'zhanghua', 'zhanghua', '彰化', '79.00000', '', '24.07700', '120.53500', ''), ('101340404', '3404', '0', 'nantou', 'nantou', '南投', '92.00000', '', '23.91600', '120.68500', ''), ('101340405', '3404', '0', 'hualian', 'hualian', '花莲', '75.00000', '', '23.98300', '121.60300', ''), ('101340406', '3404', '0', 'yunlin', 'yunlin', '云林', '34.00000', '', '23.71800', '120.53800', '');
COMMIT;

-- ----------------------------
--  Table structure for `province`
-- ----------------------------
DROP TABLE IF EXISTS `province`;
CREATE TABLE `province` (
  `id` bigint(20) NOT NULL,
  `ishot` int(11) NOT NULL,
  `pinyin` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  `title` varchar(30) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Records of `province`
-- ----------------------------
BEGIN;
INSERT INTO `province` VALUES ('1', '0', 'beijing', '北京'), ('2', '0', 'shanghai', '上海'), ('3', '0', 'tianjin', '天津'), ('4', '0', 'chongqing', '重庆'), ('5', '0', 'heilongjiang', '黑龙江'), ('6', '0', 'jilin', '吉林'), ('7', '0', 'liaoning', '辽宁'), ('8', '0', 'neimenggu', '内蒙古'), ('9', '0', 'hebei', '河北'), ('10', '0', 'shanxi', '山西'), ('11', '0', 'shanxi1', '陕西'), ('12', '0', 'shandong', '山东'), ('13', '0', 'xinjiang', '新疆'), ('14', '0', 'xicang', '西藏'), ('15', '0', 'qinghai', '青海'), ('16', '0', 'gansu', '甘肃'), ('17', '0', 'ningxia', '宁夏'), ('18', '0', 'henan', '河南'), ('19', '0', 'jiangsu', '江苏'), ('20', '0', 'hubei', '湖北'), ('21', '0', 'zhejiang', '浙江'), ('22', '0', 'anhui', '安徽'), ('23', '0', 'fujian', '福建'), ('24', '0', 'jiangxi', '江西'), ('25', '0', 'hunan', '湖南'), ('26', '0', 'guizhou', '贵州'), ('27', '0', 'sichuan', '四川'), ('28', '0', 'guangdong', '广东'), ('29', '0', 'yunnan', '云南'), ('30', '0', 'guangxi', '广西'), ('31', '0', 'hainan', '海南'), ('32', '0', 'hongkong', '香港'), ('33', '0', 'aomen', '澳门'), ('34', '0', 'taiwan', '台湾');
COMMIT;

-- ----------------------------
--  Table structure for `station`
-- ----------------------------
DROP TABLE IF EXISTS `station`;
CREATE TABLE `station` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name_zh` varchar(30) DEFAULT NULL,
  `name_en` varchar(50) DEFAULT NULL,
  `district` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `t_admin`
-- ----------------------------
DROP TABLE IF EXISTS `t_admin`;
CREATE TABLE `t_admin` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `avatar_url` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `url`
-- ----------------------------
DROP TABLE IF EXISTS `url`;
CREATE TABLE `url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `update_time` datetime DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Table structure for `weather_forecast`
-- ----------------------------
DROP TABLE IF EXISTS `weather_forecast`;
CREATE TABLE `weather_forecast` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `district` bigint(20) NOT NULL,
  `max` int(11) NOT NULL,
  `min` int(11) NOT NULL,
  `update_time` datetime DEFAULT NULL,
  `sunrise` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `sunset` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `wind_direction_day` int(11) DEFAULT NULL,
  `wind_direction_night` int(11) DEFAULT NULL,
  `weather_day` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `weather_night` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `wind_force_day` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  `wind_force_night` varchar(10) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Table structure for `weather_history`
-- ----------------------------
DROP TABLE IF EXISTS `weather_history`;
CREATE TABLE `weather_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `city` bigint(20) NOT NULL,
  `date` date DEFAULT NULL,
  `max` int(11) NOT NULL,
  `min` int(11) NOT NULL,
  `update_time` datetime DEFAULT NULL,
  `weather` varchar(20) COLLATE utf8_bin DEFAULT NULL,
  `wind_direction` varchar(20) COLLATE utf8_bin DEFAULT NULL,
  `wind_force` varchar(20) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Table structure for `weather_hour`
-- ----------------------------
DROP TABLE IF EXISTS `weather_hour`;
CREATE TABLE `weather_hour` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `aqi` int(11) NOT NULL,
  `datetime` datetime DEFAULT NULL,
  `district` bigint(20) NOT NULL,
  `humidity` int(11) NOT NULL,
  `precipitation` decimal(11,3) NOT NULL,
  `temperature` int(11) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `wind_direction` int(11) DEFAULT NULL,
  `wind_force` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
--  Table structure for `weather_instant`
-- ----------------------------
DROP TABLE IF EXISTS `weather_instant`;
CREATE TABLE `weather_instant` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `temperature_sensible` decimal(11,3) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `temperature` decimal(11,3) DEFAULT NULL,
  `precipitation` decimal(11,3) DEFAULT NULL,
  `humidity` int(11) DEFAULT NULL,
  `aqi` int(11) DEFAULT NULL,
  `district` bigint(20) DEFAULT NULL,
  `wind_direction` int(11) DEFAULT NULL,
  `wind_force` int(11) DEFAULT NULL,
  `weather` int(11) DEFAULT NULL,
  `pm25` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;
