/**
   Automatically generated by Drizzle 0.14.3 dependency helper tool, based on the selected
   at 2022-07-28T10:29:43.579Z board options in Arduino IDE's UI. To apply them make sure this file is saved, then click on
   Tools -> Drizzle -> Apply Markers. To obtain Drizzle visit: https://github.com/zhgzhg/Drizzle

   @BoardManager esp8266::^3.1.2::https://arduino.esp8266.com/stable/package_esp8266com_index.json
   @Board esp8266::esp8266::NodeMCU 1.0 (ESP-12E Module)
   @BoardSettings esp8266::NodeMCU 1.0 (ESP-12E Module)::Builtin Led->2||Upload Speed->115200
   @DependsOn RadioLib::^6.3.0
   @ArduinoTool Drizzle::(<0.16.2)::https://github.com/zhgzhg/Drizzle/releases/download/0.16.2/drizzle-0.16.2-dist.zip


   RadioLib Transmit Example - desiged for use with the default sample JSON configuration of the LoRaPacketForwarder.

   This example transmits LoRa packets with one second delays between them. Each packet contains up to 255 bytes
   of data, in the form of:
    - Arduino String
    - null-terminated char array (C-string)
    - arbitrary binary data (byte array)

   ATTENTION - this sketch exemplifies a transmission with a sync-word value set to LoRaWAN, but the sent data
   and the transmission frequency is NOT compatible with the LoRaWAN specification. For compatible examples please
   refer to those provided by RadioLib.
   The purpose of this sketch is to provide means for easy checking whether your current hardware and software setup
   is able to exchange data over LoRa.

   For more detailed information, see the LoRaLib Wiki
   https://github.com/jgromes/RadioLib/wiki

   For full API reference, see the GitHub Pages
   https://jgromes.github.io/RadioLib/
*/

#include <RadioLib.h>

// create instance of LoRa class using SX1278 module
// this pinout corresponds to RadioShield
// https://github.com/jgromes/RadioShield
// NSS pin:   10 (4 on ESP32/ESP8266 boards)
// DIO0 pin:  2
// DIO1 pin:  3

#define NSS  15  // GPIO15 i.e D8 = CHIP SELECT
#define DIO0  5  // GPIO5, i.e. D1
#define RESET 2  // GPIO2 i.e. D4, or use RADIOLIB_NC if it's not used
#define DIO1  4  // GPIO4

SX1278 lora = new Module(NSS, DIO0, RESET, DIO1);

static unsigned long pktNum = 0;

void logMsgAndProceedOnSuccess(const __FlashStringHelper* onSuccess, const __FlashStringHelper* onFailure, int state) {

  if (state == RADIOLIB_ERR_NONE) {
    Serial.println(onSuccess);
  } else {
    Serial.print(F("failed, code "));
    Serial.println(state);
    Serial.println(onFailure);
    while (true);
  }
}

void setup() {
  Serial.begin(115200);

  // initialize SX1278 with default settings
  Serial.print(F("Initializing... "));
  // carrier frequency:           434.0 MHz
  // bandwidth:                   125.0 kHz
  // spreading factor:            7
  // coding rate:                 4/5
  // sync word:                   0x34
  // output power:                14 dBm
  // current limit:               100 mA
  // preamble length:             8 symbols
  // amplifier gain:              0 (automatic gain control)
  // int state = lora.begin();

  lora.reset();
  int state = lora.begin(434.0f, 125.0f, 7, 5, 0x34, 14, 8, 0); // freq 434.0mhz, bw 125khz, sf 7, cr 5, sync-word 0x34 = lorawan, 14dBm transmit pw, preabmle 8, agc auto
  logMsgAndProceedOnSuccess(F("success!"), F("init failed"), state);

  Serial.print(F("Turning off IQ inverted transmissions... "));
  state = lora.invertIQ(false);
  logMsgAndProceedOnSuccess(F("success!"), F("IQ noninversion failed"), state);

  Serial.print(F("Turning on CRC in the packets... "));
  state = lora.setCRC(true);
  logMsgAndProceedOnSuccess(F("success!"), F("failed!"), state);

  Serial.print(F("Turning on explicit headers in the packets... "));
  state = lora.explicitHeader();
  logMsgAndProceedOnSuccess(F("success!"), F("failed to use explicit packet headers!"), state);
}

void loop() {
  String s = "Hello World! #";
  s += pktNum++;

  Serial.print(F("Sending packet... "));
  Serial.print(s);

  // you can transmit C-string or Arduino string up to
  // 255 characters long
  // NOTE: transmit() is a blocking method!
  //       See example TransmitInterrupt for details
  //       on non-blocking transmission method.

  int state = lora.transmit(s);

  // you can also transmit byte array up to 255 bytes long
  /*
    size_t len = 8;
    byte byteArr[len] = {0x01, 0x23, 0x45, 0x56,
                         0x78, 0xAB, 0xCD, 0xEF};
    int state = lora.transmit(byteArr, len);
  */

  if (state == RADIOLIB_ERR_NONE) {
    // the packet was successfully transmitted

    Serial.println(F(" - success!"));
    Serial.print(F("Datarate:\t"));
    Serial.print(lora.getDataRate());
    Serial.println(F(" bps"));

  } else if (state == RADIOLIB_ERR_PACKET_TOO_LONG) {
    // the supplied packet was longer than 255 bytes
    Serial.println(F(" - error, too long!"));

  } else if (state == RADIOLIB_ERR_TX_TIMEOUT) {
    // timeout occurred while transmitting packet

    Serial.println(F(" - error, timeout!"));
  } else {

    Serial.printf(" - error %d\n", state);
  }

  // wait a second before transmitting again
  delay(1000);
}
