<!-- readme.md v1.7.0.1
LanderTek (LTEK)
created: 17 Jul 2017
updated: 17 Jan 2023 -->

<!--this file: CC BY-ND 4.0 by zer0Kerbal-->

[![LanderTek (LTEK)][MOD:shd]][forum] [![KSP version][KSP:shd]][KSP:url]  [![License][LIC:shd]][LIC:url]  
[![Curseforge][CURSFG:shd]][CURSFG:url] [![GitHub][GITHUB:shd]][GITHUB:url] [![SpaceDock][SPCDCK:shd]][SPCDCK:url]  
[![CKAN][ckan:shd]][ckan:url] [![Pages][PAGES:shd]][pages]



# LanderTek (LTEK) by [Axial Aerospace][AAL]

Modular lander parts... for landing. This is a modular pack of 1.25m, 1.875m, and 2.5m lander parts for Kerbal Space Program.

## More Parts, More Possibilities

## By [`zer0Kerbal`][zer0Kerbal], originally by [`artwhaley`][artwhaley]

adopted with *express* permission and brought to you by *Axial Aerospace*

<img src="https://github.com/zer0Kerbal/LanderTek/blob/master/img/HeroLogo_1920x1920.png?raw=true" alt="LanderTek logo" width="500px" height="500px">

### Preamble by [artwhaley][artwhaley]

> New From Axial Aerospace...  A couple of parts to solve a hole in the stock lineup
>
> This is a modular pack of lander parts... It will eventually be a complete suite of pods, tanks, engines, decouplers, and legs for building everything from light probe landers to heavy manned missions with loads of science on board.
>
> It's always bugged me that the stock parts don't lend themselves to building compact realistic-ish' landers. Landers are built light and boxy with an emphasis on low COG's, lightweight parts, and plenty of good places to attach the gizmos they'll need on the surface. Nasa doesn't like trying to keep a 2.5m round, 12 m high lander from tipping over anymore than we do. These parts don't match the stock parts in terms of volume of fuel in volume of space... justify it by saying that lander parts are built lighter than launcher tanks and such... or... just don't worry about it! KSP is a game and the scale of things doesn't work out perfectly in it, but I think these parts are a good balance of realism/fun.
>
> Here's what's currently in the pack:
>
>* 2.5m, 3 man lander can . The exterior is finished, the interior is just a couple of RPM huds in the pilot's seat... the interior will eventually be fleshed out in the same near-future style as my dreamchaser IVA, but that's way down the line.
>* 2.5m stack that includes:
>* Upperstage with high TWR engine, fuel, monoprop, and integrated 5 way RCS Thrusters.
>* Lowerstage with low TWR engine and fuel
>* Slim decoupler
>* Undercarriage truss (also fits well on 1.875 engine part
>* Undercarriage truss with integrated legs (little buggy... but then, most single parts with multiple legs are....) and both surface and node attach points for science and miscellaneous
>* Additional 2.5m fuel tank for adding deltav to either stage
>* A 1.875m Single Stage engine module that includes onboard RCS thrusters and monoprop storage in addition to the main engine and fuel. Works great with the stock lander can and the ALCOR capsule!
>* A 1.25m stack that includes
>* Upperstage with high TWR engine, fuel, monoprop, and integrated 5 way RCS thrusters
>* Lowerstage with low TWR engine and fuel
>* Slim decoupler
>* additional 1.25m fuel tank for adding deltav to either stage
>* A 1.25m skycrane system that consists of -
>* Skycrane pod, with 4 integrated engines
>* Additional engine piece for adding 4 more offset engines for heavy payloads
>* Additional fuel tank for skycrane
>* RCS tank with integrated 5 way thrusters for orbital linkup with payloads
>* Docking port for skycrane payloads
>* Two landing legs - one that extends straight and one that folds away up for more clearance when stowed.
>* Smaller surface/node mountable versions of the goo container and materials bay - identical to stock but with cool new models and designed to mount to my lander undercarriages
>* Sample Return case - a cute little box that can store science experiment results. It still can only hold one of each experiment, but you can carry multiples! Put two of these on the upper stage and all your experiments on the lower stage and you can have your scientist run all experiments 3 times, putting one result in each container and carrying the third into the pod then leave all the heavy science equipment behind when you blast off! Or carry 8 cases with you and let a scientist biome hop several times before returning to an orbital lab to stash the data there!
>
> Planned- I'll be honest, I've been very slow on my modding lately, so it may be a long time before any of the planned features get into the pack, and i'd WELCOME help if anyone is interested in contributing.
>
>* 1.25m, two man command pod
>* Scaled down probe-sized science experiments
>* Tiny .675m probe lander system
>* More variety of lander legs
>* Heat shielded and aerodynamic set of lander parts for operating on planets with atmospheres!
>* And... maybe a Command and Service modules and set of docking ports that match the mod's aesthetic, so you can build a mission entirely out of it? Maybe not! There are a lot of good rocket parts out there and that's sort of scope creep from the idea of LANDER parts.
>
> When I say ascent and descent stages in the part descriptions... there's no reason they can't be combined in a lot of other ways or used as single stages, etc. It's just easier to describe them in Apollo lander style stacks. Ascent stages are a little smaller than descent stages. Ascent stages will have built in RCS. Descent stages will make certain to have places to attach landing gear. But there won't be anything stopping you from putting the ascent stage on bottom... or stacking three descent stages on top of each other... etc.
> The 2.5m command pod will eventually include 3 different seats with very different controls - a pilot with a lot of visibility, who gets flight and fuel data through huds, but not much else - a science and engineering station with action groups, cameras and other controls, and a docking module pilot's seat that faces up. I'll eventually release a docking port for the top of the pod that allows you to see through the top windows for visual approach to docking.
> These images are from the first development version. They show the old color scheme - this is still a WIP.

### See more

>* [ChangeLog][chlog] for more details of changes
>* [Discussions][discu] or [KSP Forums][forum] for discussions and news
>* [GitHub Pages][pages]
>* [Known Issues][issue] for more details of feature requests and known issues
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for part pictures

### Help Wanted

> * Compatibility patches
> * Contracts for these glorious parts
> * Variant Textures
> * Converting from FireSpitter to Stock and/or KSPWheel  
> * Model updates (add/improve lights, iva, hatches and so forth)
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README in the Localization folder][lreadme] for instructions for adding or improving translations. There is also the [quickstart guide][qstart]. [GitHub][GitHub:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Localization

>* ![English][EN] English
>* ***your translation here***

### Installation Directions [^1]

Use CurseForge/OverWolf Website/App

<a href="https://download.curseforge.com/"><img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" height="80px"></a>

or<a href="https://forum.kerbalspaceprogram.com/index.php?/topic/197082-*/"><img src="https://i.postimg.cc/x8XSVg4R/sj507JC.png" alt="CKAN App" height="75px"></a>

I take no part, nor am I interested in maintaining the [CKAN][ckan:url] metadata for my mods. [CKAN][ckan:url] is a great mod for those that can't use zip tools. If you are having issues please let the [CKAN][ckan:url] people know and refer to the [CKAN][ckan:url] thread. My support of [CKAN][ckan:url] extends with checking the checkbox in [SpaceDock][SPCDCK:url]. Beware, [CKAN][ckan:url] *can* really mess up; though it tries very, very, very hard not to.

### Dependencies

* [AxialAerospace Ltd (AA/L)][AAL]
* [Kerbal Space Program][KSP:url] [![Kerbal Space Program][KSP:shd]][KSP:url] [^2]

### Recommends

* by [Axial Aerospace Ltd (AAL)][AAL]
  * [Dreamer (DREAM)][DREAM]
  * [Simple Cargo Solutions (CARGO)][CARGO]
  * [WhimChaser (WHIM)][WHIM]

### Suggests

* [Adjustable Mod Panel (KAMP)][KAMP]
* [Biomatic (BIO)][BIO]
* [Docking Port Descriptions(DPD)][DPD]
* [Drop Tank Wrapper (DROP)][DROP]
* [Field Training Facility (FTF)][FTF]
* [Field Training Lab (FTL)][FTL]
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)][GPO]
* [Inflatable PicoPort (IPP)][IPP]
* [Kaboom! (BOOM)][BOOM]
* [Lithobrake Exploration Technologies (LET)][LET]
* [On Demand Fuel Cells (ODFC)][ODFC]
* [OScience Laboratories (OSL)][OSL]
* [Papa Kerballini's Pizza (PIZZA)][PIZZA]
* [Portable Science Container (PRC)][PRC]
* [Precise Maneuver (PM)][PM]
* [Shielded PicoPort (SPP)][SPP]
* [SimpleConstruction! (SCON)][SCON]
* [SimpleLogistics! (SLOG)][SLOG]
* [SimpleNotes! (NOTE)][NOTES]
* [Solar Science (SOL)][SOL]
* [Stack Inline Lights - Patches (SILP)][SILP]
* [Stack Inline Lights (SIL)][SIL]
* [Tweakscale (twk)][twk]
* [Kerbal Inventory System][kis]
* [Kerbal Joint Reinforcement][kjr]
* *either*
  * [Raster Prop Monitor][rpm]
  * [MOARdV's Avionics System][mas]

### Supports

* [On Demand Fuel Cells (ODFC)][ODFC]
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)][GPO]
* *either* [^3]
  * [Module Manager /L][mml]
  * [Module Manager][mm]
* *either*  for fully functioning wheels. may invoke bouts of dizziness.
  * [Firespitter core][fsc]
  * [Firespitter][fs]

### Tags

* career, config, crewed, parts, uncrewed, variants

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date</p>
</div>

### Credits and Special Thanks

* [artwhaley][artwhaley] for creating this glorious addon!
* see [Attribution][attrb] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Author (2) - [`zer0Kerbal`][zer0Kerbal]

> Forum: [Thread][forum] - Source: [GitHub][GITHUB:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]
>
> ##### Disclaimer(s)
>
> ***All bundled mods are distributed under their own licenses***  
> ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses***

##### see [Notices][notic] for more *legal Mumbo Jumbo*

#### Original (1) - Author: [`artwhaley`][artwhaley]

> Forum: [Thread][MOD:1:thread] - Download: [CurseForge][MOD:1:dnload] - Source: [CurseForge][MOD:1:source]  
> License: [![License][LIC:1:shd]][LIC:1:url] ![License][LIC:1:log]

#### Original (ROOT) (0) - Author: ['artwhaley'][artwhaley]

> Forum: [Thread][MOD:0:thread] - Download: [CurseForge][MOD:0:dnload] - Source: [CurseForge][MOD:0:source]
> License: [![License][LIC:0:shd]][LIC:0:url] ![License][LIC:0:log]

### How to support this and other great mods by [`zer0Kerbal`][zer0Kerbal]

> ***Completely voluntary, absolutely amazing, and really does help me out a lot!***  
> quote from <a href="https://forum.kerbalspaceprogram.com/index.php?/profile/32393-*/"><img src="https://kerbal-forum-uploads.s3.us-west-2.amazonaws.com/monthly_2020_06/kappa-kerbal-anarchy.thumb.png.673a2f6f7b36cc60a35c24efef217246.png" width="25px" height="25px" alt="cybutek" > cybutek</a> creator of <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/17833-130-*/" alt="Kerbal Engineer Redux (KER)"> Kerbal Engineer</a>

[![Support][PAYPAL:img]][PAYPAL:url] [![Github Sponsor][GSPONS:img]][GSPONS:url] [![Patreon][PATREON:img]][PATREON:url] [![Buy zer0Kerbal a snack][BMCC:img]][BMCC:url]

*and it is true.*
<!-- links -->
[attrb]: https://zer0kerbal.github.io/LanderTek/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/LanderTek/master/changelog.md "Changelog"
[discu]: https://github.com/zer0Kerbal/LanderTek/discussions "Discussions"
[forum]: https://forum.kerbalspaceprogram.com/index.php?/topic/207923-*/ "LanderTek (LTEK) Forum Thread"
[issue]: https://github.com/zer0Kerbal/LanderTek/issues "Issues"
[markt]: https://zer0kerbal.github.io/LanderTek/Marketing "Marketing Slicks"
[notic]: https://zer0kerbal.github.io/LanderTek/Notices "Notices"
[parts]: https://zer0kerbal.github.io/LanderTek/PartsCatalog "Parts Catalog"
[pages]: https://zer0kerbal.github.io/LanderTek "GitHub Pages"

<!-- shields -->
[MOD:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/LanderTek/master/json/mod.json
[PAGES:shd]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!--- mod provenance -->
[MOD:0:dnload]: https://www.curseforge.com/kerbal/ksp-mods/LanderTek "CurseForge"
[MOD:0:source]: https://www.curseforge.com/kerbal/ksp-mods/LanderTek "CurseForge"
[MOD:0:thread]: https://forum.kerbalspaceprogram.com/index.php?/topic/126402-*/ "KSP Forum"

[MOD:1:dnload]: https://www.curseforge.com/kerbal/ksp-mods/LanderTek "CurseForge"
[MOD:1:source]: https://www.curseforge.com/kerbal/ksp-mods/LanderTek "CurseForge"
[MOD:1:thread]: https://forum.kerbalspaceprogram.com/index.php?/topic/126402-*/ "KSP Forum"

<!--- license provenance -->
[LIC:0:url]: https://opensource.org/licenses/MIT "Expat-MIT"
[LIC:0:log]: https://i.postimg.cc/bvjfsMP5/MIT-17x17.png "Expat-MIT"
[LIC:0:shd]: https://img.shields.io/badge/License-Expat/MIT-3DA639?labelColor=black&logoColor=3DA639&logo=OpenSourceInitiative&style=plastic "Expat-MIT"

[LIC:1:url]: https://www.wtfpl.net/about/ "WTFPL"
[LIC:1:log]: https://www.wtfpl.net/wp-content/uploads/2012/12/wtfpl-badge-1.png "WTFPL"
[LIC:1:shd]: https://img.shields.io/badge/License-WTFPL-white?style=plastic&labelColor=purple "WTFPL"

[LIC:url]: https://www.gnu.org/licenses/gpl-2.0-standalone.html "GPL-2.0"
[LIC:log]: https://i.postimg.cc/9FrwMgK6/GPL-17x17.png "GPL-2.0"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/LanderTek/master/json/license.json "GPL-2.0"

<!--- release links -->
[CURSFG:url]: https://www.curseforge.com/kerbal/ksp-mods/LanderTek "Curseforge"
[CURSFG:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[GITHUB:url]: https://github.com/zer0Kerbal/LanderTek/ "GitHub"
[GITHUB:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=github "GitHub"

[SPCDCK:url]: http://spacedock.info/mod/3020 "SpaceDock"
[SPCDCK:shd]: https://img.shields.io/badge/SpaceDock-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE5LjAuMCwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPgo8c3ZnIHZlcnNpb249IjEuMSIgaWQ9IkxheWVyXzEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4IgoJIHZpZXdCb3g9IjAgMCA1MDAgNTAwIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCA1MDAgNTAwOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+CjxzdHlsZSB0eXBlPSJ0ZXh0L2NzcyI+Cgkuc3Qwe2ZpbGw6IzFBMUExQTt9Cgkuc3Qxe2ZpbGw6IzA1Nzg5Mzt9Cgkuc3Qye2ZpbGw6IzA3QUNEMjt9Cjwvc3R5bGU+CjxwYXRoIGlkPSJYTUxJRF8xXyIgY2xhc3M9InN0MCIgZD0iTTQwMCwwLjZIMTAwYy01NSwwLTEwMCw0NS0xMDAsMTAwVjQwMGMwLDU1LDQ1LDEwMCwxMDAsMTAwaDMwMGM1NSwwLDEwMC00NSwxMDAtMTAwVjEwMC42CglDNTAwLDQ1LjYsNDU1LDAuNiw0MDAsMC42eiIvPgo8ZyBpZD0iWE1MSURfNl8iPgoJPGcgaWQ9IlhNTElEXzlfIj4KCQk8cGF0aCBpZD0iWE1MSURfMTdfIiBjbGFzcz0ic3QxIiBkPSJNMTgzLjMsMTY1LjljNi40LTMuNiwxNi45LTMuNiwyMy4zLDBMNDY3LjQsMzE0YzYuNCwzLjYsNi40LDkuNiwwLDEzLjJMMjA2LjYsNDc0LjQKCQkJYy02LjQsMy42LTE3LjcsNi42LTI1LDYuNmgtNDQuOGMtNy40LDAtOC4xLTMtMS43LTYuNmwyNjEtMTQ3LjJjNi40LTMuNiw2LjQtOS42LDAtMTMuMkwxNzEsMTg2Yy02LjQtMy42LTYuNC05LjYsMC0xMy4yCgkJCUwxODMuMywxNjUuOXoiLz4KCTwvZz4KCTxnIGlkPSJYTUxJRF84XyI+CgkJPHBhdGggaWQ9IlhNTElEXzE2XyIgY2xhc3M9InN0MiIgZD0iTTMxOC44LDE5Yy03LjQsMC0xOC42LDIuOC0yNSw2LjRMMzMsMTczLjRjLTYuNCwzLjYtNi40LDkuNSwwLDEzLjFsMjYwLjcsMTQ3LjEKCQkJYzYuNCwzLjYsMTYuOSwzLjYsMjMuMywwbDEyLjMtN2M2LjQtMy42LDYuNC05LjUsMC0xMy4ybC0yMjUuMS0xMjdjLTYuNC0zLjYtNi40LTkuNSwwLTEzLjJMMzY1LjYsMjUuNGM2LjQtMy42LDUuNi02LjQtMS43LTYuNAoJCQlIMzE4Ljh6Ii8+Cgk8L2c+CjwvZz4KPC9zdmc+Cg==  "SpaceDock"

[CKAN:url]: http://forum.kerbalspaceprogram.com/index.php?/topic/197082-*/ "CKAN"
[CKAN:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/LanderTek/master/json/ckan.json "CKAN"

<!-- Kerbal Space Program -->
[KSP:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[KSP:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/LanderTek/master/json/ksp.json&logo=data:image/webp;base64,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 "Kerbal Space Program"

<!-- links to add-ons/mods -->  
[BIO]: https://forum.kerbalspaceprogram.com/index.php?/topic/191426-*/ "Biomatic (BIO)"
[BOOM]: https://forum.kerbalspaceprogram.com/index.php?/topic/192938-*/ "Kaboom! (BOOM)"
[DPD]: https://forum.kerbalspaceprogram.com/index.php?/topic/192184-*/ "Docking Port Descriptions"
[FTF]: https://forum.kerbalspaceprogram.com/index.php?/topic/188841-*/ "Field Training Facility (FTF)"
[FTL]: https://forum.kerbalspaceprogram.com/index.php?/topic/188841-*/ "Field Training Lab (FTL)"
[GPO]: https://forum.kerbalspaceprogram.com/index.php?/topic/207732-*/ "GPO SpeedPump (GPO)"
[IPP]: https://forum.kerbalspaceprogram.com/index.php?/topic/208975-*/ "Inflatable PicoPort (IPP)"
[KAMP]: https://forum.kerbalspaceprogram.com/index.php?/topic/207263-*/ "Adjustable Mod Panel (KAMP)"
[NOTES]: https://forum.kerbalspaceprogram.com/index.php?/topic/207118-*/ "SimpleNotes! (NOTES)"
[ODFC]: https://forum.kerbalspaceprogram.com/index.php?/topic/187625-*/ "On Demand Fuel Cells (ODFC)"
[OSL]: https://forum.kerbalspaceprogram.com/index.php?/topic/209490-*/ "OScience Laboratories (OSL)"
[PIZZA]: https://forum.kerbalspaceprogram.com/index.php?/topic/209577-*/ "Papa Kerballini's Pizza (PIZZA)"
[PM]: https://forum.kerbalspaceprogram.com/index.php?/topic/207261-*/ "Precise Maneuver (PM)"
[SCON]: https://forum.kerbalspaceprogram.com/index.php?/topic/191424-*/ "SimpleConstruction! (SCON)"
[SIL]: https://forum.kerbalspaceprogram.com/index.php?/topic/193050-*/ "Stock Inline Lights (SIL)"
[SILP]: https://forum.kerbalspaceprogram.com/index.php?/topic/193051-*/ "Stock Inline Lights Patches (SILP)"
[SLOG]: https://forum.kerbalspaceprogram.com/index.php?/topic/191045-*/ "SimpleLogistics! (SLOG)"
[SOL]: https://forum.kerbalspaceprogram.com/index.php?/topic/192489-*/ "Solar Science (SOL)"
[SPP]: https://forum.kerbalspaceprogram.com/index.php?/topic/192187-*/ "Shielded PicoPort (SPP)"
[LET]: https://www.curseforge.com/kerbal/ksp-mods/lithobrakeexplorationtechnologies "Lithobrake Exploration Technologies (LET)"
[DROP]: https://forum.kerbalspaceprogram.com/index.php?/topic/209332-*/  "Drop Tank Wrapper (DROP)"
[PRC]: https://forum.kerbalspaceprogram.com/index.php?/topic/209350-*/ "Portable Science Container (PRC)"

[AAL]: https://forum.kerbalspaceprogram.com/index.php?/topic/209301-*/ "AxialAerospace Ltd. (AA/L)"
[CARGO]: https://forum.kerbalspaceprogram.com/index.php?/topic/210255-/ "Simple Cargo Solutions (CARGO)"
[DREAM]: https://forum.kerbalspaceprogram.com/index.php?/topic/207306-*/ "Dreamer (DREAM)"
[WHIM]: https://forum.kerbalspaceprogram.com/index.php?/topic/204900-*/ "WhimChaser (WHIM)"

[fs]: https://github.com/snjo/Firespitter/ "Firespitter Core"
[fsc]: https://github.com/snjo/Firespitter "Firespitter core"
[kis]: https://forum.kerbalspaceprogram.com/index.php?/topic/149848-*/ "Kerbal Inventory System"
[kjr]: https://forum.kerbalspaceprogram.com/index.php?/topic/184206-*/ "Kerbal Joint Reinforcement"
[mas]: https://forum.kerbalspaceprogram.com/index.php?/topic/160856-*/ "MOARdV's Avionics System"
[mm]: https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*/ "Module Manager"
[mml]: https://github.com/net-lisias-ksp/ModuleManager "Module Manager /L"
[rpm]: https://forum.kerbalspaceprogram.com/index.php?/topic/105821-*/ "Raster Prop Monitor"
[twk]: https://forum.kerbalspaceprogram.com/index.php?/topic/179030-*/ "TweakScale"

<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate?hosted_button_id=DC22YHMEJREKL/ "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/bePatron?u=23390503/ "Patreon"
[GSPONS:img]: https://img.shields.io/badge/Github%20-Sponsor-EA4AAA?style=for-the-badge&logo=githubsponsors/ "Github Sponsors"
[GSPONS:url]: https://github.com/sponsors/zer0Kerbal/ "Github Sponsors"
[BMCC:img]: https://img.shields.io/badge/Buy%20Me%20a%20-Snack!-FFDD00?style=for-the-badge&logo=buymeacoffee/ "Buy Me A Snack"
[BMCC:url]: https://buymeacoffee.com/zer0Kerbal/ "Buy Me A Snack"

<!-- Localization -->
[lreadme]: https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md "Localization Readme"
[qstart]: https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md "Quickstart"
[EN]: https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/EN.png "English"

[curseforge]: https://www.curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal
[steam]: https://steamcommunity.com/id/zeroKerbal/

[artwhaley]: https://forum.kerbalspaceprogram.com/index.php?/profile/118388-*/ "artwhaley"
[zer0Kerbal]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-*/ "zer0Kerbal"

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/LanderTek/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zer0Kerbal] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | Buy Me a Coffee" width="32px" src="https://www.buymeacoffee.com/assets/img/bmc-meta-new/new/favicon.ico" />][BMCC:url] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter]</br>

##### Release Schedule

1. GitHub, reaching first manual installers and users of KSP-AVC. Right now.
2. CurseForge. Right now.
3. SpaceDock (and CKAN users). Soon™ *(the button was pressed)*

<!-- footnotes -->
[^1]: this isn't a mod. ;P  
[^2]: ***may*** work on other versions (YMMV)  
[^3]: *Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date!*