# Changelog

| modName    | LanderTek (LTEK) by Axial Aerospace                              |
| ---------- | ---------------------------------------------------------------- |
| license    | GPL-2.0                                                          |
| author     | artwhaley and zer0Kerbal                                         |
| forum      | (https://forum.kerbalspaceprogram.com/index.php?/topic/207923-*) |
| github     | (https://github.com/zer0Kerbal/zer0Kerbal/LanderTek)             |
| curseforge | (https://www.curseforge.com/kerbal/ksp-mods/LanderTek)           |
| spacedock  | (https://spacedock.info/mod/3020)                                |
| ckan       | LanderTek                                                        |

## Version 0.5.99.0-adoption - `<Thank you artwhaley>` edition

* Released
  * 03 Feb 2023
  * for Kerbal Space Program 1.12.5
  * by [zer0Kerbal](https://github.com/zer0Kerbal)

This is part of a planned series of updates to this addon. Each update will update some of the parts and patches so that instead of one massive update I can update the addon in a more manageable way.

### Adoption by [zer0Kerbal](https://github.com/zer0Kerbal)

* Can now search for `ltek` in the editor search bar to find all LanterTek parts
* ~23 total parts
  * Only updated parts are included
  * 10 parts refreshed in this release which include:
    * 1.25m lower stage
    * 1.25m upper stage
    * 1.25m tank
    * 1.25m decoupler
    * battery 400
    * 2.5m carriage
    * 2.5m decoupler
    * Materials Bay
    * Mystery Goo™
    * Sample Container
  * 10 total parts now through Phase I
  * 13 parts remain to be refreshed/updated
* `ghostparts.cfg` has been temporarily added to attempt to prevent save game spoilage but will not be *haunting* for long

### Localization 0.5.99.0

* Localization directory and contents
  * Create
    * Localization/
      * <en-us.cfg>
      * [readme.md] v2.1.2.0
      * [quickstart.md] v1.0.1.1
* closes #10 - Localization - English <en-us.cfg>
* updates #9 - Localization - Master

### Archival Releases 0.5.99.0

* Recreate archival releases
  * 0.1.0.0-release
  * 0.3.0.0-release
  * 0.5.0.0-release
* closes #28 - Recreate previous
* closes #29 - 0.1.0.0-release
* closes #30 - 0.3.0.0-release
* closes #31 - 0.5.0.0-release

### Documentation 0.5.99.0

* Create
  * readme
  * deploy to:
    * CurseForge Description page 🤬
    * Forum Original Post 🐰
    * SpaceDock Information page 🌮
  * release notes
  * [changelog.md]
  * update /docs/
* closes #50 - Update changelog
* closes #49 - Update release.md
* closes #48 - Update readme.md
* closes #26 - # folder restructure

### GitHub Pages 0.5.99.0

* Create
  * docs/
    * [`_config.yml`]
    * [404.md] v1.0.3.2
    * [Assembly.md] v1.0.0.0
    * [Attribution.md] v1.0.7.1
    * [Disclaimer.md] v1.0.7.1
    * [LegalMumboJumbo.md] v1.0.5.1
    * [Localizations.md] v1.1.7.0
    * [ManualInstallation.md] v1.1.8.0
    * [Marketing.md] v1.0.1.0
    * [Notices.md] v1.0.1.0
    * [PartsCatalog.md] v1.1.4.1
    * [Why.md] v1.1.0.0
* closes #7 - Needs a wiki

### Legal Mumbo Jumbo 0.5.99.0

* Create
  * license check
  * offline documentation
  * _Legal
    * screenshots and pdfs
    * adoptionLetters
    * communications concerning
  * _Links/
    * link(s) saved
  * docs/LegalMumboJumbo
    * [License.md]
    * FORUM-##.png's
      * public documentation
  * GitHub: :octocat:
    * LICENSE
    * [license].txt
  * CurseForge
  * SpaceDock
  * CKAN

### Part Asset Updates 0.5.99.0

* create Assets/ folder
* convert from mesh to MODEL
* rename
  * models to unique names
  * textures to unique names
* update
  * model pointers (.png et al to .dds)
  * model texture pointers to new names
* relocate assets to Assets/
* eliminate
  * duplicate textures
  * duplicate models
* relocate part.cfg to Parts/
  * landertekspec.tga --> .dds
  * landertekNRM.tga --> .dds
  * cockpittext.mbm 369kb --> .dds 342kb
  * landerlower.mbm 3.1mb --> .dds 1.4mb
  * landertekNRM.mbm 8.2mb --> .dds 2.7mb
  * landertekspec.mbm 8.2mb--> .dds 2.7mb
* closes #70 - Part Asset Updates

### Parts 0.5.99.0

* Update

### Config 0.5.99.0

* Add localized tags to parts
* Create
  * <ghostparts.cfg> - will not be haunting for long
  * LanderTek.cfg v1.0.0.0
    * adds localized tags to parts

### License 0.5.99.0

* Update
  * Updated License: GPL-2.0
    * was: WTPFL

### Social Media Presence 0.5.99.0

* Create Social Media Presence
  * Kerbal Space Program forum
    * Create new thread/post in "Add-on Development"
    * title: [1.12.x] LanderTek (LTEK) - <0.5.99.0-adoption> - `<Thank you artwhaley>` edition [01 Jan 2022]
    * create release post in new thread/post
      * content (readme.htm)
    * original mod's thread/post
      * post link to new thread/post
  * CurseForge
  * Twitter
  * SpaceDock
  * Reddit post
  * Patreon post

### Marketing 0.5.99.0

* Create
  * HeroLogo.png

### Status 0.5.99.0

* Issues

* Issues
  * closes #5 - LanderTek (LTEK) 0.5.99.0-adoption `<Thank You artwhaley>`
  * closes #4 - 0.5.99.0 Create Documentation
  * closes #3 - 0.5.99.0 Verify Legal Mumbo Jumbo
  * closes #1 - 0.5.99.0 Create Social Media
  * closes #6 - Cargo

---

## Version 0.5.0.0-release `<Archival>`

* Released on 2015-11-21
* Kerbal Space Program 1.0.5

* last release by ArtWhaley
* *No changelog provided*
* [Download](https://web.archive.org/web/20151124102839/https://kerbalstuff.com/mod/469/LanderTek%20-%20modular%20lander%20parts...%20for%20landing./download/0.5)

### Status

* Issues
  * closes #28 - Recreate previous
  * closes #31 - 0.5.0.0-release

---

## Version 0.3.0.0-release `<Archival>`

* Released on 2015-01-10
* Kerbal Space Program 0.90

* New Paint Scheme
* Several new Parts.
* [Download](https://web.archive.org/web/20151124102839/https://kerbalstuff.com/mod/469/LanderTek%20-%20modular%20lander%20parts...%20for%20landing./download/3)

### Status 0.3.0.0

* Issues
  * updates #28 - Recreate previous
  * closes #30 - 0.3.0.0-release

---

## Version 0.1.0.0-release `<Archival>`

* Released on 2014-12-31
* Kerbal Space Program 0.90

* *No changelog provided*
* [Download](https://web.archive.org/web/20151124102839/https://kerbalstuff.com/mod/469/LanderTek%20-%20modular%20lander%20parts...%20for%20landing./download/0.1)

### Status 0.1.0.0

* Issues
  * updates #28 - Recreate previous
  * closes #29 - 0.1.0.0-release

---
